eval('/*\r\n * Copyright (c) 2013 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\n/**\r\n * The bootstrapping module for brackets. This module sets up the require\r\n * configuration and loads the brackets module.\r\n */\r\nrequire.config({\r\n    paths: {\r\n        "text"              : "thirdparty/text/text",\r\n        "i18n"              : "thirdparty/i18n/i18n",\r\n\r\n        // The file system implementation. Change this value to use different\r\n        // implementations (e.g. cloud-based storage).\r\n        "fileSystemImpl"    : "filesystem/impls/appshell/AppshellFileSystem",\r\n        "preact-compat"     : "thirdparty/preact-compat/preact-compat.min",\r\n        "preact"            : "thirdparty/preact/preact"\r\n    },\r\n    map: {\r\n        "*": {\r\n            "thirdparty/CodeMirror2": "thirdparty/CodeMirror",\r\n            "thirdparty/preact"     : "preact-compat"\r\n        }\r\n    }\r\n});\r\n\r\nif (window.location.search.indexOf("testEnvironment") > -1) {\r\n    require.config({\r\n        paths: {\r\n            "preferences/PreferencesImpl": "../test/TestPreferencesImpl"\r\n        },\r\n        locale: "en" // force English (US)\r\n    });\r\n} else {\r\n    /**\r\n     * hack for r.js optimization, move locale to another config call\r\n     *\r\n     * Use custom brackets property until CEF sets the correct navigator.language\r\n     * NOTE: When we change to navigator.language here, we also should change to\r\n     * navigator.language in ExtensionLoader (when making require contexts for each\r\n     * extension).\r\n     */\r\n    require.config({\r\n        locale: window.localStorage.getItem("locale") || (typeof (brackets) !== "undefined" ? brackets.app.language : window.navigator.language)\r\n    });\r\n}\r\n\r\ndefine(\'main\',[\'require\'],function (require) {\r\n    "use strict";\r\n\r\n    // Load compatibility shims--these need to load early, be careful moving this\r\n    require(["utils/Compatibility"], function () {\r\n        // Load the brackets module. This is a self-running module that loads and runs the entire application.\r\n        require(["brackets"]);\r\n    });\r\n});\r\n\n//# sourceURL=/main.js'),eval('/*\r\n * Copyright (c) 2014 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\n/**\r\n * Compatibility shims for running Brackets in various environments, browsers.\r\n */\r\ndefine(\'utils/Compatibility\',[],function () {\r\n    "use strict";\r\n\r\n    // [IE10] String.prototype missing trimRight() and trimLeft()\r\n    if (!String.prototype.trimRight) {\r\n        String.prototype.trimRight = function () { return this.replace(/\\s+$/, ""); };\r\n    }\r\n    if (!String.prototype.trimLeft) {\r\n        String.prototype.trimLeft = function () { return this.replace(/^\\s+/, ""); };\r\n    }\r\n\r\n    // Feature detection for Error.stack. Not all browsers expose it\r\n    // and Brackets assumes it will be a non-null string.\r\n    if (typeof (new Error()).stack === "undefined") {\r\n        Error.prototype.stack = "";\r\n    }\r\n\r\n});\r\n\n//# sourceURL=/utils/Compatibility.js'),eval("/* ============================================================\r\n * bootstrap-dropdown.js v2.3.1\r\n * http://twitter.github.com/bootstrap/javascript.html#dropdowns\r\n * ============================================================\r\n * Copyright 2012 Twitter, Inc.\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n * http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n * ============================================================ */\r\n\r\n\r\n!function ($) {\r\n\r\n  \"use strict\"; // jshint ;_;\r\n\r\n\r\n /* DROPDOWN CLASS DEFINITION\r\n  * ========================= */\r\n\r\n  var toggle = '[data-toggle=dropdown]'\r\n    , Dropdown = function (element) {\r\n        var $el = $(element).on('click.dropdown.data-api', this.toggle)\r\n        $('html').on('click.dropdown.data-api', function () {\r\n          $el.parent().removeClass('open')\r\n        })\r\n      }\r\n\r\n  Dropdown.prototype = {\r\n\r\n    constructor: Dropdown\r\n\r\n  , toggle: function (e) {\r\n      var $this = $(this)\r\n        , $parent\r\n        , isActive\r\n\r\n      if ($this.is('.disabled, :disabled')) return\r\n\r\n      $parent = getParent($this)\r\n\r\n      isActive = $parent.hasClass('open')\r\n\r\n      clearMenus()\r\n\r\n      if (!isActive) {\r\n        $parent.toggleClass('open')\r\n      }\r\n\r\n      $this.focus()\r\n\r\n      return false\r\n    }\r\n\r\n  , keydown: function (e) {\r\n      var $this\r\n        , $items\r\n        , $active\r\n        , $parent\r\n        , isActive\r\n        , index\r\n\r\n      if (!/(38|40|27)/.test(e.keyCode)) return\r\n\r\n      $this = $(this)\r\n\r\n      e.preventDefault()\r\n      e.stopPropagation()\r\n\r\n      if ($this.is('.disabled, :disabled')) return\r\n\r\n      $parent = getParent($this)\r\n\r\n      isActive = $parent.hasClass('open')\r\n\r\n      if (!isActive || (isActive && e.keyCode == 27)) {\r\n        if (e.which == 27) $parent.find(toggle).focus()\r\n        return $this.click()\r\n      }\r\n\r\n      $items = $('[role=menu] li:not(.divider):visible a', $parent)\r\n\r\n      if (!$items.length) return\r\n\r\n      index = $items.index($items.filter(':focus'))\r\n\r\n      if (e.keyCode == 38 && index > 0) index--                                        // up\r\n      if (e.keyCode == 40 && index < $items.length - 1) index++                        // down\r\n      if (!~index) index = 0\r\n\r\n      $items\r\n        .eq(index)\r\n        .focus()\r\n    }\r\n\r\n  }\r\n\r\n  function clearMenus() {\r\n    $(toggle).each(function () {\r\n      getParent($(this)).removeClass('open')\r\n    })\r\n  }\r\n\r\n  function getParent($this) {\r\n    var selector = $this.attr('data-target')\r\n      , $parent\r\n\r\n    if (!selector) {\r\n      selector = $this.attr('href')\r\n      selector = selector && /#/.test(selector) && selector.replace(/.*(?=#[^\\s]*$)/, '') //strip for ie7\r\n    }\r\n\r\n    $parent = selector && $(selector)\r\n\r\n    if (!$parent || !$parent.length) $parent = $this.parent()\r\n\r\n    return $parent\r\n  }\r\n\r\n\r\n  /* DROPDOWN PLUGIN DEFINITION\r\n   * ========================== */\r\n\r\n  var old = $.fn.dropdown\r\n\r\n  $.fn.dropdown = function (option) {\r\n    return this.each(function () {\r\n      var $this = $(this)\r\n        , data = $this.data('dropdown')\r\n      if (!data) $this.data('dropdown', (data = new Dropdown(this)))\r\n      if (typeof option == 'string') data[option].call($this)\r\n    })\r\n  }\r\n\r\n  $.fn.dropdown.Constructor = Dropdown\r\n\r\n\r\n /* DROPDOWN NO CONFLICT\r\n  * ==================== */\r\n\r\n  $.fn.dropdown.noConflict = function () {\r\n    $.fn.dropdown = old\r\n    return this\r\n  }\r\n\r\n\r\n  /* APPLY TO STANDARD DROPDOWN ELEMENTS\r\n   * =================================== */\r\n\r\n  $(document)\r\n    .on('click.dropdown.data-api', clearMenus)\r\n    .on('click.dropdown.data-api', '.dropdown form', function (e) { e.stopPropagation() })\r\n    .on('click.dropdown-menu', function (e) { e.stopPropagation() })\r\n    .on('click.dropdown.data-api'  , toggle, Dropdown.prototype.toggle)\r\n    .on('keydown.dropdown.data-api', toggle + ', [role=menu]' , Dropdown.prototype.keydown)\r\n\r\n}(window.jQuery);\r\n\n//# sourceURL=/widgets/bootstrap-dropdown.js"),define("widgets/bootstrap-dropdown",function(){}),eval("/* =========================================================\r\n * bootstrap-modal.js v2.3.1\r\n * http://twitter.github.com/bootstrap/javascript.html#modals\r\n * =========================================================\r\n * Copyright 2012 Twitter, Inc.\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n * http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n * ========================================================= */\r\n\r\n\r\n!function ($) {\r\n\r\n  \"use strict\"; // jshint ;_;\r\n\r\n\r\n /* MODAL CLASS DEFINITION\r\n  * ====================== */\r\n\r\n  var Modal = function (element, options) {\r\n    this.options = options\r\n    this.$element = $(element)\r\n      .delegate('[data-dismiss=\"modal\"]', 'click.dismiss.modal', $.proxy(this.hide, this))\r\n    this.options.remote && this.$element.find('.modal-body').load(this.options.remote)\r\n  }\r\n\r\n  Modal.prototype = {\r\n\r\n      constructor: Modal\r\n\r\n    , toggle: function () {\r\n        return this[!this.isShown ? 'show' : 'hide']()\r\n      }\r\n\r\n    , show: function () {\r\n        var that = this\r\n          , e = $.Event('show')\r\n\r\n        this.$element.trigger(e)\r\n\r\n        if (this.isShown || e.isDefaultPrevented()) return\r\n\r\n        this.isShown = true\r\n\r\n        this.escape()\r\n\r\n        this.backdrop(function () {\r\n          var transition = $.support.transition && that.$element.hasClass('fade')\r\n\r\n          if (!that.$element.parent().length) {\r\n            that.$element.appendTo(this.options.selector) //don't move modals dom position\r\n          }\r\n\r\n          that.$element.show()\r\n\r\n          if (transition) {\r\n            that.$element[0].offsetWidth // force reflow\r\n          }\r\n\r\n          that.$element\r\n            .addClass('in')\r\n            .attr('aria-hidden', false)\r\n\r\n          that.enforceFocus()\r\n\r\n          transition ?\r\n            that.$element.one($.support.transition.end, function () { that.$element.focus().trigger('shown') }) :\r\n            that.$element.focus().trigger('shown')\r\n\r\n        })\r\n      }\r\n\r\n    , hide: function (e) {\r\n        e && e.preventDefault()\r\n\r\n        var that = this\r\n\r\n        e = $.Event('hide')\r\n\r\n        this.$element.trigger(e)\r\n\r\n        if (!this.isShown || e.isDefaultPrevented()) return\r\n\r\n        this.isShown = false\r\n\r\n        this.escape()\r\n\r\n        $(document).off('focusin.modal')\r\n\r\n        this.$element\r\n          .removeClass('in')\r\n          .attr('aria-hidden', true)\r\n\r\n        $.support.transition && this.$element.hasClass('fade') ?\r\n          this.hideWithTransition() :\r\n          this.hideModal()\r\n      }\r\n\r\n    , enforceFocus: function () {\r\n        var that = this\r\n        $(document).on('focusin.modal', function (e) {\r\n          if (that.$element[0] !== e.target && !that.$element.has(e.target).length) {\r\n            that.$element.focus()\r\n          }\r\n        })\r\n      }\r\n\r\n    , escape: function () {\r\n        var that = this\r\n        if (this.isShown && this.options.keyboard) {\r\n          this.$element.on('keyup.dismiss.modal', function ( e ) {\r\n            e.which == 27 && that.hide()\r\n          })\r\n        } else if (!this.isShown) {\r\n          this.$element.off('keyup.dismiss.modal')\r\n        }\r\n      }\r\n\r\n    , hideWithTransition: function () {\r\n        var that = this\r\n          , timeout = setTimeout(function () {\r\n              that.$element.off($.support.transition.end)\r\n              that.hideModal()\r\n            }, 500)\r\n\r\n        this.$element.one($.support.transition.end, function () {\r\n          clearTimeout(timeout)\r\n          that.hideModal()\r\n        })\r\n      }\r\n\r\n    , hideModal: function () {\r\n        var that = this\r\n        this.$element.hide()\r\n        this.backdrop(function () {\r\n          that.removeBackdrop()\r\n          that.$element.trigger('hidden')\r\n        })\r\n      }\r\n\r\n    , removeBackdrop: function () {\r\n        this.$backdrop && this.$backdrop.remove()\r\n        this.$backdrop = null\r\n      }\r\n\r\n    , backdrop: function (callback) {\r\n        var that = this\r\n          , animate = this.$element.hasClass('fade') ? 'fade' : ''\r\n\r\n        if (this.isShown && this.options.backdrop) {\r\n          var doAnimate = $.support.transition && animate\r\n\r\n          this.$backdrop = $('<div class=\"modal-backdrop ' + animate + '\" />')\r\n            .appendTo(this.options.selector)\r\n\r\n          this.$backdrop.click(\r\n            this.options.backdrop == 'static' ?\r\n              $.proxy(this.$element[0].focus, this.$element[0])\r\n            : $.proxy(this.hide, this)\r\n          )\r\n\r\n          if (doAnimate) this.$backdrop[0].offsetWidth // force reflow\r\n\r\n          this.$backdrop.addClass('in')\r\n\r\n          if (!callback) return\r\n\r\n          doAnimate ?\r\n            this.$backdrop.one($.support.transition.end, callback) :\r\n            callback()\r\n\r\n        } else if (!this.isShown && this.$backdrop) {\r\n          this.$backdrop.removeClass('in')\r\n\r\n          $.support.transition && this.$element.hasClass('fade')?\r\n            this.$backdrop.one($.support.transition.end, callback) :\r\n            callback()\r\n\r\n        } else if (callback) {\r\n          callback()\r\n        }\r\n      }\r\n  }\r\n\r\n\r\n /* MODAL PLUGIN DEFINITION\r\n  * ======================= */\r\n\r\n  var old = $.fn.modal\r\n\r\n  $.fn.modal = function (option) {\r\n    return this.each(function () {\r\n      var $this = $(this)\r\n        , data = $this.data('modal')\r\n        , options = $.extend({}, $.fn.modal.defaults, $this.data(), typeof option == 'object' && option)\r\n      if (!data) $this.data('modal', (data = new Modal(this, options)))\r\n      if (typeof option == 'string') data[option]()\r\n      else if (options.show) data.show()\r\n    })\r\n  }\r\n\r\n  $.fn.modal.defaults = {\r\n      backdrop: true\r\n    , keyboard: true\r\n    , show: true\r\n    , selector: \"body\"\r\n  }\r\n\r\n  $.fn.modal.Constructor = Modal\r\n\r\n\r\n /* MODAL NO CONFLICT\r\n  * ================= */\r\n\r\n  $.fn.modal.noConflict = function () {\r\n    $.fn.modal = old\r\n    return this\r\n  }\r\n\r\n\r\n /* MODAL DATA-API\r\n  * ============== */\r\n\r\n  $(document).on('click.modal.data-api', '[data-toggle=\"modal\"]', function (e) {\r\n    var $this = $(this)\r\n      , href = $this.attr('href')\r\n      , $target = $($this.attr('data-target') || (href && href.replace(/.*(?=#[^\\s]+$)/, ''))) //strip for ie7\r\n      , option = $target.data('modal') ? 'toggle' : $.extend({ remote:!/#/.test(href) && href }, $target.data(), $this.data())\r\n\r\n    e.preventDefault()\r\n\r\n    $target\r\n      .modal(option)\r\n      .one('hide', function () {\r\n        $this.focus()\r\n      })\r\n  })\r\n\r\n}(window.jQuery);\r\n\n//# sourceURL=/widgets/bootstrap-modal.js"),define("widgets/bootstrap-modal",function(){}),eval("/* ==========================================================\r\n * bootstrap-twipsy.js v1.4.0\r\n * http://twitter.github.com/bootstrap/javascript.html#twipsy\r\n * Adapted from the original jQuery.tipsy by Jason Frame\r\n * Adjusted for Brackets\r\n * ==========================================================\r\n * Copyright 2011 Twitter, Inc.\r\n *\r\n * Licensed under the Apache License, Version 2.0 (the \"License\");\r\n * you may not use this file except in compliance with the License.\r\n * You may obtain a copy of the License at\r\n *\r\n * http://www.apache.org/licenses/LICENSE-2.0\r\n *\r\n * Unless required by applicable law or agreed to in writing, software\r\n * distributed under the License is distributed on an \"AS IS\" BASIS,\r\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\r\n * See the License for the specific language governing permissions and\r\n * limitations under the License.\r\n * ========================================================== */\r\n\r\n\r\n!function( $ ) {\r\n\r\n  \"use strict\"\r\n\r\n  /***** [changed for Brackets] *****/\r\n  // Undefined until the focus state changed once\r\n  var _windowHasFocus;\r\n\r\n  $(window)\r\n    .focus(function _onWindowGainedFocus() {\r\n      _windowHasFocus = true;\r\n    })\r\n    .blur(function _onWindowLostFocus() {\r\n      _windowHasFocus = false;\r\n    });\r\n  /***** [/changed for Brackets] *****/\r\n\r\n /* CSS TRANSITION SUPPORT (https://gist.github.com/373874)\r\n  * ======================================================= */\r\n\r\n  var transitionEnd\r\n\r\n  $(document).ready(function () {\r\n\r\n    $.support.transition = (function () {\r\n\r\n      var transitionEnd = (function () {\r\n\r\n        var el = document.createElement('bootstrap')\r\n          , transEndEventNames = {\r\n               'WebkitTransition' : 'webkitTransitionEnd'\r\n            ,  'MozTransition'    : 'transitionend'\r\n            ,  'OTransition'      : 'oTransitionEnd'\r\n            ,  'msTransition'     : 'MSTransitionEnd'\r\n            ,  'transition'       : 'transitionend'\r\n            }\r\n          , name\r\n\r\n        for (name in transEndEventNames){\r\n          if (el.style[name] !== undefined) {\r\n            return transEndEventNames[name]\r\n          }\r\n        }\r\n\r\n      }())\r\n\r\n      return transitionEnd && {\r\n        end: transitionEnd\r\n      }\r\n\r\n    })()\r\n\r\n    // set CSS transition event type\r\n    if ( $.support.transition ) {\r\n      transitionEnd = $.support.transition.end\r\n    }\r\n\r\n  })\r\n\r\n\r\n /* TWIPSY PUBLIC CLASS DEFINITION\r\n  * ============================== */\r\n\r\n  var Twipsy = function ( element, options ) {\r\n    this.$element = $(element)\r\n    this.options = options\r\n    this.enabled = true\r\n    /***** [changed for Brackets] *****/\r\n    this.autoHideTimeout = null;\r\n    /***** [/changed for Brackets] *****/\r\n    this.fixTitle()\r\n  }\r\n\r\n  Twipsy.prototype = {\r\n\r\n    show: function() {\r\n      /***** [changed for Brackets: moved some variables to updatePosition()] *****/\r\n      var $tip\r\n        , that = this;\r\n      /***** [/changed for Brackets] *****/\r\n\r\n      if (this.hasContent() && this.enabled) {\r\n        $tip = this.tip()\r\n        this.setContent()\r\n\r\n        if (this.options.animate) {\r\n          $tip.addClass('fade')\r\n        }\r\n\r\n        $tip\r\n          .remove()\r\n          .css({ top: 0, left: 0, display: 'block' })\r\n          .prependTo(document.body)\r\n\r\n/***** [changed for Brackets] *****/\r\n        this.updatePosition();\r\n\r\n        $(window).off(\"resize\", this.resizeHandler);\r\n        this.resizeHandler = function(e) {\r\n          that.updatePosition();\r\n        };\r\n        $(window).on(\"resize\", this.resizeHandler);\r\n\r\n        if (this.options.autoHideDelay) {\r\n          var startAutoHide = function () {\r\n            window.clearTimeout(that.autoHideTimeout);\r\n            that.autoHideTimeout = window.setTimeout(function () {\r\n              that.hide();\r\n            }, that.options.autoHideDelay);\r\n          }\r\n          if (_windowHasFocus) {\r\n            startAutoHide();\r\n          } else {\r\n            $(window).one(\"focus\", startAutoHide);\r\n          }\r\n        }\r\n\r\n        $tip.addClass('in');\r\n      }\r\n    }\r\n\r\n  , updatePosition: function () {\r\n      var pos\r\n        , actualWidth\r\n        , actualHeight\r\n        , paddingLeft\r\n        , paddingRight\r\n        , surplusRight\r\n        , shiftArrow\r\n        , placement\r\n        , $tip\r\n        , $arrow\r\n        , tp\r\n        , that = this\r\n\r\n      $tip = this.tip()\r\n\r\n      pos = $.extend({}, this.$element.offset(), {\r\n        width: this.$element[0].offsetWidth\r\n      , height: this.$element[0].offsetHeight\r\n      })\r\n\r\n      paddingLeft  = parseInt(this.$element.css(\"padding-left\"),  10);\r\n      paddingRight = parseInt(this.$element.css(\"padding-right\"), 10);\r\n\r\n      pos.left += paddingLeft;\r\n      pos.width -= (paddingLeft + paddingRight);\r\n\r\n      actualWidth = $tip[0].offsetWidth\r\n      actualHeight = $tip[0].offsetHeight\r\n\r\n      placement = maybeCall(this.options.placement, this, [ $tip[0], this.$element[0] ])\r\n      // Add the placement class so the arrow's margin can be determined\r\n      $tip.addClass(placement)\r\n\r\n      switch (placement) {\r\n        case 'below':\r\n          tp = {top: pos.top + pos.height + this.options.offset, left: pos.left + pos.width / 2 - actualWidth / 2}\r\n          break\r\n        case 'above':\r\n          tp = {top: pos.top - actualHeight - this.options.offset, left: pos.left + pos.width / 2 - actualWidth / 2}\r\n          break\r\n        case 'left':\r\n          /***** [changed for Brackets] *****/\r\n          tp = {top: pos.top + pos.height + 20 - actualHeight, left: pos.left - actualWidth - this.options.offset}\r\n          break\r\n        case 'right':\r\n          /***** [changed for Brackets] *****/\r\n          tp = {top: pos.top + pos.height + 20 - actualHeight, left: pos.left + pos.width + this.options.offset}\r\n          break\r\n      }\r\n\r\n      shiftArrow = 0;\r\n\r\n      surplusRight = (tp.left + actualWidth - $(document.body).width());\r\n      if (surplusRight > 0) {\r\n        shiftArrow = surplusRight;\r\n        tp.left -= surplusRight;\r\n      } else if (tp.left < 0) {\r\n        shiftArrow = tp.left;\r\n        tp.left = 0;\r\n      }\r\n\r\n      if (surplusRight > 0) {\r\n        $arrow = $tip.find(\".tooltip-arrow\");\r\n        if (! this.defaultMargin) {\r\n          this.defaultMargin = parseInt($arrow.css(\"margin-left\"), 10);\r\n        }\r\n        $arrow.css(\"margin-left\", this.defaultMargin + shiftArrow);\r\n      }\r\n\r\n      $tip.css(tp);\r\n    }\r\n/***** [/changed for Brackets] *****/\r\n\r\n  , setContent: function () {\r\n      var $tip = this.tip()\r\n      $tip.find('.tooltip-inner')[this.options.html ? 'html' : 'text'](this.getTitle())\r\n      $tip[0].className = 'tooltip'\r\n    }\r\n\r\n  , hide: function() {\r\n      var that = this\r\n        , $tip = this.tip()\r\n\r\n      $tip.removeClass('in')\r\n\r\n      function removeElement () {\r\n        $tip.remove()\r\n      }\r\n\r\n      $.support.transition && this.$tip.hasClass('fade') ?\r\n        $tip.bind(transitionEnd, removeElement) :\r\n        removeElement()\r\n\r\n      /***** [changed for Brackets] *****/\r\n      window.clearTimeout(this.autoHideTimeout);\r\n      $(window).off(\"resize\", this.resizeHandler)\r\n      /***** [/changed for Brackets] *****/\r\n    }\r\n\r\n  , fixTitle: function() {\r\n      var $e = this.$element\r\n      if ($e.attr('title') || typeof($e.attr('data-original-title')) != 'string') {\r\n        $e.attr('data-original-title', $e.attr('title') || '').removeAttr('title')\r\n      }\r\n    }\r\n\r\n  , hasContent: function () {\r\n      return this.getTitle()\r\n    }\r\n\r\n  , getTitle: function() {\r\n      var title\r\n        , $e = this.$element\r\n        , o = this.options\r\n\r\n        this.fixTitle()\r\n\r\n        if (typeof o.title == 'string') {\r\n          title = $e.attr(o.title == 'title' ? 'data-original-title' : o.title)\r\n        } else if (typeof o.title == 'function') {\r\n          title = o.title.call($e[0])\r\n        }\r\n\r\n        title = ('' + title).replace(/(^\\s*|\\s*$)/, \"\")\r\n\r\n        return title || o.fallback\r\n    }\r\n\r\n  , tip: function() {\r\n      return this.$tip = this.$tip || $('<div class=\"tooltip\" />').html(this.options.template)\r\n    }\r\n\r\n  , validate: function() {\r\n      if (!this.$element[0].parentNode) {\r\n        this.hide()\r\n        this.$element = null\r\n        this.options = null\r\n      }\r\n    }\r\n\r\n  , enable: function() {\r\n      this.enabled = true\r\n    }\r\n\r\n  , disable: function() {\r\n      this.enabled = false\r\n    }\r\n\r\n  , toggleEnabled: function() {\r\n      this.enabled = !this.enabled\r\n    }\r\n\r\n  , toggle: function () {\r\n      this[this.tip().hasClass('in') ? 'hide' : 'show']()\r\n    }\r\n\r\n  }\r\n\r\n\r\n /* TWIPSY PRIVATE METHODS\r\n  * ====================== */\r\n\r\n   function maybeCall ( thing, ctx, args ) {\r\n     return typeof thing == 'function' ? thing.apply(ctx, args) : thing\r\n   }\r\n\r\n /* TWIPSY PLUGIN DEFINITION\r\n  * ======================== */\r\n\r\n  $.fn.twipsy = function (options) {\r\n    $.fn.twipsy.initWith.call(this, options, Twipsy, 'twipsy')\r\n    return this\r\n  }\r\n\r\n  $.fn.twipsy.initWith = function (options, Constructor, name) {\r\n    var twipsy\r\n      , binder\r\n      , eventIn\r\n      , eventOut\r\n\r\n    if (options === true) {\r\n      return this.data(name)\r\n    } else if (typeof options == 'string') {\r\n      twipsy = this.data(name)\r\n      if (twipsy) {\r\n        twipsy[options]()\r\n      }\r\n      return this\r\n    }\r\n\r\n    options = $.extend({}, $.fn[name].defaults, options)\r\n\r\n    function get(ele) {\r\n      var twipsy = $.data(ele, name)\r\n\r\n      if (!twipsy) {\r\n        twipsy = new Constructor(ele, $.fn.twipsy.elementOptions(ele, options))\r\n        $.data(ele, name, twipsy)\r\n      }\r\n\r\n      return twipsy\r\n    }\r\n\r\n    function enter() {\r\n      var twipsy = get(this)\r\n      twipsy.hoverState = 'in'\r\n\r\n      if (options.delayIn == 0) {\r\n        twipsy.show()\r\n      } else {\r\n        twipsy.fixTitle()\r\n        setTimeout(function() {\r\n          if (twipsy.hoverState == 'in') {\r\n            twipsy.show()\r\n          }\r\n        }, options.delayIn)\r\n      }\r\n    }\r\n\r\n    function leave() {\r\n      var twipsy = get(this)\r\n      twipsy.hoverState = 'out'\r\n      if (options.delayOut == 0) {\r\n        twipsy.hide()\r\n      } else {\r\n        setTimeout(function() {\r\n          if (twipsy.hoverState == 'out') {\r\n            twipsy.hide()\r\n          }\r\n        }, options.delayOut)\r\n      }\r\n    }\r\n\r\n    if (!options.live) {\r\n      this.each(function() {\r\n        get(this)\r\n      })\r\n    }\r\n\r\n    if (options.trigger != 'manual') {\r\n      binder   = options.live ? 'live' : 'bind'\r\n      eventIn  = options.trigger == 'hover' ? 'mouseenter' : 'focus'\r\n      eventOut = options.trigger == 'hover' ? 'mouseleave' : 'blur'\r\n      this[binder](eventIn, enter)[binder](eventOut, leave)\r\n    }\r\n\r\n    return this\r\n  }\r\n\r\n  $.fn.twipsy.Twipsy = Twipsy\r\n\r\n  $.fn.twipsy.defaults = {\r\n    animate: true\r\n  , delayIn: 0\r\n  , delayOut: 0\r\n  , fallback: ''\r\n  , placement: 'above'\r\n  , html: false\r\n  , live: false\r\n  , offset: 0\r\n  , title: 'title'\r\n  , trigger: 'hover'\r\n  , template: '<div class=\"tooltip-arrow\"></div><div class=\"tooltip-inner\"></div>'\r\n  }\r\n\r\n  $.fn.twipsy.rejectAttrOptions = [ 'title' ]\r\n\r\n  $.fn.twipsy.elementOptions = function(ele, options) {\r\n    var data = $(ele).data()\r\n      , rejects = $.fn.twipsy.rejectAttrOptions\r\n      , i = rejects.length\r\n\r\n    while (i--) {\r\n      delete data[rejects[i]]\r\n    }\r\n\r\n    return $.extend({}, options, data)\r\n  }\r\n\r\n}( window.jQuery || window.ender );\r\n\n//# sourceURL=/widgets/bootstrap-twipsy-mod.js"),define("widgets/bootstrap-twipsy-mod",function(){}),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n// This is CodeMirror (http://codemirror.net), a code editor\n// implemented in JavaScript on top of the browser\'s DOM.\n//\n// You can find some technical background for some of the code below\n// at http://marijnhaverbeke.nl/blog/#cm-internals .\n\n(function (global, factory) {\n	typeof exports === \'object\' && typeof module !== \'undefined\' ? module.exports = factory() :\n	typeof define === \'function\' && define.amd ? define(\'thirdparty/CodeMirror/lib/codemirror\',factory) :\n	(global.CodeMirror = factory());\n}(this, (function () { \'use strict\';\n\n// Kludges for bugs and behavior differences that can\'t be feature\n// detected are enabled based on userAgent etc sniffing.\nvar userAgent = navigator.userAgent;\nvar platform = navigator.platform;\n\nvar gecko = /gecko\\/\\d/i.test(userAgent);\nvar ie_upto10 = /MSIE \\d/.test(userAgent);\nvar ie_11up = /Trident\\/(?:[7-9]|\\d{2,})\\..*rv:(\\d+)/.exec(userAgent);\nvar edge = /Edge\\/(\\d+)/.exec(userAgent);\nvar ie = ie_upto10 || ie_11up || edge;\nvar ie_version = ie && (ie_upto10 ? document.documentMode || 6 : +(edge || ie_11up)[1]);\nvar webkit = !edge && /WebKit\\//.test(userAgent);\nvar qtwebkit = webkit && /Qt\\/\\d+\\.\\d+/.test(userAgent);\nvar chrome = !edge && /Chrome\\//.test(userAgent);\nvar presto = /Opera\\//.test(userAgent);\nvar safari = /Apple Computer/.test(navigator.vendor);\nvar mac_geMountainLion = /Mac OS X 1\\d\\D([8-9]|\\d\\d)\\D/.test(userAgent);\nvar phantom = /PhantomJS/.test(userAgent);\n\nvar ios = !edge && /AppleWebKit/.test(userAgent) && /Mobile\\/\\w+/.test(userAgent);\nvar android = /Android/.test(userAgent);\n// This is woefully incomplete. Suggestions for alternative methods welcome.\nvar mobile = ios || android || /webOS|BlackBerry|Opera Mini|Opera Mobi|IEMobile/i.test(userAgent);\nvar mac = ios || /Mac/.test(platform);\nvar chromeOS = /\\bCrOS\\b/.test(userAgent);\nvar windows = /win/i.test(platform);\n\nvar presto_version = presto && userAgent.match(/Version\\/(\\d*\\.\\d*)/);\nif (presto_version) { presto_version = Number(presto_version[1]); }\nif (presto_version && presto_version >= 15) { presto = false; webkit = true; }\n// Some browsers use the wrong event properties to signal cmd/ctrl on OS X\nvar flipCtrlCmd = mac && (qtwebkit || presto && (presto_version == null || presto_version < 12.11));\nvar captureRightClick = gecko || (ie && ie_version >= 9);\n\nfunction classTest(cls) { return new RegExp("(^|\\\\s)" + cls + "(?:$|\\\\s)\\\\s*") }\n\nvar rmClass = function(node, cls) {\n  var current = node.className;\n  var match = classTest(cls).exec(current);\n  if (match) {\n    var after = current.slice(match.index + match[0].length);\n    node.className = current.slice(0, match.index) + (after ? match[1] + after : "");\n  }\n};\n\nfunction removeChildren(e) {\n  for (var count = e.childNodes.length; count > 0; --count)\n    { e.removeChild(e.firstChild); }\n  return e\n}\n\nfunction removeChildrenAndAdd(parent, e) {\n  return removeChildren(parent).appendChild(e)\n}\n\nfunction elt(tag, content, className, style) {\n  var e = document.createElement(tag);\n  if (className) { e.className = className; }\n  if (style) { e.style.cssText = style; }\n  if (typeof content == "string") { e.appendChild(document.createTextNode(content)); }\n  else if (content) { for (var i = 0; i < content.length; ++i) { e.appendChild(content[i]); } }\n  return e\n}\n// wrapper for elt, which removes the elt from the accessibility tree\nfunction eltP(tag, content, className, style) {\n  var e = elt(tag, content, className, style);\n  e.setAttribute("role", "presentation");\n  return e\n}\n\nvar range;\nif (document.createRange) { range = function(node, start, end, endNode) {\n  var r = document.createRange();\n  r.setEnd(endNode || node, end);\n  r.setStart(node, start);\n  return r\n}; }\nelse { range = function(node, start, end) {\n  var r = document.body.createTextRange();\n  try { r.moveToElementText(node.parentNode); }\n  catch(e) { return r }\n  r.collapse(true);\n  r.moveEnd("character", end);\n  r.moveStart("character", start);\n  return r\n}; }\n\nfunction contains(parent, child) {\n  if (child.nodeType == 3) // Android browser always returns false when child is a textnode\n    { child = child.parentNode; }\n  if (parent.contains)\n    { return parent.contains(child) }\n  do {\n    if (child.nodeType == 11) { child = child.host; }\n    if (child == parent) { return true }\n  } while (child = child.parentNode)\n}\n\nfunction activeElt() {\n  // IE and Edge may throw an "Unspecified Error" when accessing document.activeElement.\n  // IE < 10 will throw when accessed while the page is loading or in an iframe.\n  // IE > 9 and Edge will throw when accessed in an iframe if document.body is unavailable.\n  var activeElement;\n  try {\n    activeElement = document.activeElement;\n  } catch(e) {\n    activeElement = document.body || null;\n  }\n  while (activeElement && activeElement.shadowRoot && activeElement.shadowRoot.activeElement)\n    { activeElement = activeElement.shadowRoot.activeElement; }\n  return activeElement\n}\n\nfunction addClass(node, cls) {\n  var current = node.className;\n  if (!classTest(cls).test(current)) { node.className += (current ? " " : "") + cls; }\n}\nfunction joinClasses(a, b) {\n  var as = a.split(" ");\n  for (var i = 0; i < as.length; i++)\n    { if (as[i] && !classTest(as[i]).test(b)) { b += " " + as[i]; } }\n  return b\n}\n\nvar selectInput = function(node) { node.select(); };\nif (ios) // Mobile Safari apparently has a bug where select() is broken.\n  { selectInput = function(node) { node.selectionStart = 0; node.selectionEnd = node.value.length; }; }\nelse if (ie) // Suppress mysterious IE10 errors\n  { selectInput = function(node) { try { node.select(); } catch(_e) {} }; }\n\nfunction bind(f) {\n  var args = Array.prototype.slice.call(arguments, 1);\n  return function(){return f.apply(null, args)}\n}\n\nfunction copyObj(obj, target, overwrite) {\n  if (!target) { target = {}; }\n  for (var prop in obj)\n    { if (obj.hasOwnProperty(prop) && (overwrite !== false || !target.hasOwnProperty(prop)))\n      { target[prop] = obj[prop]; } }\n  return target\n}\n\n// Counts the column offset in a string, taking tabs into account.\n// Used mostly to find indentation.\nfunction countColumn(string, end, tabSize, startIndex, startValue) {\n  if (end == null) {\n    end = string.search(/[^\\s\\u00a0]/);\n    if (end == -1) { end = string.length; }\n  }\n  for (var i = startIndex || 0, n = startValue || 0;;) {\n    var nextTab = string.indexOf("\\t", i);\n    if (nextTab < 0 || nextTab >= end)\n      { return n + (end - i) }\n    n += nextTab - i;\n    n += tabSize - (n % tabSize);\n    i = nextTab + 1;\n  }\n}\n\nvar Delayed = function() {this.id = null;};\nDelayed.prototype.set = function (ms, f) {\n  clearTimeout(this.id);\n  this.id = setTimeout(f, ms);\n};\n\nfunction indexOf(array, elt) {\n  for (var i = 0; i < array.length; ++i)\n    { if (array[i] == elt) { return i } }\n  return -1\n}\n\n// Number of pixels added to scroller and sizer to hide scrollbar\nvar scrollerGap = 30;\n\n// Returned or thrown by various protocols to signal \'I\'m not\n// handling this\'.\nvar Pass = {toString: function(){return "CodeMirror.Pass"}};\n\n// Reused option objects for setSelection & friends\nvar sel_dontScroll = {scroll: false};\nvar sel_mouse = {origin: "*mouse"};\nvar sel_move = {origin: "+move"};\n\n// The inverse of countColumn -- find the offset that corresponds to\n// a particular column.\nfunction findColumn(string, goal, tabSize) {\n  for (var pos = 0, col = 0;;) {\n    var nextTab = string.indexOf("\\t", pos);\n    if (nextTab == -1) { nextTab = string.length; }\n    var skipped = nextTab - pos;\n    if (nextTab == string.length || col + skipped >= goal)\n      { return pos + Math.min(skipped, goal - col) }\n    col += nextTab - pos;\n    col += tabSize - (col % tabSize);\n    pos = nextTab + 1;\n    if (col >= goal) { return pos }\n  }\n}\n\nvar spaceStrs = [""];\nfunction spaceStr(n) {\n  while (spaceStrs.length <= n)\n    { spaceStrs.push(lst(spaceStrs) + " "); }\n  return spaceStrs[n]\n}\n\nfunction lst(arr) { return arr[arr.length-1] }\n\nfunction map(array, f) {\n  var out = [];\n  for (var i = 0; i < array.length; i++) { out[i] = f(array[i], i); }\n  return out\n}\n\nfunction insertSorted(array, value, score) {\n  var pos = 0, priority = score(value);\n  while (pos < array.length && score(array[pos]) <= priority) { pos++; }\n  array.splice(pos, 0, value);\n}\n\nfunction nothing() {}\n\nfunction createObj(base, props) {\n  var inst;\n  if (Object.create) {\n    inst = Object.create(base);\n  } else {\n    nothing.prototype = base;\n    inst = new nothing();\n  }\n  if (props) { copyObj(props, inst); }\n  return inst\n}\n\nvar nonASCIISingleCaseWordChar = /[\\u00df\\u0587\\u0590-\\u05f4\\u0600-\\u06ff\\u3040-\\u309f\\u30a0-\\u30ff\\u3400-\\u4db5\\u4e00-\\u9fcc\\uac00-\\ud7af]/;\nfunction isWordCharBasic(ch) {\n  return /\\w/.test(ch) || ch > "\\x80" &&\n    (ch.toUpperCase() != ch.toLowerCase() || nonASCIISingleCaseWordChar.test(ch))\n}\nfunction isWordChar(ch, helper) {\n  if (!helper) { return isWordCharBasic(ch) }\n  if (helper.source.indexOf("\\\\w") > -1 && isWordCharBasic(ch)) { return true }\n  return helper.test(ch)\n}\n\nfunction isEmpty(obj) {\n  for (var n in obj) { if (obj.hasOwnProperty(n) && obj[n]) { return false } }\n  return true\n}\n\n// Extending unicode characters. A series of a non-extending char +\n// any number of extending chars is treated as a single unit as far\n// as editing and measuring is concerned. This is not fully correct,\n// since some scripts/fonts/browsers also treat other configurations\n// of code points as a group.\nvar extendingChars = /[\\u0300-\\u036f\\u0483-\\u0489\\u0591-\\u05bd\\u05bf\\u05c1\\u05c2\\u05c4\\u05c5\\u05c7\\u0610-\\u061a\\u064b-\\u065e\\u0670\\u06d6-\\u06dc\\u06de-\\u06e4\\u06e7\\u06e8\\u06ea-\\u06ed\\u0711\\u0730-\\u074a\\u07a6-\\u07b0\\u07eb-\\u07f3\\u0816-\\u0819\\u081b-\\u0823\\u0825-\\u0827\\u0829-\\u082d\\u0900-\\u0902\\u093c\\u0941-\\u0948\\u094d\\u0951-\\u0955\\u0962\\u0963\\u0981\\u09bc\\u09be\\u09c1-\\u09c4\\u09cd\\u09d7\\u09e2\\u09e3\\u0a01\\u0a02\\u0a3c\\u0a41\\u0a42\\u0a47\\u0a48\\u0a4b-\\u0a4d\\u0a51\\u0a70\\u0a71\\u0a75\\u0a81\\u0a82\\u0abc\\u0ac1-\\u0ac5\\u0ac7\\u0ac8\\u0acd\\u0ae2\\u0ae3\\u0b01\\u0b3c\\u0b3e\\u0b3f\\u0b41-\\u0b44\\u0b4d\\u0b56\\u0b57\\u0b62\\u0b63\\u0b82\\u0bbe\\u0bc0\\u0bcd\\u0bd7\\u0c3e-\\u0c40\\u0c46-\\u0c48\\u0c4a-\\u0c4d\\u0c55\\u0c56\\u0c62\\u0c63\\u0cbc\\u0cbf\\u0cc2\\u0cc6\\u0ccc\\u0ccd\\u0cd5\\u0cd6\\u0ce2\\u0ce3\\u0d3e\\u0d41-\\u0d44\\u0d4d\\u0d57\\u0d62\\u0d63\\u0dca\\u0dcf\\u0dd2-\\u0dd4\\u0dd6\\u0ddf\\u0e31\\u0e34-\\u0e3a\\u0e47-\\u0e4e\\u0eb1\\u0eb4-\\u0eb9\\u0ebb\\u0ebc\\u0ec8-\\u0ecd\\u0f18\\u0f19\\u0f35\\u0f37\\u0f39\\u0f71-\\u0f7e\\u0f80-\\u0f84\\u0f86\\u0f87\\u0f90-\\u0f97\\u0f99-\\u0fbc\\u0fc6\\u102d-\\u1030\\u1032-\\u1037\\u1039\\u103a\\u103d\\u103e\\u1058\\u1059\\u105e-\\u1060\\u1071-\\u1074\\u1082\\u1085\\u1086\\u108d\\u109d\\u135f\\u1712-\\u1714\\u1732-\\u1734\\u1752\\u1753\\u1772\\u1773\\u17b7-\\u17bd\\u17c6\\u17c9-\\u17d3\\u17dd\\u180b-\\u180d\\u18a9\\u1920-\\u1922\\u1927\\u1928\\u1932\\u1939-\\u193b\\u1a17\\u1a18\\u1a56\\u1a58-\\u1a5e\\u1a60\\u1a62\\u1a65-\\u1a6c\\u1a73-\\u1a7c\\u1a7f\\u1b00-\\u1b03\\u1b34\\u1b36-\\u1b3a\\u1b3c\\u1b42\\u1b6b-\\u1b73\\u1b80\\u1b81\\u1ba2-\\u1ba5\\u1ba8\\u1ba9\\u1c2c-\\u1c33\\u1c36\\u1c37\\u1cd0-\\u1cd2\\u1cd4-\\u1ce0\\u1ce2-\\u1ce8\\u1ced\\u1dc0-\\u1de6\\u1dfd-\\u1dff\\u200c\\u200d\\u20d0-\\u20f0\\u2cef-\\u2cf1\\u2de0-\\u2dff\\u302a-\\u302f\\u3099\\u309a\\ua66f-\\ua672\\ua67c\\ua67d\\ua6f0\\ua6f1\\ua802\\ua806\\ua80b\\ua825\\ua826\\ua8c4\\ua8e0-\\ua8f1\\ua926-\\ua92d\\ua947-\\ua951\\ua980-\\ua982\\ua9b3\\ua9b6-\\ua9b9\\ua9bc\\uaa29-\\uaa2e\\uaa31\\uaa32\\uaa35\\uaa36\\uaa43\\uaa4c\\uaab0\\uaab2-\\uaab4\\uaab7\\uaab8\\uaabe\\uaabf\\uaac1\\uabe5\\uabe8\\uabed\\udc00-\\udfff\\ufb1e\\ufe00-\\ufe0f\\ufe20-\\ufe26\\uff9e\\uff9f]/;\nfunction isExtendingChar(ch) { return ch.charCodeAt(0) >= 768 && extendingChars.test(ch) }\n\n// Returns a number from the range [`0`; `str.length`] unless `pos` is outside that range.\nfunction skipExtendingChars(str, pos, dir) {\n  while ((dir < 0 ? pos > 0 : pos < str.length) && isExtendingChar(str.charAt(pos))) { pos += dir; }\n  return pos\n}\n\n// Returns the value from the range [`from`; `to`] that satisfies\n// `pred` and is closest to `from`. Assumes that at least `to` satisfies `pred`.\nfunction findFirst(pred, from, to) {\n  for (;;) {\n    if (Math.abs(from - to) <= 1) { return pred(from) ? from : to }\n    var mid = Math.floor((from + to) / 2);\n    if (pred(mid)) { to = mid; }\n    else { from = mid; }\n  }\n}\n\n// The display handles the DOM integration, both for input reading\n// and content drawing. It holds references to DOM nodes and\n// display-related state.\n\nfunction Display(place, doc, input) {\n  var d = this;\n  this.input = input;\n\n  // Covers bottom-right square when both scrollbars are present.\n  d.scrollbarFiller = elt("div", null, "CodeMirror-scrollbar-filler");\n  d.scrollbarFiller.setAttribute("cm-not-content", "true");\n  // Covers bottom of gutter when coverGutterNextToScrollbar is on\n  // and h scrollbar is present.\n  d.gutterFiller = elt("div", null, "CodeMirror-gutter-filler");\n  d.gutterFiller.setAttribute("cm-not-content", "true");\n  // Will contain the actual code, positioned to cover the viewport.\n  d.lineDiv = eltP("div", null, "CodeMirror-code");\n  // Elements are added to these to represent selection and cursors.\n  d.selectionDiv = elt("div", null, null, "position: relative; z-index: 1");\n  d.cursorDiv = elt("div", null, "CodeMirror-cursors");\n  // A visibility: hidden element used to find the size of things.\n  d.measure = elt("div", null, "CodeMirror-measure");\n  // When lines outside of the viewport are measured, they are drawn in this.\n  d.lineMeasure = elt("div", null, "CodeMirror-measure");\n  // Wraps everything that needs to exist inside the vertically-padded coordinate system\n  d.lineSpace = eltP("div", [d.measure, d.lineMeasure, d.selectionDiv, d.cursorDiv, d.lineDiv],\n                    null, "position: relative; outline: none");\n  var lines = eltP("div", [d.lineSpace], "CodeMirror-lines");\n  // Moved around its parent to cover visible view.\n  d.mover = elt("div", [lines], null, "position: relative");\n  // Set to the height of the document, allowing scrolling.\n  d.sizer = elt("div", [d.mover], "CodeMirror-sizer");\n  d.sizerWidth = null;\n  // Behavior of elts with overflow: auto and padding is\n  // inconsistent across browsers. This is used to ensure the\n  // scrollable area is big enough.\n  d.heightForcer = elt("div", null, null, "position: absolute; height: " + scrollerGap + "px; width: 1px;");\n  // Will contain the gutters, if any.\n  d.gutters = elt("div", null, "CodeMirror-gutters");\n  d.lineGutter = null;\n  // Actual scrollable element.\n  d.scroller = elt("div", [d.sizer, d.heightForcer, d.gutters], "CodeMirror-scroll");\n  d.scroller.setAttribute("tabIndex", "-1");\n  // The element in which the editor lives.\n  d.wrapper = elt("div", [d.scrollbarFiller, d.gutterFiller, d.scroller], "CodeMirror");\n\n  // Work around IE7 z-index bug (not perfect, hence IE7 not really being supported)\n  if (ie && ie_version < 8) { d.gutters.style.zIndex = -1; d.scroller.style.paddingRight = 0; }\n  if (!webkit && !(gecko && mobile)) { d.scroller.draggable = true; }\n\n  if (place) {\n    if (place.appendChild) { place.appendChild(d.wrapper); }\n    else { place(d.wrapper); }\n  }\n\n  // Current rendered range (may be bigger than the view window).\n  d.viewFrom = d.viewTo = doc.first;\n  d.reportedViewFrom = d.reportedViewTo = doc.first;\n  // Information about the rendered lines.\n  d.view = [];\n  d.renderedView = null;\n  // Holds info about a single rendered line when it was rendered\n  // for measurement, while not in view.\n  d.externalMeasured = null;\n  // Empty space (in pixels) above the view\n  d.viewOffset = 0;\n  d.lastWrapHeight = d.lastWrapWidth = 0;\n  d.updateLineNumbers = null;\n\n  d.nativeBarWidth = d.barHeight = d.barWidth = 0;\n  d.scrollbarsClipped = false;\n\n  // Used to only resize the line number gutter when necessary (when\n  // the amount of lines crosses a boundary that makes its width change)\n  d.lineNumWidth = d.lineNumInnerWidth = d.lineNumChars = null;\n  // Set to true when a non-horizontal-scrolling line widget is\n  // added. As an optimization, line widget aligning is skipped when\n  // this is false.\n  d.alignWidgets = false;\n\n  d.cachedCharWidth = d.cachedTextHeight = d.cachedPaddingH = null;\n\n  // Tracks the maximum line length so that the horizontal scrollbar\n  // can be kept static when scrolling.\n  d.maxLine = null;\n  d.maxLineLength = 0;\n  d.maxLineChanged = false;\n\n  // Used for measuring wheel scrolling granularity\n  d.wheelDX = d.wheelDY = d.wheelStartX = d.wheelStartY = null;\n\n  // True when shift is held down.\n  d.shift = false;\n\n  // Used to track whether anything happened since the context menu\n  // was opened.\n  d.selForContextMenu = null;\n\n  d.activeTouch = null;\n\n  input.init(d);\n}\n\n// Find the line object corresponding to the given line number.\nfunction getLine(doc, n) {\n  n -= doc.first;\n  if (n < 0 || n >= doc.size) { throw new Error("There is no line " + (n + doc.first) + " in the document.") }\n  var chunk = doc;\n  while (!chunk.lines) {\n    for (var i = 0;; ++i) {\n      var child = chunk.children[i], sz = child.chunkSize();\n      if (n < sz) { chunk = child; break }\n      n -= sz;\n    }\n  }\n  return chunk.lines[n]\n}\n\n// Get the part of a document between two positions, as an array of\n// strings.\nfunction getBetween(doc, start, end) {\n  var out = [], n = start.line;\n  doc.iter(start.line, end.line + 1, function (line) {\n    var text = line.text;\n    if (n == end.line) { text = text.slice(0, end.ch); }\n    if (n == start.line) { text = text.slice(start.ch); }\n    out.push(text);\n    ++n;\n  });\n  return out\n}\n// Get the lines between from and to, as array of strings.\nfunction getLines(doc, from, to) {\n  var out = [];\n  doc.iter(from, to, function (line) { out.push(line.text); }); // iter aborts when callback returns truthy value\n  return out\n}\n\n// Update the height of a line, propagating the height change\n// upwards to parent nodes.\nfunction updateLineHeight(line, height) {\n  var diff = height - line.height;\n  if (diff) { for (var n = line; n; n = n.parent) { n.height += diff; } }\n}\n\n// Given a line object, find its line number by walking up through\n// its parent links.\nfunction lineNo(line) {\n  if (line.parent == null) { return null }\n  var cur = line.parent, no = indexOf(cur.lines, line);\n  for (var chunk = cur.parent; chunk; cur = chunk, chunk = chunk.parent) {\n    for (var i = 0;; ++i) {\n      if (chunk.children[i] == cur) { break }\n      no += chunk.children[i].chunkSize();\n    }\n  }\n  return no + cur.first\n}\n\n// Find the line at the given vertical position, using the height\n// information in the document tree.\nfunction lineAtHeight(chunk, h) {\n  var n = chunk.first;\n  outer: do {\n    for (var i$1 = 0; i$1 < chunk.children.length; ++i$1) {\n      var child = chunk.children[i$1], ch = child.height;\n      if (h < ch) { chunk = child; continue outer }\n      h -= ch;\n      n += child.chunkSize();\n    }\n    return n\n  } while (!chunk.lines)\n  var i = 0;\n  for (; i < chunk.lines.length; ++i) {\n    var line = chunk.lines[i], lh = line.height;\n    if (h < lh) { break }\n    h -= lh;\n  }\n  return n + i\n}\n\nfunction isLine(doc, l) {return l >= doc.first && l < doc.first + doc.size}\n\nfunction lineNumberFor(options, i) {\n  return String(options.lineNumberFormatter(i + options.firstLineNumber))\n}\n\n// A Pos instance represents a position within the text.\nfunction Pos(line, ch, sticky) {\n  if ( sticky === void 0 ) sticky = null;\n\n  if (!(this instanceof Pos)) { return new Pos(line, ch, sticky) }\n  this.line = line;\n  this.ch = ch;\n  this.sticky = sticky;\n}\n\n// Compare two positions, return 0 if they are the same, a negative\n// number when a is less, and a positive number otherwise.\nfunction cmp(a, b) { return a.line - b.line || a.ch - b.ch }\n\nfunction equalCursorPos(a, b) { return a.sticky == b.sticky && cmp(a, b) == 0 }\n\nfunction copyPos(x) {return Pos(x.line, x.ch)}\nfunction maxPos(a, b) { return cmp(a, b) < 0 ? b : a }\nfunction minPos(a, b) { return cmp(a, b) < 0 ? a : b }\n\n// Most of the external API clips given positions to make sure they\n// actually exist within the document.\nfunction clipLine(doc, n) {return Math.max(doc.first, Math.min(n, doc.first + doc.size - 1))}\nfunction clipPos(doc, pos) {\n  if (pos.line < doc.first) { return Pos(doc.first, 0) }\n  var last = doc.first + doc.size - 1;\n  if (pos.line > last) { return Pos(last, getLine(doc, last).text.length) }\n  return clipToLen(pos, getLine(doc, pos.line).text.length)\n}\nfunction clipToLen(pos, linelen) {\n  var ch = pos.ch;\n  if (ch == null || ch > linelen) { return Pos(pos.line, linelen) }\n  else if (ch < 0) { return Pos(pos.line, 0) }\n  else { return pos }\n}\nfunction clipPosArray(doc, array) {\n  var out = [];\n  for (var i = 0; i < array.length; i++) { out[i] = clipPos(doc, array[i]); }\n  return out\n}\n\n// Optimize some code when these features are not used.\nvar sawReadOnlySpans = false;\nvar sawCollapsedSpans = false;\n\nfunction seeReadOnlySpans() {\n  sawReadOnlySpans = true;\n}\n\nfunction seeCollapsedSpans() {\n  sawCollapsedSpans = true;\n}\n\n// TEXTMARKER SPANS\n\nfunction MarkedSpan(marker, from, to) {\n  this.marker = marker;\n  this.from = from; this.to = to;\n}\n\n// Search an array of spans for a span matching the given marker.\nfunction getMarkedSpanFor(spans, marker) {\n  if (spans) { for (var i = 0; i < spans.length; ++i) {\n    var span = spans[i];\n    if (span.marker == marker) { return span }\n  } }\n}\n// Remove a span from an array, returning undefined if no spans are\n// left (we don\'t store arrays for lines without spans).\nfunction removeMarkedSpan(spans, span) {\n  var r;\n  for (var i = 0; i < spans.length; ++i)\n    { if (spans[i] != span) { (r || (r = [])).push(spans[i]); } }\n  return r\n}\n// Add a span to a line.\nfunction addMarkedSpan(line, span) {\n  line.markedSpans = line.markedSpans ? line.markedSpans.concat([span]) : [span];\n  span.marker.attachLine(line);\n}\n\n// Used for the algorithm that adjusts markers for a change in the\n// document. These functions cut an array of spans at a given\n// character position, returning an array of remaining chunks (or\n// undefined if nothing remains).\nfunction markedSpansBefore(old, startCh, isInsert) {\n  var nw;\n  if (old) { for (var i = 0; i < old.length; ++i) {\n    var span = old[i], marker = span.marker;\n    var startsBefore = span.from == null || (marker.inclusiveLeft ? span.from <= startCh : span.from < startCh);\n    if (startsBefore || span.from == startCh && marker.type == "bookmark" && (!isInsert || !span.marker.insertLeft)) {\n      var endsAfter = span.to == null || (marker.inclusiveRight ? span.to >= startCh : span.to > startCh);(nw || (nw = [])).push(new MarkedSpan(marker, span.from, endsAfter ? null : span.to));\n    }\n  } }\n  return nw\n}\nfunction markedSpansAfter(old, endCh, isInsert) {\n  var nw;\n  if (old) { for (var i = 0; i < old.length; ++i) {\n    var span = old[i], marker = span.marker;\n    var endsAfter = span.to == null || (marker.inclusiveRight ? span.to >= endCh : span.to > endCh);\n    if (endsAfter || span.from == endCh && marker.type == "bookmark" && (!isInsert || span.marker.insertLeft)) {\n      var startsBefore = span.from == null || (marker.inclusiveLeft ? span.from <= endCh : span.from < endCh);(nw || (nw = [])).push(new MarkedSpan(marker, startsBefore ? null : span.from - endCh,\n                                            span.to == null ? null : span.to - endCh));\n    }\n  } }\n  return nw\n}\n\n// Given a change object, compute the new set of marker spans that\n// cover the line in which the change took place. Removes spans\n// entirely within the change, reconnects spans belonging to the\n// same marker that appear on both sides of the change, and cuts off\n// spans partially within the change. Returns an array of span\n// arrays with one element for each line in (after) the change.\nfunction stretchSpansOverChange(doc, change) {\n  if (change.full) { return null }\n  var oldFirst = isLine(doc, change.from.line) && getLine(doc, change.from.line).markedSpans;\n  var oldLast = isLine(doc, change.to.line) && getLine(doc, change.to.line).markedSpans;\n  if (!oldFirst && !oldLast) { return null }\n\n  var startCh = change.from.ch, endCh = change.to.ch, isInsert = cmp(change.from, change.to) == 0;\n  // Get the spans that \'stick out\' on both sides\n  var first = markedSpansBefore(oldFirst, startCh, isInsert);\n  var last = markedSpansAfter(oldLast, endCh, isInsert);\n\n  // Next, merge those two ends\n  var sameLine = change.text.length == 1, offset = lst(change.text).length + (sameLine ? startCh : 0);\n  if (first) {\n    // Fix up .to properties of first\n    for (var i = 0; i < first.length; ++i) {\n      var span = first[i];\n      if (span.to == null) {\n        var found = getMarkedSpanFor(last, span.marker);\n        if (!found) { span.to = startCh; }\n        else if (sameLine) { span.to = found.to == null ? null : found.to + offset; }\n      }\n    }\n  }\n  if (last) {\n    // Fix up .from in last (or move them into first in case of sameLine)\n    for (var i$1 = 0; i$1 < last.length; ++i$1) {\n      var span$1 = last[i$1];\n      if (span$1.to != null) { span$1.to += offset; }\n      if (span$1.from == null) {\n        var found$1 = getMarkedSpanFor(first, span$1.marker);\n        if (!found$1) {\n          span$1.from = offset;\n          if (sameLine) { (first || (first = [])).push(span$1); }\n        }\n      } else {\n        span$1.from += offset;\n        if (sameLine) { (first || (first = [])).push(span$1); }\n      }\n    }\n  }\n  // Make sure we didn\'t create any zero-length spans\n  if (first) { first = clearEmptySpans(first); }\n  if (last && last != first) { last = clearEmptySpans(last); }\n\n  var newMarkers = [first];\n  if (!sameLine) {\n    // Fill gap with whole-line-spans\n    var gap = change.text.length - 2, gapMarkers;\n    if (gap > 0 && first)\n      { for (var i$2 = 0; i$2 < first.length; ++i$2)\n        { if (first[i$2].to == null)\n          { (gapMarkers || (gapMarkers = [])).push(new MarkedSpan(first[i$2].marker, null, null)); } } }\n    for (var i$3 = 0; i$3 < gap; ++i$3)\n      { newMarkers.push(gapMarkers); }\n    newMarkers.push(last);\n  }\n  return newMarkers\n}\n\n// Remove spans that are empty and don\'t have a clearWhenEmpty\n// option of false.\nfunction clearEmptySpans(spans) {\n  for (var i = 0; i < spans.length; ++i) {\n    var span = spans[i];\n    if (span.from != null && span.from == span.to && span.marker.clearWhenEmpty !== false)\n      { spans.splice(i--, 1); }\n  }\n  if (!spans.length) { return null }\n  return spans\n}\n\n// Used to \'clip\' out readOnly ranges when making a change.\nfunction removeReadOnlyRanges(doc, from, to) {\n  var markers = null;\n  doc.iter(from.line, to.line + 1, function (line) {\n    if (line.markedSpans) { for (var i = 0; i < line.markedSpans.length; ++i) {\n      var mark = line.markedSpans[i].marker;\n      if (mark.readOnly && (!markers || indexOf(markers, mark) == -1))\n        { (markers || (markers = [])).push(mark); }\n    } }\n  });\n  if (!markers) { return null }\n  var parts = [{from: from, to: to}];\n  for (var i = 0; i < markers.length; ++i) {\n    var mk = markers[i], m = mk.find(0);\n    for (var j = 0; j < parts.length; ++j) {\n      var p = parts[j];\n      if (cmp(p.to, m.from) < 0 || cmp(p.from, m.to) > 0) { continue }\n      var newParts = [j, 1], dfrom = cmp(p.from, m.from), dto = cmp(p.to, m.to);\n      if (dfrom < 0 || !mk.inclusiveLeft && !dfrom)\n        { newParts.push({from: p.from, to: m.from}); }\n      if (dto > 0 || !mk.inclusiveRight && !dto)\n        { newParts.push({from: m.to, to: p.to}); }\n      parts.splice.apply(parts, newParts);\n      j += newParts.length - 3;\n    }\n  }\n  return parts\n}\n\n// Connect or disconnect spans from a line.\nfunction detachMarkedSpans(line) {\n  var spans = line.markedSpans;\n  if (!spans) { return }\n  for (var i = 0; i < spans.length; ++i)\n    { spans[i].marker.detachLine(line); }\n  line.markedSpans = null;\n}\nfunction attachMarkedSpans(line, spans) {\n  if (!spans) { return }\n  for (var i = 0; i < spans.length; ++i)\n    { spans[i].marker.attachLine(line); }\n  line.markedSpans = spans;\n}\n\n// Helpers used when computing which overlapping collapsed span\n// counts as the larger one.\nfunction extraLeft(marker) { return marker.inclusiveLeft ? -1 : 0 }\nfunction extraRight(marker) { return marker.inclusiveRight ? 1 : 0 }\n\n// Returns a number indicating which of two overlapping collapsed\n// spans is larger (and thus includes the other). Falls back to\n// comparing ids when the spans cover exactly the same range.\nfunction compareCollapsedMarkers(a, b) {\n  var lenDiff = a.lines.length - b.lines.length;\n  if (lenDiff != 0) { return lenDiff }\n  var aPos = a.find(), bPos = b.find();\n  var fromCmp = cmp(aPos.from, bPos.from) || extraLeft(a) - extraLeft(b);\n  if (fromCmp) { return -fromCmp }\n  var toCmp = cmp(aPos.to, bPos.to) || extraRight(a) - extraRight(b);\n  if (toCmp) { return toCmp }\n  return b.id - a.id\n}\n\n// Find out whether a line ends or starts in a collapsed span. If\n// so, return the marker for that span.\nfunction collapsedSpanAtSide(line, start) {\n  var sps = sawCollapsedSpans && line.markedSpans, found;\n  if (sps) { for (var sp = (void 0), i = 0; i < sps.length; ++i) {\n    sp = sps[i];\n    if (sp.marker.collapsed && (start ? sp.from : sp.to) == null &&\n        (!found || compareCollapsedMarkers(found, sp.marker) < 0))\n      { found = sp.marker; }\n  } }\n  return found\n}\nfunction collapsedSpanAtStart(line) { return collapsedSpanAtSide(line, true) }\nfunction collapsedSpanAtEnd(line) { return collapsedSpanAtSide(line, false) }\n\n// Test whether there exists a collapsed span that partially\n// overlaps (covers the start or end, but not both) of a new span.\n// Such overlap is not allowed.\nfunction conflictingCollapsedRange(doc, lineNo$$1, from, to, marker) {\n  var line = getLine(doc, lineNo$$1);\n  var sps = sawCollapsedSpans && line.markedSpans;\n  if (sps) { for (var i = 0; i < sps.length; ++i) {\n    var sp = sps[i];\n    if (!sp.marker.collapsed) { continue }\n    var found = sp.marker.find(0);\n    var fromCmp = cmp(found.from, from) || extraLeft(sp.marker) - extraLeft(marker);\n    var toCmp = cmp(found.to, to) || extraRight(sp.marker) - extraRight(marker);\n    if (fromCmp >= 0 && toCmp <= 0 || fromCmp <= 0 && toCmp >= 0) { continue }\n    if (fromCmp <= 0 && (sp.marker.inclusiveRight && marker.inclusiveLeft ? cmp(found.to, from) >= 0 : cmp(found.to, from) > 0) ||\n        fromCmp >= 0 && (sp.marker.inclusiveRight && marker.inclusiveLeft ? cmp(found.from, to) <= 0 : cmp(found.from, to) < 0))\n      { return true }\n  } }\n}\n\n// A visual line is a line as drawn on the screen. Folding, for\n// example, can cause multiple logical lines to appear on the same\n// visual line. This finds the start of the visual line that the\n// given line is part of (usually that is the line itself).\nfunction visualLine(line) {\n  var merged;\n  while (merged = collapsedSpanAtStart(line))\n    { line = merged.find(-1, true).line; }\n  return line\n}\n\nfunction visualLineEnd(line) {\n  var merged;\n  while (merged = collapsedSpanAtEnd(line))\n    { line = merged.find(1, true).line; }\n  return line\n}\n\n// Returns an array of logical lines that continue the visual line\n// started by the argument, or undefined if there are no such lines.\nfunction visualLineContinued(line) {\n  var merged, lines;\n  while (merged = collapsedSpanAtEnd(line)) {\n    line = merged.find(1, true).line\n    ;(lines || (lines = [])).push(line);\n  }\n  return lines\n}\n\n// Get the line number of the start of the visual line that the\n// given line number is part of.\nfunction visualLineNo(doc, lineN) {\n  var line = getLine(doc, lineN), vis = visualLine(line);\n  if (line == vis) { return lineN }\n  return lineNo(vis)\n}\n\n// Get the line number of the start of the next visual line after\n// the given line.\nfunction visualLineEndNo(doc, lineN) {\n  if (lineN > doc.lastLine()) { return lineN }\n  var line = getLine(doc, lineN), merged;\n  if (!lineIsHidden(doc, line)) { return lineN }\n  while (merged = collapsedSpanAtEnd(line))\n    { line = merged.find(1, true).line; }\n  return lineNo(line) + 1\n}\n\n// Compute whether a line is hidden. Lines count as hidden when they\n// are part of a visual line that starts with another line, or when\n// they are entirely covered by collapsed, non-widget span.\nfunction lineIsHidden(doc, line) {\n  var sps = sawCollapsedSpans && line.markedSpans;\n  if (sps) { for (var sp = (void 0), i = 0; i < sps.length; ++i) {\n    sp = sps[i];\n    if (!sp.marker.collapsed) { continue }\n    if (sp.from == null) { return true }\n    if (sp.marker.widgetNode) { continue }\n    if (sp.from == 0 && sp.marker.inclusiveLeft && lineIsHiddenInner(doc, line, sp))\n      { return true }\n  } }\n}\nfunction lineIsHiddenInner(doc, line, span) {\n  if (span.to == null) {\n    var end = span.marker.find(1, true);\n    return lineIsHiddenInner(doc, end.line, getMarkedSpanFor(end.line.markedSpans, span.marker))\n  }\n  if (span.marker.inclusiveRight && span.to == line.text.length)\n    { return true }\n  for (var sp = (void 0), i = 0; i < line.markedSpans.length; ++i) {\n    sp = line.markedSpans[i];\n    if (sp.marker.collapsed && !sp.marker.widgetNode && sp.from == span.to &&\n        (sp.to == null || sp.to != span.from) &&\n        (sp.marker.inclusiveLeft || span.marker.inclusiveRight) &&\n        lineIsHiddenInner(doc, line, sp)) { return true }\n  }\n}\n\n// Find the height above the given line.\nfunction heightAtLine(lineObj) {\n  lineObj = visualLine(lineObj);\n\n  var h = 0, chunk = lineObj.parent;\n  for (var i = 0; i < chunk.lines.length; ++i) {\n    var line = chunk.lines[i];\n    if (line == lineObj) { break }\n    else { h += line.height; }\n  }\n  for (var p = chunk.parent; p; chunk = p, p = chunk.parent) {\n    for (var i$1 = 0; i$1 < p.children.length; ++i$1) {\n      var cur = p.children[i$1];\n      if (cur == chunk) { break }\n      else { h += cur.height; }\n    }\n  }\n  return h\n}\n\n// Compute the character length of a line, taking into account\n// collapsed ranges (see markText) that might hide parts, and join\n// other lines onto it.\nfunction lineLength(line) {\n  if (line.height == 0) { return 0 }\n  var len = line.text.length, merged, cur = line;\n  while (merged = collapsedSpanAtStart(cur)) {\n    var found = merged.find(0, true);\n    cur = found.from.line;\n    len += found.from.ch - found.to.ch;\n  }\n  cur = line;\n  while (merged = collapsedSpanAtEnd(cur)) {\n    var found$1 = merged.find(0, true);\n    len -= cur.text.length - found$1.from.ch;\n    cur = found$1.to.line;\n    len += cur.text.length - found$1.to.ch;\n  }\n  return len\n}\n\n// Find the longest line in the document.\nfunction findMaxLine(cm) {\n  var d = cm.display, doc = cm.doc;\n  d.maxLine = getLine(doc, doc.first);\n  d.maxLineLength = lineLength(d.maxLine);\n  d.maxLineChanged = true;\n  doc.iter(function (line) {\n    var len = lineLength(line);\n    if (len > d.maxLineLength) {\n      d.maxLineLength = len;\n      d.maxLine = line;\n    }\n  });\n}\n\n// BIDI HELPERS\n\nfunction iterateBidiSections(order, from, to, f) {\n  if (!order) { return f(from, to, "ltr") }\n  var found = false;\n  for (var i = 0; i < order.length; ++i) {\n    var part = order[i];\n    if (part.from < to && part.to > from || from == to && part.to == from) {\n      f(Math.max(part.from, from), Math.min(part.to, to), part.level == 1 ? "rtl" : "ltr");\n      found = true;\n    }\n  }\n  if (!found) { f(from, to, "ltr"); }\n}\n\nvar bidiOther = null;\nfunction getBidiPartAt(order, ch, sticky) {\n  var found;\n  bidiOther = null;\n  for (var i = 0; i < order.length; ++i) {\n    var cur = order[i];\n    if (cur.from < ch && cur.to > ch) { return i }\n    if (cur.to == ch) {\n      if (cur.from != cur.to && sticky == "before") { found = i; }\n      else { bidiOther = i; }\n    }\n    if (cur.from == ch) {\n      if (cur.from != cur.to && sticky != "before") { found = i; }\n      else { bidiOther = i; }\n    }\n  }\n  return found != null ? found : bidiOther\n}\n\n// Bidirectional ordering algorithm\n// See http://unicode.org/reports/tr9/tr9-13.html for the algorithm\n// that this (partially) implements.\n\n// One-char codes used for character types:\n// L (L):   Left-to-Right\n// R (R):   Right-to-Left\n// r (AL):  Right-to-Left Arabic\n// 1 (EN):  European Number\n// + (ES):  European Number Separator\n// % (ET):  European Number Terminator\n// n (AN):  Arabic Number\n// , (CS):  Common Number Separator\n// m (NSM): Non-Spacing Mark\n// b (BN):  Boundary Neutral\n// s (B):   Paragraph Separator\n// t (S):   Segment Separator\n// w (WS):  Whitespace\n// N (ON):  Other Neutrals\n\n// Returns null if characters are ordered as they appear\n// (left-to-right), or an array of sections ({from, to, level}\n// objects) in the order in which they occur visually.\nvar bidiOrdering = (function() {\n  // Character types for codepoints 0 to 0xff\n  var lowTypes = "bbbbbbbbbtstwsbbbbbbbbbbbbbbssstwNN%%%NNNNNN,N,N1111111111NNNNNNNLLLLLLLLLLLLLLLLLLLLLLLLLLNNNNNNLLLLLLLLLLLLLLLLLLLLLLLLLLNNNNbbbbbbsbbbbbbbbbbbbbbbbbbbbbbbbbb,N%%%%NNNNLNNNNN%%11NLNNN1LNNNNNLLLLLLLLLLLLLLLLLLLLLLLNLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLN";\n  // Character types for codepoints 0x600 to 0x6f9\n  var arabicTypes = "nnnnnnNNr%%r,rNNmmmmmmmmmmmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrmmmmmmmmmmmmmmmmmmmmmnnnnnnnnnn%nnrrrmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrmmmmmmmnNmmmmmmrrmmNmmmmrr1111111111";\n  function charType(code) {\n    if (code <= 0xf7) { return lowTypes.charAt(code) }\n    else if (0x590 <= code && code <= 0x5f4) { return "R" }\n    else if (0x600 <= code && code <= 0x6f9) { return arabicTypes.charAt(code - 0x600) }\n    else if (0x6ee <= code && code <= 0x8ac) { return "r" }\n    else if (0x2000 <= code && code <= 0x200b) { return "w" }\n    else if (code == 0x200c) { return "b" }\n    else { return "L" }\n  }\n\n  var bidiRE = /[\\u0590-\\u05f4\\u0600-\\u06ff\\u0700-\\u08ac]/;\n  var isNeutral = /[stwN]/, isStrong = /[LRr]/, countsAsLeft = /[Lb1n]/, countsAsNum = /[1n]/;\n\n  function BidiSpan(level, from, to) {\n    this.level = level;\n    this.from = from; this.to = to;\n  }\n\n  return function(str, direction) {\n    var outerType = direction == "ltr" ? "L" : "R";\n\n    if (str.length == 0 || direction == "ltr" && !bidiRE.test(str)) { return false }\n    var len = str.length, types = [];\n    for (var i = 0; i < len; ++i)\n      { types.push(charType(str.charCodeAt(i))); }\n\n    // W1. Examine each non-spacing mark (NSM) in the level run, and\n    // change the type of the NSM to the type of the previous\n    // character. If the NSM is at the start of the level run, it will\n    // get the type of sor.\n    for (var i$1 = 0, prev = outerType; i$1 < len; ++i$1) {\n      var type = types[i$1];\n      if (type == "m") { types[i$1] = prev; }\n      else { prev = type; }\n    }\n\n    // W2. Search backwards from each instance of a European number\n    // until the first strong type (R, L, AL, or sor) is found. If an\n    // AL is found, change the type of the European number to Arabic\n    // number.\n    // W3. Change all ALs to R.\n    for (var i$2 = 0, cur = outerType; i$2 < len; ++i$2) {\n      var type$1 = types[i$2];\n      if (type$1 == "1" && cur == "r") { types[i$2] = "n"; }\n      else if (isStrong.test(type$1)) { cur = type$1; if (type$1 == "r") { types[i$2] = "R"; } }\n    }\n\n    // W4. A single European separator between two European numbers\n    // changes to a European number. A single common separator between\n    // two numbers of the same type changes to that type.\n    for (var i$3 = 1, prev$1 = types[0]; i$3 < len - 1; ++i$3) {\n      var type$2 = types[i$3];\n      if (type$2 == "+" && prev$1 == "1" && types[i$3+1] == "1") { types[i$3] = "1"; }\n      else if (type$2 == "," && prev$1 == types[i$3+1] &&\n               (prev$1 == "1" || prev$1 == "n")) { types[i$3] = prev$1; }\n      prev$1 = type$2;\n    }\n\n    // W5. A sequence of European terminators adjacent to European\n    // numbers changes to all European numbers.\n    // W6. Otherwise, separators and terminators change to Other\n    // Neutral.\n    for (var i$4 = 0; i$4 < len; ++i$4) {\n      var type$3 = types[i$4];\n      if (type$3 == ",") { types[i$4] = "N"; }\n      else if (type$3 == "%") {\n        var end = (void 0);\n        for (end = i$4 + 1; end < len && types[end] == "%"; ++end) {}\n        var replace = (i$4 && types[i$4-1] == "!") || (end < len && types[end] == "1") ? "1" : "N";\n        for (var j = i$4; j < end; ++j) { types[j] = replace; }\n        i$4 = end - 1;\n      }\n    }\n\n    // W7. Search backwards from each instance of a European number\n    // until the first strong type (R, L, or sor) is found. If an L is\n    // found, then change the type of the European number to L.\n    for (var i$5 = 0, cur$1 = outerType; i$5 < len; ++i$5) {\n      var type$4 = types[i$5];\n      if (cur$1 == "L" && type$4 == "1") { types[i$5] = "L"; }\n      else if (isStrong.test(type$4)) { cur$1 = type$4; }\n    }\n\n    // N1. A sequence of neutrals takes the direction of the\n    // surrounding strong text if the text on both sides has the same\n    // direction. European and Arabic numbers act as if they were R in\n    // terms of their influence on neutrals. Start-of-level-run (sor)\n    // and end-of-level-run (eor) are used at level run boundaries.\n    // N2. Any remaining neutrals take the embedding direction.\n    for (var i$6 = 0; i$6 < len; ++i$6) {\n      if (isNeutral.test(types[i$6])) {\n        var end$1 = (void 0);\n        for (end$1 = i$6 + 1; end$1 < len && isNeutral.test(types[end$1]); ++end$1) {}\n        var before = (i$6 ? types[i$6-1] : outerType) == "L";\n        var after = (end$1 < len ? types[end$1] : outerType) == "L";\n        var replace$1 = before == after ? (before ? "L" : "R") : outerType;\n        for (var j$1 = i$6; j$1 < end$1; ++j$1) { types[j$1] = replace$1; }\n        i$6 = end$1 - 1;\n      }\n    }\n\n    // Here we depart from the documented algorithm, in order to avoid\n    // building up an actual levels array. Since there are only three\n    // levels (0, 1, 2) in an implementation that doesn\'t take\n    // explicit embedding into account, we can build up the order on\n    // the fly, without following the level-based algorithm.\n    var order = [], m;\n    for (var i$7 = 0; i$7 < len;) {\n      if (countsAsLeft.test(types[i$7])) {\n        var start = i$7;\n        for (++i$7; i$7 < len && countsAsLeft.test(types[i$7]); ++i$7) {}\n        order.push(new BidiSpan(0, start, i$7));\n      } else {\n        var pos = i$7, at = order.length;\n        for (++i$7; i$7 < len && types[i$7] != "L"; ++i$7) {}\n        for (var j$2 = pos; j$2 < i$7;) {\n          if (countsAsNum.test(types[j$2])) {\n            if (pos < j$2) { order.splice(at, 0, new BidiSpan(1, pos, j$2)); }\n            var nstart = j$2;\n            for (++j$2; j$2 < i$7 && countsAsNum.test(types[j$2]); ++j$2) {}\n            order.splice(at, 0, new BidiSpan(2, nstart, j$2));\n            pos = j$2;\n          } else { ++j$2; }\n        }\n        if (pos < i$7) { order.splice(at, 0, new BidiSpan(1, pos, i$7)); }\n      }\n    }\n    if (order[0].level == 1 && (m = str.match(/^\\s+/))) {\n      order[0].from = m[0].length;\n      order.unshift(new BidiSpan(0, 0, m[0].length));\n    }\n    if (lst(order).level == 1 && (m = str.match(/\\s+$/))) {\n      lst(order).to -= m[0].length;\n      order.push(new BidiSpan(0, len - m[0].length, len));\n    }\n\n    return direction == "rtl" ? order.reverse() : order\n  }\n})();\n\n// Get the bidi ordering for the given line (and cache it). Returns\n// false for lines that are fully left-to-right, and an array of\n// BidiSpan objects otherwise.\nfunction getOrder(line, direction) {\n  var order = line.order;\n  if (order == null) { order = line.order = bidiOrdering(line.text, direction); }\n  return order\n}\n\nfunction moveCharLogically(line, ch, dir) {\n  var target = skipExtendingChars(line.text, ch + dir, dir);\n  return target < 0 || target > line.text.length ? null : target\n}\n\nfunction moveLogically(line, start, dir) {\n  var ch = moveCharLogically(line, start.ch, dir);\n  return ch == null ? null : new Pos(start.line, ch, dir < 0 ? "after" : "before")\n}\n\nfunction endOfLine(visually, cm, lineObj, lineNo, dir) {\n  if (visually) {\n    var order = getOrder(lineObj, cm.doc.direction);\n    if (order) {\n      var part = dir < 0 ? lst(order) : order[0];\n      var moveInStorageOrder = (dir < 0) == (part.level == 1);\n      var sticky = moveInStorageOrder ? "after" : "before";\n      var ch;\n      // With a wrapped rtl chunk (possibly spanning multiple bidi parts),\n      // it could be that the last bidi part is not on the last visual line,\n      // since visual lines contain content order-consecutive chunks.\n      // Thus, in rtl, we are looking for the first (content-order) character\n      // in the rtl chunk that is on the last line (that is, the same line\n      // as the last (content-order) character).\n      if (part.level > 0) {\n        var prep = prepareMeasureForLine(cm, lineObj);\n        ch = dir < 0 ? lineObj.text.length - 1 : 0;\n        var targetTop = measureCharPrepared(cm, prep, ch).top;\n        ch = findFirst(function (ch) { return measureCharPrepared(cm, prep, ch).top == targetTop; }, (dir < 0) == (part.level == 1) ? part.from : part.to - 1, ch);\n        if (sticky == "before") { ch = moveCharLogically(lineObj, ch, 1); }\n      } else { ch = dir < 0 ? part.to : part.from; }\n      return new Pos(lineNo, ch, sticky)\n    }\n  }\n  return new Pos(lineNo, dir < 0 ? lineObj.text.length : 0, dir < 0 ? "before" : "after")\n}\n\nfunction moveVisually(cm, line, start, dir) {\n  var bidi = getOrder(line, cm.doc.direction);\n  if (!bidi) { return moveLogically(line, start, dir) }\n  if (start.ch >= line.text.length) {\n    start.ch = line.text.length;\n    start.sticky = "before";\n  } else if (start.ch <= 0) {\n    start.ch = 0;\n    start.sticky = "after";\n  }\n  var partPos = getBidiPartAt(bidi, start.ch, start.sticky), part = bidi[partPos];\n  if (cm.doc.direction == "ltr" && part.level % 2 == 0 && (dir > 0 ? part.to > start.ch : part.from < start.ch)) {\n    // Case 1: We move within an ltr part in an ltr editor. Even with wrapped lines,\n    // nothing interesting happens.\n    return moveLogically(line, start, dir)\n  }\n\n  var mv = function (pos, dir) { return moveCharLogically(line, pos instanceof Pos ? pos.ch : pos, dir); };\n  var prep;\n  var getWrappedLineExtent = function (ch) {\n    if (!cm.options.lineWrapping) { return {begin: 0, end: line.text.length} }\n    prep = prep || prepareMeasureForLine(cm, line);\n    return wrappedLineExtentChar(cm, line, prep, ch)\n  };\n  var wrappedLineExtent = getWrappedLineExtent(start.sticky == "before" ? mv(start, -1) : start.ch);\n\n  if (cm.doc.direction == "rtl" || part.level == 1) {\n    var moveInStorageOrder = (part.level == 1) == (dir < 0);\n    var ch = mv(start, moveInStorageOrder ? 1 : -1);\n    if (ch != null && (!moveInStorageOrder ? ch >= part.from && ch >= wrappedLineExtent.begin : ch <= part.to && ch <= wrappedLineExtent.end)) {\n      // Case 2: We move within an rtl part or in an rtl editor on the same visual line\n      var sticky = moveInStorageOrder ? "before" : "after";\n      return new Pos(start.line, ch, sticky)\n    }\n  }\n\n  // Case 3: Could not move within this bidi part in this visual line, so leave\n  // the current bidi part\n\n  var searchInVisualLine = function (partPos, dir, wrappedLineExtent) {\n    var getRes = function (ch, moveInStorageOrder) { return moveInStorageOrder\n      ? new Pos(start.line, mv(ch, 1), "before")\n      : new Pos(start.line, ch, "after"); };\n\n    for (; partPos >= 0 && partPos < bidi.length; partPos += dir) {\n      var part = bidi[partPos];\n      var moveInStorageOrder = (dir > 0) == (part.level != 1);\n      var ch = moveInStorageOrder ? wrappedLineExtent.begin : mv(wrappedLineExtent.end, -1);\n      if (part.from <= ch && ch < part.to) { return getRes(ch, moveInStorageOrder) }\n      ch = moveInStorageOrder ? part.from : mv(part.to, -1);\n      if (wrappedLineExtent.begin <= ch && ch < wrappedLineExtent.end) { return getRes(ch, moveInStorageOrder) }\n    }\n  };\n\n  // Case 3a: Look for other bidi parts on the same visual line\n  var res = searchInVisualLine(partPos + dir, dir, wrappedLineExtent);\n  if (res) { return res }\n\n  // Case 3b: Look for other bidi parts on the next visual line\n  var nextCh = dir > 0 ? wrappedLineExtent.end : mv(wrappedLineExtent.begin, -1);\n  if (nextCh != null && !(dir > 0 && nextCh == line.text.length)) {\n    res = searchInVisualLine(dir > 0 ? 0 : bidi.length - 1, dir, getWrappedLineExtent(nextCh));\n    if (res) { return res }\n  }\n\n  // Case 4: Nowhere to move\n  return null\n}\n\n// EVENT HANDLING\n\n// Lightweight event framework. on/off also work on DOM nodes,\n// registering native DOM handlers.\n\nvar noHandlers = [];\n\nvar on = function(emitter, type, f) {\n  if (emitter.addEventListener) {\n    emitter.addEventListener(type, f, false);\n  } else if (emitter.attachEvent) {\n    emitter.attachEvent("on" + type, f);\n  } else {\n    var map$$1 = emitter._handlers || (emitter._handlers = {});\n    map$$1[type] = (map$$1[type] || noHandlers).concat(f);\n  }\n};\n\nfunction getHandlers(emitter, type) {\n  return emitter._handlers && emitter._handlers[type] || noHandlers\n}\n\nfunction off(emitter, type, f) {\n  if (emitter.removeEventListener) {\n    emitter.removeEventListener(type, f, false);\n  } else if (emitter.detachEvent) {\n    emitter.detachEvent("on" + type, f);\n  } else {\n    var map$$1 = emitter._handlers, arr = map$$1 && map$$1[type];\n    if (arr) {\n      var index = indexOf(arr, f);\n      if (index > -1)\n        { map$$1[type] = arr.slice(0, index).concat(arr.slice(index + 1)); }\n    }\n  }\n}\n\nfunction signal(emitter, type /*, values...*/) {\n  var handlers = getHandlers(emitter, type);\n  if (!handlers.length) { return }\n  var args = Array.prototype.slice.call(arguments, 2);\n  for (var i = 0; i < handlers.length; ++i) { handlers[i].apply(null, args); }\n}\n\n// The DOM events that CodeMirror handles can be overridden by\n// registering a (non-DOM) handler on the editor for the event name,\n// and preventDefault-ing the event in that handler.\nfunction signalDOMEvent(cm, e, override) {\n  if (typeof e == "string")\n    { e = {type: e, preventDefault: function() { this.defaultPrevented = true; }}; }\n  signal(cm, override || e.type, cm, e);\n  return e_defaultPrevented(e) || e.codemirrorIgnore\n}\n\nfunction signalCursorActivity(cm) {\n  var arr = cm._handlers && cm._handlers.cursorActivity;\n  if (!arr) { return }\n  var set = cm.curOp.cursorActivityHandlers || (cm.curOp.cursorActivityHandlers = []);\n  for (var i = 0; i < arr.length; ++i) { if (indexOf(set, arr[i]) == -1)\n    { set.push(arr[i]); } }\n}\n\nfunction hasHandler(emitter, type) {\n  return getHandlers(emitter, type).length > 0\n}\n\n// Add on and off methods to a constructor\'s prototype, to make\n// registering events on such objects more convenient.\nfunction eventMixin(ctor) {\n  ctor.prototype.on = function(type, f) {on(this, type, f);};\n  ctor.prototype.off = function(type, f) {off(this, type, f);};\n}\n\n// Due to the fact that we still support jurassic IE versions, some\n// compatibility wrappers are needed.\n\nfunction e_preventDefault(e) {\n  if (e.preventDefault) { e.preventDefault(); }\n  else { e.returnValue = false; }\n}\nfunction e_stopPropagation(e) {\n  if (e.stopPropagation) { e.stopPropagation(); }\n  else { e.cancelBubble = true; }\n}\nfunction e_defaultPrevented(e) {\n  return e.defaultPrevented != null ? e.defaultPrevented : e.returnValue == false\n}\nfunction e_stop(e) {e_preventDefault(e); e_stopPropagation(e);}\n\nfunction e_target(e) {return e.target || e.srcElement}\nfunction e_button(e) {\n  var b = e.which;\n  if (b == null) {\n    if (e.button & 1) { b = 1; }\n    else if (e.button & 2) { b = 3; }\n    else if (e.button & 4) { b = 2; }\n  }\n  if (mac && e.ctrlKey && b == 1) { b = 3; }\n  return b\n}\n\n// Detect drag-and-drop\nvar dragAndDrop = function() {\n  // There is *some* kind of drag-and-drop support in IE6-8, but I\n  // couldn\'t get it to work yet.\n  if (ie && ie_version < 9) { return false }\n  var div = elt(\'div\');\n  return "draggable" in div || "dragDrop" in div\n}();\n\nvar zwspSupported;\nfunction zeroWidthElement(measure) {\n  if (zwspSupported == null) {\n    var test = elt("span", "\\u200b");\n    removeChildrenAndAdd(measure, elt("span", [test, document.createTextNode("x")]));\n    if (measure.firstChild.offsetHeight != 0)\n      { zwspSupported = test.offsetWidth <= 1 && test.offsetHeight > 2 && !(ie && ie_version < 8); }\n  }\n  var node = zwspSupported ? elt("span", "\\u200b") :\n    elt("span", "\\u00a0", null, "display: inline-block; width: 1px; margin-right: -1px");\n  node.setAttribute("cm-text", "");\n  return node\n}\n\n// Feature-detect IE\'s crummy client rect reporting for bidi text\nvar badBidiRects;\nfunction hasBadBidiRects(measure) {\n  if (badBidiRects != null) { return badBidiRects }\n  var txt = removeChildrenAndAdd(measure, document.createTextNode("A\\u062eA"));\n  var r0 = range(txt, 0, 1).getBoundingClientRect();\n  var r1 = range(txt, 1, 2).getBoundingClientRect();\n  removeChildren(measure);\n  if (!r0 || r0.left == r0.right) { return false } // Safari returns null in some cases (#2780)\n  return badBidiRects = (r1.right - r0.right < 3)\n}\n\n// See if "".split is the broken IE version, if so, provide an\n// alternative way to split lines.\nvar splitLinesAuto = "\\n\\nb".split(/\\n/).length != 3 ? function (string) {\n  var pos = 0, result = [], l = string.length;\n  while (pos <= l) {\n    var nl = string.indexOf("\\n", pos);\n    if (nl == -1) { nl = string.length; }\n    var line = string.slice(pos, string.charAt(nl - 1) == "\\r" ? nl - 1 : nl);\n    var rt = line.indexOf("\\r");\n    if (rt != -1) {\n      result.push(line.slice(0, rt));\n      pos += rt + 1;\n    } else {\n      result.push(line);\n      pos = nl + 1;\n    }\n  }\n  return result\n} : function (string) { return string.split(/\\r\\n?|\\n/); };\n\nvar hasSelection = window.getSelection ? function (te) {\n  try { return te.selectionStart != te.selectionEnd }\n  catch(e) { return false }\n} : function (te) {\n  var range$$1;\n  try {range$$1 = te.ownerDocument.selection.createRange();}\n  catch(e) {}\n  if (!range$$1 || range$$1.parentElement() != te) { return false }\n  return range$$1.compareEndPoints("StartToEnd", range$$1) != 0\n};\n\nvar hasCopyEvent = (function () {\n  var e = elt("div");\n  if ("oncopy" in e) { return true }\n  e.setAttribute("oncopy", "return;");\n  return typeof e.oncopy == "function"\n})();\n\nvar badZoomedRects = null;\nfunction hasBadZoomedRects(measure) {\n  if (badZoomedRects != null) { return badZoomedRects }\n  var node = removeChildrenAndAdd(measure, elt("span", "x"));\n  var normal = node.getBoundingClientRect();\n  var fromRange = range(node, 0, 1).getBoundingClientRect();\n  return badZoomedRects = Math.abs(normal.left - fromRange.left) > 1\n}\n\n// Known modes, by name and by MIME\nvar modes = {};\nvar mimeModes = {};\n\n// Extra arguments are stored as the mode\'s dependencies, which is\n// used by (legacy) mechanisms like loadmode.js to automatically\n// load a mode. (Preferred mechanism is the require/define calls.)\nfunction defineMode(name, mode) {\n  if (arguments.length > 2)\n    { mode.dependencies = Array.prototype.slice.call(arguments, 2); }\n  modes[name] = mode;\n}\n\nfunction defineMIME(mime, spec) {\n  mimeModes[mime] = spec;\n}\n\n// Given a MIME type, a {name, ...options} config object, or a name\n// string, return a mode config object.\nfunction resolveMode(spec) {\n  if (typeof spec == "string" && mimeModes.hasOwnProperty(spec)) {\n    spec = mimeModes[spec];\n  } else if (spec && typeof spec.name == "string" && mimeModes.hasOwnProperty(spec.name)) {\n    var found = mimeModes[spec.name];\n    if (typeof found == "string") { found = {name: found}; }\n    spec = createObj(found, spec);\n    spec.name = found.name;\n  } else if (typeof spec == "string" && /^[\\w\\-]+\\/[\\w\\-]+\\+xml$/.test(spec)) {\n    return resolveMode("application/xml")\n  } else if (typeof spec == "string" && /^[\\w\\-]+\\/[\\w\\-]+\\+json$/.test(spec)) {\n    return resolveMode("application/json")\n  }\n  if (typeof spec == "string") { return {name: spec} }\n  else { return spec || {name: "null"} }\n}\n\n// Given a mode spec (anything that resolveMode accepts), find and\n// initialize an actual mode object.\nfunction getMode(options, spec) {\n  spec = resolveMode(spec);\n  var mfactory = modes[spec.name];\n  if (!mfactory) { return getMode(options, "text/plain") }\n  var modeObj = mfactory(options, spec);\n  if (modeExtensions.hasOwnProperty(spec.name)) {\n    var exts = modeExtensions[spec.name];\n    for (var prop in exts) {\n      if (!exts.hasOwnProperty(prop)) { continue }\n      if (modeObj.hasOwnProperty(prop)) { modeObj["_" + prop] = modeObj[prop]; }\n      modeObj[prop] = exts[prop];\n    }\n  }\n  modeObj.name = spec.name;\n  if (spec.helperType) { modeObj.helperType = spec.helperType; }\n  if (spec.modeProps) { for (var prop$1 in spec.modeProps)\n    { modeObj[prop$1] = spec.modeProps[prop$1]; } }\n\n  return modeObj\n}\n\n// This can be used to attach properties to mode objects from\n// outside the actual mode definition.\nvar modeExtensions = {};\nfunction extendMode(mode, properties) {\n  var exts = modeExtensions.hasOwnProperty(mode) ? modeExtensions[mode] : (modeExtensions[mode] = {});\n  copyObj(properties, exts);\n}\n\nfunction copyState(mode, state) {\n  if (state === true) { return state }\n  if (mode.copyState) { return mode.copyState(state) }\n  var nstate = {};\n  for (var n in state) {\n    var val = state[n];\n    if (val instanceof Array) { val = val.concat([]); }\n    nstate[n] = val;\n  }\n  return nstate\n}\n\n// Given a mode and a state (for that mode), find the inner mode and\n// state at the position that the state refers to.\nfunction innerMode(mode, state) {\n  var info;\n  while (mode.innerMode) {\n    info = mode.innerMode(state);\n    if (!info || info.mode == mode) { break }\n    state = info.state;\n    mode = info.mode;\n  }\n  return info || {mode: mode, state: state}\n}\n\nfunction startState(mode, a1, a2) {\n  return mode.startState ? mode.startState(a1, a2) : true\n}\n\n// STRING STREAM\n\n// Fed to the mode parsers, provides helper functions to make\n// parsers more succinct.\n\nvar StringStream = function(string, tabSize, lineOracle) {\n  this.pos = this.start = 0;\n  this.string = string;\n  this.tabSize = tabSize || 8;\n  this.lastColumnPos = this.lastColumnValue = 0;\n  this.lineStart = 0;\n  this.lineOracle = lineOracle;\n};\n\nStringStream.prototype.eol = function () {return this.pos >= this.string.length};\nStringStream.prototype.sol = function () {return this.pos == this.lineStart};\nStringStream.prototype.peek = function () {return this.string.charAt(this.pos) || undefined};\nStringStream.prototype.next = function () {\n  if (this.pos < this.string.length)\n    { return this.string.charAt(this.pos++) }\n};\nStringStream.prototype.eat = function (match) {\n  var ch = this.string.charAt(this.pos);\n  var ok;\n  if (typeof match == "string") { ok = ch == match; }\n  else { ok = ch && (match.test ? match.test(ch) : match(ch)); }\n  if (ok) {++this.pos; return ch}\n};\nStringStream.prototype.eatWhile = function (match) {\n  var start = this.pos;\n  while (this.eat(match)){}\n  return this.pos > start\n};\nStringStream.prototype.eatSpace = function () {\n    var this$1 = this;\n\n  var start = this.pos;\n  while (/[\\s\\u00a0]/.test(this.string.charAt(this.pos))) { ++this$1.pos; }\n  return this.pos > start\n};\nStringStream.prototype.skipToEnd = function () {this.pos = this.string.length;};\nStringStream.prototype.skipTo = function (ch) {\n  var found = this.string.indexOf(ch, this.pos);\n  if (found > -1) {this.pos = found; return true}\n};\nStringStream.prototype.backUp = function (n) {this.pos -= n;};\nStringStream.prototype.column = function () {\n  if (this.lastColumnPos < this.start) {\n    this.lastColumnValue = countColumn(this.string, this.start, this.tabSize, this.lastColumnPos, this.lastColumnValue);\n    this.lastColumnPos = this.start;\n  }\n  return this.lastColumnValue - (this.lineStart ? countColumn(this.string, this.lineStart, this.tabSize) : 0)\n};\nStringStream.prototype.indentation = function () {\n  return countColumn(this.string, null, this.tabSize) -\n    (this.lineStart ? countColumn(this.string, this.lineStart, this.tabSize) : 0)\n};\nStringStream.prototype.match = function (pattern, consume, caseInsensitive) {\n  if (typeof pattern == "string") {\n    var cased = function (str) { return caseInsensitive ? str.toLowerCase() : str; };\n    var substr = this.string.substr(this.pos, pattern.length);\n    if (cased(substr) == cased(pattern)) {\n      if (consume !== false) { this.pos += pattern.length; }\n      return true\n    }\n  } else {\n    var match = this.string.slice(this.pos).match(pattern);\n    if (match && match.index > 0) { return null }\n    if (match && consume !== false) { this.pos += match[0].length; }\n    return match\n  }\n};\nStringStream.prototype.current = function (){return this.string.slice(this.start, this.pos)};\nStringStream.prototype.hideFirstChars = function (n, inner) {\n  this.lineStart += n;\n  try { return inner() }\n  finally { this.lineStart -= n; }\n};\nStringStream.prototype.lookAhead = function (n) {\n  var oracle = this.lineOracle;\n  return oracle && oracle.lookAhead(n)\n};\n\nvar SavedContext = function(state, lookAhead) {\n  this.state = state;\n  this.lookAhead = lookAhead;\n};\n\nvar Context = function(doc, state, line, lookAhead) {\n  this.state = state;\n  this.doc = doc;\n  this.line = line;\n  this.maxLookAhead = lookAhead || 0;\n};\n\nContext.prototype.lookAhead = function (n) {\n  var line = this.doc.getLine(this.line + n);\n  if (line != null && n > this.maxLookAhead) { this.maxLookAhead = n; }\n  return line\n};\n\nContext.prototype.nextLine = function () {\n  this.line++;\n  if (this.maxLookAhead > 0) { this.maxLookAhead--; }\n};\n\nContext.fromSaved = function (doc, saved, line) {\n  if (saved instanceof SavedContext)\n    { return new Context(doc, copyState(doc.mode, saved.state), line, saved.lookAhead) }\n  else\n    { return new Context(doc, copyState(doc.mode, saved), line) }\n};\n\nContext.prototype.save = function (copy) {\n  var state = copy !== false ? copyState(this.doc.mode, this.state) : this.state;\n  return this.maxLookAhead > 0 ? new SavedContext(state, this.maxLookAhead) : state\n};\n\n\n// Compute a style array (an array starting with a mode generation\n// -- for invalidation -- followed by pairs of end positions and\n// style strings), which is used to highlight the tokens on the\n// line.\nfunction highlightLine(cm, line, context, forceToEnd) {\n  // A styles array always starts with a number identifying the\n  // mode/overlays that it is based on (for easy invalidation).\n  var st = [cm.state.modeGen], lineClasses = {};\n  // Compute the base array of styles\n  runMode(cm, line.text, cm.doc.mode, context, function (end, style) { return st.push(end, style); },\n          lineClasses, forceToEnd);\n  var state = context.state;\n\n  // Run overlays, adjust style array.\n  var loop = function ( o ) {\n    var overlay = cm.state.overlays[o], i = 1, at = 0;\n    context.state = true;\n    runMode(cm, line.text, overlay.mode, context, function (end, style) {\n      var start = i;\n      // Ensure there\'s a token end at the current position, and that i points at it\n      while (at < end) {\n        var i_end = st[i];\n        if (i_end > end)\n          { st.splice(i, 1, end, st[i+1], i_end); }\n        i += 2;\n        at = Math.min(end, i_end);\n      }\n      if (!style) { return }\n      if (overlay.opaque) {\n        st.splice(start, i - start, end, "overlay " + style);\n        i = start + 2;\n      } else {\n        for (; start < i; start += 2) {\n          var cur = st[start+1];\n          st[start+1] = (cur ? cur + " " : "") + "overlay " + style;\n        }\n      }\n    }, lineClasses);\n  };\n\n  for (var o = 0; o < cm.state.overlays.length; ++o) loop( o );\n  context.state = state;\n\n  return {styles: st, classes: lineClasses.bgClass || lineClasses.textClass ? lineClasses : null}\n}\n\nfunction getLineStyles(cm, line, updateFrontier) {\n  if (!line.styles || line.styles[0] != cm.state.modeGen) {\n    var context = getContextBefore(cm, lineNo(line));\n    var resetState = line.text.length > cm.options.maxHighlightLength && copyState(cm.doc.mode, context.state);\n    var result = highlightLine(cm, line, context);\n    if (resetState) { context.state = resetState; }\n    line.stateAfter = context.save(!resetState);\n    line.styles = result.styles;\n    if (result.classes) { line.styleClasses = result.classes; }\n    else if (line.styleClasses) { line.styleClasses = null; }\n    if (updateFrontier === cm.doc.highlightFrontier)\n      { cm.doc.modeFrontier = Math.max(cm.doc.modeFrontier, ++cm.doc.highlightFrontier); }\n  }\n  return line.styles\n}\n\nfunction getContextBefore(cm, n, precise) {\n  var doc = cm.doc, display = cm.display;\n  if (!doc.mode.startState) { return new Context(doc, true, n) }\n  var start = findStartLine(cm, n, precise);\n  var saved = start > doc.first && getLine(doc, start - 1).stateAfter;\n  var context = saved ? Context.fromSaved(doc, saved, start) : new Context(doc, startState(doc.mode), start);\n\n  doc.iter(start, n, function (line) {\n    processLine(cm, line.text, context);\n    var pos = context.line;\n    line.stateAfter = pos == n - 1 || pos % 5 == 0 || pos >= display.viewFrom && pos < display.viewTo ? context.save() : null;\n    context.nextLine();\n  });\n  if (precise) { doc.modeFrontier = context.line; }\n  return context\n}\n\n// Lightweight form of highlight -- proceed over this line and\n// update state, but don\'t save a style array. Used for lines that\n// aren\'t currently visible.\nfunction processLine(cm, text, context, startAt) {\n  var mode = cm.doc.mode;\n  var stream = new StringStream(text, cm.options.tabSize, context);\n  stream.start = stream.pos = startAt || 0;\n  if (text == "") { callBlankLine(mode, context.state); }\n  while (!stream.eol()) {\n    readToken(mode, stream, context.state);\n    stream.start = stream.pos;\n  }\n}\n\nfunction callBlankLine(mode, state) {\n  if (mode.blankLine) { return mode.blankLine(state) }\n  if (!mode.innerMode) { return }\n  var inner = innerMode(mode, state);\n  if (inner.mode.blankLine) { return inner.mode.blankLine(inner.state) }\n}\n\nfunction readToken(mode, stream, state, inner) {\n  for (var i = 0; i < 10; i++) {\n    if (inner) { inner[0] = innerMode(mode, state).mode; }\n    var style = mode.token(stream, state);\n    if (stream.pos > stream.start) { return style }\n  }\n  throw new Error("Mode " + mode.name + " failed to advance stream.")\n}\n\nvar Token = function(stream, type, state) {\n  this.start = stream.start; this.end = stream.pos;\n  this.string = stream.current();\n  this.type = type || null;\n  this.state = state;\n};\n\n// Utility for getTokenAt and getLineTokens\nfunction takeToken(cm, pos, precise, asArray) {\n  var doc = cm.doc, mode = doc.mode, style;\n  pos = clipPos(doc, pos);\n  var line = getLine(doc, pos.line), context = getContextBefore(cm, pos.line, precise);\n  var stream = new StringStream(line.text, cm.options.tabSize, context), tokens;\n  if (asArray) { tokens = []; }\n  while ((asArray || stream.pos < pos.ch) && !stream.eol()) {\n    stream.start = stream.pos;\n    style = readToken(mode, stream, context.state);\n    if (asArray) { tokens.push(new Token(stream, style, copyState(doc.mode, context.state))); }\n  }\n  return asArray ? tokens : new Token(stream, style, context.state)\n}\n\nfunction extractLineClasses(type, output) {\n  if (type) { for (;;) {\n    var lineClass = type.match(/(?:^|\\s+)line-(background-)?(\\S+)/);\n    if (!lineClass) { break }\n    type = type.slice(0, lineClass.index) + type.slice(lineClass.index + lineClass[0].length);\n    var prop = lineClass[1] ? "bgClass" : "textClass";\n    if (output[prop] == null)\n      { output[prop] = lineClass[2]; }\n    else if (!(new RegExp("(?:^|\\s)" + lineClass[2] + "(?:$|\\s)")).test(output[prop]))\n      { output[prop] += " " + lineClass[2]; }\n  } }\n  return type\n}\n\n// Run the given mode\'s parser over a line, calling f for each token.\nfunction runMode(cm, text, mode, context, f, lineClasses, forceToEnd) {\n  var flattenSpans = mode.flattenSpans;\n  if (flattenSpans == null) { flattenSpans = cm.options.flattenSpans; }\n  var curStart = 0, curStyle = null;\n  var stream = new StringStream(text, cm.options.tabSize, context), style;\n  var inner = cm.options.addModeClass && [null];\n  if (text == "") { extractLineClasses(callBlankLine(mode, context.state), lineClasses); }\n  while (!stream.eol()) {\n    if (stream.pos > cm.options.maxHighlightLength) {\n      flattenSpans = false;\n      if (forceToEnd) { processLine(cm, text, context, stream.pos); }\n      stream.pos = text.length;\n      style = null;\n    } else {\n      style = extractLineClasses(readToken(mode, stream, context.state, inner), lineClasses);\n    }\n    if (inner) {\n      var mName = inner[0].name;\n      if (mName) { style = "m-" + (style ? mName + " " + style : mName); }\n    }\n    if (!flattenSpans || curStyle != style) {\n      while (curStart < stream.start) {\n        curStart = Math.min(stream.start, curStart + 5000);\n        f(curStart, curStyle);\n      }\n      curStyle = style;\n    }\n    stream.start = stream.pos;\n  }\n  while (curStart < stream.pos) {\n    // Webkit seems to refuse to render text nodes longer than 57444\n    // characters, and returns inaccurate measurements in nodes\n    // starting around 5000 chars.\n    var pos = Math.min(stream.pos, curStart + 5000);\n    f(pos, curStyle);\n    curStart = pos;\n  }\n}\n\n// Finds the line to start with when starting a parse. Tries to\n// find a line with a stateAfter, so that it can start with a\n// valid state. If that fails, it returns the line with the\n// smallest indentation, which tends to need the least context to\n// parse correctly.\nfunction findStartLine(cm, n, precise) {\n  var minindent, minline, doc = cm.doc;\n  var lim = precise ? -1 : n - (cm.doc.mode.innerMode ? 1000 : 100);\n  for (var search = n; search > lim; --search) {\n    if (search <= doc.first) { return doc.first }\n    var line = getLine(doc, search - 1), after = line.stateAfter;\n    if (after && (!precise || search + (after instanceof SavedContext ? after.lookAhead : 0) <= doc.modeFrontier))\n      { return search }\n    var indented = countColumn(line.text, null, cm.options.tabSize);\n    if (minline == null || minindent > indented) {\n      minline = search - 1;\n      minindent = indented;\n    }\n  }\n  return minline\n}\n\nfunction retreatFrontier(doc, n) {\n  doc.modeFrontier = Math.min(doc.modeFrontier, n);\n  if (doc.highlightFrontier < n - 10) { return }\n  var start = doc.first;\n  for (var line = n - 1; line > start; line--) {\n    var saved = getLine(doc, line).stateAfter;\n    // change is on 3\n    // state on line 1 looked ahead 2 -- so saw 3\n    // test 1 + 2 < 3 should cover this\n    if (saved && (!(saved instanceof SavedContext) || line + saved.lookAhead < n)) {\n      start = line + 1;\n      break\n    }\n  }\n  doc.highlightFrontier = Math.min(doc.highlightFrontier, start);\n}\n\n// LINE DATA STRUCTURE\n\n// Line objects. These hold state related to a line, including\n// highlighting info (the styles array).\nvar Line = function(text, markedSpans, estimateHeight) {\n  this.text = text;\n  attachMarkedSpans(this, markedSpans);\n  this.height = estimateHeight ? estimateHeight(this) : 1;\n};\n\nLine.prototype.lineNo = function () { return lineNo(this) };\neventMixin(Line);\n\n// Change the content (text, markers) of a line. Automatically\n// invalidates cached information and tries to re-estimate the\n// line\'s height.\nfunction updateLine(line, text, markedSpans, estimateHeight) {\n  line.text = text;\n  if (line.stateAfter) { line.stateAfter = null; }\n  if (line.styles) { line.styles = null; }\n  if (line.order != null) { line.order = null; }\n  detachMarkedSpans(line);\n  attachMarkedSpans(line, markedSpans);\n  var estHeight = estimateHeight ? estimateHeight(line) : 1;\n  if (estHeight != line.height) { updateLineHeight(line, estHeight); }\n}\n\n// Detach a line from the document tree and its markers.\nfunction cleanUpLine(line) {\n  line.parent = null;\n  detachMarkedSpans(line);\n}\n\n// Convert a style as returned by a mode (either null, or a string\n// containing one or more styles) to a CSS style. This is cached,\n// and also looks for line-wide styles.\nvar styleToClassCache = {};\nvar styleToClassCacheWithMode = {};\nfunction interpretTokenStyle(style, options) {\n  if (!style || /^\\s*$/.test(style)) { return null }\n  var cache = options.addModeClass ? styleToClassCacheWithMode : styleToClassCache;\n  return cache[style] ||\n    (cache[style] = style.replace(/\\S+/g, "cm-$&"))\n}\n\n// Render the DOM representation of the text of a line. Also builds\n// up a \'line map\', which points at the DOM nodes that represent\n// specific stretches of text, and is used by the measuring code.\n// The returned object contains the DOM node, this map, and\n// information about line-wide styles that were set by the mode.\nfunction buildLineContent(cm, lineView) {\n  // The padding-right forces the element to have a \'border\', which\n  // is needed on Webkit to be able to get line-level bounding\n  // rectangles for it (in measureChar).\n  var content = eltP("span", null, null, webkit ? "padding-right: .1px" : null);\n  var builder = {pre: eltP("pre", [content], "CodeMirror-line"), content: content,\n                 col: 0, pos: 0, cm: cm,\n                 trailingSpace: false,\n                 splitSpaces: (ie || webkit) && cm.getOption("lineWrapping")};\n  lineView.measure = {};\n\n  // Iterate over the logical lines that make up this visual line.\n  for (var i = 0; i <= (lineView.rest ? lineView.rest.length : 0); i++) {\n    var line = i ? lineView.rest[i - 1] : lineView.line, order = (void 0);\n    builder.pos = 0;\n    builder.addToken = buildToken;\n    // Optionally wire in some hacks into the token-rendering\n    // algorithm, to deal with browser quirks.\n    if (hasBadBidiRects(cm.display.measure) && (order = getOrder(line, cm.doc.direction)))\n      { builder.addToken = buildTokenBadBidi(builder.addToken, order); }\n    builder.map = [];\n    var allowFrontierUpdate = lineView != cm.display.externalMeasured && lineNo(line);\n    insertLineContent(line, builder, getLineStyles(cm, line, allowFrontierUpdate));\n    if (line.styleClasses) {\n      if (line.styleClasses.bgClass)\n        { builder.bgClass = joinClasses(line.styleClasses.bgClass, builder.bgClass || ""); }\n      if (line.styleClasses.textClass)\n        { builder.textClass = joinClasses(line.styleClasses.textClass, builder.textClass || ""); }\n    }\n\n    // Ensure at least a single node is present, for measuring.\n    if (builder.map.length == 0)\n      { builder.map.push(0, 0, builder.content.appendChild(zeroWidthElement(cm.display.measure))); }\n\n    // Store the map and a cache object for the current logical line\n    if (i == 0) {\n      lineView.measure.map = builder.map;\n      lineView.measure.cache = {};\n    } else {\n      (lineView.measure.maps || (lineView.measure.maps = [])).push(builder.map)\n      ;(lineView.measure.caches || (lineView.measure.caches = [])).push({});\n    }\n  }\n\n  // See issue #2901\n  if (webkit) {\n    var last = builder.content.lastChild;\n    if (/\\bcm-tab\\b/.test(last.className) || (last.querySelector && last.querySelector(".cm-tab")))\n      { builder.content.className = "cm-tab-wrap-hack"; }\n  }\n\n  signal(cm, "renderLine", cm, lineView.line, builder.pre);\n  if (builder.pre.className)\n    { builder.textClass = joinClasses(builder.pre.className, builder.textClass || ""); }\n\n  return builder\n}\n\nfunction defaultSpecialCharPlaceholder(ch) {\n  var token = elt("span", "\\u2022", "cm-invalidchar");\n  token.title = "\\\\u" + ch.charCodeAt(0).toString(16);\n  token.setAttribute("aria-label", token.title);\n  return token\n}\n\n// Build up the DOM representation for a single token, and add it to\n// the line map. Takes care to render special characters separately.\nfunction buildToken(builder, text, style, startStyle, endStyle, title, css) {\n  if (!text) { return }\n  var displayText = builder.splitSpaces ? splitSpaces(text, builder.trailingSpace) : text;\n  var special = builder.cm.state.specialChars, mustWrap = false;\n  var content;\n  if (!special.test(text)) {\n    builder.col += text.length;\n    content = document.createTextNode(displayText);\n    builder.map.push(builder.pos, builder.pos + text.length, content);\n    if (ie && ie_version < 9) { mustWrap = true; }\n    builder.pos += text.length;\n  } else {\n    content = document.createDocumentFragment();\n    var pos = 0;\n    while (true) {\n      special.lastIndex = pos;\n      var m = special.exec(text);\n      var skipped = m ? m.index - pos : text.length - pos;\n      if (skipped) {\n        var txt = document.createTextNode(displayText.slice(pos, pos + skipped));\n        if (ie && ie_version < 9) { content.appendChild(elt("span", [txt])); }\n        else { content.appendChild(txt); }\n        builder.map.push(builder.pos, builder.pos + skipped, txt);\n        builder.col += skipped;\n        builder.pos += skipped;\n      }\n      if (!m) { break }\n      pos += skipped + 1;\n      var txt$1 = (void 0);\n      if (m[0] == "\\t") {\n        var tabSize = builder.cm.options.tabSize, tabWidth = tabSize - builder.col % tabSize;\n        txt$1 = content.appendChild(elt("span", spaceStr(tabWidth), "cm-tab"));\n        txt$1.setAttribute("role", "presentation");\n        txt$1.setAttribute("cm-text", "\\t");\n        builder.col += tabWidth;\n      } else if (m[0] == "\\r" || m[0] == "\\n") {\n        txt$1 = content.appendChild(elt("span", m[0] == "\\r" ? "\\u240d" : "\\u2424", "cm-invalidchar"));\n        txt$1.setAttribute("cm-text", m[0]);\n        builder.col += 1;\n      } else {\n        txt$1 = builder.cm.options.specialCharPlaceholder(m[0]);\n        txt$1.setAttribute("cm-text", m[0]);\n        if (ie && ie_version < 9) { content.appendChild(elt("span", [txt$1])); }\n        else { content.appendChild(txt$1); }\n        builder.col += 1;\n      }\n      builder.map.push(builder.pos, builder.pos + 1, txt$1);\n      builder.pos++;\n    }\n  }\n  builder.trailingSpace = displayText.charCodeAt(text.length - 1) == 32;\n  if (style || startStyle || endStyle || mustWrap || css) {\n    var fullStyle = style || "";\n    if (startStyle) { fullStyle += startStyle; }\n    if (endStyle) { fullStyle += endStyle; }\n    var token = elt("span", [content], fullStyle, css);\n    if (title) { token.title = title; }\n    return builder.content.appendChild(token)\n  }\n  builder.content.appendChild(content);\n}\n\nfunction splitSpaces(text, trailingBefore) {\n  if (text.length > 1 && !/  /.test(text)) { return text }\n  var spaceBefore = trailingBefore, result = "";\n  for (var i = 0; i < text.length; i++) {\n    var ch = text.charAt(i);\n    if (ch == " " && spaceBefore && (i == text.length - 1 || text.charCodeAt(i + 1) == 32))\n      { ch = "\\u00a0"; }\n    result += ch;\n    spaceBefore = ch == " ";\n  }\n  return result\n}\n\n// Work around nonsense dimensions being reported for stretches of\n// right-to-left text.\nfunction buildTokenBadBidi(inner, order) {\n  return function (builder, text, style, startStyle, endStyle, title, css) {\n    style = style ? style + " cm-force-border" : "cm-force-border";\n    var start = builder.pos, end = start + text.length;\n    for (;;) {\n      // Find the part that overlaps with the start of this text\n      var part = (void 0);\n      for (var i = 0; i < order.length; i++) {\n        part = order[i];\n        if (part.to > start && part.from <= start) { break }\n      }\n      if (part.to >= end) { return inner(builder, text, style, startStyle, endStyle, title, css) }\n      inner(builder, text.slice(0, part.to - start), style, startStyle, null, title, css);\n      startStyle = null;\n      text = text.slice(part.to - start);\n      start = part.to;\n    }\n  }\n}\n\nfunction buildCollapsedSpan(builder, size, marker, ignoreWidget) {\n  var widget = !ignoreWidget && marker.widgetNode;\n  if (widget) { builder.map.push(builder.pos, builder.pos + size, widget); }\n  if (!ignoreWidget && builder.cm.display.input.needsContentAttribute) {\n    if (!widget)\n      { widget = builder.content.appendChild(document.createElement("span")); }\n    widget.setAttribute("cm-marker", marker.id);\n  }\n  if (widget) {\n    builder.cm.display.input.setUneditable(widget);\n    builder.content.appendChild(widget);\n  }\n  builder.pos += size;\n  builder.trailingSpace = false;\n}\n\n// Outputs a number of spans to make up a line, taking highlighting\n// and marked text into account.\nfunction insertLineContent(line, builder, styles) {\n  var spans = line.markedSpans, allText = line.text, at = 0;\n  if (!spans) {\n    for (var i$1 = 1; i$1 < styles.length; i$1+=2)\n      { builder.addToken(builder, allText.slice(at, at = styles[i$1]), interpretTokenStyle(styles[i$1+1], builder.cm.options)); }\n    return\n  }\n\n  var len = allText.length, pos = 0, i = 1, text = "", style, css;\n  var nextChange = 0, spanStyle, spanEndStyle, spanStartStyle, title, collapsed;\n  for (;;) {\n    if (nextChange == pos) { // Update current marker set\n      spanStyle = spanEndStyle = spanStartStyle = title = css = "";\n      collapsed = null; nextChange = Infinity;\n      var foundBookmarks = [], endStyles = (void 0);\n      for (var j = 0; j < spans.length; ++j) {\n        var sp = spans[j], m = sp.marker;\n        if (m.type == "bookmark" && sp.from == pos && m.widgetNode) {\n          foundBookmarks.push(m);\n        } else if (sp.from <= pos && (sp.to == null || sp.to > pos || m.collapsed && sp.to == pos && sp.from == pos)) {\n          if (sp.to != null && sp.to != pos && nextChange > sp.to) {\n            nextChange = sp.to;\n            spanEndStyle = "";\n          }\n          if (m.className) { spanStyle += " " + m.className; }\n          if (m.css) { css = (css ? css + ";" : "") + m.css; }\n          if (m.startStyle && sp.from == pos) { spanStartStyle += " " + m.startStyle; }\n          if (m.endStyle && sp.to == nextChange) { (endStyles || (endStyles = [])).push(m.endStyle, sp.to); }\n          if (m.title && !title) { title = m.title; }\n          if (m.collapsed && (!collapsed || compareCollapsedMarkers(collapsed.marker, m) < 0))\n            { collapsed = sp; }\n        } else if (sp.from > pos && nextChange > sp.from) {\n          nextChange = sp.from;\n        }\n      }\n      if (endStyles) { for (var j$1 = 0; j$1 < endStyles.length; j$1 += 2)\n        { if (endStyles[j$1 + 1] == nextChange) { spanEndStyle += " " + endStyles[j$1]; } } }\n\n      if (!collapsed || collapsed.from == pos) { for (var j$2 = 0; j$2 < foundBookmarks.length; ++j$2)\n        { buildCollapsedSpan(builder, 0, foundBookmarks[j$2]); } }\n      if (collapsed && (collapsed.from || 0) == pos) {\n        buildCollapsedSpan(builder, (collapsed.to == null ? len + 1 : collapsed.to) - pos,\n                           collapsed.marker, collapsed.from == null);\n        if (collapsed.to == null) { return }\n        if (collapsed.to == pos) { collapsed = false; }\n      }\n    }\n    if (pos >= len) { break }\n\n    var upto = Math.min(len, nextChange);\n    while (true) {\n      if (text) {\n        var end = pos + text.length;\n        if (!collapsed) {\n          var tokenText = end > upto ? text.slice(0, upto - pos) : text;\n          builder.addToken(builder, tokenText, style ? style + spanStyle : spanStyle,\n                           spanStartStyle, pos + tokenText.length == nextChange ? spanEndStyle : "", title, css);\n        }\n        if (end >= upto) {text = text.slice(upto - pos); pos = upto; break}\n        pos = end;\n        spanStartStyle = "";\n      }\n      text = allText.slice(at, at = styles[i++]);\n      style = interpretTokenStyle(styles[i++], builder.cm.options);\n    }\n  }\n}\n\n\n// These objects are used to represent the visible (currently drawn)\n// part of the document. A LineView may correspond to multiple\n// logical lines, if those are connected by collapsed ranges.\nfunction LineView(doc, line, lineN) {\n  // The starting line\n  this.line = line;\n  // Continuing lines, if any\n  this.rest = visualLineContinued(line);\n  // Number of logical lines in this visual line\n  this.size = this.rest ? lineNo(lst(this.rest)) - lineN + 1 : 1;\n  this.node = this.text = null;\n  this.hidden = lineIsHidden(doc, line);\n}\n\n// Create a range of LineView objects for the given lines.\nfunction buildViewArray(cm, from, to) {\n  var array = [], nextPos;\n  for (var pos = from; pos < to; pos = nextPos) {\n    var view = new LineView(cm.doc, getLine(cm.doc, pos), pos);\n    nextPos = pos + view.size;\n    array.push(view);\n  }\n  return array\n}\n\nvar operationGroup = null;\n\nfunction pushOperation(op) {\n  if (operationGroup) {\n    operationGroup.ops.push(op);\n  } else {\n    op.ownsGroup = operationGroup = {\n      ops: [op],\n      delayedCallbacks: []\n    };\n  }\n}\n\nfunction fireCallbacksForOps(group) {\n  // Calls delayed callbacks and cursorActivity handlers until no\n  // new ones appear\n  var callbacks = group.delayedCallbacks, i = 0;\n  do {\n    for (; i < callbacks.length; i++)\n      { callbacks[i].call(null); }\n    for (var j = 0; j < group.ops.length; j++) {\n      var op = group.ops[j];\n      if (op.cursorActivityHandlers)\n        { while (op.cursorActivityCalled < op.cursorActivityHandlers.length)\n          { op.cursorActivityHandlers[op.cursorActivityCalled++].call(null, op.cm); } }\n    }\n  } while (i < callbacks.length)\n}\n\nfunction finishOperation(op, endCb) {\n  var group = op.ownsGroup;\n  if (!group) { return }\n\n  try { fireCallbacksForOps(group); }\n  finally {\n    operationGroup = null;\n    endCb(group);\n  }\n}\n\nvar orphanDelayedCallbacks = null;\n\n// Often, we want to signal events at a point where we are in the\n// middle of some work, but don\'t want the handler to start calling\n// other methods on the editor, which might be in an inconsistent\n// state or simply not expect any other events to happen.\n// signalLater looks whether there are any handlers, and schedules\n// them to be executed when the last operation ends, or, if no\n// operation is active, when a timeout fires.\nfunction signalLater(emitter, type /*, values...*/) {\n  var arr = getHandlers(emitter, type);\n  if (!arr.length) { return }\n  var args = Array.prototype.slice.call(arguments, 2), list;\n  if (operationGroup) {\n    list = operationGroup.delayedCallbacks;\n  } else if (orphanDelayedCallbacks) {\n    list = orphanDelayedCallbacks;\n  } else {\n    list = orphanDelayedCallbacks = [];\n    setTimeout(fireOrphanDelayed, 0);\n  }\n  var loop = function ( i ) {\n    list.push(function () { return arr[i].apply(null, args); });\n  };\n\n  for (var i = 0; i < arr.length; ++i)\n    loop( i );\n}\n\nfunction fireOrphanDelayed() {\n  var delayed = orphanDelayedCallbacks;\n  orphanDelayedCallbacks = null;\n  for (var i = 0; i < delayed.length; ++i) { delayed[i](); }\n}\n\n// When an aspect of a line changes, a string is added to\n// lineView.changes. This updates the relevant part of the line\'s\n// DOM structure.\nfunction updateLineForChanges(cm, lineView, lineN, dims) {\n  for (var j = 0; j < lineView.changes.length; j++) {\n    var type = lineView.changes[j];\n    if (type == "text") { updateLineText(cm, lineView); }\n    else if (type == "gutter") { updateLineGutter(cm, lineView, lineN, dims); }\n    else if (type == "class") { updateLineClasses(cm, lineView); }\n    else if (type == "widget") { updateLineWidgets(cm, lineView, dims); }\n  }\n  lineView.changes = null;\n}\n\n// Lines with gutter elements, widgets or a background class need to\n// be wrapped, and have the extra elements added to the wrapper div\nfunction ensureLineWrapped(lineView) {\n  if (lineView.node == lineView.text) {\n    lineView.node = elt("div", null, null, "position: relative");\n    if (lineView.text.parentNode)\n      { lineView.text.parentNode.replaceChild(lineView.node, lineView.text); }\n    lineView.node.appendChild(lineView.text);\n    if (ie && ie_version < 8) { lineView.node.style.zIndex = 2; }\n  }\n  return lineView.node\n}\n\nfunction updateLineBackground(cm, lineView) {\n  var cls = lineView.bgClass ? lineView.bgClass + " " + (lineView.line.bgClass || "") : lineView.line.bgClass;\n  if (cls) { cls += " CodeMirror-linebackground"; }\n  if (lineView.background) {\n    if (cls) { lineView.background.className = cls; }\n    else { lineView.background.parentNode.removeChild(lineView.background); lineView.background = null; }\n  } else if (cls) {\n    var wrap = ensureLineWrapped(lineView);\n    lineView.background = wrap.insertBefore(elt("div", null, cls), wrap.firstChild);\n    cm.display.input.setUneditable(lineView.background);\n  }\n}\n\n// Wrapper around buildLineContent which will reuse the structure\n// in display.externalMeasured when possible.\nfunction getLineContent(cm, lineView) {\n  var ext = cm.display.externalMeasured;\n  if (ext && ext.line == lineView.line) {\n    cm.display.externalMeasured = null;\n    lineView.measure = ext.measure;\n    return ext.built\n  }\n  return buildLineContent(cm, lineView)\n}\n\n// Redraw the line\'s text. Interacts with the background and text\n// classes because the mode may output tokens that influence these\n// classes.\nfunction updateLineText(cm, lineView) {\n  var cls = lineView.text.className;\n  var built = getLineContent(cm, lineView);\n  if (lineView.text == lineView.node) { lineView.node = built.pre; }\n  lineView.text.parentNode.replaceChild(built.pre, lineView.text);\n  lineView.text = built.pre;\n  if (built.bgClass != lineView.bgClass || built.textClass != lineView.textClass) {\n    lineView.bgClass = built.bgClass;\n    lineView.textClass = built.textClass;\n    updateLineClasses(cm, lineView);\n  } else if (cls) {\n    lineView.text.className = cls;\n  }\n}\n\nfunction updateLineClasses(cm, lineView) {\n  updateLineBackground(cm, lineView);\n  if (lineView.line.wrapClass)\n    { ensureLineWrapped(lineView).className = lineView.line.wrapClass; }\n  else if (lineView.node != lineView.text)\n    { lineView.node.className = ""; }\n  var textClass = lineView.textClass ? lineView.textClass + " " + (lineView.line.textClass || "") : lineView.line.textClass;\n  lineView.text.className = textClass || "";\n}\n\nfunction updateLineGutter(cm, lineView, lineN, dims) {\n  if (lineView.gutter) {\n    lineView.node.removeChild(lineView.gutter);\n    lineView.gutter = null;\n  }\n  if (lineView.gutterBackground) {\n    lineView.node.removeChild(lineView.gutterBackground);\n    lineView.gutterBackground = null;\n  }\n  if (lineView.line.gutterClass) {\n    var wrap = ensureLineWrapped(lineView);\n    lineView.gutterBackground = elt("div", null, "CodeMirror-gutter-background " + lineView.line.gutterClass,\n                                    ("left: " + (cm.options.fixedGutter ? dims.fixedPos : -dims.gutterTotalWidth) + "px; width: " + (dims.gutterTotalWidth) + "px"));\n    cm.display.input.setUneditable(lineView.gutterBackground);\n    wrap.insertBefore(lineView.gutterBackground, lineView.text);\n  }\n  var markers = lineView.line.gutterMarkers;\n  if (cm.options.lineNumbers || markers) {\n    var wrap$1 = ensureLineWrapped(lineView);\n    var gutterWrap = lineView.gutter = elt("div", null, "CodeMirror-gutter-wrapper", ("left: " + (cm.options.fixedGutter ? dims.fixedPos : -dims.gutterTotalWidth) + "px"));\n    cm.display.input.setUneditable(gutterWrap);\n    wrap$1.insertBefore(gutterWrap, lineView.text);\n    if (lineView.line.gutterClass)\n      { gutterWrap.className += " " + lineView.line.gutterClass; }\n    if (cm.options.lineNumbers && (!markers || !markers["CodeMirror-linenumbers"]))\n      { lineView.lineNumber = gutterWrap.appendChild(\n        elt("div", lineNumberFor(cm.options, lineN),\n            "CodeMirror-linenumber CodeMirror-gutter-elt",\n            ("left: " + (dims.gutterLeft["CodeMirror-linenumbers"]) + "px; width: " + (cm.display.lineNumInnerWidth) + "px"))); }\n    if (markers) { for (var k = 0; k < cm.options.gutters.length; ++k) {\n      var id = cm.options.gutters[k], found = markers.hasOwnProperty(id) && markers[id];\n      if (found)\n        { gutterWrap.appendChild(elt("div", [found], "CodeMirror-gutter-elt",\n                                   ("left: " + (dims.gutterLeft[id]) + "px; width: " + (dims.gutterWidth[id]) + "px"))); }\n    } }\n  }\n}\n\nfunction updateLineWidgets(cm, lineView, dims) {\n  if (lineView.alignable) { lineView.alignable = null; }\n  for (var node = lineView.node.firstChild, next = (void 0); node; node = next) {\n    next = node.nextSibling;\n    if (node.className == "CodeMirror-linewidget")\n      { lineView.node.removeChild(node); }\n  }\n  insertLineWidgets(cm, lineView, dims);\n}\n\n// Build a line\'s DOM representation from scratch\nfunction buildLineElement(cm, lineView, lineN, dims) {\n  var built = getLineContent(cm, lineView);\n  lineView.text = lineView.node = built.pre;\n  if (built.bgClass) { lineView.bgClass = built.bgClass; }\n  if (built.textClass) { lineView.textClass = built.textClass; }\n\n  updateLineClasses(cm, lineView);\n  updateLineGutter(cm, lineView, lineN, dims);\n  insertLineWidgets(cm, lineView, dims);\n  return lineView.node\n}\n\n// A lineView may contain multiple logical lines (when merged by\n// collapsed spans). The widgets for all of them need to be drawn.\nfunction insertLineWidgets(cm, lineView, dims) {\n  insertLineWidgetsFor(cm, lineView.line, lineView, dims, true);\n  if (lineView.rest) { for (var i = 0; i < lineView.rest.length; i++)\n    { insertLineWidgetsFor(cm, lineView.rest[i], lineView, dims, false); } }\n}\n\nfunction insertLineWidgetsFor(cm, line, lineView, dims, allowAbove) {\n  if (!line.widgets) { return }\n  var wrap = ensureLineWrapped(lineView);\n  for (var i = 0, ws = line.widgets; i < ws.length; ++i) {\n    var widget = ws[i], node = elt("div", [widget.node], "CodeMirror-linewidget");\n    if (!widget.handleMouseEvents) { node.setAttribute("cm-ignore-events", "true"); }\n    positionLineWidget(widget, node, lineView, dims);\n    cm.display.input.setUneditable(node);\n    if (allowAbove && widget.above)\n      { wrap.insertBefore(node, lineView.gutter || lineView.text); }\n    else\n      { wrap.appendChild(node); }\n    signalLater(widget, "redraw");\n  }\n}\n\nfunction positionLineWidget(widget, node, lineView, dims) {\n  if (widget.noHScroll) {\n    (lineView.alignable || (lineView.alignable = [])).push(node);\n    var width = dims.wrapperWidth;\n    node.style.left = dims.fixedPos + "px";\n    if (!widget.coverGutter) {\n      width -= dims.gutterTotalWidth;\n      node.style.paddingLeft = dims.gutterTotalWidth + "px";\n    }\n    node.style.width = width + "px";\n  }\n  if (widget.coverGutter) {\n    node.style.zIndex = 5;\n    node.style.position = "relative";\n    if (!widget.noHScroll) { node.style.marginLeft = -dims.gutterTotalWidth + "px"; }\n  }\n}\n\nfunction widgetHeight(widget) {\n  if (widget.height != null) { return widget.height }\n  var cm = widget.doc.cm;\n  if (!cm) { return 0 }\n  if (!contains(document.body, widget.node)) {\n    var parentStyle = "position: relative;";\n    if (widget.coverGutter)\n      { parentStyle += "margin-left: -" + cm.display.gutters.offsetWidth + "px;"; }\n    if (widget.noHScroll)\n      { parentStyle += "width: " + cm.display.wrapper.clientWidth + "px;"; }\n    removeChildrenAndAdd(cm.display.measure, elt("div", [widget.node], null, parentStyle));\n  }\n  return widget.height = widget.node.parentNode.offsetHeight\n}\n\n// Return true when the given mouse event happened in a widget\nfunction eventInWidget(display, e) {\n  for (var n = e_target(e); n != display.wrapper; n = n.parentNode) {\n    if (!n || (n.nodeType == 1 && n.getAttribute("cm-ignore-events") == "true") ||\n        (n.parentNode == display.sizer && n != display.mover))\n      { return true }\n  }\n}\n\n// POSITION MEASUREMENT\n\nfunction paddingTop(display) {return display.lineSpace.offsetTop}\nfunction paddingVert(display) {return display.mover.offsetHeight - display.lineSpace.offsetHeight}\nfunction paddingH(display) {\n  if (display.cachedPaddingH) { return display.cachedPaddingH }\n  var e = removeChildrenAndAdd(display.measure, elt("pre", "x"));\n  var style = window.getComputedStyle ? window.getComputedStyle(e) : e.currentStyle;\n  var data = {left: parseInt(style.paddingLeft), right: parseInt(style.paddingRight)};\n  if (!isNaN(data.left) && !isNaN(data.right)) { display.cachedPaddingH = data; }\n  return data\n}\n\nfunction scrollGap(cm) { return scrollerGap - cm.display.nativeBarWidth }\nfunction displayWidth(cm) {\n  return cm.display.scroller.clientWidth - scrollGap(cm) - cm.display.barWidth\n}\nfunction displayHeight(cm) {\n  return cm.display.scroller.clientHeight - scrollGap(cm) - cm.display.barHeight\n}\n\n// Ensure the lineView.wrapping.heights array is populated. This is\n// an array of bottom offsets for the lines that make up a drawn\n// line. When lineWrapping is on, there might be more than one\n// height.\nfunction ensureLineHeights(cm, lineView, rect) {\n  var wrapping = cm.options.lineWrapping;\n  var curWidth = wrapping && displayWidth(cm);\n  if (!lineView.measure.heights || wrapping && lineView.measure.width != curWidth) {\n    var heights = lineView.measure.heights = [];\n    if (wrapping) {\n      lineView.measure.width = curWidth;\n      var rects = lineView.text.firstChild.getClientRects();\n      for (var i = 0; i < rects.length - 1; i++) {\n        var cur = rects[i], next = rects[i + 1];\n        if (Math.abs(cur.bottom - next.bottom) > 2)\n          { heights.push((cur.bottom + next.top) / 2 - rect.top); }\n      }\n    }\n    heights.push(rect.bottom - rect.top);\n  }\n}\n\n// Find a line map (mapping character offsets to text nodes) and a\n// measurement cache for the given line number. (A line view might\n// contain multiple lines when collapsed ranges are present.)\nfunction mapFromLineView(lineView, line, lineN) {\n  if (lineView.line == line)\n    { return {map: lineView.measure.map, cache: lineView.measure.cache} }\n  for (var i = 0; i < lineView.rest.length; i++)\n    { if (lineView.rest[i] == line)\n      { return {map: lineView.measure.maps[i], cache: lineView.measure.caches[i]} } }\n  for (var i$1 = 0; i$1 < lineView.rest.length; i$1++)\n    { if (lineNo(lineView.rest[i$1]) > lineN)\n      { return {map: lineView.measure.maps[i$1], cache: lineView.measure.caches[i$1], before: true} } }\n}\n\n// Render a line into the hidden node display.externalMeasured. Used\n// when measurement is needed for a line that\'s not in the viewport.\nfunction updateExternalMeasurement(cm, line) {\n  line = visualLine(line);\n  var lineN = lineNo(line);\n  var view = cm.display.externalMeasured = new LineView(cm.doc, line, lineN);\n  view.lineN = lineN;\n  var built = view.built = buildLineContent(cm, view);\n  view.text = built.pre;\n  removeChildrenAndAdd(cm.display.lineMeasure, built.pre);\n  return view\n}\n\n// Get a {top, bottom, left, right} box (in line-local coordinates)\n// for a given character.\nfunction measureChar(cm, line, ch, bias) {\n  return measureCharPrepared(cm, prepareMeasureForLine(cm, line), ch, bias)\n}\n\n// Find a line view that corresponds to the given line number.\nfunction findViewForLine(cm, lineN) {\n  if (lineN >= cm.display.viewFrom && lineN < cm.display.viewTo)\n    { return cm.display.view[findViewIndex(cm, lineN)] }\n  var ext = cm.display.externalMeasured;\n  if (ext && lineN >= ext.lineN && lineN < ext.lineN + ext.size)\n    { return ext }\n}\n\n// Measurement can be split in two steps, the set-up work that\n// applies to the whole line, and the measurement of the actual\n// character. Functions like coordsChar, that need to do a lot of\n// measurements in a row, can thus ensure that the set-up work is\n// only done once.\nfunction prepareMeasureForLine(cm, line) {\n  var lineN = lineNo(line);\n  var view = findViewForLine(cm, lineN);\n  if (view && !view.text) {\n    view = null;\n  } else if (view && view.changes) {\n    updateLineForChanges(cm, view, lineN, getDimensions(cm));\n    cm.curOp.forceUpdate = true;\n  }\n  if (!view)\n    { view = updateExternalMeasurement(cm, line); }\n\n  var info = mapFromLineView(view, line, lineN);\n  return {\n    line: line, view: view, rect: null,\n    map: info.map, cache: info.cache, before: info.before,\n    hasHeights: false\n  }\n}\n\n// Given a prepared measurement object, measures the position of an\n// actual character (or fetches it from the cache).\nfunction measureCharPrepared(cm, prepared, ch, bias, varHeight) {\n  if (prepared.before) { ch = -1; }\n  var key = ch + (bias || ""), found;\n  if (prepared.cache.hasOwnProperty(key)) {\n    found = prepared.cache[key];\n  } else {\n    if (!prepared.rect)\n      { prepared.rect = prepared.view.text.getBoundingClientRect(); }\n    if (!prepared.hasHeights) {\n      ensureLineHeights(cm, prepared.view, prepared.rect);\n      prepared.hasHeights = true;\n    }\n    found = measureCharInner(cm, prepared, ch, bias);\n    if (!found.bogus) { prepared.cache[key] = found; }\n  }\n  return {left: found.left, right: found.right,\n          top: varHeight ? found.rtop : found.top,\n          bottom: varHeight ? found.rbottom : found.bottom}\n}\n\nvar nullRect = {left: 0, right: 0, top: 0, bottom: 0};\n\nfunction nodeAndOffsetInLineMap(map$$1, ch, bias) {\n  var node, start, end, collapse, mStart, mEnd;\n  // First, search the line map for the text node corresponding to,\n  // or closest to, the target character.\n  for (var i = 0; i < map$$1.length; i += 3) {\n    mStart = map$$1[i];\n    mEnd = map$$1[i + 1];\n    if (ch < mStart) {\n      start = 0; end = 1;\n      collapse = "left";\n    } else if (ch < mEnd) {\n      start = ch - mStart;\n      end = start + 1;\n    } else if (i == map$$1.length - 3 || ch == mEnd && map$$1[i + 3] > ch) {\n      end = mEnd - mStart;\n      start = end - 1;\n      if (ch >= mEnd) { collapse = "right"; }\n    }\n    if (start != null) {\n      node = map$$1[i + 2];\n      if (mStart == mEnd && bias == (node.insertLeft ? "left" : "right"))\n        { collapse = bias; }\n      if (bias == "left" && start == 0)\n        { while (i && map$$1[i - 2] == map$$1[i - 3] && map$$1[i - 1].insertLeft) {\n          node = map$$1[(i -= 3) + 2];\n          collapse = "left";\n        } }\n      if (bias == "right" && start == mEnd - mStart)\n        { while (i < map$$1.length - 3 && map$$1[i + 3] == map$$1[i + 4] && !map$$1[i + 5].insertLeft) {\n          node = map$$1[(i += 3) + 2];\n          collapse = "right";\n        } }\n      break\n    }\n  }\n  return {node: node, start: start, end: end, collapse: collapse, coverStart: mStart, coverEnd: mEnd}\n}\n\nfunction getUsefulRect(rects, bias) {\n  var rect = nullRect;\n  if (bias == "left") { for (var i = 0; i < rects.length; i++) {\n    if ((rect = rects[i]).left != rect.right) { break }\n  } } else { for (var i$1 = rects.length - 1; i$1 >= 0; i$1--) {\n    if ((rect = rects[i$1]).left != rect.right) { break }\n  } }\n  return rect\n}\n\nfunction measureCharInner(cm, prepared, ch, bias) {\n  var place = nodeAndOffsetInLineMap(prepared.map, ch, bias);\n  var node = place.node, start = place.start, end = place.end, collapse = place.collapse;\n\n  var rect;\n  if (node.nodeType == 3) { // If it is a text node, use a range to retrieve the coordinates.\n    for (var i$1 = 0; i$1 < 4; i$1++) { // Retry a maximum of 4 times when nonsense rectangles are returned\n      while (start && isExtendingChar(prepared.line.text.charAt(place.coverStart + start))) { --start; }\n      while (place.coverStart + end < place.coverEnd && isExtendingChar(prepared.line.text.charAt(place.coverStart + end))) { ++end; }\n      if (ie && ie_version < 9 && start == 0 && end == place.coverEnd - place.coverStart)\n        { rect = node.parentNode.getBoundingClientRect(); }\n      else\n        { rect = getUsefulRect(range(node, start, end).getClientRects(), bias); }\n      if (rect.left || rect.right || start == 0) { break }\n      end = start;\n      start = start - 1;\n      collapse = "right";\n    }\n    if (ie && ie_version < 11) { rect = maybeUpdateRectForZooming(cm.display.measure, rect); }\n  } else { // If it is a widget, simply get the box for the whole widget.\n    if (start > 0) { collapse = bias = "right"; }\n    var rects;\n    if (cm.options.lineWrapping && (rects = node.getClientRects()).length > 1)\n      { rect = rects[bias == "right" ? rects.length - 1 : 0]; }\n    else\n      { rect = node.getBoundingClientRect(); }\n  }\n  if (ie && ie_version < 9 && !start && (!rect || !rect.left && !rect.right)) {\n    var rSpan = node.parentNode.getClientRects()[0];\n    if (rSpan)\n      { rect = {left: rSpan.left, right: rSpan.left + charWidth(cm.display), top: rSpan.top, bottom: rSpan.bottom}; }\n    else\n      { rect = nullRect; }\n  }\n\n  var rtop = rect.top - prepared.rect.top, rbot = rect.bottom - prepared.rect.top;\n  var mid = (rtop + rbot) / 2;\n  var heights = prepared.view.measure.heights;\n  var i = 0;\n  for (; i < heights.length - 1; i++)\n    { if (mid < heights[i]) { break } }\n  var top = i ? heights[i - 1] : 0, bot = heights[i];\n  var result = {left: (collapse == "right" ? rect.right : rect.left) - prepared.rect.left,\n                right: (collapse == "left" ? rect.left : rect.right) - prepared.rect.left,\n                top: top, bottom: bot};\n  if (!rect.left && !rect.right) { result.bogus = true; }\n  if (!cm.options.singleCursorHeightPerLine) { result.rtop = rtop; result.rbottom = rbot; }\n\n  return result\n}\n\n// Work around problem with bounding client rects on ranges being\n// returned incorrectly when zoomed on IE10 and below.\nfunction maybeUpdateRectForZooming(measure, rect) {\n  if (!window.screen || screen.logicalXDPI == null ||\n      screen.logicalXDPI == screen.deviceXDPI || !hasBadZoomedRects(measure))\n    { return rect }\n  var scaleX = screen.logicalXDPI / screen.deviceXDPI;\n  var scaleY = screen.logicalYDPI / screen.deviceYDPI;\n  return {left: rect.left * scaleX, right: rect.right * scaleX,\n          top: rect.top * scaleY, bottom: rect.bottom * scaleY}\n}\n\nfunction clearLineMeasurementCacheFor(lineView) {\n  if (lineView.measure) {\n    lineView.measure.cache = {};\n    lineView.measure.heights = null;\n    if (lineView.rest) { for (var i = 0; i < lineView.rest.length; i++)\n      { lineView.measure.caches[i] = {}; } }\n  }\n}\n\nfunction clearLineMeasurementCache(cm) {\n  cm.display.externalMeasure = null;\n  removeChildren(cm.display.lineMeasure);\n  for (var i = 0; i < cm.display.view.length; i++)\n    { clearLineMeasurementCacheFor(cm.display.view[i]); }\n}\n\nfunction clearCaches(cm) {\n  clearLineMeasurementCache(cm);\n  cm.display.cachedCharWidth = cm.display.cachedTextHeight = cm.display.cachedPaddingH = null;\n  if (!cm.options.lineWrapping) { cm.display.maxLineChanged = true; }\n  cm.display.lineNumChars = null;\n}\n\nfunction pageScrollX() {\n  // Work around https://bugs.chromium.org/p/chromium/issues/detail?id=489206\n  // which causes page_Offset and bounding client rects to use\n  // different reference viewports and invalidate our calculations.\n  if (chrome && android) { return -(document.body.getBoundingClientRect().left - parseInt(getComputedStyle(document.body).marginLeft)) }\n  return window.pageXOffset || (document.documentElement || document.body).scrollLeft\n}\nfunction pageScrollY() {\n  if (chrome && android) { return -(document.body.getBoundingClientRect().top - parseInt(getComputedStyle(document.body).marginTop)) }\n  return window.pageYOffset || (document.documentElement || document.body).scrollTop\n}\n\n// Converts a {top, bottom, left, right} box from line-local\n// coordinates into another coordinate system. Context may be one of\n// "line", "div" (display.lineDiv), "local"./null (editor), "window",\n// or "page".\nfunction intoCoordSystem(cm, lineObj, rect, context, includeWidgets) {\n  if (!includeWidgets && lineObj.widgets) { for (var i = 0; i < lineObj.widgets.length; ++i) { if (lineObj.widgets[i].above) {\n    var size = widgetHeight(lineObj.widgets[i]);\n    rect.top += size; rect.bottom += size;\n  } } }\n  if (context == "line") { return rect }\n  if (!context) { context = "local"; }\n  var yOff = heightAtLine(lineObj);\n  if (context == "local") { yOff += paddingTop(cm.display); }\n  else { yOff -= cm.display.viewOffset; }\n  if (context == "page" || context == "window") {\n    var lOff = cm.display.lineSpace.getBoundingClientRect();\n    yOff += lOff.top + (context == "window" ? 0 : pageScrollY());\n    var xOff = lOff.left + (context == "window" ? 0 : pageScrollX());\n    rect.left += xOff; rect.right += xOff;\n  }\n  rect.top += yOff; rect.bottom += yOff;\n  return rect\n}\n\n// Coverts a box from "div" coords to another coordinate system.\n// Context may be "window", "page", "div", or "local"./null.\nfunction fromCoordSystem(cm, coords, context) {\n  if (context == "div") { return coords }\n  var left = coords.left, top = coords.top;\n  // First move into "page" coordinate system\n  if (context == "page") {\n    left -= pageScrollX();\n    top -= pageScrollY();\n  } else if (context == "local" || !context) {\n    var localBox = cm.display.sizer.getBoundingClientRect();\n    left += localBox.left;\n    top += localBox.top;\n  }\n\n  var lineSpaceBox = cm.display.lineSpace.getBoundingClientRect();\n  return {left: left - lineSpaceBox.left, top: top - lineSpaceBox.top}\n}\n\nfunction charCoords(cm, pos, context, lineObj, bias) {\n  if (!lineObj) { lineObj = getLine(cm.doc, pos.line); }\n  return intoCoordSystem(cm, lineObj, measureChar(cm, lineObj, pos.ch, bias), context)\n}\n\n// Returns a box for a given cursor position, which may have an\n// \'other\' property containing the position of the secondary cursor\n// on a bidi boundary.\n// A cursor Pos(line, char, "before") is on the same visual line as `char - 1`\n// and after `char - 1` in writing order of `char - 1`\n// A cursor Pos(line, char, "after") is on the same visual line as `char`\n// and before `char` in writing order of `char`\n// Examples (upper-case letters are RTL, lower-case are LTR):\n//     Pos(0, 1, ...)\n//     before   after\n// ab     a|b     a|b\n// aB     a|B     aB|\n// Ab     |Ab     A|b\n// AB     B|A     B|A\n// Every position after the last character on a line is considered to stick\n// to the last character on the line.\nfunction cursorCoords(cm, pos, context, lineObj, preparedMeasure, varHeight) {\n  lineObj = lineObj || getLine(cm.doc, pos.line);\n  if (!preparedMeasure) { preparedMeasure = prepareMeasureForLine(cm, lineObj); }\n  function get(ch, right) {\n    var m = measureCharPrepared(cm, preparedMeasure, ch, right ? "right" : "left", varHeight);\n    if (right) { m.left = m.right; } else { m.right = m.left; }\n    return intoCoordSystem(cm, lineObj, m, context)\n  }\n  var order = getOrder(lineObj, cm.doc.direction), ch = pos.ch, sticky = pos.sticky;\n  if (ch >= lineObj.text.length) {\n    ch = lineObj.text.length;\n    sticky = "before";\n  } else if (ch <= 0) {\n    ch = 0;\n    sticky = "after";\n  }\n  if (!order) { return get(sticky == "before" ? ch - 1 : ch, sticky == "before") }\n\n  function getBidi(ch, partPos, invert) {\n    var part = order[partPos], right = (part.level % 2) != 0;\n    return get(invert ? ch - 1 : ch, right != invert)\n  }\n  var partPos = getBidiPartAt(order, ch, sticky);\n  var other = bidiOther;\n  var val = getBidi(ch, partPos, sticky == "before");\n  if (other != null) { val.other = getBidi(ch, other, sticky != "before"); }\n  return val\n}\n\n// Used to cheaply estimate the coordinates for a position. Used for\n// intermediate scroll updates.\nfunction estimateCoords(cm, pos) {\n  var left = 0;\n  pos = clipPos(cm.doc, pos);\n  if (!cm.options.lineWrapping) { left = charWidth(cm.display) * pos.ch; }\n  var lineObj = getLine(cm.doc, pos.line);\n  var top = heightAtLine(lineObj) + paddingTop(cm.display);\n  return {left: left, right: left, top: top, bottom: top + lineObj.height}\n}\n\n// Positions returned by coordsChar contain some extra information.\n// xRel is the relative x position of the input coordinates compared\n// to the found position (so xRel > 0 means the coordinates are to\n// the right of the character position, for example). When outside\n// is true, that means the coordinates lie outside the line\'s\n// vertical range.\nfunction PosWithInfo(line, ch, sticky, outside, xRel) {\n  var pos = Pos(line, ch, sticky);\n  pos.xRel = xRel;\n  if (outside) { pos.outside = true; }\n  return pos\n}\n\n// Compute the character position closest to the given coordinates.\n// Input must be lineSpace-local ("div" coordinate system).\nfunction coordsChar(cm, x, y) {\n  var doc = cm.doc;\n  y += cm.display.viewOffset;\n  if (y < 0) { return PosWithInfo(doc.first, 0, null, true, -1) }\n  var lineN = lineAtHeight(doc, y), last = doc.first + doc.size - 1;\n  if (lineN > last)\n    { return PosWithInfo(doc.first + doc.size - 1, getLine(doc, last).text.length, null, true, 1) }\n  if (x < 0) { x = 0; }\n\n  var lineObj = getLine(doc, lineN);\n  for (;;) {\n    var found = coordsCharInner(cm, lineObj, lineN, x, y);\n    var merged = collapsedSpanAtEnd(lineObj);\n    var mergedPos = merged && merged.find(0, true);\n    if (merged && (found.ch > mergedPos.from.ch || found.ch == mergedPos.from.ch && found.xRel > 0))\n      { lineN = lineNo(lineObj = mergedPos.to.line); }\n    else\n      { return found }\n  }\n}\n\nfunction wrappedLineExtent(cm, lineObj, preparedMeasure, y) {\n  var measure = function (ch) { return intoCoordSystem(cm, lineObj, measureCharPrepared(cm, preparedMeasure, ch), "line"); };\n  var end = lineObj.text.length;\n  var begin = findFirst(function (ch) { return measure(ch - 1).bottom <= y; }, end, 0);\n  end = findFirst(function (ch) { return measure(ch).top > y; }, begin, end);\n  return {begin: begin, end: end}\n}\n\nfunction wrappedLineExtentChar(cm, lineObj, preparedMeasure, target) {\n  var targetTop = intoCoordSystem(cm, lineObj, measureCharPrepared(cm, preparedMeasure, target), "line").top;\n  return wrappedLineExtent(cm, lineObj, preparedMeasure, targetTop)\n}\n\nfunction coordsCharInner(cm, lineObj, lineNo$$1, x, y) {\n  y -= heightAtLine(lineObj);\n  var begin = 0, end = lineObj.text.length;\n  var preparedMeasure = prepareMeasureForLine(cm, lineObj);\n  var pos;\n  var order = getOrder(lineObj, cm.doc.direction);\n  if (order) {\n    if (cm.options.lineWrapping) {\n      var assign;\n      ((assign = wrappedLineExtent(cm, lineObj, preparedMeasure, y), begin = assign.begin, end = assign.end, assign));\n    }\n    pos = new Pos(lineNo$$1, Math.floor(begin + (end - begin) / 2));\n    var beginLeft = cursorCoords(cm, pos, "line", lineObj, preparedMeasure).left;\n    var dir = beginLeft < x ? 1 : -1;\n    var prevDiff, diff = beginLeft - x, prevPos;\n    var steps = Math.ceil((end - begin) / 4);\n    outer: do {\n      prevDiff = diff;\n      prevPos = pos;\n      var i = 0;\n      for (; i < steps; ++i) {\n        var prevPos$1 = pos;\n        pos = moveVisually(cm, lineObj, pos, dir);\n        if (pos == null || pos.ch < begin || end <= (pos.sticky == "before" ? pos.ch - 1 : pos.ch)) {\n          pos = prevPos$1;\n          break outer\n        }\n      }\n      diff = cursorCoords(cm, pos, "line", lineObj, preparedMeasure).left - x;\n      if (steps > 1) {\n        var diff_change_per_step = Math.abs(diff - prevDiff) / steps;\n        steps = Math.min(steps, Math.ceil(Math.abs(diff) / diff_change_per_step));\n        dir = diff < 0 ? 1 : -1;\n      }\n    } while (diff != 0 && (steps > 1 || ((dir < 0) != (diff < 0) && (Math.abs(diff) <= Math.abs(prevDiff)))))\n    if (Math.abs(diff) > Math.abs(prevDiff)) {\n      if ((diff < 0) == (prevDiff < 0)) { throw new Error("Broke out of infinite loop in coordsCharInner") }\n      pos = prevPos;\n    }\n  } else {\n    var ch = findFirst(function (ch) {\n      var box = intoCoordSystem(cm, lineObj, measureCharPrepared(cm, preparedMeasure, ch), "line");\n      if (box.top > y) {\n        // For the cursor stickiness\n        end = Math.min(ch, end);\n        return true\n      }\n      else if (box.bottom <= y) { return false }\n      else if (box.left > x) { return true }\n      else if (box.right < x) { return false }\n      else { return (x - box.left < box.right - x) }\n    }, begin, end);\n    ch = skipExtendingChars(lineObj.text, ch, 1);\n    pos = new Pos(lineNo$$1, ch, ch == end ? "before" : "after");\n  }\n  var coords = cursorCoords(cm, pos, "line", lineObj, preparedMeasure);\n  if (y < coords.top || coords.bottom < y) { pos.outside = true; }\n  pos.xRel = x < coords.left ? -1 : (x > coords.right ? 1 : 0);\n  return pos\n}\n\nvar measureText;\n// Compute the default text height.\nfunction textHeight(display) {\n  if (display.cachedTextHeight != null) { return display.cachedTextHeight }\n  if (measureText == null) {\n    measureText = elt("pre");\n    // Measure a bunch of lines, for browsers that compute\n    // fractional heights.\n    for (var i = 0; i < 49; ++i) {\n      measureText.appendChild(document.createTextNode("x"));\n      measureText.appendChild(elt("br"));\n    }\n    measureText.appendChild(document.createTextNode("x"));\n  }\n  removeChildrenAndAdd(display.measure, measureText);\n  var height = measureText.offsetHeight / 50;\n  if (height > 3) { display.cachedTextHeight = height; }\n  removeChildren(display.measure);\n  return height || 1\n}\n\n// Compute the default character width.\nfunction charWidth(display) {\n  if (display.cachedCharWidth != null) { return display.cachedCharWidth }\n  var anchor = elt("span", "xxxxxxxxxx");\n  var pre = elt("pre", [anchor]);\n  removeChildrenAndAdd(display.measure, pre);\n  var rect = anchor.getBoundingClientRect(), width = (rect.right - rect.left) / 10;\n  if (width > 2) { display.cachedCharWidth = width; }\n  return width || 10\n}\n\n// Do a bulk-read of the DOM positions and sizes needed to draw the\n// view, so that we don\'t interleave reading and writing to the DOM.\nfunction getDimensions(cm) {\n  var d = cm.display, left = {}, width = {};\n  var gutterLeft = d.gutters.clientLeft;\n  for (var n = d.gutters.firstChild, i = 0; n; n = n.nextSibling, ++i) {\n    left[cm.options.gutters[i]] = n.offsetLeft + n.clientLeft + gutterLeft;\n    width[cm.options.gutters[i]] = n.clientWidth;\n  }\n  return {fixedPos: compensateForHScroll(d),\n          gutterTotalWidth: d.gutters.offsetWidth,\n          gutterLeft: left,\n          gutterWidth: width,\n          wrapperWidth: d.wrapper.clientWidth}\n}\n\n// Computes display.scroller.scrollLeft + display.gutters.offsetWidth,\n// but using getBoundingClientRect to get a sub-pixel-accurate\n// result.\nfunction compensateForHScroll(display) {\n  return display.scroller.getBoundingClientRect().left - display.sizer.getBoundingClientRect().left\n}\n\n// Returns a function that estimates the height of a line, to use as\n// first approximation until the line becomes visible (and is thus\n// properly measurable).\nfunction estimateHeight(cm) {\n  var th = textHeight(cm.display), wrapping = cm.options.lineWrapping;\n  var perLine = wrapping && Math.max(5, cm.display.scroller.clientWidth / charWidth(cm.display) - 3);\n  return function (line) {\n    if (lineIsHidden(cm.doc, line)) { return 0 }\n\n    var widgetsHeight = 0;\n    if (line.widgets) { for (var i = 0; i < line.widgets.length; i++) {\n      if (line.widgets[i].height) { widgetsHeight += line.widgets[i].height; }\n    } }\n\n    if (wrapping)\n      { return widgetsHeight + (Math.ceil(line.text.length / perLine) || 1) * th }\n    else\n      { return widgetsHeight + th }\n  }\n}\n\nfunction estimateLineHeights(cm) {\n  var doc = cm.doc, est = estimateHeight(cm);\n  doc.iter(function (line) {\n    var estHeight = est(line);\n    if (estHeight != line.height) { updateLineHeight(line, estHeight); }\n  });\n}\n\n// Given a mouse event, find the corresponding position. If liberal\n// is false, it checks whether a gutter or scrollbar was clicked,\n// and returns null if it was. forRect is used by rectangular\n// selections, and tries to estimate a character position even for\n// coordinates beyond the right of the text.\nfunction posFromMouse(cm, e, liberal, forRect) {\n  var display = cm.display;\n  if (!liberal && e_target(e).getAttribute("cm-not-content") == "true") { return null }\n\n  var x, y, space = display.lineSpace.getBoundingClientRect();\n  // Fails unpredictably on IE[67] when mouse is dragged around quickly.\n  try { x = e.clientX - space.left; y = e.clientY - space.top; }\n  catch (e) { return null }\n  var coords = coordsChar(cm, x, y), line;\n  if (forRect && coords.xRel == 1 && (line = getLine(cm.doc, coords.line).text).length == coords.ch) {\n    var colDiff = countColumn(line, line.length, cm.options.tabSize) - line.length;\n    coords = Pos(coords.line, Math.max(0, Math.round((x - paddingH(cm.display).left) / charWidth(cm.display)) - colDiff));\n  }\n  return coords\n}\n\n// Find the view element corresponding to a given line. Return null\n// when the line isn\'t visible.\nfunction findViewIndex(cm, n) {\n  if (n >= cm.display.viewTo) { return null }\n  n -= cm.display.viewFrom;\n  if (n < 0) { return null }\n  var view = cm.display.view;\n  for (var i = 0; i < view.length; i++) {\n    n -= view[i].size;\n    if (n < 0) { return i }\n  }\n}\n\nfunction updateSelection(cm) {\n  cm.display.input.showSelection(cm.display.input.prepareSelection());\n}\n\nfunction prepareSelection(cm, primary) {\n  var doc = cm.doc, result = {};\n  var curFragment = result.cursors = document.createDocumentFragment();\n  var selFragment = result.selection = document.createDocumentFragment();\n\n  for (var i = 0; i < doc.sel.ranges.length; i++) {\n    if (primary === false && i == doc.sel.primIndex) { continue }\n    var range$$1 = doc.sel.ranges[i];\n    if (range$$1.from().line >= cm.display.viewTo || range$$1.to().line < cm.display.viewFrom) { continue }\n    var collapsed = range$$1.empty();\n    if (collapsed || cm.options.showCursorWhenSelecting)\n      { drawSelectionCursor(cm, range$$1.head, curFragment); }\n    if (!collapsed)\n      { drawSelectionRange(cm, range$$1, selFragment); }\n  }\n  return result\n}\n\n// Draws a cursor for the given range\nfunction drawSelectionCursor(cm, head, output) {\n  var pos = cursorCoords(cm, head, "div", null, null, !cm.options.singleCursorHeightPerLine);\n\n  var cursor = output.appendChild(elt("div", "\\u00a0", "CodeMirror-cursor"));\n  cursor.style.left = pos.left + "px";\n  cursor.style.top = pos.top + "px";\n  cursor.style.height = Math.max(0, pos.bottom - pos.top) * cm.options.cursorHeight + "px";\n\n  if (pos.other) {\n    // Secondary cursor, shown when on a \'jump\' in bi-directional text\n    var otherCursor = output.appendChild(elt("div", "\\u00a0", "CodeMirror-cursor CodeMirror-secondarycursor"));\n    otherCursor.style.display = "";\n    otherCursor.style.left = pos.other.left + "px";\n    otherCursor.style.top = pos.other.top + "px";\n    otherCursor.style.height = (pos.other.bottom - pos.other.top) * .85 + "px";\n  }\n}\n\n// Draws the given range as a highlighted selection\nfunction drawSelectionRange(cm, range$$1, output) {\n  var display = cm.display, doc = cm.doc;\n  var fragment = document.createDocumentFragment();\n  var padding = paddingH(cm.display), leftSide = padding.left;\n  var rightSide = Math.max(display.sizerWidth, displayWidth(cm) - display.sizer.offsetLeft) - padding.right;\n\n  function add(left, top, width, bottom) {\n    if (top < 0) { top = 0; }\n    top = Math.round(top);\n    bottom = Math.round(bottom);\n    fragment.appendChild(elt("div", null, "CodeMirror-selected", ("position: absolute; left: " + left + "px;\\n                             top: " + top + "px; width: " + (width == null ? rightSide - left : width) + "px;\\n                             height: " + (bottom - top) + "px")));\n  }\n\n  function drawForLine(line, fromArg, toArg) {\n    var lineObj = getLine(doc, line);\n    var lineLen = lineObj.text.length;\n    var start, end;\n    function coords(ch, bias) {\n      return charCoords(cm, Pos(line, ch), "div", lineObj, bias)\n    }\n\n    iterateBidiSections(getOrder(lineObj, doc.direction), fromArg || 0, toArg == null ? lineLen : toArg, function (from, to, dir) {\n      var leftPos = coords(from, "left"), rightPos, left, right;\n      if (from == to) {\n        rightPos = leftPos;\n        left = right = leftPos.left;\n      } else {\n        rightPos = coords(to - 1, "right");\n        if (dir == "rtl") { var tmp = leftPos; leftPos = rightPos; rightPos = tmp; }\n        left = leftPos.left;\n        right = rightPos.right;\n      }\n      if (fromArg == null && from == 0) { left = leftSide; }\n      if (rightPos.top - leftPos.top > 3) { // Different lines, draw top part\n        add(left, leftPos.top, null, leftPos.bottom);\n        left = leftSide;\n        if (leftPos.bottom < rightPos.top) { add(left, leftPos.bottom, null, rightPos.top); }\n      }\n      if (toArg == null && to == lineLen) { right = rightSide; }\n      if (!start || leftPos.top < start.top || leftPos.top == start.top && leftPos.left < start.left)\n        { start = leftPos; }\n      if (!end || rightPos.bottom > end.bottom || rightPos.bottom == end.bottom && rightPos.right > end.right)\n        { end = rightPos; }\n      if (left < leftSide + 1) { left = leftSide; }\n      add(left, rightPos.top, right - left, rightPos.bottom);\n    });\n    return {start: start, end: end}\n  }\n\n  var sFrom = range$$1.from(), sTo = range$$1.to();\n  if (sFrom.line == sTo.line) {\n    drawForLine(sFrom.line, sFrom.ch, sTo.ch);\n  } else {\n    var fromLine = getLine(doc, sFrom.line), toLine = getLine(doc, sTo.line);\n    var singleVLine = visualLine(fromLine) == visualLine(toLine);\n    var leftEnd = drawForLine(sFrom.line, sFrom.ch, singleVLine ? fromLine.text.length + 1 : null).end;\n    var rightStart = drawForLine(sTo.line, singleVLine ? 0 : null, sTo.ch).start;\n    if (singleVLine) {\n      if (leftEnd.top < rightStart.top - 2) {\n        add(leftEnd.right, leftEnd.top, null, leftEnd.bottom);\n        add(leftSide, rightStart.top, rightStart.left, rightStart.bottom);\n      } else {\n        add(leftEnd.right, leftEnd.top, rightStart.left - leftEnd.right, leftEnd.bottom);\n      }\n    }\n    if (leftEnd.bottom < rightStart.top)\n      { add(leftSide, leftEnd.bottom, null, rightStart.top); }\n  }\n\n  output.appendChild(fragment);\n}\n\n// Cursor-blinking\nfunction restartBlink(cm) {\n  if (!cm.state.focused) { return }\n  var display = cm.display;\n  clearInterval(display.blinker);\n  var on = true;\n  display.cursorDiv.style.visibility = "";\n  if (cm.options.cursorBlinkRate > 0)\n    { display.blinker = setInterval(function () { return display.cursorDiv.style.visibility = (on = !on) ? "" : "hidden"; },\n      cm.options.cursorBlinkRate); }\n  else if (cm.options.cursorBlinkRate < 0)\n    { display.cursorDiv.style.visibility = "hidden"; }\n}\n\nfunction ensureFocus(cm) {\n  if (!cm.state.focused) { cm.display.input.focus(); onFocus(cm); }\n}\n\nfunction delayBlurEvent(cm) {\n  cm.state.delayingBlurEvent = true;\n  setTimeout(function () { if (cm.state.delayingBlurEvent) {\n    cm.state.delayingBlurEvent = false;\n    onBlur(cm);\n  } }, 100);\n}\n\nfunction onFocus(cm, e) {\n  if (cm.state.delayingBlurEvent) { cm.state.delayingBlurEvent = false; }\n\n  if (cm.options.readOnly == "nocursor") { return }\n  if (!cm.state.focused) {\n    signal(cm, "focus", cm, e);\n    cm.state.focused = true;\n    addClass(cm.display.wrapper, "CodeMirror-focused");\n    // This test prevents this from firing when a context\n    // menu is closed (since the input reset would kill the\n    // select-all detection hack)\n    if (!cm.curOp && cm.display.selForContextMenu != cm.doc.sel) {\n      cm.display.input.reset();\n      if (webkit) { setTimeout(function () { return cm.display.input.reset(true); }, 20); } // Issue #1730\n    }\n    cm.display.input.receivedFocus();\n  }\n  restartBlink(cm);\n}\nfunction onBlur(cm, e) {\n  if (cm.state.delayingBlurEvent) { return }\n\n  if (cm.state.focused) {\n    signal(cm, "blur", cm, e);\n    cm.state.focused = false;\n    rmClass(cm.display.wrapper, "CodeMirror-focused");\n  }\n  clearInterval(cm.display.blinker);\n  setTimeout(function () { if (!cm.state.focused) { cm.display.shift = false; } }, 150);\n}\n\n// Read the actual heights of the rendered lines, and update their\n// stored heights to match.\nfunction updateHeightsInViewport(cm) {\n  var display = cm.display;\n  var prevBottom = display.lineDiv.offsetTop;\n  for (var i = 0; i < display.view.length; i++) {\n    var cur = display.view[i], height = (void 0);\n    if (cur.hidden) { continue }\n    if (ie && ie_version < 8) {\n      var bot = cur.node.offsetTop + cur.node.offsetHeight;\n      height = bot - prevBottom;\n      prevBottom = bot;\n    } else {\n      var box = cur.node.getBoundingClientRect();\n      height = box.bottom - box.top;\n    }\n    var diff = cur.line.height - height;\n    if (height < 2) { height = textHeight(display); }\n    if (diff > .005 || diff < -.005) {\n      updateLineHeight(cur.line, height);\n      updateWidgetHeight(cur.line);\n      if (cur.rest) { for (var j = 0; j < cur.rest.length; j++)\n        { updateWidgetHeight(cur.rest[j]); } }\n    }\n  }\n}\n\n// Read and store the height of line widgets associated with the\n// given line.\nfunction updateWidgetHeight(line) {\n  if (line.widgets) { for (var i = 0; i < line.widgets.length; ++i)\n    { line.widgets[i].height = line.widgets[i].node.parentNode.offsetHeight; } }\n}\n\n// Compute the lines that are visible in a given viewport (defaults\n// the the current scroll position). viewport may contain top,\n// height, and ensure (see op.scrollToPos) properties.\nfunction visibleLines(display, doc, viewport) {\n  var top = viewport && viewport.top != null ? Math.max(0, viewport.top) : display.scroller.scrollTop;\n  top = Math.floor(top - paddingTop(display));\n  var bottom = viewport && viewport.bottom != null ? viewport.bottom : top + display.wrapper.clientHeight;\n\n  var from = lineAtHeight(doc, top), to = lineAtHeight(doc, bottom);\n  // Ensure is a {from: {line, ch}, to: {line, ch}} object, and\n  // forces those lines into the viewport (if possible).\n  if (viewport && viewport.ensure) {\n    var ensureFrom = viewport.ensure.from.line, ensureTo = viewport.ensure.to.line;\n    if (ensureFrom < from) {\n      from = ensureFrom;\n      to = lineAtHeight(doc, heightAtLine(getLine(doc, ensureFrom)) + display.wrapper.clientHeight);\n    } else if (Math.min(ensureTo, doc.lastLine()) >= to) {\n      from = lineAtHeight(doc, heightAtLine(getLine(doc, ensureTo)) - display.wrapper.clientHeight);\n      to = ensureTo;\n    }\n  }\n  return {from: from, to: Math.max(to, from + 1)}\n}\n\n// Re-align line numbers and gutter marks to compensate for\n// horizontal scrolling.\nfunction alignHorizontally(cm) {\n  var display = cm.display, view = display.view;\n  if (!display.alignWidgets && (!display.gutters.firstChild || !cm.options.fixedGutter)) { return }\n  var comp = compensateForHScroll(display) - display.scroller.scrollLeft + cm.doc.scrollLeft;\n  var gutterW = display.gutters.offsetWidth, left = comp + "px";\n  for (var i = 0; i < view.length; i++) { if (!view[i].hidden) {\n    if (cm.options.fixedGutter) {\n      if (view[i].gutter)\n        { view[i].gutter.style.left = left; }\n      if (view[i].gutterBackground)\n        { view[i].gutterBackground.style.left = left; }\n    }\n    var align = view[i].alignable;\n    if (align) { for (var j = 0; j < align.length; j++)\n      { align[j].style.left = left; } }\n  } }\n  if (cm.options.fixedGutter)\n    { display.gutters.style.left = (comp + gutterW) + "px"; }\n}\n\n// Used to ensure that the line number gutter is still the right\n// size for the current document size. Returns true when an update\n// is needed.\nfunction maybeUpdateLineNumberWidth(cm) {\n  if (!cm.options.lineNumbers) { return false }\n  var doc = cm.doc, last = lineNumberFor(cm.options, doc.first + doc.size - 1), display = cm.display;\n  if (last.length != display.lineNumChars) {\n    var test = display.measure.appendChild(elt("div", [elt("div", last)],\n                                               "CodeMirror-linenumber CodeMirror-gutter-elt"));\n    var innerW = test.firstChild.offsetWidth, padding = test.offsetWidth - innerW;\n    display.lineGutter.style.width = "";\n    display.lineNumInnerWidth = Math.max(innerW, display.lineGutter.offsetWidth - padding) + 1;\n    display.lineNumWidth = display.lineNumInnerWidth + padding;\n    display.lineNumChars = display.lineNumInnerWidth ? last.length : -1;\n    display.lineGutter.style.width = display.lineNumWidth + "px";\n    updateGutterSpace(cm);\n    return true\n  }\n  return false\n}\n\n// SCROLLING THINGS INTO VIEW\n\n// If an editor sits on the top or bottom of the window, partially\n// scrolled out of view, this ensures that the cursor is visible.\nfunction maybeScrollWindow(cm, rect) {\n  if (signalDOMEvent(cm, "scrollCursorIntoView")) { return }\n\n  var display = cm.display, box = display.sizer.getBoundingClientRect(), doScroll = null;\n  if (rect.top + box.top < 0) { doScroll = true; }\n  else if (rect.bottom + box.top > (window.innerHeight || document.documentElement.clientHeight)) { doScroll = false; }\n  if (doScroll != null && !phantom) {\n    var scrollNode = elt("div", "\\u200b", null, ("position: absolute;\\n                         top: " + (rect.top - display.viewOffset - paddingTop(cm.display)) + "px;\\n                         height: " + (rect.bottom - rect.top + scrollGap(cm) + display.barHeight) + "px;\\n                         left: " + (rect.left) + "px; width: " + (Math.max(2, rect.right - rect.left)) + "px;"));\n    cm.display.lineSpace.appendChild(scrollNode);\n    scrollNode.scrollIntoView(doScroll);\n    cm.display.lineSpace.removeChild(scrollNode);\n  }\n}\n\n// Scroll a given position into view (immediately), verifying that\n// it actually became visible (as line heights are accurately\n// measured, the position of something may \'drift\' during drawing).\nfunction scrollPosIntoView(cm, pos, end, margin) {\n  if (margin == null) { margin = 0; }\n  var rect;\n  if (!cm.options.lineWrapping && pos == end) {\n    // Set pos and end to the cursor positions around the character pos sticks to\n    // If pos.sticky == "before", that is around pos.ch - 1, otherwise around pos.ch\n    // If pos == Pos(_, 0, "before"), pos and end are unchanged\n    pos = pos.ch ? Pos(pos.line, pos.sticky == "before" ? pos.ch - 1 : pos.ch, "after") : pos;\n    end = pos.sticky == "before" ? Pos(pos.line, pos.ch + 1, "before") : pos;\n  }\n  for (var limit = 0; limit < 5; limit++) {\n    var changed = false;\n    var coords = cursorCoords(cm, pos);\n    var endCoords = !end || end == pos ? coords : cursorCoords(cm, end);\n    rect = {left: Math.min(coords.left, endCoords.left),\n            top: Math.min(coords.top, endCoords.top) - margin,\n            right: Math.max(coords.left, endCoords.left),\n            bottom: Math.max(coords.bottom, endCoords.bottom) + margin};\n    var scrollPos = calculateScrollPos(cm, rect);\n    var startTop = cm.doc.scrollTop, startLeft = cm.doc.scrollLeft;\n    if (scrollPos.scrollTop != null) {\n      updateScrollTop(cm, scrollPos.scrollTop);\n      if (Math.abs(cm.doc.scrollTop - startTop) > 1) { changed = true; }\n    }\n    if (scrollPos.scrollLeft != null) {\n      setScrollLeft(cm, scrollPos.scrollLeft);\n      if (Math.abs(cm.doc.scrollLeft - startLeft) > 1) { changed = true; }\n    }\n    if (!changed) { break }\n  }\n  return rect\n}\n\n// Scroll a given set of coordinates into view (immediately).\nfunction scrollIntoView(cm, rect) {\n  var scrollPos = calculateScrollPos(cm, rect);\n  if (scrollPos.scrollTop != null) { updateScrollTop(cm, scrollPos.scrollTop); }\n  if (scrollPos.scrollLeft != null) { setScrollLeft(cm, scrollPos.scrollLeft); }\n}\n\n// Calculate a new scroll position needed to scroll the given\n// rectangle into view. Returns an object with scrollTop and\n// scrollLeft properties. When these are undefined, the\n// vertical/horizontal position does not need to be adjusted.\nfunction calculateScrollPos(cm, rect) {\n  var display = cm.display, snapMargin = textHeight(cm.display);\n  if (rect.top < 0) { rect.top = 0; }\n  var screentop = cm.curOp && cm.curOp.scrollTop != null ? cm.curOp.scrollTop : display.scroller.scrollTop;\n  var screen = displayHeight(cm), result = {};\n  if (rect.bottom - rect.top > screen) { rect.bottom = rect.top + screen; }\n  var docBottom = cm.doc.height + paddingVert(display);\n  var atTop = rect.top < snapMargin, atBottom = rect.bottom > docBottom - snapMargin;\n  if (rect.top < screentop) {\n    result.scrollTop = atTop ? 0 : rect.top;\n  } else if (rect.bottom > screentop + screen) {\n    var newTop = Math.min(rect.top, (atBottom ? docBottom : rect.bottom) - screen);\n    if (newTop != screentop) { result.scrollTop = newTop; }\n  }\n\n  var screenleft = cm.curOp && cm.curOp.scrollLeft != null ? cm.curOp.scrollLeft : display.scroller.scrollLeft;\n  var screenw = displayWidth(cm) - (cm.options.fixedGutter ? display.gutters.offsetWidth : 0);\n  var tooWide = rect.right - rect.left > screenw;\n  if (tooWide) { rect.right = rect.left + screenw; }\n  if (rect.left < 10)\n    { result.scrollLeft = 0; }\n  else if (rect.left < screenleft)\n    { result.scrollLeft = Math.max(0, rect.left - (tooWide ? 0 : 10)); }\n  else if (rect.right > screenw + screenleft - 3)\n    { result.scrollLeft = rect.right + (tooWide ? 0 : 10) - screenw; }\n  return result\n}\n\n// Store a relative adjustment to the scroll position in the current\n// operation (to be applied when the operation finishes).\nfunction addToScrollTop(cm, top) {\n  if (top == null) { return }\n  resolveScrollToPos(cm);\n  cm.curOp.scrollTop = (cm.curOp.scrollTop == null ? cm.doc.scrollTop : cm.curOp.scrollTop) + top;\n}\n\n// Make sure that at the end of the operation the current cursor is\n// shown.\nfunction ensureCursorVisible(cm) {\n  resolveScrollToPos(cm);\n  var cur = cm.getCursor();\n  cm.curOp.scrollToPos = {from: cur, to: cur, margin: cm.options.cursorScrollMargin};\n}\n\nfunction scrollToCoords(cm, x, y) {\n  if (x != null || y != null) { resolveScrollToPos(cm); }\n  if (x != null) { cm.curOp.scrollLeft = x; }\n  if (y != null) { cm.curOp.scrollTop = y; }\n}\n\nfunction scrollToRange(cm, range$$1) {\n  resolveScrollToPos(cm);\n  cm.curOp.scrollToPos = range$$1;\n}\n\n// When an operation has its scrollToPos property set, and another\n// scroll action is applied before the end of the operation, this\n// \'simulates\' scrolling that position into view in a cheap way, so\n// that the effect of intermediate scroll commands is not ignored.\nfunction resolveScrollToPos(cm) {\n  var range$$1 = cm.curOp.scrollToPos;\n  if (range$$1) {\n    cm.curOp.scrollToPos = null;\n    var from = estimateCoords(cm, range$$1.from), to = estimateCoords(cm, range$$1.to);\n    scrollToCoordsRange(cm, from, to, range$$1.margin);\n  }\n}\n\nfunction scrollToCoordsRange(cm, from, to, margin) {\n  var sPos = calculateScrollPos(cm, {\n    left: Math.min(from.left, to.left),\n    top: Math.min(from.top, to.top) - margin,\n    right: Math.max(from.right, to.right),\n    bottom: Math.max(from.bottom, to.bottom) + margin\n  });\n  scrollToCoords(cm, sPos.scrollLeft, sPos.scrollTop);\n}\n\n// Sync the scrollable area and scrollbars, ensure the viewport\n// covers the visible area.\nfunction updateScrollTop(cm, val) {\n  if (Math.abs(cm.doc.scrollTop - val) < 2) { return }\n  if (!gecko) { updateDisplaySimple(cm, {top: val}); }\n  setScrollTop(cm, val, true);\n  if (gecko) { updateDisplaySimple(cm); }\n  startWorker(cm, 100);\n}\n\nfunction setScrollTop(cm, val, forceScroll) {\n  val = Math.min(cm.display.scroller.scrollHeight - cm.display.scroller.clientHeight, val);\n  if (cm.display.scroller.scrollTop == val && !forceScroll) { return }\n  cm.doc.scrollTop = val;\n  cm.display.scrollbars.setScrollTop(val);\n  if (cm.display.scroller.scrollTop != val) { cm.display.scroller.scrollTop = val; }\n}\n\n// Sync scroller and scrollbar, ensure the gutter elements are\n// aligned.\nfunction setScrollLeft(cm, val, isScroller, forceScroll) {\n  val = Math.min(val, cm.display.scroller.scrollWidth - cm.display.scroller.clientWidth);\n  if ((isScroller ? val == cm.doc.scrollLeft : Math.abs(cm.doc.scrollLeft - val) < 2) && !forceScroll) { return }\n  cm.doc.scrollLeft = val;\n  alignHorizontally(cm);\n  if (cm.display.scroller.scrollLeft != val) { cm.display.scroller.scrollLeft = val; }\n  cm.display.scrollbars.setScrollLeft(val);\n}\n\n// SCROLLBARS\n\n// Prepare DOM reads needed to update the scrollbars. Done in one\n// shot to minimize update/measure roundtrips.\nfunction measureForScrollbars(cm) {\n  var d = cm.display, gutterW = d.gutters.offsetWidth;\n  var docH = Math.round(cm.doc.height + paddingVert(cm.display));\n  return {\n    clientHeight: d.scroller.clientHeight,\n    viewHeight: d.wrapper.clientHeight,\n    scrollWidth: d.scroller.scrollWidth, clientWidth: d.scroller.clientWidth,\n    viewWidth: d.wrapper.clientWidth,\n    barLeft: cm.options.fixedGutter ? gutterW : 0,\n    docHeight: docH,\n    scrollHeight: docH + scrollGap(cm) + d.barHeight,\n    nativeBarWidth: d.nativeBarWidth,\n    gutterWidth: gutterW\n  }\n}\n\nvar NativeScrollbars = function(place, scroll, cm) {\n  this.cm = cm;\n  var vert = this.vert = elt("div", [elt("div", null, null, "min-width: 1px")], "CodeMirror-vscrollbar");\n  var horiz = this.horiz = elt("div", [elt("div", null, null, "height: 100%; min-height: 1px")], "CodeMirror-hscrollbar");\n  place(vert); place(horiz);\n\n  on(vert, "scroll", function () {\n    if (vert.clientHeight) { scroll(vert.scrollTop, "vertical"); }\n  });\n  on(horiz, "scroll", function () {\n    if (horiz.clientWidth) { scroll(horiz.scrollLeft, "horizontal"); }\n  });\n\n  this.checkedZeroWidth = false;\n  // Need to set a minimum width to see the scrollbar on IE7 (but must not set it on IE8).\n  if (ie && ie_version < 8) { this.horiz.style.minHeight = this.vert.style.minWidth = "18px"; }\n};\n\nNativeScrollbars.prototype.update = function (measure) {\n  var needsH = measure.scrollWidth > measure.clientWidth + 1;\n  var needsV = measure.scrollHeight > measure.clientHeight + 1;\n  var sWidth = measure.nativeBarWidth;\n\n  if (needsV) {\n    this.vert.style.display = "block";\n    this.vert.style.bottom = needsH ? sWidth + "px" : "0";\n    var totalHeight = measure.viewHeight - (needsH ? sWidth : 0);\n    // A bug in IE8 can cause this value to be negative, so guard it.\n    this.vert.firstChild.style.height =\n      Math.max(0, measure.scrollHeight - measure.clientHeight + totalHeight) + "px";\n  } else {\n    this.vert.style.display = "";\n    this.vert.firstChild.style.height = "0";\n  }\n\n  if (needsH) {\n    this.horiz.style.display = "block";\n    this.horiz.style.right = needsV ? sWidth + "px" : "0";\n    this.horiz.style.left = measure.barLeft + "px";\n    var totalWidth = measure.viewWidth - measure.barLeft - (needsV ? sWidth : 0);\n    this.horiz.firstChild.style.width =\n      Math.max(0, measure.scrollWidth - measure.clientWidth + totalWidth) + "px";\n  } else {\n    this.horiz.style.display = "";\n    this.horiz.firstChild.style.width = "0";\n  }\n\n  if (!this.checkedZeroWidth && measure.clientHeight > 0) {\n    if (sWidth == 0) { this.zeroWidthHack(); }\n    this.checkedZeroWidth = true;\n  }\n\n  return {right: needsV ? sWidth : 0, bottom: needsH ? sWidth : 0}\n};\n\nNativeScrollbars.prototype.setScrollLeft = function (pos) {\n  if (this.horiz.scrollLeft != pos) { this.horiz.scrollLeft = pos; }\n  if (this.disableHoriz) { this.enableZeroWidthBar(this.horiz, this.disableHoriz, "horiz"); }\n};\n\nNativeScrollbars.prototype.setScrollTop = function (pos) {\n  if (this.vert.scrollTop != pos) { this.vert.scrollTop = pos; }\n  if (this.disableVert) { this.enableZeroWidthBar(this.vert, this.disableVert, "vert"); }\n};\n\nNativeScrollbars.prototype.zeroWidthHack = function () {\n  var w = mac && !mac_geMountainLion ? "12px" : "18px";\n  this.horiz.style.height = this.vert.style.width = w;\n  this.horiz.style.pointerEvents = this.vert.style.pointerEvents = "none";\n  this.disableHoriz = new Delayed;\n  this.disableVert = new Delayed;\n};\n\nNativeScrollbars.prototype.enableZeroWidthBar = function (bar, delay, type) {\n  bar.style.pointerEvents = "auto";\n  function maybeDisable() {\n    // To find out whether the scrollbar is still visible, we\n    // check whether the element under the pixel in the bottom\n    // right corner of the scrollbar box is the scrollbar box\n    // itself (when the bar is still visible) or its filler child\n    // (when the bar is hidden). If it is still visible, we keep\n    // it enabled, if it\'s hidden, we disable pointer events.\n    var box = bar.getBoundingClientRect();\n    var elt$$1 = type == "vert" ? document.elementFromPoint(box.right - 1, (box.top + box.bottom) / 2)\n        : document.elementFromPoint((box.right + box.left) / 2, box.bottom - 1);\n    if (elt$$1 != bar) { bar.style.pointerEvents = "none"; }\n    else { delay.set(1000, maybeDisable); }\n  }\n  delay.set(1000, maybeDisable);\n};\n\nNativeScrollbars.prototype.clear = function () {\n  var parent = this.horiz.parentNode;\n  parent.removeChild(this.horiz);\n  parent.removeChild(this.vert);\n};\n\nvar NullScrollbars = function () {};\n\nNullScrollbars.prototype.update = function () { return {bottom: 0, right: 0} };\nNullScrollbars.prototype.setScrollLeft = function () {};\nNullScrollbars.prototype.setScrollTop = function () {};\nNullScrollbars.prototype.clear = function () {};\n\nfunction updateScrollbars(cm, measure) {\n  if (!measure) { measure = measureForScrollbars(cm); }\n  var startWidth = cm.display.barWidth, startHeight = cm.display.barHeight;\n  updateScrollbarsInner(cm, measure);\n  for (var i = 0; i < 4 && startWidth != cm.display.barWidth || startHeight != cm.display.barHeight; i++) {\n    if (startWidth != cm.display.barWidth && cm.options.lineWrapping)\n      { updateHeightsInViewport(cm); }\n    updateScrollbarsInner(cm, measureForScrollbars(cm));\n    startWidth = cm.display.barWidth; startHeight = cm.display.barHeight;\n  }\n}\n\n// Re-synchronize the fake scrollbars with the actual size of the\n// content.\nfunction updateScrollbarsInner(cm, measure) {\n  var d = cm.display;\n  var sizes = d.scrollbars.update(measure);\n\n  d.sizer.style.paddingRight = (d.barWidth = sizes.right) + "px";\n  d.sizer.style.paddingBottom = (d.barHeight = sizes.bottom) + "px";\n  d.heightForcer.style.borderBottom = sizes.bottom + "px solid transparent";\n\n  if (sizes.right && sizes.bottom) {\n    d.scrollbarFiller.style.display = "block";\n    d.scrollbarFiller.style.height = sizes.bottom + "px";\n    d.scrollbarFiller.style.width = sizes.right + "px";\n  } else { d.scrollbarFiller.style.display = ""; }\n  if (sizes.bottom && cm.options.coverGutterNextToScrollbar && cm.options.fixedGutter) {\n    d.gutterFiller.style.display = "block";\n    d.gutterFiller.style.height = sizes.bottom + "px";\n    d.gutterFiller.style.width = measure.gutterWidth + "px";\n  } else { d.gutterFiller.style.display = ""; }\n}\n\nvar scrollbarModel = {"native": NativeScrollbars, "null": NullScrollbars};\n\nfunction initScrollbars(cm) {\n  if (cm.display.scrollbars) {\n    cm.display.scrollbars.clear();\n    if (cm.display.scrollbars.addClass)\n      { rmClass(cm.display.wrapper, cm.display.scrollbars.addClass); }\n  }\n\n  cm.display.scrollbars = new scrollbarModel[cm.options.scrollbarStyle](function (node) {\n    cm.display.wrapper.insertBefore(node, cm.display.scrollbarFiller);\n    // Prevent clicks in the scrollbars from killing focus\n    on(node, "mousedown", function () {\n      if (cm.state.focused) { setTimeout(function () { return cm.display.input.focus(); }, 0); }\n    });\n    node.setAttribute("cm-not-content", "true");\n  }, function (pos, axis) {\n    if (axis == "horizontal") { setScrollLeft(cm, pos); }\n    else { updateScrollTop(cm, pos); }\n  }, cm);\n  if (cm.display.scrollbars.addClass)\n    { addClass(cm.display.wrapper, cm.display.scrollbars.addClass); }\n}\n\n// Operations are used to wrap a series of changes to the editor\n// state in such a way that each change won\'t have to update the\n// cursor and display (which would be awkward, slow, and\n// error-prone). Instead, display updates are batched and then all\n// combined and executed at once.\n\nvar nextOpId = 0;\n// Start a new operation.\nfunction startOperation(cm) {\n  cm.curOp = {\n    cm: cm,\n    viewChanged: false,      // Flag that indicates that lines might need to be redrawn\n    startHeight: cm.doc.height, // Used to detect need to update scrollbar\n    forceUpdate: false,      // Used to force a redraw\n    updateInput: null,       // Whether to reset the input textarea\n    typing: false,           // Whether this reset should be careful to leave existing text (for compositing)\n    changeObjs: null,        // Accumulated changes, for firing change events\n    cursorActivityHandlers: null, // Set of handlers to fire cursorActivity on\n    cursorActivityCalled: 0, // Tracks which cursorActivity handlers have been called already\n    selectionChanged: false, // Whether the selection needs to be redrawn\n    updateMaxLine: false,    // Set when the widest line needs to be determined anew\n    scrollLeft: null, scrollTop: null, // Intermediate scroll position, not pushed to DOM yet\n    scrollToPos: null,       // Used to scroll to a specific position\n    focus: false,\n    id: ++nextOpId           // Unique ID\n  };\n  pushOperation(cm.curOp);\n}\n\n// Finish an operation, updating the display and signalling delayed events\nfunction endOperation(cm) {\n  var op = cm.curOp;\n  finishOperation(op, function (group) {\n    for (var i = 0; i < group.ops.length; i++)\n      { group.ops[i].cm.curOp = null; }\n    endOperations(group);\n  });\n}\n\n// The DOM updates done when an operation finishes are batched so\n// that the minimum number of relayouts are required.\nfunction endOperations(group) {\n  var ops = group.ops;\n  for (var i = 0; i < ops.length; i++) // Read DOM\n    { endOperation_R1(ops[i]); }\n  for (var i$1 = 0; i$1 < ops.length; i$1++) // Write DOM (maybe)\n    { endOperation_W1(ops[i$1]); }\n  for (var i$2 = 0; i$2 < ops.length; i$2++) // Read DOM\n    { endOperation_R2(ops[i$2]); }\n  for (var i$3 = 0; i$3 < ops.length; i$3++) // Write DOM (maybe)\n    { endOperation_W2(ops[i$3]); }\n  for (var i$4 = 0; i$4 < ops.length; i$4++) // Read DOM\n    { endOperation_finish(ops[i$4]); }\n}\n\nfunction endOperation_R1(op) {\n  var cm = op.cm, display = cm.display;\n  maybeClipScrollbars(cm);\n  if (op.updateMaxLine) { findMaxLine(cm); }\n\n  op.mustUpdate = op.viewChanged || op.forceUpdate || op.scrollTop != null ||\n    op.scrollToPos && (op.scrollToPos.from.line < display.viewFrom ||\n                       op.scrollToPos.to.line >= display.viewTo) ||\n    display.maxLineChanged && cm.options.lineWrapping;\n  op.update = op.mustUpdate &&\n    new DisplayUpdate(cm, op.mustUpdate && {top: op.scrollTop, ensure: op.scrollToPos}, op.forceUpdate);\n}\n\nfunction endOperation_W1(op) {\n  op.updatedDisplay = op.mustUpdate && updateDisplayIfNeeded(op.cm, op.update);\n}\n\nfunction endOperation_R2(op) {\n  var cm = op.cm, display = cm.display;\n  if (op.updatedDisplay) { updateHeightsInViewport(cm); }\n\n  op.barMeasure = measureForScrollbars(cm);\n\n  // If the max line changed since it was last measured, measure it,\n  // and ensure the document\'s width matches it.\n  // updateDisplay_W2 will use these properties to do the actual resizing\n  if (display.maxLineChanged && !cm.options.lineWrapping) {\n    op.adjustWidthTo = measureChar(cm, display.maxLine, display.maxLine.text.length).left + 3;\n    cm.display.sizerWidth = op.adjustWidthTo;\n    op.barMeasure.scrollWidth =\n      Math.max(display.scroller.clientWidth, display.sizer.offsetLeft + op.adjustWidthTo + scrollGap(cm) + cm.display.barWidth);\n    op.maxScrollLeft = Math.max(0, display.sizer.offsetLeft + op.adjustWidthTo - displayWidth(cm));\n  }\n\n  if (op.updatedDisplay || op.selectionChanged)\n    { op.preparedSelection = display.input.prepareSelection(op.focus); }\n}\n\nfunction endOperation_W2(op) {\n  var cm = op.cm;\n\n  if (op.adjustWidthTo != null) {\n    cm.display.sizer.style.minWidth = op.adjustWidthTo + "px";\n    if (op.maxScrollLeft < cm.doc.scrollLeft)\n      { setScrollLeft(cm, Math.min(cm.display.scroller.scrollLeft, op.maxScrollLeft), true); }\n    cm.display.maxLineChanged = false;\n  }\n\n  var takeFocus = op.focus && op.focus == activeElt() && (!document.hasFocus || document.hasFocus());\n  if (op.preparedSelection)\n    { cm.display.input.showSelection(op.preparedSelection, takeFocus); }\n  if (op.updatedDisplay || op.startHeight != cm.doc.height)\n    { updateScrollbars(cm, op.barMeasure); }\n  if (op.updatedDisplay)\n    { setDocumentHeight(cm, op.barMeasure); }\n\n  if (op.selectionChanged) { restartBlink(cm); }\n\n  if (cm.state.focused && op.updateInput)\n    { cm.display.input.reset(op.typing); }\n  if (takeFocus) { ensureFocus(op.cm); }\n}\n\nfunction endOperation_finish(op) {\n  var cm = op.cm, display = cm.display, doc = cm.doc;\n\n  if (op.updatedDisplay) { postUpdateDisplay(cm, op.update); }\n\n  // Abort mouse wheel delta measurement, when scrolling explicitly\n  if (display.wheelStartX != null && (op.scrollTop != null || op.scrollLeft != null || op.scrollToPos))\n    { display.wheelStartX = display.wheelStartY = null; }\n\n  // Propagate the scroll position to the actual DOM scroller\n  if (op.scrollTop != null) { setScrollTop(cm, op.scrollTop, op.forceScroll); }\n\n  if (op.scrollLeft != null) { setScrollLeft(cm, op.scrollLeft, true, true); }\n  // If we need to scroll a specific position into view, do so.\n  if (op.scrollToPos) {\n    var rect = scrollPosIntoView(cm, clipPos(doc, op.scrollToPos.from),\n                                 clipPos(doc, op.scrollToPos.to), op.scrollToPos.margin);\n    maybeScrollWindow(cm, rect);\n  }\n\n  // Fire events for markers that are hidden/unidden by editing or\n  // undoing\n  var hidden = op.maybeHiddenMarkers, unhidden = op.maybeUnhiddenMarkers;\n  if (hidden) { for (var i = 0; i < hidden.length; ++i)\n    { if (!hidden[i].lines.length) { signal(hidden[i], "hide"); } } }\n  if (unhidden) { for (var i$1 = 0; i$1 < unhidden.length; ++i$1)\n    { if (unhidden[i$1].lines.length) { signal(unhidden[i$1], "unhide"); } } }\n\n  if (display.wrapper.offsetHeight)\n    { doc.scrollTop = cm.display.scroller.scrollTop; }\n\n  // Fire change events, and delayed event handlers\n  if (op.changeObjs)\n    { signal(cm, "changes", cm, op.changeObjs); }\n  if (op.update)\n    { op.update.finish(); }\n}\n\n// Run the given function in an operation\nfunction runInOp(cm, f) {\n  if (cm.curOp) { return f() }\n  startOperation(cm);\n  try { return f() }\n  finally { endOperation(cm); }\n}\n// Wraps a function in an operation. Returns the wrapped function.\nfunction operation(cm, f) {\n  return function() {\n    if (cm.curOp) { return f.apply(cm, arguments) }\n    startOperation(cm);\n    try { return f.apply(cm, arguments) }\n    finally { endOperation(cm); }\n  }\n}\n// Used to add methods to editor and doc instances, wrapping them in\n// operations.\nfunction methodOp(f) {\n  return function() {\n    if (this.curOp) { return f.apply(this, arguments) }\n    startOperation(this);\n    try { return f.apply(this, arguments) }\n    finally { endOperation(this); }\n  }\n}\nfunction docMethodOp(f) {\n  return function() {\n    var cm = this.cm;\n    if (!cm || cm.curOp) { return f.apply(this, arguments) }\n    startOperation(cm);\n    try { return f.apply(this, arguments) }\n    finally { endOperation(cm); }\n  }\n}\n\n// Updates the display.view data structure for a given change to the\n// document. From and to are in pre-change coordinates. Lendiff is\n// the amount of lines added or subtracted by the change. This is\n// used for changes that span multiple lines, or change the way\n// lines are divided into visual lines. regLineChange (below)\n// registers single-line changes.\nfunction regChange(cm, from, to, lendiff) {\n  if (from == null) { from = cm.doc.first; }\n  if (to == null) { to = cm.doc.first + cm.doc.size; }\n  if (!lendiff) { lendiff = 0; }\n\n  var display = cm.display;\n  if (lendiff && to < display.viewTo &&\n      (display.updateLineNumbers == null || display.updateLineNumbers > from))\n    { display.updateLineNumbers = from; }\n\n  cm.curOp.viewChanged = true;\n\n  if (from >= display.viewTo) { // Change after\n    if (sawCollapsedSpans && visualLineNo(cm.doc, from) < display.viewTo)\n      { resetView(cm); }\n  } else if (to <= display.viewFrom) { // Change before\n    if (sawCollapsedSpans && visualLineEndNo(cm.doc, to + lendiff) > display.viewFrom) {\n      resetView(cm);\n    } else {\n      display.viewFrom += lendiff;\n      display.viewTo += lendiff;\n    }\n  } else if (from <= display.viewFrom && to >= display.viewTo) { // Full overlap\n    resetView(cm);\n  } else if (from <= display.viewFrom) { // Top overlap\n    var cut = viewCuttingPoint(cm, to, to + lendiff, 1);\n    if (cut) {\n      display.view = display.view.slice(cut.index);\n      display.viewFrom = cut.lineN;\n      display.viewTo += lendiff;\n    } else {\n      resetView(cm);\n    }\n  } else if (to >= display.viewTo) { // Bottom overlap\n    var cut$1 = viewCuttingPoint(cm, from, from, -1);\n    if (cut$1) {\n      display.view = display.view.slice(0, cut$1.index);\n      display.viewTo = cut$1.lineN;\n    } else {\n      resetView(cm);\n    }\n  } else { // Gap in the middle\n    var cutTop = viewCuttingPoint(cm, from, from, -1);\n    var cutBot = viewCuttingPoint(cm, to, to + lendiff, 1);\n    if (cutTop && cutBot) {\n      display.view = display.view.slice(0, cutTop.index)\n        .concat(buildViewArray(cm, cutTop.lineN, cutBot.lineN))\n        .concat(display.view.slice(cutBot.index));\n      display.viewTo += lendiff;\n    } else {\n      resetView(cm);\n    }\n  }\n\n  var ext = display.externalMeasured;\n  if (ext) {\n    if (to < ext.lineN)\n      { ext.lineN += lendiff; }\n    else if (from < ext.lineN + ext.size)\n      { display.externalMeasured = null; }\n  }\n}\n\n// Register a change to a single line. Type must be one of "text",\n// "gutter", "class", "widget"\nfunction regLineChange(cm, line, type) {\n  cm.curOp.viewChanged = true;\n  var display = cm.display, ext = cm.display.externalMeasured;\n  if (ext && line >= ext.lineN && line < ext.lineN + ext.size)\n    { display.externalMeasured = null; }\n\n  if (line < display.viewFrom || line >= display.viewTo) { return }\n  var lineView = display.view[findViewIndex(cm, line)];\n  if (lineView.node == null) { return }\n  var arr = lineView.changes || (lineView.changes = []);\n  if (indexOf(arr, type) == -1) { arr.push(type); }\n}\n\n// Clear the view.\nfunction resetView(cm) {\n  cm.display.viewFrom = cm.display.viewTo = cm.doc.first;\n  cm.display.view = [];\n  cm.display.viewOffset = 0;\n}\n\nfunction viewCuttingPoint(cm, oldN, newN, dir) {\n  var index = findViewIndex(cm, oldN), diff, view = cm.display.view;\n  if (!sawCollapsedSpans || newN == cm.doc.first + cm.doc.size)\n    { return {index: index, lineN: newN} }\n  var n = cm.display.viewFrom;\n  for (var i = 0; i < index; i++)\n    { n += view[i].size; }\n  if (n != oldN) {\n    if (dir > 0) {\n      if (index == view.length - 1) { return null }\n      diff = (n + view[index].size) - oldN;\n      index++;\n    } else {\n      diff = n - oldN;\n    }\n    oldN += diff; newN += diff;\n  }\n  while (visualLineNo(cm.doc, newN) != newN) {\n    if (index == (dir < 0 ? 0 : view.length - 1)) { return null }\n    newN += dir * view[index - (dir < 0 ? 1 : 0)].size;\n    index += dir;\n  }\n  return {index: index, lineN: newN}\n}\n\n// Force the view to cover a given range, adding empty view element\n// or clipping off existing ones as needed.\nfunction adjustView(cm, from, to) {\n  var display = cm.display, view = display.view;\n  if (view.length == 0 || from >= display.viewTo || to <= display.viewFrom) {\n    display.view = buildViewArray(cm, from, to);\n    display.viewFrom = from;\n  } else {\n    if (display.viewFrom > from)\n      { display.view = buildViewArray(cm, from, display.viewFrom).concat(display.view); }\n    else if (display.viewFrom < from)\n      { display.view = display.view.slice(findViewIndex(cm, from)); }\n    display.viewFrom = from;\n    if (display.viewTo < to)\n      { display.view = display.view.concat(buildViewArray(cm, display.viewTo, to)); }\n    else if (display.viewTo > to)\n      { display.view = display.view.slice(0, findViewIndex(cm, to)); }\n  }\n  display.viewTo = to;\n}\n\n// Count the number of lines in the view whose DOM representation is\n// out of date (or nonexistent).\nfunction countDirtyView(cm) {\n  var view = cm.display.view, dirty = 0;\n  for (var i = 0; i < view.length; i++) {\n    var lineView = view[i];\n    if (!lineView.hidden && (!lineView.node || lineView.changes)) { ++dirty; }\n  }\n  return dirty\n}\n\n// HIGHLIGHT WORKER\n\nfunction startWorker(cm, time) {\n  if (cm.doc.highlightFrontier < cm.display.viewTo)\n    { cm.state.highlight.set(time, bind(highlightWorker, cm)); }\n}\n\nfunction highlightWorker(cm) {\n  var doc = cm.doc;\n  if (doc.highlightFrontier >= cm.display.viewTo) { return }\n  var end = +new Date + cm.options.workTime;\n  var context = getContextBefore(cm, doc.highlightFrontier);\n  var changedLines = [];\n\n  doc.iter(context.line, Math.min(doc.first + doc.size, cm.display.viewTo + 500), function (line) {\n    if (context.line >= cm.display.viewFrom) { // Visible\n      var oldStyles = line.styles;\n      var resetState = line.text.length > cm.options.maxHighlightLength ? copyState(doc.mode, context.state) : null;\n      var highlighted = highlightLine(cm, line, context, true);\n      if (resetState) { context.state = resetState; }\n      line.styles = highlighted.styles;\n      var oldCls = line.styleClasses, newCls = highlighted.classes;\n      if (newCls) { line.styleClasses = newCls; }\n      else if (oldCls) { line.styleClasses = null; }\n      var ischange = !oldStyles || oldStyles.length != line.styles.length ||\n        oldCls != newCls && (!oldCls || !newCls || oldCls.bgClass != newCls.bgClass || oldCls.textClass != newCls.textClass);\n      for (var i = 0; !ischange && i < oldStyles.length; ++i) { ischange = oldStyles[i] != line.styles[i]; }\n      if (ischange) { changedLines.push(context.line); }\n      line.stateAfter = context.save();\n      context.nextLine();\n    } else {\n      if (line.text.length <= cm.options.maxHighlightLength)\n        { processLine(cm, line.text, context); }\n      line.stateAfter = context.line % 5 == 0 ? context.save() : null;\n      context.nextLine();\n    }\n    if (+new Date > end) {\n      startWorker(cm, cm.options.workDelay);\n      return true\n    }\n  });\n  doc.highlightFrontier = context.line;\n  doc.modeFrontier = Math.max(doc.modeFrontier, context.line);\n  if (changedLines.length) { runInOp(cm, function () {\n    for (var i = 0; i < changedLines.length; i++)\n      { regLineChange(cm, changedLines[i], "text"); }\n  }); }\n}\n\n// DISPLAY DRAWING\n\nvar DisplayUpdate = function(cm, viewport, force) {\n  var display = cm.display;\n\n  this.viewport = viewport;\n  // Store some values that we\'ll need later (but don\'t want to force a relayout for)\n  this.visible = visibleLines(display, cm.doc, viewport);\n  this.editorIsHidden = !display.wrapper.offsetWidth;\n  this.wrapperHeight = display.wrapper.clientHeight;\n  this.wrapperWidth = display.wrapper.clientWidth;\n  this.oldDisplayWidth = displayWidth(cm);\n  this.force = force;\n  this.dims = getDimensions(cm);\n  this.events = [];\n};\n\nDisplayUpdate.prototype.signal = function (emitter, type) {\n  if (hasHandler(emitter, type))\n    { this.events.push(arguments); }\n};\nDisplayUpdate.prototype.finish = function () {\n    var this$1 = this;\n\n  for (var i = 0; i < this.events.length; i++)\n    { signal.apply(null, this$1.events[i]); }\n};\n\nfunction maybeClipScrollbars(cm) {\n  var display = cm.display;\n  if (!display.scrollbarsClipped && display.scroller.offsetWidth) {\n    display.nativeBarWidth = display.scroller.offsetWidth - display.scroller.clientWidth;\n    display.heightForcer.style.height = scrollGap(cm) + "px";\n    display.sizer.style.marginBottom = -display.nativeBarWidth + "px";\n    display.sizer.style.borderRightWidth = scrollGap(cm) + "px";\n    display.scrollbarsClipped = true;\n  }\n}\n\nfunction selectionSnapshot(cm) {\n  if (cm.hasFocus()) { return null }\n  var active = activeElt();\n  if (!active || !contains(cm.display.lineDiv, active)) { return null }\n  var result = {activeElt: active};\n  if (window.getSelection) {\n    var sel = window.getSelection();\n    if (sel.anchorNode && sel.extend && contains(cm.display.lineDiv, sel.anchorNode)) {\n      result.anchorNode = sel.anchorNode;\n      result.anchorOffset = sel.anchorOffset;\n      result.focusNode = sel.focusNode;\n      result.focusOffset = sel.focusOffset;\n    }\n  }\n  return result\n}\n\nfunction restoreSelection(snapshot) {\n  if (!snapshot || !snapshot.activeElt || snapshot.activeElt == activeElt()) { return }\n  snapshot.activeElt.focus();\n  if (snapshot.anchorNode && contains(document.body, snapshot.anchorNode) && contains(document.body, snapshot.focusNode)) {\n    var sel = window.getSelection(), range$$1 = document.createRange();\n    range$$1.setEnd(snapshot.anchorNode, snapshot.anchorOffset);\n    range$$1.collapse(false);\n    sel.removeAllRanges();\n    sel.addRange(range$$1);\n    sel.extend(snapshot.focusNode, snapshot.focusOffset);\n  }\n}\n\n// Does the actual updating of the line display. Bails out\n// (returning false) when there is nothing to be done and forced is\n// false.\nfunction updateDisplayIfNeeded(cm, update) {\n  var display = cm.display, doc = cm.doc;\n\n  if (update.editorIsHidden) {\n    resetView(cm);\n    return false\n  }\n\n  // Bail out if the visible area is already rendered and nothing changed.\n  if (!update.force &&\n      update.visible.from >= display.viewFrom && update.visible.to <= display.viewTo &&\n      (display.updateLineNumbers == null || display.updateLineNumbers >= display.viewTo) &&\n      display.renderedView == display.view && countDirtyView(cm) == 0)\n    { return false }\n\n  if (maybeUpdateLineNumberWidth(cm)) {\n    resetView(cm);\n    update.dims = getDimensions(cm);\n  }\n\n  // Compute a suitable new viewport (from & to)\n  var end = doc.first + doc.size;\n  var from = Math.max(update.visible.from - cm.options.viewportMargin, doc.first);\n  var to = Math.min(end, update.visible.to + cm.options.viewportMargin);\n  if (display.viewFrom < from && from - display.viewFrom < 20) { from = Math.max(doc.first, display.viewFrom); }\n  if (display.viewTo > to && display.viewTo - to < 20) { to = Math.min(end, display.viewTo); }\n  if (sawCollapsedSpans) {\n    from = visualLineNo(cm.doc, from);\n    to = visualLineEndNo(cm.doc, to);\n  }\n\n  var different = from != display.viewFrom || to != display.viewTo ||\n    display.lastWrapHeight != update.wrapperHeight || display.lastWrapWidth != update.wrapperWidth;\n  adjustView(cm, from, to);\n\n  display.viewOffset = heightAtLine(getLine(cm.doc, display.viewFrom));\n  // Position the mover div to align with the current scroll position\n  cm.display.mover.style.top = display.viewOffset + "px";\n\n  var toUpdate = countDirtyView(cm);\n  if (!different && toUpdate == 0 && !update.force && display.renderedView == display.view &&\n      (display.updateLineNumbers == null || display.updateLineNumbers >= display.viewTo))\n    { return false }\n\n  // For big changes, we hide the enclosing element during the\n  // update, since that speeds up the operations on most browsers.\n  var selSnapshot = selectionSnapshot(cm);\n  if (toUpdate > 4) { display.lineDiv.style.display = "none"; }\n  patchDisplay(cm, display.updateLineNumbers, update.dims);\n  if (toUpdate > 4) { display.lineDiv.style.display = ""; }\n  display.renderedView = display.view;\n  // There might have been a widget with a focused element that got\n  // hidden or updated, if so re-focus it.\n  restoreSelection(selSnapshot);\n\n  // Prevent selection and cursors from interfering with the scroll\n  // width and height.\n  removeChildren(display.cursorDiv);\n  removeChildren(display.selectionDiv);\n  display.gutters.style.height = display.sizer.style.minHeight = 0;\n\n  if (different) {\n    display.lastWrapHeight = update.wrapperHeight;\n    display.lastWrapWidth = update.wrapperWidth;\n    startWorker(cm, 400);\n  }\n\n  display.updateLineNumbers = null;\n\n  return true\n}\n\nfunction postUpdateDisplay(cm, update) {\n  var viewport = update.viewport;\n\n  for (var first = true;; first = false) {\n    if (!first || !cm.options.lineWrapping || update.oldDisplayWidth == displayWidth(cm)) {\n      // Clip forced viewport to actual scrollable area.\n      if (viewport && viewport.top != null)\n        { viewport = {top: Math.min(cm.doc.height + paddingVert(cm.display) - displayHeight(cm), viewport.top)}; }\n      // Updated line heights might result in the drawn area not\n      // actually covering the viewport. Keep looping until it does.\n      update.visible = visibleLines(cm.display, cm.doc, viewport);\n      if (update.visible.from >= cm.display.viewFrom && update.visible.to <= cm.display.viewTo)\n        { break }\n    }\n    if (!updateDisplayIfNeeded(cm, update)) { break }\n    updateHeightsInViewport(cm);\n    var barMeasure = measureForScrollbars(cm);\n    updateSelection(cm);\n    updateScrollbars(cm, barMeasure);\n    setDocumentHeight(cm, barMeasure);\n    update.force = false;\n  }\n\n  update.signal(cm, "update", cm);\n  if (cm.display.viewFrom != cm.display.reportedViewFrom || cm.display.viewTo != cm.display.reportedViewTo) {\n    update.signal(cm, "viewportChange", cm, cm.display.viewFrom, cm.display.viewTo);\n    cm.display.reportedViewFrom = cm.display.viewFrom; cm.display.reportedViewTo = cm.display.viewTo;\n  }\n}\n\nfunction updateDisplaySimple(cm, viewport) {\n  var update = new DisplayUpdate(cm, viewport);\n  if (updateDisplayIfNeeded(cm, update)) {\n    updateHeightsInViewport(cm);\n    postUpdateDisplay(cm, update);\n    var barMeasure = measureForScrollbars(cm);\n    updateSelection(cm);\n    updateScrollbars(cm, barMeasure);\n    setDocumentHeight(cm, barMeasure);\n    update.finish();\n  }\n}\n\n// Sync the actual display DOM structure with display.view, removing\n// nodes for lines that are no longer in view, and creating the ones\n// that are not there yet, and updating the ones that are out of\n// date.\nfunction patchDisplay(cm, updateNumbersFrom, dims) {\n  var display = cm.display, lineNumbers = cm.options.lineNumbers;\n  var container = display.lineDiv, cur = container.firstChild;\n\n  function rm(node) {\n    var next = node.nextSibling;\n    // Works around a throw-scroll bug in OS X Webkit\n    if (webkit && mac && cm.display.currentWheelTarget == node)\n      { node.style.display = "none"; }\n    else\n      { node.parentNode.removeChild(node); }\n    return next\n  }\n\n  var view = display.view, lineN = display.viewFrom;\n  // Loop over the elements in the view, syncing cur (the DOM nodes\n  // in display.lineDiv) with the view as we go.\n  for (var i = 0; i < view.length; i++) {\n    var lineView = view[i];\n    if (lineView.hidden) {\n    } else if (!lineView.node || lineView.node.parentNode != container) { // Not drawn yet\n      var node = buildLineElement(cm, lineView, lineN, dims);\n      container.insertBefore(node, cur);\n    } else { // Already drawn\n      while (cur != lineView.node) { cur = rm(cur); }\n      var updateNumber = lineNumbers && updateNumbersFrom != null &&\n        updateNumbersFrom <= lineN && lineView.lineNumber;\n      if (lineView.changes) {\n        if (indexOf(lineView.changes, "gutter") > -1) { updateNumber = false; }\n        updateLineForChanges(cm, lineView, lineN, dims);\n      }\n      if (updateNumber) {\n        removeChildren(lineView.lineNumber);\n        lineView.lineNumber.appendChild(document.createTextNode(lineNumberFor(cm.options, lineN)));\n      }\n      cur = lineView.node.nextSibling;\n    }\n    lineN += lineView.size;\n  }\n  while (cur) { cur = rm(cur); }\n}\n\nfunction updateGutterSpace(cm) {\n  var width = cm.display.gutters.offsetWidth;\n  cm.display.sizer.style.marginLeft = width + "px";\n}\n\nfunction setDocumentHeight(cm, measure) {\n  cm.display.sizer.style.minHeight = measure.docHeight + "px";\n  cm.display.heightForcer.style.top = measure.docHeight + "px";\n  cm.display.gutters.style.height = (measure.docHeight + cm.display.barHeight + scrollGap(cm)) + "px";\n}\n\n// Rebuild the gutter elements, ensure the margin to the left of the\n// code matches their width.\nfunction updateGutters(cm) {\n  var gutters = cm.display.gutters, specs = cm.options.gutters;\n  removeChildren(gutters);\n  var i = 0;\n  for (; i < specs.length; ++i) {\n    var gutterClass = specs[i];\n    var gElt = gutters.appendChild(elt("div", null, "CodeMirror-gutter " + gutterClass));\n    if (gutterClass == "CodeMirror-linenumbers") {\n      cm.display.lineGutter = gElt;\n      gElt.style.width = (cm.display.lineNumWidth || 1) + "px";\n    }\n  }\n  gutters.style.display = i ? "" : "none";\n  updateGutterSpace(cm);\n}\n\n// Make sure the gutters options contains the element\n// "CodeMirror-linenumbers" when the lineNumbers option is true.\nfunction setGuttersForLineNumbers(options) {\n  var found = indexOf(options.gutters, "CodeMirror-linenumbers");\n  if (found == -1 && options.lineNumbers) {\n    options.gutters = options.gutters.concat(["CodeMirror-linenumbers"]);\n  } else if (found > -1 && !options.lineNumbers) {\n    options.gutters = options.gutters.slice(0);\n    options.gutters.splice(found, 1);\n  }\n}\n\n// Since the delta values reported on mouse wheel events are\n// unstandardized between browsers and even browser versions, and\n// generally horribly unpredictable, this code starts by measuring\n// the scroll effect that the first few mouse wheel events have,\n// and, from that, detects the way it can convert deltas to pixel\n// offsets afterwards.\n//\n// The reason we want to know the amount a wheel event will scroll\n// is that it gives us a chance to update the display before the\n// actual scrolling happens, reducing flickering.\n\nvar wheelSamples = 0;\nvar wheelPixelsPerUnit = null;\n// Fill in a browser-detected starting value on browsers where we\n// know one. These don\'t have to be accurate -- the result of them\n// being wrong would just be a slight flicker on the first wheel\n// scroll (if it is large enough).\nif (ie) { wheelPixelsPerUnit = -.53; }\nelse if (gecko) { wheelPixelsPerUnit = 15; }\nelse if (chrome) { wheelPixelsPerUnit = -.7; }\nelse if (safari) { wheelPixelsPerUnit = -1/3; }\n\nfunction wheelEventDelta(e) {\n  var dx = e.wheelDeltaX, dy = e.wheelDeltaY;\n  if (dx == null && e.detail && e.axis == e.HORIZONTAL_AXIS) { dx = e.detail; }\n  if (dy == null && e.detail && e.axis == e.VERTICAL_AXIS) { dy = e.detail; }\n  else if (dy == null) { dy = e.wheelDelta; }\n  return {x: dx, y: dy}\n}\nfunction wheelEventPixels(e) {\n  var delta = wheelEventDelta(e);\n  delta.x *= wheelPixelsPerUnit;\n  delta.y *= wheelPixelsPerUnit;\n  return delta\n}\n\nfunction onScrollWheel(cm, e) {\n  var delta = wheelEventDelta(e), dx = delta.x, dy = delta.y;\n\n  var display = cm.display, scroll = display.scroller;\n  // Quit if there\'s nothing to scroll here\n  var canScrollX = scroll.scrollWidth > scroll.clientWidth;\n  var canScrollY = scroll.scrollHeight > scroll.clientHeight;\n  if (!(dx && canScrollX || dy && canScrollY)) { return }\n\n  // Webkit browsers on OS X abort momentum scrolls when the target\n  // of the scroll event is removed from the scrollable element.\n  // This hack (see related code in patchDisplay) makes sure the\n  // element is kept around.\n  if (dy && mac && webkit) {\n    outer: for (var cur = e.target, view = display.view; cur != scroll; cur = cur.parentNode) {\n      for (var i = 0; i < view.length; i++) {\n        if (view[i].node == cur) {\n          cm.display.currentWheelTarget = cur;\n          break outer\n        }\n      }\n    }\n  }\n\n  // On some browsers, horizontal scrolling will cause redraws to\n  // happen before the gutter has been realigned, causing it to\n  // wriggle around in a most unseemly way. When we have an\n  // estimated pixels/delta value, we just handle horizontal\n  // scrolling entirely here. It\'ll be slightly off from native, but\n  // better than glitching out.\n  if (dx && !gecko && !presto && wheelPixelsPerUnit != null) {\n    if (dy && canScrollY)\n      { updateScrollTop(cm, Math.max(0, scroll.scrollTop + dy * wheelPixelsPerUnit)); }\n    setScrollLeft(cm, Math.max(0, scroll.scrollLeft + dx * wheelPixelsPerUnit));\n    // Only prevent default scrolling if vertical scrolling is\n    // actually possible. Otherwise, it causes vertical scroll\n    // jitter on OSX trackpads when deltaX is small and deltaY\n    // is large (issue #3579)\n    if (!dy || (dy && canScrollY))\n      { e_preventDefault(e); }\n    display.wheelStartX = null; // Abort measurement, if in progress\n    return\n  }\n\n  // \'Project\' the visible viewport to cover the area that is being\n  // scrolled into view (if we know enough to estimate it).\n  if (dy && wheelPixelsPerUnit != null) {\n    var pixels = dy * wheelPixelsPerUnit;\n    var top = cm.doc.scrollTop, bot = top + display.wrapper.clientHeight;\n    if (pixels < 0) { top = Math.max(0, top + pixels - 50); }\n    else { bot = Math.min(cm.doc.height, bot + pixels + 50); }\n    updateDisplaySimple(cm, {top: top, bottom: bot});\n  }\n\n  if (wheelSamples < 20) {\n    if (display.wheelStartX == null) {\n      display.wheelStartX = scroll.scrollLeft; display.wheelStartY = scroll.scrollTop;\n      display.wheelDX = dx; display.wheelDY = dy;\n      setTimeout(function () {\n        if (display.wheelStartX == null) { return }\n        var movedX = scroll.scrollLeft - display.wheelStartX;\n        var movedY = scroll.scrollTop - display.wheelStartY;\n        var sample = (movedY && display.wheelDY && movedY / display.wheelDY) ||\n          (movedX && display.wheelDX && movedX / display.wheelDX);\n        display.wheelStartX = display.wheelStartY = null;\n        if (!sample) { return }\n        wheelPixelsPerUnit = (wheelPixelsPerUnit * wheelSamples + sample) / (wheelSamples + 1);\n        ++wheelSamples;\n      }, 200);\n    } else {\n      display.wheelDX += dx; display.wheelDY += dy;\n    }\n  }\n}\n\n// Selection objects are immutable. A new one is created every time\n// the selection changes. A selection is one or more non-overlapping\n// (and non-touching) ranges, sorted, and an integer that indicates\n// which one is the primary selection (the one that\'s scrolled into\n// view, that getCursor returns, etc).\nvar Selection = function(ranges, primIndex) {\n  this.ranges = ranges;\n  this.primIndex = primIndex;\n};\n\nSelection.prototype.primary = function () { return this.ranges[this.primIndex] };\n\nSelection.prototype.equals = function (other) {\n    var this$1 = this;\n\n  if (other == this) { return true }\n  if (other.primIndex != this.primIndex || other.ranges.length != this.ranges.length) { return false }\n  for (var i = 0; i < this.ranges.length; i++) {\n    var here = this$1.ranges[i], there = other.ranges[i];\n    if (!equalCursorPos(here.anchor, there.anchor) || !equalCursorPos(here.head, there.head)) { return false }\n  }\n  return true\n};\n\nSelection.prototype.deepCopy = function () {\n    var this$1 = this;\n\n  var out = [];\n  for (var i = 0; i < this.ranges.length; i++)\n    { out[i] = new Range(copyPos(this$1.ranges[i].anchor), copyPos(this$1.ranges[i].head)); }\n  return new Selection(out, this.primIndex)\n};\n\nSelection.prototype.somethingSelected = function () {\n    var this$1 = this;\n\n  for (var i = 0; i < this.ranges.length; i++)\n    { if (!this$1.ranges[i].empty()) { return true } }\n  return false\n};\n\nSelection.prototype.contains = function (pos, end) {\n    var this$1 = this;\n\n  if (!end) { end = pos; }\n  for (var i = 0; i < this.ranges.length; i++) {\n    var range = this$1.ranges[i];\n    if (cmp(end, range.from()) >= 0 && cmp(pos, range.to()) <= 0)\n      { return i }\n  }\n  return -1\n};\n\nvar Range = function(anchor, head) {\n  this.anchor = anchor; this.head = head;\n};\n\nRange.prototype.from = function () { return minPos(this.anchor, this.head) };\nRange.prototype.to = function () { return maxPos(this.anchor, this.head) };\nRange.prototype.empty = function () { return this.head.line == this.anchor.line && this.head.ch == this.anchor.ch };\n\n// Take an unsorted, potentially overlapping set of ranges, and\n// build a selection out of it. \'Consumes\' ranges array (modifying\n// it).\nfunction normalizeSelection(ranges, primIndex) {\n  var prim = ranges[primIndex];\n  ranges.sort(function (a, b) { return cmp(a.from(), b.from()); });\n  primIndex = indexOf(ranges, prim);\n  for (var i = 1; i < ranges.length; i++) {\n    var cur = ranges[i], prev = ranges[i - 1];\n    if (cmp(prev.to(), cur.from()) >= 0) {\n      var from = minPos(prev.from(), cur.from()), to = maxPos(prev.to(), cur.to());\n      var inv = prev.empty() ? cur.from() == cur.head : prev.from() == prev.head;\n      if (i <= primIndex) { --primIndex; }\n      ranges.splice(--i, 2, new Range(inv ? to : from, inv ? from : to));\n    }\n  }\n  return new Selection(ranges, primIndex)\n}\n\nfunction simpleSelection(anchor, head) {\n  return new Selection([new Range(anchor, head || anchor)], 0)\n}\n\n// Compute the position of the end of a change (its \'to\' property\n// refers to the pre-change end).\nfunction changeEnd(change) {\n  if (!change.text) { return change.to }\n  return Pos(change.from.line + change.text.length - 1,\n             lst(change.text).length + (change.text.length == 1 ? change.from.ch : 0))\n}\n\n// Adjust a position to refer to the post-change position of the\n// same text, or the end of the change if the change covers it.\nfunction adjustForChange(pos, change) {\n  if (cmp(pos, change.from) < 0) { return pos }\n  if (cmp(pos, change.to) <= 0) { return changeEnd(change) }\n\n  var line = pos.line + change.text.length - (change.to.line - change.from.line) - 1, ch = pos.ch;\n  if (pos.line == change.to.line) { ch += changeEnd(change).ch - change.to.ch; }\n  return Pos(line, ch)\n}\n\nfunction computeSelAfterChange(doc, change) {\n  var out = [];\n  for (var i = 0; i < doc.sel.ranges.length; i++) {\n    var range = doc.sel.ranges[i];\n    out.push(new Range(adjustForChange(range.anchor, change),\n                       adjustForChange(range.head, change)));\n  }\n  return normalizeSelection(out, doc.sel.primIndex)\n}\n\nfunction offsetPos(pos, old, nw) {\n  if (pos.line == old.line)\n    { return Pos(nw.line, pos.ch - old.ch + nw.ch) }\n  else\n    { return Pos(nw.line + (pos.line - old.line), pos.ch) }\n}\n\n// Used by replaceSelections to allow moving the selection to the\n// start or around the replaced test. Hint may be "start" or "around".\nfunction computeReplacedSel(doc, changes, hint) {\n  var out = [];\n  var oldPrev = Pos(doc.first, 0), newPrev = oldPrev;\n  for (var i = 0; i < changes.length; i++) {\n    var change = changes[i];\n    var from = offsetPos(change.from, oldPrev, newPrev);\n    var to = offsetPos(changeEnd(change), oldPrev, newPrev);\n    oldPrev = change.to;\n    newPrev = to;\n    if (hint == "around") {\n      var range = doc.sel.ranges[i], inv = cmp(range.head, range.anchor) < 0;\n      out[i] = new Range(inv ? to : from, inv ? from : to);\n    } else {\n      out[i] = new Range(from, from);\n    }\n  }\n  return new Selection(out, doc.sel.primIndex)\n}\n\n// Used to get the editor into a consistent state again when options change.\n\nfunction loadMode(cm) {\n  cm.doc.mode = getMode(cm.options, cm.doc.modeOption);\n  resetModeState(cm);\n}\n\nfunction resetModeState(cm) {\n  cm.doc.iter(function (line) {\n    if (line.stateAfter) { line.stateAfter = null; }\n    if (line.styles) { line.styles = null; }\n  });\n  cm.doc.modeFrontier = cm.doc.highlightFrontier = cm.doc.first;\n  startWorker(cm, 100);\n  cm.state.modeGen++;\n  if (cm.curOp) { regChange(cm); }\n}\n\n// DOCUMENT DATA STRUCTURE\n\n// By default, updates that start and end at the beginning of a line\n// are treated specially, in order to make the association of line\n// widgets and marker elements with the text behave more intuitive.\nfunction isWholeLineUpdate(doc, change) {\n  return change.from.ch == 0 && change.to.ch == 0 && lst(change.text) == "" &&\n    (!doc.cm || doc.cm.options.wholeLineUpdateBefore)\n}\n\n// Perform a change on the document data structure.\nfunction updateDoc(doc, change, markedSpans, estimateHeight$$1) {\n  function spansFor(n) {return markedSpans ? markedSpans[n] : null}\n  function update(line, text, spans) {\n    updateLine(line, text, spans, estimateHeight$$1);\n    signalLater(line, "change", line, change);\n  }\n  function linesFor(start, end) {\n    var result = [];\n    for (var i = start; i < end; ++i)\n      { result.push(new Line(text[i], spansFor(i), estimateHeight$$1)); }\n    return result\n  }\n\n  var from = change.from, to = change.to, text = change.text;\n  var firstLine = getLine(doc, from.line), lastLine = getLine(doc, to.line);\n  var lastText = lst(text), lastSpans = spansFor(text.length - 1), nlines = to.line - from.line;\n\n  // Adjust the line structure\n  if (change.full) {\n    doc.insert(0, linesFor(0, text.length));\n    doc.remove(text.length, doc.size - text.length);\n  } else if (isWholeLineUpdate(doc, change)) {\n    // This is a whole-line replace. Treated specially to make\n    // sure line objects move the way they are supposed to.\n    var added = linesFor(0, text.length - 1);\n    update(lastLine, lastLine.text, lastSpans);\n    if (nlines) { doc.remove(from.line, nlines); }\n    if (added.length) { doc.insert(from.line, added); }\n  } else if (firstLine == lastLine) {\n    if (text.length == 1) {\n      update(firstLine, firstLine.text.slice(0, from.ch) + lastText + firstLine.text.slice(to.ch), lastSpans);\n    } else {\n      var added$1 = linesFor(1, text.length - 1);\n      added$1.push(new Line(lastText + firstLine.text.slice(to.ch), lastSpans, estimateHeight$$1));\n      update(firstLine, firstLine.text.slice(0, from.ch) + text[0], spansFor(0));\n      doc.insert(from.line + 1, added$1);\n    }\n  } else if (text.length == 1) {\n    update(firstLine, firstLine.text.slice(0, from.ch) + text[0] + lastLine.text.slice(to.ch), spansFor(0));\n    doc.remove(from.line + 1, nlines);\n  } else {\n    update(firstLine, firstLine.text.slice(0, from.ch) + text[0], spansFor(0));\n    update(lastLine, lastText + lastLine.text.slice(to.ch), lastSpans);\n    var added$2 = linesFor(1, text.length - 1);\n    if (nlines > 1) { doc.remove(from.line + 1, nlines - 1); }\n    doc.insert(from.line + 1, added$2);\n  }\n\n  signalLater(doc, "change", doc, change);\n}\n\n// Call f for all linked documents.\nfunction linkedDocs(doc, f, sharedHistOnly) {\n  function propagate(doc, skip, sharedHist) {\n    if (doc.linked) { for (var i = 0; i < doc.linked.length; ++i) {\n      var rel = doc.linked[i];\n      if (rel.doc == skip) { continue }\n      var shared = sharedHist && rel.sharedHist;\n      if (sharedHistOnly && !shared) { continue }\n      f(rel.doc, shared);\n      propagate(rel.doc, doc, shared);\n    } }\n  }\n  propagate(doc, null, true);\n}\n\n// Attach a document to an editor.\nfunction attachDoc(cm, doc) {\n  if (doc.cm) { throw new Error("This document is already in use.") }\n  cm.doc = doc;\n  doc.cm = cm;\n  estimateLineHeights(cm);\n  loadMode(cm);\n  setDirectionClass(cm);\n  if (!cm.options.lineWrapping) { findMaxLine(cm); }\n  cm.options.mode = doc.modeOption;\n  regChange(cm);\n}\n\nfunction setDirectionClass(cm) {\n  (cm.doc.direction == "rtl" ? addClass : rmClass)(cm.display.lineDiv, "CodeMirror-rtl");\n}\n\nfunction directionChanged(cm) {\n  runInOp(cm, function () {\n    setDirectionClass(cm);\n    regChange(cm);\n  });\n}\n\nfunction History(startGen) {\n  // Arrays of change events and selections. Doing something adds an\n  // event to done and clears undo. Undoing moves events from done\n  // to undone, redoing moves them in the other direction.\n  this.done = []; this.undone = [];\n  this.undoDepth = Infinity;\n  // Used to track when changes can be merged into a single undo\n  // event\n  this.lastModTime = this.lastSelTime = 0;\n  this.lastOp = this.lastSelOp = null;\n  this.lastOrigin = this.lastSelOrigin = null;\n  // Used by the isClean() method\n  this.generation = this.maxGeneration = startGen || 1;\n}\n\n// Create a history change event from an updateDoc-style change\n// object.\nfunction historyChangeFromChange(doc, change) {\n  var histChange = {from: copyPos(change.from), to: changeEnd(change), text: getBetween(doc, change.from, change.to)};\n  attachLocalSpans(doc, histChange, change.from.line, change.to.line + 1);\n  linkedDocs(doc, function (doc) { return attachLocalSpans(doc, histChange, change.from.line, change.to.line + 1); }, true);\n  return histChange\n}\n\n// Pop all selection events off the end of a history array. Stop at\n// a change event.\nfunction clearSelectionEvents(array) {\n  while (array.length) {\n    var last = lst(array);\n    if (last.ranges) { array.pop(); }\n    else { break }\n  }\n}\n\n// Find the top change event in the history. Pop off selection\n// events that are in the way.\nfunction lastChangeEvent(hist, force) {\n  if (force) {\n    clearSelectionEvents(hist.done);\n    return lst(hist.done)\n  } else if (hist.done.length && !lst(hist.done).ranges) {\n    return lst(hist.done)\n  } else if (hist.done.length > 1 && !hist.done[hist.done.length - 2].ranges) {\n    hist.done.pop();\n    return lst(hist.done)\n  }\n}\n\n// Register a change in the history. Merges changes that are within\n// a single operation, or are close together with an origin that\n// allows merging (starting with "+") into a single event.\nfunction addChangeToHistory(doc, change, selAfter, opId) {\n  var hist = doc.history;\n  hist.undone.length = 0;\n  var time = +new Date, cur;\n  var last;\n\n  if ((hist.lastOp == opId ||\n       hist.lastOrigin == change.origin && change.origin &&\n       ((change.origin.charAt(0) == "+" && doc.cm && hist.lastModTime > time - doc.cm.options.historyEventDelay) ||\n        change.origin.charAt(0) == "*")) &&\n      (cur = lastChangeEvent(hist, hist.lastOp == opId))) {\n    // Merge this change into the last event\n    last = lst(cur.changes);\n    if (cmp(change.from, change.to) == 0 && cmp(change.from, last.to) == 0) {\n      // Optimized case for simple insertion -- don\'t want to add\n      // new changesets for every character typed\n      last.to = changeEnd(change);\n    } else {\n      // Add new sub-event\n      cur.changes.push(historyChangeFromChange(doc, change));\n    }\n  } else {\n    // Can not be merged, start a new event.\n    var before = lst(hist.done);\n    if (!before || !before.ranges)\n      { pushSelectionToHistory(doc.sel, hist.done); }\n    cur = {changes: [historyChangeFromChange(doc, change)],\n           generation: hist.generation};\n    hist.done.push(cur);\n    while (hist.done.length > hist.undoDepth) {\n      hist.done.shift();\n      if (!hist.done[0].ranges) { hist.done.shift(); }\n    }\n  }\n  hist.done.push(selAfter);\n  hist.generation = ++hist.maxGeneration;\n  hist.lastModTime = hist.lastSelTime = time;\n  hist.lastOp = hist.lastSelOp = opId;\n  hist.lastOrigin = hist.lastSelOrigin = change.origin;\n\n  if (!last) { signal(doc, "historyAdded"); }\n}\n\nfunction selectionEventCanBeMerged(doc, origin, prev, sel) {\n  var ch = origin.charAt(0);\n  return ch == "*" ||\n    ch == "+" &&\n    prev.ranges.length == sel.ranges.length &&\n    prev.somethingSelected() == sel.somethingSelected() &&\n    new Date - doc.history.lastSelTime <= (doc.cm ? doc.cm.options.historyEventDelay : 500)\n}\n\n// Called whenever the selection changes, sets the new selection as\n// the pending selection in the history, and pushes the old pending\n// selection into the \'done\' array when it was significantly\n// different (in number of selected ranges, emptiness, or time).\nfunction addSelectionToHistory(doc, sel, opId, options) {\n  var hist = doc.history, origin = options && options.origin;\n\n  // A new event is started when the previous origin does not match\n  // the current, or the origins don\'t allow matching. Origins\n  // starting with * are always merged, those starting with + are\n  // merged when similar and close together in time.\n  if (opId == hist.lastSelOp ||\n      (origin && hist.lastSelOrigin == origin &&\n       (hist.lastModTime == hist.lastSelTime && hist.lastOrigin == origin ||\n        selectionEventCanBeMerged(doc, origin, lst(hist.done), sel))))\n    { hist.done[hist.done.length - 1] = sel; }\n  else\n    { pushSelectionToHistory(sel, hist.done); }\n\n  hist.lastSelTime = +new Date;\n  hist.lastSelOrigin = origin;\n  hist.lastSelOp = opId;\n  if (options && options.clearRedo !== false)\n    { clearSelectionEvents(hist.undone); }\n}\n\nfunction pushSelectionToHistory(sel, dest) {\n  var top = lst(dest);\n  if (!(top && top.ranges && top.equals(sel)))\n    { dest.push(sel); }\n}\n\n// Used to store marked span information in the history.\nfunction attachLocalSpans(doc, change, from, to) {\n  var existing = change["spans_" + doc.id], n = 0;\n  doc.iter(Math.max(doc.first, from), Math.min(doc.first + doc.size, to), function (line) {\n    if (line.markedSpans)\n      { (existing || (existing = change["spans_" + doc.id] = {}))[n] = line.markedSpans; }\n    ++n;\n  });\n}\n\n// When un/re-doing restores text containing marked spans, those\n// that have been explicitly cleared should not be restored.\nfunction removeClearedSpans(spans) {\n  if (!spans) { return null }\n  var out;\n  for (var i = 0; i < spans.length; ++i) {\n    if (spans[i].marker.explicitlyCleared) { if (!out) { out = spans.slice(0, i); } }\n    else if (out) { out.push(spans[i]); }\n  }\n  return !out ? spans : out.length ? out : null\n}\n\n// Retrieve and filter the old marked spans stored in a change event.\nfunction getOldSpans(doc, change) {\n  var found = change["spans_" + doc.id];\n  if (!found) { return null }\n  var nw = [];\n  for (var i = 0; i < change.text.length; ++i)\n    { nw.push(removeClearedSpans(found[i])); }\n  return nw\n}\n\n// Used for un/re-doing changes from the history. Combines the\n// result of computing the existing spans with the set of spans that\n// existed in the history (so that deleting around a span and then\n// undoing brings back the span).\nfunction mergeOldSpans(doc, change) {\n  var old = getOldSpans(doc, change);\n  var stretched = stretchSpansOverChange(doc, change);\n  if (!old) { return stretched }\n  if (!stretched) { return old }\n\n  for (var i = 0; i < old.length; ++i) {\n    var oldCur = old[i], stretchCur = stretched[i];\n    if (oldCur && stretchCur) {\n      spans: for (var j = 0; j < stretchCur.length; ++j) {\n        var span = stretchCur[j];\n        for (var k = 0; k < oldCur.length; ++k)\n          { if (oldCur[k].marker == span.marker) { continue spans } }\n        oldCur.push(span);\n      }\n    } else if (stretchCur) {\n      old[i] = stretchCur;\n    }\n  }\n  return old\n}\n\n// Used both to provide a JSON-safe object in .getHistory, and, when\n// detaching a document, to split the history in two\nfunction copyHistoryArray(events, newGroup, instantiateSel) {\n  var copy = [];\n  for (var i = 0; i < events.length; ++i) {\n    var event = events[i];\n    if (event.ranges) {\n      copy.push(instantiateSel ? Selection.prototype.deepCopy.call(event) : event);\n      continue\n    }\n    var changes = event.changes, newChanges = [];\n    copy.push({changes: newChanges});\n    for (var j = 0; j < changes.length; ++j) {\n      var change = changes[j], m = (void 0);\n      newChanges.push({from: change.from, to: change.to, text: change.text});\n      if (newGroup) { for (var prop in change) { if (m = prop.match(/^spans_(\\d+)$/)) {\n        if (indexOf(newGroup, Number(m[1])) > -1) {\n          lst(newChanges)[prop] = change[prop];\n          delete change[prop];\n        }\n      } } }\n    }\n  }\n  return copy\n}\n\n// The \'scroll\' parameter given to many of these indicated whether\n// the new cursor position should be scrolled into view after\n// modifying the selection.\n\n// If shift is held or the extend flag is set, extends a range to\n// include a given position (and optionally a second position).\n// Otherwise, simply returns the range between the given positions.\n// Used for cursor motion and such.\nfunction extendRange(range, head, other, extend) {\n  if (extend) {\n    var anchor = range.anchor;\n    if (other) {\n      var posBefore = cmp(head, anchor) < 0;\n      if (posBefore != (cmp(other, anchor) < 0)) {\n        anchor = head;\n        head = other;\n      } else if (posBefore != (cmp(head, other) < 0)) {\n        head = other;\n      }\n    }\n    return new Range(anchor, head)\n  } else {\n    return new Range(other || head, head)\n  }\n}\n\n// Extend the primary selection range, discard the rest.\nfunction extendSelection(doc, head, other, options, extend) {\n  if (extend == null) { extend = doc.cm && (doc.cm.display.shift || doc.extend); }\n  setSelection(doc, new Selection([extendRange(doc.sel.primary(), head, other, extend)], 0), options);\n}\n\n// Extend all selections (pos is an array of selections with length\n// equal the number of selections)\nfunction extendSelections(doc, heads, options) {\n  var out = [];\n  var extend = doc.cm && (doc.cm.display.shift || doc.extend);\n  for (var i = 0; i < doc.sel.ranges.length; i++)\n    { out[i] = extendRange(doc.sel.ranges[i], heads[i], null, extend); }\n  var newSel = normalizeSelection(out, doc.sel.primIndex);\n  setSelection(doc, newSel, options);\n}\n\n// Updates a single range in the selection.\nfunction replaceOneSelection(doc, i, range, options) {\n  var ranges = doc.sel.ranges.slice(0);\n  ranges[i] = range;\n  setSelection(doc, normalizeSelection(ranges, doc.sel.primIndex), options);\n}\n\n// Reset the selection to a single range.\nfunction setSimpleSelection(doc, anchor, head, options) {\n  setSelection(doc, simpleSelection(anchor, head), options);\n}\n\n// Give beforeSelectionChange handlers a change to influence a\n// selection update.\nfunction filterSelectionChange(doc, sel, options) {\n  var obj = {\n    ranges: sel.ranges,\n    update: function(ranges) {\n      var this$1 = this;\n\n      this.ranges = [];\n      for (var i = 0; i < ranges.length; i++)\n        { this$1.ranges[i] = new Range(clipPos(doc, ranges[i].anchor),\n                                   clipPos(doc, ranges[i].head)); }\n    },\n    origin: options && options.origin\n  };\n  signal(doc, "beforeSelectionChange", doc, obj);\n  if (doc.cm) { signal(doc.cm, "beforeSelectionChange", doc.cm, obj); }\n  if (obj.ranges != sel.ranges) { return normalizeSelection(obj.ranges, obj.ranges.length - 1) }\n  else { return sel }\n}\n\nfunction setSelectionReplaceHistory(doc, sel, options) {\n  var done = doc.history.done, last = lst(done);\n  if (last && last.ranges) {\n    done[done.length - 1] = sel;\n    setSelectionNoUndo(doc, sel, options);\n  } else {\n    setSelection(doc, sel, options);\n  }\n}\n\n// Set a new selection.\nfunction setSelection(doc, sel, options) {\n  setSelectionNoUndo(doc, sel, options);\n  addSelectionToHistory(doc, doc.sel, doc.cm ? doc.cm.curOp.id : NaN, options);\n}\n\nfunction setSelectionNoUndo(doc, sel, options) {\n  if (hasHandler(doc, "beforeSelectionChange") || doc.cm && hasHandler(doc.cm, "beforeSelectionChange"))\n    { sel = filterSelectionChange(doc, sel, options); }\n\n  var bias = options && options.bias ||\n    (cmp(sel.primary().head, doc.sel.primary().head) < 0 ? -1 : 1);\n  setSelectionInner(doc, skipAtomicInSelection(doc, sel, bias, true));\n\n  if (!(options && options.scroll === false) && doc.cm)\n    { ensureCursorVisible(doc.cm); }\n}\n\nfunction setSelectionInner(doc, sel) {\n  if (sel.equals(doc.sel)) { return }\n\n  doc.sel = sel;\n\n  if (doc.cm) {\n    doc.cm.curOp.updateInput = doc.cm.curOp.selectionChanged = true;\n    signalCursorActivity(doc.cm);\n  }\n  signalLater(doc, "cursorActivity", doc);\n}\n\n// Verify that the selection does not partially select any atomic\n// marked ranges.\nfunction reCheckSelection(doc) {\n  setSelectionInner(doc, skipAtomicInSelection(doc, doc.sel, null, false));\n}\n\n// Return a selection that does not partially select any atomic\n// ranges.\nfunction skipAtomicInSelection(doc, sel, bias, mayClear) {\n  var out;\n  for (var i = 0; i < sel.ranges.length; i++) {\n    var range = sel.ranges[i];\n    var old = sel.ranges.length == doc.sel.ranges.length && doc.sel.ranges[i];\n    var newAnchor = skipAtomic(doc, range.anchor, old && old.anchor, bias, mayClear);\n    var newHead = skipAtomic(doc, range.head, old && old.head, bias, mayClear);\n    if (out || newAnchor != range.anchor || newHead != range.head) {\n      if (!out) { out = sel.ranges.slice(0, i); }\n      out[i] = new Range(newAnchor, newHead);\n    }\n  }\n  return out ? normalizeSelection(out, sel.primIndex) : sel\n}\n\nfunction skipAtomicInner(doc, pos, oldPos, dir, mayClear) {\n  var line = getLine(doc, pos.line);\n  if (line.markedSpans) { for (var i = 0; i < line.markedSpans.length; ++i) {\n    var sp = line.markedSpans[i], m = sp.marker;\n    if ((sp.from == null || (m.inclusiveLeft ? sp.from <= pos.ch : sp.from < pos.ch)) &&\n        (sp.to == null || (m.inclusiveRight ? sp.to >= pos.ch : sp.to > pos.ch))) {\n      if (mayClear) {\n        signal(m, "beforeCursorEnter");\n        if (m.explicitlyCleared) {\n          if (!line.markedSpans) { break }\n          else {--i; continue}\n        }\n      }\n      if (!m.atomic) { continue }\n\n      if (oldPos) {\n        var near = m.find(dir < 0 ? 1 : -1), diff = (void 0);\n        if (dir < 0 ? m.inclusiveRight : m.inclusiveLeft)\n          { near = movePos(doc, near, -dir, near && near.line == pos.line ? line : null); }\n        if (near && near.line == pos.line && (diff = cmp(near, oldPos)) && (dir < 0 ? diff < 0 : diff > 0))\n          { return skipAtomicInner(doc, near, pos, dir, mayClear) }\n      }\n\n      var far = m.find(dir < 0 ? -1 : 1);\n      if (dir < 0 ? m.inclusiveLeft : m.inclusiveRight)\n        { far = movePos(doc, far, dir, far.line == pos.line ? line : null); }\n      return far ? skipAtomicInner(doc, far, pos, dir, mayClear) : null\n    }\n  } }\n  return pos\n}\n\n// Ensure a given position is not inside an atomic range.\nfunction skipAtomic(doc, pos, oldPos, bias, mayClear) {\n  var dir = bias || 1;\n  var found = skipAtomicInner(doc, pos, oldPos, dir, mayClear) ||\n      (!mayClear && skipAtomicInner(doc, pos, oldPos, dir, true)) ||\n      skipAtomicInner(doc, pos, oldPos, -dir, mayClear) ||\n      (!mayClear && skipAtomicInner(doc, pos, oldPos, -dir, true));\n  if (!found) {\n    doc.cantEdit = true;\n    return Pos(doc.first, 0)\n  }\n  return found\n}\n\nfunction movePos(doc, pos, dir, line) {\n  if (dir < 0 && pos.ch == 0) {\n    if (pos.line > doc.first) { return clipPos(doc, Pos(pos.line - 1)) }\n    else { return null }\n  } else if (dir > 0 && pos.ch == (line || getLine(doc, pos.line)).text.length) {\n    if (pos.line < doc.first + doc.size - 1) { return Pos(pos.line + 1, 0) }\n    else { return null }\n  } else {\n    return new Pos(pos.line, pos.ch + dir)\n  }\n}\n\nfunction selectAll(cm) {\n  cm.setSelection(Pos(cm.firstLine(), 0), Pos(cm.lastLine()), sel_dontScroll);\n}\n\n// UPDATING\n\n// Allow "beforeChange" event handlers to influence a change\nfunction filterChange(doc, change, update) {\n  var obj = {\n    canceled: false,\n    from: change.from,\n    to: change.to,\n    text: change.text,\n    origin: change.origin,\n    cancel: function () { return obj.canceled = true; }\n  };\n  if (update) { obj.update = function (from, to, text, origin) {\n    if (from) { obj.from = clipPos(doc, from); }\n    if (to) { obj.to = clipPos(doc, to); }\n    if (text) { obj.text = text; }\n    if (origin !== undefined) { obj.origin = origin; }\n  }; }\n  signal(doc, "beforeChange", doc, obj);\n  if (doc.cm) { signal(doc.cm, "beforeChange", doc.cm, obj); }\n\n  if (obj.canceled) { return null }\n  return {from: obj.from, to: obj.to, text: obj.text, origin: obj.origin}\n}\n\n// Apply a change to a document, and add it to the document\'s\n// history, and propagating it to all linked documents.\nfunction makeChange(doc, change, ignoreReadOnly) {\n  if (doc.cm) {\n    if (!doc.cm.curOp) { return operation(doc.cm, makeChange)(doc, change, ignoreReadOnly) }\n    if (doc.cm.state.suppressEdits) { return }\n  }\n\n  if (hasHandler(doc, "beforeChange") || doc.cm && hasHandler(doc.cm, "beforeChange")) {\n    change = filterChange(doc, change, true);\n    if (!change) { return }\n  }\n\n  // Possibly split or suppress the update based on the presence\n  // of read-only spans in its range.\n  var split = sawReadOnlySpans && !ignoreReadOnly && removeReadOnlyRanges(doc, change.from, change.to);\n  if (split) {\n    for (var i = split.length - 1; i >= 0; --i)\n      { makeChangeInner(doc, {from: split[i].from, to: split[i].to, text: i ? [""] : change.text}); }\n  } else {\n    makeChangeInner(doc, change);\n  }\n}\n\nfunction makeChangeInner(doc, change) {\n  if (change.text.length == 1 && change.text[0] == "" && cmp(change.from, change.to) == 0) { return }\n  var selAfter = computeSelAfterChange(doc, change);\n  addChangeToHistory(doc, change, selAfter, doc.cm ? doc.cm.curOp.id : NaN);\n\n  makeChangeSingleDoc(doc, change, selAfter, stretchSpansOverChange(doc, change));\n  var rebased = [];\n\n  linkedDocs(doc, function (doc, sharedHist) {\n    if (!sharedHist && indexOf(rebased, doc.history) == -1) {\n      rebaseHist(doc.history, change);\n      rebased.push(doc.history);\n    }\n    makeChangeSingleDoc(doc, change, null, stretchSpansOverChange(doc, change));\n  });\n}\n\n// Revert a change stored in a document\'s history.\nfunction makeChangeFromHistory(doc, type, allowSelectionOnly) {\n  if (doc.cm && doc.cm.state.suppressEdits && !allowSelectionOnly) { return }\n\n  var hist = doc.history, event, selAfter = doc.sel;\n  var source = type == "undo" ? hist.done : hist.undone, dest = type == "undo" ? hist.undone : hist.done;\n\n  // Verify that there is a useable event (so that ctrl-z won\'t\n  // needlessly clear selection events)\n  var i = 0;\n  for (; i < source.length; i++) {\n    event = source[i];\n    if (allowSelectionOnly ? event.ranges && !event.equals(doc.sel) : !event.ranges)\n      { break }\n  }\n  if (i == source.length) { return }\n  hist.lastOrigin = hist.lastSelOrigin = null;\n\n  for (;;) {\n    event = source.pop();\n    if (event.ranges) {\n      pushSelectionToHistory(event, dest);\n      if (allowSelectionOnly && !event.equals(doc.sel)) {\n        setSelection(doc, event, {clearRedo: false});\n        return\n      }\n      selAfter = event;\n    }\n    else { break }\n  }\n\n  // Build up a reverse change object to add to the opposite history\n  // stack (redo when undoing, and vice versa).\n  var antiChanges = [];\n  pushSelectionToHistory(selAfter, dest);\n  dest.push({changes: antiChanges, generation: hist.generation});\n  hist.generation = event.generation || ++hist.maxGeneration;\n\n  var filter = hasHandler(doc, "beforeChange") || doc.cm && hasHandler(doc.cm, "beforeChange");\n\n  var loop = function ( i ) {\n    var change = event.changes[i];\n    change.origin = type;\n    if (filter && !filterChange(doc, change, false)) {\n      source.length = 0;\n      return {}\n    }\n\n    antiChanges.push(historyChangeFromChange(doc, change));\n\n    var after = i ? computeSelAfterChange(doc, change) : lst(source);\n    makeChangeSingleDoc(doc, change, after, mergeOldSpans(doc, change));\n    if (!i && doc.cm) { doc.cm.scrollIntoView({from: change.from, to: changeEnd(change)}); }\n    var rebased = [];\n\n    // Propagate to the linked documents\n    linkedDocs(doc, function (doc, sharedHist) {\n      if (!sharedHist && indexOf(rebased, doc.history) == -1) {\n        rebaseHist(doc.history, change);\n        rebased.push(doc.history);\n      }\n      makeChangeSingleDoc(doc, change, null, mergeOldSpans(doc, change));\n    });\n  };\n\n  for (var i$1 = event.changes.length - 1; i$1 >= 0; --i$1) {\n    var returned = loop( i$1 );\n\n    if ( returned ) return returned.v;\n  }\n}\n\n// Sub-views need their line numbers shifted when text is added\n// above or below them in the parent document.\nfunction shiftDoc(doc, distance) {\n  if (distance == 0) { return }\n  doc.first += distance;\n  doc.sel = new Selection(map(doc.sel.ranges, function (range) { return new Range(\n    Pos(range.anchor.line + distance, range.anchor.ch),\n    Pos(range.head.line + distance, range.head.ch)\n  ); }), doc.sel.primIndex);\n  if (doc.cm) {\n    regChange(doc.cm, doc.first, doc.first - distance, distance);\n    for (var d = doc.cm.display, l = d.viewFrom; l < d.viewTo; l++)\n      { regLineChange(doc.cm, l, "gutter"); }\n  }\n}\n\n// More lower-level change function, handling only a single document\n// (not linked ones).\nfunction makeChangeSingleDoc(doc, change, selAfter, spans) {\n  if (doc.cm && !doc.cm.curOp)\n    { return operation(doc.cm, makeChangeSingleDoc)(doc, change, selAfter, spans) }\n\n  if (change.to.line < doc.first) {\n    shiftDoc(doc, change.text.length - 1 - (change.to.line - change.from.line));\n    return\n  }\n  if (change.from.line > doc.lastLine()) { return }\n\n  // Clip the change to the size of this doc\n  if (change.from.line < doc.first) {\n    var shift = change.text.length - 1 - (doc.first - change.from.line);\n    shiftDoc(doc, shift);\n    change = {from: Pos(doc.first, 0), to: Pos(change.to.line + shift, change.to.ch),\n              text: [lst(change.text)], origin: change.origin};\n  }\n  var last = doc.lastLine();\n  if (change.to.line > last) {\n    change = {from: change.from, to: Pos(last, getLine(doc, last).text.length),\n              text: [change.text[0]], origin: change.origin};\n  }\n\n  change.removed = getBetween(doc, change.from, change.to);\n\n  if (!selAfter) { selAfter = computeSelAfterChange(doc, change); }\n  if (doc.cm) { makeChangeSingleDocInEditor(doc.cm, change, spans); }\n  else { updateDoc(doc, change, spans); }\n  setSelectionNoUndo(doc, selAfter, sel_dontScroll);\n}\n\n// Handle the interaction of a change to a document with the editor\n// that this document is part of.\nfunction makeChangeSingleDocInEditor(cm, change, spans) {\n  var doc = cm.doc, display = cm.display, from = change.from, to = change.to;\n\n  var recomputeMaxLength = false, checkWidthStart = from.line;\n  if (!cm.options.lineWrapping) {\n    checkWidthStart = lineNo(visualLine(getLine(doc, from.line)));\n    doc.iter(checkWidthStart, to.line + 1, function (line) {\n      if (line == display.maxLine) {\n        recomputeMaxLength = true;\n        return true\n      }\n    });\n  }\n\n  if (doc.sel.contains(change.from, change.to) > -1)\n    { signalCursorActivity(cm); }\n\n  updateDoc(doc, change, spans, estimateHeight(cm));\n\n  if (!cm.options.lineWrapping) {\n    doc.iter(checkWidthStart, from.line + change.text.length, function (line) {\n      var len = lineLength(line);\n      if (len > display.maxLineLength) {\n        display.maxLine = line;\n        display.maxLineLength = len;\n        display.maxLineChanged = true;\n        recomputeMaxLength = false;\n      }\n    });\n    if (recomputeMaxLength) { cm.curOp.updateMaxLine = true; }\n  }\n\n  retreatFrontier(doc, from.line);\n  startWorker(cm, 400);\n\n  var lendiff = change.text.length - (to.line - from.line) - 1;\n  // Remember that these lines changed, for updating the display\n  if (change.full)\n    { regChange(cm); }\n  else if (from.line == to.line && change.text.length == 1 && !isWholeLineUpdate(cm.doc, change))\n    { regLineChange(cm, from.line, "text"); }\n  else\n    { regChange(cm, from.line, to.line + 1, lendiff); }\n\n  var changesHandler = hasHandler(cm, "changes"), changeHandler = hasHandler(cm, "change");\n  if (changeHandler || changesHandler) {\n    var obj = {\n      from: from, to: to,\n      text: change.text,\n      removed: change.removed,\n      origin: change.origin\n    };\n    if (changeHandler) { signalLater(cm, "change", cm, obj); }\n    if (changesHandler) { (cm.curOp.changeObjs || (cm.curOp.changeObjs = [])).push(obj); }\n  }\n  cm.display.selForContextMenu = null;\n}\n\nfunction replaceRange(doc, code, from, to, origin) {\n  if (!to) { to = from; }\n  if (cmp(to, from) < 0) { var tmp = to; to = from; from = tmp; }\n  if (typeof code == "string") { code = doc.splitLines(code); }\n  makeChange(doc, {from: from, to: to, text: code, origin: origin});\n}\n\n// Rebasing/resetting history to deal with externally-sourced changes\n\nfunction rebaseHistSelSingle(pos, from, to, diff) {\n  if (to < pos.line) {\n    pos.line += diff;\n  } else if (from < pos.line) {\n    pos.line = from;\n    pos.ch = 0;\n  }\n}\n\n// Tries to rebase an array of history events given a change in the\n// document. If the change touches the same lines as the event, the\n// event, and everything \'behind\' it, is discarded. If the change is\n// before the event, the event\'s positions are updated. Uses a\n// copy-on-write scheme for the positions, to avoid having to\n// reallocate them all on every rebase, but also avoid problems with\n// shared position objects being unsafely updated.\nfunction rebaseHistArray(array, from, to, diff) {\n  for (var i = 0; i < array.length; ++i) {\n    var sub = array[i], ok = true;\n    if (sub.ranges) {\n      if (!sub.copied) { sub = array[i] = sub.deepCopy(); sub.copied = true; }\n      for (var j = 0; j < sub.ranges.length; j++) {\n        rebaseHistSelSingle(sub.ranges[j].anchor, from, to, diff);\n        rebaseHistSelSingle(sub.ranges[j].head, from, to, diff);\n      }\n      continue\n    }\n    for (var j$1 = 0; j$1 < sub.changes.length; ++j$1) {\n      var cur = sub.changes[j$1];\n      if (to < cur.from.line) {\n        cur.from = Pos(cur.from.line + diff, cur.from.ch);\n        cur.to = Pos(cur.to.line + diff, cur.to.ch);\n      } else if (from <= cur.to.line) {\n        ok = false;\n        break\n      }\n    }\n    if (!ok) {\n      array.splice(0, i + 1);\n      i = 0;\n    }\n  }\n}\n\nfunction rebaseHist(hist, change) {\n  var from = change.from.line, to = change.to.line, diff = change.text.length - (to - from) - 1;\n  rebaseHistArray(hist.done, from, to, diff);\n  rebaseHistArray(hist.undone, from, to, diff);\n}\n\n// Utility for applying a change to a line by handle or number,\n// returning the number and optionally registering the line as\n// changed.\nfunction changeLine(doc, handle, changeType, op) {\n  var no = handle, line = handle;\n  if (typeof handle == "number") { line = getLine(doc, clipLine(doc, handle)); }\n  else { no = lineNo(handle); }\n  if (no == null) { return null }\n  if (op(line, no) && doc.cm) { regLineChange(doc.cm, no, changeType); }\n  return line\n}\n\n// The document is represented as a BTree consisting of leaves, with\n// chunk of lines in them, and branches, with up to ten leaves or\n// other branch nodes below them. The top node is always a branch\n// node, and is the document object itself (meaning it has\n// additional methods and properties).\n//\n// All nodes have parent links. The tree is used both to go from\n// line numbers to line objects, and to go from objects to numbers.\n// It also indexes by height, and is used to convert between height\n// and line object, and to find the total height of the document.\n//\n// See also http://marijnhaverbeke.nl/blog/codemirror-line-tree.html\n\nfunction LeafChunk(lines) {\n  var this$1 = this;\n\n  this.lines = lines;\n  this.parent = null;\n  var height = 0;\n  for (var i = 0; i < lines.length; ++i) {\n    lines[i].parent = this$1;\n    height += lines[i].height;\n  }\n  this.height = height;\n}\n\nLeafChunk.prototype = {\n  chunkSize: function chunkSize() { return this.lines.length },\n\n  // Remove the n lines at offset \'at\'.\n  removeInner: function removeInner(at, n) {\n    var this$1 = this;\n\n    for (var i = at, e = at + n; i < e; ++i) {\n      var line = this$1.lines[i];\n      this$1.height -= line.height;\n      cleanUpLine(line);\n      signalLater(line, "delete");\n    }\n    this.lines.splice(at, n);\n  },\n\n  // Helper used to collapse a small branch into a single leaf.\n  collapse: function collapse(lines) {\n    lines.push.apply(lines, this.lines);\n  },\n\n  // Insert the given array of lines at offset \'at\', count them as\n  // having the given height.\n  insertInner: function insertInner(at, lines, height) {\n    var this$1 = this;\n\n    this.height += height;\n    this.lines = this.lines.slice(0, at).concat(lines).concat(this.lines.slice(at));\n    for (var i = 0; i < lines.length; ++i) { lines[i].parent = this$1; }\n  },\n\n  // Used to iterate over a part of the tree.\n  iterN: function iterN(at, n, op) {\n    var this$1 = this;\n\n    for (var e = at + n; at < e; ++at)\n      { if (op(this$1.lines[at])) { return true } }\n  }\n};\n\nfunction BranchChunk(children) {\n  var this$1 = this;\n\n  this.children = children;\n  var size = 0, height = 0;\n  for (var i = 0; i < children.length; ++i) {\n    var ch = children[i];\n    size += ch.chunkSize(); height += ch.height;\n    ch.parent = this$1;\n  }\n  this.size = size;\n  this.height = height;\n  this.parent = null;\n}\n\nBranchChunk.prototype = {\n  chunkSize: function chunkSize() { return this.size },\n\n  removeInner: function removeInner(at, n) {\n    var this$1 = this;\n\n    this.size -= n;\n    for (var i = 0; i < this.children.length; ++i) {\n      var child = this$1.children[i], sz = child.chunkSize();\n      if (at < sz) {\n        var rm = Math.min(n, sz - at), oldHeight = child.height;\n        child.removeInner(at, rm);\n        this$1.height -= oldHeight - child.height;\n        if (sz == rm) { this$1.children.splice(i--, 1); child.parent = null; }\n        if ((n -= rm) == 0) { break }\n        at = 0;\n      } else { at -= sz; }\n    }\n    // If the result is smaller than 25 lines, ensure that it is a\n    // single leaf node.\n    if (this.size - n < 25 &&\n        (this.children.length > 1 || !(this.children[0] instanceof LeafChunk))) {\n      var lines = [];\n      this.collapse(lines);\n      this.children = [new LeafChunk(lines)];\n      this.children[0].parent = this;\n    }\n  },\n\n  collapse: function collapse(lines) {\n    var this$1 = this;\n\n    for (var i = 0; i < this.children.length; ++i) { this$1.children[i].collapse(lines); }\n  },\n\n  insertInner: function insertInner(at, lines, height) {\n    var this$1 = this;\n\n    this.size += lines.length;\n    this.height += height;\n    for (var i = 0; i < this.children.length; ++i) {\n      var child = this$1.children[i], sz = child.chunkSize();\n      if (at <= sz) {\n        child.insertInner(at, lines, height);\n        if (child.lines && child.lines.length > 50) {\n          // To avoid memory thrashing when child.lines is huge (e.g. first view of a large file), it\'s never spliced.\n          // Instead, small slices are taken. They\'re taken in order because sequential memory accesses are fastest.\n          var remaining = child.lines.length % 25 + 25;\n          for (var pos = remaining; pos < child.lines.length;) {\n            var leaf = new LeafChunk(child.lines.slice(pos, pos += 25));\n            child.height -= leaf.height;\n            this$1.children.splice(++i, 0, leaf);\n            leaf.parent = this$1;\n          }\n          child.lines = child.lines.slice(0, remaining);\n          this$1.maybeSpill();\n        }\n        break\n      }\n      at -= sz;\n    }\n  },\n\n  // When a node has grown, check whether it should be split.\n  maybeSpill: function maybeSpill() {\n    if (this.children.length <= 10) { return }\n    var me = this;\n    do {\n      var spilled = me.children.splice(me.children.length - 5, 5);\n      var sibling = new BranchChunk(spilled);\n      if (!me.parent) { // Become the parent node\n        var copy = new BranchChunk(me.children);\n        copy.parent = me;\n        me.children = [copy, sibling];\n        me = copy;\n     } else {\n        me.size -= sibling.size;\n        me.height -= sibling.height;\n        var myIndex = indexOf(me.parent.children, me);\n        me.parent.children.splice(myIndex + 1, 0, sibling);\n      }\n      sibling.parent = me.parent;\n    } while (me.children.length > 10)\n    me.parent.maybeSpill();\n  },\n\n  iterN: function iterN(at, n, op) {\n    var this$1 = this;\n\n    for (var i = 0; i < this.children.length; ++i) {\n      var child = this$1.children[i], sz = child.chunkSize();\n      if (at < sz) {\n        var used = Math.min(n, sz - at);\n        if (child.iterN(at, used, op)) { return true }\n        if ((n -= used) == 0) { break }\n        at = 0;\n      } else { at -= sz; }\n    }\n  }\n};\n\n// Line widgets are block elements displayed above or below a line.\n\nvar LineWidget = function(doc, node, options) {\n  var this$1 = this;\n\n  if (options) { for (var opt in options) { if (options.hasOwnProperty(opt))\n    { this$1[opt] = options[opt]; } } }\n  this.doc = doc;\n  this.node = node;\n};\n\nLineWidget.prototype.clear = function () {\n    var this$1 = this;\n\n  var cm = this.doc.cm, ws = this.line.widgets, line = this.line, no = lineNo(line);\n  if (no == null || !ws) { return }\n  for (var i = 0; i < ws.length; ++i) { if (ws[i] == this$1) { ws.splice(i--, 1); } }\n  if (!ws.length) { line.widgets = null; }\n  var height = widgetHeight(this);\n  updateLineHeight(line, Math.max(0, line.height - height));\n  if (cm) {\n    runInOp(cm, function () {\n      adjustScrollWhenAboveVisible(cm, line, -height);\n      regLineChange(cm, no, "widget");\n    });\n    signalLater(cm, "lineWidgetCleared", cm, this, no);\n  }\n};\n\nLineWidget.prototype.changed = function () {\n    var this$1 = this;\n\n  var oldH = this.height, cm = this.doc.cm, line = this.line;\n  this.height = null;\n  var diff = widgetHeight(this) - oldH;\n  if (!diff) { return }\n  updateLineHeight(line, line.height + diff);\n  if (cm) {\n    runInOp(cm, function () {\n      cm.curOp.forceUpdate = true;\n      adjustScrollWhenAboveVisible(cm, line, diff);\n      signalLater(cm, "lineWidgetChanged", cm, this$1, lineNo(line));\n    });\n  }\n};\neventMixin(LineWidget);\n\nfunction adjustScrollWhenAboveVisible(cm, line, diff) {\n  if (heightAtLine(line) < ((cm.curOp && cm.curOp.scrollTop) || cm.doc.scrollTop))\n    { addToScrollTop(cm, diff); }\n}\n\nfunction addLineWidget(doc, handle, node, options) {\n  var widget = new LineWidget(doc, node, options);\n  var cm = doc.cm;\n  if (cm && widget.noHScroll) { cm.display.alignWidgets = true; }\n  changeLine(doc, handle, "widget", function (line) {\n    var widgets = line.widgets || (line.widgets = []);\n    if (widget.insertAt == null) { widgets.push(widget); }\n    else { widgets.splice(Math.min(widgets.length - 1, Math.max(0, widget.insertAt)), 0, widget); }\n    widget.line = line;\n    if (cm && !lineIsHidden(doc, line)) {\n      var aboveVisible = heightAtLine(line) < doc.scrollTop;\n      updateLineHeight(line, line.height + widgetHeight(widget));\n      if (aboveVisible) { addToScrollTop(cm, widget.height); }\n      cm.curOp.forceUpdate = true;\n    }\n    return true\n  });\n  signalLater(cm, "lineWidgetAdded", cm, widget, typeof handle == "number" ? handle : lineNo(handle));\n  return widget\n}\n\n// TEXTMARKERS\n\n// Created with markText and setBookmark methods. A TextMarker is a\n// handle that can be used to clear or find a marked position in the\n// document. Line objects hold arrays (markedSpans) containing\n// {from, to, marker} object pointing to such marker objects, and\n// indicating that such a marker is present on that line. Multiple\n// lines may point to the same marker when it spans across lines.\n// The spans will have null for their from/to properties when the\n// marker continues beyond the start/end of the line. Markers have\n// links back to the lines they currently touch.\n\n// Collapsed markers have unique ids, in order to be able to order\n// them, which is needed for uniquely determining an outer marker\n// when they overlap (they may nest, but not partially overlap).\nvar nextMarkerId = 0;\n\nvar TextMarker = function(doc, type) {\n  this.lines = [];\n  this.type = type;\n  this.doc = doc;\n  this.id = ++nextMarkerId;\n};\n\n// Clear the marker.\nTextMarker.prototype.clear = function () {\n    var this$1 = this;\n\n  if (this.explicitlyCleared) { return }\n  var cm = this.doc.cm, withOp = cm && !cm.curOp;\n  if (withOp) { startOperation(cm); }\n  if (hasHandler(this, "clear")) {\n    var found = this.find();\n    if (found) { signalLater(this, "clear", found.from, found.to); }\n  }\n  var min = null, max = null;\n  for (var i = 0; i < this.lines.length; ++i) {\n    var line = this$1.lines[i];\n    var span = getMarkedSpanFor(line.markedSpans, this$1);\n    if (cm && !this$1.collapsed) { regLineChange(cm, lineNo(line), "text"); }\n    else if (cm) {\n      if (span.to != null) { max = lineNo(line); }\n      if (span.from != null) { min = lineNo(line); }\n    }\n    line.markedSpans = removeMarkedSpan(line.markedSpans, span);\n    if (span.from == null && this$1.collapsed && !lineIsHidden(this$1.doc, line) && cm)\n      { updateLineHeight(line, textHeight(cm.display)); }\n  }\n  if (cm && this.collapsed && !cm.options.lineWrapping) { for (var i$1 = 0; i$1 < this.lines.length; ++i$1) {\n    var visual = visualLine(this$1.lines[i$1]), len = lineLength(visual);\n    if (len > cm.display.maxLineLength) {\n      cm.display.maxLine = visual;\n      cm.display.maxLineLength = len;\n      cm.display.maxLineChanged = true;\n    }\n  } }\n\n  if (min != null && cm && this.collapsed) { regChange(cm, min, max + 1); }\n  this.lines.length = 0;\n  this.explicitlyCleared = true;\n  if (this.atomic && this.doc.cantEdit) {\n    this.doc.cantEdit = false;\n    if (cm) { reCheckSelection(cm.doc); }\n  }\n  if (cm) { signalLater(cm, "markerCleared", cm, this, min, max); }\n  if (withOp) { endOperation(cm); }\n  if (this.parent) { this.parent.clear(); }\n};\n\n// Find the position of the marker in the document. Returns a {from,\n// to} object by default. Side can be passed to get a specific side\n// -- 0 (both), -1 (left), or 1 (right). When lineObj is true, the\n// Pos objects returned contain a line object, rather than a line\n// number (used to prevent looking up the same line twice).\nTextMarker.prototype.find = function (side, lineObj) {\n    var this$1 = this;\n\n  if (side == null && this.type == "bookmark") { side = 1; }\n  var from, to;\n  for (var i = 0; i < this.lines.length; ++i) {\n    var line = this$1.lines[i];\n    var span = getMarkedSpanFor(line.markedSpans, this$1);\n    if (span.from != null) {\n      from = Pos(lineObj ? line : lineNo(line), span.from);\n      if (side == -1) { return from }\n    }\n    if (span.to != null) {\n      to = Pos(lineObj ? line : lineNo(line), span.to);\n      if (side == 1) { return to }\n    }\n  }\n  return from && {from: from, to: to}\n};\n\n// Signals that the marker\'s widget changed, and surrounding layout\n// should be recomputed.\nTextMarker.prototype.changed = function () {\n    var this$1 = this;\n\n  var pos = this.find(-1, true), widget = this, cm = this.doc.cm;\n  if (!pos || !cm) { return }\n  runInOp(cm, function () {\n    var line = pos.line, lineN = lineNo(pos.line);\n    var view = findViewForLine(cm, lineN);\n    if (view) {\n      clearLineMeasurementCacheFor(view);\n      cm.curOp.selectionChanged = cm.curOp.forceUpdate = true;\n    }\n    cm.curOp.updateMaxLine = true;\n    if (!lineIsHidden(widget.doc, line) && widget.height != null) {\n      var oldHeight = widget.height;\n      widget.height = null;\n      var dHeight = widgetHeight(widget) - oldHeight;\n      if (dHeight)\n        { updateLineHeight(line, line.height + dHeight); }\n    }\n    signalLater(cm, "markerChanged", cm, this$1);\n  });\n};\n\nTextMarker.prototype.attachLine = function (line) {\n  if (!this.lines.length && this.doc.cm) {\n    var op = this.doc.cm.curOp;\n    if (!op.maybeHiddenMarkers || indexOf(op.maybeHiddenMarkers, this) == -1)\n      { (op.maybeUnhiddenMarkers || (op.maybeUnhiddenMarkers = [])).push(this); }\n  }\n  this.lines.push(line);\n};\n\nTextMarker.prototype.detachLine = function (line) {\n  this.lines.splice(indexOf(this.lines, line), 1);\n  if (!this.lines.length && this.doc.cm) {\n    var op = this.doc.cm.curOp;(op.maybeHiddenMarkers || (op.maybeHiddenMarkers = [])).push(this);\n  }\n};\neventMixin(TextMarker);\n\n// Create a marker, wire it up to the right lines, and\nfunction markText(doc, from, to, options, type) {\n  // Shared markers (across linked documents) are handled separately\n  // (markTextShared will call out to this again, once per\n  // document).\n  if (options && options.shared) { return markTextShared(doc, from, to, options, type) }\n  // Ensure we are in an operation.\n  if (doc.cm && !doc.cm.curOp) { return operation(doc.cm, markText)(doc, from, to, options, type) }\n\n  var marker = new TextMarker(doc, type), diff = cmp(from, to);\n  if (options) { copyObj(options, marker, false); }\n  // Don\'t connect empty markers unless clearWhenEmpty is false\n  if (diff > 0 || diff == 0 && marker.clearWhenEmpty !== false)\n    { return marker }\n  if (marker.replacedWith) {\n    // Showing up as a widget implies collapsed (widget replaces text)\n    marker.collapsed = true;\n    marker.widgetNode = eltP("span", [marker.replacedWith], "CodeMirror-widget");\n    if (!options.handleMouseEvents) { marker.widgetNode.setAttribute("cm-ignore-events", "true"); }\n    if (options.insertLeft) { marker.widgetNode.insertLeft = true; }\n  }\n  if (marker.collapsed) {\n    if (conflictingCollapsedRange(doc, from.line, from, to, marker) ||\n        from.line != to.line && conflictingCollapsedRange(doc, to.line, from, to, marker))\n      { throw new Error("Inserting collapsed marker partially overlapping an existing one") }\n    seeCollapsedSpans();\n  }\n\n  if (marker.addToHistory)\n    { addChangeToHistory(doc, {from: from, to: to, origin: "markText"}, doc.sel, NaN); }\n\n  var curLine = from.line, cm = doc.cm, updateMaxLine;\n  doc.iter(curLine, to.line + 1, function (line) {\n    if (cm && marker.collapsed && !cm.options.lineWrapping && visualLine(line) == cm.display.maxLine)\n      { updateMaxLine = true; }\n    if (marker.collapsed && curLine != from.line) { updateLineHeight(line, 0); }\n    addMarkedSpan(line, new MarkedSpan(marker,\n                                       curLine == from.line ? from.ch : null,\n                                       curLine == to.line ? to.ch : null));\n    ++curLine;\n  });\n  // lineIsHidden depends on the presence of the spans, so needs a second pass\n  if (marker.collapsed) { doc.iter(from.line, to.line + 1, function (line) {\n    if (lineIsHidden(doc, line)) { updateLineHeight(line, 0); }\n  }); }\n\n  if (marker.clearOnEnter) { on(marker, "beforeCursorEnter", function () { return marker.clear(); }); }\n\n  if (marker.readOnly) {\n    seeReadOnlySpans();\n    if (doc.history.done.length || doc.history.undone.length)\n      { doc.clearHistory(); }\n  }\n  if (marker.collapsed) {\n    marker.id = ++nextMarkerId;\n    marker.atomic = true;\n  }\n  if (cm) {\n    // Sync editor state\n    if (updateMaxLine) { cm.curOp.updateMaxLine = true; }\n    if (marker.collapsed)\n      { regChange(cm, from.line, to.line + 1); }\n    else if (marker.className || marker.title || marker.startStyle || marker.endStyle || marker.css)\n      { for (var i = from.line; i <= to.line; i++) { regLineChange(cm, i, "text"); } }\n    if (marker.atomic) { reCheckSelection(cm.doc); }\n    signalLater(cm, "markerAdded", cm, marker);\n  }\n  return marker\n}\n\n// SHARED TEXTMARKERS\n\n// A shared marker spans multiple linked documents. It is\n// implemented as a meta-marker-object controlling multiple normal\n// markers.\nvar SharedTextMarker = function(markers, primary) {\n  var this$1 = this;\n\n  this.markers = markers;\n  this.primary = primary;\n  for (var i = 0; i < markers.length; ++i)\n    { markers[i].parent = this$1; }\n};\n\nSharedTextMarker.prototype.clear = function () {\n    var this$1 = this;\n\n  if (this.explicitlyCleared) { return }\n  this.explicitlyCleared = true;\n  for (var i = 0; i < this.markers.length; ++i)\n    { this$1.markers[i].clear(); }\n  signalLater(this, "clear");\n};\n\nSharedTextMarker.prototype.find = function (side, lineObj) {\n  return this.primary.find(side, lineObj)\n};\neventMixin(SharedTextMarker);\n\nfunction markTextShared(doc, from, to, options, type) {\n  options = copyObj(options);\n  options.shared = false;\n  var markers = [markText(doc, from, to, options, type)], primary = markers[0];\n  var widget = options.widgetNode;\n  linkedDocs(doc, function (doc) {\n    if (widget) { options.widgetNode = widget.cloneNode(true); }\n    markers.push(markText(doc, clipPos(doc, from), clipPos(doc, to), options, type));\n    for (var i = 0; i < doc.linked.length; ++i)\n      { if (doc.linked[i].isParent) { return } }\n    primary = lst(markers);\n  });\n  return new SharedTextMarker(markers, primary)\n}\n\nfunction findSharedMarkers(doc) {\n  return doc.findMarks(Pos(doc.first, 0), doc.clipPos(Pos(doc.lastLine())), function (m) { return m.parent; })\n}\n\nfunction copySharedMarkers(doc, markers) {\n  for (var i = 0; i < markers.length; i++) {\n    var marker = markers[i], pos = marker.find();\n    var mFrom = doc.clipPos(pos.from), mTo = doc.clipPos(pos.to);\n    if (cmp(mFrom, mTo)) {\n      var subMark = markText(doc, mFrom, mTo, marker.primary, marker.primary.type);\n      marker.markers.push(subMark);\n      subMark.parent = marker;\n    }\n  }\n}\n\nfunction detachSharedMarkers(markers) {\n  var loop = function ( i ) {\n    var marker = markers[i], linked = [marker.primary.doc];\n    linkedDocs(marker.primary.doc, function (d) { return linked.push(d); });\n    for (var j = 0; j < marker.markers.length; j++) {\n      var subMarker = marker.markers[j];\n      if (indexOf(linked, subMarker.doc) == -1) {\n        subMarker.parent = null;\n        marker.markers.splice(j--, 1);\n      }\n    }\n  };\n\n  for (var i = 0; i < markers.length; i++) loop( i );\n}\n\nvar nextDocId = 0;\nvar Doc = function(text, mode, firstLine, lineSep, direction) {\n  if (!(this instanceof Doc)) { return new Doc(text, mode, firstLine, lineSep, direction) }\n  if (firstLine == null) { firstLine = 0; }\n\n  BranchChunk.call(this, [new LeafChunk([new Line("", null)])]);\n  this.first = firstLine;\n  this.scrollTop = this.scrollLeft = 0;\n  this.cantEdit = false;\n  this.cleanGeneration = 1;\n  this.modeFrontier = this.highlightFrontier = firstLine;\n  var start = Pos(firstLine, 0);\n  this.sel = simpleSelection(start);\n  this.history = new History(null);\n  this.id = ++nextDocId;\n  this.modeOption = mode;\n  this.lineSep = lineSep;\n  this.direction = (direction == "rtl") ? "rtl" : "ltr";\n  this.extend = false;\n\n  if (typeof text == "string") { text = this.splitLines(text); }\n  updateDoc(this, {from: start, to: start, text: text});\n  setSelection(this, simpleSelection(start), sel_dontScroll);\n};\n\nDoc.prototype = createObj(BranchChunk.prototype, {\n  constructor: Doc,\n  // Iterate over the document. Supports two forms -- with only one\n  // argument, it calls that for each line in the document. With\n  // three, it iterates over the range given by the first two (with\n  // the second being non-inclusive).\n  iter: function(from, to, op) {\n    if (op) { this.iterN(from - this.first, to - from, op); }\n    else { this.iterN(this.first, this.first + this.size, from); }\n  },\n\n  // Non-public interface for adding and removing lines.\n  insert: function(at, lines) {\n    var height = 0;\n    for (var i = 0; i < lines.length; ++i) { height += lines[i].height; }\n    this.insertInner(at - this.first, lines, height);\n  },\n  remove: function(at, n) { this.removeInner(at - this.first, n); },\n\n  // From here, the methods are part of the public interface. Most\n  // are also available from CodeMirror (editor) instances.\n\n  getValue: function(lineSep) {\n    var lines = getLines(this, this.first, this.first + this.size);\n    if (lineSep === false) { return lines }\n    return lines.join(lineSep || this.lineSeparator())\n  },\n  setValue: docMethodOp(function(code) {\n    var top = Pos(this.first, 0), last = this.first + this.size - 1;\n    makeChange(this, {from: top, to: Pos(last, getLine(this, last).text.length),\n                      text: this.splitLines(code), origin: "setValue", full: true}, true);\n    if (this.cm) { scrollToCoords(this.cm, 0, 0); }\n    setSelection(this, simpleSelection(top), sel_dontScroll);\n  }),\n  replaceRange: function(code, from, to, origin) {\n    from = clipPos(this, from);\n    to = to ? clipPos(this, to) : from;\n    replaceRange(this, code, from, to, origin);\n  },\n  getRange: function(from, to, lineSep) {\n    var lines = getBetween(this, clipPos(this, from), clipPos(this, to));\n    if (lineSep === false) { return lines }\n    return lines.join(lineSep || this.lineSeparator())\n  },\n\n  getLine: function(line) {var l = this.getLineHandle(line); return l && l.text},\n\n  getLineHandle: function(line) {if (isLine(this, line)) { return getLine(this, line) }},\n  getLineNumber: function(line) {return lineNo(line)},\n\n  getLineHandleVisualStart: function(line) {\n    if (typeof line == "number") { line = getLine(this, line); }\n    return visualLine(line)\n  },\n\n  lineCount: function() {return this.size},\n  firstLine: function() {return this.first},\n  lastLine: function() {return this.first + this.size - 1},\n\n  clipPos: function(pos) {return clipPos(this, pos)},\n\n  getCursor: function(start) {\n    var range$$1 = this.sel.primary(), pos;\n    if (start == null || start == "head") { pos = range$$1.head; }\n    else if (start == "anchor") { pos = range$$1.anchor; }\n    else if (start == "end" || start == "to" || start === false) { pos = range$$1.to(); }\n    else { pos = range$$1.from(); }\n    return pos\n  },\n  listSelections: function() { return this.sel.ranges },\n  somethingSelected: function() {return this.sel.somethingSelected()},\n\n  setCursor: docMethodOp(function(line, ch, options) {\n    setSimpleSelection(this, clipPos(this, typeof line == "number" ? Pos(line, ch || 0) : line), null, options);\n  }),\n  setSelection: docMethodOp(function(anchor, head, options) {\n    setSimpleSelection(this, clipPos(this, anchor), clipPos(this, head || anchor), options);\n  }),\n  extendSelection: docMethodOp(function(head, other, options) {\n    extendSelection(this, clipPos(this, head), other && clipPos(this, other), options);\n  }),\n  extendSelections: docMethodOp(function(heads, options) {\n    extendSelections(this, clipPosArray(this, heads), options);\n  }),\n  extendSelectionsBy: docMethodOp(function(f, options) {\n    var heads = map(this.sel.ranges, f);\n    extendSelections(this, clipPosArray(this, heads), options);\n  }),\n  setSelections: docMethodOp(function(ranges, primary, options) {\n    var this$1 = this;\n\n    if (!ranges.length) { return }\n    var out = [];\n    for (var i = 0; i < ranges.length; i++)\n      { out[i] = new Range(clipPos(this$1, ranges[i].anchor),\n                         clipPos(this$1, ranges[i].head)); }\n    if (primary == null) { primary = Math.min(ranges.length - 1, this.sel.primIndex); }\n    setSelection(this, normalizeSelection(out, primary), options);\n  }),\n  addSelection: docMethodOp(function(anchor, head, options) {\n    var ranges = this.sel.ranges.slice(0);\n    ranges.push(new Range(clipPos(this, anchor), clipPos(this, head || anchor)));\n    setSelection(this, normalizeSelection(ranges, ranges.length - 1), options);\n  }),\n\n  getSelection: function(lineSep) {\n    var this$1 = this;\n\n    var ranges = this.sel.ranges, lines;\n    for (var i = 0; i < ranges.length; i++) {\n      var sel = getBetween(this$1, ranges[i].from(), ranges[i].to());\n      lines = lines ? lines.concat(sel) : sel;\n    }\n    if (lineSep === false) { return lines }\n    else { return lines.join(lineSep || this.lineSeparator()) }\n  },\n  getSelections: function(lineSep) {\n    var this$1 = this;\n\n    var parts = [], ranges = this.sel.ranges;\n    for (var i = 0; i < ranges.length; i++) {\n      var sel = getBetween(this$1, ranges[i].from(), ranges[i].to());\n      if (lineSep !== false) { sel = sel.join(lineSep || this$1.lineSeparator()); }\n      parts[i] = sel;\n    }\n    return parts\n  },\n  replaceSelection: function(code, collapse, origin) {\n    var dup = [];\n    for (var i = 0; i < this.sel.ranges.length; i++)\n      { dup[i] = code; }\n    this.replaceSelections(dup, collapse, origin || "+input");\n  },\n  replaceSelections: docMethodOp(function(code, collapse, origin) {\n    var this$1 = this;\n\n    var changes = [], sel = this.sel;\n    for (var i = 0; i < sel.ranges.length; i++) {\n      var range$$1 = sel.ranges[i];\n      changes[i] = {from: range$$1.from(), to: range$$1.to(), text: this$1.splitLines(code[i]), origin: origin};\n    }\n    var newSel = collapse && collapse != "end" && computeReplacedSel(this, changes, collapse);\n    for (var i$1 = changes.length - 1; i$1 >= 0; i$1--)\n      { makeChange(this$1, changes[i$1]); }\n    if (newSel) { setSelectionReplaceHistory(this, newSel); }\n    else if (this.cm) { ensureCursorVisible(this.cm); }\n  }),\n  undo: docMethodOp(function() {makeChangeFromHistory(this, "undo");}),\n  redo: docMethodOp(function() {makeChangeFromHistory(this, "redo");}),\n  undoSelection: docMethodOp(function() {makeChangeFromHistory(this, "undo", true);}),\n  redoSelection: docMethodOp(function() {makeChangeFromHistory(this, "redo", true);}),\n\n  setExtending: function(val) {this.extend = val;},\n  getExtending: function() {return this.extend},\n\n  historySize: function() {\n    var hist = this.history, done = 0, undone = 0;\n    for (var i = 0; i < hist.done.length; i++) { if (!hist.done[i].ranges) { ++done; } }\n    for (var i$1 = 0; i$1 < hist.undone.length; i$1++) { if (!hist.undone[i$1].ranges) { ++undone; } }\n    return {undo: done, redo: undone}\n  },\n  clearHistory: function() {this.history = new History(this.history.maxGeneration);},\n\n  markClean: function() {\n    this.cleanGeneration = this.changeGeneration(true);\n  },\n  changeGeneration: function(forceSplit) {\n    if (forceSplit)\n      { this.history.lastOp = this.history.lastSelOp = this.history.lastOrigin = null; }\n    return this.history.generation\n  },\n  isClean: function (gen) {\n    return this.history.generation == (gen || this.cleanGeneration)\n  },\n\n  getHistory: function() {\n    return {done: copyHistoryArray(this.history.done),\n            undone: copyHistoryArray(this.history.undone)}\n  },\n  setHistory: function(histData) {\n    var hist = this.history = new History(this.history.maxGeneration);\n    hist.done = copyHistoryArray(histData.done.slice(0), null, true);\n    hist.undone = copyHistoryArray(histData.undone.slice(0), null, true);\n  },\n\n  setGutterMarker: docMethodOp(function(line, gutterID, value) {\n    return changeLine(this, line, "gutter", function (line) {\n      var markers = line.gutterMarkers || (line.gutterMarkers = {});\n      markers[gutterID] = value;\n      if (!value && isEmpty(markers)) { line.gutterMarkers = null; }\n      return true\n    })\n  }),\n\n  clearGutter: docMethodOp(function(gutterID) {\n    var this$1 = this;\n\n    this.iter(function (line) {\n      if (line.gutterMarkers && line.gutterMarkers[gutterID]) {\n        changeLine(this$1, line, "gutter", function () {\n          line.gutterMarkers[gutterID] = null;\n          if (isEmpty(line.gutterMarkers)) { line.gutterMarkers = null; }\n          return true\n        });\n      }\n    });\n  }),\n\n  lineInfo: function(line) {\n    var n;\n    if (typeof line == "number") {\n      if (!isLine(this, line)) { return null }\n      n = line;\n      line = getLine(this, line);\n      if (!line) { return null }\n    } else {\n      n = lineNo(line);\n      if (n == null) { return null }\n    }\n    return {line: n, handle: line, text: line.text, gutterMarkers: line.gutterMarkers,\n            textClass: line.textClass, bgClass: line.bgClass, wrapClass: line.wrapClass,\n            widgets: line.widgets}\n  },\n\n  addLineClass: docMethodOp(function(handle, where, cls) {\n    return changeLine(this, handle, where == "gutter" ? "gutter" : "class", function (line) {\n      var prop = where == "text" ? "textClass"\n               : where == "background" ? "bgClass"\n               : where == "gutter" ? "gutterClass" : "wrapClass";\n      if (!line[prop]) { line[prop] = cls; }\n      else if (classTest(cls).test(line[prop])) { return false }\n      else { line[prop] += " " + cls; }\n      return true\n    })\n  }),\n  removeLineClass: docMethodOp(function(handle, where, cls) {\n    return changeLine(this, handle, where == "gutter" ? "gutter" : "class", function (line) {\n      var prop = where == "text" ? "textClass"\n               : where == "background" ? "bgClass"\n               : where == "gutter" ? "gutterClass" : "wrapClass";\n      var cur = line[prop];\n      if (!cur) { return false }\n      else if (cls == null) { line[prop] = null; }\n      else {\n        var found = cur.match(classTest(cls));\n        if (!found) { return false }\n        var end = found.index + found[0].length;\n        line[prop] = cur.slice(0, found.index) + (!found.index || end == cur.length ? "" : " ") + cur.slice(end) || null;\n      }\n      return true\n    })\n  }),\n\n  addLineWidget: docMethodOp(function(handle, node, options) {\n    return addLineWidget(this, handle, node, options)\n  }),\n  removeLineWidget: function(widget) { widget.clear(); },\n\n  markText: function(from, to, options) {\n    return markText(this, clipPos(this, from), clipPos(this, to), options, options && options.type || "range")\n  },\n  setBookmark: function(pos, options) {\n    var realOpts = {replacedWith: options && (options.nodeType == null ? options.widget : options),\n                    insertLeft: options && options.insertLeft,\n                    clearWhenEmpty: false, shared: options && options.shared,\n                    handleMouseEvents: options && options.handleMouseEvents};\n    pos = clipPos(this, pos);\n    return markText(this, pos, pos, realOpts, "bookmark")\n  },\n  findMarksAt: function(pos) {\n    pos = clipPos(this, pos);\n    var markers = [], spans = getLine(this, pos.line).markedSpans;\n    if (spans) { for (var i = 0; i < spans.length; ++i) {\n      var span = spans[i];\n      if ((span.from == null || span.from <= pos.ch) &&\n          (span.to == null || span.to >= pos.ch))\n        { markers.push(span.marker.parent || span.marker); }\n    } }\n    return markers\n  },\n  findMarks: function(from, to, filter) {\n    from = clipPos(this, from); to = clipPos(this, to);\n    var found = [], lineNo$$1 = from.line;\n    this.iter(from.line, to.line + 1, function (line) {\n      var spans = line.markedSpans;\n      if (spans) { for (var i = 0; i < spans.length; i++) {\n        var span = spans[i];\n        if (!(span.to != null && lineNo$$1 == from.line && from.ch >= span.to ||\n              span.from == null && lineNo$$1 != from.line ||\n              span.from != null && lineNo$$1 == to.line && span.from >= to.ch) &&\n            (!filter || filter(span.marker)))\n          { found.push(span.marker.parent || span.marker); }\n      } }\n      ++lineNo$$1;\n    });\n    return found\n  },\n  getAllMarks: function() {\n    var markers = [];\n    this.iter(function (line) {\n      var sps = line.markedSpans;\n      if (sps) { for (var i = 0; i < sps.length; ++i)\n        { if (sps[i].from != null) { markers.push(sps[i].marker); } } }\n    });\n    return markers\n  },\n\n  posFromIndex: function(off) {\n    var ch, lineNo$$1 = this.first, sepSize = this.lineSeparator().length;\n    this.iter(function (line) {\n      var sz = line.text.length + sepSize;\n      if (sz > off) { ch = off; return true }\n      off -= sz;\n      ++lineNo$$1;\n    });\n    return clipPos(this, Pos(lineNo$$1, ch))\n  },\n  indexFromPos: function (coords) {\n    coords = clipPos(this, coords);\n    var index = coords.ch;\n    if (coords.line < this.first || coords.ch < 0) { return 0 }\n    var sepSize = this.lineSeparator().length;\n    this.iter(this.first, coords.line, function (line) { // iter aborts when callback returns a truthy value\n      index += line.text.length + sepSize;\n    });\n    return index\n  },\n\n  copy: function(copyHistory) {\n    var doc = new Doc(getLines(this, this.first, this.first + this.size),\n                      this.modeOption, this.first, this.lineSep, this.direction);\n    doc.scrollTop = this.scrollTop; doc.scrollLeft = this.scrollLeft;\n    doc.sel = this.sel;\n    doc.extend = false;\n    if (copyHistory) {\n      doc.history.undoDepth = this.history.undoDepth;\n      doc.setHistory(this.getHistory());\n    }\n    return doc\n  },\n\n  linkedDoc: function(options) {\n    if (!options) { options = {}; }\n    var from = this.first, to = this.first + this.size;\n    if (options.from != null && options.from > from) { from = options.from; }\n    if (options.to != null && options.to < to) { to = options.to; }\n    var copy = new Doc(getLines(this, from, to), options.mode || this.modeOption, from, this.lineSep, this.direction);\n    if (options.sharedHist) { copy.history = this.history\n    ; }(this.linked || (this.linked = [])).push({doc: copy, sharedHist: options.sharedHist});\n    copy.linked = [{doc: this, isParent: true, sharedHist: options.sharedHist}];\n    copySharedMarkers(copy, findSharedMarkers(this));\n    return copy\n  },\n  unlinkDoc: function(other) {\n    var this$1 = this;\n\n    if (other instanceof CodeMirror$1) { other = other.doc; }\n    if (this.linked) { for (var i = 0; i < this.linked.length; ++i) {\n      var link = this$1.linked[i];\n      if (link.doc != other) { continue }\n      this$1.linked.splice(i, 1);\n      other.unlinkDoc(this$1);\n      detachSharedMarkers(findSharedMarkers(this$1));\n      break\n    } }\n    // If the histories were shared, split them again\n    if (other.history == this.history) {\n      var splitIds = [other.id];\n      linkedDocs(other, function (doc) { return splitIds.push(doc.id); }, true);\n      other.history = new History(null);\n      other.history.done = copyHistoryArray(this.history.done, splitIds);\n      other.history.undone = copyHistoryArray(this.history.undone, splitIds);\n    }\n  },\n  iterLinkedDocs: function(f) {linkedDocs(this, f);},\n\n  getMode: function() {return this.mode},\n  getEditor: function() {return this.cm},\n\n  splitLines: function(str) {\n    if (this.lineSep) { return str.split(this.lineSep) }\n    return splitLinesAuto(str)\n  },\n  lineSeparator: function() { return this.lineSep || "\\n" },\n\n  setDirection: docMethodOp(function (dir) {\n    if (dir != "rtl") { dir = "ltr"; }\n    if (dir == this.direction) { return }\n    this.direction = dir;\n    this.iter(function (line) { return line.order = null; });\n    if (this.cm) { directionChanged(this.cm); }\n  })\n});\n\n// Public alias.\nDoc.prototype.eachLine = Doc.prototype.iter;\n\n// Kludge to work around strange IE behavior where it\'ll sometimes\n// re-fire a series of drag-related events right after the drop (#1551)\nvar lastDrop = 0;\n\nfunction onDrop(e) {\n  var cm = this;\n  clearDragCursor(cm);\n  if (signalDOMEvent(cm, e) || eventInWidget(cm.display, e))\n    { return }\n  e_preventDefault(e);\n  if (ie) { lastDrop = +new Date; }\n  var pos = posFromMouse(cm, e, true), files = e.dataTransfer.files;\n  if (!pos || cm.isReadOnly()) { return }\n  // Might be a file drop, in which case we simply extract the text\n  // and insert it.\n  if (files && files.length && window.FileReader && window.File) {\n    var n = files.length, text = Array(n), read = 0;\n    var loadFile = function (file, i) {\n      if (cm.options.allowDropFileTypes &&\n          indexOf(cm.options.allowDropFileTypes, file.type) == -1)\n        { return }\n\n      var reader = new FileReader;\n      reader.onload = operation(cm, function () {\n        var content = reader.result;\n        if (/[\\x00-\\x08\\x0e-\\x1f]{2}/.test(content)) { content = ""; }\n        text[i] = content;\n        if (++read == n) {\n          pos = clipPos(cm.doc, pos);\n          var change = {from: pos, to: pos,\n                        text: cm.doc.splitLines(text.join(cm.doc.lineSeparator())),\n                        origin: "paste"};\n          makeChange(cm.doc, change);\n          setSelectionReplaceHistory(cm.doc, simpleSelection(pos, changeEnd(change)));\n        }\n      });\n      reader.readAsText(file);\n    };\n    for (var i = 0; i < n; ++i) { loadFile(files[i], i); }\n  } else { // Normal drop\n    // Don\'t do a replace if the drop happened inside of the selected text.\n    if (cm.state.draggingText && cm.doc.sel.contains(pos) > -1) {\n      cm.state.draggingText(e);\n      // Ensure the editor is re-focused\n      setTimeout(function () { return cm.display.input.focus(); }, 20);\n      return\n    }\n    try {\n      var text$1 = e.dataTransfer.getData("Text");\n      if (text$1) {\n        var selected;\n        if (cm.state.draggingText && !cm.state.draggingText.copy)\n          { selected = cm.listSelections(); }\n        setSelectionNoUndo(cm.doc, simpleSelection(pos, pos));\n        if (selected) { for (var i$1 = 0; i$1 < selected.length; ++i$1)\n          { replaceRange(cm.doc, "", selected[i$1].anchor, selected[i$1].head, "drag"); } }\n        cm.replaceSelection(text$1, "around", "paste");\n        cm.display.input.focus();\n      }\n    }\n    catch(e){}\n  }\n}\n\nfunction onDragStart(cm, e) {\n  if (ie && (!cm.state.draggingText || +new Date - lastDrop < 100)) { e_stop(e); return }\n  if (signalDOMEvent(cm, e) || eventInWidget(cm.display, e)) { return }\n\n  e.dataTransfer.setData("Text", cm.getSelection());\n  e.dataTransfer.effectAllowed = "copyMove";\n\n  // Use dummy image instead of default browsers image.\n  // Recent Safari (~6.0.2) have a tendency to segfault when this happens, so we don\'t do it there.\n  if (e.dataTransfer.setDragImage && !safari) {\n    var img = elt("img", null, null, "position: fixed; left: 0; top: 0;");\n    img.src = "data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";\n    if (presto) {\n      img.width = img.height = 1;\n      cm.display.wrapper.appendChild(img);\n      // Force a relayout, or Opera won\'t use our image for some obscure reason\n      img._top = img.offsetTop;\n    }\n    e.dataTransfer.setDragImage(img, 0, 0);\n    if (presto) { img.parentNode.removeChild(img); }\n  }\n}\n\nfunction onDragOver(cm, e) {\n  var pos = posFromMouse(cm, e);\n  if (!pos) { return }\n  var frag = document.createDocumentFragment();\n  drawSelectionCursor(cm, pos, frag);\n  if (!cm.display.dragCursor) {\n    cm.display.dragCursor = elt("div", null, "CodeMirror-cursors CodeMirror-dragcursors");\n    cm.display.lineSpace.insertBefore(cm.display.dragCursor, cm.display.cursorDiv);\n  }\n  removeChildrenAndAdd(cm.display.dragCursor, frag);\n}\n\nfunction clearDragCursor(cm) {\n  if (cm.display.dragCursor) {\n    cm.display.lineSpace.removeChild(cm.display.dragCursor);\n    cm.display.dragCursor = null;\n  }\n}\n\n// These must be handled carefully, because naively registering a\n// handler for each editor will cause the editors to never be\n// garbage collected.\n\nfunction forEachCodeMirror(f) {\n  if (!document.getElementsByClassName) { return }\n  var byClass = document.getElementsByClassName("CodeMirror");\n  for (var i = 0; i < byClass.length; i++) {\n    var cm = byClass[i].CodeMirror;\n    if (cm) { f(cm); }\n  }\n}\n\nvar globalsRegistered = false;\nfunction ensureGlobalHandlers() {\n  if (globalsRegistered) { return }\n  registerGlobalHandlers();\n  globalsRegistered = true;\n}\nfunction registerGlobalHandlers() {\n  // When the window resizes, we need to refresh active editors.\n  var resizeTimer;\n  on(window, "resize", function () {\n    if (resizeTimer == null) { resizeTimer = setTimeout(function () {\n      resizeTimer = null;\n      forEachCodeMirror(onResize);\n    }, 100); }\n  });\n  // When the window loses focus, we want to show the editor as blurred\n  on(window, "blur", function () { return forEachCodeMirror(onBlur); });\n}\n// Called when the window resizes\nfunction onResize(cm) {\n  var d = cm.display;\n  if (d.lastWrapHeight == d.wrapper.clientHeight && d.lastWrapWidth == d.wrapper.clientWidth)\n    { return }\n  // Might be a text scaling operation, clear size caches.\n  d.cachedCharWidth = d.cachedTextHeight = d.cachedPaddingH = null;\n  d.scrollbarsClipped = false;\n  cm.setSize();\n}\n\nvar keyNames = {\n  3: "Enter", 8: "Backspace", 9: "Tab", 13: "Enter", 16: "Shift", 17: "Ctrl", 18: "Alt",\n  19: "Pause", 20: "CapsLock", 27: "Esc", 32: "Space", 33: "PageUp", 34: "PageDown", 35: "End",\n  36: "Home", 37: "Left", 38: "Up", 39: "Right", 40: "Down", 44: "PrintScrn", 45: "Insert",\n  46: "Delete", 59: ";", 61: "=", 91: "Mod", 92: "Mod", 93: "Mod",\n  106: "*", 107: "=", 109: "-", 110: ".", 111: "/", 127: "Delete",\n  173: "-", 186: ";", 187: "=", 188: ",", 189: "-", 190: ".", 191: "/", 192: "`", 219: "[", 220: "\\\\",\n  221: "]", 222: "\'", 63232: "Up", 63233: "Down", 63234: "Left", 63235: "Right", 63272: "Delete",\n  63273: "Home", 63275: "End", 63276: "PageUp", 63277: "PageDown", 63302: "Insert"\n};\n\n// Number keys\nfor (var i = 0; i < 10; i++) { keyNames[i + 48] = keyNames[i + 96] = String(i); }\n// Alphabetic keys\nfor (var i$1 = 65; i$1 <= 90; i$1++) { keyNames[i$1] = String.fromCharCode(i$1); }\n// Function keys\nfor (var i$2 = 1; i$2 <= 12; i$2++) { keyNames[i$2 + 111] = keyNames[i$2 + 63235] = "F" + i$2; }\n\nvar keyMap = {};\n\nkeyMap.basic = {\n  "Left": "goCharLeft", "Right": "goCharRight", "Up": "goLineUp", "Down": "goLineDown",\n  "End": "goLineEnd", "Home": "goLineStartSmart", "PageUp": "goPageUp", "PageDown": "goPageDown",\n  "Delete": "delCharAfter", "Backspace": "delCharBefore", "Shift-Backspace": "delCharBefore",\n  "Tab": "defaultTab", "Shift-Tab": "indentAuto",\n  "Enter": "newlineAndIndent", "Insert": "toggleOverwrite",\n  "Esc": "singleSelection"\n};\n// Note that the save and find-related commands aren\'t defined by\n// default. User code or addons can define them. Unknown commands\n// are simply ignored.\nkeyMap.pcDefault = {\n  "Ctrl-A": "selectAll", "Ctrl-D": "deleteLine", "Ctrl-Z": "undo", "Shift-Ctrl-Z": "redo", "Ctrl-Y": "redo",\n  "Ctrl-Home": "goDocStart", "Ctrl-End": "goDocEnd", "Ctrl-Up": "goLineUp", "Ctrl-Down": "goLineDown",\n  "Ctrl-Left": "goGroupLeft", "Ctrl-Right": "goGroupRight", "Alt-Left": "goLineStart", "Alt-Right": "goLineEnd",\n  "Ctrl-Backspace": "delGroupBefore", "Ctrl-Delete": "delGroupAfter", "Ctrl-S": "save", "Ctrl-F": "find",\n  "Ctrl-G": "findNext", "Shift-Ctrl-G": "findPrev", "Shift-Ctrl-F": "replace", "Shift-Ctrl-R": "replaceAll",\n  "Ctrl-[": "indentLess", "Ctrl-]": "indentMore",\n  "Ctrl-U": "undoSelection", "Shift-Ctrl-U": "redoSelection", "Alt-U": "redoSelection",\n  fallthrough: "basic"\n};\n// Very basic readline/emacs-style bindings, which are standard on Mac.\nkeyMap.emacsy = {\n  "Ctrl-F": "goCharRight", "Ctrl-B": "goCharLeft", "Ctrl-P": "goLineUp", "Ctrl-N": "goLineDown",\n  "Alt-F": "goWordRight", "Alt-B": "goWordLeft", "Ctrl-A": "goLineStart", "Ctrl-E": "goLineEnd",\n  "Ctrl-V": "goPageDown", "Shift-Ctrl-V": "goPageUp", "Ctrl-D": "delCharAfter", "Ctrl-H": "delCharBefore",\n  "Alt-D": "delWordAfter", "Alt-Backspace": "delWordBefore", "Ctrl-K": "killLine", "Ctrl-T": "transposeChars",\n  "Ctrl-O": "openLine"\n};\nkeyMap.macDefault = {\n  "Cmd-A": "selectAll", "Cmd-D": "deleteLine", "Cmd-Z": "undo", "Shift-Cmd-Z": "redo", "Cmd-Y": "redo",\n  "Cmd-Home": "goDocStart", "Cmd-Up": "goDocStart", "Cmd-End": "goDocEnd", "Cmd-Down": "goDocEnd", "Alt-Left": "goGroupLeft",\n  "Alt-Right": "goGroupRight", "Cmd-Left": "goLineLeft", "Cmd-Right": "goLineRight", "Alt-Backspace": "delGroupBefore",\n  "Ctrl-Alt-Backspace": "delGroupAfter", "Alt-Delete": "delGroupAfter", "Cmd-S": "save", "Cmd-F": "find",\n  "Cmd-G": "findNext", "Shift-Cmd-G": "findPrev", "Cmd-Alt-F": "replace", "Shift-Cmd-Alt-F": "replaceAll",\n  "Cmd-[": "indentLess", "Cmd-]": "indentMore", "Cmd-Backspace": "delWrappedLineLeft", "Cmd-Delete": "delWrappedLineRight",\n  "Cmd-U": "undoSelection", "Shift-Cmd-U": "redoSelection", "Ctrl-Up": "goDocStart", "Ctrl-Down": "goDocEnd",\n  fallthrough: ["basic", "emacsy"]\n};\nkeyMap["default"] = mac ? keyMap.macDefault : keyMap.pcDefault;\n\n// KEYMAP DISPATCH\n\nfunction normalizeKeyName(name) {\n  var parts = name.split(/-(?!$)/);\n  name = parts[parts.length - 1];\n  var alt, ctrl, shift, cmd;\n  for (var i = 0; i < parts.length - 1; i++) {\n    var mod = parts[i];\n    if (/^(cmd|meta|m)$/i.test(mod)) { cmd = true; }\n    else if (/^a(lt)?$/i.test(mod)) { alt = true; }\n    else if (/^(c|ctrl|control)$/i.test(mod)) { ctrl = true; }\n    else if (/^s(hift)?$/i.test(mod)) { shift = true; }\n    else { throw new Error("Unrecognized modifier name: " + mod) }\n  }\n  if (alt) { name = "Alt-" + name; }\n  if (ctrl) { name = "Ctrl-" + name; }\n  if (cmd) { name = "Cmd-" + name; }\n  if (shift) { name = "Shift-" + name; }\n  return name\n}\n\n// This is a kludge to keep keymaps mostly working as raw objects\n// (backwards compatibility) while at the same time support features\n// like normalization and multi-stroke key bindings. It compiles a\n// new normalized keymap, and then updates the old object to reflect\n// this.\nfunction normalizeKeyMap(keymap) {\n  var copy = {};\n  for (var keyname in keymap) { if (keymap.hasOwnProperty(keyname)) {\n    var value = keymap[keyname];\n    if (/^(name|fallthrough|(de|at)tach)$/.test(keyname)) { continue }\n    if (value == "...") { delete keymap[keyname]; continue }\n\n    var keys = map(keyname.split(" "), normalizeKeyName);\n    for (var i = 0; i < keys.length; i++) {\n      var val = (void 0), name = (void 0);\n      if (i == keys.length - 1) {\n        name = keys.join(" ");\n        val = value;\n      } else {\n        name = keys.slice(0, i + 1).join(" ");\n        val = "...";\n      }\n      var prev = copy[name];\n      if (!prev) { copy[name] = val; }\n      else if (prev != val) { throw new Error("Inconsistent bindings for " + name) }\n    }\n    delete keymap[keyname];\n  } }\n  for (var prop in copy) { keymap[prop] = copy[prop]; }\n  return keymap\n}\n\nfunction lookupKey(key, map$$1, handle, context) {\n  map$$1 = getKeyMap(map$$1);\n  var found = map$$1.call ? map$$1.call(key, context) : map$$1[key];\n  if (found === false) { return "nothing" }\n  if (found === "...") { return "multi" }\n  if (found != null && handle(found)) { return "handled" }\n\n  if (map$$1.fallthrough) {\n    if (Object.prototype.toString.call(map$$1.fallthrough) != "[object Array]")\n      { return lookupKey(key, map$$1.fallthrough, handle, context) }\n    for (var i = 0; i < map$$1.fallthrough.length; i++) {\n      var result = lookupKey(key, map$$1.fallthrough[i], handle, context);\n      if (result) { return result }\n    }\n  }\n}\n\n// Modifier key presses don\'t count as \'real\' key presses for the\n// purpose of keymap fallthrough.\nfunction isModifierKey(value) {\n  var name = typeof value == "string" ? value : keyNames[value.keyCode];\n  return name == "Ctrl" || name == "Alt" || name == "Shift" || name == "Mod"\n}\n\nfunction addModifierNames(name, event, noShift) {\n  var base = name;\n  if (event.altKey && base != "Alt") { name = "Alt-" + name; }\n  if ((flipCtrlCmd ? event.metaKey : event.ctrlKey) && base != "Ctrl") { name = "Ctrl-" + name; }\n  if ((flipCtrlCmd ? event.ctrlKey : event.metaKey) && base != "Cmd") { name = "Cmd-" + name; }\n  if (!noShift && event.shiftKey && base != "Shift") { name = "Shift-" + name; }\n  return name\n}\n\n// Look up the name of a key as indicated by an event object.\nfunction keyName(event, noShift) {\n  if (presto && event.keyCode == 34 && event["char"]) { return false }\n  var name = keyNames[event.keyCode];\n  if (name == null || event.altGraphKey) { return false }\n  return addModifierNames(name, event, noShift)\n}\n\nfunction getKeyMap(val) {\n  return typeof val == "string" ? keyMap[val] : val\n}\n\n// Helper for deleting text near the selection(s), used to implement\n// backspace, delete, and similar functionality.\nfunction deleteNearSelection(cm, compute) {\n  var ranges = cm.doc.sel.ranges, kill = [];\n  // Build up a set of ranges to kill first, merging overlapping\n  // ranges.\n  for (var i = 0; i < ranges.length; i++) {\n    var toKill = compute(ranges[i]);\n    while (kill.length && cmp(toKill.from, lst(kill).to) <= 0) {\n      var replaced = kill.pop();\n      if (cmp(replaced.from, toKill.from) < 0) {\n        toKill.from = replaced.from;\n        break\n      }\n    }\n    kill.push(toKill);\n  }\n  // Next, remove those actual ranges.\n  runInOp(cm, function () {\n    for (var i = kill.length - 1; i >= 0; i--)\n      { replaceRange(cm.doc, "", kill[i].from, kill[i].to, "+delete"); }\n    ensureCursorVisible(cm);\n  });\n}\n\n// Commands are parameter-less actions that can be performed on an\n// editor, mostly used for keybindings.\nvar commands = {\n  selectAll: selectAll,\n  singleSelection: function (cm) { return cm.setSelection(cm.getCursor("anchor"), cm.getCursor("head"), sel_dontScroll); },\n  killLine: function (cm) { return deleteNearSelection(cm, function (range) {\n    if (range.empty()) {\n      var len = getLine(cm.doc, range.head.line).text.length;\n      if (range.head.ch == len && range.head.line < cm.lastLine())\n        { return {from: range.head, to: Pos(range.head.line + 1, 0)} }\n      else\n        { return {from: range.head, to: Pos(range.head.line, len)} }\n    } else {\n      return {from: range.from(), to: range.to()}\n    }\n  }); },\n  deleteLine: function (cm) { return deleteNearSelection(cm, function (range) { return ({\n    from: Pos(range.from().line, 0),\n    to: clipPos(cm.doc, Pos(range.to().line + 1, 0))\n  }); }); },\n  delLineLeft: function (cm) { return deleteNearSelection(cm, function (range) { return ({\n    from: Pos(range.from().line, 0), to: range.from()\n  }); }); },\n  delWrappedLineLeft: function (cm) { return deleteNearSelection(cm, function (range) {\n    var top = cm.charCoords(range.head, "div").top + 5;\n    var leftPos = cm.coordsChar({left: 0, top: top}, "div");\n    return {from: leftPos, to: range.from()}\n  }); },\n  delWrappedLineRight: function (cm) { return deleteNearSelection(cm, function (range) {\n    var top = cm.charCoords(range.head, "div").top + 5;\n    var rightPos = cm.coordsChar({left: cm.display.lineDiv.offsetWidth + 100, top: top}, "div");\n    return {from: range.from(), to: rightPos }\n  }); },\n  undo: function (cm) { return cm.undo(); },\n  redo: function (cm) { return cm.redo(); },\n  undoSelection: function (cm) { return cm.undoSelection(); },\n  redoSelection: function (cm) { return cm.redoSelection(); },\n  goDocStart: function (cm) { return cm.extendSelection(Pos(cm.firstLine(), 0)); },\n  goDocEnd: function (cm) { return cm.extendSelection(Pos(cm.lastLine())); },\n  goLineStart: function (cm) { return cm.extendSelectionsBy(function (range) { return lineStart(cm, range.head.line); },\n    {origin: "+move", bias: 1}\n  ); },\n  goLineStartSmart: function (cm) { return cm.extendSelectionsBy(function (range) { return lineStartSmart(cm, range.head); },\n    {origin: "+move", bias: 1}\n  ); },\n  goLineEnd: function (cm) { return cm.extendSelectionsBy(function (range) { return lineEnd(cm, range.head.line); },\n    {origin: "+move", bias: -1}\n  ); },\n  goLineRight: function (cm) { return cm.extendSelectionsBy(function (range) {\n    var top = cm.cursorCoords(range.head, "div").top + 5;\n    return cm.coordsChar({left: cm.display.lineDiv.offsetWidth + 100, top: top}, "div")\n  }, sel_move); },\n  goLineLeft: function (cm) { return cm.extendSelectionsBy(function (range) {\n    var top = cm.cursorCoords(range.head, "div").top + 5;\n    return cm.coordsChar({left: 0, top: top}, "div")\n  }, sel_move); },\n  goLineLeftSmart: function (cm) { return cm.extendSelectionsBy(function (range) {\n    var top = cm.cursorCoords(range.head, "div").top + 5;\n    var pos = cm.coordsChar({left: 0, top: top}, "div");\n    if (pos.ch < cm.getLine(pos.line).search(/\\S/)) { return lineStartSmart(cm, range.head) }\n    return pos\n  }, sel_move); },\n  goLineUp: function (cm) { return cm.moveV(-1, "line"); },\n  goLineDown: function (cm) { return cm.moveV(1, "line"); },\n  goPageUp: function (cm) { return cm.moveV(-1, "page"); },\n  goPageDown: function (cm) { return cm.moveV(1, "page"); },\n  goCharLeft: function (cm) { return cm.moveH(-1, "char"); },\n  goCharRight: function (cm) { return cm.moveH(1, "char"); },\n  goColumnLeft: function (cm) { return cm.moveH(-1, "column"); },\n  goColumnRight: function (cm) { return cm.moveH(1, "column"); },\n  goWordLeft: function (cm) { return cm.moveH(-1, "word"); },\n  goGroupRight: function (cm) { return cm.moveH(1, "group"); },\n  goGroupLeft: function (cm) { return cm.moveH(-1, "group"); },\n  goWordRight: function (cm) { return cm.moveH(1, "word"); },\n  delCharBefore: function (cm) { return cm.deleteH(-1, "char"); },\n  delCharAfter: function (cm) { return cm.deleteH(1, "char"); },\n  delWordBefore: function (cm) { return cm.deleteH(-1, "word"); },\n  delWordAfter: function (cm) { return cm.deleteH(1, "word"); },\n  delGroupBefore: function (cm) { return cm.deleteH(-1, "group"); },\n  delGroupAfter: function (cm) { return cm.deleteH(1, "group"); },\n  indentAuto: function (cm) { return cm.indentSelection("smart"); },\n  indentMore: function (cm) { return cm.indentSelection("add"); },\n  indentLess: function (cm) { return cm.indentSelection("subtract"); },\n  insertTab: function (cm) { return cm.replaceSelection("\\t"); },\n  insertSoftTab: function (cm) {\n    var spaces = [], ranges = cm.listSelections(), tabSize = cm.options.tabSize;\n    for (var i = 0; i < ranges.length; i++) {\n      var pos = ranges[i].from();\n      var col = countColumn(cm.getLine(pos.line), pos.ch, tabSize);\n      spaces.push(spaceStr(tabSize - col % tabSize));\n    }\n    cm.replaceSelections(spaces);\n  },\n  defaultTab: function (cm) {\n    if (cm.somethingSelected()) { cm.indentSelection("add"); }\n    else { cm.execCommand("insertTab"); }\n  },\n  // Swap the two chars left and right of each selection\'s head.\n  // Move cursor behind the two swapped characters afterwards.\n  //\n  // Doesn\'t consider line feeds a character.\n  // Doesn\'t scan more than one line above to find a character.\n  // Doesn\'t do anything on an empty line.\n  // Doesn\'t do anything with non-empty selections.\n  transposeChars: function (cm) { return runInOp(cm, function () {\n    var ranges = cm.listSelections(), newSel = [];\n    for (var i = 0; i < ranges.length; i++) {\n      if (!ranges[i].empty()) { continue }\n      var cur = ranges[i].head, line = getLine(cm.doc, cur.line).text;\n      if (line) {\n        if (cur.ch == line.length) { cur = new Pos(cur.line, cur.ch - 1); }\n        if (cur.ch > 0) {\n          cur = new Pos(cur.line, cur.ch + 1);\n          cm.replaceRange(line.charAt(cur.ch - 1) + line.charAt(cur.ch - 2),\n                          Pos(cur.line, cur.ch - 2), cur, "+transpose");\n        } else if (cur.line > cm.doc.first) {\n          var prev = getLine(cm.doc, cur.line - 1).text;\n          if (prev) {\n            cur = new Pos(cur.line, 1);\n            cm.replaceRange(line.charAt(0) + cm.doc.lineSeparator() +\n                            prev.charAt(prev.length - 1),\n                            Pos(cur.line - 1, prev.length - 1), cur, "+transpose");\n          }\n        }\n      }\n      newSel.push(new Range(cur, cur));\n    }\n    cm.setSelections(newSel);\n  }); },\n  newlineAndIndent: function (cm) { return runInOp(cm, function () {\n    var sels = cm.listSelections();\n    for (var i = sels.length - 1; i >= 0; i--)\n      { cm.replaceRange(cm.doc.lineSeparator(), sels[i].anchor, sels[i].head, "+input"); }\n    sels = cm.listSelections();\n    for (var i$1 = 0; i$1 < sels.length; i$1++)\n      { cm.indentLine(sels[i$1].from().line, null, true); }\n    ensureCursorVisible(cm);\n  }); },\n  openLine: function (cm) { return cm.replaceSelection("\\n", "start"); },\n  toggleOverwrite: function (cm) { return cm.toggleOverwrite(); }\n};\n\n\nfunction lineStart(cm, lineN) {\n  var line = getLine(cm.doc, lineN);\n  var visual = visualLine(line);\n  if (visual != line) { lineN = lineNo(visual); }\n  return endOfLine(true, cm, visual, lineN, 1)\n}\nfunction lineEnd(cm, lineN) {\n  var line = getLine(cm.doc, lineN);\n  var visual = visualLineEnd(line);\n  if (visual != line) { lineN = lineNo(visual); }\n  return endOfLine(true, cm, line, lineN, -1)\n}\nfunction lineStartSmart(cm, pos) {\n  var start = lineStart(cm, pos.line);\n  var line = getLine(cm.doc, start.line);\n  var order = getOrder(line, cm.doc.direction);\n  if (!order || order[0].level == 0) {\n    var firstNonWS = Math.max(0, line.text.search(/\\S/));\n    var inWS = pos.line == start.line && pos.ch <= firstNonWS && pos.ch;\n    return Pos(start.line, inWS ? 0 : firstNonWS, start.sticky)\n  }\n  return start\n}\n\n// Run a handler that was bound to a key.\nfunction doHandleBinding(cm, bound, dropShift) {\n  if (typeof bound == "string") {\n    bound = commands[bound];\n    if (!bound) { return false }\n  }\n  // Ensure previous input has been read, so that the handler sees a\n  // consistent view of the document\n  cm.display.input.ensurePolled();\n  var prevShift = cm.display.shift, done = false;\n  try {\n    if (cm.isReadOnly()) { cm.state.suppressEdits = true; }\n    if (dropShift) { cm.display.shift = false; }\n    done = bound(cm) != Pass;\n  } finally {\n    cm.display.shift = prevShift;\n    cm.state.suppressEdits = false;\n  }\n  return done\n}\n\nfunction lookupKeyForEditor(cm, name, handle) {\n  for (var i = 0; i < cm.state.keyMaps.length; i++) {\n    var result = lookupKey(name, cm.state.keyMaps[i], handle, cm);\n    if (result) { return result }\n  }\n  return (cm.options.extraKeys && lookupKey(name, cm.options.extraKeys, handle, cm))\n    || lookupKey(name, cm.options.keyMap, handle, cm)\n}\n\n// Note that, despite the name, this function is also used to check\n// for bound mouse clicks.\n\nvar stopSeq = new Delayed;\nfunction dispatchKey(cm, name, e, handle) {\n  var seq = cm.state.keySeq;\n  if (seq) {\n    if (isModifierKey(name)) { return "handled" }\n    stopSeq.set(50, function () {\n      if (cm.state.keySeq == seq) {\n        cm.state.keySeq = null;\n        cm.display.input.reset();\n      }\n    });\n    name = seq + " " + name;\n  }\n  var result = lookupKeyForEditor(cm, name, handle);\n\n  if (result == "multi")\n    { cm.state.keySeq = name; }\n  if (result == "handled")\n    { signalLater(cm, "keyHandled", cm, name, e); }\n\n  if (result == "handled" || result == "multi") {\n    e_preventDefault(e);\n    restartBlink(cm);\n  }\n\n  if (seq && !result && /\\\'$/.test(name)) {\n    e_preventDefault(e);\n    return true\n  }\n  return !!result\n}\n\n// Handle a key from the keydown event.\nfunction handleKeyBinding(cm, e) {\n  var name = keyName(e, true);\n  if (!name) { return false }\n\n  if (e.shiftKey && !cm.state.keySeq) {\n    // First try to resolve full name (including \'Shift-\'). Failing\n    // that, see if there is a cursor-motion command (starting with\n    // \'go\') bound to the keyname without \'Shift-\'.\n    return dispatchKey(cm, "Shift-" + name, e, function (b) { return doHandleBinding(cm, b, true); })\n        || dispatchKey(cm, name, e, function (b) {\n             if (typeof b == "string" ? /^go[A-Z]/.test(b) : b.motion)\n               { return doHandleBinding(cm, b) }\n           })\n  } else {\n    return dispatchKey(cm, name, e, function (b) { return doHandleBinding(cm, b); })\n  }\n}\n\n// Handle a key from the keypress event\nfunction handleCharBinding(cm, e, ch) {\n  return dispatchKey(cm, "\'" + ch + "\'", e, function (b) { return doHandleBinding(cm, b, true); })\n}\n\nvar lastStoppedKey = null;\nfunction onKeyDown(e) {\n  var cm = this;\n  cm.curOp.focus = activeElt();\n  if (signalDOMEvent(cm, e)) { return }\n  // IE does strange things with escape.\n  if (ie && ie_version < 11 && e.keyCode == 27) { e.returnValue = false; }\n  var code = e.keyCode;\n  cm.display.shift = code == 16 || e.shiftKey;\n  var handled = handleKeyBinding(cm, e);\n  if (presto) {\n    lastStoppedKey = handled ? code : null;\n    // Opera has no cut event... we try to at least catch the key combo\n    if (!handled && code == 88 && !hasCopyEvent && (mac ? e.metaKey : e.ctrlKey))\n      { cm.replaceSelection("", null, "cut"); }\n  }\n\n  // Turn mouse into crosshair when Alt is held on Mac.\n  if (code == 18 && !/\\bCodeMirror-crosshair\\b/.test(cm.display.lineDiv.className))\n    { showCrossHair(cm); }\n}\n\nfunction showCrossHair(cm) {\n  var lineDiv = cm.display.lineDiv;\n  addClass(lineDiv, "CodeMirror-crosshair");\n\n  function up(e) {\n    if (e.keyCode == 18 || !e.altKey) {\n      rmClass(lineDiv, "CodeMirror-crosshair");\n      off(document, "keyup", up);\n      off(document, "mouseover", up);\n    }\n  }\n  on(document, "keyup", up);\n  on(document, "mouseover", up);\n}\n\nfunction onKeyUp(e) {\n  if (e.keyCode == 16) { this.doc.sel.shift = false; }\n  signalDOMEvent(this, e);\n}\n\nfunction onKeyPress(e) {\n  var cm = this;\n  if (eventInWidget(cm.display, e) || signalDOMEvent(cm, e) || e.ctrlKey && !e.altKey || mac && e.metaKey) { return }\n  var keyCode = e.keyCode, charCode = e.charCode;\n  if (presto && keyCode == lastStoppedKey) {lastStoppedKey = null; e_preventDefault(e); return}\n  if ((presto && (!e.which || e.which < 10)) && handleKeyBinding(cm, e)) { return }\n  var ch = String.fromCharCode(charCode == null ? keyCode : charCode);\n  // Some browsers fire keypress events for backspace\n  if (ch == "\\x08") { return }\n  if (handleCharBinding(cm, e, ch)) { return }\n  cm.display.input.onKeyPress(e);\n}\n\nvar DOUBLECLICK_DELAY = 400;\n\nvar PastClick = function(time, pos, button) {\n  this.time = time;\n  this.pos = pos;\n  this.button = button;\n};\n\nPastClick.prototype.compare = function (time, pos, button) {\n  return this.time + DOUBLECLICK_DELAY > time &&\n    cmp(pos, this.pos) == 0 && button == this.button\n};\n\nvar lastClick;\nvar lastDoubleClick;\nfunction clickRepeat(pos, button) {\n  var now = +new Date;\n  if (lastDoubleClick && lastDoubleClick.compare(now, pos, button)) {\n    lastClick = lastDoubleClick = null;\n    return "triple"\n  } else if (lastClick && lastClick.compare(now, pos, button)) {\n    lastDoubleClick = new PastClick(now, pos, button);\n    lastClick = null;\n    return "double"\n  } else {\n    lastClick = new PastClick(now, pos, button);\n    lastDoubleClick = null;\n    return "single"\n  }\n}\n\n// A mouse down can be a single click, double click, triple click,\n// start of selection drag, start of text drag, new cursor\n// (ctrl-click), rectangle drag (alt-drag), or xwin\n// middle-click-paste. Or it might be a click on something we should\n// not interfere with, such as a scrollbar or widget.\nfunction onMouseDown(e) {\n  var cm = this, display = cm.display;\n  if (signalDOMEvent(cm, e) || display.activeTouch && display.input.supportsTouch()) { return }\n  display.input.ensurePolled();\n  display.shift = e.shiftKey;\n\n  if (eventInWidget(display, e)) {\n    if (!webkit) {\n      // Briefly turn off draggability, to allow widgets to do\n      // normal dragging things.\n      display.scroller.draggable = false;\n      setTimeout(function () { return display.scroller.draggable = true; }, 100);\n    }\n    return\n  }\n  if (clickInGutter(cm, e)) { return }\n  var pos = posFromMouse(cm, e), button = e_button(e), repeat = pos ? clickRepeat(pos, button) : "single";\n  window.focus();\n\n  // #3261: make sure, that we\'re not starting a second selection\n  if (button == 1 && cm.state.selectingText)\n    { cm.state.selectingText(e); }\n\n  if (pos && handleMappedButton(cm, button, pos, repeat, e)) { return }\n\n  if (button == 1) {\n    if (pos) { leftButtonDown(cm, pos, repeat, e); }\n    else if (e_target(e) == display.scroller) { e_preventDefault(e); }\n  } else if (button == 2) {\n    if (pos) { extendSelection(cm.doc, pos); }\n    setTimeout(function () { return display.input.focus(); }, 20);\n  } else if (button == 3) {\n    if (captureRightClick) { onContextMenu(cm, e); }\n    else { delayBlurEvent(cm); }\n  }\n}\n\nfunction handleMappedButton(cm, button, pos, repeat, event) {\n  var name = "Click";\n  if (repeat == "double") { name = "Double" + name; }\n  else if (repeat == "triple") { name = "Triple" + name; }\n  name = (button == 1 ? "Left" : button == 2 ? "Middle" : "Right") + name;\n\n  return dispatchKey(cm,  addModifierNames(name, event), event, function (bound) {\n    if (typeof bound == "string") { bound = commands[bound]; }\n    if (!bound) { return false }\n    var done = false;\n    try {\n      if (cm.isReadOnly()) { cm.state.suppressEdits = true; }\n      done = bound(cm, pos) != Pass;\n    } finally {\n      cm.state.suppressEdits = false;\n    }\n    return done\n  })\n}\n\nfunction configureMouse(cm, repeat, event) {\n  var option = cm.getOption("configureMouse");\n  var value = option ? option(cm, repeat, event) : {};\n  if (value.unit == null) {\n    var rect = chromeOS ? event.shiftKey && event.metaKey : event.altKey;\n    value.unit = rect ? "rectangle" : repeat == "single" ? "char" : repeat == "double" ? "word" : "line";\n  }\n  if (value.extend == null || cm.doc.extend) { value.extend = cm.doc.extend || event.shiftKey; }\n  if (value.addNew == null) { value.addNew = mac ? event.metaKey : event.ctrlKey; }\n  if (value.moveOnDrag == null) { value.moveOnDrag = !(mac ? event.altKey : event.ctrlKey); }\n  return value\n}\n\nfunction leftButtonDown(cm, pos, repeat, event) {\n  if (ie) { setTimeout(bind(ensureFocus, cm), 0); }\n  else { cm.curOp.focus = activeElt(); }\n\n  var behavior = configureMouse(cm, repeat, event);\n\n  var sel = cm.doc.sel, contained;\n  if (cm.options.dragDrop && dragAndDrop && !cm.isReadOnly() &&\n      repeat == "single" && (contained = sel.contains(pos)) > -1 &&\n      (cmp((contained = sel.ranges[contained]).from(), pos) < 0 || pos.xRel > 0) &&\n      (cmp(contained.to(), pos) > 0 || pos.xRel < 0))\n    { leftButtonStartDrag(cm, event, pos, behavior); }\n  else\n    { leftButtonSelect(cm, event, pos, behavior); }\n}\n\n// Start a text drag. When it ends, see if any dragging actually\n// happen, and treat as a click if it didn\'t.\nfunction leftButtonStartDrag(cm, event, pos, behavior) {\n  var display = cm.display, moved = false;\n  var dragEnd = operation(cm, function (e) {\n    if (webkit) { display.scroller.draggable = false; }\n    cm.state.draggingText = false;\n    off(document, "mouseup", dragEnd);\n    off(document, "mousemove", mouseMove);\n    off(display.scroller, "dragstart", dragStart);\n    off(display.scroller, "drop", dragEnd);\n    if (!moved) {\n      e_preventDefault(e);\n      if (!behavior.addNew)\n        { extendSelection(cm.doc, pos, null, null, behavior.extend); }\n      // Work around unexplainable focus problem in IE9 (#2127) and Chrome (#3081)\n      if (webkit || ie && ie_version == 9)\n        { setTimeout(function () {document.body.focus(); display.input.focus();}, 20); }\n      else\n        { display.input.focus(); }\n    }\n  });\n  var mouseMove = function(e2) {\n    moved = moved || Math.abs(event.clientX - e2.clientX) + Math.abs(event.clientY - e2.clientY) >= 10;\n  };\n  var dragStart = function () { return moved = true; };\n  // Let the drag handler handle this.\n  if (webkit) { display.scroller.draggable = true; }\n  cm.state.draggingText = dragEnd;\n  dragEnd.copy = !behavior.moveOnDrag;\n  // IE\'s approach to draggable\n  if (display.scroller.dragDrop) { display.scroller.dragDrop(); }\n  on(document, "mouseup", dragEnd);\n  on(document, "mousemove", mouseMove);\n  on(display.scroller, "dragstart", dragStart);\n  on(display.scroller, "drop", dragEnd);\n\n  delayBlurEvent(cm);\n  setTimeout(function () { return display.input.focus(); }, 20);\n}\n\nfunction rangeForUnit(cm, pos, unit) {\n  if (unit == "char") { return new Range(pos, pos) }\n  if (unit == "word") { return cm.findWordAt(pos) }\n  if (unit == "line") { return new Range(Pos(pos.line, 0), clipPos(cm.doc, Pos(pos.line + 1, 0))) }\n  var result = unit(cm, pos);\n  return new Range(result.from, result.to)\n}\n\n// Normal selection, as opposed to text dragging.\nfunction leftButtonSelect(cm, event, start, behavior) {\n  var display = cm.display, doc = cm.doc;\n  e_preventDefault(event);\n\n  var ourRange, ourIndex, startSel = doc.sel, ranges = startSel.ranges;\n  if (behavior.addNew && !behavior.extend) {\n    ourIndex = doc.sel.contains(start);\n    if (ourIndex > -1)\n      { ourRange = ranges[ourIndex]; }\n    else\n      { ourRange = new Range(start, start); }\n  } else {\n    ourRange = doc.sel.primary();\n    ourIndex = doc.sel.primIndex;\n  }\n\n  if (behavior.unit == "rectangle") {\n    if (!behavior.addNew) { ourRange = new Range(start, start); }\n    start = posFromMouse(cm, event, true, true);\n    ourIndex = -1;\n  } else {\n    var range$$1 = rangeForUnit(cm, start, behavior.unit);\n    if (behavior.extend)\n      { ourRange = extendRange(ourRange, range$$1.anchor, range$$1.head, behavior.extend); }\n    else\n      { ourRange = range$$1; }\n  }\n\n  if (!behavior.addNew) {\n    ourIndex = 0;\n    setSelection(doc, new Selection([ourRange], 0), sel_mouse);\n    startSel = doc.sel;\n  } else if (ourIndex == -1) {\n    ourIndex = ranges.length;\n    setSelection(doc, normalizeSelection(ranges.concat([ourRange]), ourIndex),\n                 {scroll: false, origin: "*mouse"});\n  } else if (ranges.length > 1 && ranges[ourIndex].empty() && behavior.unit == "char" && !behavior.extend) {\n    setSelection(doc, normalizeSelection(ranges.slice(0, ourIndex).concat(ranges.slice(ourIndex + 1)), 0),\n                 {scroll: false, origin: "*mouse"});\n    startSel = doc.sel;\n  } else {\n    replaceOneSelection(doc, ourIndex, ourRange, sel_mouse);\n  }\n\n  var lastPos = start;\n  function extendTo(pos) {\n    if (cmp(lastPos, pos) == 0) { return }\n    lastPos = pos;\n\n    if (behavior.unit == "rectangle") {\n      var ranges = [], tabSize = cm.options.tabSize;\n      var startCol = countColumn(getLine(doc, start.line).text, start.ch, tabSize);\n      var posCol = countColumn(getLine(doc, pos.line).text, pos.ch, tabSize);\n      var left = Math.min(startCol, posCol), right = Math.max(startCol, posCol);\n      for (var line = Math.min(start.line, pos.line), end = Math.min(cm.lastLine(), Math.max(start.line, pos.line));\n           line <= end; line++) {\n        var text = getLine(doc, line).text, leftPos = findColumn(text, left, tabSize);\n        if (left == right)\n          { ranges.push(new Range(Pos(line, leftPos), Pos(line, leftPos))); }\n        else if (text.length > leftPos)\n          { ranges.push(new Range(Pos(line, leftPos), Pos(line, findColumn(text, right, tabSize)))); }\n      }\n      if (!ranges.length) { ranges.push(new Range(start, start)); }\n      setSelection(doc, normalizeSelection(startSel.ranges.slice(0, ourIndex).concat(ranges), ourIndex),\n                   {origin: "*mouse", scroll: false});\n      cm.scrollIntoView(pos);\n    } else {\n      var oldRange = ourRange;\n      var range$$1 = rangeForUnit(cm, pos, behavior.unit);\n      var anchor = oldRange.anchor, head;\n      if (cmp(range$$1.anchor, anchor) > 0) {\n        head = range$$1.head;\n        anchor = minPos(oldRange.from(), range$$1.anchor);\n      } else {\n        head = range$$1.anchor;\n        anchor = maxPos(oldRange.to(), range$$1.head);\n      }\n      var ranges$1 = startSel.ranges.slice(0);\n      ranges$1[ourIndex] = new Range(clipPos(doc, anchor), head);\n      setSelection(doc, normalizeSelection(ranges$1, ourIndex), sel_mouse);\n    }\n  }\n\n  var editorSize = display.wrapper.getBoundingClientRect();\n  // Used to ensure timeout re-tries don\'t fire when another extend\n  // happened in the meantime (clearTimeout isn\'t reliable -- at\n  // least on Chrome, the timeouts still happen even when cleared,\n  // if the clear happens after their scheduled firing time).\n  var counter = 0;\n\n  function extend(e) {\n    var curCount = ++counter;\n    var cur = posFromMouse(cm, e, true, behavior.unit == "rectangle");\n    if (!cur) { return }\n    if (cmp(cur, lastPos) != 0) {\n      cm.curOp.focus = activeElt();\n      extendTo(cur);\n      var visible = visibleLines(display, doc);\n      if (cur.line >= visible.to || cur.line < visible.from)\n        { setTimeout(operation(cm, function () {if (counter == curCount) { extend(e); }}), 150); }\n    } else {\n      var outside = e.clientY < editorSize.top ? -20 : e.clientY > editorSize.bottom ? 20 : 0;\n      if (outside) { setTimeout(operation(cm, function () {\n        if (counter != curCount) { return }\n        display.scroller.scrollTop += outside;\n        extend(e);\n      }), 50); }\n    }\n  }\n\n  function done(e) {\n    cm.state.selectingText = false;\n    counter = Infinity;\n    e_preventDefault(e);\n    display.input.focus();\n    off(document, "mousemove", move);\n    off(document, "mouseup", up);\n    doc.history.lastSelOrigin = null;\n  }\n\n  var move = operation(cm, function (e) {\n    if (!e_button(e)) { done(e); }\n    else { extend(e); }\n  });\n  var up = operation(cm, done);\n  cm.state.selectingText = up;\n  on(document, "mousemove", move);\n  on(document, "mouseup", up);\n}\n\n\n// Determines whether an event happened in the gutter, and fires the\n// handlers for the corresponding event.\nfunction gutterEvent(cm, e, type, prevent) {\n  var mX, mY;\n  try { mX = e.clientX; mY = e.clientY; }\n  catch(e) { return false }\n  if (mX >= Math.floor(cm.display.gutters.getBoundingClientRect().right)) { return false }\n  if (prevent) { e_preventDefault(e); }\n\n  var display = cm.display;\n  var lineBox = display.lineDiv.getBoundingClientRect();\n\n  if (mY > lineBox.bottom || !hasHandler(cm, type)) { return e_defaultPrevented(e) }\n  mY -= lineBox.top - display.viewOffset;\n\n  for (var i = 0; i < cm.options.gutters.length; ++i) {\n    var g = display.gutters.childNodes[i];\n    if (g && g.getBoundingClientRect().right >= mX) {\n      var line = lineAtHeight(cm.doc, mY);\n      var gutter = cm.options.gutters[i];\n      signal(cm, type, cm, line, gutter, e);\n      return e_defaultPrevented(e)\n    }\n  }\n}\n\nfunction clickInGutter(cm, e) {\n  return gutterEvent(cm, e, "gutterClick", true)\n}\n\n// CONTEXT MENU HANDLING\n\n// To make the context menu work, we need to briefly unhide the\n// textarea (making it as unobtrusive as possible) to let the\n// right-click take effect on it.\nfunction onContextMenu(cm, e) {\n  if (eventInWidget(cm.display, e) || contextMenuInGutter(cm, e)) { return }\n  if (signalDOMEvent(cm, e, "contextmenu")) { return }\n  cm.display.input.onContextMenu(e);\n}\n\nfunction contextMenuInGutter(cm, e) {\n  if (!hasHandler(cm, "gutterContextMenu")) { return false }\n  return gutterEvent(cm, e, "gutterContextMenu", false)\n}\n\nfunction themeChanged(cm) {\n  cm.display.wrapper.className = cm.display.wrapper.className.replace(/\\s*cm-s-\\S+/g, "") +\n    cm.options.theme.replace(/(^|\\s)\\s*/g, " cm-s-");\n  clearCaches(cm);\n}\n\nvar Init = {toString: function(){return "CodeMirror.Init"}};\n\nvar defaults = {};\nvar optionHandlers = {};\n\nfunction defineOptions(CodeMirror) {\n  var optionHandlers = CodeMirror.optionHandlers;\n\n  function option(name, deflt, handle, notOnInit) {\n    CodeMirror.defaults[name] = deflt;\n    if (handle) { optionHandlers[name] =\n      notOnInit ? function (cm, val, old) {if (old != Init) { handle(cm, val, old); }} : handle; }\n  }\n\n  CodeMirror.defineOption = option;\n\n  // Passed to option handlers when there is no old value.\n  CodeMirror.Init = Init;\n\n  // These two are, on init, called from the constructor because they\n  // have to be initialized before the editor can start at all.\n  option("value", "", function (cm, val) { return cm.setValue(val); }, true);\n  option("mode", null, function (cm, val) {\n    cm.doc.modeOption = val;\n    loadMode(cm);\n  }, true);\n\n  option("indentUnit", 2, loadMode, true);\n  option("indentWithTabs", false);\n  option("smartIndent", true);\n  option("tabSize", 4, function (cm) {\n    resetModeState(cm);\n    clearCaches(cm);\n    regChange(cm);\n  }, true);\n  option("lineSeparator", null, function (cm, val) {\n    cm.doc.lineSep = val;\n    if (!val) { return }\n    var newBreaks = [], lineNo = cm.doc.first;\n    cm.doc.iter(function (line) {\n      for (var pos = 0;;) {\n        var found = line.text.indexOf(val, pos);\n        if (found == -1) { break }\n        pos = found + val.length;\n        newBreaks.push(Pos(lineNo, found));\n      }\n      lineNo++;\n    });\n    for (var i = newBreaks.length - 1; i >= 0; i--)\n      { replaceRange(cm.doc, val, newBreaks[i], Pos(newBreaks[i].line, newBreaks[i].ch + val.length)); }\n  });\n  option("specialChars", /[\\u0000-\\u001f\\u007f-\\u009f\\u00ad\\u061c\\u200b-\\u200f\\u2028\\u2029\\ufeff]/g, function (cm, val, old) {\n    cm.state.specialChars = new RegExp(val.source + (val.test("\\t") ? "" : "|\\t"), "g");\n    if (old != Init) { cm.refresh(); }\n  });\n  option("specialCharPlaceholder", defaultSpecialCharPlaceholder, function (cm) { return cm.refresh(); }, true);\n  option("electricChars", true);\n  option("inputStyle", mobile ? "contenteditable" : "textarea", function () {\n    throw new Error("inputStyle can not (yet) be changed in a running editor") // FIXME\n  }, true);\n  option("spellcheck", false, function (cm, val) { return cm.getInputField().spellcheck = val; }, true);\n  option("rtlMoveVisually", !windows);\n  option("wholeLineUpdateBefore", true);\n\n  option("theme", "default", function (cm) {\n    themeChanged(cm);\n    guttersChanged(cm);\n  }, true);\n  option("keyMap", "default", function (cm, val, old) {\n    var next = getKeyMap(val);\n    var prev = old != Init && getKeyMap(old);\n    if (prev && prev.detach) { prev.detach(cm, next); }\n    if (next.attach) { next.attach(cm, prev || null); }\n  });\n  option("extraKeys", null);\n  option("configureMouse", null);\n\n  option("lineWrapping", false, wrappingChanged, true);\n  option("gutters", [], function (cm) {\n    setGuttersForLineNumbers(cm.options);\n    guttersChanged(cm);\n  }, true);\n  option("fixedGutter", true, function (cm, val) {\n    cm.display.gutters.style.left = val ? compensateForHScroll(cm.display) + "px" : "0";\n    cm.refresh();\n  }, true);\n  option("coverGutterNextToScrollbar", false, function (cm) { return updateScrollbars(cm); }, true);\n  option("scrollbarStyle", "native", function (cm) {\n    initScrollbars(cm);\n    updateScrollbars(cm);\n    cm.display.scrollbars.setScrollTop(cm.doc.scrollTop);\n    cm.display.scrollbars.setScrollLeft(cm.doc.scrollLeft);\n  }, true);\n  option("lineNumbers", false, function (cm) {\n    setGuttersForLineNumbers(cm.options);\n    guttersChanged(cm);\n  }, true);\n  option("firstLineNumber", 1, guttersChanged, true);\n  option("lineNumberFormatter", function (integer) { return integer; }, guttersChanged, true);\n  option("showCursorWhenSelecting", false, updateSelection, true);\n\n  option("resetSelectionOnContextMenu", true);\n  option("lineWiseCopyCut", true);\n  option("pasteLinesPerSelection", true);\n\n  option("readOnly", false, function (cm, val) {\n    if (val == "nocursor") {\n      onBlur(cm);\n      cm.display.input.blur();\n    }\n    cm.display.input.readOnlyChanged(val);\n  });\n  option("disableInput", false, function (cm, val) {if (!val) { cm.display.input.reset(); }}, true);\n  option("dragDrop", true, dragDropChanged);\n  option("allowDropFileTypes", null);\n\n  option("cursorBlinkRate", 530);\n  option("cursorScrollMargin", 0);\n  option("cursorHeight", 1, updateSelection, true);\n  option("singleCursorHeightPerLine", true, updateSelection, true);\n  option("workTime", 100);\n  option("workDelay", 100);\n  option("flattenSpans", true, resetModeState, true);\n  option("addModeClass", false, resetModeState, true);\n  option("pollInterval", 100);\n  option("undoDepth", 200, function (cm, val) { return cm.doc.history.undoDepth = val; });\n  option("historyEventDelay", 1250);\n  option("viewportMargin", 10, function (cm) { return cm.refresh(); }, true);\n  option("maxHighlightLength", 10000, resetModeState, true);\n  option("moveInputWithCursor", true, function (cm, val) {\n    if (!val) { cm.display.input.resetPosition(); }\n  });\n\n  option("tabindex", null, function (cm, val) { return cm.display.input.getField().tabIndex = val || ""; });\n  option("autofocus", null);\n  option("direction", "ltr", function (cm, val) { return cm.doc.setDirection(val); }, true);\n}\n\nfunction guttersChanged(cm) {\n  updateGutters(cm);\n  regChange(cm);\n  alignHorizontally(cm);\n}\n\nfunction dragDropChanged(cm, value, old) {\n  var wasOn = old && old != Init;\n  if (!value != !wasOn) {\n    var funcs = cm.display.dragFunctions;\n    var toggle = value ? on : off;\n    toggle(cm.display.scroller, "dragstart", funcs.start);\n    toggle(cm.display.scroller, "dragenter", funcs.enter);\n    toggle(cm.display.scroller, "dragover", funcs.over);\n    toggle(cm.display.scroller, "dragleave", funcs.leave);\n    toggle(cm.display.scroller, "drop", funcs.drop);\n  }\n}\n\nfunction wrappingChanged(cm) {\n  if (cm.options.lineWrapping) {\n    addClass(cm.display.wrapper, "CodeMirror-wrap");\n    cm.display.sizer.style.minWidth = "";\n    cm.display.sizerWidth = null;\n  } else {\n    rmClass(cm.display.wrapper, "CodeMirror-wrap");\n    findMaxLine(cm);\n  }\n  estimateLineHeights(cm);\n  regChange(cm);\n  clearCaches(cm);\n  setTimeout(function () { return updateScrollbars(cm); }, 100);\n}\n\n// A CodeMirror instance represents an editor. This is the object\n// that user code is usually dealing with.\n\nfunction CodeMirror$1(place, options) {\n  var this$1 = this;\n\n  if (!(this instanceof CodeMirror$1)) { return new CodeMirror$1(place, options) }\n\n  this.options = options = options ? copyObj(options) : {};\n  // Determine effective options based on given values and defaults.\n  copyObj(defaults, options, false);\n  setGuttersForLineNumbers(options);\n\n  var doc = options.value;\n  if (typeof doc == "string") { doc = new Doc(doc, options.mode, null, options.lineSeparator, options.direction); }\n  this.doc = doc;\n\n  var input = new CodeMirror$1.inputStyles[options.inputStyle](this);\n  var display = this.display = new Display(place, doc, input);\n  display.wrapper.CodeMirror = this;\n  updateGutters(this);\n  themeChanged(this);\n  if (options.lineWrapping)\n    { this.display.wrapper.className += " CodeMirror-wrap"; }\n  initScrollbars(this);\n\n  this.state = {\n    keyMaps: [],  // stores maps added by addKeyMap\n    overlays: [], // highlighting overlays, as added by addOverlay\n    modeGen: 0,   // bumped when mode/overlay changes, used to invalidate highlighting info\n    overwrite: false,\n    delayingBlurEvent: false,\n    focused: false,\n    suppressEdits: false, // used to disable editing during key handlers when in readOnly mode\n    pasteIncoming: false, cutIncoming: false, // help recognize paste/cut edits in input.poll\n    selectingText: false,\n    draggingText: false,\n    highlight: new Delayed(), // stores highlight worker timeout\n    keySeq: null,  // Unfinished key sequence\n    specialChars: null\n  };\n\n  if (options.autofocus && !mobile) { display.input.focus(); }\n\n  // Override magic textarea content restore that IE sometimes does\n  // on our hidden textarea on reload\n  if (ie && ie_version < 11) { setTimeout(function () { return this$1.display.input.reset(true); }, 20); }\n\n  registerEventHandlers(this);\n  ensureGlobalHandlers();\n\n  startOperation(this);\n  this.curOp.forceUpdate = true;\n  attachDoc(this, doc);\n\n  if ((options.autofocus && !mobile) || this.hasFocus())\n    { setTimeout(bind(onFocus, this), 20); }\n  else\n    { onBlur(this); }\n\n  for (var opt in optionHandlers) { if (optionHandlers.hasOwnProperty(opt))\n    { optionHandlers[opt](this$1, options[opt], Init); } }\n  maybeUpdateLineNumberWidth(this);\n  if (options.finishInit) { options.finishInit(this); }\n  for (var i = 0; i < initHooks.length; ++i) { initHooks[i](this$1); }\n  endOperation(this);\n  // Suppress optimizelegibility in Webkit, since it breaks text\n  // measuring on line wrapping boundaries.\n  if (webkit && options.lineWrapping &&\n      getComputedStyle(display.lineDiv).textRendering == "optimizelegibility")\n    { display.lineDiv.style.textRendering = "auto"; }\n}\n\n// The default configuration options.\nCodeMirror$1.defaults = defaults;\n// Functions to run when options are changed.\nCodeMirror$1.optionHandlers = optionHandlers;\n\n// Attach the necessary event handlers when initializing the editor\nfunction registerEventHandlers(cm) {\n  var d = cm.display;\n  on(d.scroller, "mousedown", operation(cm, onMouseDown));\n  // Older IE\'s will not fire a second mousedown for a double click\n  if (ie && ie_version < 11)\n    { on(d.scroller, "dblclick", operation(cm, function (e) {\n      if (signalDOMEvent(cm, e)) { return }\n      var pos = posFromMouse(cm, e);\n      if (!pos || clickInGutter(cm, e) || eventInWidget(cm.display, e)) { return }\n      e_preventDefault(e);\n      var word = cm.findWordAt(pos);\n      extendSelection(cm.doc, word.anchor, word.head);\n    })); }\n  else\n    { on(d.scroller, "dblclick", function (e) { return signalDOMEvent(cm, e) || e_preventDefault(e); }); }\n  // Some browsers fire contextmenu *after* opening the menu, at\n  // which point we can\'t mess with it anymore. Context menu is\n  // handled in onMouseDown for these browsers.\n  if (!captureRightClick) { on(d.scroller, "contextmenu", function (e) { return onContextMenu(cm, e); }); }\n\n  // Used to suppress mouse event handling when a touch happens\n  var touchFinished, prevTouch = {end: 0};\n  function finishTouch() {\n    if (d.activeTouch) {\n      touchFinished = setTimeout(function () { return d.activeTouch = null; }, 1000);\n      prevTouch = d.activeTouch;\n      prevTouch.end = +new Date;\n    }\n  }\n  function isMouseLikeTouchEvent(e) {\n    if (e.touches.length != 1) { return false }\n    var touch = e.touches[0];\n    return touch.radiusX <= 1 && touch.radiusY <= 1\n  }\n  function farAway(touch, other) {\n    if (other.left == null) { return true }\n    var dx = other.left - touch.left, dy = other.top - touch.top;\n    return dx * dx + dy * dy > 20 * 20\n  }\n  on(d.scroller, "touchstart", function (e) {\n    if (!signalDOMEvent(cm, e) && !isMouseLikeTouchEvent(e)) {\n      d.input.ensurePolled();\n      clearTimeout(touchFinished);\n      var now = +new Date;\n      d.activeTouch = {start: now, moved: false,\n                       prev: now - prevTouch.end <= 300 ? prevTouch : null};\n      if (e.touches.length == 1) {\n        d.activeTouch.left = e.touches[0].pageX;\n        d.activeTouch.top = e.touches[0].pageY;\n      }\n    }\n  });\n  on(d.scroller, "touchmove", function () {\n    if (d.activeTouch) { d.activeTouch.moved = true; }\n  });\n  on(d.scroller, "touchend", function (e) {\n    var touch = d.activeTouch;\n    if (touch && !eventInWidget(d, e) && touch.left != null &&\n        !touch.moved && new Date - touch.start < 300) {\n      var pos = cm.coordsChar(d.activeTouch, "page"), range;\n      if (!touch.prev || farAway(touch, touch.prev)) // Single tap\n        { range = new Range(pos, pos); }\n      else if (!touch.prev.prev || farAway(touch, touch.prev.prev)) // Double tap\n        { range = cm.findWordAt(pos); }\n      else // Triple tap\n        { range = new Range(Pos(pos.line, 0), clipPos(cm.doc, Pos(pos.line + 1, 0))); }\n      cm.setSelection(range.anchor, range.head);\n      cm.focus();\n      e_preventDefault(e);\n    }\n    finishTouch();\n  });\n  on(d.scroller, "touchcancel", finishTouch);\n\n  // Sync scrolling between fake scrollbars and real scrollable\n  // area, ensure viewport is updated when scrolling.\n  on(d.scroller, "scroll", function () {\n    if (d.scroller.clientHeight) {\n      updateScrollTop(cm, d.scroller.scrollTop);\n      setScrollLeft(cm, d.scroller.scrollLeft, true);\n      signal(cm, "scroll", cm);\n    }\n  });\n\n  // Listen to wheel events in order to try and update the viewport on time.\n  on(d.scroller, "mousewheel", function (e) { return onScrollWheel(cm, e); });\n  on(d.scroller, "DOMMouseScroll", function (e) { return onScrollWheel(cm, e); });\n\n  // Prevent wrapper from ever scrolling\n  on(d.wrapper, "scroll", function () { return d.wrapper.scrollTop = d.wrapper.scrollLeft = 0; });\n\n  d.dragFunctions = {\n    enter: function (e) {if (!signalDOMEvent(cm, e)) { e_stop(e); }},\n    over: function (e) {if (!signalDOMEvent(cm, e)) { onDragOver(cm, e); e_stop(e); }},\n    start: function (e) { return onDragStart(cm, e); },\n    drop: operation(cm, onDrop),\n    leave: function (e) {if (!signalDOMEvent(cm, e)) { clearDragCursor(cm); }}\n  };\n\n  var inp = d.input.getField();\n  on(inp, "keyup", function (e) { return onKeyUp.call(cm, e); });\n  on(inp, "keydown", operation(cm, onKeyDown));\n  on(inp, "keypress", operation(cm, onKeyPress));\n  on(inp, "focus", function (e) { return onFocus(cm, e); });\n  on(inp, "blur", function (e) { return onBlur(cm, e); });\n}\n\nvar initHooks = [];\nCodeMirror$1.defineInitHook = function (f) { return initHooks.push(f); };\n\n// Indent the given line. The how parameter can be "smart",\n// "add"/null, "subtract", or "prev". When aggressive is false\n// (typically set to true for forced single-line indents), empty\n// lines are not indented, and places where the mode returns Pass\n// are left alone.\nfunction indentLine(cm, n, how, aggressive) {\n  var doc = cm.doc, state;\n  if (how == null) { how = "add"; }\n  if (how == "smart") {\n    // Fall back to "prev" when the mode doesn\'t have an indentation\n    // method.\n    if (!doc.mode.indent) { how = "prev"; }\n    else { state = getContextBefore(cm, n).state; }\n  }\n\n  var tabSize = cm.options.tabSize;\n  var line = getLine(doc, n), curSpace = countColumn(line.text, null, tabSize);\n  if (line.stateAfter) { line.stateAfter = null; }\n  var curSpaceString = line.text.match(/^\\s*/)[0], indentation;\n  if (!aggressive && !/\\S/.test(line.text)) {\n    indentation = 0;\n    how = "not";\n  } else if (how == "smart") {\n    indentation = doc.mode.indent(state, line.text.slice(curSpaceString.length), line.text);\n    if (indentation == Pass || indentation > 150) {\n      if (!aggressive) { return }\n      how = "prev";\n    }\n  }\n  if (how == "prev") {\n    if (n > doc.first) { indentation = countColumn(getLine(doc, n-1).text, null, tabSize); }\n    else { indentation = 0; }\n  } else if (how == "add") {\n    indentation = curSpace + cm.options.indentUnit;\n  } else if (how == "subtract") {\n    indentation = curSpace - cm.options.indentUnit;\n  } else if (typeof how == "number") {\n    indentation = curSpace + how;\n  }\n  indentation = Math.max(0, indentation);\n\n  var indentString = "", pos = 0;\n  if (cm.options.indentWithTabs)\n    { for (var i = Math.floor(indentation / tabSize); i; --i) {pos += tabSize; indentString += "\\t";} }\n  if (pos < indentation) { indentString += spaceStr(indentation - pos); }\n\n  if (indentString != curSpaceString) {\n    replaceRange(doc, indentString, Pos(n, 0), Pos(n, curSpaceString.length), "+input");\n    line.stateAfter = null;\n    return true\n  } else {\n    // Ensure that, if the cursor was in the whitespace at the start\n    // of the line, it is moved to the end of that space.\n    for (var i$1 = 0; i$1 < doc.sel.ranges.length; i$1++) {\n      var range = doc.sel.ranges[i$1];\n      if (range.head.line == n && range.head.ch < curSpaceString.length) {\n        var pos$1 = Pos(n, curSpaceString.length);\n        replaceOneSelection(doc, i$1, new Range(pos$1, pos$1));\n        break\n      }\n    }\n  }\n}\n\n// This will be set to a {lineWise: bool, text: [string]} object, so\n// that, when pasting, we know what kind of selections the copied\n// text was made out of.\nvar lastCopied = null;\n\nfunction setLastCopied(newLastCopied) {\n  lastCopied = newLastCopied;\n}\n\nfunction applyTextInput(cm, inserted, deleted, sel, origin) {\n  var doc = cm.doc;\n  cm.display.shift = false;\n  if (!sel) { sel = doc.sel; }\n\n  var paste = cm.state.pasteIncoming || origin == "paste";\n  var textLines = splitLinesAuto(inserted), multiPaste = null;\n  // When pasing N lines into N selections, insert one line per selection\n  if (paste && sel.ranges.length > 1) {\n    if (lastCopied && lastCopied.text.join("\\n") == inserted) {\n      if (sel.ranges.length % lastCopied.text.length == 0) {\n        multiPaste = [];\n        for (var i = 0; i < lastCopied.text.length; i++)\n          { multiPaste.push(doc.splitLines(lastCopied.text[i])); }\n      }\n    } else if (textLines.length == sel.ranges.length && cm.options.pasteLinesPerSelection) {\n      multiPaste = map(textLines, function (l) { return [l]; });\n    }\n  }\n\n  var updateInput;\n  // Normal behavior is to insert the new text into every selection\n  for (var i$1 = sel.ranges.length - 1; i$1 >= 0; i$1--) {\n    var range$$1 = sel.ranges[i$1];\n    var from = range$$1.from(), to = range$$1.to();\n    if (range$$1.empty()) {\n      if (deleted && deleted > 0) // Handle deletion\n        { from = Pos(from.line, from.ch - deleted); }\n      else if (cm.state.overwrite && !paste) // Handle overwrite\n        { to = Pos(to.line, Math.min(getLine(doc, to.line).text.length, to.ch + lst(textLines).length)); }\n      else if (lastCopied && lastCopied.lineWise && lastCopied.text.join("\\n") == inserted)\n        { from = to = Pos(from.line, 0); }\n    }\n    updateInput = cm.curOp.updateInput;\n    var changeEvent = {from: from, to: to, text: multiPaste ? multiPaste[i$1 % multiPaste.length] : textLines,\n                       origin: origin || (paste ? "paste" : cm.state.cutIncoming ? "cut" : "+input")};\n    makeChange(cm.doc, changeEvent);\n    signalLater(cm, "inputRead", cm, changeEvent);\n  }\n  if (inserted && !paste)\n    { triggerElectric(cm, inserted); }\n\n  ensureCursorVisible(cm);\n  cm.curOp.updateInput = updateInput;\n  cm.curOp.typing = true;\n  cm.state.pasteIncoming = cm.state.cutIncoming = false;\n}\n\nfunction handlePaste(e, cm) {\n  var pasted = e.clipboardData && e.clipboardData.getData("Text");\n  if (pasted) {\n    e.preventDefault();\n    if (!cm.isReadOnly() && !cm.options.disableInput)\n      { runInOp(cm, function () { return applyTextInput(cm, pasted, 0, null, "paste"); }); }\n    return true\n  }\n}\n\nfunction triggerElectric(cm, inserted) {\n  // When an \'electric\' character is inserted, immediately trigger a reindent\n  if (!cm.options.electricChars || !cm.options.smartIndent) { return }\n  var sel = cm.doc.sel;\n\n  for (var i = sel.ranges.length - 1; i >= 0; i--) {\n    var range$$1 = sel.ranges[i];\n    if (range$$1.head.ch > 100 || (i && sel.ranges[i - 1].head.line == range$$1.head.line)) { continue }\n    var mode = cm.getModeAt(range$$1.head);\n    var indented = false;\n    if (mode.electricChars) {\n      for (var j = 0; j < mode.electricChars.length; j++)\n        { if (inserted.indexOf(mode.electricChars.charAt(j)) > -1) {\n          indented = indentLine(cm, range$$1.head.line, "smart");\n          break\n        } }\n    } else if (mode.electricInput) {\n      if (mode.electricInput.test(getLine(cm.doc, range$$1.head.line).text.slice(0, range$$1.head.ch)))\n        { indented = indentLine(cm, range$$1.head.line, "smart"); }\n    }\n    if (indented) { signalLater(cm, "electricInput", cm, range$$1.head.line); }\n  }\n}\n\nfunction copyableRanges(cm) {\n  var text = [], ranges = [];\n  for (var i = 0; i < cm.doc.sel.ranges.length; i++) {\n    var line = cm.doc.sel.ranges[i].head.line;\n    var lineRange = {anchor: Pos(line, 0), head: Pos(line + 1, 0)};\n    ranges.push(lineRange);\n    text.push(cm.getRange(lineRange.anchor, lineRange.head));\n  }\n  return {text: text, ranges: ranges}\n}\n\nfunction disableBrowserMagic(field, spellcheck) {\n  field.setAttribute("autocorrect", "off");\n  field.setAttribute("autocapitalize", "off");\n  field.setAttribute("spellcheck", !!spellcheck);\n}\n\nfunction hiddenTextarea() {\n  var te = elt("textarea", null, null, "position: absolute; bottom: -1em; padding: 0; width: 1px; height: 1em; outline: none");\n  var div = elt("div", [te], null, "overflow: hidden; position: relative; width: 3px; height: 0px;");\n  // The textarea is kept positioned near the cursor to prevent the\n  // fact that it\'ll be scrolled into view on input from scrolling\n  // our fake cursor out of view. On webkit, when wrap=off, paste is\n  // very slow. So make the area wide instead.\n  if (webkit) { te.style.width = "1000px"; }\n  else { te.setAttribute("wrap", "off"); }\n  // If border: 0; -- iOS fails to open keyboard (issue #1287)\n  if (ios) { te.style.border = "1px solid black"; }\n  disableBrowserMagic(te);\n  return div\n}\n\n// The publicly visible API. Note that methodOp(f) means\n// \'wrap f in an operation, performed on its `this` parameter\'.\n\n// This is not the complete set of editor methods. Most of the\n// methods defined on the Doc type are also injected into\n// CodeMirror.prototype, for backwards compatibility and\n// convenience.\n\nvar addEditorMethods = function(CodeMirror) {\n  var optionHandlers = CodeMirror.optionHandlers;\n\n  var helpers = CodeMirror.helpers = {};\n\n  CodeMirror.prototype = {\n    constructor: CodeMirror,\n    focus: function(){window.focus(); this.display.input.focus();},\n\n    setOption: function(option, value) {\n      var options = this.options, old = options[option];\n      if (options[option] == value && option != "mode") { return }\n      options[option] = value;\n      if (optionHandlers.hasOwnProperty(option))\n        { operation(this, optionHandlers[option])(this, value, old); }\n      signal(this, "optionChange", this, option);\n    },\n\n    getOption: function(option) {return this.options[option]},\n    getDoc: function() {return this.doc},\n\n    addKeyMap: function(map$$1, bottom) {\n      this.state.keyMaps[bottom ? "push" : "unshift"](getKeyMap(map$$1));\n    },\n    removeKeyMap: function(map$$1) {\n      var maps = this.state.keyMaps;\n      for (var i = 0; i < maps.length; ++i)\n        { if (maps[i] == map$$1 || maps[i].name == map$$1) {\n          maps.splice(i, 1);\n          return true\n        } }\n    },\n\n    addOverlay: methodOp(function(spec, options) {\n      var mode = spec.token ? spec : CodeMirror.getMode(this.options, spec);\n      if (mode.startState) { throw new Error("Overlays may not be stateful.") }\n      insertSorted(this.state.overlays,\n                   {mode: mode, modeSpec: spec, opaque: options && options.opaque,\n                    priority: (options && options.priority) || 0},\n                   function (overlay) { return overlay.priority; });\n      this.state.modeGen++;\n      regChange(this);\n    }),\n    removeOverlay: methodOp(function(spec) {\n      var this$1 = this;\n\n      var overlays = this.state.overlays;\n      for (var i = 0; i < overlays.length; ++i) {\n        var cur = overlays[i].modeSpec;\n        if (cur == spec || typeof spec == "string" && cur.name == spec) {\n          overlays.splice(i, 1);\n          this$1.state.modeGen++;\n          regChange(this$1);\n          return\n        }\n      }\n    }),\n\n    indentLine: methodOp(function(n, dir, aggressive) {\n      if (typeof dir != "string" && typeof dir != "number") {\n        if (dir == null) { dir = this.options.smartIndent ? "smart" : "prev"; }\n        else { dir = dir ? "add" : "subtract"; }\n      }\n      if (isLine(this.doc, n)) { indentLine(this, n, dir, aggressive); }\n    }),\n    indentSelection: methodOp(function(how) {\n      var this$1 = this;\n\n      var ranges = this.doc.sel.ranges, end = -1;\n      for (var i = 0; i < ranges.length; i++) {\n        var range$$1 = ranges[i];\n        if (!range$$1.empty()) {\n          var from = range$$1.from(), to = range$$1.to();\n          var start = Math.max(end, from.line);\n          end = Math.min(this$1.lastLine(), to.line - (to.ch ? 0 : 1)) + 1;\n          for (var j = start; j < end; ++j)\n            { indentLine(this$1, j, how); }\n          var newRanges = this$1.doc.sel.ranges;\n          if (from.ch == 0 && ranges.length == newRanges.length && newRanges[i].from().ch > 0)\n            { replaceOneSelection(this$1.doc, i, new Range(from, newRanges[i].to()), sel_dontScroll); }\n        } else if (range$$1.head.line > end) {\n          indentLine(this$1, range$$1.head.line, how, true);\n          end = range$$1.head.line;\n          if (i == this$1.doc.sel.primIndex) { ensureCursorVisible(this$1); }\n        }\n      }\n    }),\n\n    // Fetch the parser token for a given character. Useful for hacks\n    // that want to inspect the mode state (say, for completion).\n    getTokenAt: function(pos, precise) {\n      return takeToken(this, pos, precise)\n    },\n\n    getLineTokens: function(line, precise) {\n      return takeToken(this, Pos(line), precise, true)\n    },\n\n    getTokenTypeAt: function(pos) {\n      pos = clipPos(this.doc, pos);\n      var styles = getLineStyles(this, getLine(this.doc, pos.line));\n      var before = 0, after = (styles.length - 1) / 2, ch = pos.ch;\n      var type;\n      if (ch == 0) { type = styles[2]; }\n      else { for (;;) {\n        var mid = (before + after) >> 1;\n        if ((mid ? styles[mid * 2 - 1] : 0) >= ch) { after = mid; }\n        else if (styles[mid * 2 + 1] < ch) { before = mid + 1; }\n        else { type = styles[mid * 2 + 2]; break }\n      } }\n      var cut = type ? type.indexOf("overlay ") : -1;\n      return cut < 0 ? type : cut == 0 ? null : type.slice(0, cut - 1)\n    },\n\n    getModeAt: function(pos) {\n      var mode = this.doc.mode;\n      if (!mode.innerMode) { return mode }\n      return CodeMirror.innerMode(mode, this.getTokenAt(pos).state).mode\n    },\n\n    getHelper: function(pos, type) {\n      return this.getHelpers(pos, type)[0]\n    },\n\n    getHelpers: function(pos, type) {\n      var this$1 = this;\n\n      var found = [];\n      if (!helpers.hasOwnProperty(type)) { return found }\n      var help = helpers[type], mode = this.getModeAt(pos);\n      if (typeof mode[type] == "string") {\n        if (help[mode[type]]) { found.push(help[mode[type]]); }\n      } else if (mode[type]) {\n        for (var i = 0; i < mode[type].length; i++) {\n          var val = help[mode[type][i]];\n          if (val) { found.push(val); }\n        }\n      } else if (mode.helperType && help[mode.helperType]) {\n        found.push(help[mode.helperType]);\n      } else if (help[mode.name]) {\n        found.push(help[mode.name]);\n      }\n      for (var i$1 = 0; i$1 < help._global.length; i$1++) {\n        var cur = help._global[i$1];\n        if (cur.pred(mode, this$1) && indexOf(found, cur.val) == -1)\n          { found.push(cur.val); }\n      }\n      return found\n    },\n\n    getStateAfter: function(line, precise) {\n      var doc = this.doc;\n      line = clipLine(doc, line == null ? doc.first + doc.size - 1: line);\n      return getContextBefore(this, line + 1, precise).state\n    },\n\n    cursorCoords: function(start, mode) {\n      var pos, range$$1 = this.doc.sel.primary();\n      if (start == null) { pos = range$$1.head; }\n      else if (typeof start == "object") { pos = clipPos(this.doc, start); }\n      else { pos = start ? range$$1.from() : range$$1.to(); }\n      return cursorCoords(this, pos, mode || "page")\n    },\n\n    charCoords: function(pos, mode) {\n      return charCoords(this, clipPos(this.doc, pos), mode || "page")\n    },\n\n    coordsChar: function(coords, mode) {\n      coords = fromCoordSystem(this, coords, mode || "page");\n      return coordsChar(this, coords.left, coords.top)\n    },\n\n    lineAtHeight: function(height, mode) {\n      height = fromCoordSystem(this, {top: height, left: 0}, mode || "page").top;\n      return lineAtHeight(this.doc, height + this.display.viewOffset)\n    },\n    heightAtLine: function(line, mode, includeWidgets) {\n      var end = false, lineObj;\n      if (typeof line == "number") {\n        var last = this.doc.first + this.doc.size - 1;\n        if (line < this.doc.first) { line = this.doc.first; }\n        else if (line > last) { line = last; end = true; }\n        lineObj = getLine(this.doc, line);\n      } else {\n        lineObj = line;\n      }\n      return intoCoordSystem(this, lineObj, {top: 0, left: 0}, mode || "page", includeWidgets || end).top +\n        (end ? this.doc.height - heightAtLine(lineObj) : 0)\n    },\n\n    defaultTextHeight: function() { return textHeight(this.display) },\n    defaultCharWidth: function() { return charWidth(this.display) },\n\n    getViewport: function() { return {from: this.display.viewFrom, to: this.display.viewTo}},\n\n    addWidget: function(pos, node, scroll, vert, horiz) {\n      var display = this.display;\n      pos = cursorCoords(this, clipPos(this.doc, pos));\n      var top = pos.bottom, left = pos.left;\n      node.style.position = "absolute";\n      node.setAttribute("cm-ignore-events", "true");\n      this.display.input.setUneditable(node);\n      display.sizer.appendChild(node);\n      if (vert == "over") {\n        top = pos.top;\n      } else if (vert == "above" || vert == "near") {\n        var vspace = Math.max(display.wrapper.clientHeight, this.doc.height),\n        hspace = Math.max(display.sizer.clientWidth, display.lineSpace.clientWidth);\n        // Default to positioning above (if specified and possible); otherwise default to positioning below\n        if ((vert == \'above\' || pos.bottom + node.offsetHeight > vspace) && pos.top > node.offsetHeight)\n          { top = pos.top - node.offsetHeight; }\n        else if (pos.bottom + node.offsetHeight <= vspace)\n          { top = pos.bottom; }\n        if (left + node.offsetWidth > hspace)\n          { left = hspace - node.offsetWidth; }\n      }\n      node.style.top = top + "px";\n      node.style.left = node.style.right = "";\n      if (horiz == "right") {\n        left = display.sizer.clientWidth - node.offsetWidth;\n        node.style.right = "0px";\n      } else {\n        if (horiz == "left") { left = 0; }\n        else if (horiz == "middle") { left = (display.sizer.clientWidth - node.offsetWidth) / 2; }\n        node.style.left = left + "px";\n      }\n      if (scroll)\n        { scrollIntoView(this, {left: left, top: top, right: left + node.offsetWidth, bottom: top + node.offsetHeight}); }\n    },\n\n    triggerOnKeyDown: methodOp(onKeyDown),\n    triggerOnKeyPress: methodOp(onKeyPress),\n    triggerOnKeyUp: onKeyUp,\n    triggerOnMouseDown: methodOp(onMouseDown),\n\n    execCommand: function(cmd) {\n      if (commands.hasOwnProperty(cmd))\n        { return commands[cmd].call(null, this) }\n    },\n\n    triggerElectric: methodOp(function(text) { triggerElectric(this, text); }),\n\n    findPosH: function(from, amount, unit, visually) {\n      var this$1 = this;\n\n      var dir = 1;\n      if (amount < 0) { dir = -1; amount = -amount; }\n      var cur = clipPos(this.doc, from);\n      for (var i = 0; i < amount; ++i) {\n        cur = findPosH(this$1.doc, cur, dir, unit, visually);\n        if (cur.hitSide) { break }\n      }\n      return cur\n    },\n\n    moveH: methodOp(function(dir, unit) {\n      var this$1 = this;\n\n      this.extendSelectionsBy(function (range$$1) {\n        if (this$1.display.shift || this$1.doc.extend || range$$1.empty())\n          { return findPosH(this$1.doc, range$$1.head, dir, unit, this$1.options.rtlMoveVisually) }\n        else\n          { return dir < 0 ? range$$1.from() : range$$1.to() }\n      }, sel_move);\n    }),\n\n    deleteH: methodOp(function(dir, unit) {\n      var sel = this.doc.sel, doc = this.doc;\n      if (sel.somethingSelected())\n        { doc.replaceSelection("", null, "+delete"); }\n      else\n        { deleteNearSelection(this, function (range$$1) {\n          var other = findPosH(doc, range$$1.head, dir, unit, false);\n          return dir < 0 ? {from: other, to: range$$1.head} : {from: range$$1.head, to: other}\n        }); }\n    }),\n\n    findPosV: function(from, amount, unit, goalColumn) {\n      var this$1 = this;\n\n      var dir = 1, x = goalColumn;\n      if (amount < 0) { dir = -1; amount = -amount; }\n      var cur = clipPos(this.doc, from);\n      for (var i = 0; i < amount; ++i) {\n        var coords = cursorCoords(this$1, cur, "div");\n        if (x == null) { x = coords.left; }\n        else { coords.left = x; }\n        cur = findPosV(this$1, coords, dir, unit);\n        if (cur.hitSide) { break }\n      }\n      return cur\n    },\n\n    moveV: methodOp(function(dir, unit) {\n      var this$1 = this;\n\n      var doc = this.doc, goals = [];\n      var collapse = !this.display.shift && !doc.extend && doc.sel.somethingSelected();\n      doc.extendSelectionsBy(function (range$$1) {\n        if (collapse)\n          { return dir < 0 ? range$$1.from() : range$$1.to() }\n        var headPos = cursorCoords(this$1, range$$1.head, "div");\n        if (range$$1.goalColumn != null) { headPos.left = range$$1.goalColumn; }\n        goals.push(headPos.left);\n        var pos = findPosV(this$1, headPos, dir, unit);\n        if (unit == "page" && range$$1 == doc.sel.primary())\n          { addToScrollTop(this$1, charCoords(this$1, pos, "div").top - headPos.top); }\n        return pos\n      }, sel_move);\n      if (goals.length) { for (var i = 0; i < doc.sel.ranges.length; i++)\n        { doc.sel.ranges[i].goalColumn = goals[i]; } }\n    }),\n\n    // Find the word at the given position (as returned by coordsChar).\n    findWordAt: function(pos) {\n      var doc = this.doc, line = getLine(doc, pos.line).text;\n      var start = pos.ch, end = pos.ch;\n      if (line) {\n        var helper = this.getHelper(pos, "wordChars");\n        if ((pos.sticky == "before" || end == line.length) && start) { --start; } else { ++end; }\n        var startChar = line.charAt(start);\n        var check = isWordChar(startChar, helper)\n          ? function (ch) { return isWordChar(ch, helper); }\n          : /\\s/.test(startChar) ? function (ch) { return /\\s/.test(ch); }\n          : function (ch) { return (!/\\s/.test(ch) && !isWordChar(ch)); };\n        while (start > 0 && check(line.charAt(start - 1))) { --start; }\n        while (end < line.length && check(line.charAt(end))) { ++end; }\n      }\n      return new Range(Pos(pos.line, start), Pos(pos.line, end))\n    },\n\n    toggleOverwrite: function(value) {\n      if (value != null && value == this.state.overwrite) { return }\n      if (this.state.overwrite = !this.state.overwrite)\n        { addClass(this.display.cursorDiv, "CodeMirror-overwrite"); }\n      else\n        { rmClass(this.display.cursorDiv, "CodeMirror-overwrite"); }\n\n      signal(this, "overwriteToggle", this, this.state.overwrite);\n    },\n    hasFocus: function() { return this.display.input.getField() == activeElt() },\n    isReadOnly: function() { return !!(this.options.readOnly || this.doc.cantEdit) },\n\n    scrollTo: methodOp(function (x, y) { scrollToCoords(this, x, y); }),\n    getScrollInfo: function() {\n      var scroller = this.display.scroller;\n      return {left: scroller.scrollLeft, top: scroller.scrollTop,\n              height: scroller.scrollHeight - scrollGap(this) - this.display.barHeight,\n              width: scroller.scrollWidth - scrollGap(this) - this.display.barWidth,\n              clientHeight: displayHeight(this), clientWidth: displayWidth(this)}\n    },\n\n    scrollIntoView: methodOp(function(range$$1, margin) {\n      if (range$$1 == null) {\n        range$$1 = {from: this.doc.sel.primary().head, to: null};\n        if (margin == null) { margin = this.options.cursorScrollMargin; }\n      } else if (typeof range$$1 == "number") {\n        range$$1 = {from: Pos(range$$1, 0), to: null};\n      } else if (range$$1.from == null) {\n        range$$1 = {from: range$$1, to: null};\n      }\n      if (!range$$1.to) { range$$1.to = range$$1.from; }\n      range$$1.margin = margin || 0;\n\n      if (range$$1.from.line != null) {\n        scrollToRange(this, range$$1);\n      } else {\n        scrollToCoordsRange(this, range$$1.from, range$$1.to, range$$1.margin);\n      }\n    }),\n\n    setSize: methodOp(function(width, height) {\n      var this$1 = this;\n\n      var interpret = function (val) { return typeof val == "number" || /^\\d+$/.test(String(val)) ? val + "px" : val; };\n      if (width != null) { this.display.wrapper.style.width = interpret(width); }\n      if (height != null) { this.display.wrapper.style.height = interpret(height); }\n      if (this.options.lineWrapping) { clearLineMeasurementCache(this); }\n      var lineNo$$1 = this.display.viewFrom;\n      this.doc.iter(lineNo$$1, this.display.viewTo, function (line) {\n        if (line.widgets) { for (var i = 0; i < line.widgets.length; i++)\n          { if (line.widgets[i].noHScroll) { regLineChange(this$1, lineNo$$1, "widget"); break } } }\n        ++lineNo$$1;\n      });\n      this.curOp.forceUpdate = true;\n      signal(this, "refresh", this);\n    }),\n\n    operation: function(f){return runInOp(this, f)},\n    startOperation: function(){return startOperation(this)},\n    endOperation: function(){return endOperation(this)},\n\n    refresh: methodOp(function() {\n      var oldHeight = this.display.cachedTextHeight;\n      regChange(this);\n      this.curOp.forceUpdate = true;\n      clearCaches(this);\n      scrollToCoords(this, this.doc.scrollLeft, this.doc.scrollTop);\n      updateGutterSpace(this);\n      if (oldHeight == null || Math.abs(oldHeight - textHeight(this.display)) > .5)\n        { estimateLineHeights(this); }\n      signal(this, "refresh", this);\n    }),\n\n    swapDoc: methodOp(function(doc) {\n      var old = this.doc;\n      old.cm = null;\n      attachDoc(this, doc);\n      clearCaches(this);\n      this.display.input.reset();\n      scrollToCoords(this, doc.scrollLeft, doc.scrollTop);\n      this.curOp.forceScroll = true;\n      signalLater(this, "swapDoc", this, old);\n      return old\n    }),\n\n    getInputField: function(){return this.display.input.getField()},\n    getWrapperElement: function(){return this.display.wrapper},\n    getScrollerElement: function(){return this.display.scroller},\n    getGutterElement: function(){return this.display.gutters}\n  };\n  eventMixin(CodeMirror);\n\n  CodeMirror.registerHelper = function(type, name, value) {\n    if (!helpers.hasOwnProperty(type)) { helpers[type] = CodeMirror[type] = {_global: []}; }\n    helpers[type][name] = value;\n  };\n  CodeMirror.registerGlobalHelper = function(type, name, predicate, value) {\n    CodeMirror.registerHelper(type, name, value);\n    helpers[type]._global.push({pred: predicate, val: value});\n  };\n};\n\n// Used for horizontal relative motion. Dir is -1 or 1 (left or\n// right), unit can be "char", "column" (like char, but doesn\'t\n// cross line boundaries), "word" (across next word), or "group" (to\n// the start of next group of word or non-word-non-whitespace\n// chars). The visually param controls whether, in right-to-left\n// text, direction 1 means to move towards the next index in the\n// string, or towards the character to the right of the current\n// position. The resulting position will have a hitSide=true\n// property if it reached the end of the document.\nfunction findPosH(doc, pos, dir, unit, visually) {\n  var oldPos = pos;\n  var origDir = dir;\n  var lineObj = getLine(doc, pos.line);\n  function findNextLine() {\n    var l = pos.line + dir;\n    if (l < doc.first || l >= doc.first + doc.size) { return false }\n    pos = new Pos(l, pos.ch, pos.sticky);\n    return lineObj = getLine(doc, l)\n  }\n  function moveOnce(boundToLine) {\n    var next;\n    if (visually) {\n      next = moveVisually(doc.cm, lineObj, pos, dir);\n    } else {\n      next = moveLogically(lineObj, pos, dir);\n    }\n    if (next == null) {\n      if (!boundToLine && findNextLine())\n        { pos = endOfLine(visually, doc.cm, lineObj, pos.line, dir); }\n      else\n        { return false }\n    } else {\n      pos = next;\n    }\n    return true\n  }\n\n  if (unit == "char") {\n    moveOnce();\n  } else if (unit == "column") {\n    moveOnce(true);\n  } else if (unit == "word" || unit == "group") {\n    var sawType = null, group = unit == "group";\n    var helper = doc.cm && doc.cm.getHelper(pos, "wordChars");\n    for (var first = true;; first = false) {\n      if (dir < 0 && !moveOnce(!first)) { break }\n      var cur = lineObj.text.charAt(pos.ch) || "\\n";\n      var type = isWordChar(cur, helper) ? "w"\n        : group && cur == "\\n" ? "n"\n        : !group || /\\s/.test(cur) ? null\n        : "p";\n      if (group && !first && !type) { type = "s"; }\n      if (sawType && sawType != type) {\n        if (dir < 0) {dir = 1; moveOnce(); pos.sticky = "after";}\n        break\n      }\n\n      if (type) { sawType = type; }\n      if (dir > 0 && !moveOnce(!first)) { break }\n    }\n  }\n  var result = skipAtomic(doc, pos, oldPos, origDir, true);\n  if (equalCursorPos(oldPos, result)) { result.hitSide = true; }\n  return result\n}\n\n// For relative vertical movement. Dir may be -1 or 1. Unit can be\n// "page" or "line". The resulting position will have a hitSide=true\n// property if it reached the end of the document.\nfunction findPosV(cm, pos, dir, unit) {\n  var doc = cm.doc, x = pos.left, y;\n  if (unit == "page") {\n    var pageSize = Math.min(cm.display.wrapper.clientHeight, window.innerHeight || document.documentElement.clientHeight);\n    var moveAmount = Math.max(pageSize - .5 * textHeight(cm.display), 3);\n    y = (dir > 0 ? pos.bottom : pos.top) + dir * moveAmount;\n\n  } else if (unit == "line") {\n    y = dir > 0 ? pos.bottom + 3 : pos.top - 3;\n  }\n  var target;\n  for (;;) {\n    target = coordsChar(cm, x, y);\n    if (!target.outside) { break }\n    if (dir < 0 ? y <= 0 : y >= doc.height) { target.hitSide = true; break }\n    y += dir * 5;\n  }\n  return target\n}\n\n// CONTENTEDITABLE INPUT STYLE\n\nvar ContentEditableInput = function(cm) {\n  this.cm = cm;\n  this.lastAnchorNode = this.lastAnchorOffset = this.lastFocusNode = this.lastFocusOffset = null;\n  this.polling = new Delayed();\n  this.composing = null;\n  this.gracePeriod = false;\n  this.readDOMTimeout = null;\n};\n\nContentEditableInput.prototype.init = function (display) {\n    var this$1 = this;\n\n  var input = this, cm = input.cm;\n  var div = input.div = display.lineDiv;\n  disableBrowserMagic(div, cm.options.spellcheck);\n\n  on(div, "paste", function (e) {\n    if (signalDOMEvent(cm, e) || handlePaste(e, cm)) { return }\n    // IE doesn\'t fire input events, so we schedule a read for the pasted content in this way\n    if (ie_version <= 11) { setTimeout(operation(cm, function () { return this$1.updateFromDOM(); }), 20); }\n  });\n\n  on(div, "compositionstart", function (e) {\n    this$1.composing = {data: e.data, done: false};\n  });\n  on(div, "compositionupdate", function (e) {\n    if (!this$1.composing) { this$1.composing = {data: e.data, done: false}; }\n  });\n  on(div, "compositionend", function (e) {\n    if (this$1.composing) {\n      if (e.data != this$1.composing.data) { this$1.readFromDOMSoon(); }\n      this$1.composing.done = true;\n    }\n  });\n\n  on(div, "touchstart", function () { return input.forceCompositionEnd(); });\n\n  on(div, "input", function () {\n    if (!this$1.composing) { this$1.readFromDOMSoon(); }\n  });\n\n  function onCopyCut(e) {\n    if (signalDOMEvent(cm, e)) { return }\n    if (cm.somethingSelected()) {\n      setLastCopied({lineWise: false, text: cm.getSelections()});\n      if (e.type == "cut") { cm.replaceSelection("", null, "cut"); }\n    } else if (!cm.options.lineWiseCopyCut) {\n      return\n    } else {\n      var ranges = copyableRanges(cm);\n      setLastCopied({lineWise: true, text: ranges.text});\n      if (e.type == "cut") {\n        cm.operation(function () {\n          cm.setSelections(ranges.ranges, 0, sel_dontScroll);\n          cm.replaceSelection("", null, "cut");\n        });\n      }\n    }\n    if (e.clipboardData) {\n      e.clipboardData.clearData();\n      var content = lastCopied.text.join("\\n");\n      // iOS exposes the clipboard API, but seems to discard content inserted into it\n      e.clipboardData.setData("Text", content);\n      if (e.clipboardData.getData("Text") == content) {\n        e.preventDefault();\n        return\n      }\n    }\n    // Old-fashioned briefly-focus-a-textarea hack\n    var kludge = hiddenTextarea(), te = kludge.firstChild;\n    cm.display.lineSpace.insertBefore(kludge, cm.display.lineSpace.firstChild);\n    te.value = lastCopied.text.join("\\n");\n    var hadFocus = document.activeElement;\n    selectInput(te);\n    setTimeout(function () {\n      cm.display.lineSpace.removeChild(kludge);\n      hadFocus.focus();\n      if (hadFocus == div) { input.showPrimarySelection(); }\n    }, 50);\n  }\n  on(div, "copy", onCopyCut);\n  on(div, "cut", onCopyCut);\n};\n\nContentEditableInput.prototype.prepareSelection = function () {\n  var result = prepareSelection(this.cm, false);\n  result.focus = this.cm.state.focused;\n  return result\n};\n\nContentEditableInput.prototype.showSelection = function (info, takeFocus) {\n  if (!info || !this.cm.display.view.length) { return }\n  if (info.focus || takeFocus) { this.showPrimarySelection(); }\n  this.showMultipleSelections(info);\n};\n\nContentEditableInput.prototype.showPrimarySelection = function () {\n  var sel = window.getSelection(), cm = this.cm, prim = cm.doc.sel.primary();\n  var from = prim.from(), to = prim.to();\n\n  if (cm.display.viewTo == cm.display.viewFrom || from.line >= cm.display.viewTo || to.line < cm.display.viewFrom) {\n    sel.removeAllRanges();\n    return\n  }\n\n  var curAnchor = domToPos(cm, sel.anchorNode, sel.anchorOffset);\n  var curFocus = domToPos(cm, sel.focusNode, sel.focusOffset);\n  if (curAnchor && !curAnchor.bad && curFocus && !curFocus.bad &&\n      cmp(minPos(curAnchor, curFocus), from) == 0 &&\n      cmp(maxPos(curAnchor, curFocus), to) == 0)\n    { return }\n\n  var view = cm.display.view;\n  var start = (from.line >= cm.display.viewFrom && posToDOM(cm, from)) ||\n      {node: view[0].measure.map[2], offset: 0};\n  var end = to.line < cm.display.viewTo && posToDOM(cm, to);\n  if (!end) {\n    var measure = view[view.length - 1].measure;\n    var map$$1 = measure.maps ? measure.maps[measure.maps.length - 1] : measure.map;\n    end = {node: map$$1[map$$1.length - 1], offset: map$$1[map$$1.length - 2] - map$$1[map$$1.length - 3]};\n  }\n\n  if (!start || !end) {\n    sel.removeAllRanges();\n    return\n  }\n\n  var old = sel.rangeCount && sel.getRangeAt(0), rng;\n  try { rng = range(start.node, start.offset, end.offset, end.node); }\n  catch(e) {} // Our model of the DOM might be outdated, in which case the range we try to set can be impossible\n  if (rng) {\n    if (!gecko && cm.state.focused) {\n      sel.collapse(start.node, start.offset);\n      if (!rng.collapsed) {\n        sel.removeAllRanges();\n        sel.addRange(rng);\n      }\n    } else {\n      sel.removeAllRanges();\n      sel.addRange(rng);\n    }\n    if (old && sel.anchorNode == null) { sel.addRange(old); }\n    else if (gecko) { this.startGracePeriod(); }\n  }\n  this.rememberSelection();\n};\n\nContentEditableInput.prototype.startGracePeriod = function () {\n    var this$1 = this;\n\n  clearTimeout(this.gracePeriod);\n  this.gracePeriod = setTimeout(function () {\n    this$1.gracePeriod = false;\n    if (this$1.selectionChanged())\n      { this$1.cm.operation(function () { return this$1.cm.curOp.selectionChanged = true; }); }\n  }, 20);\n};\n\nContentEditableInput.prototype.showMultipleSelections = function (info) {\n  removeChildrenAndAdd(this.cm.display.cursorDiv, info.cursors);\n  removeChildrenAndAdd(this.cm.display.selectionDiv, info.selection);\n};\n\nContentEditableInput.prototype.rememberSelection = function () {\n  var sel = window.getSelection();\n  this.lastAnchorNode = sel.anchorNode; this.lastAnchorOffset = sel.anchorOffset;\n  this.lastFocusNode = sel.focusNode; this.lastFocusOffset = sel.focusOffset;\n};\n\nContentEditableInput.prototype.selectionInEditor = function () {\n  var sel = window.getSelection();\n  if (!sel.rangeCount) { return false }\n  var node = sel.getRangeAt(0).commonAncestorContainer;\n  return contains(this.div, node)\n};\n\nContentEditableInput.prototype.focus = function () {\n  if (this.cm.options.readOnly != "nocursor") {\n    if (!this.selectionInEditor())\n      { this.showSelection(this.prepareSelection(), true); }\n    this.div.focus();\n  }\n};\nContentEditableInput.prototype.blur = function () { this.div.blur(); };\nContentEditableInput.prototype.getField = function () { return this.div };\n\nContentEditableInput.prototype.supportsTouch = function () { return true };\n\nContentEditableInput.prototype.receivedFocus = function () {\n  var input = this;\n  if (this.selectionInEditor())\n    { this.pollSelection(); }\n  else\n    { runInOp(this.cm, function () { return input.cm.curOp.selectionChanged = true; }); }\n\n  function poll() {\n    if (input.cm.state.focused) {\n      input.pollSelection();\n      input.polling.set(input.cm.options.pollInterval, poll);\n    }\n  }\n  this.polling.set(this.cm.options.pollInterval, poll);\n};\n\nContentEditableInput.prototype.selectionChanged = function () {\n  var sel = window.getSelection();\n  return sel.anchorNode != this.lastAnchorNode || sel.anchorOffset != this.lastAnchorOffset ||\n    sel.focusNode != this.lastFocusNode || sel.focusOffset != this.lastFocusOffset\n};\n\nContentEditableInput.prototype.pollSelection = function () {\n  if (this.readDOMTimeout != null || this.gracePeriod || !this.selectionChanged()) { return }\n  var sel = window.getSelection(), cm = this.cm;\n  // On Android Chrome (version 56, at least), backspacing into an\n  // uneditable block element will put the cursor in that element,\n  // and then, because it\'s not editable, hide the virtual keyboard.\n  // Because Android doesn\'t allow us to actually detect backspace\n  // presses in a sane way, this code checks for when that happens\n  // and simulates a backspace press in this case.\n  if (android && chrome && this.cm.options.gutters.length && isInGutter(sel.anchorNode)) {\n    this.cm.triggerOnKeyDown({type: "keydown", keyCode: 8, preventDefault: Math.abs});\n    this.blur();\n    this.focus();\n    return\n  }\n  if (this.composing) { return }\n  this.rememberSelection();\n  var anchor = domToPos(cm, sel.anchorNode, sel.anchorOffset);\n  var head = domToPos(cm, sel.focusNode, sel.focusOffset);\n  if (anchor && head) { runInOp(cm, function () {\n    setSelection(cm.doc, simpleSelection(anchor, head), sel_dontScroll);\n    if (anchor.bad || head.bad) { cm.curOp.selectionChanged = true; }\n  }); }\n};\n\nContentEditableInput.prototype.pollContent = function () {\n  if (this.readDOMTimeout != null) {\n    clearTimeout(this.readDOMTimeout);\n    this.readDOMTimeout = null;\n  }\n\n  var cm = this.cm, display = cm.display, sel = cm.doc.sel.primary();\n  var from = sel.from(), to = sel.to();\n  if (from.ch == 0 && from.line > cm.firstLine())\n    { from = Pos(from.line - 1, getLine(cm.doc, from.line - 1).length); }\n  if (to.ch == getLine(cm.doc, to.line).text.length && to.line < cm.lastLine())\n    { to = Pos(to.line + 1, 0); }\n  if (from.line < display.viewFrom || to.line > display.viewTo - 1) { return false }\n\n  var fromIndex, fromLine, fromNode;\n  if (from.line == display.viewFrom || (fromIndex = findViewIndex(cm, from.line)) == 0) {\n    fromLine = lineNo(display.view[0].line);\n    fromNode = display.view[0].node;\n  } else {\n    fromLine = lineNo(display.view[fromIndex].line);\n    fromNode = display.view[fromIndex - 1].node.nextSibling;\n  }\n  var toIndex = findViewIndex(cm, to.line);\n  var toLine, toNode;\n  if (toIndex == display.view.length - 1) {\n    toLine = display.viewTo - 1;\n    toNode = display.lineDiv.lastChild;\n  } else {\n    toLine = lineNo(display.view[toIndex + 1].line) - 1;\n    toNode = display.view[toIndex + 1].node.previousSibling;\n  }\n\n  if (!fromNode) { return false }\n  var newText = cm.doc.splitLines(domTextBetween(cm, fromNode, toNode, fromLine, toLine));\n  var oldText = getBetween(cm.doc, Pos(fromLine, 0), Pos(toLine, getLine(cm.doc, toLine).text.length));\n  while (newText.length > 1 && oldText.length > 1) {\n    if (lst(newText) == lst(oldText)) { newText.pop(); oldText.pop(); toLine--; }\n    else if (newText[0] == oldText[0]) { newText.shift(); oldText.shift(); fromLine++; }\n    else { break }\n  }\n\n  var cutFront = 0, cutEnd = 0;\n  var newTop = newText[0], oldTop = oldText[0], maxCutFront = Math.min(newTop.length, oldTop.length);\n  while (cutFront < maxCutFront && newTop.charCodeAt(cutFront) == oldTop.charCodeAt(cutFront))\n    { ++cutFront; }\n  var newBot = lst(newText), oldBot = lst(oldText);\n  var maxCutEnd = Math.min(newBot.length - (newText.length == 1 ? cutFront : 0),\n                           oldBot.length - (oldText.length == 1 ? cutFront : 0));\n  while (cutEnd < maxCutEnd &&\n         newBot.charCodeAt(newBot.length - cutEnd - 1) == oldBot.charCodeAt(oldBot.length - cutEnd - 1))\n    { ++cutEnd; }\n  // Try to move start of change to start of selection if ambiguous\n  if (newText.length == 1 && oldText.length == 1 && fromLine == from.line) {\n    while (cutFront && cutFront > from.ch &&\n           newBot.charCodeAt(newBot.length - cutEnd - 1) == oldBot.charCodeAt(oldBot.length - cutEnd - 1)) {\n      cutFront--;\n      cutEnd++;\n    }\n  }\n\n  newText[newText.length - 1] = newBot.slice(0, newBot.length - cutEnd).replace(/^\\u200b+/, "");\n  newText[0] = newText[0].slice(cutFront).replace(/\\u200b+$/, "");\n\n  var chFrom = Pos(fromLine, cutFront);\n  var chTo = Pos(toLine, oldText.length ? lst(oldText).length - cutEnd : 0);\n  if (newText.length > 1 || newText[0] || cmp(chFrom, chTo)) {\n    replaceRange(cm.doc, newText, chFrom, chTo, "+input");\n    return true\n  }\n};\n\nContentEditableInput.prototype.ensurePolled = function () {\n  this.forceCompositionEnd();\n};\nContentEditableInput.prototype.reset = function () {\n  this.forceCompositionEnd();\n};\nContentEditableInput.prototype.forceCompositionEnd = function () {\n  if (!this.composing) { return }\n  clearTimeout(this.readDOMTimeout);\n  this.composing = null;\n  this.updateFromDOM();\n  this.div.blur();\n  this.div.focus();\n};\nContentEditableInput.prototype.readFromDOMSoon = function () {\n    var this$1 = this;\n\n  if (this.readDOMTimeout != null) { return }\n  this.readDOMTimeout = setTimeout(function () {\n    this$1.readDOMTimeout = null;\n    if (this$1.composing) {\n      if (this$1.composing.done) { this$1.composing = null; }\n      else { return }\n    }\n    this$1.updateFromDOM();\n  }, 80);\n};\n\nContentEditableInput.prototype.updateFromDOM = function () {\n    var this$1 = this;\n\n  if (this.cm.isReadOnly() || !this.pollContent())\n    { runInOp(this.cm, function () { return regChange(this$1.cm); }); }\n};\n\nContentEditableInput.prototype.setUneditable = function (node) {\n  node.contentEditable = "false";\n};\n\nContentEditableInput.prototype.onKeyPress = function (e) {\n  if (e.charCode == 0) { return }\n  e.preventDefault();\n  if (!this.cm.isReadOnly())\n    { operation(this.cm, applyTextInput)(this.cm, String.fromCharCode(e.charCode == null ? e.keyCode : e.charCode), 0); }\n};\n\nContentEditableInput.prototype.readOnlyChanged = function (val) {\n  this.div.contentEditable = String(val != "nocursor");\n};\n\nContentEditableInput.prototype.onContextMenu = function () {};\nContentEditableInput.prototype.resetPosition = function () {};\n\nContentEditableInput.prototype.needsContentAttribute = true;\n\nfunction posToDOM(cm, pos) {\n  var view = findViewForLine(cm, pos.line);\n  if (!view || view.hidden) { return null }\n  var line = getLine(cm.doc, pos.line);\n  var info = mapFromLineView(view, line, pos.line);\n\n  var order = getOrder(line, cm.doc.direction), side = "left";\n  if (order) {\n    var partPos = getBidiPartAt(order, pos.ch);\n    side = partPos % 2 ? "right" : "left";\n  }\n  var result = nodeAndOffsetInLineMap(info.map, pos.ch, side);\n  result.offset = result.collapse == "right" ? result.end : result.start;\n  return result\n}\n\nfunction isInGutter(node) {\n  for (var scan = node; scan; scan = scan.parentNode)\n    { if (/CodeMirror-gutter-wrapper/.test(scan.className)) { return true } }\n  return false\n}\n\nfunction badPos(pos, bad) { if (bad) { pos.bad = true; } return pos }\n\nfunction domTextBetween(cm, from, to, fromLine, toLine) {\n  var text = "", closing = false, lineSep = cm.doc.lineSeparator();\n  function recognizeMarker(id) { return function (marker) { return marker.id == id; } }\n  function close() {\n    if (closing) {\n      text += lineSep;\n      closing = false;\n    }\n  }\n  function addText(str) {\n    if (str) {\n      close();\n      text += str;\n    }\n  }\n  function walk(node) {\n    if (node.nodeType == 1) {\n      var cmText = node.getAttribute("cm-text");\n      if (cmText != null) {\n        addText(cmText || node.textContent.replace(/\\u200b/g, ""));\n        return\n      }\n      var markerID = node.getAttribute("cm-marker"), range$$1;\n      if (markerID) {\n        var found = cm.findMarks(Pos(fromLine, 0), Pos(toLine + 1, 0), recognizeMarker(+markerID));\n        if (found.length && (range$$1 = found[0].find()))\n          { addText(getBetween(cm.doc, range$$1.from, range$$1.to).join(lineSep)); }\n        return\n      }\n      if (node.getAttribute("contenteditable") == "false") { return }\n      var isBlock = /^(pre|div|p)$/i.test(node.nodeName);\n      if (isBlock) { close(); }\n      for (var i = 0; i < node.childNodes.length; i++)\n        { walk(node.childNodes[i]); }\n      if (isBlock) { closing = true; }\n    } else if (node.nodeType == 3) {\n      addText(node.nodeValue);\n    }\n  }\n  for (;;) {\n    walk(from);\n    if (from == to) { break }\n    from = from.nextSibling;\n  }\n  return text\n}\n\nfunction domToPos(cm, node, offset) {\n  var lineNode;\n  if (node == cm.display.lineDiv) {\n    lineNode = cm.display.lineDiv.childNodes[offset];\n    if (!lineNode) { return badPos(cm.clipPos(Pos(cm.display.viewTo - 1)), true) }\n    node = null; offset = 0;\n  } else {\n    for (lineNode = node;; lineNode = lineNode.parentNode) {\n      if (!lineNode || lineNode == cm.display.lineDiv) { return null }\n      if (lineNode.parentNode && lineNode.parentNode == cm.display.lineDiv) { break }\n    }\n  }\n  for (var i = 0; i < cm.display.view.length; i++) {\n    var lineView = cm.display.view[i];\n    if (lineView.node == lineNode)\n      { return locateNodeInLineView(lineView, node, offset) }\n  }\n}\n\nfunction locateNodeInLineView(lineView, node, offset) {\n  var wrapper = lineView.text.firstChild, bad = false;\n  if (!node || !contains(wrapper, node)) { return badPos(Pos(lineNo(lineView.line), 0), true) }\n  if (node == wrapper) {\n    bad = true;\n    node = wrapper.childNodes[offset];\n    offset = 0;\n    if (!node) {\n      var line = lineView.rest ? lst(lineView.rest) : lineView.line;\n      return badPos(Pos(lineNo(line), line.text.length), bad)\n    }\n  }\n\n  var textNode = node.nodeType == 3 ? node : null, topNode = node;\n  if (!textNode && node.childNodes.length == 1 && node.firstChild.nodeType == 3) {\n    textNode = node.firstChild;\n    if (offset) { offset = textNode.nodeValue.length; }\n  }\n  while (topNode.parentNode != wrapper) { topNode = topNode.parentNode; }\n  var measure = lineView.measure, maps = measure.maps;\n\n  function find(textNode, topNode, offset) {\n    for (var i = -1; i < (maps ? maps.length : 0); i++) {\n      var map$$1 = i < 0 ? measure.map : maps[i];\n      for (var j = 0; j < map$$1.length; j += 3) {\n        var curNode = map$$1[j + 2];\n        if (curNode == textNode || curNode == topNode) {\n          var line = lineNo(i < 0 ? lineView.line : lineView.rest[i]);\n          var ch = map$$1[j] + offset;\n          if (offset < 0 || curNode != textNode) { ch = map$$1[j + (offset ? 1 : 0)]; }\n          return Pos(line, ch)\n        }\n      }\n    }\n  }\n  var found = find(textNode, topNode, offset);\n  if (found) { return badPos(found, bad) }\n\n  // FIXME this is all really shaky. might handle the few cases it needs to handle, but likely to cause problems\n  for (var after = topNode.nextSibling, dist = textNode ? textNode.nodeValue.length - offset : 0; after; after = after.nextSibling) {\n    found = find(after, after.firstChild, 0);\n    if (found)\n      { return badPos(Pos(found.line, found.ch - dist), bad) }\n    else\n      { dist += after.textContent.length; }\n  }\n  for (var before = topNode.previousSibling, dist$1 = offset; before; before = before.previousSibling) {\n    found = find(before, before.firstChild, -1);\n    if (found)\n      { return badPos(Pos(found.line, found.ch + dist$1), bad) }\n    else\n      { dist$1 += before.textContent.length; }\n  }\n}\n\n// TEXTAREA INPUT STYLE\n\nvar TextareaInput = function(cm) {\n  this.cm = cm;\n  // See input.poll and input.reset\n  this.prevInput = "";\n\n  // Flag that indicates whether we expect input to appear real soon\n  // now (after some event like \'keypress\' or \'input\') and are\n  // polling intensively.\n  this.pollingFast = false;\n  // Self-resetting timeout for the poller\n  this.polling = new Delayed();\n  // Used to work around IE issue with selection being forgotten when focus moves away from textarea\n  this.hasSelection = false;\n  this.composing = null;\n};\n\nTextareaInput.prototype.init = function (display) {\n    var this$1 = this;\n\n  var input = this, cm = this.cm;\n\n  // Wraps and hides input textarea\n  var div = this.wrapper = hiddenTextarea();\n  // The semihidden textarea that is focused when the editor is\n  // focused, and receives input.\n  var te = this.textarea = div.firstChild;\n  display.wrapper.insertBefore(div, display.wrapper.firstChild);\n\n  // Needed to hide big blue blinking cursor on Mobile Safari (doesn\'t seem to work in iOS 8 anymore)\n  if (ios) { te.style.width = "0px"; }\n\n  on(te, "input", function () {\n    if (ie && ie_version >= 9 && this$1.hasSelection) { this$1.hasSelection = null; }\n    input.poll();\n  });\n\n  on(te, "paste", function (e) {\n    if (signalDOMEvent(cm, e) || handlePaste(e, cm)) { return }\n\n    cm.state.pasteIncoming = true;\n    input.fastPoll();\n  });\n\n  function prepareCopyCut(e) {\n    if (signalDOMEvent(cm, e)) { return }\n    if (cm.somethingSelected()) {\n      setLastCopied({lineWise: false, text: cm.getSelections()});\n    } else if (!cm.options.lineWiseCopyCut) {\n      return\n    } else {\n      var ranges = copyableRanges(cm);\n      setLastCopied({lineWise: true, text: ranges.text});\n      if (e.type == "cut") {\n        cm.setSelections(ranges.ranges, null, sel_dontScroll);\n      } else {\n        input.prevInput = "";\n        te.value = ranges.text.join("\\n");\n        selectInput(te);\n      }\n    }\n    if (e.type == "cut") { cm.state.cutIncoming = true; }\n  }\n  on(te, "cut", prepareCopyCut);\n  on(te, "copy", prepareCopyCut);\n\n  on(display.scroller, "paste", function (e) {\n    if (eventInWidget(display, e) || signalDOMEvent(cm, e)) { return }\n    cm.state.pasteIncoming = true;\n    input.focus();\n  });\n\n  // Prevent normal selection in the editor (we handle our own)\n  on(display.lineSpace, "selectstart", function (e) {\n    if (!eventInWidget(display, e)) { e_preventDefault(e); }\n  });\n\n  on(te, "compositionstart", function () {\n    var start = cm.getCursor("from");\n    if (input.composing) { input.composing.range.clear(); }\n    input.composing = {\n      start: start,\n      range: cm.markText(start, cm.getCursor("to"), {className: "CodeMirror-composing"})\n    };\n  });\n  on(te, "compositionend", function () {\n    if (input.composing) {\n      input.poll();\n      input.composing.range.clear();\n      input.composing = null;\n    }\n  });\n};\n\nTextareaInput.prototype.prepareSelection = function () {\n  // Redraw the selection and/or cursor\n  var cm = this.cm, display = cm.display, doc = cm.doc;\n  var result = prepareSelection(cm);\n\n  // Move the hidden textarea near the cursor to prevent scrolling artifacts\n  if (cm.options.moveInputWithCursor) {\n    var headPos = cursorCoords(cm, doc.sel.primary().head, "div");\n    var wrapOff = display.wrapper.getBoundingClientRect(), lineOff = display.lineDiv.getBoundingClientRect();\n    result.teTop = Math.max(0, Math.min(display.wrapper.clientHeight - 10,\n                                        headPos.top + lineOff.top - wrapOff.top));\n    result.teLeft = Math.max(0, Math.min(display.wrapper.clientWidth - 10,\n                                         headPos.left + lineOff.left - wrapOff.left));\n  }\n\n  return result\n};\n\nTextareaInput.prototype.showSelection = function (drawn) {\n  var cm = this.cm, display = cm.display;\n  removeChildrenAndAdd(display.cursorDiv, drawn.cursors);\n  removeChildrenAndAdd(display.selectionDiv, drawn.selection);\n  if (drawn.teTop != null) {\n    this.wrapper.style.top = drawn.teTop + "px";\n    this.wrapper.style.left = drawn.teLeft + "px";\n  }\n};\n\n// Reset the input to correspond to the selection (or to be empty,\n// when not typing and nothing is selected)\nTextareaInput.prototype.reset = function (typing) {\n  if (this.contextMenuPending || this.composing) { return }\n  var cm = this.cm;\n  if (cm.somethingSelected()) {\n    this.prevInput = "";\n    var content = cm.getSelection();\n    this.textarea.value = content;\n    if (cm.state.focused) { selectInput(this.textarea); }\n    if (ie && ie_version >= 9) { this.hasSelection = content; }\n  } else if (!typing) {\n    this.prevInput = this.textarea.value = "";\n    if (ie && ie_version >= 9) { this.hasSelection = null; }\n  }\n};\n\nTextareaInput.prototype.getField = function () { return this.textarea };\n\nTextareaInput.prototype.supportsTouch = function () { return false };\n\nTextareaInput.prototype.focus = function () {\n  if (this.cm.options.readOnly != "nocursor" && (!mobile || activeElt() != this.textarea)) {\n    try { this.textarea.focus(); }\n    catch (e) {} // IE8 will throw if the textarea is display: none or not in DOM\n  }\n};\n\nTextareaInput.prototype.blur = function () { this.textarea.blur(); };\n\nTextareaInput.prototype.resetPosition = function () {\n  this.wrapper.style.top = this.wrapper.style.left = 0;\n};\n\nTextareaInput.prototype.receivedFocus = function () { this.slowPoll(); };\n\n// Poll for input changes, using the normal rate of polling. This\n// runs as long as the editor is focused.\nTextareaInput.prototype.slowPoll = function () {\n    var this$1 = this;\n\n  if (this.pollingFast) { return }\n  this.polling.set(this.cm.options.pollInterval, function () {\n    this$1.poll();\n    if (this$1.cm.state.focused) { this$1.slowPoll(); }\n  });\n};\n\n// When an event has just come in that is likely to add or change\n// something in the input textarea, we poll faster, to ensure that\n// the change appears on the screen quickly.\nTextareaInput.prototype.fastPoll = function () {\n  var missed = false, input = this;\n  input.pollingFast = true;\n  function p() {\n    var changed = input.poll();\n    if (!changed && !missed) {missed = true; input.polling.set(60, p);}\n    else {input.pollingFast = false; input.slowPoll();}\n  }\n  input.polling.set(20, p);\n};\n\n// Read input from the textarea, and update the document to match.\n// When something is selected, it is present in the textarea, and\n// selected (unless it is huge, in which case a placeholder is\n// used). When nothing is selected, the cursor sits after previously\n// seen text (can be empty), which is stored in prevInput (we must\n// not reset the textarea when typing, because that breaks IME).\nTextareaInput.prototype.poll = function () {\n    var this$1 = this;\n\n  var cm = this.cm, input = this.textarea, prevInput = this.prevInput;\n  // Since this is called a *lot*, try to bail out as cheaply as\n  // possible when it is clear that nothing happened. hasSelection\n  // will be the case when there is a lot of text in the textarea,\n  // in which case reading its value would be expensive.\n  if (this.contextMenuPending || !cm.state.focused ||\n      (hasSelection(input) && !prevInput && !this.composing) ||\n      cm.isReadOnly() || cm.options.disableInput || cm.state.keySeq)\n    { return false }\n\n  var text = input.value;\n  // If nothing changed, bail.\n  if (text == prevInput && !cm.somethingSelected()) { return false }\n  // Work around nonsensical selection resetting in IE9/10, and\n  // inexplicable appearance of private area unicode characters on\n  // some key combos in Mac (#2689).\n  if (ie && ie_version >= 9 && this.hasSelection === text ||\n      mac && /[\\uf700-\\uf7ff]/.test(text)) {\n    cm.display.input.reset();\n    return false\n  }\n\n  if (cm.doc.sel == cm.display.selForContextMenu) {\n    var first = text.charCodeAt(0);\n    if (first == 0x200b && !prevInput) { prevInput = "\\u200b"; }\n    if (first == 0x21da) { this.reset(); return this.cm.execCommand("undo") }\n  }\n  // Find the part of the input that is actually new\n  var same = 0, l = Math.min(prevInput.length, text.length);\n  while (same < l && prevInput.charCodeAt(same) == text.charCodeAt(same)) { ++same; }\n\n  runInOp(cm, function () {\n    applyTextInput(cm, text.slice(same), prevInput.length - same,\n                   null, this$1.composing ? "*compose" : null);\n\n    // Don\'t leave long text in the textarea, since it makes further polling slow\n    if (text.length > 1000 || text.indexOf("\\n") > -1) { input.value = this$1.prevInput = ""; }\n    else { this$1.prevInput = text; }\n\n    if (this$1.composing) {\n      this$1.composing.range.clear();\n      this$1.composing.range = cm.markText(this$1.composing.start, cm.getCursor("to"),\n                                         {className: "CodeMirror-composing"});\n    }\n  });\n  return true\n};\n\nTextareaInput.prototype.ensurePolled = function () {\n  if (this.pollingFast && this.poll()) { this.pollingFast = false; }\n};\n\nTextareaInput.prototype.onKeyPress = function () {\n  if (ie && ie_version >= 9) { this.hasSelection = null; }\n  this.fastPoll();\n};\n\nTextareaInput.prototype.onContextMenu = function (e) {\n  var input = this, cm = input.cm, display = cm.display, te = input.textarea;\n  var pos = posFromMouse(cm, e), scrollPos = display.scroller.scrollTop;\n  if (!pos || presto) { return } // Opera is difficult.\n\n  // Reset the current text selection only if the click is done outside of the selection\n  // and \'resetSelectionOnContextMenu\' option is true.\n  var reset = cm.options.resetSelectionOnContextMenu;\n  if (reset && cm.doc.sel.contains(pos) == -1)\n    { operation(cm, setSelection)(cm.doc, simpleSelection(pos), sel_dontScroll); }\n\n  var oldCSS = te.style.cssText, oldWrapperCSS = input.wrapper.style.cssText;\n  input.wrapper.style.cssText = "position: absolute";\n  var wrapperBox = input.wrapper.getBoundingClientRect();\n  te.style.cssText = "position: absolute; width: 30px; height: 30px;\\n      top: " + (e.clientY - wrapperBox.top - 5) + "px; left: " + (e.clientX - wrapperBox.left - 5) + "px;\\n      z-index: 1000; background: " + (ie ? "rgba(255, 255, 255, .05)" : "transparent") + ";\\n      outline: none; border-width: 0; outline: none; overflow: hidden; opacity: .05; filter: alpha(opacity=5);";\n  var oldScrollY;\n  if (webkit) { oldScrollY = window.scrollY; } // Work around Chrome issue (#2712)\n  display.input.focus();\n  if (webkit) { window.scrollTo(null, oldScrollY); }\n  display.input.reset();\n  // Adds "Select all" to context menu in FF\n  if (!cm.somethingSelected()) { te.value = input.prevInput = " "; }\n  input.contextMenuPending = true;\n  display.selForContextMenu = cm.doc.sel;\n  clearTimeout(display.detectingSelectAll);\n\n  // Select-all will be greyed out if there\'s nothing to select, so\n  // this adds a zero-width space so that we can later check whether\n  // it got selected.\n  function prepareSelectAllHack() {\n    if (te.selectionStart != null) {\n      var selected = cm.somethingSelected();\n      var extval = "\\u200b" + (selected ? te.value : "");\n      te.value = "\\u21da"; // Used to catch context-menu undo\n      te.value = extval;\n      input.prevInput = selected ? "" : "\\u200b";\n      te.selectionStart = 1; te.selectionEnd = extval.length;\n      // Re-set this, in case some other handler touched the\n      // selection in the meantime.\n      display.selForContextMenu = cm.doc.sel;\n    }\n  }\n  function rehide() {\n    input.contextMenuPending = false;\n    input.wrapper.style.cssText = oldWrapperCSS;\n    te.style.cssText = oldCSS;\n    if (ie && ie_version < 9) { display.scrollbars.setScrollTop(display.scroller.scrollTop = scrollPos); }\n\n    // Try to detect the user choosing select-all\n    if (te.selectionStart != null) {\n      if (!ie || (ie && ie_version < 9)) { prepareSelectAllHack(); }\n      var i = 0, poll = function () {\n        if (display.selForContextMenu == cm.doc.sel && te.selectionStart == 0 &&\n            te.selectionEnd > 0 && input.prevInput == "\\u200b") {\n          operation(cm, selectAll)(cm);\n        } else if (i++ < 10) {\n          display.detectingSelectAll = setTimeout(poll, 500);\n        } else {\n          display.selForContextMenu = null;\n          display.input.reset();\n        }\n      };\n      display.detectingSelectAll = setTimeout(poll, 200);\n    }\n  }\n\n  if (ie && ie_version >= 9) { prepareSelectAllHack(); }\n  if (captureRightClick) {\n    e_stop(e);\n    var mouseup = function () {\n      off(window, "mouseup", mouseup);\n      setTimeout(rehide, 20);\n    };\n    on(window, "mouseup", mouseup);\n  } else {\n    setTimeout(rehide, 50);\n  }\n};\n\nTextareaInput.prototype.readOnlyChanged = function (val) {\n  if (!val) { this.reset(); }\n  this.textarea.disabled = val == "nocursor";\n};\n\nTextareaInput.prototype.setUneditable = function () {};\n\nTextareaInput.prototype.needsContentAttribute = false;\n\nfunction fromTextArea(textarea, options) {\n  options = options ? copyObj(options) : {};\n  options.value = textarea.value;\n  if (!options.tabindex && textarea.tabIndex)\n    { options.tabindex = textarea.tabIndex; }\n  if (!options.placeholder && textarea.placeholder)\n    { options.placeholder = textarea.placeholder; }\n  // Set autofocus to true if this textarea is focused, or if it has\n  // autofocus and no other element is focused.\n  if (options.autofocus == null) {\n    var hasFocus = activeElt();\n    options.autofocus = hasFocus == textarea ||\n      textarea.getAttribute("autofocus") != null && hasFocus == document.body;\n  }\n\n  function save() {textarea.value = cm.getValue();}\n\n  var realSubmit;\n  if (textarea.form) {\n    on(textarea.form, "submit", save);\n    // Deplorable hack to make the submit method do the right thing.\n    if (!options.leaveSubmitMethodAlone) {\n      var form = textarea.form;\n      realSubmit = form.submit;\n      try {\n        var wrappedSubmit = form.submit = function () {\n          save();\n          form.submit = realSubmit;\n          form.submit();\n          form.submit = wrappedSubmit;\n        };\n      } catch(e) {}\n    }\n  }\n\n  options.finishInit = function (cm) {\n    cm.save = save;\n    cm.getTextArea = function () { return textarea; };\n    cm.toTextArea = function () {\n      cm.toTextArea = isNaN; // Prevent this from being ran twice\n      save();\n      textarea.parentNode.removeChild(cm.getWrapperElement());\n      textarea.style.display = "";\n      if (textarea.form) {\n        off(textarea.form, "submit", save);\n        if (typeof textarea.form.submit == "function")\n          { textarea.form.submit = realSubmit; }\n      }\n    };\n  };\n\n  textarea.style.display = "none";\n  var cm = CodeMirror$1(function (node) { return textarea.parentNode.insertBefore(node, textarea.nextSibling); },\n    options);\n  return cm\n}\n\nfunction addLegacyProps(CodeMirror) {\n  CodeMirror.off = off;\n  CodeMirror.on = on;\n  CodeMirror.wheelEventPixels = wheelEventPixels;\n  CodeMirror.Doc = Doc;\n  CodeMirror.splitLines = splitLinesAuto;\n  CodeMirror.countColumn = countColumn;\n  CodeMirror.findColumn = findColumn;\n  CodeMirror.isWordChar = isWordCharBasic;\n  CodeMirror.Pass = Pass;\n  CodeMirror.signal = signal;\n  CodeMirror.Line = Line;\n  CodeMirror.changeEnd = changeEnd;\n  CodeMirror.scrollbarModel = scrollbarModel;\n  CodeMirror.Pos = Pos;\n  CodeMirror.cmpPos = cmp;\n  CodeMirror.modes = modes;\n  CodeMirror.mimeModes = mimeModes;\n  CodeMirror.resolveMode = resolveMode;\n  CodeMirror.getMode = getMode;\n  CodeMirror.modeExtensions = modeExtensions;\n  CodeMirror.extendMode = extendMode;\n  CodeMirror.copyState = copyState;\n  CodeMirror.startState = startState;\n  CodeMirror.innerMode = innerMode;\n  CodeMirror.commands = commands;\n  CodeMirror.keyMap = keyMap;\n  CodeMirror.keyName = keyName;\n  CodeMirror.isModifierKey = isModifierKey;\n  CodeMirror.lookupKey = lookupKey;\n  CodeMirror.normalizeKeyMap = normalizeKeyMap;\n  CodeMirror.StringStream = StringStream;\n  CodeMirror.SharedTextMarker = SharedTextMarker;\n  CodeMirror.TextMarker = TextMarker;\n  CodeMirror.LineWidget = LineWidget;\n  CodeMirror.e_preventDefault = e_preventDefault;\n  CodeMirror.e_stopPropagation = e_stopPropagation;\n  CodeMirror.e_stop = e_stop;\n  CodeMirror.addClass = addClass;\n  CodeMirror.contains = contains;\n  CodeMirror.rmClass = rmClass;\n  CodeMirror.keyNames = keyNames;\n}\n\n// EDITOR CONSTRUCTOR\n\ndefineOptions(CodeMirror$1);\n\naddEditorMethods(CodeMirror$1);\n\n// Set up methods on CodeMirror\'s prototype to redirect to the editor\'s document.\nvar dontDelegate = "iter insert remove copy getEditor constructor".split(" ");\nfor (var prop in Doc.prototype) { if (Doc.prototype.hasOwnProperty(prop) && indexOf(dontDelegate, prop) < 0)\n  { CodeMirror$1.prototype[prop] = (function(method) {\n    return function() {return method.apply(this.doc, arguments)}\n  })(Doc.prototype[prop]); } }\n\neventMixin(Doc);\n\n// INPUT HANDLING\n\nCodeMirror$1.inputStyles = {"textarea": TextareaInput, "contenteditable": ContentEditableInput};\n\n// MODE DEFINITION AND QUERYING\n\n// Extra arguments are stored as the mode\'s dependencies, which is\n// used by (legacy) mechanisms like loadmode.js to automatically\n// load a mode. (Preferred mechanism is the require/define calls.)\nCodeMirror$1.defineMode = function(name/*, mode, …*/) {\n  if (!CodeMirror$1.defaults.mode && name != "null") { CodeMirror$1.defaults.mode = name; }\n  defineMode.apply(this, arguments);\n};\n\nCodeMirror$1.defineMIME = defineMIME;\n\n// Minimal default mode.\nCodeMirror$1.defineMode("null", function () { return ({token: function (stream) { return stream.skipToEnd(); }}); });\nCodeMirror$1.defineMIME("text/plain", "null");\n\n// EXTENSIONS\n\nCodeMirror$1.defineExtension = function (name, func) {\n  CodeMirror$1.prototype[name] = func;\n};\nCodeMirror$1.defineDocExtension = function (name, func) {\n  Doc.prototype[name] = func;\n};\n\nCodeMirror$1.fromTextArea = fromTextArea;\n\naddLegacyProps(CodeMirror$1);\n\nCodeMirror$1.version = "5.28.0";\n\nreturn CodeMirror$1;\n\n})));\n\n//# sourceURL=/thirdparty/CodeMirror/lib/codemirror.js'),
eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/edit/closebrackets\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  var defaults = {\n    pairs: "()[]{}\'\'\\"\\"",\n    triples: "",\n    explode: "[]{}"\n  };\n\n  var Pos = CodeMirror.Pos;\n\n  CodeMirror.defineOption("autoCloseBrackets", false, function(cm, val, old) {\n    if (old && old != CodeMirror.Init) {\n      cm.removeKeyMap(keyMap);\n      cm.state.closeBrackets = null;\n    }\n    if (val) {\n      cm.state.closeBrackets = val;\n      cm.addKeyMap(keyMap);\n    }\n  });\n\n  function getOption(conf, name) {\n    if (name == "pairs" && typeof conf == "string") return conf;\n    if (typeof conf == "object" && conf[name] != null) return conf[name];\n    return defaults[name];\n  }\n\n  var bind = defaults.pairs + "`";\n  var keyMap = {Backspace: handleBackspace, Enter: handleEnter};\n  for (var i = 0; i < bind.length; i++)\n    keyMap["\'" + bind.charAt(i) + "\'"] = handler(bind.charAt(i));\n\n  function handler(ch) {\n    return function(cm) { return handleChar(cm, ch); };\n  }\n\n  function getConfig(cm) {\n    var deflt = cm.state.closeBrackets;\n    if (!deflt || deflt.override) return deflt;\n    var mode = cm.getModeAt(cm.getCursor());\n    return mode.closeBrackets || deflt;\n  }\n\n  function handleBackspace(cm) {\n    var conf = getConfig(cm);\n    if (!conf || cm.getOption("disableInput")) return CodeMirror.Pass;\n\n    var pairs = getOption(conf, "pairs");\n    var ranges = cm.listSelections();\n    for (var i = 0; i < ranges.length; i++) {\n      if (!ranges[i].empty()) return CodeMirror.Pass;\n      var around = charsAround(cm, ranges[i].head);\n      if (!around || pairs.indexOf(around) % 2 != 0) return CodeMirror.Pass;\n    }\n    for (var i = ranges.length - 1; i >= 0; i--) {\n      var cur = ranges[i].head;\n      cm.replaceRange("", Pos(cur.line, cur.ch - 1), Pos(cur.line, cur.ch + 1), "+delete");\n    }\n  }\n\n  function handleEnter(cm) {\n    var conf = getConfig(cm);\n    var explode = conf && getOption(conf, "explode");\n    if (!explode || cm.getOption("disableInput")) return CodeMirror.Pass;\n\n    var ranges = cm.listSelections();\n    for (var i = 0; i < ranges.length; i++) {\n      if (!ranges[i].empty()) return CodeMirror.Pass;\n      var around = charsAround(cm, ranges[i].head);\n      if (!around || explode.indexOf(around) % 2 != 0) return CodeMirror.Pass;\n    }\n    cm.operation(function() {\n      cm.replaceSelection("\\n\\n", null);\n      cm.execCommand("goCharLeft");\n      ranges = cm.listSelections();\n      for (var i = 0; i < ranges.length; i++) {\n        var line = ranges[i].head.line;\n        cm.indentLine(line, null, true);\n        cm.indentLine(line + 1, null, true);\n      }\n    });\n  }\n\n  function contractSelection(sel) {\n    var inverted = CodeMirror.cmpPos(sel.anchor, sel.head) > 0;\n    return {anchor: new Pos(sel.anchor.line, sel.anchor.ch + (inverted ? -1 : 1)),\n            head: new Pos(sel.head.line, sel.head.ch + (inverted ? 1 : -1))};\n  }\n\n  function handleChar(cm, ch) {\n    var conf = getConfig(cm);\n    if (!conf || cm.getOption("disableInput")) return CodeMirror.Pass;\n\n    var pairs = getOption(conf, "pairs");\n    var pos = pairs.indexOf(ch);\n    if (pos == -1) return CodeMirror.Pass;\n    var triples = getOption(conf, "triples");\n\n    var identical = pairs.charAt(pos + 1) == ch;\n    var ranges = cm.listSelections();\n    var opening = pos % 2 == 0;\n\n    var type;\n    for (var i = 0; i < ranges.length; i++) {\n      var range = ranges[i], cur = range.head, curType;\n      var next = cm.getRange(cur, Pos(cur.line, cur.ch + 1));\n      if (opening && !range.empty()) {\n        curType = "surround";\n      } else if ((identical || !opening) && next == ch) {\n        if (identical && stringStartsAfter(cm, cur))\n          curType = "both";\n        else if (triples.indexOf(ch) >= 0 && cm.getRange(cur, Pos(cur.line, cur.ch + 3)) == ch + ch + ch)\n          curType = "skipThree";\n        else\n          curType = "skip";\n      } else if (identical && cur.ch > 1 && triples.indexOf(ch) >= 0 &&\n                 cm.getRange(Pos(cur.line, cur.ch - 2), cur) == ch + ch &&\n                 (cur.ch <= 2 || cm.getRange(Pos(cur.line, cur.ch - 3), Pos(cur.line, cur.ch - 2)) != ch)) {\n        curType = "addFour";\n      } else if (identical) {\n        if (!CodeMirror.isWordChar(next) && enteringString(cm, cur, ch)) curType = "both";\n        else return CodeMirror.Pass;\n      } else if (opening && (cm.getLine(cur.line).length == cur.ch ||\n                             isClosingBracket(next, pairs) ||\n                             /\\s/.test(next))) {\n        curType = "both";\n      } else {\n        return CodeMirror.Pass;\n      }\n      if (!type) type = curType;\n      else if (type != curType) return CodeMirror.Pass;\n    }\n\n    var left = pos % 2 ? pairs.charAt(pos - 1) : ch;\n    var right = pos % 2 ? ch : pairs.charAt(pos + 1);\n    cm.operation(function() {\n      if (type == "skip") {\n        cm.execCommand("goCharRight");\n      } else if (type == "skipThree") {\n        for (var i = 0; i < 3; i++)\n          cm.execCommand("goCharRight");\n      } else if (type == "surround") {\n        var sels = cm.getSelections();\n        for (var i = 0; i < sels.length; i++)\n          sels[i] = left + sels[i] + right;\n        cm.replaceSelections(sels, "around");\n        sels = cm.listSelections().slice();\n        for (var i = 0; i < sels.length; i++)\n          sels[i] = contractSelection(sels[i]);\n        cm.setSelections(sels);\n      } else if (type == "both") {\n        cm.replaceSelection(left + right, null);\n        cm.triggerElectric(left + right);\n        cm.execCommand("goCharLeft");\n      } else if (type == "addFour") {\n        cm.replaceSelection(left + left + left + left, "before");\n        cm.execCommand("goCharRight");\n      }\n    });\n  }\n\n  function isClosingBracket(ch, pairs) {\n    var pos = pairs.lastIndexOf(ch);\n    return pos > -1 && pos % 2 == 1;\n  }\n\n  function charsAround(cm, pos) {\n    var str = cm.getRange(Pos(pos.line, pos.ch - 1),\n                          Pos(pos.line, pos.ch + 1));\n    return str.length == 2 ? str : null;\n  }\n\n  // Project the token type that will exists after the given char is\n  // typed, and use it to determine whether it would cause the start\n  // of a string token.\n  function enteringString(cm, pos, ch) {\n    var line = cm.getLine(pos.line);\n    var token = cm.getTokenAt(pos);\n    if (/\\bstring2?\\b/.test(token.type) || stringStartsAfter(cm, pos)) return false;\n    var stream = new CodeMirror.StringStream(line.slice(0, pos.ch) + ch + line.slice(pos.ch), 4);\n    stream.pos = stream.start = token.start;\n    for (;;) {\n      var type1 = cm.getMode().token(stream, token.state);\n      if (stream.pos >= pos.ch + 1) return /\\bstring2?\\b/.test(type1);\n      stream.start = stream.pos;\n    }\n  }\n\n  function stringStartsAfter(cm, pos) {\n    var token = cm.getTokenAt(Pos(pos.line, pos.ch + 1))\n    return /\\bstring/.test(token.type) && token.start == pos.ch\n  }\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/edit/closebrackets.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/fold/xml-fold\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  "use strict";\n\n  var Pos = CodeMirror.Pos;\n  function cmp(a, b) { return a.line - b.line || a.ch - b.ch; }\n\n  var nameStartChar = "A-Z_a-z\\\\u00C0-\\\\u00D6\\\\u00D8-\\\\u00F6\\\\u00F8-\\\\u02FF\\\\u0370-\\\\u037D\\\\u037F-\\\\u1FFF\\\\u200C-\\\\u200D\\\\u2070-\\\\u218F\\\\u2C00-\\\\u2FEF\\\\u3001-\\\\uD7FF\\\\uF900-\\\\uFDCF\\\\uFDF0-\\\\uFFFD";\n  var nameChar = nameStartChar + "\\-\\:\\.0-9\\\\u00B7\\\\u0300-\\\\u036F\\\\u203F-\\\\u2040";\n  var xmlTagStart = new RegExp("<(/?)([" + nameStartChar + "][" + nameChar + "]*)", "g");\n\n  function Iter(cm, line, ch, range) {\n    this.line = line; this.ch = ch;\n    this.cm = cm; this.text = cm.getLine(line);\n    this.min = range ? Math.max(range.from, cm.firstLine()) : cm.firstLine();\n    this.max = range ? Math.min(range.to - 1, cm.lastLine()) : cm.lastLine();\n  }\n\n  function tagAt(iter, ch) {\n    var type = iter.cm.getTokenTypeAt(Pos(iter.line, ch));\n    return type && /\\btag\\b/.test(type);\n  }\n\n  function nextLine(iter) {\n    if (iter.line >= iter.max) return;\n    iter.ch = 0;\n    iter.text = iter.cm.getLine(++iter.line);\n    return true;\n  }\n  function prevLine(iter) {\n    if (iter.line <= iter.min) return;\n    iter.text = iter.cm.getLine(--iter.line);\n    iter.ch = iter.text.length;\n    return true;\n  }\n\n  function toTagEnd(iter) {\n    for (;;) {\n      var gt = iter.text.indexOf(">", iter.ch);\n      if (gt == -1) { if (nextLine(iter)) continue; else return; }\n      if (!tagAt(iter, gt + 1)) { iter.ch = gt + 1; continue; }\n      var lastSlash = iter.text.lastIndexOf("/", gt);\n      var selfClose = lastSlash > -1 && !/\\S/.test(iter.text.slice(lastSlash + 1, gt));\n      iter.ch = gt + 1;\n      return selfClose ? "selfClose" : "regular";\n    }\n  }\n  function toTagStart(iter) {\n    for (;;) {\n      var lt = iter.ch ? iter.text.lastIndexOf("<", iter.ch - 1) : -1;\n      if (lt == -1) { if (prevLine(iter)) continue; else return; }\n      if (!tagAt(iter, lt + 1)) { iter.ch = lt; continue; }\n      xmlTagStart.lastIndex = lt;\n      iter.ch = lt;\n      var match = xmlTagStart.exec(iter.text);\n      if (match && match.index == lt) return match;\n    }\n  }\n\n  function toNextTag(iter) {\n    for (;;) {\n      xmlTagStart.lastIndex = iter.ch;\n      var found = xmlTagStart.exec(iter.text);\n      if (!found) { if (nextLine(iter)) continue; else return; }\n      if (!tagAt(iter, found.index + 1)) { iter.ch = found.index + 1; continue; }\n      iter.ch = found.index + found[0].length;\n      return found;\n    }\n  }\n  function toPrevTag(iter) {\n    for (;;) {\n      var gt = iter.ch ? iter.text.lastIndexOf(">", iter.ch - 1) : -1;\n      if (gt == -1) { if (prevLine(iter)) continue; else return; }\n      if (!tagAt(iter, gt + 1)) { iter.ch = gt; continue; }\n      var lastSlash = iter.text.lastIndexOf("/", gt);\n      var selfClose = lastSlash > -1 && !/\\S/.test(iter.text.slice(lastSlash + 1, gt));\n      iter.ch = gt + 1;\n      return selfClose ? "selfClose" : "regular";\n    }\n  }\n\n  function findMatchingClose(iter, tag) {\n    var stack = [];\n    for (;;) {\n      var next = toNextTag(iter), end, startLine = iter.line, startCh = iter.ch - (next ? next[0].length : 0);\n      if (!next || !(end = toTagEnd(iter))) return;\n      if (end == "selfClose") continue;\n      if (next[1]) { // closing tag\n        for (var i = stack.length - 1; i >= 0; --i) if (stack[i] == next[2]) {\n          stack.length = i;\n          break;\n        }\n        if (i < 0 && (!tag || tag == next[2])) return {\n          tag: next[2],\n          from: Pos(startLine, startCh),\n          to: Pos(iter.line, iter.ch)\n        };\n      } else { // opening tag\n        stack.push(next[2]);\n      }\n    }\n  }\n  function findMatchingOpen(iter, tag) {\n    var stack = [];\n    for (;;) {\n      var prev = toPrevTag(iter);\n      if (!prev) return;\n      if (prev == "selfClose") { toTagStart(iter); continue; }\n      var endLine = iter.line, endCh = iter.ch;\n      var start = toTagStart(iter);\n      if (!start) return;\n      if (start[1]) { // closing tag\n        stack.push(start[2]);\n      } else { // opening tag\n        for (var i = stack.length - 1; i >= 0; --i) if (stack[i] == start[2]) {\n          stack.length = i;\n          break;\n        }\n        if (i < 0 && (!tag || tag == start[2])) return {\n          tag: start[2],\n          from: Pos(iter.line, iter.ch),\n          to: Pos(endLine, endCh)\n        };\n      }\n    }\n  }\n\n  CodeMirror.registerHelper("fold", "xml", function(cm, start) {\n    var iter = new Iter(cm, start.line, 0);\n    for (;;) {\n      var openTag = toNextTag(iter), end;\n      if (!openTag || iter.line != start.line || !(end = toTagEnd(iter))) return;\n      if (!openTag[1] && end != "selfClose") {\n        var startPos = Pos(iter.line, iter.ch);\n        var endPos = findMatchingClose(iter, openTag[2]);\n        return endPos && {from: startPos, to: endPos.from};\n      }\n    }\n  });\n  CodeMirror.findMatchingTag = function(cm, pos, range) {\n    var iter = new Iter(cm, pos.line, pos.ch, range);\n    if (iter.text.indexOf(">") == -1 && iter.text.indexOf("<") == -1) return;\n    var end = toTagEnd(iter), to = end && Pos(iter.line, iter.ch);\n    var start = end && toTagStart(iter);\n    if (!end || !start || cmp(iter, pos) > 0) return;\n    var here = {from: Pos(iter.line, iter.ch), to: to, tag: start[2]};\n    if (end == "selfClose") return {open: here, close: null, at: "open"};\n\n    if (start[1]) { // closing tag\n      return {open: findMatchingOpen(iter, start[2]), close: here, at: "close"};\n    } else { // opening tag\n      iter = new Iter(cm, to.line, to.ch, range);\n      return {open: here, close: findMatchingClose(iter, start[2]), at: "open"};\n    }\n  };\n\n  CodeMirror.findEnclosingTag = function(cm, pos, range, tag) {\n    var iter = new Iter(cm, pos.line, pos.ch, range);\n    for (;;) {\n      var open = findMatchingOpen(iter, tag);\n      if (!open) break;\n      var forward = new Iter(cm, pos.line, pos.ch, range);\n      var close = findMatchingClose(forward, open.tag);\n      if (close) return {open: open, close: close};\n    }\n  };\n\n  // Used by addon/edit/closetag.js\n  CodeMirror.scanForClosingTag = function(cm, pos, name, end) {\n    var iter = new Iter(cm, pos.line, pos.ch, end ? {from: 0, to: end} : null);\n    return findMatchingClose(iter, name);\n  };\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/fold/xml-fold.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n/**\n * Tag-closer extension for CodeMirror.\n *\n * This extension adds an "autoCloseTags" option that can be set to\n * either true to get the default behavior, or an object to further\n * configure its behavior.\n *\n * These are supported options:\n *\n * `whenClosing` (default true)\n *   Whether to autoclose when the \'/\' of a closing tag is typed.\n * `whenOpening` (default true)\n *   Whether to autoclose the tag when the final \'>\' of an opening\n *   tag is typed.\n * `dontCloseTags` (default is empty tags for HTML, none for XML)\n *   An array of tag names that should not be autoclosed.\n * `indentTags` (default is block tags for HTML, none for XML)\n *   An array of tag names that should, when opened, cause a\n *   blank line to be added inside the tag, and the blank line and\n *   closing line to be indented.\n *\n * See demos/closetag.html for a usage example.\n */\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"), require("../fold/xml-fold"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/edit/closetag\',["../../lib/codemirror", "../fold/xml-fold"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  CodeMirror.defineOption("autoCloseTags", false, function(cm, val, old) {\n    if (old != CodeMirror.Init && old)\n      cm.removeKeyMap("autoCloseTags");\n    if (!val) return;\n    var map = {name: "autoCloseTags"};\n    if (typeof val != "object" || val.whenClosing)\n      map["\'/\'"] = function(cm) { return autoCloseSlash(cm); };\n    if (typeof val != "object" || val.whenOpening)\n      map["\'>\'"] = function(cm) { return autoCloseGT(cm); };\n    cm.addKeyMap(map);\n  });\n\n  var htmlDontClose = ["area", "base", "br", "col", "command", "embed", "hr", "img", "input", "keygen", "link", "meta", "param",\n                       "source", "track", "wbr"];\n  var htmlIndent = ["applet", "blockquote", "body", "button", "div", "dl", "fieldset", "form", "frameset", "h1", "h2", "h3", "h4",\n                    "h5", "h6", "head", "html", "iframe", "layer", "legend", "object", "ol", "p", "select", "table", "ul"];\n\n  function autoCloseGT(cm) {\n    if (cm.getOption("disableInput")) return CodeMirror.Pass;\n    var ranges = cm.listSelections(), replacements = [];\n    for (var i = 0; i < ranges.length; i++) {\n      if (!ranges[i].empty()) return CodeMirror.Pass;\n      var pos = ranges[i].head, tok = cm.getTokenAt(pos);\n      var inner = CodeMirror.innerMode(cm.getMode(), tok.state), state = inner.state;\n      if (inner.mode.name != "xml" || !state.tagName) return CodeMirror.Pass;\n\n      var opt = cm.getOption("autoCloseTags"), html = inner.mode.configuration == "html";\n      var dontCloseTags = (typeof opt == "object" && opt.dontCloseTags) || (html && htmlDontClose);\n      var indentTags = (typeof opt == "object" && opt.indentTags) || (html && htmlIndent);\n\n      var tagName = state.tagName;\n      if (tok.end > pos.ch) tagName = tagName.slice(0, tagName.length - tok.end + pos.ch);\n      var lowerTagName = tagName.toLowerCase();\n      // Don\'t process the \'>\' at the end of an end-tag or self-closing tag\n      if (!tagName ||\n          tok.type == "string" && (tok.end != pos.ch || !/[\\"\\\']/.test(tok.string.charAt(tok.string.length - 1)) || tok.string.length == 1) ||\n          tok.type == "tag" && state.type == "closeTag" ||\n          tok.string.indexOf("/") == (tok.string.length - 1) || // match something like <someTagName />\n          dontCloseTags && indexOf(dontCloseTags, lowerTagName) > -1 ||\n          closingTagExists(cm, tagName, pos, state, true))\n        return CodeMirror.Pass;\n\n      var indent = indentTags && indexOf(indentTags, lowerTagName) > -1;\n      replacements[i] = {indent: indent,\n                         text: ">" + (indent ? "\\n\\n" : "") + "</" + tagName + ">",\n                         newPos: indent ? CodeMirror.Pos(pos.line + 1, 0) : CodeMirror.Pos(pos.line, pos.ch + 1)};\n    }\n\n    for (var i = ranges.length - 1; i >= 0; i--) {\n      var info = replacements[i];\n      cm.replaceRange(info.text, ranges[i].head, ranges[i].anchor, "+insert");\n      var sel = cm.listSelections().slice(0);\n      sel[i] = {head: info.newPos, anchor: info.newPos};\n      cm.setSelections(sel);\n      if (info.indent) {\n        cm.indentLine(info.newPos.line, null, true);\n        cm.indentLine(info.newPos.line + 1, null, true);\n      }\n    }\n  }\n\n  function autoCloseCurrent(cm, typingSlash) {\n    var ranges = cm.listSelections(), replacements = [];\n    var head = typingSlash ? "/" : "</";\n    for (var i = 0; i < ranges.length; i++) {\n      if (!ranges[i].empty()) return CodeMirror.Pass;\n      var pos = ranges[i].head, tok = cm.getTokenAt(pos);\n      var inner = CodeMirror.innerMode(cm.getMode(), tok.state), state = inner.state;\n      if (typingSlash && (tok.type == "string" || tok.string.charAt(0) != "<" ||\n                          tok.start != pos.ch - 1))\n        return CodeMirror.Pass;\n      // Kludge to get around the fact that we are not in XML mode\n      // when completing in JS/CSS snippet in htmlmixed mode. Does not\n      // work for other XML embedded languages (there is no general\n      // way to go from a mixed mode to its current XML state).\n      var replacement;\n      if (inner.mode.name != "xml") {\n        if (cm.getMode().name == "htmlmixed" && inner.mode.name == "javascript")\n          replacement = head + "script";\n        else if (cm.getMode().name == "htmlmixed" && inner.mode.name == "css")\n          replacement = head + "style";\n        else\n          return CodeMirror.Pass;\n      } else {\n        if (!state.context || !state.context.tagName ||\n            closingTagExists(cm, state.context.tagName, pos, state))\n          return CodeMirror.Pass;\n        replacement = head + state.context.tagName;\n      }\n      if (cm.getLine(pos.line).charAt(tok.end) != ">") replacement += ">";\n      replacements[i] = replacement;\n    }\n    cm.replaceSelections(replacements);\n    ranges = cm.listSelections();\n    for (var i = 0; i < ranges.length; i++)\n      if (i == ranges.length - 1 || ranges[i].head.line < ranges[i + 1].head.line)\n        cm.indentLine(ranges[i].head.line);\n  }\n\n  function autoCloseSlash(cm) {\n    if (cm.getOption("disableInput")) return CodeMirror.Pass;\n    return autoCloseCurrent(cm, true);\n  }\n\n  CodeMirror.commands.closeTag = function(cm) { return autoCloseCurrent(cm); };\n\n  function indexOf(collection, elt) {\n    if (collection.indexOf) return collection.indexOf(elt);\n    for (var i = 0, e = collection.length; i < e; ++i)\n      if (collection[i] == elt) return i;\n    return -1;\n  }\n\n  // If xml-fold is loaded, we use its functionality to try and verify\n  // whether a given tag is actually unclosed.\n  function closingTagExists(cm, tagName, pos, state, newTag) {\n    if (!CodeMirror.scanForClosingTag) return false;\n    var end = Math.min(cm.lastLine() + 1, pos.line + 500);\n    var nextClose = CodeMirror.scanForClosingTag(cm, pos, null, end);\n    if (!nextClose || nextClose.tag != tagName) return false;\n    var cx = state.context;\n    // If the immediate wrapping context contains onCx instances of\n    // the same tag, a closing tag only exists if there are at least\n    // that many closing tags of that type following.\n    for (var onCx = newTag ? 1 : 0; cx && cx.tagName == tagName; cx = cx.prev) ++onCx;\n    pos = nextClose.to;\n    for (var i = 1; i < onCx; i++) {\n      var next = CodeMirror.scanForClosingTag(cm, pos, null, end);\n      if (!next || next.tag != tagName) return false;\n      pos = next.to;\n    }\n    return true;\n  }\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/edit/closetag.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/edit/matchbrackets\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  var ie_lt8 = /MSIE \\d/.test(navigator.userAgent) &&\n    (document.documentMode == null || document.documentMode < 8);\n\n  var Pos = CodeMirror.Pos;\n\n  var matching = {"(": ")>", ")": "(<", "[": "]>", "]": "[<", "{": "}>", "}": "{<"};\n\n  function findMatchingBracket(cm, where, config) {\n    var line = cm.getLineHandle(where.line), pos = where.ch - 1;\n    var afterCursor = config && config.afterCursor\n    if (afterCursor == null)\n      afterCursor = /(^| )cm-fat-cursor($| )/.test(cm.getWrapperElement().className)\n\n    // A cursor is defined as between two characters, but in in vim command mode\n    // (i.e. not insert mode), the cursor is visually represented as a\n    // highlighted box on top of the 2nd character. Otherwise, we allow matches\n    // from before or after the cursor.\n    var match = (!afterCursor && pos >= 0 && matching[line.text.charAt(pos)]) ||\n        matching[line.text.charAt(++pos)];\n    if (!match) return null;\n    var dir = match.charAt(1) == ">" ? 1 : -1;\n    if (config && config.strict && (dir > 0) != (pos == where.ch)) return null;\n    var style = cm.getTokenTypeAt(Pos(where.line, pos + 1));\n\n    var found = scanForBracket(cm, Pos(where.line, pos + (dir > 0 ? 1 : 0)), dir, style || null, config);\n    if (found == null) return null;\n    return {from: Pos(where.line, pos), to: found && found.pos,\n            match: found && found.ch == match.charAt(0), forward: dir > 0};\n  }\n\n  // bracketRegex is used to specify which type of bracket to scan\n  // should be a regexp, e.g. /[[\\]]/\n  //\n  // Note: If "where" is on an open bracket, then this bracket is ignored.\n  //\n  // Returns false when no bracket was found, null when it reached\n  // maxScanLines and gave up\n  function scanForBracket(cm, where, dir, style, config) {\n    var maxScanLen = (config && config.maxScanLineLength) || 10000;\n    var maxScanLines = (config && config.maxScanLines) || 1000;\n\n    var stack = [];\n    var re = config && config.bracketRegex ? config.bracketRegex : /[(){}[\\]]/;\n    var lineEnd = dir > 0 ? Math.min(where.line + maxScanLines, cm.lastLine() + 1)\n                          : Math.max(cm.firstLine() - 1, where.line - maxScanLines);\n    for (var lineNo = where.line; lineNo != lineEnd; lineNo += dir) {\n      var line = cm.getLine(lineNo);\n      if (!line) continue;\n      var pos = dir > 0 ? 0 : line.length - 1, end = dir > 0 ? line.length : -1;\n      if (line.length > maxScanLen) continue;\n      if (lineNo == where.line) pos = where.ch - (dir < 0 ? 1 : 0);\n      for (; pos != end; pos += dir) {\n        var ch = line.charAt(pos);\n        if (re.test(ch) && (style === undefined || cm.getTokenTypeAt(Pos(lineNo, pos + 1)) == style)) {\n          var match = matching[ch];\n          if ((match.charAt(1) == ">") == (dir > 0)) stack.push(ch);\n          else if (!stack.length) return {pos: Pos(lineNo, pos), ch: ch};\n          else stack.pop();\n        }\n      }\n    }\n    return lineNo - dir == (dir > 0 ? cm.lastLine() : cm.firstLine()) ? false : null;\n  }\n\n  function matchBrackets(cm, autoclear, config) {\n    // Disable brace matching in long lines, since it\'ll cause hugely slow updates\n    var maxHighlightLen = cm.state.matchBrackets.maxHighlightLineLength || 1000;\n    var marks = [], ranges = cm.listSelections();\n    for (var i = 0; i < ranges.length; i++) {\n      var match = ranges[i].empty() && findMatchingBracket(cm, ranges[i].head, config);\n      if (match && cm.getLine(match.from.line).length <= maxHighlightLen) {\n        var style = match.match ? "CodeMirror-matchingbracket" : "CodeMirror-nonmatchingbracket";\n        marks.push(cm.markText(match.from, Pos(match.from.line, match.from.ch + 1), {className: style}));\n        if (match.to && cm.getLine(match.to.line).length <= maxHighlightLen)\n          marks.push(cm.markText(match.to, Pos(match.to.line, match.to.ch + 1), {className: style}));\n      }\n    }\n\n    if (marks.length) {\n      // Kludge to work around the IE bug from issue #1193, where text\n      // input stops going to the textare whever this fires.\n      if (ie_lt8 && cm.state.focused) cm.focus();\n\n      var clear = function() {\n        cm.operation(function() {\n          for (var i = 0; i < marks.length; i++) marks[i].clear();\n        });\n      };\n      if (autoclear) setTimeout(clear, 800);\n      else return clear;\n    }\n  }\n\n  var currentlyHighlighted = null;\n  function doMatchBrackets(cm) {\n    cm.operation(function() {\n      if (currentlyHighlighted) {currentlyHighlighted(); currentlyHighlighted = null;}\n      currentlyHighlighted = matchBrackets(cm, false, cm.state.matchBrackets);\n    });\n  }\n\n  CodeMirror.defineOption("matchBrackets", false, function(cm, val, old) {\n    if (old && old != CodeMirror.Init) {\n      cm.off("cursorActivity", doMatchBrackets);\n      if (currentlyHighlighted) {currentlyHighlighted(); currentlyHighlighted = null;}\n    }\n    if (val) {\n      cm.state.matchBrackets = typeof val == "object" ? val : {};\n      cm.on("cursorActivity", doMatchBrackets);\n    }\n  });\n\n  CodeMirror.defineExtension("matchBrackets", function() {matchBrackets(this, true);});\n  CodeMirror.defineExtension("findMatchingBracket", function(pos, config, oldConfig){\n    // Backwards-compatibility kludge\n    if (oldConfig || typeof config == "boolean") {\n      if (!oldConfig) {\n        config = config ? {strict: true} : null\n      } else {\n        oldConfig.strict = config\n        config = oldConfig\n      }\n    }\n    return findMatchingBracket(this, pos, config)\n  });\n  CodeMirror.defineExtension("scanForBracket", function(pos, dir, style, config){\n    return scanForBracket(this, pos, dir, style, config);\n  });\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/edit/matchbrackets.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"), require("../fold/xml-fold"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/edit/matchtags\',["../../lib/codemirror", "../fold/xml-fold"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  "use strict";\n\n  CodeMirror.defineOption("matchTags", false, function(cm, val, old) {\n    if (old && old != CodeMirror.Init) {\n      cm.off("cursorActivity", doMatchTags);\n      cm.off("viewportChange", maybeUpdateMatch);\n      clear(cm);\n    }\n    if (val) {\n      cm.state.matchBothTags = typeof val == "object" && val.bothTags;\n      cm.on("cursorActivity", doMatchTags);\n      cm.on("viewportChange", maybeUpdateMatch);\n      doMatchTags(cm);\n    }\n  });\n\n  function clear(cm) {\n    if (cm.state.tagHit) cm.state.tagHit.clear();\n    if (cm.state.tagOther) cm.state.tagOther.clear();\n    cm.state.tagHit = cm.state.tagOther = null;\n  }\n\n  function doMatchTags(cm) {\n    cm.state.failedTagMatch = false;\n    cm.operation(function() {\n      clear(cm);\n      if (cm.somethingSelected()) return;\n      var cur = cm.getCursor(), range = cm.getViewport();\n      range.from = Math.min(range.from, cur.line); range.to = Math.max(cur.line + 1, range.to);\n      var match = CodeMirror.findMatchingTag(cm, cur, range);\n      if (!match) return;\n      if (cm.state.matchBothTags) {\n        var hit = match.at == "open" ? match.open : match.close;\n        if (hit) cm.state.tagHit = cm.markText(hit.from, hit.to, {className: "CodeMirror-matchingtag"});\n      }\n      var other = match.at == "close" ? match.open : match.close;\n      if (other)\n        cm.state.tagOther = cm.markText(other.from, other.to, {className: "CodeMirror-matchingtag"});\n      else\n        cm.state.failedTagMatch = true;\n    });\n  }\n\n  function maybeUpdateMatch(cm) {\n    if (cm.state.failedTagMatch) doMatchTags(cm);\n  }\n\n  CodeMirror.commands.toMatchingTag = function(cm) {\n    var found = CodeMirror.findMatchingTag(cm, cm.getCursor());\n    if (found) {\n      var other = found.at == "close" ? found.open : found.close;\n      if (other) cm.extendSelection(other.to, other.from);\n    }\n  };\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/edit/matchtags.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/mode/multiplex\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n"use strict";\n\nCodeMirror.multiplexingMode = function(outer /*, others */) {\n  // Others should be {open, close, mode [, delimStyle] [, innerStyle]} objects\n  var others = Array.prototype.slice.call(arguments, 1);\n\n  function indexOf(string, pattern, from, returnEnd) {\n    if (typeof pattern == "string") {\n      var found = string.indexOf(pattern, from);\n      return returnEnd && found > -1 ? found + pattern.length : found;\n    }\n    var m = pattern.exec(from ? string.slice(from) : string);\n    return m ? m.index + from + (returnEnd ? m[0].length : 0) : -1;\n  }\n\n  return {\n    startState: function() {\n      return {\n        outer: CodeMirror.startState(outer),\n        innerActive: null,\n        inner: null\n      };\n    },\n\n    copyState: function(state) {\n      return {\n        outer: CodeMirror.copyState(outer, state.outer),\n        innerActive: state.innerActive,\n        inner: state.innerActive && CodeMirror.copyState(state.innerActive.mode, state.inner)\n      };\n    },\n\n    token: function(stream, state) {\n      if (!state.innerActive) {\n        var cutOff = Infinity, oldContent = stream.string;\n        for (var i = 0; i < others.length; ++i) {\n          var other = others[i];\n          var found = indexOf(oldContent, other.open, stream.pos);\n          if (found == stream.pos) {\n            if (!other.parseDelimiters) stream.match(other.open);\n            state.innerActive = other;\n            state.inner = CodeMirror.startState(other.mode, outer.indent ? outer.indent(state.outer, "") : 0);\n            return other.delimStyle && (other.delimStyle + " " + other.delimStyle + "-open");\n          } else if (found != -1 && found < cutOff) {\n            cutOff = found;\n          }\n        }\n        if (cutOff != Infinity) stream.string = oldContent.slice(0, cutOff);\n        var outerToken = outer.token(stream, state.outer);\n        if (cutOff != Infinity) stream.string = oldContent;\n        return outerToken;\n      } else {\n        var curInner = state.innerActive, oldContent = stream.string;\n        if (!curInner.close && stream.sol()) {\n          state.innerActive = state.inner = null;\n          return this.token(stream, state);\n        }\n        var found = curInner.close ? indexOf(oldContent, curInner.close, stream.pos, curInner.parseDelimiters) : -1;\n        if (found == stream.pos && !curInner.parseDelimiters) {\n          stream.match(curInner.close);\n          state.innerActive = state.inner = null;\n          return curInner.delimStyle && (curInner.delimStyle + " " + curInner.delimStyle + "-close");\n        }\n        if (found > -1) stream.string = oldContent.slice(0, found);\n        var innerToken = curInner.mode.token(stream, state.inner);\n        if (found > -1) stream.string = oldContent;\n\n        if (found == stream.pos && curInner.parseDelimiters)\n          state.innerActive = state.inner = null;\n\n        if (curInner.innerStyle) {\n          if (innerToken) innerToken = innerToken + " " + curInner.innerStyle;\n          else innerToken = curInner.innerStyle;\n        }\n\n        return innerToken;\n      }\n    },\n\n    indent: function(state, textAfter) {\n      var mode = state.innerActive ? state.innerActive.mode : outer;\n      if (!mode.indent) return CodeMirror.Pass;\n      return mode.indent(state.innerActive ? state.inner : state.outer, textAfter);\n    },\n\n    blankLine: function(state) {\n      var mode = state.innerActive ? state.innerActive.mode : outer;\n      if (mode.blankLine) {\n        mode.blankLine(state.innerActive ? state.inner : state.outer);\n      }\n      if (!state.innerActive) {\n        for (var i = 0; i < others.length; ++i) {\n          var other = others[i];\n          if (other.open === "\\n") {\n            state.innerActive = other;\n            state.inner = CodeMirror.startState(other.mode, mode.indent ? mode.indent(state.outer, "") : 0);\n          }\n        }\n      } else if (state.innerActive.close === "\\n") {\n        state.innerActive = state.inner = null;\n      }\n    },\n\n    electricChars: outer.electricChars,\n\n    innerMode: function(state) {\n      return state.inner ? {state: state.inner, mode: state.innerActive.mode} : {state: state.outer, mode: outer};\n    }\n  };\n};\n\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/mode/multiplex.js'),
eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n// Utility function that allows modes to be combined. The mode given\n// as the base argument takes care of most of the normal mode\n// functionality, but a second (typically simple) mode is used, which\n// can override the style of text. Both modes get to parse all of the\n// text, but when both assign a non-null style to a piece of code, the\n// overlay wins, unless the combine argument was true and not overridden,\n// or state.overlay.combineTokens was true, in which case the styles are\n// combined.\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/mode/overlay\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n"use strict";\n\nCodeMirror.overlayMode = function(base, overlay, combine) {\n  return {\n    startState: function() {\n      return {\n        base: CodeMirror.startState(base),\n        overlay: CodeMirror.startState(overlay),\n        basePos: 0, baseCur: null,\n        overlayPos: 0, overlayCur: null,\n        streamSeen: null\n      };\n    },\n    copyState: function(state) {\n      return {\n        base: CodeMirror.copyState(base, state.base),\n        overlay: CodeMirror.copyState(overlay, state.overlay),\n        basePos: state.basePos, baseCur: null,\n        overlayPos: state.overlayPos, overlayCur: null\n      };\n    },\n\n    token: function(stream, state) {\n      if (stream != state.streamSeen ||\n          Math.min(state.basePos, state.overlayPos) < stream.start) {\n        state.streamSeen = stream;\n        state.basePos = state.overlayPos = stream.start;\n      }\n\n      if (stream.start == state.basePos) {\n        state.baseCur = base.token(stream, state.base);\n        state.basePos = stream.pos;\n      }\n      if (stream.start == state.overlayPos) {\n        stream.pos = stream.start;\n        state.overlayCur = overlay.token(stream, state.overlay);\n        state.overlayPos = stream.pos;\n      }\n      stream.pos = Math.min(state.basePos, state.overlayPos);\n\n      // state.overlay.combineTokens always takes precedence over combine,\n      // unless set to null\n      if (state.overlayCur == null) return state.baseCur;\n      else if (state.baseCur != null &&\n               state.overlay.combineTokens ||\n               combine && state.overlay.combineTokens == null)\n        return state.baseCur + " " + state.overlayCur;\n      else return state.overlayCur;\n    },\n\n    indent: base.indent && function(state, textAfter) {\n      return base.indent(state.base, textAfter);\n    },\n    electricChars: base.electricChars,\n\n    innerMode: function(state) { return {state: state.base, mode: base}; },\n\n    blankLine: function(state) {\n      var baseToken, overlayToken;\n      if (base.blankLine) baseToken = base.blankLine(state.base);\n      if (overlay.blankLine) overlayToken = overlay.blankLine(state.overlay);\n\n      return overlayToken == null ?\n        baseToken :\n        (combine && baseToken != null ? baseToken + " " + overlayToken : overlayToken);\n    }\n  };\n};\n\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/mode/overlay.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/mode/simple\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  "use strict";\n\n  CodeMirror.defineSimpleMode = function(name, states) {\n    CodeMirror.defineMode(name, function(config) {\n      return CodeMirror.simpleMode(config, states);\n    });\n  };\n\n  CodeMirror.simpleMode = function(config, states) {\n    ensureState(states, "start");\n    var states_ = {}, meta = states.meta || {}, hasIndentation = false;\n    for (var state in states) if (state != meta && states.hasOwnProperty(state)) {\n      var list = states_[state] = [], orig = states[state];\n      for (var i = 0; i < orig.length; i++) {\n        var data = orig[i];\n        list.push(new Rule(data, states));\n        if (data.indent || data.dedent) hasIndentation = true;\n      }\n    }\n    var mode = {\n      startState: function() {\n        return {state: "start", pending: null,\n                local: null, localState: null,\n                indent: hasIndentation ? [] : null};\n      },\n      copyState: function(state) {\n        var s = {state: state.state, pending: state.pending,\n                 local: state.local, localState: null,\n                 indent: state.indent && state.indent.slice(0)};\n        if (state.localState)\n          s.localState = CodeMirror.copyState(state.local.mode, state.localState);\n        if (state.stack)\n          s.stack = state.stack.slice(0);\n        for (var pers = state.persistentStates; pers; pers = pers.next)\n          s.persistentStates = {mode: pers.mode,\n                                spec: pers.spec,\n                                state: pers.state == state.localState ? s.localState : CodeMirror.copyState(pers.mode, pers.state),\n                                next: s.persistentStates};\n        return s;\n      },\n      token: tokenFunction(states_, config),\n      innerMode: function(state) { return state.local && {mode: state.local.mode, state: state.localState}; },\n      indent: indentFunction(states_, meta)\n    };\n    if (meta) for (var prop in meta) if (meta.hasOwnProperty(prop))\n      mode[prop] = meta[prop];\n    return mode;\n  };\n\n  function ensureState(states, name) {\n    if (!states.hasOwnProperty(name))\n      throw new Error("Undefined state " + name + " in simple mode");\n  }\n\n  function toRegex(val, caret) {\n    if (!val) return /(?:)/;\n    var flags = "";\n    if (val instanceof RegExp) {\n      if (val.ignoreCase) flags = "i";\n      val = val.source;\n    } else {\n      val = String(val);\n    }\n    return new RegExp((caret === false ? "" : "^") + "(?:" + val + ")", flags);\n  }\n\n  function asToken(val) {\n    if (!val) return null;\n    if (val.apply) return val\n    if (typeof val == "string") return val.replace(/\\./g, " ");\n    var result = [];\n    for (var i = 0; i < val.length; i++)\n      result.push(val[i] && val[i].replace(/\\./g, " "));\n    return result;\n  }\n\n  function Rule(data, states) {\n    if (data.next || data.push) ensureState(states, data.next || data.push);\n    this.regex = toRegex(data.regex);\n    this.token = asToken(data.token);\n    this.data = data;\n  }\n\n  function tokenFunction(states, config) {\n    return function(stream, state) {\n      if (state.pending) {\n        var pend = state.pending.shift();\n        if (state.pending.length == 0) state.pending = null;\n        stream.pos += pend.text.length;\n        return pend.token;\n      }\n\n      if (state.local) {\n        if (state.local.end && stream.match(state.local.end)) {\n          var tok = state.local.endToken || null;\n          state.local = state.localState = null;\n          return tok;\n        } else {\n          var tok = state.local.mode.token(stream, state.localState), m;\n          if (state.local.endScan && (m = state.local.endScan.exec(stream.current())))\n            stream.pos = stream.start + m.index;\n          return tok;\n        }\n      }\n\n      var curState = states[state.state];\n      for (var i = 0; i < curState.length; i++) {\n        var rule = curState[i];\n        var matches = (!rule.data.sol || stream.sol()) && stream.match(rule.regex);\n        if (matches) {\n          if (rule.data.next) {\n            state.state = rule.data.next;\n          } else if (rule.data.push) {\n            (state.stack || (state.stack = [])).push(state.state);\n            state.state = rule.data.push;\n          } else if (rule.data.pop && state.stack && state.stack.length) {\n            state.state = state.stack.pop();\n          }\n\n          if (rule.data.mode)\n            enterLocalMode(config, state, rule.data.mode, rule.token);\n          if (rule.data.indent)\n            state.indent.push(stream.indentation() + config.indentUnit);\n          if (rule.data.dedent)\n            state.indent.pop();\n          var token = rule.token\n          if (token && token.apply) token = token(matches)\n          if (matches.length > 2) {\n            state.pending = [];\n            for (var j = 2; j < matches.length; j++)\n              if (matches[j])\n                state.pending.push({text: matches[j], token: rule.token[j - 1]});\n            stream.backUp(matches[0].length - (matches[1] ? matches[1].length : 0));\n            return token[0];\n          } else if (token && token.join) {\n            return token[0];\n          } else {\n            return token;\n          }\n        }\n      }\n      stream.next();\n      return null;\n    };\n  }\n\n  function cmp(a, b) {\n    if (a === b) return true;\n    if (!a || typeof a != "object" || !b || typeof b != "object") return false;\n    var props = 0;\n    for (var prop in a) if (a.hasOwnProperty(prop)) {\n      if (!b.hasOwnProperty(prop) || !cmp(a[prop], b[prop])) return false;\n      props++;\n    }\n    for (var prop in b) if (b.hasOwnProperty(prop)) props--;\n    return props == 0;\n  }\n\n  function enterLocalMode(config, state, spec, token) {\n    var pers;\n    if (spec.persistent) for (var p = state.persistentStates; p && !pers; p = p.next)\n      if (spec.spec ? cmp(spec.spec, p.spec) : spec.mode == p.mode) pers = p;\n    var mode = pers ? pers.mode : spec.mode || CodeMirror.getMode(config, spec.spec);\n    var lState = pers ? pers.state : CodeMirror.startState(mode);\n    if (spec.persistent && !pers)\n      state.persistentStates = {mode: mode, spec: spec.spec, state: lState, next: state.persistentStates};\n\n    state.localState = lState;\n    state.local = {mode: mode,\n                   end: spec.end && toRegex(spec.end),\n                   endScan: spec.end && spec.forceEnd !== false && toRegex(spec.end, false),\n                   endToken: token && token.join ? token[token.length - 1] : token};\n  }\n\n  function indexOf(val, arr) {\n    for (var i = 0; i < arr.length; i++) if (arr[i] === val) return true;\n  }\n\n  function indentFunction(states, meta) {\n    return function(state, textAfter, line) {\n      if (state.local && state.local.mode.indent)\n        return state.local.mode.indent(state.localState, textAfter, line);\n      if (state.indent == null || state.local || meta.dontIndentStates && indexOf(state.state, meta.dontIndentStates) > -1)\n        return CodeMirror.Pass;\n\n      var pos = state.indent.length - 1, rules = states[state.state];\n      scan: for (;;) {\n        for (var i = 0; i < rules.length; i++) {\n          var rule = rules[i];\n          if (rule.data.dedent && rule.data.dedentIfLineStart !== false) {\n            var m = rule.regex.exec(textAfter);\n            if (m && m[0]) {\n              pos--;\n              if (rule.next || rule.push) rules = states[rule.next || rule.push];\n              textAfter = textAfter.slice(m[0].length);\n              continue scan;\n            }\n          }\n        }\n        break;\n      }\n      return pos < 0 ? 0 : state.indent[pos];\n    };\n  }\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/mode/simple.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/scroll/scrollpastend\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  "use strict";\n\n  CodeMirror.defineOption("scrollPastEnd", false, function(cm, val, old) {\n    if (old && old != CodeMirror.Init) {\n      cm.off("change", onChange);\n      cm.off("refresh", updateBottomMargin);\n      cm.display.lineSpace.parentNode.style.paddingBottom = "";\n      cm.state.scrollPastEndPadding = null;\n    }\n    if (val) {\n      cm.on("change", onChange);\n      cm.on("refresh", updateBottomMargin);\n      updateBottomMargin(cm);\n    }\n  });\n\n  function onChange(cm, change) {\n    if (CodeMirror.changeEnd(change).line == cm.lastLine())\n      updateBottomMargin(cm);\n  }\n\n  function updateBottomMargin(cm) {\n    var padding = "";\n    if (cm.lineCount() > 1) {\n      var totalH = cm.display.scroller.clientHeight - 30,\n          lastLineH = cm.getLineHandle(cm.lastLine()).height;\n      padding = (totalH - lastLineH) + "px";\n    }\n    if (cm.state.scrollPastEndPadding != padding) {\n      cm.state.scrollPastEndPadding = padding;\n      cm.display.lineSpace.parentNode.style.paddingBottom = padding;\n      cm.off("refresh", updateBottomMargin);\n      cm.setSize();\n      cm.on("refresh", updateBottomMargin);\n    }\n  }\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/scroll/scrollpastend.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"))\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/search/searchcursor\',["../../lib/codemirror"], mod)\n  else // Plain browser env\n    mod(CodeMirror)\n})(function(CodeMirror) {\n  "use strict"\n  var Pos = CodeMirror.Pos\n\n  function regexpFlags(regexp) {\n    var flags = regexp.flags\n    return flags != null ? flags : (regexp.ignoreCase ? "i" : "")\n      + (regexp.global ? "g" : "")\n      + (regexp.multiline ? "m" : "")\n  }\n\n  function ensureGlobal(regexp) {\n    return regexp.global ? regexp : new RegExp(regexp.source, regexpFlags(regexp) + "g")\n  }\n\n  function maybeMultiline(regexp) {\n    return /\\\\s|\\\\n|\\n|\\\\W|\\\\D|\\[\\^/.test(regexp.source)\n  }\n\n  function searchRegexpForward(doc, regexp, start) {\n    regexp = ensureGlobal(regexp)\n    for (var line = start.line, ch = start.ch, last = doc.lastLine(); line <= last; line++, ch = 0) {\n      regexp.lastIndex = ch\n      var string = doc.getLine(line), match = regexp.exec(string)\n      if (match)\n        return {from: Pos(line, match.index),\n                to: Pos(line, match.index + match[0].length),\n                match: match}\n    }\n  }\n\n  function searchRegexpForwardMultiline(doc, regexp, start) {\n    if (!maybeMultiline(regexp)) return searchRegexpForward(doc, regexp, start)\n\n    regexp = ensureGlobal(regexp)\n    var string, chunk = 1\n    for (var line = start.line, last = doc.lastLine(); line <= last;) {\n      // This grows the search buffer in exponentially-sized chunks\n      // between matches, so that nearby matches are fast and don\'t\n      // require concatenating the whole document (in case we\'re\n      // searching for something that has tons of matches), but at the\n      // same time, the amount of retries is limited.\n      for (var i = 0; i < chunk; i++) {\n        var curLine = doc.getLine(line++)\n        string = string == null ? curLine : string + "\\n" + curLine\n      }\n      chunk = chunk * 2\n      regexp.lastIndex = start.ch\n      var match = regexp.exec(string)\n      if (match) {\n        var before = string.slice(0, match.index).split("\\n"), inside = match[0].split("\\n")\n        var startLine = start.line + before.length - 1, startCh = before[before.length - 1].length\n        return {from: Pos(startLine, startCh),\n                to: Pos(startLine + inside.length - 1,\n                        inside.length == 1 ? startCh + inside[0].length : inside[inside.length - 1].length),\n                match: match}\n      }\n    }\n  }\n\n  function lastMatchIn(string, regexp) {\n    var cutOff = 0, match\n    for (;;) {\n      regexp.lastIndex = cutOff\n      var newMatch = regexp.exec(string)\n      if (!newMatch) return match\n      match = newMatch\n      cutOff = match.index + (match[0].length || 1)\n      if (cutOff == string.length) return match\n    }\n  }\n\n  function searchRegexpBackward(doc, regexp, start) {\n    regexp = ensureGlobal(regexp)\n    for (var line = start.line, ch = start.ch, first = doc.firstLine(); line >= first; line--, ch = -1) {\n      var string = doc.getLine(line)\n      if (ch > -1) string = string.slice(0, ch)\n      var match = lastMatchIn(string, regexp)\n      if (match)\n        return {from: Pos(line, match.index),\n                to: Pos(line, match.index + match[0].length),\n                match: match}\n    }\n  }\n\n  function searchRegexpBackwardMultiline(doc, regexp, start) {\n    regexp = ensureGlobal(regexp)\n    var string, chunk = 1\n    for (var line = start.line, first = doc.firstLine(); line >= first;) {\n      for (var i = 0; i < chunk; i++) {\n        var curLine = doc.getLine(line--)\n        string = string == null ? curLine.slice(0, start.ch) : curLine + "\\n" + string\n      }\n      chunk *= 2\n\n      var match = lastMatchIn(string, regexp)\n      if (match) {\n        var before = string.slice(0, match.index).split("\\n"), inside = match[0].split("\\n")\n        var startLine = line + before.length, startCh = before[before.length - 1].length\n        return {from: Pos(startLine, startCh),\n                to: Pos(startLine + inside.length - 1,\n                        inside.length == 1 ? startCh + inside[0].length : inside[inside.length - 1].length),\n                match: match}\n      }\n    }\n  }\n\n  var doFold, noFold\n  if (String.prototype.normalize) {\n    doFold = function(str) { return str.normalize("NFD").toLowerCase() }\n    noFold = function(str) { return str.normalize("NFD") }\n  } else {\n    doFold = function(str) { return str.toLowerCase() }\n    noFold = function(str) { return str }\n  }\n\n  // Maps a position in a case-folded line back to a position in the original line\n  // (compensating for codepoints increasing in number during folding)\n  function adjustPos(orig, folded, pos, foldFunc) {\n    if (orig.length == folded.length) return pos\n    for (var min = 0, max = pos + Math.max(0, orig.length - folded.length);;) {\n      if (min == max) return min\n      var mid = (min + max) >> 1\n      var len = foldFunc(orig.slice(0, mid)).length\n      if (len == pos) return mid\n      else if (len > pos) max = mid\n      else min = mid + 1\n    }\n  }\n\n  function searchStringForward(doc, query, start, caseFold) {\n    // Empty string would match anything and never progress, so we\n    // define it to match nothing instead.\n    if (!query.length) return null\n    var fold = caseFold ? doFold : noFold\n    var lines = fold(query).split(/\\r|\\n\\r?/)\n\n    search: for (var line = start.line, ch = start.ch, last = doc.lastLine() + 1 - lines.length; line <= last; line++, ch = 0) {\n      var orig = doc.getLine(line).slice(ch), string = fold(orig)\n      if (lines.length == 1) {\n        var found = string.indexOf(lines[0])\n        if (found == -1) continue search\n        var start = adjustPos(orig, string, found, fold) + ch\n        return {from: Pos(line, adjustPos(orig, string, found, fold) + ch),\n                to: Pos(line, adjustPos(orig, string, found + lines[0].length, fold) + ch)}\n      } else {\n        var cutFrom = string.length - lines[0].length\n        if (string.slice(cutFrom) != lines[0]) continue search\n        for (var i = 1; i < lines.length - 1; i++)\n          if (fold(doc.getLine(line + i)) != lines[i]) continue search\n        var end = doc.getLine(line + lines.length - 1), endString = fold(end), lastLine = lines[lines.length - 1]\n        if (end.slice(0, lastLine.length) != lastLine) continue search\n        return {from: Pos(line, adjustPos(orig, string, cutFrom, fold) + ch),\n                to: Pos(line + lines.length - 1, adjustPos(end, endString, lastLine.length, fold))}\n      }\n    }\n  }\n\n  function searchStringBackward(doc, query, start, caseFold) {\n    if (!query.length) return null\n    var fold = caseFold ? doFold : noFold\n    var lines = fold(query).split(/\\r|\\n\\r?/)\n\n    search: for (var line = start.line, ch = start.ch, first = doc.firstLine() - 1 + lines.length; line >= first; line--, ch = -1) {\n      var orig = doc.getLine(line)\n      if (ch > -1) orig = orig.slice(0, ch)\n      var string = fold(orig)\n      if (lines.length == 1) {\n        var found = string.lastIndexOf(lines[0])\n        if (found == -1) continue search\n        return {from: Pos(line, adjustPos(orig, string, found, fold)),\n                to: Pos(line, adjustPos(orig, string, found + lines[0].length, fold))}\n      } else {\n        var lastLine = lines[lines.length - 1]\n        if (string.slice(0, lastLine.length) != lastLine) continue search\n        for (var i = 1, start = line - lines.length + 1; i < lines.length - 1; i++)\n          if (fold(doc.getLine(start + i)) != lines[i]) continue search\n        var top = doc.getLine(line + 1 - lines.length), topString = fold(top)\n        if (topString.slice(topString.length - lines[0].length) != lines[0]) continue search\n        return {from: Pos(line + 1 - lines.length, adjustPos(top, topString, top.length - lines[0].length, fold)),\n                to: Pos(line, adjustPos(orig, string, lastLine.length, fold))}\n      }\n    }\n  }\n\n  function SearchCursor(doc, query, pos, options) {\n    this.atOccurrence = false\n    this.doc = doc\n    pos = pos ? doc.clipPos(pos) : Pos(0, 0)\n    this.pos = {from: pos, to: pos}\n\n    var caseFold\n    if (typeof options == "object") {\n      caseFold = options.caseFold\n    } else { // Backwards compat for when caseFold was the 4th argument\n      caseFold = options\n      options = null\n    }\n\n    if (typeof query == "string") {\n      if (caseFold == null) caseFold = false\n      this.matches = function(reverse, pos) {\n        return (reverse ? searchStringBackward : searchStringForward)(doc, query, pos, caseFold)\n      }\n    } else {\n      query = ensureGlobal(query)\n      if (!options || options.multiline !== false)\n        this.matches = function(reverse, pos) {\n          return (reverse ? searchRegexpBackwardMultiline : searchRegexpForwardMultiline)(doc, query, pos)\n        }\n      else\n        this.matches = function(reverse, pos) {\n          return (reverse ? searchRegexpBackward : searchRegexpForward)(doc, query, pos)\n        }\n    }\n  }\n\n  SearchCursor.prototype = {\n    findNext: function() {return this.find(false)},\n    findPrevious: function() {return this.find(true)},\n\n    find: function(reverse) {\n      var result = this.matches(reverse, this.doc.clipPos(reverse ? this.pos.from : this.pos.to))\n\n      // Implements weird auto-growing behavior on null-matches for\n      // backwards-compatiblity with the vim code (unfortunately)\n      while (result && CodeMirror.cmpPos(result.from, result.to) == 0) {\n        if (reverse) {\n          if (result.from.ch) result.from = Pos(result.from.line, result.from.ch - 1)\n          else if (result.from.line == this.doc.firstLine()) result = null\n          else result = this.matches(reverse, this.doc.clipPos(Pos(result.from.line - 1)))\n        } else {\n          if (result.to.ch < this.doc.getLine(result.to.line).length) result.to = Pos(result.to.line, result.to.ch + 1)\n          else if (result.to.line == this.doc.lastLine()) result = null\n          else result = this.matches(reverse, Pos(result.to.line + 1, 0))\n        }\n      }\n\n      if (result) {\n        this.pos = result\n        this.atOccurrence = true\n        return this.pos.match || true\n      } else {\n        var end = Pos(reverse ? this.doc.firstLine() : this.doc.lastLine() + 1, 0)\n        this.pos = {from: end, to: end}\n        return this.atOccurrence = false\n      }\n    },\n\n    from: function() {if (this.atOccurrence) return this.pos.from},\n    to: function() {if (this.atOccurrence) return this.pos.to},\n\n    replace: function(newText, origin) {\n      if (!this.atOccurrence) return\n      var lines = CodeMirror.splitLines(newText)\n      this.doc.replaceRange(lines, this.pos.from, this.pos.to, origin)\n      this.pos.to = Pos(this.pos.from.line + lines.length - 1,\n                        lines[lines.length - 1].length + (lines.length == 1 ? this.pos.from.ch : 0))\n    }\n  }\n\n  CodeMirror.defineExtension("getSearchCursor", function(query, pos, caseFold) {\n    return new SearchCursor(this.doc, query, pos, caseFold)\n  })\n  CodeMirror.defineDocExtension("getSearchCursor", function(query, pos, caseFold) {\n    return new SearchCursor(this, query, pos, caseFold)\n  })\n\n  CodeMirror.defineExtension("selectMatches", function(query, caseFold) {\n    var ranges = []\n    var cur = this.getSearchCursor(query, this.getCursor("from"), caseFold)\n    while (cur.findNext()) {\n      if (CodeMirror.cmpPos(cur.to(), this.getCursor("to")) > 0) break\n      ranges.push({anchor: cur.from(), head: cur.to()})\n    }\n    if (ranges.length)\n      this.setSelections(ranges, 0)\n  })\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/search/searchcursor.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/scroll/annotatescrollbar\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  "use strict";\n\n  CodeMirror.defineExtension("annotateScrollbar", function(options) {\n    if (typeof options == "string") options = {className: options};\n    return new Annotation(this, options);\n  });\n\n  CodeMirror.defineOption("scrollButtonHeight", 0);\n\n  function Annotation(cm, options) {\n    this.cm = cm;\n    this.options = options;\n    this.buttonHeight = options.scrollButtonHeight || cm.getOption("scrollButtonHeight");\n    this.annotations = [];\n    this.doRedraw = this.doUpdate = null;\n    this.div = cm.getWrapperElement().appendChild(document.createElement("div"));\n    this.div.style.cssText = "position: absolute; right: 0; top: 0; z-index: 7; pointer-events: none";\n    this.computeScale();\n\n    function scheduleRedraw(delay) {\n      clearTimeout(self.doRedraw);\n      self.doRedraw = setTimeout(function() { self.redraw(); }, delay);\n    }\n\n    var self = this;\n    cm.on("refresh", this.resizeHandler = function() {\n      clearTimeout(self.doUpdate);\n      self.doUpdate = setTimeout(function() {\n        if (self.computeScale()) scheduleRedraw(20);\n      }, 100);\n    });\n    cm.on("markerAdded", this.resizeHandler);\n    cm.on("markerCleared", this.resizeHandler);\n    if (options.listenForChanges !== false)\n      cm.on("change", this.changeHandler = function() {\n        scheduleRedraw(250);\n      });\n  }\n\n  Annotation.prototype.computeScale = function() {\n    var cm = this.cm;\n    var hScale = (cm.getWrapperElement().clientHeight - cm.display.barHeight - this.buttonHeight * 2) /\n      cm.getScrollerElement().scrollHeight\n    if (hScale != this.hScale) {\n      this.hScale = hScale;\n      return true;\n    }\n  };\n\n  Annotation.prototype.update = function(annotations) {\n    this.annotations = annotations;\n    this.redraw();\n  };\n\n  Annotation.prototype.redraw = function(compute) {\n    if (compute !== false) this.computeScale();\n    var cm = this.cm, hScale = this.hScale;\n\n    var frag = document.createDocumentFragment(), anns = this.annotations;\n\n    var wrapping = cm.getOption("lineWrapping");\n    var singleLineH = wrapping && cm.defaultTextHeight() * 1.5;\n    var curLine = null, curLineObj = null;\n    function getY(pos, top) {\n      if (curLine != pos.line) {\n        curLine = pos.line;\n        curLineObj = cm.getLineHandle(curLine);\n      }\n      if ((curLineObj.widgets && curLineObj.widgets.length) ||\n          (wrapping && curLineObj.height > singleLineH))\n        return cm.charCoords(pos, "local")[top ? "top" : "bottom"];\n      var topY = cm.heightAtLine(curLineObj, "local");\n      return topY + (top ? 0 : curLineObj.height);\n    }\n\n    var lastLine = cm.lastLine()\n    if (cm.display.barWidth) for (var i = 0, nextTop; i < anns.length; i++) {\n      var ann = anns[i];\n      if (ann.to.line > lastLine) continue;\n      var top = nextTop || getY(ann.from, true) * hScale;\n      var bottom = getY(ann.to, false) * hScale;\n      while (i < anns.length - 1) {\n        if (anns[i + 1].to.line > lastLine) break;\n        nextTop = getY(anns[i + 1].from, true) * hScale;\n        if (nextTop > bottom + .9) break;\n        ann = anns[++i];\n        bottom = getY(ann.to, false) * hScale;\n      }\n      if (bottom == top) continue;\n      var height = Math.max(bottom - top, 3);\n\n      var elt = frag.appendChild(document.createElement("div"));\n      elt.style.cssText = "position: absolute; right: 0px; width: " + Math.max(cm.display.barWidth - 1, 2) + "px; top: "\n        + (top + this.buttonHeight) + "px; height: " + height + "px";\n      elt.className = this.options.className;\n      if (ann.id) {\n        elt.setAttribute("annotation-id", ann.id);\n      }\n    }\n    this.div.textContent = "";\n    this.div.appendChild(frag);\n  };\n\n  Annotation.prototype.clear = function() {\n    this.cm.off("refresh", this.resizeHandler);\n    this.cm.off("markerAdded", this.resizeHandler);\n    this.cm.off("markerCleared", this.resizeHandler);\n    if (this.changeHandler) this.cm.off("change", this.changeHandler);\n    this.div.parentNode.removeChild(this.div);\n  };\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/scroll/annotatescrollbar.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"), require("./searchcursor"), require("../scroll/annotatescrollbar"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/search/matchesonscrollbar\',["../../lib/codemirror", "./searchcursor", "../scroll/annotatescrollbar"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  "use strict";\n\n  CodeMirror.defineExtension("showMatchesOnScrollbar", function(query, caseFold, options) {\n    if (typeof options == "string") options = {className: options};\n    if (!options) options = {};\n    return new SearchAnnotation(this, query, caseFold, options);\n  });\n\n  function SearchAnnotation(cm, query, caseFold, options) {\n    this.cm = cm;\n    this.options = options;\n    var annotateOptions = {listenForChanges: false};\n    for (var prop in options) annotateOptions[prop] = options[prop];\n    if (!annotateOptions.className) annotateOptions.className = "CodeMirror-search-match";\n    this.annotation = cm.annotateScrollbar(annotateOptions);\n    this.query = query;\n    this.caseFold = caseFold;\n    this.gap = {from: cm.firstLine(), to: cm.lastLine() + 1};\n    this.matches = [];\n    this.update = null;\n\n    this.findMatches();\n    this.annotation.update(this.matches);\n\n    var self = this;\n    cm.on("change", this.changeHandler = function(_cm, change) { self.onChange(change); });\n  }\n\n  var MAX_MATCHES = 1000;\n\n  SearchAnnotation.prototype.findMatches = function() {\n    if (!this.gap) return;\n    for (var i = 0; i < this.matches.length; i++) {\n      var match = this.matches[i];\n      if (match.from.line >= this.gap.to) break;\n      if (match.to.line >= this.gap.from) this.matches.splice(i--, 1);\n    }\n    var cursor = this.cm.getSearchCursor(this.query, CodeMirror.Pos(this.gap.from, 0), this.caseFold);\n    var maxMatches = this.options && this.options.maxMatches || MAX_MATCHES;\n    while (cursor.findNext()) {\n      var match = {from: cursor.from(), to: cursor.to()};\n      if (match.from.line >= this.gap.to) break;\n      this.matches.splice(i++, 0, match);\n      if (this.matches.length > maxMatches) break;\n    }\n    this.gap = null;\n  };\n\n  function offsetLine(line, changeStart, sizeChange) {\n    if (line <= changeStart) return line;\n    return Math.max(changeStart, line + sizeChange);\n  }\n\n  SearchAnnotation.prototype.onChange = function(change) {\n    var startLine = change.from.line;\n    var endLine = CodeMirror.changeEnd(change).line;\n    var sizeChange = endLine - change.to.line;\n    if (this.gap) {\n      this.gap.from = Math.min(offsetLine(this.gap.from, startLine, sizeChange), change.from.line);\n      this.gap.to = Math.max(offsetLine(this.gap.to, startLine, sizeChange), change.from.line);\n    } else {\n      this.gap = {from: change.from.line, to: endLine + 1};\n    }\n\n    if (sizeChange) for (var i = 0; i < this.matches.length; i++) {\n      var match = this.matches[i];\n      var newFrom = offsetLine(match.from.line, startLine, sizeChange);\n      if (newFrom != match.from.line) match.from = CodeMirror.Pos(newFrom, match.from.ch);\n      var newTo = offsetLine(match.to.line, startLine, sizeChange);\n      if (newTo != match.to.line) match.to = CodeMirror.Pos(newTo, match.to.ch);\n    }\n    clearTimeout(this.update);\n    var self = this;\n    this.update = setTimeout(function() { self.updateAfterChange(); }, 250);\n  };\n\n  SearchAnnotation.prototype.updateAfterChange = function() {\n    this.findMatches();\n    this.annotation.update(this.matches);\n  };\n\n  SearchAnnotation.prototype.clear = function() {\n    this.cm.off("change", this.changeHandler);\n    this.annotation.clear();\n  };\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/search/matchesonscrollbar.js'),
eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n// Highlighting text that matches the selection\n//\n// Defines an option highlightSelectionMatches, which, when enabled,\n// will style strings that match the selection throughout the\n// document.\n//\n// The option can be set to true to simply enable it, or to a\n// {minChars, style, wordsOnly, showToken, delay} object to explicitly\n// configure it. minChars is the minimum amount of characters that should be\n// selected for the behavior to occur, and style is the token style to\n// apply to the matches. This will be prefixed by "cm-" to create an\n// actual CSS class name. If wordsOnly is enabled, the matches will be\n// highlighted only if the selected text is a word. showToken, when enabled,\n// will cause the current token to be highlighted when nothing is selected.\n// delay is used to specify how much time to wait, in milliseconds, before\n// highlighting the matches. If annotateScrollbar is enabled, the occurences\n// will be highlighted on the scrollbar via the matchesonscrollbar addon.\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"), require("./matchesonscrollbar"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/search/match-highlighter\',["../../lib/codemirror", "./matchesonscrollbar"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  "use strict";\n\n  var defaults = {\n    style: "matchhighlight",\n    minChars: 2,\n    delay: 100,\n    wordsOnly: false,\n    annotateScrollbar: false,\n    showToken: false,\n    trim: true\n  }\n\n  function State(options) {\n    this.options = {}\n    for (var name in defaults)\n      this.options[name] = (options && options.hasOwnProperty(name) ? options : defaults)[name]\n    this.overlay = this.timeout = null;\n    this.matchesonscroll = null;\n    this.active = false;\n  }\n\n  CodeMirror.defineOption("highlightSelectionMatches", false, function(cm, val, old) {\n    if (old && old != CodeMirror.Init) {\n      removeOverlay(cm);\n      clearTimeout(cm.state.matchHighlighter.timeout);\n      cm.state.matchHighlighter = null;\n      cm.off("cursorActivity", cursorActivity);\n      cm.off("focus", onFocus)\n    }\n    if (val) {\n      var state = cm.state.matchHighlighter = new State(val);\n      if (cm.hasFocus()) {\n        state.active = true\n        highlightMatches(cm)\n      } else {\n        cm.on("focus", onFocus)\n      }\n      cm.on("cursorActivity", cursorActivity);\n    }\n  });\n\n  function cursorActivity(cm) {\n    var state = cm.state.matchHighlighter;\n    if (state.active || cm.hasFocus()) scheduleHighlight(cm, state)\n  }\n\n  function onFocus(cm) {\n    var state = cm.state.matchHighlighter\n    if (!state.active) {\n      state.active = true\n      scheduleHighlight(cm, state)\n    }\n  }\n\n  function scheduleHighlight(cm, state) {\n    clearTimeout(state.timeout);\n    state.timeout = setTimeout(function() {highlightMatches(cm);}, state.options.delay);\n  }\n\n  function addOverlay(cm, query, hasBoundary, style) {\n    var state = cm.state.matchHighlighter;\n    cm.addOverlay(state.overlay = makeOverlay(query, hasBoundary, style));\n    if (state.options.annotateScrollbar && cm.showMatchesOnScrollbar) {\n      var searchFor = hasBoundary ? new RegExp("\\\\b" + query + "\\\\b") : query;\n      state.matchesonscroll = cm.showMatchesOnScrollbar(searchFor, false,\n        {className: "CodeMirror-selection-highlight-scrollbar"});\n    }\n  }\n\n  function removeOverlay(cm) {\n    var state = cm.state.matchHighlighter;\n    if (state.overlay) {\n      cm.removeOverlay(state.overlay);\n      state.overlay = null;\n      if (state.matchesonscroll) {\n        state.matchesonscroll.clear();\n        state.matchesonscroll = null;\n      }\n    }\n  }\n\n  function highlightMatches(cm) {\n    cm.operation(function() {\n      var state = cm.state.matchHighlighter;\n      removeOverlay(cm);\n      if (!cm.somethingSelected() && state.options.showToken) {\n        var re = state.options.showToken === true ? /[\\w$]/ : state.options.showToken;\n        var cur = cm.getCursor(), line = cm.getLine(cur.line), start = cur.ch, end = start;\n        while (start && re.test(line.charAt(start - 1))) --start;\n        while (end < line.length && re.test(line.charAt(end))) ++end;\n        if (start < end)\n          addOverlay(cm, line.slice(start, end), re, state.options.style);\n        return;\n      }\n      var from = cm.getCursor("from"), to = cm.getCursor("to");\n      if (from.line != to.line) return;\n      if (state.options.wordsOnly && !isWord(cm, from, to)) return;\n      var selection = cm.getRange(from, to)\n      if (state.options.trim) selection = selection.replace(/^\\s+|\\s+$/g, "")\n      if (selection.length >= state.options.minChars)\n        addOverlay(cm, selection, false, state.options.style);\n    });\n  }\n\n  function isWord(cm, from, to) {\n    var str = cm.getRange(from, to);\n    if (str.match(/^\\w+$/) !== null) {\n        if (from.ch > 0) {\n            var pos = {line: from.line, ch: from.ch - 1};\n            var chr = cm.getRange(pos, from);\n            if (chr.match(/\\W/) === null) return false;\n        }\n        if (to.ch < cm.getLine(from.line).length) {\n            var pos = {line: to.line, ch: to.ch + 1};\n            var chr = cm.getRange(to, pos);\n            if (chr.match(/\\W/) === null) return false;\n        }\n        return true;\n    } else return false;\n  }\n\n  function boundariesAround(stream, re) {\n    return (!stream.start || !re.test(stream.string.charAt(stream.start - 1))) &&\n      (stream.pos == stream.string.length || !re.test(stream.string.charAt(stream.pos)));\n  }\n\n  function makeOverlay(query, hasBoundary, style) {\n    return {token: function(stream) {\n      if (stream.match(query) &&\n          (!hasBoundary || boundariesAround(stream, hasBoundary)))\n        return style;\n      stream.next();\n      stream.skipTo(query.charAt(0)) || stream.skipToEnd();\n    }};\n  }\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/search/match-highlighter.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/selection/active-line\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  "use strict";\n  var WRAP_CLASS = "CodeMirror-activeline";\n  var BACK_CLASS = "CodeMirror-activeline-background";\n  var GUTT_CLASS = "CodeMirror-activeline-gutter";\n\n  CodeMirror.defineOption("styleActiveLine", false, function(cm, val, old) {\n    var prev = old == CodeMirror.Init ? false : old;\n    if (val == prev) return\n    if (prev) {\n      cm.off("beforeSelectionChange", selectionChange);\n      clearActiveLines(cm);\n      delete cm.state.activeLines;\n    }\n    if (val) {\n      cm.state.activeLines = [];\n      updateActiveLines(cm, cm.listSelections());\n      cm.on("beforeSelectionChange", selectionChange);\n    }\n  });\n\n  function clearActiveLines(cm) {\n    for (var i = 0; i < cm.state.activeLines.length; i++) {\n      cm.removeLineClass(cm.state.activeLines[i], "wrap", WRAP_CLASS);\n      cm.removeLineClass(cm.state.activeLines[i], "background", BACK_CLASS);\n      cm.removeLineClass(cm.state.activeLines[i], "gutter", GUTT_CLASS);\n    }\n  }\n\n  function sameArray(a, b) {\n    if (a.length != b.length) return false;\n    for (var i = 0; i < a.length; i++)\n      if (a[i] != b[i]) return false;\n    return true;\n  }\n\n  function updateActiveLines(cm, ranges) {\n    var active = [];\n    for (var i = 0; i < ranges.length; i++) {\n      var range = ranges[i];\n      var option = cm.getOption("styleActiveLine");\n      if (typeof option == "object" && option.nonEmpty ? range.anchor.line != range.head.line : !range.empty())\n        continue\n      var line = cm.getLineHandleVisualStart(range.head.line);\n      if (active[active.length - 1] != line) active.push(line);\n    }\n    if (sameArray(cm.state.activeLines, active)) return;\n    cm.operation(function() {\n      clearActiveLines(cm);\n      for (var i = 0; i < active.length; i++) {\n        cm.addLineClass(active[i], "wrap", WRAP_CLASS);\n        cm.addLineClass(active[i], "background", BACK_CLASS);\n        cm.addLineClass(active[i], "gutter", GUTT_CLASS);\n      }\n      cm.state.activeLines = active;\n    });\n  }\n\n  function selectionChange(cm, sel) {\n    updateActiveLines(cm, sel.ranges);\n  }\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/selection/active-line.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n// Because sometimes you need to mark the selected *text*.\n//\n// Adds an option \'styleSelectedText\' which, when enabled, gives\n// selected text the CSS class given as option value, or\n// "CodeMirror-selectedtext" when the value is not a string.\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../../lib/codemirror"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/addon/selection/mark-selection\',["../../lib/codemirror"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  "use strict";\n\n  CodeMirror.defineOption("styleSelectedText", false, function(cm, val, old) {\n    var prev = old && old != CodeMirror.Init;\n    if (val && !prev) {\n      cm.state.markedSelection = [];\n      cm.state.markedSelectionStyle = typeof val == "string" ? val : "CodeMirror-selectedtext";\n      reset(cm);\n      cm.on("cursorActivity", onCursorActivity);\n      cm.on("change", onChange);\n    } else if (!val && prev) {\n      cm.off("cursorActivity", onCursorActivity);\n      cm.off("change", onChange);\n      clear(cm);\n      cm.state.markedSelection = cm.state.markedSelectionStyle = null;\n    }\n  });\n\n  function onCursorActivity(cm) {\n    if (cm.state.markedSelection)\n      cm.operation(function() { update(cm); });\n  }\n\n  function onChange(cm) {\n    if (cm.state.markedSelection && cm.state.markedSelection.length)\n      cm.operation(function() { clear(cm); });\n  }\n\n  var CHUNK_SIZE = 8;\n  var Pos = CodeMirror.Pos;\n  var cmp = CodeMirror.cmpPos;\n\n  function coverRange(cm, from, to, addAt) {\n    if (cmp(from, to) == 0) return;\n    var array = cm.state.markedSelection;\n    var cls = cm.state.markedSelectionStyle;\n    for (var line = from.line;;) {\n      var start = line == from.line ? from : Pos(line, 0);\n      var endLine = line + CHUNK_SIZE, atEnd = endLine >= to.line;\n      var end = atEnd ? to : Pos(endLine, 0);\n      var mark = cm.markText(start, end, {className: cls});\n      if (addAt == null) array.push(mark);\n      else array.splice(addAt++, 0, mark);\n      if (atEnd) break;\n      line = endLine;\n    }\n  }\n\n  function clear(cm) {\n    var array = cm.state.markedSelection;\n    for (var i = 0; i < array.length; ++i) array[i].clear();\n    array.length = 0;\n  }\n\n  function reset(cm) {\n    clear(cm);\n    var ranges = cm.listSelections();\n    for (var i = 0; i < ranges.length; i++)\n      coverRange(cm, ranges[i].from(), ranges[i].to());\n  }\n\n  function update(cm) {\n    if (!cm.somethingSelected()) return clear(cm);\n    if (cm.listSelections().length > 1) return reset(cm);\n\n    var from = cm.getCursor("start"), to = cm.getCursor("end");\n\n    var array = cm.state.markedSelection;\n    if (!array.length) return coverRange(cm, from, to);\n\n    var coverStart = array[0].find(), coverEnd = array[array.length - 1].find();\n    if (!coverStart || !coverEnd || to.line - from.line < CHUNK_SIZE ||\n        cmp(from, coverEnd.to) >= 0 || cmp(to, coverStart.from) <= 0)\n      return reset(cm);\n\n    while (cmp(from, coverStart.from) > 0) {\n      array.shift().clear();\n      coverStart = array[0].find();\n    }\n    if (cmp(from, coverStart.from) < 0) {\n      if (coverStart.to.line - from.line < CHUNK_SIZE) {\n        array.shift().clear();\n        coverRange(cm, from, coverStart.to, 0);\n      } else {\n        coverRange(cm, from, coverStart.from, 0);\n      }\n    }\n\n    while (cmp(to, coverEnd.to) < 0) {\n      array.pop().clear();\n      coverEnd = array[array.length - 1].find();\n    }\n    if (cmp(to, coverEnd.to) > 0) {\n      if (to.line - coverEnd.from.line < CHUNK_SIZE) {\n        array.pop().clear();\n        coverRange(cm, coverEnd.from, to);\n      } else {\n        coverRange(cm, coverEnd.to, to);\n      }\n    }\n  }\n});\n\n//# sourceURL=/thirdparty/CodeMirror/addon/selection/mark-selection.js'),eval('// CodeMirror, copyright (c) by Marijn Haverbeke and others\n// Distributed under an MIT license: http://codemirror.net/LICENSE\n\n// A rough approximation of Sublime Text\'s keybindings\n// Depends on addon/search/searchcursor.js and optionally addon/dialog/dialogs.js\n\n(function(mod) {\n  if (typeof exports == "object" && typeof module == "object") // CommonJS\n    mod(require("../lib/codemirror"), require("../addon/search/searchcursor"), require("../addon/edit/matchbrackets"));\n  else if (typeof define == "function" && define.amd) // AMD\n    define(\'thirdparty/CodeMirror/keymap/sublime\',["../lib/codemirror", "../addon/search/searchcursor", "../addon/edit/matchbrackets"], mod);\n  else // Plain browser env\n    mod(CodeMirror);\n})(function(CodeMirror) {\n  "use strict";\n\n  var map = CodeMirror.keyMap.sublime = {fallthrough: "default"};\n  var cmds = CodeMirror.commands;\n  var Pos = CodeMirror.Pos;\n  var mac = CodeMirror.keyMap["default"] == CodeMirror.keyMap.macDefault;\n  var ctrl = mac ? "Cmd-" : "Ctrl-";\n\n  // This is not exactly Sublime\'s algorithm. I couldn\'t make heads or tails of that.\n  function findPosSubword(doc, start, dir) {\n    if (dir < 0 && start.ch == 0) return doc.clipPos(Pos(start.line - 1));\n    var line = doc.getLine(start.line);\n    if (dir > 0 && start.ch >= line.length) return doc.clipPos(Pos(start.line + 1, 0));\n    var state = "start", type;\n    for (var pos = start.ch, e = dir < 0 ? 0 : line.length, i = 0; pos != e; pos += dir, i++) {\n      var next = line.charAt(dir < 0 ? pos - 1 : pos);\n      var cat = next != "_" && CodeMirror.isWordChar(next) ? "w" : "o";\n      if (cat == "w" && next.toUpperCase() == next) cat = "W";\n      if (state == "start") {\n        if (cat != "o") { state = "in"; type = cat; }\n      } else if (state == "in") {\n        if (type != cat) {\n          if (type == "w" && cat == "W" && dir < 0) pos--;\n          if (type == "W" && cat == "w" && dir > 0) { type = "w"; continue; }\n          break;\n        }\n      }\n    }\n    return Pos(start.line, pos);\n  }\n\n  function moveSubword(cm, dir) {\n    cm.extendSelectionsBy(function(range) {\n      if (cm.display.shift || cm.doc.extend || range.empty())\n        return findPosSubword(cm.doc, range.head, dir);\n      else\n        return dir < 0 ? range.from() : range.to();\n    });\n  }\n\n  var goSubwordCombo = mac ? "Ctrl-" : "Alt-";\n\n  cmds[map[goSubwordCombo + "Left"] = "goSubwordLeft"] = function(cm) { moveSubword(cm, -1); };\n  cmds[map[goSubwordCombo + "Right"] = "goSubwordRight"] = function(cm) { moveSubword(cm, 1); };\n\n  if (mac) map["Cmd-Left"] = "goLineStartSmart";\n\n  var scrollLineCombo = mac ? "Ctrl-Alt-" : "Ctrl-";\n\n  cmds[map[scrollLineCombo + "Up"] = "scrollLineUp"] = function(cm) {\n    var info = cm.getScrollInfo();\n    if (!cm.somethingSelected()) {\n      var visibleBottomLine = cm.lineAtHeight(info.top + info.clientHeight, "local");\n      if (cm.getCursor().line >= visibleBottomLine)\n        cm.execCommand("goLineUp");\n    }\n    cm.scrollTo(null, info.top - cm.defaultTextHeight());\n  };\n  cmds[map[scrollLineCombo + "Down"] = "scrollLineDown"] = function(cm) {\n    var info = cm.getScrollInfo();\n    if (!cm.somethingSelected()) {\n      var visibleTopLine = cm.lineAtHeight(info.top, "local")+1;\n      if (cm.getCursor().line <= visibleTopLine)\n        cm.execCommand("goLineDown");\n    }\n    cm.scrollTo(null, info.top + cm.defaultTextHeight());\n  };\n\n  cmds[map["Shift-" + ctrl + "L"] = "splitSelectionByLine"] = function(cm) {\n    var ranges = cm.listSelections(), lineRanges = [];\n    for (var i = 0; i < ranges.length; i++) {\n      var from = ranges[i].from(), to = ranges[i].to();\n      for (var line = from.line; line <= to.line; ++line)\n        if (!(to.line > from.line && line == to.line && to.ch == 0))\n          lineRanges.push({anchor: line == from.line ? from : Pos(line, 0),\n                           head: line == to.line ? to : Pos(line)});\n    }\n    cm.setSelections(lineRanges, 0);\n  };\n\n  map["Shift-Tab"] = "indentLess";\n\n  cmds[map["Esc"] = "singleSelectionTop"] = function(cm) {\n    var range = cm.listSelections()[0];\n    cm.setSelection(range.anchor, range.head, {scroll: false});\n  };\n\n  cmds[map[ctrl + "L"] = "selectLine"] = function(cm) {\n    var ranges = cm.listSelections(), extended = [];\n    for (var i = 0; i < ranges.length; i++) {\n      var range = ranges[i];\n      extended.push({anchor: Pos(range.from().line, 0),\n                     head: Pos(range.to().line + 1, 0)});\n    }\n    cm.setSelections(extended);\n  };\n\n  map["Shift-Ctrl-K"] = "deleteLine";\n\n  function insertLine(cm, above) {\n    if (cm.isReadOnly()) return CodeMirror.Pass\n    cm.operation(function() {\n      var len = cm.listSelections().length, newSelection = [], last = -1;\n      for (var i = 0; i < len; i++) {\n        var head = cm.listSelections()[i].head;\n        if (head.line <= last) continue;\n        var at = Pos(head.line + (above ? 0 : 1), 0);\n        cm.replaceRange("\\n", at, null, "+insertLine");\n        cm.indentLine(at.line, null, true);\n        newSelection.push({head: at, anchor: at});\n        last = head.line + 1;\n      }\n      cm.setSelections(newSelection);\n    });\n    cm.execCommand("indentAuto");\n  }\n\n  cmds[map[ctrl + "Enter"] = "insertLineAfter"] = function(cm) { return insertLine(cm, false); };\n\n  cmds[map["Shift-" + ctrl + "Enter"] = "insertLineBefore"] = function(cm) { return insertLine(cm, true); };\n\n  function wordAt(cm, pos) {\n    var start = pos.ch, end = start, line = cm.getLine(pos.line);\n    while (start && CodeMirror.isWordChar(line.charAt(start - 1))) --start;\n    while (end < line.length && CodeMirror.isWordChar(line.charAt(end))) ++end;\n    return {from: Pos(pos.line, start), to: Pos(pos.line, end), word: line.slice(start, end)};\n  }\n\n  cmds[map[ctrl + "D"] = "selectNextOccurrence"] = function(cm) {\n    var from = cm.getCursor("from"), to = cm.getCursor("to");\n    var fullWord = cm.state.sublimeFindFullWord == cm.doc.sel;\n    if (CodeMirror.cmpPos(from, to) == 0) {\n      var word = wordAt(cm, from);\n      if (!word.word) return;\n      cm.setSelection(word.from, word.to);\n      fullWord = true;\n    } else {\n      var text = cm.getRange(from, to);\n      var query = fullWord ? new RegExp("\\\\b" + text + "\\\\b") : text;\n      var cur = cm.getSearchCursor(query, to);\n      var found = cur.findNext();\n      if (!found) {\n        cur = cm.getSearchCursor(query, Pos(cm.firstLine(), 0));\n        found = cur.findNext();\n      }\n      if (!found || isSelectedRange(cm.listSelections(), cur.from(), cur.to()))\n        return CodeMirror.Pass\n      cm.addSelection(cur.from(), cur.to());\n    }\n    if (fullWord)\n      cm.state.sublimeFindFullWord = cm.doc.sel;\n  };\n\n  function addCursorToSelection(cm, dir) {\n    var ranges = cm.listSelections(), newRanges = [];\n    for (var i = 0; i < ranges.length; i++) {\n      var range = ranges[i];\n      var newAnchor = cm.findPosV(range.anchor, dir, "line");\n      var newHead = cm.findPosV(range.head, dir, "line");\n      var newRange = {anchor: newAnchor, head: newHead};\n      newRanges.push(range);\n      newRanges.push(newRange);\n    }\n    cm.setSelections(newRanges);\n  }\n\n  var addCursorToLineCombo = mac ? "Shift-Cmd" : \'Alt-Ctrl\';\n  cmds[map[addCursorToLineCombo + "Up"] = "addCursorToPrevLine"] = function(cm) { addCursorToSelection(cm, -1); };\n  cmds[map[addCursorToLineCombo + "Down"] = "addCursorToNextLine"] = function(cm) { addCursorToSelection(cm, 1); };\n\n  function isSelectedRange(ranges, from, to) {\n    for (var i = 0; i < ranges.length; i++)\n      if (ranges[i].from() == from && ranges[i].to() == to) return true\n    return false\n  }\n\n  var mirror = "(){}[]";\n  function selectBetweenBrackets(cm) {\n    var ranges = cm.listSelections(), newRanges = []\n    for (var i = 0; i < ranges.length; i++) {\n      var range = ranges[i], pos = range.head, opening = cm.scanForBracket(pos, -1);\n      if (!opening) return false;\n      for (;;) {\n        var closing = cm.scanForBracket(pos, 1);\n        if (!closing) return false;\n        if (closing.ch == mirror.charAt(mirror.indexOf(opening.ch) + 1)) {\n          newRanges.push({anchor: Pos(opening.pos.line, opening.pos.ch + 1),\n                          head: closing.pos});\n          break;\n        }\n        pos = Pos(closing.pos.line, closing.pos.ch + 1);\n      }\n    }\n    cm.setSelections(newRanges);\n    return true;\n  }\n\n  cmds[map["Shift-" + ctrl + "Space"] = "selectScope"] = function(cm) {\n    selectBetweenBrackets(cm) || cm.execCommand("selectAll");\n  };\n  cmds[map["Shift-" + ctrl + "M"] = "selectBetweenBrackets"] = function(cm) {\n    if (!selectBetweenBrackets(cm)) return CodeMirror.Pass;\n  };\n\n  cmds[map[ctrl + "M"] = "goToBracket"] = function(cm) {\n    cm.extendSelectionsBy(function(range) {\n      var next = cm.scanForBracket(range.head, 1);\n      if (next && CodeMirror.cmpPos(next.pos, range.head) != 0) return next.pos;\n      var prev = cm.scanForBracket(range.head, -1);\n      return prev && Pos(prev.pos.line, prev.pos.ch + 1) || range.head;\n    });\n  };\n\n  var swapLineCombo = mac ? "Cmd-Ctrl-" : "Shift-Ctrl-";\n\n  cmds[map[swapLineCombo + "Up"] = "swapLineUp"] = function(cm) {\n    if (cm.isReadOnly()) return CodeMirror.Pass\n    var ranges = cm.listSelections(), linesToMove = [], at = cm.firstLine() - 1, newSels = [];\n    for (var i = 0; i < ranges.length; i++) {\n      var range = ranges[i], from = range.from().line - 1, to = range.to().line;\n      newSels.push({anchor: Pos(range.anchor.line - 1, range.anchor.ch),\n                    head: Pos(range.head.line - 1, range.head.ch)});\n      if (range.to().ch == 0 && !range.empty()) --to;\n      if (from > at) linesToMove.push(from, to);\n      else if (linesToMove.length) linesToMove[linesToMove.length - 1] = to;\n      at = to;\n    }\n    cm.operation(function() {\n      for (var i = 0; i < linesToMove.length; i += 2) {\n        var from = linesToMove[i], to = linesToMove[i + 1];\n        var line = cm.getLine(from);\n        cm.replaceRange("", Pos(from, 0), Pos(from + 1, 0), "+swapLine");\n        if (to > cm.lastLine())\n          cm.replaceRange("\\n" + line, Pos(cm.lastLine()), null, "+swapLine");\n        else\n          cm.replaceRange(line + "\\n", Pos(to, 0), null, "+swapLine");\n      }\n      cm.setSelections(newSels);\n      cm.scrollIntoView();\n    });\n  };\n\n  cmds[map[swapLineCombo + "Down"] = "swapLineDown"] = function(cm) {\n    if (cm.isReadOnly()) return CodeMirror.Pass\n    var ranges = cm.listSelections(), linesToMove = [], at = cm.lastLine() + 1;\n    for (var i = ranges.length - 1; i >= 0; i--) {\n      var range = ranges[i], from = range.to().line + 1, to = range.from().line;\n      if (range.to().ch == 0 && !range.empty()) from--;\n      if (from < at) linesToMove.push(from, to);\n      else if (linesToMove.length) linesToMove[linesToMove.length - 1] = to;\n      at = to;\n    }\n    cm.operation(function() {\n      for (var i = linesToMove.length - 2; i >= 0; i -= 2) {\n        var from = linesToMove[i], to = linesToMove[i + 1];\n        var line = cm.getLine(from);\n        if (from == cm.lastLine())\n          cm.replaceRange("", Pos(from - 1), Pos(from), "+swapLine");\n        else\n          cm.replaceRange("", Pos(from, 0), Pos(from + 1, 0), "+swapLine");\n        cm.replaceRange(line + "\\n", Pos(to, 0), null, "+swapLine");\n      }\n      cm.scrollIntoView();\n    });\n  };\n\n  cmds[map[ctrl + "/"] = "toggleCommentIndented"] = function(cm) {\n    cm.toggleComment({ indent: true });\n  }\n\n  cmds[map[ctrl + "J"] = "joinLines"] = function(cm) {\n    var ranges = cm.listSelections(), joined = [];\n    for (var i = 0; i < ranges.length; i++) {\n      var range = ranges[i], from = range.from();\n      var start = from.line, end = range.to().line;\n      while (i < ranges.length - 1 && ranges[i + 1].from().line == end)\n        end = ranges[++i].to().line;\n      joined.push({start: start, end: end, anchor: !range.empty() && from});\n    }\n    cm.operation(function() {\n      var offset = 0, ranges = [];\n      for (var i = 0; i < joined.length; i++) {\n        var obj = joined[i];\n        var anchor = obj.anchor && Pos(obj.anchor.line - offset, obj.anchor.ch), head;\n        for (var line = obj.start; line <= obj.end; line++) {\n          var actual = line - offset;\n          if (line == obj.end) head = Pos(actual, cm.getLine(actual).length + 1);\n          if (actual < cm.lastLine()) {\n            cm.replaceRange(" ", Pos(actual), Pos(actual + 1, /^\\s*/.exec(cm.getLine(actual + 1))[0].length));\n            ++offset;\n          }\n        }\n        ranges.push({anchor: anchor || head, head: head});\n      }\n      cm.setSelections(ranges, 0);\n    });\n  };\n\n  cmds[map["Shift-" + ctrl + "D"] = "duplicateLine"] = function(cm) {\n    cm.operation(function() {\n      var rangeCount = cm.listSelections().length;\n      for (var i = 0; i < rangeCount; i++) {\n        var range = cm.listSelections()[i];\n        if (range.empty())\n          cm.replaceRange(cm.getLine(range.head.line) + "\\n", Pos(range.head.line, 0));\n        else\n          cm.replaceRange(cm.getRange(range.from(), range.to()), range.from());\n      }\n      cm.scrollIntoView();\n    });\n  };\n\n  if (!mac) map[ctrl + "T"] = "transposeChars";\n\n  function sortLines(cm, caseSensitive) {\n    if (cm.isReadOnly()) return CodeMirror.Pass\n    var ranges = cm.listSelections(), toSort = [], selected;\n    for (var i = 0; i < ranges.length; i++) {\n      var range = ranges[i];\n      if (range.empty()) continue;\n      var from = range.from().line, to = range.to().line;\n      while (i < ranges.length - 1 && ranges[i + 1].from().line == to)\n        to = ranges[++i].to().line;\n      if (!ranges[i].to().ch) to--;\n      toSort.push(from, to);\n    }\n    if (toSort.length) selected = true;\n    else toSort.push(cm.firstLine(), cm.lastLine());\n\n    cm.operation(function() {\n      var ranges = [];\n      for (var i = 0; i < toSort.length; i += 2) {\n        var from = toSort[i], to = toSort[i + 1];\n        var start = Pos(from, 0), end = Pos(to);\n        var lines = cm.getRange(start, end, false);\n        if (caseSensitive)\n          lines.sort();\n        else\n          lines.sort(function(a, b) {\n            var au = a.toUpperCase(), bu = b.toUpperCase();\n            if (au != bu) { a = au; b = bu; }\n            return a < b ? -1 : a == b ? 0 : 1;\n          });\n        cm.replaceRange(lines, start, end);\n        if (selected) ranges.push({anchor: start, head: Pos(to + 1, 0)});\n      }\n      if (selected) cm.setSelections(ranges, 0);\n    });\n  }\n\n  cmds[map["F9"] = "sortLines"] = function(cm) { sortLines(cm, true); };\n  cmds[map[ctrl + "F9"] = "sortLinesInsensitive"] = function(cm) { sortLines(cm, false); };\n\n  cmds[map["F2"] = "nextBookmark"] = function(cm) {\n    var marks = cm.state.sublimeBookmarks;\n    if (marks) while (marks.length) {\n      var current = marks.shift();\n      var found = current.find();\n      if (found) {\n        marks.push(current);\n        return cm.setSelection(found.from, found.to);\n      }\n    }\n  };\n\n  cmds[map["Shift-F2"] = "prevBookmark"] = function(cm) {\n    var marks = cm.state.sublimeBookmarks;\n    if (marks) while (marks.length) {\n      marks.unshift(marks.pop());\n      var found = marks[marks.length - 1].find();\n      if (!found)\n        marks.pop();\n      else\n        return cm.setSelection(found.from, found.to);\n    }\n  };\n\n  cmds[map[ctrl + "F2"] = "toggleBookmark"] = function(cm) {\n    var ranges = cm.listSelections();\n    var marks = cm.state.sublimeBookmarks || (cm.state.sublimeBookmarks = []);\n    for (var i = 0; i < ranges.length; i++) {\n      var from = ranges[i].from(), to = ranges[i].to();\n      var found = cm.findMarks(from, to);\n      for (var j = 0; j < found.length; j++) {\n        if (found[j].sublimeBookmark) {\n          found[j].clear();\n          for (var k = 0; k < marks.length; k++)\n            if (marks[k] == found[j])\n              marks.splice(k--, 1);\n          break;\n        }\n      }\n      if (j == found.length)\n        marks.push(cm.markText(from, to, {sublimeBookmark: true, clearWhenEmpty: false}));\n    }\n  };\n\n  cmds[map["Shift-" + ctrl + "F2"] = "clearBookmarks"] = function(cm) {\n    var marks = cm.state.sublimeBookmarks;\n    if (marks) for (var i = 0; i < marks.length; i++) marks[i].clear();\n    marks.length = 0;\n  };\n\n  cmds[map["Alt-F2"] = "selectBookmarks"] = function(cm) {\n    var marks = cm.state.sublimeBookmarks, ranges = [];\n    if (marks) for (var i = 0; i < marks.length; i++) {\n      var found = marks[i].find();\n      if (!found)\n        marks.splice(i--, 0);\n      else\n        ranges.push({anchor: found.from, head: found.to});\n    }\n    if (ranges.length)\n      cm.setSelections(ranges, 0);\n  };\n\n  map["Alt-Q"] = "wrapLines";\n\n  var cK = ctrl + "K ";\n\n  function modifyWordOrSelection(cm, mod) {\n    cm.operation(function() {\n      var ranges = cm.listSelections(), indices = [], replacements = [];\n      for (var i = 0; i < ranges.length; i++) {\n        var range = ranges[i];\n        if (range.empty()) { indices.push(i); replacements.push(""); }\n        else replacements.push(mod(cm.getRange(range.from(), range.to())));\n      }\n      cm.replaceSelections(replacements, "around", "case");\n      for (var i = indices.length - 1, at; i >= 0; i--) {\n        var range = ranges[indices[i]];\n        if (at && CodeMirror.cmpPos(range.head, at) > 0) continue;\n        var word = wordAt(cm, range.head);\n        at = word.from;\n        cm.replaceRange(mod(word.word), word.from, word.to);\n      }\n    });\n  }\n\n  map[cK + ctrl + "Backspace"] = "delLineLeft";\n\n  cmds[map["Backspace"] = "smartBackspace"] = function(cm) {\n    if (cm.somethingSelected()) return CodeMirror.Pass;\n\n    cm.operation(function() {\n      var cursors = cm.listSelections();\n      var indentUnit = cm.getOption("indentUnit");\n\n      for (var i = cursors.length - 1; i >= 0; i--) {\n        var cursor = cursors[i].head;\n        var toStartOfLine = cm.getRange({line: cursor.line, ch: 0}, cursor);\n        var column = CodeMirror.countColumn(toStartOfLine, null, cm.getOption("tabSize"));\n\n        // Delete by one character by default\n        var deletePos = cm.findPosH(cursor, -1, "char", false);\n\n        if (toStartOfLine && !/\\S/.test(toStartOfLine) && column % indentUnit == 0) {\n          var prevIndent = new Pos(cursor.line,\n            CodeMirror.findColumn(toStartOfLine, column - indentUnit, indentUnit));\n\n          // Smart delete only if we found a valid prevIndent location\n          if (prevIndent.ch != cursor.ch) deletePos = prevIndent;\n        }\n\n        cm.replaceRange("", deletePos, cursor, "+delete");\n      }\n    });\n  };\n\n  cmds[map[cK + ctrl + "K"] = "delLineRight"] = function(cm) {\n    cm.operation(function() {\n      var ranges = cm.listSelections();\n      for (var i = ranges.length - 1; i >= 0; i--)\n        cm.replaceRange("", ranges[i].anchor, Pos(ranges[i].to().line), "+delete");\n      cm.scrollIntoView();\n    });\n  };\n\n  cmds[map[cK + ctrl + "U"] = "upcaseAtCursor"] = function(cm) {\n    modifyWordOrSelection(cm, function(str) { return str.toUpperCase(); });\n  };\n  cmds[map[cK + ctrl + "L"] = "downcaseAtCursor"] = function(cm) {\n    modifyWordOrSelection(cm, function(str) { return str.toLowerCase(); });\n  };\n\n  cmds[map[cK + ctrl + "Space"] = "setSublimeMark"] = function(cm) {\n    if (cm.state.sublimeMark) cm.state.sublimeMark.clear();\n    cm.state.sublimeMark = cm.setBookmark(cm.getCursor());\n  };\n  cmds[map[cK + ctrl + "A"] = "selectToSublimeMark"] = function(cm) {\n    var found = cm.state.sublimeMark && cm.state.sublimeMark.find();\n    if (found) cm.setSelection(cm.getCursor(), found);\n  };\n  cmds[map[cK + ctrl + "W"] = "deleteToSublimeMark"] = function(cm) {\n    var found = cm.state.sublimeMark && cm.state.sublimeMark.find();\n    if (found) {\n      var from = cm.getCursor(), to = found;\n      if (CodeMirror.cmpPos(from, to) > 0) { var tmp = to; to = from; from = tmp; }\n      cm.state.sublimeKilled = cm.getRange(from, to);\n      cm.replaceRange("", from, to);\n    }\n  };\n  cmds[map[cK + ctrl + "X"] = "swapWithSublimeMark"] = function(cm) {\n    var found = cm.state.sublimeMark && cm.state.sublimeMark.find();\n    if (found) {\n      cm.state.sublimeMark.clear();\n      cm.state.sublimeMark = cm.setBookmark(cm.getCursor());\n      cm.setCursor(found);\n    }\n  };\n  cmds[map[cK + ctrl + "Y"] = "sublimeYank"] = function(cm) {\n    if (cm.state.sublimeKilled != null)\n      cm.replaceSelection(cm.state.sublimeKilled, null, "paste");\n  };\n\n  map[cK + ctrl + "G"] = "clearBookmarks";\n  cmds[map[cK + ctrl + "C"] = "showInCenter"] = function(cm) {\n    var pos = cm.cursorCoords(null, "local");\n    cm.scrollTo(null, (pos.top + pos.bottom) / 2 - cm.getScrollInfo().clientHeight / 2);\n  };\n\n  var selectLinesCombo = mac ? "Ctrl-Shift-" : "Ctrl-Alt-";\n  cmds[map[selectLinesCombo + "Up"] = "selectLinesUpward"] = function(cm) {\n    cm.operation(function() {\n      var ranges = cm.listSelections();\n      for (var i = 0; i < ranges.length; i++) {\n        var range = ranges[i];\n        if (range.head.line > cm.firstLine())\n          cm.addSelection(Pos(range.head.line - 1, range.head.ch));\n      }\n    });\n  };\n  cmds[map[selectLinesCombo + "Down"] = "selectLinesDownward"] = function(cm) {\n    cm.operation(function() {\n      var ranges = cm.listSelections();\n      for (var i = 0; i < ranges.length; i++) {\n        var range = ranges[i];\n        if (range.head.line < cm.lastLine())\n          cm.addSelection(Pos(range.head.line + 1, range.head.ch));\n      }\n    });\n  };\n\n  function getTarget(cm) {\n    var from = cm.getCursor("from"), to = cm.getCursor("to");\n    if (CodeMirror.cmpPos(from, to) == 0) {\n      var word = wordAt(cm, from);\n      if (!word.word) return;\n      from = word.from;\n      to = word.to;\n    }\n    return {from: from, to: to, query: cm.getRange(from, to), word: word};\n  }\n\n  function findAndGoTo(cm, forward) {\n    var target = getTarget(cm);\n    if (!target) return;\n    var query = target.query;\n    var cur = cm.getSearchCursor(query, forward ? target.to : target.from);\n\n    if (forward ? cur.findNext() : cur.findPrevious()) {\n      cm.setSelection(cur.from(), cur.to());\n    } else {\n      cur = cm.getSearchCursor(query, forward ? Pos(cm.firstLine(), 0)\n                                              : cm.clipPos(Pos(cm.lastLine())));\n      if (forward ? cur.findNext() : cur.findPrevious())\n        cm.setSelection(cur.from(), cur.to());\n      else if (target.word)\n        cm.setSelection(target.from, target.to);\n    }\n  };\n  cmds[map[ctrl + "F3"] = "findUnder"] = function(cm) { findAndGoTo(cm, true); };\n  cmds[map["Shift-" + ctrl + "F3"] = "findUnderPrevious"] = function(cm) { findAndGoTo(cm,false); };\n  cmds[map["Alt-F3"] = "findAllUnder"] = function(cm) {\n    var target = getTarget(cm);\n    if (!target) return;\n    var cur = cm.getSearchCursor(target.query);\n    var matches = [];\n    var primaryIndex = -1;\n    while (cur.findNext()) {\n      matches.push({anchor: cur.from(), head: cur.to()});\n      if (cur.from().line <= target.from.line && cur.from().ch <= target.from.ch)\n        primaryIndex++;\n    }\n    cm.setSelections(matches, primaryIndex);\n  };\n\n  map["Shift-" + ctrl + "["] = "fold";\n  map["Shift-" + ctrl + "]"] = "unfold";\n  map[cK + ctrl + "0"] = map[cK + ctrl + "J"] = "unfoldAll";\n\n  map[ctrl + "I"] = "findIncremental";\n  map["Shift-" + ctrl + "I"] = "findIncrementalReverse";\n  map[ctrl + "H"] = "replace";\n  map["F3"] = "findNext";\n  map["Shift-F3"] = "findPrev";\n\n  CodeMirror.normalizeKeyMap(map);\n});\n\n//# sourceURL=/thirdparty/CodeMirror/keymap/sublime.js'),
eval('/*\r\n * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\n/**\r\n * Defines hooks to assist with module initialization.\r\n *\r\n * This module defines 3 methods for client modules to attach callbacks:\r\n *    - htmlReady - When the main application template is rendered\r\n *    - extensionsLoaded - When the extension manager has loaded all extensions\r\n *    - appReady - When Brackets completes loading all modules and extensions\r\n *\r\n * These are *not* jQuery events. Each method is similar to $(document).ready\r\n * in that it will call the handler immediately if brackets is already done\r\n * loading.\r\n */\r\ndefine(\'utils/AppInit\',[\'require\',\'exports\',\'module\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    /*\r\n     * Fires when the base htmlContent/main-view.html is loaded\r\n     * @type {string}\r\n     * @const\r\n     */\r\n    var HTML_READY  = "htmlReady";\r\n\r\n    /*\r\n     * Fires when all extensions are loaded\r\n     * @type {string}\r\n     * @const\r\n     */\r\n    var APP_READY   = "appReady";\r\n\r\n    /*\r\n     * Fires after extensions have been loaded\r\n     * @type {string}\r\n     * @const\r\n     */\r\n    var EXTENSIONS_LOADED = "extensionsLoaded";\r\n\r\n    /*\r\n     * Map of each state\'s trigger\r\n     * @type {Object.<string, boolean>}\r\n     * @private\r\n     */\r\n    var _status      = { HTML_READY : false, APP_READY : false, EXTENSIONS_LOADED: false };\r\n\r\n    /*\r\n     * Map of callbacks to states\r\n     * @type {Object.<string, Array.<function()>>}\r\n     * @private\r\n     */\r\n    var _callbacks   = {};\r\n\r\n    _callbacks[HTML_READY]        = [];\r\n    _callbacks[APP_READY]         = [];\r\n    _callbacks[EXTENSIONS_LOADED] = [];\r\n\r\n\r\n    /*\r\n     * calls the specified handler inside a try/catch handler\r\n     * @param {function()} handler - the callback to call\r\n     * @private\r\n     */\r\n    function _callHandler(handler) {\r\n        try {\r\n            // TODO (issue 1034): We *could* use a $.Deferred for this, except deferred objects enter a broken\r\n            // state if any resolution callback throws an exception. Since third parties (e.g. extensions) may\r\n            // add callbacks to this, we need to be robust to exceptions\r\n            handler();\r\n        } catch (e) {\r\n            console.error("Exception when calling a \'brackets done loading\' handler: " + e);\r\n            console.log(e.stack);\r\n        }\r\n    }\r\n\r\n    /*\r\n     * dispatches the event by calling all handlers registered for that type\r\n     * @param {string} type - the event type to dispatch (APP_READY, EXTENSIONS_READY, HTML_READY)\r\n     * @private\r\n     */\r\n    function _dispatchReady(type) {\r\n        var i,\r\n            myHandlers = _callbacks[type];\r\n\r\n        // mark this status complete\r\n        _status[type] = true;\r\n\r\n        for (i = 0; i < myHandlers.length; i++) {\r\n            _callHandler(myHandlers[i]);\r\n        }\r\n\r\n        // clear all callbacks after being called\r\n        _callbacks[type] = [];\r\n    }\r\n\r\n    /*\r\n     * adds a callback to the list of functions to call for the specified event type\r\n     * @param {string} type - the event type to dispatch (APP_READY, EXTENSIONS_READY, HTML_READY)\r\n     * @param {function} handler - callback funciton to call when the event is triggered\r\n     * @private\r\n     */\r\n    function _addListener(type, handler) {\r\n        if (_status[type]) {\r\n            _callHandler(handler);\r\n        } else {\r\n            _callbacks[type].push(handler);\r\n        }\r\n    }\r\n\r\n    /**\r\n     * Adds a callback for the ready hook. Handlers are called after\r\n     * htmlReady is done, the initial project is loaded, and all extensions are\r\n     * loaded.\r\n     * @param {function} handler - callback function to call when the event is fired\r\n     */\r\n    function appReady(handler) {\r\n        _addListener(APP_READY, handler);\r\n    }\r\n\r\n    /**\r\n     * Adds a callback for the htmlReady hook. Handlers are called after the\r\n     * main application html template is rendered.\r\n     * @param {function} handler - callback function to call when the event is fired\r\n     */\r\n    function htmlReady(handler) {\r\n        _addListener(HTML_READY, handler);\r\n    }\r\n\r\n    /**\r\n     * Adds a callback for the extensionsLoaded hook. Handlers are called after the\r\n     * extensions have been loaded\r\n     * @param {function} handler - callback function to call when the event is fired\r\n     */\r\n    function extensionsLoaded(handler) {\r\n        _addListener(EXTENSIONS_LOADED, handler);\r\n    }\r\n\r\n    // Public API\r\n    exports.appReady = appReady;\r\n    exports.htmlReady = htmlReady;\r\n    exports.extensionsLoaded = extensionsLoaded;\r\n\r\n    exports.HTML_READY = HTML_READY;\r\n    exports.APP_READY = APP_READY;\r\n    exports.EXTENSIONS_LOADED = EXTENSIONS_LOADED;\r\n\r\n    // Unit Test API\r\n    exports._dispatchReady = _dispatchReady;\r\n});\r\n\n//# sourceURL=/utils/AppInit.js'),eval('/**\r\n * @license\r\n * lodash 3.10.0 (Custom Build) lodash.com/license | Underscore.js 1.8.3 underscorejs.org/LICENSE\r\n * Build: `lodash modern exports="amd"`\r\n */\r\n;(function(){function n(n,t){if(n!==t){var r=null===n,e=n===w,u=n===n,o=null===t,i=t===w,f=t===t;if(n>t&&!o||!u||r&&!i&&f||e&&f)return 1;if(n<t&&!r||!f||o&&!e&&u||i&&u)return-1}return 0}function t(n,t,r){for(var e=n.length,u=r?e:-1;r?u--:++u<e;)if(t(n[u],u,n))return u;return-1}function r(n,t,r){if(t!==t)return p(n,r);r-=1;for(var e=n.length;++r<e;)if(n[r]===t)return r;return-1}function e(n){return typeof n=="function"||false}function u(n){return null==n?"":n+""}function o(n,t){for(var r=-1,e=n.length;++r<e&&-1<t.indexOf(n.charAt(r)););\r\nreturn r}function i(n,t){for(var r=n.length;r--&&-1<t.indexOf(n.charAt(r)););return r}function f(t,r){return n(t.a,r.a)||t.b-r.b}function a(n){return Nn[n]}function c(n){return Tn[n]}function l(n,t,r){return t?n=Bn[n]:r&&(n=Dn[n]),"\\\\"+n}function s(n){return"\\\\"+Dn[n]}function p(n,t,r){var e=n.length;for(t+=r?0:-1;r?t--:++t<e;){var u=n[t];if(u!==u)return t}return-1}function h(n){return!!n&&typeof n=="object"}function _(n){return 160>=n&&9<=n&&13>=n||32==n||160==n||5760==n||6158==n||8192<=n&&(8202>=n||8232==n||8233==n||8239==n||8287==n||12288==n||65279==n);\r\n}function v(n,t){for(var r=-1,e=n.length,u=-1,o=[];++r<e;)n[r]===t&&(n[r]=z,o[++u]=r);return o}function g(n){for(var t=-1,r=n.length;++t<r&&_(n.charCodeAt(t)););return t}function y(n){for(var t=n.length;t--&&_(n.charCodeAt(t)););return t}function d(n){return Ln[n]}function m(_){function Nn(n){if(h(n)&&!(Oo(n)||n instanceof zn)){if(n instanceof Ln)return n;if(nu.call(n,"__chain__")&&nu.call(n,"__wrapped__"))return Mr(n)}return new Ln(n)}function Tn(){}function Ln(n,t,r){this.__wrapped__=n,this.__actions__=r||[],\r\nthis.__chain__=!!t}function zn(n){this.__wrapped__=n,this.__actions__=[],this.__dir__=1,this.__filtered__=false,this.__iteratees__=[],this.__takeCount__=Ru,this.__views__=[]}function Bn(){this.__data__={}}function Dn(n){var t=n?n.length:0;for(this.data={hash:gu(null),set:new lu};t--;)this.push(n[t])}function Mn(n,t){var r=n.data;return(typeof t=="string"||ge(t)?r.set.has(t):r.hash[t])?0:-1}function qn(n,t){var r=-1,e=n.length;for(t||(t=Be(e));++r<e;)t[r]=n[r];return t}function Pn(n,t){for(var r=-1,e=n.length;++r<e&&false!==t(n[r],r,n););\r\nreturn n}function Zn(n,t){for(var r=-1,e=n.length;++r<e;)if(!t(n[r],r,n))return false;return true}function Yn(n,t){for(var r=-1,e=n.length,u=-1,o=[];++r<e;){var i=n[r];t(i,r,n)&&(o[++u]=i)}return o}function Gn(n,t){for(var r=-1,e=n.length,u=Be(e);++r<e;)u[r]=t(n[r],r,n);return u}function Jn(n,t){for(var r=-1,e=t.length,u=n.length;++r<e;)n[u+r]=t[r];return n}function Xn(n,t,r,e){var u=-1,o=n.length;for(e&&o&&(r=n[++u]);++u<o;)r=t(r,n[u],u,n);return r}function Hn(n,t){for(var r=-1,e=n.length;++r<e;)if(t(n[r],r,n))return true;\r\nreturn false}function Qn(n,t,r,e){return n!==w&&nu.call(e,r)?n:t}function nt(n,t,r){for(var e=-1,u=zo(t),o=u.length;++e<o;){var i=u[e],f=n[i],a=r(f,t[i],i,n,t);(a===a?a===f:f!==f)&&(f!==w||i in n)||(n[i]=a)}return n}function tt(n,t){return null==t?n:et(t,zo(t),n)}function rt(n,t){for(var r=-1,e=null==n,u=!e&&Er(n),o=u?n.length:0,i=t.length,f=Be(i);++r<i;){var a=t[r];f[r]=u?Cr(a,o)?n[a]:w:e?w:n[a]}return f}function et(n,t,r){r||(r={});for(var e=-1,u=t.length;++e<u;){var o=t[e];r[o]=n[o]}return r}function ut(n,t,r){\r\nvar e=typeof n;return"function"==e?t===w?n:Bt(n,t,r):null==n?Fe:"object"==e?bt(n):t===w?ze(n):xt(n,t)}function ot(n,t,r,e,u,o,i){var f;if(r&&(f=u?r(n,e,u):r(n)),f!==w)return f;if(!ge(n))return n;if(e=Oo(n)){if(f=kr(n),!t)return qn(n,f)}else{var a=ru.call(n),c=a==K;if(a!=Z&&a!=B&&(!c||u))return Fn[a]?Rr(n,a,t):u?n:{};if(f=Ir(c?{}:n),!t)return tt(f,n)}for(o||(o=[]),i||(i=[]),u=o.length;u--;)if(o[u]==n)return i[u];return o.push(n),i.push(f),(e?Pn:_t)(n,function(e,u){f[u]=ot(e,t,r,u,n,o,i)}),f}function it(n,t,r){\r\nif(typeof n!="function")throw new Ge(L);return su(function(){n.apply(w,r)},t)}function ft(n,t){var e=n?n.length:0,u=[];if(!e)return u;var o=-1,i=xr(),f=i==r,a=f&&t.length>=F&&gu&&lu?new Dn(t):null,c=t.length;a&&(i=Mn,f=false,t=a);n:for(;++o<e;)if(a=n[o],f&&a===a){for(var l=c;l--;)if(t[l]===a)continue n;u.push(a)}else 0>i(t,a,0)&&u.push(a);return u}function at(n,t){var r=true;return Su(n,function(n,e,u){return r=!!t(n,e,u)}),r}function ct(n,t,r,e){var u=e,o=u;return Su(n,function(n,i,f){i=+t(n,i,f),(r(i,u)||i===e&&i===o)&&(u=i,\r\no=n)}),o}function lt(n,t){var r=[];return Su(n,function(n,e,u){t(n,e,u)&&r.push(n)}),r}function st(n,t,r,e){var u;return r(n,function(n,r,o){return t(n,r,o)?(u=e?r:n,false):void 0}),u}function pt(n,t,r,e){e||(e=[]);for(var u=-1,o=n.length;++u<o;){var i=n[u];h(i)&&Er(i)&&(r||Oo(i)||pe(i))?t?pt(i,t,r,e):Jn(e,i):r||(e[e.length]=i)}return e}function ht(n,t){Nu(n,t,Re)}function _t(n,t){return Nu(n,t,zo)}function vt(n,t){return Tu(n,t,zo)}function gt(n,t){for(var r=-1,e=t.length,u=-1,o=[];++r<e;){var i=t[r];\r\nve(n[i])&&(o[++u]=i)}return o}function yt(n,t,r){if(null!=n){r!==w&&r in Br(n)&&(t=[r]),r=0;for(var e=t.length;null!=n&&r<e;)n=n[t[r++]];return r&&r==e?n:w}}function dt(n,t,r,e,u,o){if(n===t)n=true;else if(null==n||null==t||!ge(n)&&!h(t))n=n!==n&&t!==t;else n:{var i=dt,f=Oo(n),a=Oo(t),c=D,l=D;f||(c=ru.call(n),c==B?c=Z:c!=Z&&(f=xe(n))),a||(l=ru.call(t),l==B?l=Z:l!=Z&&xe(t));var s=c==Z,a=l==Z,l=c==l;if(!l||f||s){if(!e&&(c=s&&nu.call(n,"__wrapped__"),a=a&&nu.call(t,"__wrapped__"),c||a)){n=i(c?n.value():n,a?t.value():t,r,e,u,o);\r\nbreak n}if(l){for(u||(u=[]),o||(o=[]),c=u.length;c--;)if(u[c]==n){n=o[c]==t;break n}u.push(n),o.push(t),n=(f?yr:mr)(n,t,i,r,e,u,o),u.pop(),o.pop()}else n=false}else n=dr(n,t,c)}return n}function mt(n,t,r){var e=t.length,u=e,o=!r;if(null==n)return!u;for(n=Br(n);e--;){var i=t[e];if(o&&i[2]?i[1]!==n[i[0]]:!(i[0]in n))return false}for(;++e<u;){var i=t[e],f=i[0],a=n[f],c=i[1];if(o&&i[2]){if(a===w&&!(f in n))return false}else if(i=r?r(a,c,f):w,i===w?!dt(c,a,r,true):!i)return false}return true}function wt(n,t){var r=-1,e=Er(n)?Be(n.length):[];\r\nreturn Su(n,function(n,u,o){e[++r]=t(n,u,o)}),e}function bt(n){var t=Ar(n);if(1==t.length&&t[0][2]){var r=t[0][0],e=t[0][1];return function(n){return null==n?false:n[r]===e&&(e!==w||r in Br(n))}}return function(n){return mt(n,t)}}function xt(n,t){var r=Oo(n),e=Wr(n)&&t===t&&!ge(t),u=n+"";return n=Dr(n),function(o){if(null==o)return false;var i=u;if(o=Br(o),!(!r&&e||i in o)){if(o=1==n.length?o:yt(o,Et(n,0,-1)),null==o)return false;i=Zr(n),o=Br(o)}return o[i]===t?t!==w||i in o:dt(t,o[i],w,true)}}function At(n,t,r,e,u){\r\nif(!ge(n))return n;var o=Er(t)&&(Oo(t)||xe(t)),i=o?w:zo(t);return Pn(i||t,function(f,a){if(i&&(a=f,f=t[a]),h(f)){e||(e=[]),u||(u=[]);n:{for(var c=a,l=e,s=u,p=l.length,_=t[c];p--;)if(l[p]==_){n[c]=s[p];break n}var p=n[c],v=r?r(p,_,c,n,t):w,g=v===w;g&&(v=_,Er(_)&&(Oo(_)||xe(_))?v=Oo(p)?p:Er(p)?qn(p):[]:me(_)||pe(_)?v=pe(p)?ke(p):me(p)?p:{}:g=false),l.push(_),s.push(v),g?n[c]=At(v,_,r,l,s):(v===v?v!==p:p===p)&&(n[c]=v)}}else c=n[a],l=r?r(c,f,a,n,t):w,(s=l===w)&&(l=f),l===w&&(!o||a in n)||!s&&(l===l?l===c:c!==c)||(n[a]=l);\r\n}),n}function jt(n){return function(t){return null==t?w:t[n]}}function kt(n){var t=n+"";return n=Dr(n),function(r){return yt(r,n,t)}}function It(n,t){for(var r=n?t.length:0;r--;){var e=t[r];if(e!=u&&Cr(e)){var u=e;pu.call(n,e,1)}}}function Rt(n,t){return n+yu(ku()*(t-n+1))}function Ot(n,t,r,e,u){return u(n,function(n,u,o){r=e?(e=false,n):t(r,n,u,o)}),r}function Et(n,t,r){var e=-1,u=n.length;for(t=null==t?0:+t||0,0>t&&(t=-t>u?0:u+t),r=r===w||r>u?u:+r||0,0>r&&(r+=u),u=t>r?0:r-t>>>0,t>>>=0,r=Be(u);++e<u;)r[e]=n[e+t];\r\nreturn r}function Ct(n,t){var r;return Su(n,function(n,e,u){return r=t(n,e,u),!r}),!!r}function Ut(n,t){var r=n.length;for(n.sort(t);r--;)n[r]=n[r].c;return n}function Wt(t,r,e){var u=wr(),o=-1;return r=Gn(r,function(n){return u(n)}),t=wt(t,function(n){return{a:Gn(r,function(t){return t(n)}),b:++o,c:n}}),Ut(t,function(t,r){var u;n:{for(var o=-1,i=t.a,f=r.a,a=i.length,c=e.length;++o<a;)if(u=n(i[o],f[o])){if(o>=c)break n;o=e[o],u*="asc"===o||true===o?1:-1;break n}u=t.b-r.b}return u})}function $t(n,t){\r\nvar r=0;return Su(n,function(n,e,u){r+=+t(n,e,u)||0}),r}function St(n,t){var e=-1,u=xr(),o=n.length,i=u==r,f=i&&o>=F,a=f&&gu&&lu?new Dn(void 0):null,c=[];a?(u=Mn,i=false):(f=false,a=t?[]:c);n:for(;++e<o;){var l=n[e],s=t?t(l,e,n):l;if(i&&l===l){for(var p=a.length;p--;)if(a[p]===s)continue n;t&&a.push(s),c.push(l)}else 0>u(a,s,0)&&((t||f)&&a.push(s),c.push(l))}return c}function Ft(n,t){for(var r=-1,e=t.length,u=Be(e);++r<e;)u[r]=n[t[r]];return u}function Nt(n,t,r,e){for(var u=n.length,o=e?u:-1;(e?o--:++o<u)&&t(n[o],o,n););\r\nreturn r?Et(n,e?0:o,e?o+1:u):Et(n,e?o+1:0,e?u:o)}function Tt(n,t){var r=n;r instanceof zn&&(r=r.value());for(var e=-1,u=t.length;++e<u;)var o=t[e],r=o.func.apply(o.thisArg,Jn([r],o.args));return r}function Lt(n,t,r){var e=0,u=n?n.length:e;if(typeof t=="number"&&t===t&&u<=Eu){for(;e<u;){var o=e+u>>>1,i=n[o];(r?i<=t:i<t)&&null!==i?e=o+1:u=o}return u}return zt(n,t,Fe,r)}function zt(n,t,r,e){t=r(t);for(var u=0,o=n?n.length:0,i=t!==t,f=null===t,a=t===w;u<o;){var c=yu((u+o)/2),l=r(n[c]),s=l!==w,p=l===l;\r\n(i?p||e:f?p&&s&&(e||null!=l):a?p&&(e||s):null==l?0:e?l<=t:l<t)?u=c+1:o=c}return xu(o,Ou)}function Bt(n,t,r){if(typeof n!="function")return Fe;if(t===w)return n;switch(r){case 1:return function(r){return n.call(t,r)};case 3:return function(r,e,u){return n.call(t,r,e,u)};case 4:return function(r,e,u,o){return n.call(t,r,e,u,o)};case 5:return function(r,e,u,o,i){return n.call(t,r,e,u,o,i)}}return function(){return n.apply(t,arguments)}}function Dt(n){var t=new ou(n.byteLength);return new hu(t).set(new hu(n)),\r\nt}function Mt(n,t,r){for(var e=r.length,u=-1,o=bu(n.length-e,0),i=-1,f=t.length,a=Be(f+o);++i<f;)a[i]=t[i];for(;++u<e;)a[r[u]]=n[u];for(;o--;)a[i++]=n[u++];return a}function qt(n,t,r){for(var e=-1,u=r.length,o=-1,i=bu(n.length-u,0),f=-1,a=t.length,c=Be(i+a);++o<i;)c[o]=n[o];for(i=o;++f<a;)c[i+f]=t[f];for(;++e<u;)c[i+r[e]]=n[o++];return c}function Pt(n,t){return function(r,e,u){var o=t?t():{};if(e=wr(e,u,3),Oo(r)){u=-1;for(var i=r.length;++u<i;){var f=r[u];n(o,f,e(f,u,r),r)}}else Su(r,function(t,r,u){\r\nn(o,t,e(t,r,u),u)});return o}}function Kt(n){return le(function(t,r){var e=-1,u=null==t?0:r.length,o=2<u?r[u-2]:w,i=2<u?r[2]:w,f=1<u?r[u-1]:w;for(typeof o=="function"?(o=Bt(o,f,5),u-=2):(o=typeof f=="function"?f:w,u-=o?1:0),i&&Ur(r[0],r[1],i)&&(o=3>u?w:o,u=1);++e<u;)(i=r[e])&&n(t,i,o);return t})}function Vt(n,t){return function(r,e){var u=r?Bu(r):0;if(!Sr(u))return n(r,e);for(var o=t?u:-1,i=Br(r);(t?o--:++o<u)&&false!==e(i[o],o,i););return r}}function Zt(n){return function(t,r,e){var u=Br(t);e=e(t);for(var o=e.length,i=n?o:-1;n?i--:++i<o;){\r\nvar f=e[i];if(false===r(u[f],f,u))break}return t}}function Yt(n,t){function r(){return(this&&this!==Kn&&this instanceof r?e:n).apply(t,arguments)}var e=Jt(n);return r}function Gt(n){return function(t){var r=-1;t=$e(Ce(t));for(var e=t.length,u="";++r<e;)u=n(u,t[r],r);return u}}function Jt(n){return function(){var t=arguments;switch(t.length){case 0:return new n;case 1:return new n(t[0]);case 2:return new n(t[0],t[1]);case 3:return new n(t[0],t[1],t[2]);case 4:return new n(t[0],t[1],t[2],t[3]);case 5:\r\nreturn new n(t[0],t[1],t[2],t[3],t[4]);case 6:return new n(t[0],t[1],t[2],t[3],t[4],t[5]);case 7:return new n(t[0],t[1],t[2],t[3],t[4],t[5],t[6])}var r=$u(n.prototype),t=n.apply(r,t);return ge(t)?t:r}}function Xt(n){function t(r,e,u){return u&&Ur(r,e,u)&&(e=w),r=gr(r,n,w,w,w,w,w,e),r.placeholder=t.placeholder,r}return t}function Ht(n,t){return le(function(r){var e=r[0];return null==e?e:(r.push(t),n.apply(w,r))})}function Qt(n,t){return function(r,e,u){if(u&&Ur(r,e,u)&&(e=w),e=wr(e,u,3),1==e.length){\r\nu=r=Oo(r)?r:zr(r);for(var o=e,i=-1,f=u.length,a=t,c=a;++i<f;){var l=u[i],s=+o(l);n(s,a)&&(a=s,c=l)}if(u=c,!r.length||u!==t)return u}return ct(r,e,n,t)}}function nr(n,r){return function(e,u,o){return u=wr(u,o,3),Oo(e)?(u=t(e,u,r),-1<u?e[u]:w):st(e,u,n)}}function tr(n){return function(r,e,u){return r&&r.length?(e=wr(e,u,3),t(r,e,n)):-1}}function rr(n){return function(t,r,e){return r=wr(r,e,3),st(t,r,n,true)}}function er(n){return function(){for(var t,r=arguments.length,e=n?r:-1,u=0,o=Be(r);n?e--:++e<r;){\r\nvar i=o[u++]=arguments[e];if(typeof i!="function")throw new Ge(L);!t&&Ln.prototype.thru&&"wrapper"==br(i)&&(t=new Ln([],true))}for(e=t?-1:r;++e<r;){var i=o[e],u=br(i),f="wrapper"==u?zu(i):w;t=f&&$r(f[0])&&f[1]==(E|k|R|C)&&!f[4].length&&1==f[9]?t[br(f[0])].apply(t,f[3]):1==i.length&&$r(i)?t[u]():t.thru(i)}return function(){var n=arguments,e=n[0];if(t&&1==n.length&&Oo(e)&&e.length>=F)return t.plant(e).value();for(var u=0,n=r?o[u].apply(this,n):e;++u<r;)n=o[u].call(this,n);return n}}}function ur(n,t){\r\nreturn function(r,e,u){return typeof e=="function"&&u===w&&Oo(r)?n(r,e):t(r,Bt(e,u,3))}}function or(n){return function(t,r,e){return(typeof r!="function"||e!==w)&&(r=Bt(r,e,3)),n(t,r,Re)}}function ir(n){return function(t,r,e){return(typeof r!="function"||e!==w)&&(r=Bt(r,e,3)),n(t,r)}}function fr(n){return function(t,r,e){var u={};return r=wr(r,e,3),_t(t,function(t,e,o){o=r(t,e,o),e=n?o:e,t=n?t:o,u[e]=t}),u}}function ar(n){return function(t,r,e){return t=u(t),(n?t:"")+pr(t,r,e)+(n?"":t)}}function cr(n){\r\nvar t=le(function(r,e){var u=v(e,t.placeholder);return gr(r,n,w,e,u)});return t}function lr(n,t){return function(r,e,u,o){var i=3>arguments.length;return typeof e=="function"&&o===w&&Oo(r)?n(r,e,u,i):Ot(r,wr(e,o,4),u,i,t)}}function sr(n,t,r,e,u,o,i,f,a,c){function l(){for(var m=arguments.length,b=m,j=Be(m);b--;)j[b]=arguments[b];if(e&&(j=Mt(j,e,u)),o&&(j=qt(j,o,i)),_||y){var b=l.placeholder,k=v(j,b),m=m-k.length;if(m<c){var I=f?qn(f):w,m=bu(c-m,0),E=_?k:w,k=_?w:k,C=_?j:w,j=_?w:j;return t|=_?R:O,t&=~(_?O:R),\r\ng||(t&=~(x|A)),j=[n,t,r,C,E,j,k,I,a,m],I=sr.apply(w,j),$r(n)&&Du(I,j),I.placeholder=b,I}}if(b=p?r:this,I=h?b[n]:n,f)for(m=j.length,E=xu(f.length,m),k=qn(j);E--;)C=f[E],j[E]=Cr(C,m)?k[C]:w;return s&&a<j.length&&(j.length=a),this&&this!==Kn&&this instanceof l&&(I=d||Jt(n)),I.apply(b,j)}var s=t&E,p=t&x,h=t&A,_=t&k,g=t&j,y=t&I,d=h?w:Jt(n);return l}function pr(n,t,r){return n=n.length,t=+t,n<t&&mu(t)?(t-=n,r=null==r?" ":r+"",Ue(r,vu(t/r.length)).slice(0,t)):""}function hr(n,t,r,e){function u(){for(var t=-1,f=arguments.length,a=-1,c=e.length,l=Be(c+f);++a<c;)l[a]=e[a];\r\nfor(;f--;)l[a++]=arguments[++t];return(this&&this!==Kn&&this instanceof u?i:n).apply(o?r:this,l)}var o=t&x,i=Jt(n);return u}function _r(n){var t=Pe[n];return function(n,r){return(r=r===w?0:+r||0)?(r=au(10,r),t(n*r)/r):t(n)}}function vr(n){return function(t,r,e,u){var o=wr(e);return null==e&&o===ut?Lt(t,r,n):zt(t,r,o(e,u,1),n)}}function gr(n,t,r,e,u,o,i,f){var a=t&A;if(!a&&typeof n!="function")throw new Ge(L);var c=e?e.length:0;if(c||(t&=~(R|O),e=u=w),c-=u?u.length:0,t&O){var l=e,s=u;e=u=w}var p=a?w:zu(n);\r\nreturn r=[n,t,r,e,u,l,s,o,i,f],p&&(e=r[1],t=p[1],f=e|t,u=t==E&&e==k||t==E&&e==C&&r[7].length<=p[8]||t==(E|C)&&e==k,(f<E||u)&&(t&x&&(r[2]=p[2],f|=e&x?0:j),(e=p[3])&&(u=r[3],r[3]=u?Mt(u,e,p[4]):qn(e),r[4]=u?v(r[3],z):qn(p[4])),(e=p[5])&&(u=r[5],r[5]=u?qt(u,e,p[6]):qn(e),r[6]=u?v(r[5],z):qn(p[6])),(e=p[7])&&(r[7]=qn(e)),t&E&&(r[8]=null==r[8]?p[8]:xu(r[8],p[8])),null==r[9]&&(r[9]=p[9]),r[0]=p[0],r[1]=f),t=r[1],f=r[9]),r[9]=null==f?a?0:n.length:bu(f-c,0)||0,(p?Lu:Du)(t==x?Yt(r[0],r[2]):t!=R&&t!=(x|R)||r[4].length?sr.apply(w,r):hr.apply(w,r),r);\r\n}function yr(n,t,r,e,u,o,i){var f=-1,a=n.length,c=t.length;if(a!=c&&(!u||c<=a))return false;for(;++f<a;){var l=n[f],c=t[f],s=e?e(u?c:l,u?l:c,f):w;if(s!==w){if(s)continue;return false}if(u){if(!Hn(t,function(n){return l===n||r(l,n,e,u,o,i)}))return false}else if(l!==c&&!r(l,c,e,u,o,i))return false}return true}function dr(n,t,r){switch(r){case M:case q:return+n==+t;case P:return n.name==t.name&&n.message==t.message;case V:return n!=+n?t!=+t:n==+t;case Y:case G:return n==t+""}return false}function mr(n,t,r,e,u,o,i){var f=zo(n),a=f.length,c=zo(t).length;\r\nif(a!=c&&!u)return false;for(c=a;c--;){var l=f[c];if(!(u?l in t:nu.call(t,l)))return false}for(var s=u;++c<a;){var l=f[c],p=n[l],h=t[l],_=e?e(u?h:p,u?p:h,l):w;if(_===w?!r(p,h,e,u,o,i):!_)return false;s||(s="constructor"==l)}return s||(r=n.constructor,e=t.constructor,!(r!=e&&"constructor"in n&&"constructor"in t)||typeof r=="function"&&r instanceof r&&typeof e=="function"&&e instanceof e)?true:false}function wr(n,t,r){var e=Nn.callback||Se,e=e===Se?ut:e;return r?e(n,t,r):e}function br(n){for(var t=n.name,r=Wu[t],e=r?r.length:0;e--;){\r\nvar u=r[e],o=u.func;if(null==o||o==n)return u.name}return t}function xr(n,t,e){var u=Nn.indexOf||Vr,u=u===Vr?r:u;return n?u(n,t,e):u}function Ar(n){n=Oe(n);for(var t=n.length;t--;){var r=n[t][1];n[t][2]=r===r&&!ge(r)}return n}function jr(n,t){var r=null==n?w:n[t];return ye(r)?r:w}function kr(n){var t=n.length,r=new n.constructor(t);return t&&"string"==typeof n[0]&&nu.call(n,"index")&&(r.index=n.index,r.input=n.input),r}function Ir(n){return n=n.constructor,typeof n=="function"&&n instanceof n||(n=Ve),\r\nnew n}function Rr(n,t,r){var e=n.constructor;switch(t){case J:return Dt(n);case M:case q:return new e(+n);case X:case H:case Q:case nn:case tn:case rn:case en:case un:case on:return t=n.buffer,new e(r?Dt(t):t,n.byteOffset,n.length);case V:case G:return new e(n);case Y:var u=new e(n.source,kn.exec(n));u.lastIndex=n.lastIndex}return u}function Or(n,t,r){return null==n||Wr(t,n)||(t=Dr(t),n=1==t.length?n:yt(n,Et(t,0,-1)),t=Zr(t)),t=null==n?n:n[t],null==t?w:t.apply(n,r)}function Er(n){return null!=n&&Sr(Bu(n));\r\n}function Cr(n,t){return n=typeof n=="number"||On.test(n)?+n:-1,t=null==t?Cu:t,-1<n&&0==n%1&&n<t}function Ur(n,t,r){if(!ge(r))return false;var e=typeof t;return("number"==e?Er(r)&&Cr(t,r.length):"string"==e&&t in r)?(t=r[t],n===n?n===t:t!==t):false}function Wr(n,t){var r=typeof n;return"string"==r&&dn.test(n)||"number"==r?true:Oo(n)?false:!yn.test(n)||null!=t&&n in Br(t)}function $r(n){var t=br(n);return t in zn.prototype?(t=Nn[t],n===t?true:(t=zu(t),!!t&&n===t[0])):false}function Sr(n){return typeof n=="number"&&-1<n&&0==n%1&&n<=Cu;\r\n}function Fr(n,t){return n===w?t:Eo(n,t,Fr)}function Nr(n,t){n=Br(n);for(var r=-1,e=t.length,u={};++r<e;){var o=t[r];o in n&&(u[o]=n[o])}return u}function Tr(n,t){var r={};return ht(n,function(n,e,u){t(n,e,u)&&(r[e]=n)}),r}function Lr(n){for(var t=Re(n),r=t.length,e=r&&n.length,u=!!e&&Sr(e)&&(Oo(n)||pe(n)),o=-1,i=[];++o<r;){var f=t[o];(u&&Cr(f,e)||nu.call(n,f))&&i.push(f)}return i}function zr(n){return null==n?[]:Er(n)?ge(n)?n:Ve(n):Ee(n)}function Br(n){return ge(n)?n:Ve(n)}function Dr(n){if(Oo(n))return n;\r\nvar t=[];return u(n).replace(mn,function(n,r,e,u){t.push(e?u.replace(An,"$1"):r||n)}),t}function Mr(n){return n instanceof zn?n.clone():new Ln(n.__wrapped__,n.__chain__,qn(n.__actions__))}function qr(n,t,r){return n&&n.length?((r?Ur(n,t,r):null==t)&&(t=1),Et(n,0>t?0:t)):[]}function Pr(n,t,r){var e=n?n.length:0;return e?((r?Ur(n,t,r):null==t)&&(t=1),t=e-(+t||0),Et(n,0,0>t?0:t)):[]}function Kr(n){return n?n[0]:w}function Vr(n,t,e){var u=n?n.length:0;if(!u)return-1;if(typeof e=="number")e=0>e?bu(u+e,0):e;else if(e)return e=Lt(n,t),\r\ne<u&&(t===t?t===n[e]:n[e]!==n[e])?e:-1;return r(n,t,e||0)}function Zr(n){var t=n?n.length:0;return t?n[t-1]:w}function Yr(n){return qr(n,1)}function Gr(n,t,e,u){if(!n||!n.length)return[];null!=t&&typeof t!="boolean"&&(u=e,e=Ur(n,t,u)?w:t,t=false);var o=wr();if((null!=e||o!==ut)&&(e=o(e,u,3)),t&&xr()==r){t=e;var i;e=-1,u=n.length;for(var o=-1,f=[];++e<u;){var a=n[e],c=t?t(a,e,n):a;e&&i===c||(i=c,f[++o]=a)}n=f}else n=St(n,e);return n}function Jr(n){if(!n||!n.length)return[];var t=-1,r=0;n=Yn(n,function(n){\r\nreturn Er(n)?(r=bu(n.length,r),true):void 0});for(var e=Be(r);++t<r;)e[t]=Gn(n,jt(t));return e}function Xr(n,t,r){return n&&n.length?(n=Jr(n),null==t?n:(t=Bt(t,r,4),Gn(n,function(n){return Xn(n,t,w,true)}))):[]}function Hr(n,t){var r=-1,e=n?n.length:0,u={};for(!e||t||Oo(n[0])||(t=[]);++r<e;){var o=n[r];t?u[o]=t[r]:o&&(u[o[0]]=o[1])}return u}function Qr(n){return n=Nn(n),n.__chain__=true,n}function ne(n,t,r){return t.call(r,n)}function te(n,t,r){var e=Oo(n)?Zn:at;return r&&Ur(n,t,r)&&(t=w),(typeof t!="function"||r!==w)&&(t=wr(t,r,3)),\r\ne(n,t)}function re(n,t,r){var e=Oo(n)?Yn:lt;return t=wr(t,r,3),e(n,t)}function ee(n,t,r,e){var u=n?Bu(n):0;return Sr(u)||(n=Ee(n),u=n.length),r=typeof r!="number"||e&&Ur(t,r,e)?0:0>r?bu(u+r,0):r||0,typeof n=="string"||!Oo(n)&&be(n)?r<=u&&-1<n.indexOf(t,r):!!u&&-1<xr(n,t,r)}function ue(n,t,r){var e=Oo(n)?Gn:wt;return t=wr(t,r,3),e(n,t)}function oe(n,t,r){if(r?Ur(n,t,r):null==t){n=zr(n);var e=n.length;return 0<e?n[Rt(0,e-1)]:w}r=-1,n=je(n);var e=n.length,u=e-1;for(t=xu(0>t?0:+t||0,e);++r<t;){var e=Rt(r,u),o=n[e];\r\nn[e]=n[r],n[r]=o}return n.length=t,n}function ie(n,t,r){var e=Oo(n)?Hn:Ct;return r&&Ur(n,t,r)&&(t=w),(typeof t!="function"||r!==w)&&(t=wr(t,r,3)),e(n,t)}function fe(n,t){var r;if(typeof t!="function"){if(typeof n!="function")throw new Ge(L);var e=n;n=t,t=e}return function(){return 0<--n&&(r=t.apply(this,arguments)),1>=n&&(t=w),r}}function ae(n,t,r){function e(t,r){r&&iu(r),a=p=h=w,t&&(_=ho(),c=n.apply(s,f),p||a||(f=s=w))}function u(){var n=t-(ho()-l);0>=n||n>t?e(h,a):p=su(u,n)}function o(){e(g,p);\r\n}function i(){if(f=arguments,l=ho(),s=this,h=g&&(p||!y),false===v)var r=y&&!p;else{a||y||(_=l);var e=v-(l-_),i=0>=e||e>v;i?(a&&(a=iu(a)),_=l,c=n.apply(s,f)):a||(a=su(o,e))}return i&&p?p=iu(p):p||t===v||(p=su(u,t)),r&&(i=true,c=n.apply(s,f)),!i||p||a||(f=s=w),c}var f,a,c,l,s,p,h,_=0,v=false,g=true;if(typeof n!="function")throw new Ge(L);if(t=0>t?0:+t||0,true===r)var y=true,g=false;else ge(r)&&(y=!!r.leading,v="maxWait"in r&&bu(+r.maxWait||0,t),g="trailing"in r?!!r.trailing:g);return i.cancel=function(){p&&iu(p),a&&iu(a),\r\n_=0,a=p=h=w},i}function ce(n,t){function r(){var e=arguments,u=t?t.apply(this,e):e[0],o=r.cache;return o.has(u)?o.get(u):(e=n.apply(this,e),r.cache=o.set(u,e),e)}if(typeof n!="function"||t&&typeof t!="function")throw new Ge(L);return r.cache=new ce.Cache,r}function le(n,t){if(typeof n!="function")throw new Ge(L);return t=bu(t===w?n.length-1:+t||0,0),function(){for(var r=arguments,e=-1,u=bu(r.length-t,0),o=Be(u);++e<u;)o[e]=r[t+e];switch(t){case 0:return n.call(this,o);case 1:return n.call(this,r[0],o);\r\ncase 2:return n.call(this,r[0],r[1],o)}for(u=Be(t+1),e=-1;++e<t;)u[e]=r[e];return u[t]=o,n.apply(this,u)}}function se(n,t){return n>t}function pe(n){return h(n)&&Er(n)&&nu.call(n,"callee")&&!cu.call(n,"callee")}function he(n,t,r,e){return e=(r=typeof r=="function"?Bt(r,e,3):w)?r(n,t):w,e===w?dt(n,t,r):!!e}function _e(n){return h(n)&&typeof n.message=="string"&&ru.call(n)==P}function ve(n){return ge(n)&&ru.call(n)==K}function ge(n){var t=typeof n;return!!n&&("object"==t||"function"==t)}function ye(n){\r\nreturn null==n?false:ve(n)?uu.test(Qe.call(n)):h(n)&&Rn.test(n)}function de(n){return typeof n=="number"||h(n)&&ru.call(n)==V}function me(n){var t;if(!h(n)||ru.call(n)!=Z||pe(n)||!(nu.call(n,"constructor")||(t=n.constructor,typeof t!="function"||t instanceof t)))return false;var r;return ht(n,function(n,t){r=t}),r===w||nu.call(n,r)}function we(n){return ge(n)&&ru.call(n)==Y}function be(n){return typeof n=="string"||h(n)&&ru.call(n)==G}function xe(n){return h(n)&&Sr(n.length)&&!!Sn[ru.call(n)]}function Ae(n,t){\r\nreturn n<t}function je(n){var t=n?Bu(n):0;return Sr(t)?t?qn(n):[]:Ee(n)}function ke(n){return et(n,Re(n))}function Ie(n){return gt(n,Re(n))}function Re(n){if(null==n)return[];ge(n)||(n=Ve(n));for(var t=n.length,t=t&&Sr(t)&&(Oo(n)||pe(n))&&t||0,r=n.constructor,e=-1,r=typeof r=="function"&&r.prototype===n,u=Be(t),o=0<t;++e<t;)u[e]=e+"";for(var i in n)o&&Cr(i,t)||"constructor"==i&&(r||!nu.call(n,i))||u.push(i);return u}function Oe(n){n=Br(n);for(var t=-1,r=zo(n),e=r.length,u=Be(e);++t<e;){var o=r[t];\r\nu[t]=[o,n[o]]}return u}function Ee(n){return Ft(n,zo(n))}function Ce(n){return(n=u(n))&&n.replace(En,a).replace(xn,"")}function Ue(n,t){var r="";if(n=u(n),t=+t,1>t||!n||!mu(t))return r;do t%2&&(r+=n),t=yu(t/2),n+=n;while(t);return r}function We(n,t,r){var e=n;return(n=u(n))?(r?Ur(e,t,r):null==t)?n.slice(g(n),y(n)+1):(t+="",n.slice(o(n,t),i(n,t)+1)):n}function $e(n,t,r){return r&&Ur(n,t,r)&&(t=w),n=u(n),n.match(t||Wn)||[]}function Se(n,t,r){return r&&Ur(n,t,r)&&(t=w),h(n)?Ne(n):ut(n,t)}function Fe(n){\r\nreturn n}function Ne(n){return bt(ot(n,true))}function Te(n,t,r){if(null==r){var e=ge(t),u=e?zo(t):w;((u=u&&u.length?gt(t,u):w)?u.length:e)||(u=false,r=t,t=n,n=this)}u||(u=gt(t,zo(t)));var o=true,e=-1,i=ve(n),f=u.length;false===r?o=false:ge(r)&&"chain"in r&&(o=r.chain);for(;++e<f;){r=u[e];var a=t[r];n[r]=a,i&&(n.prototype[r]=function(t){return function(){var r=this.__chain__;if(o||r){var e=n(this.__wrapped__);return(e.__actions__=qn(this.__actions__)).push({func:t,args:arguments,thisArg:n}),e.__chain__=r,e}return t.apply(n,Jn([this.value()],arguments));\r\n}}(a))}return n}function Le(){}function ze(n){return Wr(n)?jt(n):kt(n)}_=_?Vn.defaults(Kn.Object(),_,Vn.pick(Kn,$n)):Kn;var Be=_.Array,De=_.Date,Me=_.Error,qe=_.Function,Pe=_.Math,Ke=_.Number,Ve=_.Object,Ze=_.RegExp,Ye=_.String,Ge=_.TypeError,Je=Be.prototype,Xe=Ve.prototype,He=Ye.prototype,Qe=qe.prototype.toString,nu=Xe.hasOwnProperty,tu=0,ru=Xe.toString,eu=Kn._,uu=Ze("^"+Qe.call(nu).replace(/[\\\\^$.*+?()[\\]{}|]/g,"\\\\$&").replace(/hasOwnProperty|(function).*?(?=\\\\\\()| for .+?(?=\\\\\\])/g,"$1.*?")+"$"),ou=_.ArrayBuffer,iu=_.clearTimeout,fu=_.parseFloat,au=Pe.pow,cu=Xe.propertyIsEnumerable,lu=jr(_,"Set"),su=_.setTimeout,pu=Je.splice,hu=_.Uint8Array,_u=jr(_,"WeakMap"),vu=Pe.ceil,gu=jr(Ve,"create"),yu=Pe.floor,du=jr(Be,"isArray"),mu=_.isFinite,wu=jr(Ve,"keys"),bu=Pe.max,xu=Pe.min,Au=jr(De,"now"),ju=_.parseInt,ku=Pe.random,Iu=Ke.NEGATIVE_INFINITY,Ru=Ke.POSITIVE_INFINITY,Ou=4294967294,Eu=2147483647,Cu=9007199254740991,Uu=_u&&new _u,Wu={};\r\nNn.support={},Nn.templateSettings={escape:_n,evaluate:vn,interpolate:gn,variable:"",imports:{_:Nn}};var $u=function(){function n(){}return function(t){if(ge(t)){n.prototype=t;var r=new n;n.prototype=w}return r||{}}}(),Su=Vt(_t),Fu=Vt(vt,true),Nu=Zt(),Tu=Zt(true),Lu=Uu?function(n,t){return Uu.set(n,t),n}:Fe,zu=Uu?function(n){return Uu.get(n)}:Le,Bu=jt("length"),Du=function(){var n=0,t=0;return function(r,e){var u=ho(),o=S-(u-t);if(t=u,0<o){if(++n>=$)return r}else n=0;return Lu(r,e)}}(),Mu=le(function(n,t){\r\nreturn h(n)&&Er(n)?ft(n,pt(t,false,true)):[]}),qu=tr(),Pu=tr(true),Ku=le(function(n){for(var t=n.length,e=t,u=Be(l),o=xr(),i=o==r,f=[];e--;){var a=n[e]=Er(a=n[e])?a:[];u[e]=i&&120<=a.length&&gu&&lu?new Dn(e&&a):null}var i=n[0],c=-1,l=i?i.length:0,s=u[0];n:for(;++c<l;)if(a=i[c],0>(s?Mn(s,a):o(f,a,0))){for(e=t;--e;){var p=u[e];if(0>(p?Mn(p,a):o(n[e],a,0)))continue n}s&&s.push(a),f.push(a)}return f}),Vu=le(function(t,r){r=pt(r);var e=rt(t,r);return It(t,r.sort(n)),e}),Zu=vr(),Yu=vr(true),Gu=le(function(n){return St(pt(n,false,true));\r\n}),Ju=le(function(n,t){return Er(n)?ft(n,t):[]}),Xu=le(Jr),Hu=le(function(n){var t=n.length,r=2<t?n[t-2]:w,e=1<t?n[t-1]:w;return 2<t&&typeof r=="function"?t-=2:(r=1<t&&typeof e=="function"?(--t,e):w,e=w),n.length=t,Xr(n,r,e)}),Qu=le(function(n){return n=pt(n),this.thru(function(t){t=Oo(t)?t:[Br(t)];for(var r=n,e=-1,u=t.length,o=-1,i=r.length,f=Be(u+i);++e<u;)f[e]=t[e];for(;++o<i;)f[e++]=r[o];return f})}),no=le(function(n,t){return rt(n,pt(t))}),to=Pt(function(n,t,r){nu.call(n,r)?++n[r]:n[r]=1}),ro=nr(Su),eo=nr(Fu,true),uo=ur(Pn,Su),oo=ur(function(n,t){\r\nfor(var r=n.length;r--&&false!==t(n[r],r,n););return n},Fu),io=Pt(function(n,t,r){nu.call(n,r)?n[r].push(t):n[r]=[t]}),fo=Pt(function(n,t,r){n[r]=t}),ao=le(function(n,t,r){var e=-1,u=typeof t=="function",o=Wr(t),i=Er(n)?Be(n.length):[];return Su(n,function(n){var f=u?t:o&&null!=n?n[t]:w;i[++e]=f?f.apply(n,r):Or(n,t,r)}),i}),co=Pt(function(n,t,r){n[r?0:1].push(t)},function(){return[[],[]]}),lo=lr(Xn,Su),so=lr(function(n,t,r,e){var u=n.length;for(e&&u&&(r=n[--u]);u--;)r=t(r,n[u],u,n);return r},Fu),po=le(function(n,t){\r\nif(null==n)return[];var r=t[2];return r&&Ur(t[0],t[1],r)&&(t.length=1),Wt(n,pt(t),[])}),ho=Au||function(){return(new De).getTime()},_o=le(function(n,t,r){var e=x;if(r.length)var u=v(r,_o.placeholder),e=e|R;return gr(n,e,t,r,u)}),vo=le(function(n,t){t=t.length?pt(t):Ie(n);for(var r=-1,e=t.length;++r<e;){var u=t[r];n[u]=gr(n[u],x,n)}return n}),go=le(function(n,t,r){var e=x|A;if(r.length)var u=v(r,go.placeholder),e=e|R;return gr(t,e,n,r,u)}),yo=Xt(k),mo=Xt(I),wo=le(function(n,t){return it(n,1,t)}),bo=le(function(n,t,r){\r\nreturn it(n,t,r)}),xo=er(),Ao=er(true),jo=le(function(n,t){if(t=pt(t),typeof n!="function"||!Zn(t,e))throw new Ge(L);var r=t.length;return le(function(e){for(var u=xu(e.length,r);u--;)e[u]=t[u](e[u]);return n.apply(this,e)})}),ko=cr(R),Io=cr(O),Ro=le(function(n,t){return gr(n,C,w,w,w,pt(t))}),Oo=du||function(n){return h(n)&&Sr(n.length)&&ru.call(n)==D},Eo=Kt(At),Co=Kt(function(n,t,r){return r?nt(n,t,r):tt(n,t)}),Uo=Ht(Co,function(n,t){return n===w?t:n}),Wo=Ht(Eo,Fr),$o=rr(_t),So=rr(vt),Fo=or(Nu),No=or(Tu),To=ir(_t),Lo=ir(vt),zo=wu?function(n){\r\nvar t=null==n?w:n.constructor;return typeof t=="function"&&t.prototype===n||typeof n!="function"&&Er(n)?Lr(n):ge(n)?wu(n):[]}:Lr,Bo=fr(true),Do=fr(),Mo=le(function(n,t){if(null==n)return{};if("function"!=typeof t[0])return t=Gn(pt(t),Ye),Nr(n,ft(Re(n),t));var r=Bt(t[0],t[1],3);return Tr(n,function(n,t,e){return!r(n,t,e)})}),qo=le(function(n,t){return null==n?{}:"function"==typeof t[0]?Tr(n,Bt(t[0],t[1],3)):Nr(n,pt(t))}),Po=Gt(function(n,t,r){return t=t.toLowerCase(),n+(r?t.charAt(0).toUpperCase()+t.slice(1):t);\r\n}),Ko=Gt(function(n,t,r){return n+(r?"-":"")+t.toLowerCase()}),Vo=ar(),Zo=ar(true),Yo=Gt(function(n,t,r){return n+(r?"_":"")+t.toLowerCase()}),Go=Gt(function(n,t,r){return n+(r?" ":"")+(t.charAt(0).toUpperCase()+t.slice(1))}),Jo=le(function(n,t){try{return n.apply(w,t)}catch(r){return _e(r)?r:new Me(r)}}),Xo=le(function(n,t){return function(r){return Or(r,n,t)}}),Ho=le(function(n,t){return function(r){return Or(n,r,t)}}),Qo=_r("ceil"),ni=_r("floor"),ti=Qt(se,Iu),ri=Qt(Ae,Ru),ei=_r("round");return Nn.prototype=Tn.prototype,\r\nLn.prototype=$u(Tn.prototype),Ln.prototype.constructor=Ln,zn.prototype=$u(Tn.prototype),zn.prototype.constructor=zn,Bn.prototype["delete"]=function(n){return this.has(n)&&delete this.__data__[n]},Bn.prototype.get=function(n){return"__proto__"==n?w:this.__data__[n]},Bn.prototype.has=function(n){return"__proto__"!=n&&nu.call(this.__data__,n)},Bn.prototype.set=function(n,t){return"__proto__"!=n&&(this.__data__[n]=t),this},Dn.prototype.push=function(n){var t=this.data;typeof n=="string"||ge(n)?t.set.add(n):t.hash[n]=true;\r\n},ce.Cache=Bn,Nn.after=function(n,t){if(typeof t!="function"){if(typeof n!="function")throw new Ge(L);var r=n;n=t,t=r}return n=mu(n=+n)?n:0,function(){return 1>--n?t.apply(this,arguments):void 0}},Nn.ary=function(n,t,r){return r&&Ur(n,t,r)&&(t=w),t=n&&null==t?n.length:bu(+t||0,0),gr(n,E,w,w,w,w,t)},Nn.assign=Co,Nn.at=no,Nn.before=fe,Nn.bind=_o,Nn.bindAll=vo,Nn.bindKey=go,Nn.callback=Se,Nn.chain=Qr,Nn.chunk=function(n,t,r){t=(r?Ur(n,t,r):null==t)?1:bu(yu(t)||1,1),r=0;for(var e=n?n.length:0,u=-1,o=Be(vu(e/t));r<e;)o[++u]=Et(n,r,r+=t);\r\nreturn o},Nn.compact=function(n){for(var t=-1,r=n?n.length:0,e=-1,u=[];++t<r;){var o=n[t];o&&(u[++e]=o)}return u},Nn.constant=function(n){return function(){return n}},Nn.countBy=to,Nn.create=function(n,t,r){var e=$u(n);return r&&Ur(n,t,r)&&(t=w),t?tt(e,t):e},Nn.curry=yo,Nn.curryRight=mo,Nn.debounce=ae,Nn.defaults=Uo,Nn.defaultsDeep=Wo,Nn.defer=wo,Nn.delay=bo,Nn.difference=Mu,Nn.drop=qr,Nn.dropRight=Pr,Nn.dropRightWhile=function(n,t,r){return n&&n.length?Nt(n,wr(t,r,3),true,true):[]},Nn.dropWhile=function(n,t,r){\r\nreturn n&&n.length?Nt(n,wr(t,r,3),true):[]},Nn.fill=function(n,t,r,e){var u=n?n.length:0;if(!u)return[];for(r&&typeof r!="number"&&Ur(n,t,r)&&(r=0,e=u),u=n.length,r=null==r?0:+r||0,0>r&&(r=-r>u?0:u+r),e=e===w||e>u?u:+e||0,0>e&&(e+=u),u=r>e?0:e>>>0,r>>>=0;r<u;)n[r++]=t;return n},Nn.filter=re,Nn.flatten=function(n,t,r){var e=n?n.length:0;return r&&Ur(n,t,r)&&(t=false),e?pt(n,t):[]},Nn.flattenDeep=function(n){return n&&n.length?pt(n,true):[]},Nn.flow=xo,Nn.flowRight=Ao,Nn.forEach=uo,Nn.forEachRight=oo,Nn.forIn=Fo,\r\nNn.forInRight=No,Nn.forOwn=To,Nn.forOwnRight=Lo,Nn.functions=Ie,Nn.groupBy=io,Nn.indexBy=fo,Nn.initial=function(n){return Pr(n,1)},Nn.intersection=Ku,Nn.invert=function(n,t,r){r&&Ur(n,t,r)&&(t=w),r=-1;for(var e=zo(n),u=e.length,o={};++r<u;){var i=e[r],f=n[i];t?nu.call(o,f)?o[f].push(i):o[f]=[i]:o[f]=i}return o},Nn.invoke=ao,Nn.keys=zo,Nn.keysIn=Re,Nn.map=ue,Nn.mapKeys=Bo,Nn.mapValues=Do,Nn.matches=Ne,Nn.matchesProperty=function(n,t){return xt(n,ot(t,true))},Nn.memoize=ce,Nn.merge=Eo,Nn.method=Xo,Nn.methodOf=Ho,\r\nNn.mixin=Te,Nn.modArgs=jo,Nn.negate=function(n){if(typeof n!="function")throw new Ge(L);return function(){return!n.apply(this,arguments)}},Nn.omit=Mo,Nn.once=function(n){return fe(2,n)},Nn.pairs=Oe,Nn.partial=ko,Nn.partialRight=Io,Nn.partition=co,Nn.pick=qo,Nn.pluck=function(n,t){return ue(n,ze(t))},Nn.property=ze,Nn.propertyOf=function(n){return function(t){return yt(n,Dr(t),t+"")}},Nn.pull=function(){var n=arguments,t=n[0];if(!t||!t.length)return t;for(var r=0,e=xr(),u=n.length;++r<u;)for(var o=0,i=n[r];-1<(o=e(t,i,o));)pu.call(t,o,1);\r\nreturn t},Nn.pullAt=Vu,Nn.range=function(n,t,r){r&&Ur(n,t,r)&&(t=r=w),n=+n||0,r=null==r?1:+r||0,null==t?(t=n,n=0):t=+t||0;var e=-1;t=bu(vu((t-n)/(r||1)),0);for(var u=Be(t);++e<t;)u[e]=n,n+=r;return u},Nn.rearg=Ro,Nn.reject=function(n,t,r){var e=Oo(n)?Yn:lt;return t=wr(t,r,3),e(n,function(n,r,e){return!t(n,r,e)})},Nn.remove=function(n,t,r){var e=[];if(!n||!n.length)return e;var u=-1,o=[],i=n.length;for(t=wr(t,r,3);++u<i;)r=n[u],t(r,u,n)&&(e.push(r),o.push(u));return It(n,o),e},Nn.rest=Yr,Nn.restParam=le,\r\nNn.set=function(n,t,r){if(null==n)return n;var e=t+"";t=null!=n[e]||Wr(t,n)?[e]:Dr(t);for(var e=-1,u=t.length,o=u-1,i=n;null!=i&&++e<u;){var f=t[e];ge(i)&&(e==o?i[f]=r:null==i[f]&&(i[f]=Cr(t[e+1])?[]:{})),i=i[f]}return n},Nn.shuffle=function(n){return oe(n,Ru)},Nn.slice=function(n,t,r){var e=n?n.length:0;return e?(r&&typeof r!="number"&&Ur(n,t,r)&&(t=0,r=e),Et(n,t,r)):[]},Nn.sortBy=function(n,t,r){if(null==n)return[];r&&Ur(n,t,r)&&(t=w);var e=-1;return t=wr(t,r,3),n=wt(n,function(n,r,u){return{a:t(n,r,u),\r\nb:++e,c:n}}),Ut(n,f)},Nn.sortByAll=po,Nn.sortByOrder=function(n,t,r,e){return null==n?[]:(e&&Ur(t,r,e)&&(r=w),Oo(t)||(t=null==t?[]:[t]),Oo(r)||(r=null==r?[]:[r]),Wt(n,t,r))},Nn.spread=function(n){if(typeof n!="function")throw new Ge(L);return function(t){return n.apply(this,t)}},Nn.take=function(n,t,r){return n&&n.length?((r?Ur(n,t,r):null==t)&&(t=1),Et(n,0,0>t?0:t)):[]},Nn.takeRight=function(n,t,r){var e=n?n.length:0;return e?((r?Ur(n,t,r):null==t)&&(t=1),t=e-(+t||0),Et(n,0>t?0:t)):[]},Nn.takeRightWhile=function(n,t,r){\r\nreturn n&&n.length?Nt(n,wr(t,r,3),false,true):[]},Nn.takeWhile=function(n,t,r){return n&&n.length?Nt(n,wr(t,r,3)):[]},Nn.tap=function(n,t,r){return t.call(r,n),n},Nn.throttle=function(n,t,r){var e=true,u=true;if(typeof n!="function")throw new Ge(L);return false===r?e=false:ge(r)&&(e="leading"in r?!!r.leading:e,u="trailing"in r?!!r.trailing:u),ae(n,t,{leading:e,maxWait:+t,trailing:u})},Nn.thru=ne,Nn.times=function(n,t,r){if(n=yu(n),1>n||!mu(n))return[];var e=-1,u=Be(xu(n,4294967295));for(t=Bt(t,r,1);++e<n;)4294967295>e?u[e]=t(e):t(e);\r\nreturn u},Nn.toArray=je,Nn.toPlainObject=ke,Nn.transform=function(n,t,r,e){var u=Oo(n)||xe(n);return t=wr(t,e,4),null==r&&(u||ge(n)?(e=n.constructor,r=u?Oo(n)?new e:[]:$u(ve(e)?e.prototype:w)):r={}),(u?Pn:_t)(n,function(n,e,u){return t(r,n,e,u)}),r},Nn.union=Gu,Nn.uniq=Gr,Nn.unzip=Jr,Nn.unzipWith=Xr,Nn.values=Ee,Nn.valuesIn=function(n){return Ft(n,Re(n))},Nn.where=function(n,t){return re(n,bt(t))},Nn.without=Ju,Nn.wrap=function(n,t){return t=null==t?Fe:t,gr(t,R,w,[n],[])},Nn.xor=function(){for(var n=-1,t=arguments.length;++n<t;){\r\nvar r=arguments[n];if(Er(r))var e=e?Jn(ft(e,r),ft(r,e)):r}return e?St(e):[]},Nn.zip=Xu,Nn.zipObject=Hr,Nn.zipWith=Hu,Nn.backflow=Ao,Nn.collect=ue,Nn.compose=Ao,Nn.each=uo,Nn.eachRight=oo,Nn.extend=Co,Nn.iteratee=Se,Nn.methods=Ie,Nn.object=Hr,Nn.select=re,Nn.tail=Yr,Nn.unique=Gr,Te(Nn,Nn),Nn.add=function(n,t){return(+n||0)+(+t||0)},Nn.attempt=Jo,Nn.camelCase=Po,Nn.capitalize=function(n){return(n=u(n))&&n.charAt(0).toUpperCase()+n.slice(1)},Nn.ceil=Qo,Nn.clone=function(n,t,r,e){return t&&typeof t!="boolean"&&Ur(n,t,r)?t=false:typeof t=="function"&&(e=r,\r\nr=t,t=false),typeof r=="function"?ot(n,t,Bt(r,e,1)):ot(n,t)},Nn.cloneDeep=function(n,t,r){return typeof t=="function"?ot(n,true,Bt(t,r,1)):ot(n,true)},Nn.deburr=Ce,Nn.endsWith=function(n,t,r){n=u(n),t+="";var e=n.length;return r=r===w?e:xu(0>r?0:+r||0,e),r-=t.length,0<=r&&n.indexOf(t,r)==r},Nn.escape=function(n){return(n=u(n))&&hn.test(n)?n.replace(sn,c):n},Nn.escapeRegExp=function(n){return(n=u(n))&&bn.test(n)?n.replace(wn,l):n||"(?:)"},Nn.every=te,Nn.find=ro,Nn.findIndex=qu,Nn.findKey=$o,Nn.findLast=eo,\r\nNn.findLastIndex=Pu,Nn.findLastKey=So,Nn.findWhere=function(n,t){return ro(n,bt(t))},Nn.first=Kr,Nn.floor=ni,Nn.get=function(n,t,r){return n=null==n?w:yt(n,Dr(t),t+""),n===w?r:n},Nn.gt=se,Nn.gte=function(n,t){return n>=t},Nn.has=function(n,t){if(null==n)return false;var r=nu.call(n,t);if(!r&&!Wr(t)){if(t=Dr(t),n=1==t.length?n:yt(n,Et(t,0,-1)),null==n)return false;t=Zr(t),r=nu.call(n,t)}return r||Sr(n.length)&&Cr(t,n.length)&&(Oo(n)||pe(n))},Nn.identity=Fe,Nn.includes=ee,Nn.indexOf=Vr,Nn.inRange=function(n,t,r){\r\nreturn t=+t||0,r===w?(r=t,t=0):r=+r||0,n>=xu(t,r)&&n<bu(t,r)},Nn.isArguments=pe,Nn.isArray=Oo,Nn.isBoolean=function(n){return true===n||false===n||h(n)&&ru.call(n)==M},Nn.isDate=function(n){return h(n)&&ru.call(n)==q},Nn.isElement=function(n){return!!n&&1===n.nodeType&&h(n)&&!me(n)},Nn.isEmpty=function(n){return null==n?true:Er(n)&&(Oo(n)||be(n)||pe(n)||h(n)&&ve(n.splice))?!n.length:!zo(n).length},Nn.isEqual=he,Nn.isError=_e,Nn.isFinite=function(n){return typeof n=="number"&&mu(n)},Nn.isFunction=ve,Nn.isMatch=function(n,t,r,e){\r\nreturn r=typeof r=="function"?Bt(r,e,3):w,mt(n,Ar(t),r)},Nn.isNaN=function(n){return de(n)&&n!=+n},Nn.isNative=ye,Nn.isNull=function(n){return null===n},Nn.isNumber=de,Nn.isObject=ge,Nn.isPlainObject=me,Nn.isRegExp=we,Nn.isString=be,Nn.isTypedArray=xe,Nn.isUndefined=function(n){return n===w},Nn.kebabCase=Ko,Nn.last=Zr,Nn.lastIndexOf=function(n,t,r){var e=n?n.length:0;if(!e)return-1;var u=e;if(typeof r=="number")u=(0>r?bu(e+r,0):xu(r||0,e-1))+1;else if(r)return u=Lt(n,t,true)-1,n=n[u],(t===t?t===n:n!==n)?u:-1;\r\nif(t!==t)return p(n,u,true);for(;u--;)if(n[u]===t)return u;return-1},Nn.lt=Ae,Nn.lte=function(n,t){return n<=t},Nn.max=ti,Nn.min=ri,Nn.noConflict=function(){return Kn._=eu,this},Nn.noop=Le,Nn.now=ho,Nn.pad=function(n,t,r){n=u(n),t=+t;var e=n.length;return e<t&&mu(t)?(e=(t-e)/2,t=yu(e),e=vu(e),r=pr("",e,r),r.slice(0,t)+n+r):n},Nn.padLeft=Vo,Nn.padRight=Zo,Nn.parseInt=function(n,t,r){return(r?Ur(n,t,r):null==t)?t=0:t&&(t=+t),n=We(n),ju(n,t||(In.test(n)?16:10))},Nn.random=function(n,t,r){r&&Ur(n,t,r)&&(t=r=w);\r\nvar e=null==n,u=null==t;return null==r&&(u&&typeof n=="boolean"?(r=n,n=1):typeof t=="boolean"&&(r=t,u=true)),e&&u&&(t=1,u=false),n=+n||0,u?(t=n,n=0):t=+t||0,r||n%1||t%1?(r=ku(),xu(n+r*(t-n+fu("1e-"+((r+"").length-1))),t)):Rt(n,t)},Nn.reduce=lo,Nn.reduceRight=so,Nn.repeat=Ue,Nn.result=function(n,t,r){var e=null==n?w:n[t];return e===w&&(null==n||Wr(t,n)||(t=Dr(t),n=1==t.length?n:yt(n,Et(t,0,-1)),e=null==n?w:n[Zr(t)]),e=e===w?r:e),ve(e)?e.call(n):e},Nn.round=ei,Nn.runInContext=m,Nn.size=function(n){var t=n?Bu(n):0;\r\nreturn Sr(t)?t:zo(n).length},Nn.snakeCase=Yo,Nn.some=ie,Nn.sortedIndex=Zu,Nn.sortedLastIndex=Yu,Nn.startCase=Go,Nn.startsWith=function(n,t,r){return n=u(n),r=null==r?0:xu(0>r?0:+r||0,n.length),n.lastIndexOf(t,r)==r},Nn.sum=function(n,t,r){if(r&&Ur(n,t,r)&&(t=w),t=wr(t,r,3),1==t.length){n=Oo(n)?n:zr(n),r=n.length;for(var e=0;r--;)e+=+t(n[r])||0;n=e}else n=$t(n,t);return n},Nn.template=function(n,t,r){var e=Nn.templateSettings;r&&Ur(n,t,r)&&(t=r=w),n=u(n),t=nt(tt({},r||t),e,Qn),r=nt(tt({},t.imports),e.imports,Qn);\r\nvar o,i,f=zo(r),a=Ft(r,f),c=0;r=t.interpolate||Cn;var l="__p+=\'";r=Ze((t.escape||Cn).source+"|"+r.source+"|"+(r===gn?jn:Cn).source+"|"+(t.evaluate||Cn).source+"|$","g");var p="sourceURL"in t?"//# sourceURL="+t.sourceURL+"\\n":"";if(n.replace(r,function(t,r,e,u,f,a){return e||(e=u),l+=n.slice(c,a).replace(Un,s),r&&(o=true,l+="\'+__e("+r+")+\'"),f&&(i=true,l+="\';"+f+";\\n__p+=\'"),e&&(l+="\'+((__t=("+e+"))==null?\'\':__t)+\'"),c=a+t.length,t}),l+="\';",(t=t.variable)||(l="with(obj){"+l+"}"),l=(i?l.replace(fn,""):l).replace(an,"$1").replace(cn,"$1;"),\r\nl="function("+(t||"obj")+"){"+(t?"":"obj||(obj={});")+"var __t,__p=\'\'"+(o?",__e=_.escape":"")+(i?",__j=Array.prototype.join;function print(){__p+=__j.call(arguments,\'\')}":";")+l+"return __p}",t=Jo(function(){return qe(f,p+"return "+l).apply(w,a)}),t.source=l,_e(t))throw t;return t},Nn.trim=We,Nn.trimLeft=function(n,t,r){var e=n;return(n=u(n))?n.slice((r?Ur(e,t,r):null==t)?g(n):o(n,t+"")):n},Nn.trimRight=function(n,t,r){var e=n;return(n=u(n))?(r?Ur(e,t,r):null==t)?n.slice(0,y(n)+1):n.slice(0,i(n,t+"")+1):n;\r\n},Nn.trunc=function(n,t,r){r&&Ur(n,t,r)&&(t=w);var e=U;if(r=W,null!=t)if(ge(t)){var o="separator"in t?t.separator:o,e="length"in t?+t.length||0:e;r="omission"in t?u(t.omission):r}else e=+t||0;if(n=u(n),e>=n.length)return n;if(e-=r.length,1>e)return r;if(t=n.slice(0,e),null==o)return t+r;if(we(o)){if(n.slice(e).search(o)){var i,f=n.slice(0,e);for(o.global||(o=Ze(o.source,(kn.exec(o)||"")+"g")),o.lastIndex=0;n=o.exec(f);)i=n.index;t=t.slice(0,null==i?e:i)}}else n.indexOf(o,e)!=e&&(o=t.lastIndexOf(o),\r\n-1<o&&(t=t.slice(0,o)));return t+r},Nn.unescape=function(n){return(n=u(n))&&pn.test(n)?n.replace(ln,d):n},Nn.uniqueId=function(n){var t=++tu;return u(n)+t},Nn.words=$e,Nn.all=te,Nn.any=ie,Nn.contains=ee,Nn.eq=he,Nn.detect=ro,Nn.foldl=lo,Nn.foldr=so,Nn.head=Kr,Nn.include=ee,Nn.inject=lo,Te(Nn,function(){var n={};return _t(Nn,function(t,r){Nn.prototype[r]||(n[r]=t)}),n}(),false),Nn.sample=oe,Nn.prototype.sample=function(n){return this.__chain__||null!=n?this.thru(function(t){return oe(t,n)}):oe(this.value());\r\n},Nn.VERSION=b,Pn("bind bindKey curry curryRight partial partialRight".split(" "),function(n){Nn[n].placeholder=Nn}),Pn(["drop","take"],function(n,t){zn.prototype[n]=function(r){var e=this.__filtered__;if(e&&!t)return new zn(this);r=null==r?1:bu(yu(r)||0,0);var u=this.clone();return e?u.__takeCount__=xu(u.__takeCount__,r):u.__views__.push({size:r,type:n+(0>u.__dir__?"Right":"")}),u},zn.prototype[n+"Right"]=function(t){return this.reverse()[n](t).reverse()}}),Pn(["filter","map","takeWhile"],function(n,t){\r\nvar r=t+1,e=r!=T;zn.prototype[n]=function(n,t){var u=this.clone();return u.__iteratees__.push({iteratee:wr(n,t,1),type:r}),u.__filtered__=u.__filtered__||e,u}}),Pn(["first","last"],function(n,t){var r="take"+(t?"Right":"");zn.prototype[n]=function(){return this[r](1).value()[0]}}),Pn(["initial","rest"],function(n,t){var r="drop"+(t?"":"Right");zn.prototype[n]=function(){return this.__filtered__?new zn(this):this[r](1)}}),Pn(["pluck","where"],function(n,t){var r=t?"filter":"map",e=t?bt:ze;zn.prototype[n]=function(n){\r\nreturn this[r](e(n))}}),zn.prototype.compact=function(){return this.filter(Fe)},zn.prototype.reject=function(n,t){return n=wr(n,t,1),this.filter(function(t){return!n(t)})},zn.prototype.slice=function(n,t){n=null==n?0:+n||0;var r=this;return r.__filtered__&&(0<n||0>t)?new zn(r):(0>n?r=r.takeRight(-n):n&&(r=r.drop(n)),t!==w&&(t=+t||0,r=0>t?r.dropRight(-t):r.take(t-n)),r)},zn.prototype.takeRightWhile=function(n,t){return this.reverse().takeWhile(n,t).reverse()},zn.prototype.toArray=function(){return this.take(Ru);\r\n},_t(zn.prototype,function(n,t){var r=/^(?:filter|map|reject)|While$/.test(t),e=/^(?:first|last)$/.test(t),u=Nn[e?"take"+("last"==t?"Right":""):t];u&&(Nn.prototype[t]=function(){function t(n){return e&&i?u(n,1)[0]:u.apply(w,Jn([n],o))}var o=e?[1]:arguments,i=this.__chain__,f=this.__wrapped__,a=!!this.__actions__.length,c=f instanceof zn,l=o[0],s=c||Oo(f);return s&&r&&typeof l=="function"&&1!=l.length&&(c=s=false),l={func:ne,args:[t],thisArg:w},a=c&&!a,e&&!i?a?(f=f.clone(),f.__actions__.push(l),n.call(f)):u.call(w,this.value())[0]:!e&&s?(f=a?f:new zn(this),\r\nf=n.apply(f,o),f.__actions__.push(l),new Ln(f,i)):this.thru(t)})}),Pn("join pop push replace shift sort splice split unshift".split(" "),function(n){var t=(/^(?:replace|split)$/.test(n)?He:Je)[n],r=/^(?:push|sort|unshift)$/.test(n)?"tap":"thru",e=/^(?:join|pop|replace|shift)$/.test(n);Nn.prototype[n]=function(){var n=arguments;return e&&!this.__chain__?t.apply(this.value(),n):this[r](function(r){return t.apply(r,n)})}}),_t(zn.prototype,function(n,t){var r=Nn[t];if(r){var e=r.name;(Wu[e]||(Wu[e]=[])).push({\r\nname:t,func:r})}}),Wu[sr(w,A).name]=[{name:"wrapper",func:w}],zn.prototype.clone=function(){var n=new zn(this.__wrapped__);return n.__actions__=qn(this.__actions__),n.__dir__=this.__dir__,n.__filtered__=this.__filtered__,n.__iteratees__=qn(this.__iteratees__),n.__takeCount__=this.__takeCount__,n.__views__=qn(this.__views__),n},zn.prototype.reverse=function(){if(this.__filtered__){var n=new zn(this);n.__dir__=-1,n.__filtered__=true}else n=this.clone(),n.__dir__*=-1;return n},zn.prototype.value=function(){\r\nvar n,t=this.__wrapped__.value(),r=this.__dir__,e=Oo(t),u=0>r,o=e?t.length:0;n=o;for(var i=this.__views__,f=0,a=-1,c=i.length;++a<c;){var l=i[a],s=l.size;switch(l.type){case"drop":f+=s;break;case"dropRight":n-=s;break;case"take":n=xu(n,f+s);break;case"takeRight":f=bu(f,n-s)}}if(n={start:f,end:n},i=n.start,f=n.end,n=f-i,i=u?f:i-1,f=this.__iteratees__,a=f.length,c=0,l=xu(n,this.__takeCount__),!e||o<F||o==n&&l==n)return Tt(u&&e?t.reverse():t,this.__actions__);e=[];n:for(;n--&&c<l;){for(i+=r,u=-1,o=t[i];++u<a;){\r\nvar p=f[u],s=p.type,p=p.iteratee(o);if(s==T)o=p;else if(!p){if(s==N)continue n;break n}}e[c++]=o}return e},Nn.prototype.chain=function(){return Qr(this)},Nn.prototype.commit=function(){return new Ln(this.value(),this.__chain__)},Nn.prototype.concat=Qu,Nn.prototype.plant=function(n){for(var t,r=this;r instanceof Tn;){var e=Mr(r);t?u.__wrapped__=e:t=e;var u=e,r=r.__wrapped__}return u.__wrapped__=n,t},Nn.prototype.reverse=function(){function n(n){return r&&0>r.__dir__?n:n.reverse()}var t=this.__wrapped__;\r\nif(t instanceof zn){var r=t;return this.__actions__.length&&(r=new zn(this)),r=r.reverse(),r.__actions__.push({func:ne,args:[n],thisArg:w}),new Ln(r,this.__chain__)}return this.thru(n)},Nn.prototype.toString=function(){return this.value()+""},Nn.prototype.run=Nn.prototype.toJSON=Nn.prototype.valueOf=Nn.prototype.value=function(){return Tt(this.__wrapped__,this.__actions__)},Nn.prototype.collect=Nn.prototype.map,Nn.prototype.head=Nn.prototype.first,Nn.prototype.select=Nn.prototype.filter,Nn.prototype.tail=Nn.prototype.rest,\r\nNn}var w,b="3.10.0",x=1,A=2,j=4,k=8,I=16,R=32,O=64,E=128,C=256,U=30,W="...",$=150,S=16,F=200,N=1,T=2,L="Expected a function",z="__lodash_placeholder__",B="[object Arguments]",D="[object Array]",M="[object Boolean]",q="[object Date]",P="[object Error]",K="[object Function]",V="[object Number]",Z="[object Object]",Y="[object RegExp]",G="[object String]",J="[object ArrayBuffer]",X="[object Float32Array]",H="[object Float64Array]",Q="[object Int8Array]",nn="[object Int16Array]",tn="[object Int32Array]",rn="[object Uint8Array]",en="[object Uint8ClampedArray]",un="[object Uint16Array]",on="[object Uint32Array]",fn=/\\b__p\\+=\'\';/g,an=/\\b(__p\\+=)\'\'\\+/g,cn=/(__e\\(.*?\\)|\\b__t\\))\\+\'\';/g,ln=/&(?:amp|lt|gt|quot|#39|#96);/g,sn=/[&<>"\'`]/g,pn=RegExp(ln.source),hn=RegExp(sn.source),_n=/<%-([\\s\\S]+?)%>/g,vn=/<%([\\s\\S]+?)%>/g,gn=/<%=([\\s\\S]+?)%>/g,yn=/\\.|\\[(?:[^[\\]]*|(["\'])(?:(?!\\1)[^\\n\\\\]|\\\\.)*?\\1)\\]/,dn=/^\\w*$/,mn=/[^.[\\]]+|\\[(?:(-?\\d+(?:\\.\\d+)?)|(["\'])((?:(?!\\2)[^\\n\\\\]|\\\\.)*?)\\2)\\]/g,wn=/^[:!,]|[\\\\^$.*+?()[\\]{}|\\/]|(^[0-9a-fA-Fnrtuvx])|([\\n\\r\\u2028\\u2029])/g,bn=RegExp(wn.source),xn=/[\\u0300-\\u036f\\ufe20-\\ufe23]/g,An=/\\\\(\\\\)?/g,jn=/\\$\\{([^\\\\}]*(?:\\\\.[^\\\\}]*)*)\\}/g,kn=/\\w*$/,In=/^0[xX]/,Rn=/^\\[object .+?Constructor\\]$/,On=/^\\d+$/,En=/[\\xc0-\\xd6\\xd8-\\xde\\xdf-\\xf6\\xf8-\\xff]/g,Cn=/($^)/,Un=/[\'\\n\\r\\u2028\\u2029\\\\]/g,Wn=RegExp("[A-Z\\\\xc0-\\\\xd6\\\\xd8-\\\\xde]+(?=[A-Z\\\\xc0-\\\\xd6\\\\xd8-\\\\xde][a-z\\\\xdf-\\\\xf6\\\\xf8-\\\\xff]+)|[A-Z\\\\xc0-\\\\xd6\\\\xd8-\\\\xde]?[a-z\\\\xdf-\\\\xf6\\\\xf8-\\\\xff]+|[A-Z\\\\xc0-\\\\xd6\\\\xd8-\\\\xde]+|[0-9]+","g"),$n="Array ArrayBuffer Date Error Float32Array Float64Array Function Int8Array Int16Array Int32Array Math Number Object RegExp Set String _ clearTimeout isFinite parseFloat parseInt setTimeout TypeError Uint8Array Uint8ClampedArray Uint16Array Uint32Array WeakMap".split(" "),Sn={};\r\nSn[X]=Sn[H]=Sn[Q]=Sn[nn]=Sn[tn]=Sn[rn]=Sn[en]=Sn[un]=Sn[on]=true,Sn[B]=Sn[D]=Sn[J]=Sn[M]=Sn[q]=Sn[P]=Sn[K]=Sn["[object Map]"]=Sn[V]=Sn[Z]=Sn[Y]=Sn["[object Set]"]=Sn[G]=Sn["[object WeakMap]"]=false;var Fn={};Fn[B]=Fn[D]=Fn[J]=Fn[M]=Fn[q]=Fn[X]=Fn[H]=Fn[Q]=Fn[nn]=Fn[tn]=Fn[V]=Fn[Z]=Fn[Y]=Fn[G]=Fn[rn]=Fn[en]=Fn[un]=Fn[on]=true,Fn[P]=Fn[K]=Fn["[object Map]"]=Fn["[object Set]"]=Fn["[object WeakMap]"]=false;var Nn={"\\xc0":"A","\\xc1":"A","\\xc2":"A","\\xc3":"A","\\xc4":"A","\\xc5":"A","\\xe0":"a","\\xe1":"a","\\xe2":"a",\r\n"\\xe3":"a","\\xe4":"a","\\xe5":"a","\\xc7":"C","\\xe7":"c","\\xd0":"D","\\xf0":"d","\\xc8":"E","\\xc9":"E","\\xca":"E","\\xcb":"E","\\xe8":"e","\\xe9":"e","\\xea":"e","\\xeb":"e","\\xcc":"I","\\xcd":"I","\\xce":"I","\\xcf":"I","\\xec":"i","\\xed":"i","\\xee":"i","\\xef":"i","\\xd1":"N","\\xf1":"n","\\xd2":"O","\\xd3":"O","\\xd4":"O","\\xd5":"O","\\xd6":"O","\\xd8":"O","\\xf2":"o","\\xf3":"o","\\xf4":"o","\\xf5":"o","\\xf6":"o","\\xf8":"o","\\xd9":"U","\\xda":"U","\\xdb":"U","\\xdc":"U","\\xf9":"u","\\xfa":"u","\\xfb":"u","\\xfc":"u","\\xdd":"Y",\r\n"\\xfd":"y","\\xff":"y","\\xc6":"Ae","\\xe6":"ae","\\xde":"Th","\\xfe":"th","\\xdf":"ss"},Tn={"&":"&amp;","<":"&lt;",">":"&gt;",\'"\':"&quot;","\'":"&#39;","`":"&#96;"},Ln={"&amp;":"&","&lt;":"<","&gt;":">","&quot;":\'"\',"&#39;":"\'","&#96;":"`"},zn={"function":true,object:true},Bn={0:"x30",1:"x31",2:"x32",3:"x33",4:"x34",5:"x35",6:"x36",7:"x37",8:"x38",9:"x39",A:"x41",B:"x42",C:"x43",D:"x44",E:"x45",F:"x46",a:"x61",b:"x62",c:"x63",d:"x64",e:"x65",f:"x66",n:"x6e",r:"x72",t:"x74",u:"x75",v:"x76",x:"x78"},Dn={"\\\\":"\\\\",\r\n"\'":"\'","\\n":"n","\\r":"r","\\u2028":"u2028","\\u2029":"u2029"},Mn=zn[typeof module]&&module&&!module.nodeType&&module,qn=zn[typeof self]&&self&&self.Object&&self,Pn=zn[typeof window]&&window&&window.Object&&window,Kn=zn[typeof exports]&&exports&&!exports.nodeType&&exports&&Mn&&typeof global=="object"&&global&&global.Object&&global||Pn!==(this&&this.window)&&Pn||qn||this,Vn=m();typeof define=="function"&&typeof define.amd=="object"&&define.amd&& define(\'thirdparty/lodash\',[],function(){return Vn})}).call(this);\n//# sourceURL=/thirdparty/lodash.js'),
eval("/*\r\n * Copyright (c) 2014 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the \"Software\"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n */\r\n\r\n/**\r\n * Implements a jQuery-like event dispatch pattern for non-DOM objects:\r\n *  - Listeners are attached via on()/one() & detached via off()\r\n *  - Listeners can use namespaces for easy removal\r\n *  - Listeners can attach to multiple events at once via a space-separated list\r\n *  - Events are fired via trigger()\r\n *  - The same listener can be attached twice, and will be called twice; but off() will detach all\r\n *    duplicate copies at once ('duplicate' means '===' equality - see http://jsfiddle.net/bf4p29g5/1/)\r\n *\r\n * But it has some important differences from jQuery's non-DOM event mechanism:\r\n *  - More robust to listeners that throw exceptions (other listeners will still be called, and\r\n *    trigger() will still return control to its caller).\r\n *  - Events can be marked deprecated, causing on() to issue warnings\r\n *  - Easier to debug, since the dispatch code is much simpler\r\n *  - Faster, for the same reason\r\n *  - Uses less memory, since $(nonDOMObj).on() leaks memory in jQuery\r\n *  - API is simplified:\r\n *      - Event handlers do not have 'this' set to the event dispatcher object\r\n *      - Event object passed to handlers only has 'type' and 'target' fields\r\n *      - trigger() uses a simpler argument-list signature (like Promise APIs), rather than requiring\r\n *        an Array arg and ignoring additional args\r\n *      - trigger() does not support namespaces\r\n *      - For simplicity, on() does not accept a map of multiple events -> multiple handlers, nor a\r\n *        missing arg standing in for a bare 'return false' handler.\r\n *\r\n * For now, Brackets uses a jQuery patch to ensure $(obj).on() and obj.on() (etc.) are identical\r\n * for any obj that has the EventDispatcher pattern. In the future, this may be deprecated.\r\n *\r\n * To add EventDispatcher methods to any object, call EventDispatcher.makeEventDispatcher(obj).\r\n */\r\ndefine('utils/EventDispatcher',['require','exports','module','thirdparty/lodash'],function (require, exports, module) {\r\n    \"use strict\";\r\n\r\n    var _ = require(\"thirdparty/lodash\");\r\n\r\n    var LEAK_WARNING_THRESHOLD = 15;\r\n\r\n\r\n    /**\r\n     * Split \"event.namespace\" string into its two parts; both parts are optional.\r\n     * @param {string} eventName Event name and/or trailing \".namespace\"\r\n     * @return {!{event:string, ns:string}} Uses \"\" for missing parts.\r\n     */\r\n    function splitNs(eventStr) {\r\n        var dot = eventStr.indexOf(\".\");\r\n        if (dot === -1) {\r\n            return { eventName: eventStr };\r\n        } else {\r\n            return { eventName: eventStr.substring(0, dot), ns: eventStr.substring(dot) };\r\n        }\r\n    }\r\n\r\n\r\n    // These functions are added as mixins to any object by makeEventDispatcher()\r\n\r\n    /**\r\n     * Adds the given handler function to 'events': a space-separated list of one or more event names, each\r\n     * with an optional \".namespace\" (used by off() - see below). If the handler is already listening to this\r\n     * event, a duplicate copy is added.\r\n     * @param {string} events\r\n     * @param {!function(!{type:string, target:!Object}, ...)} fn\r\n     */\r\n    var on = function (events, fn) {\r\n        var eventsList = events.split(/\\s+/).map(splitNs),\r\n            i;\r\n\r\n        if (!fn) {\r\n            throw new Error(\"EventListener.on() called with no listener fn for event '\" + events + \"'\");\r\n        }\r\n\r\n        // Check for deprecation warnings\r\n        if (this._deprecatedEvents) {\r\n            for (i = 0; i < eventsList.length; i++) {\r\n                var deprecation = this._deprecatedEvents[eventsList[i].eventName];\r\n                if (deprecation) {\r\n                    var message = \"Registering for deprecated event '\" + eventsList[i].eventName + \"'.\";\r\n                    if (typeof deprecation === \"string\") {\r\n                        message += \" Instead, use \" + deprecation + \".\";\r\n                    }\r\n                    console.warn(message, new Error().stack);\r\n                }\r\n            }\r\n        }\r\n\r\n        // Attach listener for each event clause\r\n        for (i = 0; i < eventsList.length; i++) {\r\n            var eventName = eventsList[i].eventName;\r\n            if (!this._eventHandlers) {\r\n                this._eventHandlers = {};\r\n            }\r\n            if (!this._eventHandlers[eventName]) {\r\n                this._eventHandlers[eventName] = [];\r\n            }\r\n            eventsList[i].handler = fn;\r\n            this._eventHandlers[eventName].push(eventsList[i]);\r\n\r\n            // Check for suspicious number of listeners being added to one object-event pair\r\n            if (this._eventHandlers[eventName].length > LEAK_WARNING_THRESHOLD) {\r\n                console.error(\"Possible memory leak: \" + this._eventHandlers[eventName].length + \" '\" + eventName + \"' listeners attached to\", this);\r\n            }\r\n        }\r\n\r\n        return this;  // for chaining\r\n    };\r\n\r\n    /**\r\n     * Removes one or more handler functions based on the space-separated 'events' list. Each item in\r\n     * 'events' can be: bare event name, bare .namespace, or event.namespace pair. This yields a set of\r\n     * matching handlers. If 'fn' is ommitted, all these handlers are removed. If 'fn' is provided,\r\n     * only handlers exactly equal to 'fn' are removed (there may still be >1, if duplicates were added).\r\n     * @param {string} events\r\n     * @param {?function(!{type:string, target:!Object}, ...)} fn\r\n     */\r\n    var off = function (events, fn) {\r\n        if (!this._eventHandlers) {\r\n            return this;\r\n        }\r\n\r\n        var eventsList = events.split(/\\s+/).map(splitNs),\r\n            i;\r\n\r\n        var removeAllMatches = function (eventRec, eventName) {\r\n            var handlerList = this._eventHandlers[eventName],\r\n                k;\r\n            if (!handlerList) {\r\n                return;\r\n            }\r\n\r\n            // Walk backwards so it's easy to remove items\r\n            for (k = handlerList.length - 1; k >= 0; k--) {\r\n                // Look at ns & fn only - doRemove() has already taken care of eventName\r\n                if (!eventRec.ns || eventRec.ns === handlerList[k].ns) {\r\n                    var handler = handlerList[k].handler;\r\n                    if (!fn || fn === handler || fn._eventOnceWrapper === handler) {\r\n                        handlerList.splice(k, 1);\r\n                    }\r\n                }\r\n            }\r\n            if (!handlerList.length) {\r\n                delete this._eventHandlers[eventName];\r\n            }\r\n        }.bind(this);\r\n\r\n        var doRemove = function (eventRec) {\r\n            if (eventRec.eventName) {\r\n                // If arg calls out an event name, look at that handler list only\r\n                removeAllMatches(eventRec, eventRec.eventName);\r\n            } else {\r\n                // If arg only gives a namespace, look at handler lists for all events\r\n                _.forEach(this._eventHandlers, function (handlerList, eventName) {\r\n                    removeAllMatches(eventRec, eventName);\r\n                });\r\n            }\r\n        }.bind(this);\r\n\r\n        // Detach listener for each event clause\r\n        // Each clause may be: bare eventname, bare .namespace, full eventname.namespace\r\n        for (i = 0; i < eventsList.length; i++) {\r\n            doRemove(eventsList[i]);\r\n        }\r\n\r\n        return this;  // for chaining\r\n    };\r\n\r\n    /**\r\n     * Attaches a handler so it's only called once (per event in the 'events' list).\r\n     * @param {string} events\r\n     * @param {?function(!{type:string, target:!Object}, ...)} fn\r\n     */\r\n    var one = function (events, fn) {\r\n        // Wrap fn in a self-detaching handler; saved on the original fn so off() can detect it later\r\n        if (!fn._eventOnceWrapper) {\r\n            fn._eventOnceWrapper = function (event) {\r\n                // Note: this wrapper is reused for all attachments of the same fn, so it shouldn't reference\r\n                // anything from the outer closure other than 'fn'\r\n                event.target.off(event.type, fn._eventOnceWrapper);\r\n                fn.apply(this, arguments);\r\n            };\r\n        }\r\n        return this.on(events, fn._eventOnceWrapper);\r\n    };\r\n\r\n    /**\r\n     * Invokes all handlers for the given event (in the order they were added).\r\n     * @param {string} eventName\r\n     * @param {*} ... Any additional args are passed to the event handler after the event object\r\n     */\r\n    var trigger = function (eventName) {\r\n        var event = { type: eventName, target: this },\r\n            handlerList = this._eventHandlers && this._eventHandlers[eventName],\r\n            i;\r\n\r\n        if (!handlerList) {\r\n            return;\r\n        }\r\n\r\n        // Use a clone of the list in case handlers call on()/off() while we're still in the loop\r\n        handlerList = handlerList.slice();\r\n\r\n        // Pass 'event' object followed by any additional args trigger() was given\r\n        var applyArgs = Array.prototype.slice.call(arguments, 1);\r\n        applyArgs.unshift(event);\r\n\r\n        for (i = 0; i < handlerList.length; i++) {\r\n            try {\r\n                // Call one handler\r\n                handlerList[i].handler.apply(null, applyArgs);\r\n            } catch (err) {\r\n                console.error(\"Exception in '\" + eventName + \"' listener on\", this, String(err), err.stack);\r\n                console.assert();  // causes dev tools to pause, just like an uncaught exception\r\n            }\r\n        }\r\n    };\r\n\r\n\r\n    /**\r\n     * Adds the EventDispatcher APIs to the given object: on(), one(), off(), and trigger(). May also be\r\n     * called on a prototype object - each instance will still behave independently.\r\n     * @param {!Object} obj Object to add event-dispatch methods to\r\n     */\r\n    function makeEventDispatcher(obj) {\r\n        $.extend(obj, {\r\n            on: on,\r\n            off: off,\r\n            one: one,\r\n            trigger: trigger,\r\n            _EventDispatcher: true\r\n        });\r\n        // Later, on() may add _eventHandlers: Object.<string, Array.<{event:string, namespace:?string,\r\n        //   handler:!function(!{type:string, target:!Object}, ...)}>> - map from eventName to an array\r\n        //   of handler records\r\n        // Later, markDeprecated() may add _deprecatedEvents: Object.<string, string|boolean> - map from\r\n        //   eventName to deprecation warning info\r\n    }\r\n\r\n    /**\r\n     * Utility for calling on() with an array of arguments to pass to event handlers (rather than a varargs\r\n     * list). makeEventDispatcher() must have previously been called on 'dispatcher'.\r\n     * @param {!Object} dispatcher\r\n     * @param {string} eventName\r\n     * @param {!Array.<*>} argsArray\r\n     */\r\n    function triggerWithArray(dispatcher, eventName, argsArray) {\r\n        var triggerArgs = [eventName].concat(argsArray);\r\n        dispatcher.trigger.apply(dispatcher, triggerArgs);\r\n    }\r\n\r\n    /**\r\n     * Utility for attaching an event handler to an object that has not YET had makeEventDispatcher() called\r\n     * on it, but will in the future. Once 'futureDispatcher' becomes a real event dispatcher, any handlers\r\n     * attached here will be retained.\r\n     *\r\n     * Useful with core modules that have circular dependencies (one module initially gets an empty copy of the\r\n     * other, with no on() API present yet). Unlike other strategies like waiting for htmlReady(), this helper\r\n     * guarantees you won't miss any future events, regardless of how soon the other module finishes init and\r\n     * starts calling trigger().\r\n     *\r\n     * @param {!Object} futureDispatcher\r\n     * @param {string} events\r\n     * @param {?function(!{type:string, target:!Object}, ...)} fn\r\n     */\r\n    function on_duringInit(futureDispatcher, events, fn) {\r\n        on.call(futureDispatcher, events, fn);\r\n    }\r\n\r\n    /**\r\n     * Mark a given event name as deprecated, such that on() will emit warnings when called with it.\r\n     * May be called before makeEventDispatcher(). May be called on a prototype where makeEventDispatcher()\r\n     * is called separately per instance (i.e. in the constructor). Should be called before clients have\r\n     * a chance to start calling on().\r\n     * @param {!Object} obj Event dispatcher object\r\n     * @param {string} eventName Name of deprecated event\r\n     * @param {string=} insteadStr Suggested thing to use instead\r\n     */\r\n    function markDeprecated(obj, eventName, insteadStr) {\r\n        // Mark event as deprecated - on() will emit warnings when called with this event\r\n        if (!obj._deprecatedEvents) {\r\n            obj._deprecatedEvents = {};\r\n        }\r\n        obj._deprecatedEvents[eventName] = insteadStr || true;\r\n    }\r\n\r\n\r\n    exports.makeEventDispatcher = makeEventDispatcher;\r\n    exports.triggerWithArray    = triggerWithArray;\r\n    exports.on_duringInit       = on_duringInit;\r\n    exports.markDeprecated      = markDeprecated;\r\n});\r\n\n//# sourceURL=/utils/EventDispatcher.js"),eval("/*\r\n * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the \"Software\"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\n/**\r\n * Utilities for working with Deferred, Promise, and other asynchronous processes.\r\n */\r\ndefine('utils/Async',['require','exports','module'],function (require, exports, module) {\r\n    \"use strict\";\r\n\r\n    // Further ideas for Async utilities...\r\n    //  - Utilities for blocking UI until a Promise completes?\r\n    //  - A \"SuperDeferred\" could feature some very useful enhancements:\r\n    //     - API for cancellation (non guaranteed, best attempt)\r\n    //     - Easier way to add a timeout clause (withTimeout() wrapper below is more verbose)\r\n    //     - Encapsulate the task kickoff code so you can start it later, e.g. superDeferred.start()\r\n    //  - Deferred/Promise are unable to do anything akin to a 'finally' block. It'd be nice if we\r\n    //    could harvest exceptions across all steps of an async process and pipe them to a handler,\r\n    //    so that we don't leave UI-blocking overlays up forever, etc. But this is hard: we'd have\r\n    //    wrap every async callback (including low-level native ones that don't use [Super]Deferred)\r\n    //    to catch exceptions, and then understand which Deferred(s) the code *would* have resolved/\r\n    //    rejected had it run to completion.\r\n\r\n\r\n    /**\r\n     * Executes a series of tasks in parallel, returning a \"master\" Promise that is resolved once\r\n     * all the tasks have resolved. If one or more tasks fail, behavior depends on the failFast\r\n     * flag:\r\n     *   - If true, the master Promise is rejected as soon as the first task fails. The remaining\r\n     *     tasks continue to completion in the background.\r\n     *   - If false, the master Promise is rejected after all tasks have completed.\r\n     *\r\n     * If nothing fails:          (M = master promise; 1-4 = tasks; d = done; F = fail)\r\n     *  M  ------------d\r\n     *  1 >---d        .\r\n     *  2 >------d     .\r\n     *  3 >---------d  .\r\n     *  4 >------------d\r\n     *\r\n     * With failFast = false:\r\n     *  M  ------------F\r\n     *  1 >---d     .  .\r\n     *  2 >------d  .  .\r\n     *  3 >---------F  .\r\n     *  4 >------------d\r\n     *\r\n     * With failFast = true: -- equivalent to $.when()\r\n     *  M  ---------F\r\n     *  1 >---d     .\r\n     *  2 >------d  .\r\n     *  3 >---------F\r\n     *  4 >------------d   (#4 continues even though master Promise has failed)\r\n     * (Note: if tasks finish synchronously, the behavior is more like failFast=false because you\r\n     * won't get a chance to respond to the master Promise until after all items have been processed)\r\n     *\r\n     * To perform task-specific work after an individual task completes, attach handlers to each\r\n     * Promise before beginProcessItem() returns it.\r\n     *\r\n     * Note: don't use this if individual tasks (or their done/fail handlers) could ever show a user-\r\n     * visible dialog: because they run in parallel, you could show multiple dialogs atop each other.\r\n     *\r\n     * @param {!Array.<*>} items\r\n     * @param {!function(*, number):Promise} beginProcessItem\r\n     * @param {!boolean} failFast\r\n     * @return {$.Promise}\r\n     */\r\n    function doInParallel(items, beginProcessItem, failFast) {\r\n        var promises = [];\r\n        var masterDeferred = new $.Deferred();\r\n\r\n        if (items.length === 0) {\r\n            masterDeferred.resolve();\r\n\r\n        } else {\r\n            var numCompleted = 0;\r\n            var hasFailed = false;\r\n\r\n            items.forEach(function (item, i) {\r\n                var itemPromise = beginProcessItem(item, i);\r\n                promises.push(itemPromise);\r\n\r\n                itemPromise.fail(function () {\r\n                    if (failFast) {\r\n                        masterDeferred.reject();\r\n                    } else {\r\n                        hasFailed = true;\r\n                    }\r\n                });\r\n                itemPromise.always(function () {\r\n                    numCompleted++;\r\n                    if (numCompleted === items.length) {\r\n                        if (hasFailed) {\r\n                            masterDeferred.reject();\r\n                        } else {\r\n                            masterDeferred.resolve();\r\n                        }\r\n                    }\r\n                });\r\n            });\r\n\r\n        }\r\n\r\n        return masterDeferred.promise();\r\n    }\r\n\r\n    /**\r\n     * Executes a series of tasks in serial (task N does not begin until task N-1 has completed).\r\n     * Returns a \"master\" Promise that is resolved once all the tasks have resolved. If one or more\r\n     * tasks fail, behavior depends on the failAndStopFast flag:\r\n     *   - If true, the master Promise is rejected as soon as the first task fails. The remaining\r\n     *     tasks are never started (the serial sequence is stopped).\r\n     *   - If false, the master Promise is rejected after all tasks have completed.\r\n     *\r\n     * If nothing fails:\r\n     *  M  ------------d\r\n     *  1 >---d        .\r\n     *  2     >--d     .\r\n     *  3        >--d  .\r\n     *  4           >--d\r\n     *\r\n     * With failAndStopFast = false:\r\n     *  M  ------------F\r\n     *  1 >---d     .  .\r\n     *  2     >--d  .  .\r\n     *  3        >--F  .\r\n     *  4           >--d\r\n     *\r\n     * With failAndStopFast = true:\r\n     *  M  ---------F\r\n     *  1 >---d     .\r\n     *  2     >--d  .\r\n     *  3        >--F\r\n     *  4          (#4 never runs)\r\n     *\r\n     * To perform task-specific work after an individual task completes, attach handlers to each\r\n     * Promise before beginProcessItem() returns it.\r\n     *\r\n     * @param {!Array.<*>} items\r\n     * @param {!function(*, number):Promise} beginProcessItem\r\n     * @param {!boolean} failAndStopFast\r\n     * @return {$.Promise}\r\n     */\r\n    function doSequentially(items, beginProcessItem, failAndStopFast) {\r\n\r\n        var masterDeferred = new $.Deferred(),\r\n            hasFailed = false;\r\n\r\n        function doItem(i) {\r\n            if (i >= items.length) {\r\n                if (hasFailed) {\r\n                    masterDeferred.reject();\r\n                } else {\r\n                    masterDeferred.resolve();\r\n                }\r\n                return;\r\n            }\r\n\r\n            var itemPromise = beginProcessItem(items[i], i);\r\n\r\n            itemPromise.done(function () {\r\n                doItem(i + 1);\r\n            });\r\n            itemPromise.fail(function () {\r\n                if (failAndStopFast) {\r\n                    masterDeferred.reject();\r\n                    // note: we do NOT process any further items in this case\r\n                } else {\r\n                    hasFailed = true;\r\n                    doItem(i + 1);\r\n                }\r\n            });\r\n        }\r\n\r\n        doItem(0);\r\n\r\n        return masterDeferred.promise();\r\n    }\r\n\r\n    /**\r\n     * Executes a series of synchronous tasks sequentially spread over time-slices less than maxBlockingTime.\r\n     * Processing yields by idleTime between time-slices.\r\n     *\r\n     * @param {!Array.<*>} items\r\n     * @param {!function(*, number)} fnProcessItem  Function that synchronously processes one item\r\n     * @param {number=} maxBlockingTime\r\n     * @param {number=} idleTime\r\n     * @return {$.Promise}\r\n     */\r\n    function doSequentiallyInBackground(items, fnProcessItem, maxBlockingTime, idleTime) {\r\n\r\n        maxBlockingTime = maxBlockingTime || 15;\r\n        idleTime = idleTime || 30;\r\n\r\n        var sliceStartTime = (new Date()).getTime();\r\n\r\n        return doSequentially(items, function (item, i) {\r\n            var result = new $.Deferred();\r\n\r\n            // process the next item\r\n            fnProcessItem(item, i);\r\n\r\n            // if we've exhausted our maxBlockingTime\r\n            if ((new Date()).getTime() - sliceStartTime >= maxBlockingTime) {\r\n                //yield\r\n                window.setTimeout(function () {\r\n                    sliceStartTime = (new Date()).getTime();\r\n                    result.resolve();\r\n                }, idleTime);\r\n            } else {\r\n                //continue processing\r\n                result.resolve();\r\n            }\r\n\r\n            return result;\r\n        }, false);\r\n    }\r\n\r\n    /**\r\n     * Executes a series of tasks in serial (task N does not begin until task N-1 has completed).\r\n     * Returns a \"master\" Promise that is resolved when the first task has resolved. If all tasks\r\n     * fail, the master Promise is rejected.\r\n     *\r\n     * @param {!Array.<*>} items\r\n     * @param {!function(*, number):Promise} beginProcessItem\r\n     * @return {$.Promise}\r\n     */\r\n    function firstSequentially(items, beginProcessItem) {\r\n\r\n        var masterDeferred = new $.Deferred();\r\n\r\n        function doItem(i) {\r\n            if (i >= items.length) {\r\n                masterDeferred.reject();\r\n                return;\r\n            }\r\n\r\n            beginProcessItem(items[i], i)\r\n                .fail(function () {\r\n                    doItem(i + 1);\r\n                })\r\n                .done(function () {\r\n                    masterDeferred.resolve(items[i]);\r\n                });\r\n        }\r\n\r\n        doItem(0);\r\n        return masterDeferred.promise();\r\n    }\r\n\r\n    /**\r\n     * Executes a series of tasks in parallel, saving up error info from any that fail along the way.\r\n     * Returns a Promise that is only resolved/rejected once all tasks are complete. This is\r\n     * essentially a wrapper around doInParallel(..., false).\r\n     *\r\n     * If one or more tasks failed, the entire \"master\" promise is rejected at the end - with one\r\n     * argument: an array objects, one per failed task. Each error object contains:\r\n     *  - item -- the entry in items whose task failed\r\n     *  - error -- the first argument passed to the fail() handler when the task failed\r\n     *\r\n     * @param {!Array.<*>} items\r\n     * @param {!function(*, number):Promise} beginProcessItem\r\n     * @return {$.Promise}\r\n     */\r\n    function doInParallel_aggregateErrors(items, beginProcessItem) {\r\n        var errors = [];\r\n\r\n        var masterDeferred = new $.Deferred();\r\n\r\n        var parallelResult = doInParallel(\r\n            items,\r\n            function (item, i) {\r\n                var itemResult = beginProcessItem(item, i);\r\n                itemResult.fail(function (error) {\r\n                    errors.push({ item: item, error: error });\r\n                });\r\n                return itemResult;\r\n            },\r\n            false\r\n        );\r\n\r\n        parallelResult\r\n            .done(function () {\r\n                masterDeferred.resolve();\r\n            })\r\n            .fail(function () {\r\n                masterDeferred.reject(errors);\r\n            });\r\n\r\n        return masterDeferred.promise();\r\n    }\r\n\r\n    /** Value passed to fail() handlers that have been triggered due to withTimeout()'s timeout */\r\n    var ERROR_TIMEOUT = {};\r\n\r\n    /**\r\n     * Adds timeout-driven termination to a Promise: returns a new Promise that is resolved/rejected when\r\n     * the given original Promise is resolved/rejected, OR is resolved/rejected after the given delay -\r\n     * whichever happens first.\r\n     *\r\n     * If the original Promise is resolved/rejected first, done()/fail() handlers receive arguments\r\n     * piped from the original Promise. If the timeout occurs first instead, then resolve() or\r\n     * fail() (with Async.ERROR_TIMEOUT) is called based on value of resolveTimeout.\r\n     *\r\n     * @param {$.Promise} promise\r\n     * @param {number} timeout\r\n     * @param {boolean=} resolveTimeout If true, then resolve deferred on timeout, otherwise reject. Default is false.\r\n     * @return {$.Promise}\r\n     */\r\n    function withTimeout(promise, timeout, resolveTimeout) {\r\n        var wrapper = new $.Deferred();\r\n\r\n        var timer = window.setTimeout(function () {\r\n            if (resolveTimeout) {\r\n                wrapper.resolve();\r\n            } else {\r\n                wrapper.reject(ERROR_TIMEOUT);\r\n            }\r\n        }, timeout);\r\n        promise.always(function () {\r\n            window.clearTimeout(timer);\r\n        });\r\n\r\n        // If the wrapper was already rejected due to timeout, the Promise's calls to resolve/reject\r\n        // won't do anything\r\n        promise.then(wrapper.resolve, wrapper.reject);\r\n\r\n        return wrapper.promise();\r\n    }\r\n\r\n    /**\r\n     * Allows waiting for all the promises to be either resolved or rejected.\r\n     * Unlike $.when(), it does not call .fail() or .always() handlers on first\r\n     * reject. The caller should take all the precaution to make sure all the\r\n     * promises passed to this function are completed to avoid blocking.\r\n     *\r\n     * If failOnReject is set to true, promise returned by the function will be\r\n     * rejected if at least one of the promises was rejected. The default value\r\n     * is false, which will cause the call to this function to be always\r\n     * successfully resolved.\r\n     *\r\n     * If timeout is specified, the promise will be rejected on timeout as per\r\n     * Async.withTimeout.\r\n     *\r\n     * @param {!Array.<$.Promise>} promises Array of promises to wait for\r\n     * @param {boolean=} failOnReject       Whether to reject or not if one of the promises has been rejected.\r\n     * @param {number=} timeout             Number of milliseconds to wait until rejecting the promise\r\n     *\r\n     * @return {$.Promise} A Promise which will be resolved once all dependent promises are resolved.\r\n     *                     It is resolved with an array of results from the successfully resolved dependent promises.\r\n     *                     The resulting array may not be in the same order or contain as many items as there were\r\n     *                     promises to wait on and it will contain 'undefined' entries for those promises that resolve\r\n     *                     without a result.\r\n     *\r\n     */\r\n    function waitForAll(promises, failOnReject, timeout) {\r\n        var masterDeferred = new $.Deferred(),\r\n            results = [],\r\n            count = 0,\r\n            sawRejects = false;\r\n\r\n        if (!promises || promises.length === 0) {\r\n            masterDeferred.resolve();\r\n            return masterDeferred.promise();\r\n        }\r\n\r\n        // set defaults if needed\r\n        failOnReject = (failOnReject === undefined) ? false : true;\r\n\r\n        if (timeout !== undefined) {\r\n            withTimeout(masterDeferred, timeout);\r\n        }\r\n\r\n        promises.forEach(function (promise) {\r\n            promise\r\n                .fail(function (err) {\r\n                    sawRejects = true;\r\n                })\r\n                .done(function (result) {\r\n                    results.push(result);\r\n                })\r\n                .always(function () {\r\n                    count++;\r\n                    if (count === promises.length) {\r\n                        if (failOnReject && sawRejects) {\r\n                            masterDeferred.reject();\r\n                        } else {\r\n                            masterDeferred.resolve(results);\r\n                        }\r\n                    }\r\n                });\r\n        });\r\n\r\n        return masterDeferred.promise();\r\n    }\r\n\r\n    /**\r\n     * Chains a series of synchronous and asynchronous (jQuery promise-returning) functions\r\n     * together, using the result of each successive function as the argument(s) to the next.\r\n     * A promise is returned that resolves with the result of the final call if all calls\r\n     * resolve or return normally. Otherwise, if any of the functions reject or throw, the\r\n     * computation is halted immediately and the promise is rejected with this halting error.\r\n     *\r\n     * @param {Array.<function(*)>} functions Functions to be chained\r\n     * @param {?Array} args Arguments to call the first function with\r\n     * @return {jQuery.Promise} A promise that resolves with the result of the final call, or\r\n     *      rejects with the first error.\r\n     */\r\n    function chain(functions, args) {\r\n        var deferred = $.Deferred();\r\n\r\n        function chainHelper(index, args) {\r\n            if (functions.length === index) {\r\n                deferred.resolveWith(null, args);\r\n            } else {\r\n                var nextFunction = functions[index++];\r\n                try {\r\n                    var responseOrPromise = nextFunction.apply(null, args);\r\n                    if (responseOrPromise.hasOwnProperty(\"done\") &&\r\n                            responseOrPromise.hasOwnProperty(\"fail\")) {\r\n                        responseOrPromise.done(function () {\r\n                            chainHelper(index, arguments);\r\n                        });\r\n                        responseOrPromise.fail(function () {\r\n                            deferred.rejectWith(null, arguments);\r\n                        });\r\n                    } else {\r\n                        chainHelper(index, [responseOrPromise]);\r\n                    }\r\n                } catch (e) {\r\n                    deferred.reject(e);\r\n                }\r\n            }\r\n        }\r\n\r\n        chainHelper(0, args || []);\r\n\r\n        return deferred.promise();\r\n    }\r\n\r\n    /**\r\n     * Utility for converting a method that takes (error, callback) to one that returns a promise;\r\n     * useful for using FileSystem methods (or other Node-style API methods) in a promise-oriented\r\n     * workflow. For example, instead of\r\n     *\r\n     *      var deferred = new $.Deferred();\r\n     *      file.read(function (err, contents) {\r\n     *          if (err) {\r\n     *              deferred.reject(err);\r\n     *          } else {\r\n     *              // ...process the contents...\r\n     *              deferred.resolve();\r\n     *          }\r\n     *      }\r\n     *      return deferred.promise();\r\n     *\r\n     * you can just do\r\n     *\r\n     *      return Async.promisify(file, \"read\").then(function (contents) {\r\n     *          // ...process the contents...\r\n     *      });\r\n     *\r\n     * The object/method are passed as an object/string pair so that we can\r\n     * properly call the method without the caller having to deal with \"bind\" all the time.\r\n     *\r\n     * @param {Object} obj The object to call the method on.\r\n     * @param {string} method The name of the method. The method should expect the errback\r\n     *      as its last parameter.\r\n     * @param {...Object} varargs The arguments you would have normally passed to the method\r\n     *      (excluding the errback itself).\r\n     * @return {$.Promise} A promise that is resolved with the arguments that were passed to the\r\n     *      errback (not including the err argument) if err is null, or rejected with the err if\r\n     *      non-null.\r\n     */\r\n    function promisify(obj, method) {\r\n        var result = new $.Deferred(),\r\n            args = Array.prototype.slice.call(arguments, 2);\r\n        args.push(function (err) {\r\n            if (err) {\r\n                result.reject(err);\r\n            } else {\r\n                result.resolve.apply(result, Array.prototype.slice.call(arguments, 1));\r\n            }\r\n        });\r\n        obj[method].apply(obj, args);\r\n        return result.promise();\r\n    }\r\n\r\n    /**\r\n     * Creates a queue of async operations that will be executed sequentially. Operations can be added to the\r\n     * queue at any time. If the queue is empty and nothing is currently executing when an operation is added,\r\n     * it will execute immediately. Otherwise, it will execute when the last operation currently in the queue\r\n     * has finished.\r\n     * @constructor\r\n     */\r\n    function PromiseQueue() {\r\n        this._queue = [];\r\n    }\r\n\r\n    /**\r\n     * @private\r\n     * @type {Array.<function(): $.Promise>}\r\n     * The queue of operations to execute sequentially. Note that even if this array is empty, there might\r\n     * still be an operation we need to wait on; that operation's promise is stored in _curPromise.\r\n     */\r\n    PromiseQueue.prototype._queue = null;\r\n\r\n    /**\r\n     * @private\r\n     * @type {$.Promise}\r\n     * The promise we're currently waiting on, or null if there's nothing currently executing.\r\n     */\r\n    PromiseQueue.prototype._curPromise = null;\r\n\r\n    /**\r\n     * @type {number} The number of queued promises.\r\n     */\r\n    Object.defineProperties(PromiseQueue.prototype, {\r\n        \"length\": {\r\n            get: function () { return this._queue.length; },\r\n            set: function () { throw new Error(\"Cannot set length\"); }\r\n        }\r\n    });\r\n\r\n    /**\r\n     * Adds an operation to the queue. If nothing is currently executing, it will execute immediately (and\r\n     * the next operation added to the queue will wait for it to complete). Otherwise, it will wait until\r\n     * the last operation in the queue (or the currently executing operation if nothing is in the queue) is\r\n     * finished. The operation must return a promise that will be resolved or rejected when it's finished;\r\n     * the queue will continue with the next operation regardless of whether the current operation's promise\r\n     * is resolved or rejected.\r\n     * @param {function(): $.Promise} op The operation to add to the queue.\r\n     */\r\n    PromiseQueue.prototype.add = function (op) {\r\n        this._queue.push(op);\r\n\r\n        // If something is currently executing, then _doNext() will get called when it's done. If nothing\r\n        // is executing (in which case the queue should have been empty), we need to call _doNext() to kickstart\r\n        // the queue.\r\n        if (!this._curPromise) {\r\n            this._doNext();\r\n        }\r\n    };\r\n\r\n    /**\r\n     * Removes all pending promises from the queue.\r\n     */\r\n    PromiseQueue.prototype.removeAll = function () {\r\n        this._queue = [];\r\n    };\r\n\r\n    /**\r\n     * @private\r\n     * Pulls the next operation off the queue and executes it.\r\n     */\r\n    PromiseQueue.prototype._doNext = function () {\r\n        var self = this;\r\n        if (this._queue.length) {\r\n            var op = this._queue.shift();\r\n            this._curPromise = op();\r\n            this._curPromise.always(function () {\r\n                self._curPromise = null;\r\n                self._doNext();\r\n            });\r\n        }\r\n    };\r\n\r\n    // Define public API\r\n    exports.doInParallel        = doInParallel;\r\n    exports.doSequentially      = doSequentially;\r\n    exports.doSequentiallyInBackground   = doSequentiallyInBackground;\r\n    exports.doInParallel_aggregateErrors = doInParallel_aggregateErrors;\r\n    exports.firstSequentially   = firstSequentially;\r\n    exports.withTimeout         = withTimeout;\r\n    exports.waitForAll          = waitForAll;\r\n    exports.ERROR_TIMEOUT       = ERROR_TIMEOUT;\r\n    exports.chain               = chain;\r\n    exports.promisify           = promisify;\r\n    exports.PromiseQueue        = PromiseQueue;\r\n});\r\n\n//# sourceURL=/utils/Async.js"),
eval('/*\r\n * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\ndefine(\'utils/UrlParams\',[\'require\',\'exports\',\'module\',\'thirdparty/lodash\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    var _ = require("thirdparty/lodash");\r\n\r\n    /**\r\n     * Convert between URL querystring and name/value pairs. Decodes and encodes URL parameters.\r\n     */\r\n    function UrlParams() {\r\n        this._store = {};\r\n    }\r\n\r\n    /**\r\n     * Parse the window location by default. Optionally specify a URL to parse.\r\n     * @param {string} url\r\n     */\r\n    UrlParams.prototype.parse = function (url) {\r\n        var queryString = "",\r\n            urlParams,\r\n            p,\r\n            self = this;\r\n\r\n        self._store = {};\r\n\r\n        if (!url) {\r\n            queryString = window.document.location.search.substring(1);\r\n        } else if (url.indexOf("?") !== -1) {\r\n            queryString = url.substring(url.indexOf("?") + 1);\r\n        }\r\n\r\n        queryString = queryString.trimRight();\r\n\r\n        if (queryString) {\r\n            urlParams = queryString.split("&");\r\n\r\n            urlParams.forEach(function (param) {\r\n                p = param.split("=");\r\n                p[1] = p[1] || "";\r\n                self._store[decodeURIComponent(p[0])] = decodeURIComponent(p[1]);\r\n            });\r\n        }\r\n    };\r\n\r\n    /**\r\n     * Store a name/value string pair\r\n     * @param {!string} name\r\n     * @param {!string} value\r\n     */\r\n    UrlParams.prototype.put = function (name, value) {\r\n        this._store[name] = value;\r\n    };\r\n\r\n    /**\r\n     * Retrieve a value by name\r\n     * @param {!string} name\r\n     * @return {string}\r\n     */\r\n    UrlParams.prototype.get = function (name) {\r\n        return this._store[name];\r\n    };\r\n\r\n    /**\r\n     * Remove a name/value string pair\r\n     * @param {!string} name\r\n     */\r\n    UrlParams.prototype.remove = function (name) {\r\n        delete this._store[name];\r\n    };\r\n\r\n    /**\r\n     * Returns true if the parameter list is empty, else returns false.\r\n     * @return {boolean}\r\n     */\r\n    UrlParams.prototype.isEmpty = function (name) {\r\n        return _.isEmpty(this._store);\r\n    };\r\n\r\n    /**\r\n     * Encode name/value pairs as URI components.\r\n     * @return {string}\r\n     */\r\n    UrlParams.prototype.toString = function () {\r\n        var strs = [],\r\n            self = this;\r\n\r\n        _.forEach(self._store, function (value, key) {\r\n            strs.push(encodeURIComponent(key) + "=" + encodeURIComponent(value));\r\n        });\r\n\r\n        return strs.join("&");\r\n    };\r\n\r\n    // Define public API\r\n    exports.UrlParams = UrlParams;\r\n});\r\n\n//# sourceURL=/utils/UrlParams.js'),eval('/*\r\n * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\n /**\r\n  * Manages global application commands that can be called from menu items, key bindings, or subparts\r\n  * of the application.\r\n  *\r\n  * This module dispatches these event(s):\r\n  *    - commandRegistered  -- when a new command is registered\r\n  *    - beforeExecuteCommand -- before dispatching a command\r\n  */\r\ndefine(\'command/CommandManager\',[\'require\',\'exports\',\'module\',\'utils/EventDispatcher\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    var EventDispatcher = require("utils/EventDispatcher");\r\n\r\n\r\n    /**\r\n     * Map of all registered global commands\r\n     * @type {Object.<commandID: string, Command>}\r\n     */\r\n    var _commands = {};\r\n\r\n    /**\r\n     * Temporary copy of commands map for restoring after testing\r\n     * TODO (issue #1039): implement separate require contexts for unit tests\r\n     * @type {Object.<commandID: string, Command>}\r\n     */\r\n    var _commandsOriginal = {};\r\n\r\n    /**\r\n     * Events:\r\n     * - enabledStateChange\r\n     * - checkedStateChange\r\n     * - keyBindingAdded\r\n     * - keyBindingRemoved\r\n     *\r\n     * @constructor\r\n     * @private\r\n     * @param {string} name - text that will be displayed in the UI to represent command\r\n     * @param {string} id\r\n     * @param {function} commandFn - the function that is called when the command is executed.\r\n     *\r\n     * TODO: where should this be triggered, The Command or Exports?\r\n     */\r\n    function Command(name, id, commandFn) {\r\n        this._name = name;\r\n        this._id = id;\r\n        this._commandFn = commandFn;\r\n        this._checked = undefined;\r\n        this._enabled = true;\r\n    }\r\n    EventDispatcher.makeEventDispatcher(Command.prototype);\r\n\r\n    /**\r\n     * Get command id\r\n     * @return {string}\r\n     */\r\n    Command.prototype.getID = function () {\r\n        return this._id;\r\n    };\r\n\r\n    /**\r\n     * Executes the command. Additional arguments are passed to the executing function\r\n     *\r\n     * @return {$.Promise} a jQuery promise that will be resolved when the command completes.\r\n     */\r\n    Command.prototype.execute = function () {\r\n        if (!this._enabled) {\r\n            return (new $.Deferred()).reject().promise();\r\n        }\r\n\r\n        var result = this._commandFn.apply(this, arguments);\r\n        if (!result) {\r\n            // If command does not return a promise, assume that it handled the\r\n            // command and return a resolved promise\r\n            return (new $.Deferred()).resolve().promise();\r\n        } else {\r\n            return result;\r\n        }\r\n    };\r\n\r\n    /**\r\n     * Is command enabled?\r\n     * @return {boolean}\r\n     */\r\n    Command.prototype.getEnabled = function () {\r\n        return this._enabled;\r\n    };\r\n\r\n    /**\r\n     * Sets enabled state of Command and dispatches "enabledStateChange"\r\n     * when the enabled state changes.\r\n     * @param {boolean} enabled\r\n     */\r\n    Command.prototype.setEnabled = function (enabled) {\r\n        var changed = this._enabled !== enabled;\r\n        this._enabled = enabled;\r\n\r\n        if (changed) {\r\n            this.trigger("enabledStateChange");\r\n        }\r\n    };\r\n\r\n    /**\r\n     * Sets enabled state of Command and dispatches "checkedStateChange"\r\n     * when the enabled state changes.\r\n     * @param {boolean} checked\r\n     */\r\n    Command.prototype.setChecked = function (checked) {\r\n        var changed = this._checked !== checked;\r\n        this._checked = checked;\r\n\r\n        if (changed) {\r\n            this.trigger("checkedStateChange");\r\n        }\r\n    };\r\n\r\n    /**\r\n     * Is command checked?\r\n     * @return {boolean}\r\n     */\r\n    Command.prototype.getChecked = function () {\r\n        return this._checked;\r\n    };\r\n\r\n    /**\r\n     * Sets the name of the Command and dispatches "nameChange" so that\r\n     * UI that reflects the command name can update.\r\n     *\r\n     * Note, a Command name can appear in either HTML or native UI\r\n     * so HTML tags should not be used. To add a Unicode character,\r\n     * use \\uXXXX instead of an HTML entity.\r\n     *\r\n     * @param {string} name\r\n     */\r\n    Command.prototype.setName = function (name) {\r\n        var changed = this._name !== name;\r\n        this._name = name;\r\n\r\n        if (changed) {\r\n            this.trigger("nameChange");\r\n        }\r\n    };\r\n\r\n    /**\r\n     * Get command name\r\n     * @return {string}\r\n     */\r\n    Command.prototype.getName = function () {\r\n        return this._name;\r\n    };\r\n\r\n\r\n\r\n    /**\r\n     * Registers a global command.\r\n     * @param {string} name - text that will be displayed in the UI to represent command\r\n     * @param {string} id - unique identifier for command.\r\n     *      Core commands in Brackets use a simple command title as an id, for example "open.file".\r\n     *      Extensions should use the following format: "author.myextension.mycommandname".\r\n     *      For example, "lschmitt.csswizard.format.css".\r\n     * @param {function(...)} commandFn - the function to call when the command is executed. Any arguments passed to\r\n     *     execute() (after the id) are passed as arguments to the function. If the function is asynchronous,\r\n     *     it must return a jQuery promise that is resolved when the command completes. Otherwise, the\r\n     *     CommandManager will assume it is synchronous, and return a promise that is already resolved.\r\n     * @return {?Command}\r\n     */\r\n    function register(name, id, commandFn) {\r\n        if (_commands[id]) {\r\n            console.log("Attempting to register an already-registered command: " + id);\r\n            return null;\r\n        }\r\n        if (!name || !id || !commandFn) {\r\n            console.error("Attempting to register a command with a missing name, id, or command function:" + name + " " + id);\r\n            return null;\r\n        }\r\n\r\n        var command = new Command(name, id, commandFn);\r\n        _commands[id] = command;\r\n\r\n        exports.trigger("commandRegistered", command);\r\n\r\n        return command;\r\n    }\r\n\r\n    /**\r\n     * Registers a global internal only command.\r\n     * @param {string} id - unique identifier for command.\r\n     *      Core commands in Brackets use a simple command title as an id, for example "app.abort_quit".\r\n     *      Extensions should use the following format: "author.myextension.mycommandname".\r\n     *      For example, "lschmitt.csswizard.format.css".\r\n     * @param {function(...)} commandFn - the function to call when the command is executed. Any arguments passed to\r\n     *     execute() (after the id) are passed as arguments to the function. If the function is asynchronous,\r\n     *     it must return a jQuery promise that is resolved when the command completes. Otherwise, the\r\n     *     CommandManager will assume it is synchronous, and return a promise that is already resolved.\r\n     * @return {?Command}\r\n     */\r\n    function registerInternal(id, commandFn) {\r\n        if (_commands[id]) {\r\n            console.log("Attempting to register an already-registered command: " + id);\r\n            return null;\r\n        }\r\n        if (!id || !commandFn) {\r\n            console.error("Attempting to register an internal command with a missing id, or command function: " + id);\r\n            return null;\r\n        }\r\n\r\n        var command = new Command(null, id, commandFn);\r\n        _commands[id] = command;\r\n\r\n        exports.trigger("commandRegistered", command);\r\n\r\n        return command;\r\n    }\r\n\r\n    /**\r\n     * Clear all commands for unit testing, but first make copy of commands so that\r\n     * they can be restored afterward\r\n     */\r\n    function _testReset() {\r\n        _commandsOriginal = _commands;\r\n        _commands = {};\r\n    }\r\n\r\n    /**\r\n     * Restore original commands after test and release copy\r\n     */\r\n    function _testRestore() {\r\n        _commands = _commandsOriginal;\r\n        _commandsOriginal = {};\r\n    }\r\n\r\n    /**\r\n     * Retrieves a Command object by id\r\n     * @param {string} id\r\n     * @return {Command}\r\n     */\r\n    function get(id) {\r\n        return _commands[id];\r\n    }\r\n\r\n    /**\r\n     * Returns the ids of all registered commands\r\n     * @return {Array.<string>}\r\n     */\r\n    function getAll() {\r\n        return Object.keys(_commands);\r\n    }\r\n\r\n    /**\r\n     * Looks up and runs a global command. Additional arguments are passed to the command.\r\n     *\r\n     * @param {string} id The ID of the command to run.\r\n     * @return {$.Promise} a jQuery promise that will be resolved when the command completes.\r\n     */\r\n    function execute(id) {\r\n        var command = _commands[id];\r\n\r\n        if (command) {\r\n            try {\r\n                exports.trigger("beforeExecuteCommand", id);\r\n            } catch (err) {\r\n                console.error(err);\r\n            }\r\n\r\n            return command.execute.apply(command, Array.prototype.slice.call(arguments, 1));\r\n        } else {\r\n            return (new $.Deferred()).reject().promise();\r\n        }\r\n    }\r\n\r\n    EventDispatcher.makeEventDispatcher(exports);\r\n\r\n    // Define public API\r\n    exports.register            = register;\r\n    exports.registerInternal    = registerInternal;\r\n    exports.execute             = execute;\r\n    exports.get                 = get;\r\n    exports.getAll              = getAll;\r\n    exports._testReset          = _testReset;\r\n    exports._testRestore        = _testRestore;\r\n});\r\n\n//# sourceURL=/command/CommandManager.js'),eval('/*\r\n * Copyright (c) 2014 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\n/**\r\n *  Utilities functions to display deprecation warning in the console.\r\n *\r\n */\r\ndefine(\'utils/DeprecationWarning\',[\'require\',\'exports\',\'module\',\'utils/EventDispatcher\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    var EventDispatcher = require("utils/EventDispatcher");\r\n\r\n\r\n    var displayedWarnings = {};\r\n\r\n    /**\r\n     * Trim the stack so that it does not have the call to this module,\r\n     * and all the calls to require.js to load the extension that shows\r\n     * this deprecation warning.\r\n     */\r\n    function _trimStack(stack) {\r\n        var indexOfFirstRequireJSline;\r\n\r\n        // Remove everything in the stack up to the end of the line that shows this module file path\r\n        stack = stack.substr(stack.indexOf(")\\n") + 2);\r\n\r\n        // Find the very first line of require.js in the stack if the call is from an extension.\r\n        // Remove all those lines from the call stack.\r\n        indexOfFirstRequireJSline = stack.indexOf("requirejs/require.js");\r\n        if (indexOfFirstRequireJSline !== -1) {\r\n            indexOfFirstRequireJSline = stack.lastIndexOf(")", indexOfFirstRequireJSline) + 1;\r\n            stack = stack.substr(0, indexOfFirstRequireJSline);\r\n        }\r\n\r\n        return stack;\r\n    }\r\n\r\n    /**\r\n     * Show deprecation warning with the call stack if it\r\n     * has never been displayed before.\r\n     * @param {!string} message The deprecation message to be displayed.\r\n     * @param {boolean=} oncePerCaller If true, displays the message once for each unique call location.\r\n     *     If false (the default), only displays the message once no matter where it\'s called from.\r\n     *     Note that setting this to true can cause a slight performance hit (because it has to generate\r\n     *     a stack trace), so don\'t set this for functions that you expect to be called from performance-\r\n     *     sensitive code (e.g. tight loops).\r\n     * @param {number=} callerStackPos Only used if oncePerCaller=true. Overrides the `Error().stack` depth\r\n     *     where the client-code caller can be found. Only needed if extra shim layers are involved.\r\n     */\r\n    function deprecationWarning(message, oncePerCaller, callerStackPos) {\r\n        // If oncePerCaller isn\'t set, then only show the message once no matter who calls it.\r\n        if (!message || (!oncePerCaller && displayedWarnings[message])) {\r\n            return;\r\n        }\r\n\r\n        // Don\'t show the warning again if we\'ve already gotten it from the current caller.\r\n        // The true caller location is the fourth line in the stack trace:\r\n        // * 0 is the word "Error"\r\n        // * 1 is this function\r\n        // * 2 is the caller of this function (the one throwing the deprecation warning)\r\n        // * 3 is the actual caller of the deprecated function.\r\n        var stack = new Error().stack,\r\n            callerLocation = stack.split("\\n")[callerStackPos || 3];\r\n        if (oncePerCaller && displayedWarnings[message] && displayedWarnings[message][callerLocation]) {\r\n            return;\r\n        }\r\n\r\n        console.warn(message + "\\n" + _trimStack(stack));\r\n        if (!displayedWarnings[message]) {\r\n            displayedWarnings[message] = {};\r\n        }\r\n        displayedWarnings[message][callerLocation] = true;\r\n    }\r\n\r\n\r\n    /**\r\n     * Show a deprecation warning if there are listeners for the event\r\n     *\r\n     * ```\r\n     *    DeprecationWarning.deprecateEvent(exports,\r\n     *                                      MainViewManager,\r\n     *                                      "workingSetAdd",\r\n     *                                      "workingSetAdd",\r\n     *                                      "DocumentManager.workingSetAdd",\r\n     *                                      "MainViewManager.workingSetAdd");\r\n     * ```\r\n     *\r\n     * @param {Object} outbound - the object with the old event to dispatch\r\n     * @param {Object} inbound - the object with the new event to map to the old event\r\n     * @param {string} oldEventName - the name of the old event\r\n     * @param {string} newEventName - the name of the new event\r\n     * @param {string=} canonicalOutboundName - the canonical name of the old event\r\n     * @param {string=} canonicalInboundName - the canonical name of the new event\r\n     */\r\n    function deprecateEvent(outbound, inbound, oldEventName, newEventName, canonicalOutboundName, canonicalInboundName) {\r\n        // Mark deprecated so EventDispatcher.on() will emit warnings\r\n        EventDispatcher.markDeprecated(outbound, oldEventName, canonicalInboundName);\r\n\r\n        // create an event handler for the new event to listen for\r\n        inbound.on(newEventName, function () {\r\n            // Dispatch the event in case anyone is still listening\r\n            EventDispatcher.triggerWithArray(outbound, oldEventName, Array.prototype.slice.call(arguments, 1));\r\n        });\r\n    }\r\n\r\n\r\n    /**\r\n     * Create a deprecation warning and action for updated constants\r\n     * @param {!string} old Menu Id\r\n     * @param {!string} new Menu Id\r\n     */\r\n    function deprecateConstant(obj, oldId, newId) {\r\n        var warning     = "Use Menus." + newId + " instead of Menus." + oldId,\r\n            newValue    = obj[newId];\r\n\r\n        Object.defineProperty(obj, oldId, {\r\n            get: function () {\r\n                deprecationWarning(warning, true);\r\n                return newValue;\r\n            }\r\n        });\r\n    }\r\n\r\n    // Define public API\r\n    exports.deprecationWarning   = deprecationWarning;\r\n    exports.deprecateEvent       = deprecateEvent;\r\n    exports.deprecateConstant      = deprecateConstant;\r\n});\r\n\n//# sourceURL=/utils/DeprecationWarning.js'),eval('/*\r\n * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\ndefine(\'command/Commands\',[\'require\',\'exports\',\'module\',\'utils/DeprecationWarning\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    var DeprecationWarning = require("utils/DeprecationWarning");\r\n\r\n    /**\r\n     * List of constants for global command IDs.\r\n     */\r\n\r\n    // FILE\r\n    exports.FILE_NEW_UNTITLED           = "file.newDoc";                // DocumentCommandHandlers.js   handleFileNew()\r\n    exports.FILE_NEW                    = "file.newFile";               // DocumentCommandHandlers.js   handleFileNewInProject()\r\n    exports.FILE_NEW_FOLDER             = "file.newFolder";             // DocumentCommandHandlers.js   handleNewFolderInProject()\r\n    exports.FILE_OPEN                   = "file.open";                  // DocumentCommandHandlers.js   handleDocumentOpen()\r\n    exports.FILE_OPEN_FOLDER            = "file.openFolder";            // ProjectManager.js            openProject()\r\n    exports.FILE_SAVE                   = "file.save";                  // DocumentCommandHandlers.js   handleFileSave()\r\n    exports.FILE_SAVE_ALL               = "file.saveAll";               // DocumentCommandHandlers.js   handleFileSaveAll()\r\n    exports.FILE_SAVE_AS                = "file.saveAs";                // DocumentCommandHandlers.js   handleFileSaveAs()\r\n    exports.FILE_CLOSE                  = "file.close";                 // DocumentCommandHandlers.js   handleFileClose()\r\n    exports.FILE_CLOSE_ALL              = "file.close_all";             // DocumentCommandHandlers.js   handleFileCloseAll()\r\n    exports.FILE_CLOSE_LIST             = "file.close_list";            // DocumentCommandHandlers.js   handleFileCloseList()\r\n    exports.FILE_OPEN_DROPPED_FILES     = "file.openDroppedFiles";      // DragAndDrop.js               openDroppedFiles()\r\n    exports.FILE_LIVE_FILE_PREVIEW      = "file.liveFilePreview";       // LiveDevelopment/main.js      _handleGoLiveCommand()\r\n    exports.TOGGLE_LIVE_PREVIEW_MB_MODE = "file.toggleLivePreviewMB";   // LiveDevelopment/main.js      _toggleLivePreviewMultiBrowser()\r\n    exports.CMD_RELOAD_LIVE_PREVIEW     = "file.reloadLivePreview";     // LiveDevelopment/main.js      _handleReloadLivePreviewCommand()\r\n    exports.FILE_LIVE_HIGHLIGHT         = "file.previewHighlight";      // LiveDevelopment/main.js      _handlePreviewHighlightCommand()\r\n    exports.FILE_PROJECT_SETTINGS       = "file.projectSettings";       // ProjectManager.js            _projectSettings()\r\n    exports.FILE_RENAME                 = "file.rename";                // DocumentCommandHandlers.js   handleFileRename()\r\n    exports.FILE_DELETE                 = "file.delete";                // DocumentCommandHandlers.js   handleFileDelete()\r\n    exports.FILE_EXTENSION_MANAGER      = "file.extensionManager";      // ExtensionManagerDialog.js    _showDialog()\r\n    exports.FILE_REFRESH                = "file.refresh";               // ProjectManager.js            refreshFileTree()\r\n    exports.FILE_OPEN_PREFERENCES       = "file.openPreferences";       // PreferencesManager.js        _handleOpenPreferences()\r\n    exports.FILE_OPEN_KEYMAP            = "file.openKeyMap";            // KeyBindingManager.js         _openUserKeyMap()\r\n\r\n    // File shell callbacks - string must MATCH string in native code (appshell/command_callbacks.h)\r\n    exports.FILE_CLOSE_WINDOW           = "file.close_window";          // DocumentCommandHandlers.js   handleFileCloseWindow()\r\n    exports.FILE_QUIT                   = "file.quit";                  // DocumentCommandHandlers.js   handleFileQuit()\r\n\r\n    // EDIT\r\n    // File shell callbacks - string must MATCH string in native code (appshell/command_callbacks.h)\r\n    exports.EDIT_UNDO                   = "edit.undo";                  // EditorCommandHandlers.js     handleUndo()\r\n    exports.EDIT_REDO                   = "edit.redo";                  // EditorCommandHandlers.js     handleRedo()\r\n    exports.EDIT_CUT                    = "edit.cut";                   // EditorCommandHandlers.js     ignoreCommand()\r\n    exports.EDIT_COPY                   = "edit.copy";                  // EditorCommandHandlers.js     ignoreCommand()\r\n    exports.EDIT_PASTE                  = "edit.paste";                 // EditorCommandHandlers.js     ignoreCommand()\r\n    exports.EDIT_SELECT_ALL             = "edit.selectAll";             // EditorCommandHandlers.js     _handleSelectAll()\r\n\r\n    exports.EDIT_SELECT_LINE            = "edit.selectLine";            // EditorCommandHandlers.js     selectLine()\r\n    exports.EDIT_SPLIT_SEL_INTO_LINES   = "edit.splitSelIntoLines";     // EditorCommandHandlers.js     splitSelIntoLines()\r\n    exports.EDIT_ADD_CUR_TO_NEXT_LINE   = "edit.addCursorToNextLine";   // EditorCommandHandlers.js     addCursorToNextLine()\r\n    exports.EDIT_ADD_CUR_TO_PREV_LINE   = "edit.addCursorToPrevLine";   // EditorCommandHandlers.js     addCursorToPrevLine()\r\n    exports.EDIT_INDENT                 = "edit.indent";                // EditorCommandHandlers.js     indentText()\r\n    exports.EDIT_UNINDENT               = "edit.unindent";              // EditorCommandHandlers.js     unindentText()\r\n    exports.EDIT_DUPLICATE              = "edit.duplicate";             // EditorCommandHandlers.js     duplicateText()\r\n    exports.EDIT_DELETE_LINES           = "edit.deletelines";           // EditorCommandHandlers.js     deleteCurrentLines()\r\n    exports.EDIT_LINE_COMMENT           = "edit.lineComment";           // EditorCommandHandlers.js     lineComment()\r\n    exports.EDIT_BLOCK_COMMENT          = "edit.blockComment";          // EditorCommandHandlers.js     blockComment()\r\n    exports.EDIT_LINE_UP                = "edit.lineUp";                // EditorCommandHandlers.js     moveLineUp()\r\n    exports.EDIT_LINE_DOWN              = "edit.lineDown";              // EditorCommandHandlers.js     moveLineDown()\r\n    exports.EDIT_OPEN_LINE_ABOVE        = "edit.openLineAbove";         // EditorCommandHandlers.js     openLineAbove()\r\n    exports.EDIT_OPEN_LINE_BELOW        = "edit.openLineBelow";         // EditorCommandHandlers.js     openLineBelow()\r\n    exports.TOGGLE_CLOSE_BRACKETS       = "edit.autoCloseBrackets";     // EditorOptionHandlers.js      _getToggler()\r\n    exports.SHOW_CODE_HINTS             = "edit.showCodeHints";         // CodeHintManager.js           _startNewSession()\r\n\r\n    // FIND\r\n    exports.CMD_FIND                    = "cmd.find";                   // FindReplace.js               _launchFind()\r\n    exports.CMD_FIND_IN_FILES           = "cmd.findInFiles";            // FindInFilesUI.js             _showFindBar()\r\n    exports.CMD_FIND_IN_SUBTREE         = "cmd.findInSubtree";          // FindInFilesUI.js             _showFindBarForSubtree()\r\n    exports.CMD_FIND_NEXT               = "cmd.findNext";               // FindReplace.js               _findNext()\r\n    exports.CMD_FIND_PREVIOUS           = "cmd.findPrevious";           // FindReplace.js               _findPrevious()\r\n    exports.CMD_FIND_ALL_AND_SELECT     = "cmd.findAllAndSelect";       // FindReplace.js               _findAllAndSelect()\r\n    exports.CMD_ADD_NEXT_MATCH          = "cmd.addNextMatch";           // FindReplace.js               _expandAndAddNextToSelection()\r\n    exports.CMD_SKIP_CURRENT_MATCH      = "cmd.skipCurrentMatch";       // FindReplace.js               _skipCurrentMatch()\r\n    exports.CMD_REPLACE                 = "cmd.replace";                // FindReplace.js               _replace()\r\n    exports.CMD_REPLACE_IN_FILES        = "cmd.replaceInFiles";         // FindInFilesUI.js             _showReplaceBar()\r\n    exports.CMD_REPLACE_IN_SUBTREE      = "cmd.replaceInSubtree";       // FindInFilesUI.js             _showReplaceBarForSubtree()\r\n\r\n    // VIEW\r\n    exports.CMD_THEMES_OPEN_SETTINGS    = "view.themesOpenSetting";     // MenuCommands.js              Settings.open()\r\n    exports.VIEW_HIDE_SIDEBAR           = "view.toggleSidebar";         // SidebarView.js               toggle()\r\n    exports.VIEW_INCREASE_FONT_SIZE     = "view.increaseFontSize";      // ViewCommandHandlers.js       _handleIncreaseFontSize()\r\n    exports.VIEW_DECREASE_FONT_SIZE     = "view.decreaseFontSize";      // ViewCommandHandlers.js       _handleDecreaseFontSize()\r\n    exports.VIEW_RESTORE_FONT_SIZE      = "view.restoreFontSize";       // ViewCommandHandlers.js       _handleRestoreFontSize()\r\n    exports.VIEW_SCROLL_LINE_UP         = "view.scrollLineUp";          // ViewCommandHandlers.js       _handleScrollLineUp()\r\n    exports.VIEW_SCROLL_LINE_DOWN       = "view.scrollLineDown";        // ViewCommandHandlers.js       _handleScrollLineDown()\r\n    exports.VIEW_TOGGLE_INSPECTION      = "view.toggleCodeInspection";  // CodeInspection.js            toggleEnabled()\r\n    exports.TOGGLE_LINE_NUMBERS         = "view.toggleLineNumbers";     // EditorOptionHandlers.js      _getToggler()\r\n    exports.TOGGLE_ACTIVE_LINE          = "view.toggleActiveLine";      // EditorOptionHandlers.js      _getToggler()\r\n    exports.TOGGLE_WORD_WRAP            = "view.toggleWordWrap";        // EditorOptionHandlers.js      _getToggler()\r\n\r\n    exports.CMD_OPEN                        = "cmd.open";\r\n    exports.CMD_ADD_TO_WORKINGSET_AND_OPEN  = "cmd.addToWorkingSetAndOpen";          // DocumentCommandHandlers.js   handleOpenDocumentInNewPane()\r\n\r\n    // NAVIGATE\r\n    exports.NAVIGATE_NEXT_DOC           = "navigate.nextDoc";           // DocumentCommandHandlers.js   handleGoNextDoc()\r\n    exports.NAVIGATE_PREV_DOC           = "navigate.prevDoc";           // DocumentCommandHandlers.js   handleGoPrevDoc()\r\n    exports.NAVIGATE_NEXT_DOC_LIST_ORDER    = "navigate.nextDocListOrder";           // DocumentCommandHandlers.js   handleGoNextDocListOrder()\r\n    exports.NAVIGATE_PREV_DOC_LIST_ORDER    = "navigate.prevDocListOrder";           // DocumentCommandHandlers.js   handleGoPrevDocListOrder()\r\n    exports.NAVIGATE_SHOW_IN_FILE_TREE  = "navigate.showInFileTree";    // DocumentCommandHandlers.js   handleShowInTree()\r\n    exports.NAVIGATE_SHOW_IN_OS         = "navigate.showInOS";          // DocumentCommandHandlers.js   handleShowInOS()\r\n    exports.NAVIGATE_QUICK_OPEN         = "navigate.quickOpen";         // QuickOpen.js                 doFileSearch()\r\n    exports.NAVIGATE_JUMPTO_DEFINITION  = "navigate.jumptoDefinition";  // EditorManager.js             _doJumpToDef()\r\n    exports.NAVIGATE_GOTO_DEFINITION    = "navigate.gotoDefinition";    // QuickOpen.js                 doDefinitionSearch()\r\n    exports.NAVIGATE_GOTO_LINE          = "navigate.gotoLine";          // QuickOpen.js                 doGotoLine()\r\n    exports.NAVIGATE_GOTO_FIRST_PROBLEM = "navigate.gotoFirstProblem";  // CodeInspection.js            handleGotoFirstProblem()\r\n    exports.TOGGLE_QUICK_EDIT           = "navigate.toggleQuickEdit";   // EditorManager.js             _toggleInlineWidget()\r\n    exports.TOGGLE_QUICK_DOCS           = "navigate.toggleQuickDocs";   // EditorManager.js             _toggleInlineWidget()\r\n    exports.QUICK_EDIT_NEXT_MATCH       = "navigate.nextMatch";         // MultiRangeInlineEditor.js    _nextRange()\r\n    exports.QUICK_EDIT_PREV_MATCH       = "navigate.previousMatch";     // MultiRangeInlineEditor.js    _previousRange()\r\n    exports.CSS_QUICK_EDIT_NEW_RULE     = "navigate.newRule";           // CSSInlineEditor.js           _handleNewRule()\r\n\r\n    // HELP\r\n    exports.HELP_CHECK_FOR_UPDATE       = "help.checkForUpdate";        // HelpCommandHandlers.js       _handleCheckForUpdates()\r\n    exports.HELP_HOW_TO_USE_BRACKETS    = "help.howToUseBrackets";      // HelpCommandHandlers.js       _handleLinkMenuItem()\r\n    exports.HELP_SUPPORT                = "help.support";               // HelpCommandHandlers.js       _handleLinkMenuItem()\r\n    exports.HELP_SUGGEST                = "help.suggest";               // HelpCommandHandlers.js       _handleLinkMenuItem()\r\n    exports.HELP_RELEASE_NOTES          = "help.releaseNotes";          // HelpCommandHandlers.js       _handleLinkMenuItem()\r\n    exports.HELP_GET_INVOLVED           = "help.getInvolved";           // HelpCommandHandlers.js       _handleLinkMenuItem()\r\n    exports.HELP_SHOW_EXT_FOLDER        = "help.showExtensionsFolder";  // HelpCommandHandlers.js       _handleShowExtensionsFolder()\r\n    exports.HELP_HOMEPAGE               = "help.homepage";              // HelpCommandHandlers.js       _handleLinkMenuItem()\r\n    exports.HELP_TWITTER                = "help.twitter";               // HelpCommandHandlers.js       _handleLinkMenuItem()\r\n\r\n    // Working Set Configuration\r\n    exports.CMD_WORKINGSET_SORT_BY_ADDED  = "cmd.sortWorkingSetByAdded";     // WorkingSetSort.js       _handleSort()\r\n    exports.CMD_WORKINGSET_SORT_BY_NAME   = "cmd.sortWorkingSetByName";      // WorkingSetSort.js       _handleSort()\r\n    exports.CMD_WORKINGSET_SORT_BY_TYPE   = "cmd.sortWorkingSetByType";      // WorkingSetSort.js       _handleSort()\r\n    exports.CMD_WORKING_SORT_TOGGLE_AUTO  = "cmd.sortWorkingSetToggleAuto";  // WorkingSetSort.js       _handleToggleAutoSort()\r\n\r\n    // Split View\r\n    exports.CMD_SPLITVIEW_NONE          = "cmd.splitViewNone";          // SidebarView.js               _handleSplitNone()\r\n    exports.CMD_SPLITVIEW_VERTICAL      = "cmd.splitViewVertical";      // SidebarView.js               _handleSplitVertical()\r\n    exports.CMD_SPLITVIEW_HORIZONTAL    = "cmd.splitViewHorizontal";    // SidebarView.js               _handleSplitHorizontal()\r\n    exports.CMD_SWITCH_PANE_FOCUS       = "cmd.switchPaneFocus";        // MainViewManager.js           _switchPaneFocus()\r\n\r\n    // File shell callbacks - string must MATCH string in native code (appshell/command_callbacks.h)\r\n    exports.HELP_ABOUT                  = "help.about";                 // HelpCommandHandlers.js       _handleAboutDialog()\r\n\r\n    // APP\r\n    exports.APP_RELOAD                  = "app.reload";                 // DocumentCommandHandlers.js   handleReload()\r\n    exports.APP_RELOAD_WITHOUT_EXTS     = "app.reload_without_exts";    // DocumentCommandHandlers.js   handleReloadWithoutExts()\r\n\r\n    // File shell callbacks - string must MATCH string in native code (appshell/command_callbacks.h)\r\n    exports.APP_ABORT_QUIT              = "app.abort_quit";             // DocumentCommandHandlers.js   handleAbortQuit()\r\n    exports.APP_BEFORE_MENUPOPUP        = "app.before_menupopup";       // DocumentCommandHandlers.js   handleBeforeMenuPopup()\r\n\r\n    // ADD_TO_WORKING_SET is deprectated but we need a handler for it because the new command doesn\'t return the same result as the legacy command\r\n    exports.FILE_ADD_TO_WORKING_SET     = "file.addToWorkingSet";       // Deprecated through DocumentCommandHandlers.js handleFileAddToWorkingSet\r\n\r\n    // Show or Hide sidebar\r\n    exports.HIDE_SIDEBAR                = "view.hideSidebar";           // SidebarView.js               hide()\r\n    exports.SHOW_SIDEBAR                = "view.showSidebar";           // SidebarView.js               show()\r\n\r\n    // DEPRECATED: Working Set Commands\r\n    DeprecationWarning.deprecateConstant(exports, "SORT_WORKINGSET_BY_ADDED",   "CMD_WORKINGSET_SORT_BY_ADDED");\r\n    DeprecationWarning.deprecateConstant(exports, "SORT_WORKINGSET_BY_NAME",    "CMD_WORKINGSET_SORT_BY_NAME");\r\n    DeprecationWarning.deprecateConstant(exports, "SORT_WORKINGSET_BY_TYPE",    "CMD_WORKINGSET_SORT_BY_TYPE");\r\n    DeprecationWarning.deprecateConstant(exports, "SORT_WORKINGSET_AUTO",       "CMD_WORKING_SORT_TOGGLE_AUTO");\r\n});\r\n\r\n\n//# sourceURL=/command/Commands.js'),
eval('/*\r\n * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\n /**\r\n  * This is JavaScript API exposed to the native shell when Brackets is run in a native shell rather than a browser.\r\n  */\r\ndefine(\'utils/ShellAPI\',[\'require\',\'exports\',\'module\',\'utils/AppInit\',\'command/CommandManager\',\'command/Commands\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    // Load dependent modules\r\n    var AppInit        = require("utils/AppInit"),\r\n        CommandManager = require("command/CommandManager"),\r\n        Commands       = require("command/Commands");\r\n\r\n    var appReady = false; // Set to true after app is fully initialized\r\n\r\n    /**\r\n     * The native function BracketsShellAPI::DispatchBracketsJSCommand calls this function in order to enable\r\n     * calling Brackets commands from the native shell.\r\n     */\r\n    function executeCommand(eventName) {\r\n        // Temporary fix for #2616 - don\'t execute the command if a modal dialog is open.\r\n        // This should really be fixed with proper menu enabling.\r\n        if ($(".modal.instance").length || !appReady) {\r\n            // Another hack to fix issue #3219 so that all test windows are closed\r\n            // as before the fix for #3152 has been introduced. isBracketsTestWindow\r\n            // property is explicitly set in createTestWindowAndRun() in SpecRunnerUtils.js.\r\n            if (window.isBracketsTestWindow) {\r\n                return false;\r\n            }\r\n            // Return false for all commands except file.close_window command for\r\n            // which we have to return true (issue #3152).\r\n            return (eventName === Commands.FILE_CLOSE_WINDOW);\r\n        }\r\n\r\n        // Use E for Error so that uglify doesn\'t change this to simply Error()\r\n        var promise, E = Error, e = new E(), stackDepth = e.stack.split("\\n").length;\r\n\r\n        // This function should *only* be called as a top-level function. If the current\r\n        // stack depth is > 2, it is most likely because we are at a breakpoint.\r\n        if (stackDepth < 3) {\r\n            promise = CommandManager.execute(eventName);\r\n        } else {\r\n            console.error("Skipping command " + eventName + " because it looks like you are " +\r\n                          "at a breakpoint. If you are NOT at a breakpoint, please " +\r\n                          "file a bug and mention this comment. Stack depth = " + stackDepth + ".");\r\n        }\r\n        return (promise && promise.state() === "rejected") ? false : true;\r\n    }\r\n\r\n    AppInit.appReady(function () {\r\n        appReady = true;\r\n    });\r\n\r\n    exports.executeCommand = executeCommand;\r\n});\r\n\n//# sourceURL=/utils/ShellAPI.js'),eval('/*\r\n * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\n/**\r\n * Initializes the global "brackets" variable and it\'s properties.\r\n * Modules should not access the global.brackets object until either\r\n * (a) the module requires this module, i.e. require("utils/Global") or\r\n * (b) the module receives a "appReady" callback from the utils/AppReady module.\r\n */\r\ndefine(\'utils/Global\',[\'require\',\'exports\',\'module\',\'text!config.json\',\'utils/UrlParams\',\'utils/ShellAPI\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    var configJSON  = require("text!config.json"),\r\n        UrlParams   = require("utils/UrlParams").UrlParams;\r\n\r\n    // Define core brackets namespace if it isn\'t already defined\r\n    //\r\n    // We can\'t simply do \'brackets = {}\' to define it in the global namespace because\r\n    // we\'re in "use strict" mode. Most likely, \'window\' will always point to the global\r\n    // object when this code is running. However, in case it isn\'t (e.g. if we\'re running\r\n    // inside Node for CI testing) we use this trick to get the global object.\r\n    var Fn = Function, global = (new Fn("return this"))();\r\n    if (!global.brackets) {\r\n        global.brackets = {};\r\n    }\r\n\r\n    // Parse URL params\r\n    var params = new UrlParams();\r\n    params.parse();\r\n\r\n    // Parse src/config.json\r\n    try {\r\n        global.brackets.metadata = JSON.parse(configJSON);\r\n        global.brackets.config = global.brackets.metadata.config;\r\n    } catch (err) {\r\n        console.log(err);\r\n    }\r\n\r\n    // Uncomment the following line to force all low level file i/o routines to complete\r\n    // asynchronously. This should only be done for testing/debugging.\r\n    // NOTE: Make sure this line is commented out again before committing!\r\n    //brackets.forceAsyncCallbacks = true;\r\n\r\n    // Load native shell when brackets is run in a native shell rather than the browser\r\n    // TODO: (issue #266) load conditionally\r\n    global.brackets.shellAPI = require("utils/ShellAPI");\r\n\r\n    // Determine OS/platform\r\n    if (global.navigator.platform === "MacIntel" || global.navigator.platform === "MacPPC") {\r\n        global.brackets.platform = "mac";\r\n    } else if (global.navigator.platform.indexOf("Linux") >= 0) {\r\n        global.brackets.platform = "linux";\r\n    } else {\r\n        global.brackets.platform = "win";\r\n    }\r\n\r\n    global.brackets.inBrowser = !global.brackets.hasOwnProperty("fs");\r\n\r\n    // Are we in a desktop shell with a native menu bar?\r\n    var hasNativeMenus = params.get("hasNativeMenus");\r\n    if (hasNativeMenus) {\r\n        global.brackets.nativeMenus = (hasNativeMenus === "true");\r\n    } else {\r\n        global.brackets.nativeMenus = (!global.brackets.inBrowser);\r\n    }\r\n\r\n    // Locale-related APIs\r\n    global.brackets.isLocaleDefault = function () {\r\n        return !global.localStorage.getItem("locale");\r\n    };\r\n\r\n    global.brackets.getLocale = function () {\r\n        // By default use the locale that was determined in brackets.js\r\n        return params.get("testEnvironment") ? "en" : (global.localStorage.getItem("locale") || global.require.s.contexts._.config.locale);\r\n    };\r\n\r\n    global.brackets.setLocale = function (locale) {\r\n        if (locale) {\r\n            global.localStorage.setItem("locale", locale);\r\n        } else {\r\n            global.localStorage.removeItem("locale");\r\n        }\r\n    };\r\n\r\n    // Create empty app namespace if running in-browser\r\n    if (!global.brackets.app) {\r\n        global.brackets.app = {};\r\n    }\r\n\r\n    // Loading extensions requires creating new require.js contexts, which\r\n    // requires access to the global \'require\' object that always gets hidden\r\n    // by the \'require\' in the AMD wrapper. We store this in the brackets\r\n    // object here so that the ExtensionLoader doesn\'t have to have access to\r\n    // the global object.\r\n    global.brackets.libRequire = global.require;\r\n\r\n    // Also store our current require.js context (the one that loads brackets\r\n    // core modules) so that extensions can use it.\r\n    // Note: we change the name to "getModule" because this won\'t do exactly\r\n    // the same thing as \'require\' in AMD-wrapped modules. The extension will\r\n    // only be able to load modules that have already been loaded once.\r\n    global.brackets.getModule = require;\r\n\r\n    /* API for retrieving the global RequireJS config\r\n     * For internal use only\r\n     */\r\n    global.brackets._getGlobalRequireJSConfig = function () {\r\n        return global.require.s.contexts._.config;\r\n    };\r\n    \r\n    exports.global = global;\r\n});\r\n\n//# sourceURL=/utils/Global.js'),eval('/*\r\n * Copyright (c) 2013 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\n/**\r\n * FileSystemError describes the errors that can occur when using the FileSystem, File,\r\n * and Directory modules.\r\n *\r\n * Error values are strings. Any "falsy" value: null, undefined or "" means "no error".\r\n */\r\ndefine(\'filesystem/FileSystemError\',[\'require\',\'exports\',\'module\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    /**\r\n     * Enumerated File System Errors\r\n     * @enum {string}\r\n     */\r\n    module.exports = {\r\n        UNKNOWN                     : "Unknown",\r\n        INVALID_PARAMS              : "InvalidParams",\r\n        NOT_FOUND                   : "NotFound",\r\n        NOT_READABLE                : "NotReadable",\r\n        UNSUPPORTED_ENCODING        : "UnsupportedEncoding",\r\n        NOT_SUPPORTED               : "NotSupported",\r\n        NOT_WRITABLE                : "NotWritable",\r\n        OUT_OF_SPACE                : "OutOfSpace",\r\n        TOO_MANY_ENTRIES            : "TooManyEntries",\r\n        ALREADY_EXISTS              : "AlreadyExists",\r\n        CONTENTS_MODIFIED           : "ContentsModified",\r\n        ROOT_NOT_WATCHED            : "RootNotBeingWatched",\r\n        EXCEEDS_MAX_FILE_SIZE       : "ExceedsMaxFileSize",\r\n        NETWORK_DRIVE_NOT_SUPPORTED : "NetworkDriveNotSupported",\r\n        ENCODE_FILE_FAILED          : "EncodeFileFailed",\r\n        DECODE_FILE_FAILED          : "DecodeFileFailed",\r\n        UNSUPPORTED_UTF16_ENCODING  : "UnsupportedUTF16Encoding"\r\n\r\n        // FUTURE: Add remote connection errors: timeout, not logged in, connection err, etc.\r\n    };\r\n});\r\n\n//# sourceURL=/filesystem/FileSystemError.js'),eval('/*\r\n * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\n/* The hash code routne is taken from http://stackoverflow.com/questions/7616461/generate-a-hash-from-string-in-javascript-jquery\r\n   @CC wiki attribution: esmiralha\r\n*/\r\n\r\n/*eslint no-bitwise: off */\r\n/*jslint bitwise: true */\r\n\r\n/**\r\n *  Utilities functions related to string manipulation\r\n *\r\n */\r\ndefine(\'utils/StringUtils\',[\'require\',\'exports\',\'module\',\'thirdparty/lodash\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    var _ = require("thirdparty/lodash");\r\n\r\n    /**\r\n     * Format a string by replacing placeholder symbols with passed in arguments.\r\n     *\r\n     * Example: var formatted = StringUtils.format("Hello {0}", "World");\r\n     *\r\n     * @param {string} str The base string\r\n     * @param {...} Arguments to be substituted into the string\r\n     *\r\n     * @return {string} Formatted string\r\n     */\r\n    function format(str) {\r\n        // arguments[0] is the base string, so we need to adjust index values here\r\n        var args = [].slice.call(arguments, 1);\r\n        return str.replace(/\\{(\\d+)\\}/g, function (match, num) {\r\n            return typeof args[num] !== "undefined" ? args[num] : match;\r\n        });\r\n    }\r\n\r\n    function regexEscape(str) {\r\n        return str.replace(/([.?*+\\^$\\[\\]\\\\(){}|\\-])/g, "\\\\$1");\r\n    }\r\n\r\n    // Periods (aka "dots") are allowed in HTML identifiers, but jQuery interprets\r\n    // them as the start of a class selector, so they need to be escaped\r\n    function jQueryIdEscape(str) {\r\n        return str.replace(/\\./g, "\\\\.");\r\n    }\r\n\r\n    /**\r\n     * Splits the text by new line characters and returns an array of lines\r\n     * @param {string} text\r\n     * @return {Array.<string>} lines\r\n     */\r\n    function getLines(text) {\r\n        return text.split("\\n");\r\n    }\r\n\r\n    /**\r\n     * Returns a line number corresponding to an offset in some text. The text can\r\n     * be specified as a single string or as an array of strings that correspond to\r\n     * the lines of the string.\r\n     *\r\n     * Specify the text in lines when repeatedly calling the function on the same\r\n     * text in a loop. Use getLines() to divide the text into lines, then repeatedly call\r\n     * this function to compute a line number from the offset.\r\n     *\r\n     * @param {string | Array.<string>} textOrLines - string or array of lines from which\r\n     *      to compute the line number from the offset\r\n     * @param {number} offset\r\n     * @return {number} line number\r\n     */\r\n    function offsetToLineNum(textOrLines, offset) {\r\n        if (Array.isArray(textOrLines)) {\r\n            var lines = textOrLines,\r\n                total = 0,\r\n                line;\r\n            for (line = 0; line < lines.length; line++) {\r\n                if (total < offset) {\r\n                    // add 1 per line since /n were removed by splitting, but they needed to\r\n                    // contribute to the total offset count\r\n                    total += lines[line].length + 1;\r\n                } else if (total === offset) {\r\n                    return line;\r\n                } else {\r\n                    return line - 1;\r\n                }\r\n            }\r\n\r\n            // if offset is NOT over the total then offset is in the last line\r\n            if (offset <= total) {\r\n                return line - 1;\r\n            } else {\r\n                return undefined;\r\n            }\r\n        } else {\r\n            return textOrLines.substr(0, offset).split("\\n").length - 1;\r\n        }\r\n    }\r\n\r\n    /**\r\n     * Returns true if the given string starts with the given prefix.\r\n     * @param   {String} str\r\n     * @param   {String} prefix\r\n     * @return {Boolean}\r\n     */\r\n    function startsWith(str, prefix) {\r\n        return str.slice(0, prefix.length) === prefix;\r\n    }\r\n\r\n    /**\r\n     * Returns true if the given string ends with the given suffix.\r\n     *\r\n     * @param {string} str\r\n     * @param {string} suffix\r\n     */\r\n    function endsWith(str, suffix) {\r\n        return str.indexOf(suffix, str.length - suffix.length) !== -1;\r\n    }\r\n\r\n    function urlSort(a, b) {\r\n        var a2, b2;\r\n        function isFile(s) {\r\n            return ((s.lastIndexOf("/") + 1) < s.length);\r\n        }\r\n\r\n        if (brackets.platform === "win") {\r\n            // Windows: prepend folder names with a \'0\' and file names with a \'1\' so folders are listed first\r\n            a2 = ((isFile(a)) ? "1" : "0") + a.toLowerCase();\r\n            b2 = ((isFile(b)) ? "1" : "0") + b.toLowerCase();\r\n        } else {\r\n            a2 = a.toLowerCase();\r\n            b2 = b.toLowerCase();\r\n        }\r\n\r\n        if (a2 === b2) {\r\n            return 0;\r\n        } else {\r\n            return (a2 > b2) ? 1 : -1;\r\n        }\r\n    }\r\n\r\n    /**\r\n     * Return an escaped path or URL string that can be broken near path separators.\r\n     * @param {string} url the path or URL to format\r\n     * @return {string} the formatted path or URL\r\n     */\r\n    function breakableUrl(url) {\r\n        // This is for displaying in UI, so always want it escaped\r\n        var escUrl = _.escape(url);\r\n\r\n        // Inject zero-width space character (U+200B) near path separators (/) to allow line breaking there\r\n        return escUrl.replace(\r\n            new RegExp(regexEscape("/"), "g"),\r\n            "/" + "&#8203;"\r\n        );\r\n    }\r\n\r\n    /**\r\n     * Converts number of bytes into human readable format.\r\n     * If param bytes is negative it returns the number without any changes.\r\n     *\r\n     * @param {number} bytes     Number of bytes to convert\r\n     * @param {number} precision Number of digits after the decimal separator\r\n     * @return {string}\r\n     */\r\n    function prettyPrintBytes(bytes, precision) {\r\n        var kilobyte = 1024,\r\n            megabyte = kilobyte * 1024,\r\n            gigabyte = megabyte * 1024,\r\n            terabyte = gigabyte * 1024,\r\n            returnVal = bytes;\r\n\r\n        if ((bytes >= 0) && (bytes < kilobyte)) {\r\n            returnVal = bytes + " B";\r\n        } else if (bytes < megabyte) {\r\n            returnVal = (bytes / kilobyte).toFixed(precision) + " KB";\r\n        } else if (bytes < gigabyte) {\r\n            returnVal = (bytes / megabyte).toFixed(precision) + " MB";\r\n        } else if (bytes < terabyte) {\r\n            returnVal = (bytes / gigabyte).toFixed(precision) + " GB";\r\n        } else if (bytes >= terabyte) {\r\n            return (bytes / terabyte).toFixed(precision) + " TB";\r\n        }\r\n\r\n        return returnVal;\r\n    }\r\n\r\n    /**\r\n     * Truncate text to specified length.\r\n     * @param {string} str Text to be truncated.\r\n     * @param {number} len Length to which text should be truncated\r\n     * @return {?string} Returns truncated text only if it was changed\r\n     */\r\n    function truncate(str, len) {\r\n        // Truncate text to specified length\r\n        if (str.length > len) {\r\n            str = str.substr(0, len);\r\n\r\n            // To prevent awkwardly truncating in the middle of a word,\r\n            // attempt to truncate at the end of the last whole word\r\n            var lastSpaceChar = str.lastIndexOf(" ");\r\n            if (lastSpaceChar < len && lastSpaceChar > -1) {\r\n                str = str.substr(0, lastSpaceChar);\r\n            }\r\n            return str;\r\n        }\r\n    }\r\n\r\n    /**\r\n     * Computes a 32bit hash from the given string\r\n     * Taken from http://stackoverflow.com/questions/7616461/generate-a-hash-from-string-in-javascript-jquery\r\n     * @CC wiki attribution: esmiralha\r\n     * @param   {string}   str The string for which hash is to be computed\r\n     * @return {number} The 32-bit hash\r\n     */\r\n    function hashCode(str) {\r\n        var hash = 0, i, chr, len;\r\n        if (str.length === 0) {\r\n            return hash;\r\n        }\r\n        for (i = 0, len = str.length; i < len; i++) {\r\n            chr   = str.charCodeAt(i);\r\n            hash  = ((hash << 5) - hash) + chr;\r\n            hash |= 0; // Convert to 32bit integer\r\n        }\r\n        return hash;\r\n    }\r\n\r\n    // Define public API\r\n    exports.format              = format;\r\n    exports.regexEscape         = regexEscape;\r\n    exports.jQueryIdEscape      = jQueryIdEscape;\r\n    exports.getLines            = getLines;\r\n    exports.offsetToLineNum     = offsetToLineNum;\r\n    exports.urlSort             = urlSort;\r\n    exports.breakableUrl        = breakableUrl;\r\n    exports.startsWith          = startsWith;\r\n    exports.endsWith            = endsWith;\r\n    exports.prettyPrintBytes    = prettyPrintBytes;\r\n    exports.truncate            = truncate;\r\n    exports.hashCode            = hashCode;\r\n});\r\n\n//# sourceURL=/utils/StringUtils.js'),eval('/*\r\n * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\n/**\r\n * This is a collection of utility functions for gathering performance data.\r\n */\r\ndefine(\'utils/PerfUtils\',[\'require\',\'exports\',\'module\',\'thirdparty/lodash\',\'utils/StringUtils\',\'utils/Global\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    var _            = require("thirdparty/lodash"),\r\n        StringUtils  = require("utils/StringUtils");\r\n\r\n    // make sure the global brackets variable is loaded\r\n    require("utils/Global");\r\n\r\n    /**\r\n     * Flag to enable/disable performance data gathering. Default is true (enabled)\r\n     * @type {boolean} enabled\r\n     */\r\n    var enabled = brackets && !!brackets.app.getElapsedMilliseconds;\r\n\r\n    /**\r\n     * Peformance data is stored in this hash object. The key is the name of the\r\n     * test (passed to markStart/addMeasurement), and the value is the time, in\r\n     * milliseconds, that it took to run the test. If multiple runs of the same test\r\n     * are made, the value is an Array with each run stored as an entry in the Array.\r\n     */\r\n    var perfData = {};\r\n\r\n    /**\r\n     * Active tests. This is a hash of all tests that have had markStart() called,\r\n     * but have not yet had addMeasurement() called.\r\n     */\r\n    var activeTests = {};\r\n\r\n    /**\r\n     * Updatable tests. This is a hash of all tests that have had markStart() called,\r\n     * and have had updateMeasurement() called. Caller must explicitly remove tests\r\n     * from this list using finalizeMeasurement()\r\n     */\r\n    var updatableTests = {};\r\n\r\n    /**\r\n     * @private\r\n     * Keeps the track of measurements sequence number for re-entrant sequences with\r\n     * the same name currently running. Entries are created and deleted as needed.\r\n     */\r\n    var _reentTests = {};\r\n\r\n    /**\r\n     * @private\r\n     * A unique key to log performance data\r\n     *\r\n     * @param {(string|undefined)} id Unique ID for this measurement name\r\n     * @param {!string} name A short name for this measurement\r\n     * @param {?number} reent Sequence identifier for parallel tests of the same name\r\n     */\r\n    function PerfMeasurement(id, name, reent) {\r\n        this.name = name;\r\n        this.reent = reent;\r\n        if (id) {\r\n            this.id = id;\r\n        } else {\r\n            this.id = (reent) ? "[reent " + this.reent + "] " + name : name;\r\n        }\r\n    }\r\n\r\n    /**\r\n     * Override toString() to allow using PerfMeasurement as an array key without\r\n     * explicit conversion.\r\n     */\r\n    PerfMeasurement.prototype.toString = function () {\r\n        return this.name;\r\n    };\r\n\r\n    /**\r\n     * Create a new PerfMeasurement key. Adds itself to the module export.\r\n     * Can be accessed on the module, e.g. PerfUtils.MY_PERF_KEY.\r\n     *\r\n     * @param {!string} id Unique ID for this measurement name\r\n     * @param {!name} name A short name for this measurement\r\n     */\r\n    function createPerfMeasurement(id, name) {\r\n        var pm = new PerfMeasurement(id, name);\r\n        exports[id] = pm;\r\n\r\n        return pm;\r\n    }\r\n\r\n    /**\r\n     * @private\r\n     * Generates PerfMeasurements based on the name or array of names.\r\n     */\r\n    function _generatePerfMeasurements(name) {\r\n        // always convert it to array so that the rest of the routines could rely on it\r\n        var id = (!Array.isArray(name)) ? [name] : name;\r\n        // generate unique identifiers for each name\r\n        var i;\r\n        for (i = 0; i < id.length; i++) {\r\n            if (!(id[i] instanceof PerfMeasurement)) {\r\n                if (_reentTests[id[i]] === undefined) {\r\n                    _reentTests[id[i]] = 0;\r\n                } else {\r\n                    _reentTests[id[i]]++;\r\n                }\r\n                id[i] = new PerfMeasurement(undefined, id[i], _reentTests[id[i]]);\r\n            }\r\n        }\r\n        return id;\r\n    }\r\n\r\n    /**\r\n     * @private\r\n     * Helper function for markStart()\r\n     *\r\n     * @param {Object} id  Timer id.\r\n     * @param {number} time  Timer start time.\r\n     */\r\n    function _markStart(id, time) {\r\n        if (activeTests[id.id]) {\r\n            console.error("Recursive tests with the same id are not supported. Timer id: " + id.id);\r\n        }\r\n\r\n        activeTests[id.id] = { startTime: time };\r\n    }\r\n\r\n    /**\r\n     * Start a new named timer. The name should be as descriptive as possible, since\r\n     * this name will appear as an entry in the performance report.\r\n     * For example: "Open file: /Users/brackets/src/ProjectManager.js"\r\n     *\r\n     * Multiple timers can be opened simultaneously.\r\n     *\r\n     * Returns an opaque set of timer ids which can be stored and used for calling\r\n     * addMeasurement(). Since name is often creating via concatenating strings this\r\n     * return value allows clients to construct the name once.\r\n     *\r\n     * @param {(string|Array.<string>)} name  Single name or an Array of names.\r\n     * @return {(Object|Array.<Object>)} Opaque timer id or array of timer ids.\r\n     */\r\n    function markStart(name) {\r\n        if (!enabled) {\r\n            return;\r\n        }\r\n\r\n        var time = brackets.app.getElapsedMilliseconds();\r\n        var id = _generatePerfMeasurements(name);\r\n        var i;\r\n\r\n        for (i = 0; i < id.length; i++) {\r\n            _markStart(id[i], time);\r\n        }\r\n        return id.length > 1 ? id : id[0];\r\n    }\r\n\r\n    /**\r\n     * Stop a timer and add its measurements to the performance data.\r\n     *\r\n     * Multiple measurements can be stored for any given name. If there are\r\n     * multiple values for a name, they are stored in an Array.\r\n     *\r\n     * If markStart() was not called for the specified timer, the\r\n     * measured time is relative to app startup.\r\n     *\r\n     * @param {Object} id  Timer id.\r\n     */\r\n    function addMeasurement(id) {\r\n        if (!enabled) {\r\n            return;\r\n        }\r\n\r\n        if (!(id instanceof PerfMeasurement)) {\r\n            id = new PerfMeasurement(id, id);\r\n        }\r\n\r\n        var elapsedTime = brackets.app.getElapsedMilliseconds();\r\n\r\n        if (activeTests[id.id]) {\r\n            elapsedTime -= activeTests[id.id].startTime;\r\n            delete activeTests[id.id];\r\n        }\r\n\r\n        if (perfData[id]) {\r\n            // We have existing data, add to it\r\n            if (Array.isArray(perfData[id])) {\r\n                perfData[id].push(elapsedTime);\r\n            } else {\r\n                // Current data is a number, convert to Array\r\n                perfData[id] = [perfData[id], elapsedTime];\r\n            }\r\n        } else {\r\n            perfData[id] = elapsedTime;\r\n        }\r\n\r\n        if (id.reent !== undefined) {\r\n            if (_reentTests[id] === 0) {\r\n                delete _reentTests[id];\r\n            } else {\r\n                _reentTests[id]--;\r\n            }\r\n        }\r\n\r\n    }\r\n\r\n    /**\r\n     * This function is similar to addMeasurement(), but it allows timing the\r\n     * *last* event, when you don\'t know which event will be the last one.\r\n     *\r\n     * Tests that are in the activeTests list, have not yet been added, so add\r\n     * measurements to the performance data, and move test to updatableTests list.\r\n     * A test is moved to the updatable list so that it no longer passes isActive().\r\n     *\r\n     * Tests that are already in the updatableTests list are updated.\r\n     *\r\n     * Caller must explicitly remove test from the updatableTests list using\r\n     * finalizeMeasurement().\r\n     *\r\n     * If markStart() was not called for the specified timer, there is no way to\r\n     * determine if this is the first or subsequent call, so the measurement is\r\n     * not updatable, and it is handled in addMeasurement().\r\n     *\r\n     * @param {Object} id  Timer id.\r\n     */\r\n    function updateMeasurement(id) {\r\n        var elapsedTime = brackets.app.getElapsedMilliseconds();\r\n\r\n        if (updatableTests[id.id]) {\r\n            // update existing measurement\r\n            elapsedTime -= updatableTests[id].startTime;\r\n\r\n            // update\r\n            if (perfData[id] && Array.isArray(perfData[id])) {\r\n                // We have existing data and it\'s an array, so update the last entry\r\n                perfData[id][perfData[id].length - 1] = elapsedTime;\r\n            } else {\r\n                // No current data or a single entry, so set/update it\r\n                perfData[id] = elapsedTime;\r\n            }\r\n\r\n        } else {\r\n            // not yet in updatable list\r\n\r\n            if (activeTests[id.id]) {\r\n                // save startTime in updatable list before addMeasurement() deletes it\r\n                updatableTests[id.id] = { startTime: activeTests[id.id].startTime };\r\n            }\r\n\r\n            // let addMeasurement() handle the initial case\r\n            addMeasurement(id);\r\n        }\r\n    }\r\n\r\n    /**\r\n     * Remove timer from lists so next action starts a new measurement\r\n     *\r\n     * updateMeasurement may not have been called, so timer may be\r\n     * in either or neither list, but should never be in both.\r\n     *\r\n     * @param {Object} id  Timer id.\r\n     */\r\n    function finalizeMeasurement(id) {\r\n        if (activeTests[id.id]) {\r\n            delete activeTests[id.id];\r\n        }\r\n\r\n        if (updatableTests[id.id]) {\r\n            delete updatableTests[id.id];\r\n        }\r\n    }\r\n\r\n    /**\r\n     * Returns whether a timer is active or not, where "active" means that\r\n     * timer has been started with addMark(), but has not been added to perfdata\r\n     * with addMeasurement().\r\n     *\r\n     * @param {Object} id  Timer id.\r\n     * @return {boolean} Whether a timer is active or not.\r\n     */\r\n    function isActive(id) {\r\n        return (activeTests[id.id]) ? true : false;\r\n    }\r\n\r\n    /**\r\n     * return single value, or comma separated values for an array or return aggregated values with\r\n     * <min value, average, max value, standard deviation>\r\n     * @param   {Array}    entry          An array or a single value\r\n     * @param   {Boolean} aggregateStats If set, the returned value will be aggregated in the form -\r\n     *                                   <min(avg)max[standard deviation]>\r\n     * @return {String}   a single value, or comma separated values in an array or\r\n     *                     <min(avg)max[standard deviation]> if aggregateStats is set\r\n     */\r\n    function getValueAsString(entry, aggregateStats) {\r\n        if (!Array.isArray(entry)) {\r\n            return entry;\r\n        }\r\n\r\n        if (aggregateStats) {\r\n            var sum = 0,\r\n                avg,\r\n                min = _.min(entry),\r\n                max = _.max(entry),\r\n                sd,\r\n                variationSum = 0;\r\n\r\n            entry.forEach(function (value) {\r\n                sum += value;\r\n            });\r\n            avg = Math.round(sum / entry.length);\r\n            entry.forEach(function (value) {\r\n                variationSum += Math.pow(value - avg, 2);\r\n            });\r\n            sd = Math.round(Math.sqrt(variationSum / entry.length));\r\n            return min + "(" + avg + ")" + max + "[" + sd + "]";\r\n        } else {\r\n            return entry.join(", ");\r\n        }\r\n    }\r\n\r\n    /**\r\n     * Returns the performance data as a tab delimited string\r\n     * @return {string}\r\n     */\r\n    function getDelimitedPerfData() {\r\n        var result = "";\r\n        _.forEach(perfData, function (entry, testName) {\r\n            result += getValueAsString(entry) + "\\t" + testName + "\\n";\r\n        });\r\n\r\n        return result;\r\n    }\r\n\r\n    /**\r\n     * Returns the measured value for the given measurement name.\r\n     * @param {Object} id The measurement to retreive.\r\n     */\r\n    function getData(id) {\r\n        if (!id) {\r\n            return perfData;\r\n        }\r\n\r\n        return perfData[id];\r\n    }\r\n\r\n    /**\r\n     * Returns the Performance metrics to be logged for health report\r\n     * @return {Object} An object with the health data logs to be sent\r\n     */\r\n    function getHealthReport() {\r\n        var healthReport = {\r\n            projectLoadTimes : "",\r\n            fileOpenTimes : ""\r\n        };\r\n\r\n        _.forEach(perfData, function (entry, testName) {\r\n            if (StringUtils.startsWith(testName, "Application Startup")) {\r\n                healthReport.AppStartupTime = getValueAsString(entry);\r\n            } else if (StringUtils.startsWith(testName, "brackets module dependencies resolved")) {\r\n                healthReport.ModuleDepsResolved = getValueAsString(entry);\r\n            } else if (StringUtils.startsWith(testName, "Load Project")) {\r\n                healthReport.projectLoadTimes += ":" + getValueAsString(entry, true);\r\n            } else if (StringUtils.startsWith(testName, "Open File")) {\r\n                healthReport.fileOpenTimes += ":" + getValueAsString(entry, true);\r\n            }\r\n        });\r\n\r\n        return healthReport;\r\n    }\r\n\r\n    function searchData(regExp) {\r\n        var keys = Object.keys(perfData).filter(function (key) {\r\n            return regExp.test(key);\r\n        });\r\n\r\n        var datas = [];\r\n\r\n        keys.forEach(function (key) {\r\n            datas.push(perfData[key]);\r\n        });\r\n\r\n        return datas;\r\n    }\r\n\r\n    /**\r\n     * Clear all logs including metric data and active tests.\r\n     */\r\n    function clear() {\r\n        perfData = {};\r\n        activeTests = {};\r\n        updatableTests = {};\r\n        _reentTests = {};\r\n    }\r\n\r\n    // create performance measurement constants\r\n    createPerfMeasurement("INLINE_WIDGET_OPEN", "Open inline editor or docs");\r\n    createPerfMeasurement("INLINE_WIDGET_CLOSE", "Close inline editor or docs");\r\n\r\n    // extensions may create additional measurement constants during their lifecycle\r\n\r\n    exports.addMeasurement          = addMeasurement;\r\n    exports.finalizeMeasurement     = finalizeMeasurement;\r\n    exports.isActive                = isActive;\r\n    exports.markStart               = markStart;\r\n    exports.getData                 = getData;\r\n    exports.searchData              = searchData;\r\n    exports.updateMeasurement       = updateMeasurement;\r\n    exports.getDelimitedPerfData    = getDelimitedPerfData;\r\n    exports.createPerfMeasurement   = createPerfMeasurement;\r\n    exports.clear                   = clear;\r\n    exports.getHealthReport         = getHealthReport;\r\n});\r\n\n//# sourceURL=/utils/PerfUtils.js'),
eval('/**\r\n * @license RequireJS i18n 2.0.2 Copyright (c) 2010-2012, The Dojo Foundation All Rights Reserved.\r\n * Available via the MIT or new BSD license.\r\n * see: http://github.com/requirejs/i18n for details\r\n */\r\n/*jslint regexp: true */\r\n/*global require: false, navigator: false, define: false */\r\n\r\n/**\r\n * This plugin handles i18n! prefixed modules. It does the following:\r\n *\r\n * 1) A regular module can have a dependency on an i18n bundle, but the regular\r\n * module does not want to specify what locale to load. So it just specifies\r\n * the top-level bundle, like "i18n!nls/colors".\r\n *\r\n * This plugin will load the i18n bundle at nls/colors, see that it is a root/master\r\n * bundle since it does not have a locale in its name. It will then try to find\r\n * the best match locale available in that master bundle, then request all the\r\n * locale pieces for that best match locale. For instance, if the locale is "en-us",\r\n * then the plugin will ask for the "en-us", "en" and "root" bundles to be loaded\r\n * (but only if they are specified on the master bundle).\r\n *\r\n * Once all the bundles for the locale pieces load, then it mixes in all those\r\n * locale pieces into each other, then finally sets the context.defined value\r\n * for the nls/colors bundle to be that mixed in locale.\r\n *\r\n * 2) A regular module specifies a specific locale to load. For instance,\r\n * i18n!nls/fr-fr/colors. In this case, the plugin needs to load the master bundle\r\n * first, at nls/colors, then figure out what the best match locale is for fr-fr,\r\n * since maybe only fr or just root is defined for that locale. Once that best\r\n * fit is found, all of its locale pieces need to have their bundles loaded.\r\n *\r\n * Once all the bundles for the locale pieces load, then it mixes in all those\r\n * locale pieces into each other, then finally sets the context.defined value\r\n * for the nls/fr-fr/colors bundle to be that mixed in locale.\r\n */\r\n(function () {\r\n    \'use strict\';\r\n\r\n    //regexp for reconstructing the master bundle name from parts of the regexp match\r\n    //nlsRegExp.exec("foo/bar/baz/nls/en-ca/foo") gives:\r\n    //["foo/bar/baz/nls/en-ca/foo", "foo/bar/baz/nls/", "/", "/", "en-ca", "foo"]\r\n    //nlsRegExp.exec("foo/bar/baz/nls/foo") gives:\r\n    //["foo/bar/baz/nls/foo", "foo/bar/baz/nls/", "/", "/", "foo", ""]\r\n    //so, if match[5] is blank, it means this is the top bundle definition.\r\n    var nlsRegExp = /(^.*(^|\\/)nls(\\/|$))([^\\/]*)\\/?([^\\/]*)/;\r\n\r\n    //Helper function to avoid repeating code. Lots of arguments in the\r\n    //desire to stay functional and support RequireJS contexts without having\r\n    //to know about the RequireJS contexts.\r\n    function addPart(locale, master, needed, toLoad, prefix, suffix) {\r\n        if (master[locale]) {\r\n            needed.push(locale);\r\n            if (master[locale] === true || master[locale] === 1) {\r\n                toLoad.push(prefix + locale + \'/\' + suffix);\r\n            }\r\n        }\r\n    }\r\n\r\n    function addIfExists(req, locale, toLoad, prefix, suffix) {\r\n        var fullName = prefix + locale + \'/\' + suffix;\r\n        if (require._fileExists(req.toUrl(fullName + \'.js\'))) {\r\n            toLoad.push(fullName);\r\n        }\r\n    }\r\n\r\n    /**\r\n     * Simple function to mix in properties from source into target,\r\n     * but only if target does not already have a property of the same name.\r\n     * This is not robust in IE for transferring methods that match\r\n     * Object.prototype names, but the uses of mixin here seem unlikely to\r\n     * trigger a problem related to that.\r\n     */\r\n    function mixin(target, source, force) {\r\n        var prop;\r\n        for (prop in source) {\r\n            if (source.hasOwnProperty(prop) && (!target.hasOwnProperty(prop) || force)) {\r\n                target[prop] = source[prop];\r\n            } else if (typeof source[prop] === \'object\') {\r\n                mixin(target[prop], source[prop], force);\r\n            }\r\n        }\r\n    }\r\n\r\n    define(\'i18n\',[\'module\'], function (module) {\r\n        var masterConfig = module.config ? module.config() : {};\r\n\r\n        return {\r\n            version: \'2.0.1+\',\r\n            /**\r\n             * Called when a dependency needs to be loaded.\r\n             */\r\n            load: function (name, req, onLoad, config) {\r\n                config = config || {};\r\n\r\n                if (config.locale) {\r\n                    masterConfig.locale = config.locale;\r\n                }\r\n\r\n                var masterName,\r\n                    match = nlsRegExp.exec(name),\r\n                    prefix = match[1],\r\n                    locale = match[4],\r\n                    suffix = match[5],\r\n                    parts = locale.split("-"),\r\n                    toLoad = [],\r\n                    value = {},\r\n                    i, part, current = "";\r\n\r\n                //If match[5] is blank, it means this is the top bundle definition,\r\n                //so it does not have to be handled. Locale-specific requests\r\n                //will have a match[4] value but no match[5]\r\n                if (match[5]) {\r\n                    //locale-specific bundle\r\n                    prefix = match[1];\r\n                    masterName = prefix + suffix;\r\n                } else {\r\n                    //Top-level bundle.\r\n                    masterName = name;\r\n                    suffix = match[4];\r\n                    locale = masterConfig.locale;\r\n                    if (!locale) {\r\n                        locale = masterConfig.locale =\r\n                            typeof navigator === "undefined" ? "root" :\r\n                            (navigator.language ||\r\n                             navigator.userLanguage || "root").toLowerCase();\r\n                    }\r\n                    parts = locale.split("-");\r\n                }\r\n\r\n                if (config.isBuild) {\r\n                    //Check for existence of all locale possible files and\r\n                    //require them if exist.\r\n                    toLoad.push(masterName);\r\n                    addIfExists(req, "root", toLoad, prefix, suffix);\r\n                    for (i = 0; i < parts.length; i++) {\r\n                        part = parts[i];\r\n                        current += (current ? "-" : "") + part;\r\n                        addIfExists(req, current, toLoad, prefix, suffix);\r\n                    }\r\n\r\n                    req(toLoad, function () {\r\n                        onLoad();\r\n                    });\r\n                } else {\r\n                    //First, fetch the master bundle, it knows what locales are available.\r\n                    req([masterName], function (master) {\r\n                        //Figure out the best fit\r\n                        var needed = [],\r\n                            part;\r\n\r\n                        //Always allow for root, then do the rest of the locale parts.\r\n                        addPart("root", master, needed, toLoad, prefix, suffix);\r\n                        for (i = 0; i < parts.length; i++) {\r\n                            part = parts[i];\r\n                            current += (current ? "-" : "") + part;\r\n                            addPart(current, master, needed, toLoad, prefix, suffix);\r\n                        }\r\n\r\n                        //Load all the parts missing.\r\n                        req(toLoad, function () {\r\n                            var i, partBundle, part;\r\n                            for (i = needed.length - 1; i > -1 && needed[i]; i--) {\r\n                                part = needed[i];\r\n                                partBundle = master[part];\r\n                                if (partBundle === true || partBundle === 1) {\r\n                                    partBundle = req(prefix + part + \'/\' + suffix);\r\n                                }\r\n                                mixin(value, partBundle);\r\n                            }\r\n\r\n                            //All done, notify the loader.\r\n                            onLoad(value);\r\n                        });\r\n                    });\r\n                }\r\n            }\r\n        };\r\n    });\r\n}());\r\n\n//# sourceURL=/thirdparty/i18n/i18n.js'),eval('/*\r\n * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\ndefine(\'nls/strings\',[\'require\',\'exports\',\'module\'],function (require, exports, module) {\r\n\r\n    "use strict";\r\n\r\n    // Code that needs to display user strings should call require("strings") to load\r\n    // src/strings.js. This file will dynamically load strings.js for the specified brackets.locale.\r\n    //\r\n    // See the README.md file in this folder for information on how to add a new translation for\r\n    // another language or locale.\r\n    //\r\n    // TODO: dynamically populate the local prefix list below?\r\n    module.exports = {\r\n        root: true,\r\n        "bg": true,\r\n        "cs": true,\r\n        "da": true,\r\n        "de": true,\r\n        "el": true,\r\n        "en-gb": true,\r\n        "es": true,\r\n        "fa-ir": true,\r\n        "fi": true,\r\n        "fr": true,\r\n        "gl": true,\r\n        "hr": true,\r\n        "hu": true,\r\n        "id": true,\r\n        "it": true,\r\n        "ja": true,\r\n        "ko": true,\r\n        "lv": true,\r\n        "nb": true,\r\n        "nl": true,\r\n        "pl": true,\r\n        "pt-br": true,\r\n        "pt-pt": true,\r\n        "ro": true,\r\n        "ru": true,\r\n        "sk": true,\r\n        "sr": true,\r\n        "sv": true,\r\n        "tr": true,\r\n        "uk": true,\r\n        "zh-cn": true,\r\n        "zh-tw": true\r\n    };\r\n});\r\n\n//# sourceURL=/nls/strings.js'),eval('/*\r\n * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\ndefine(\'nls/root/strings\',{\r\n\r\n    /**\r\n     * Errors\r\n     */\r\n\r\n    // General file io error strings\r\n    "GENERIC_ERROR"                     : "(error {0})",\r\n    "NOT_FOUND_ERR"                     : "The file/directory could not be found.",\r\n    "NOT_READABLE_ERR"                  : "The file/directory could not be read.",\r\n    "EXCEEDS_MAX_FILE_SIZE"             : "Files larger than {0} MB cannot be opened in {APP_NAME}.",\r\n    "NO_MODIFICATION_ALLOWED_ERR"       : "The target directory cannot be modified.",\r\n    "NO_MODIFICATION_ALLOWED_ERR_FILE"  : "The permissions do not allow you to make modifications.",\r\n    "CONTENTS_MODIFIED_ERR"             : "The file has been modified outside of {APP_NAME}.",\r\n    "UNSUPPORTED_ENCODING_ERR"          : "Unknown encoding format",\r\n    "ENCODE_FILE_FAILED_ERR"            : "{APP_NAME} was not able to encode the contents of file.",\r\n    "DECODE_FILE_FAILED_ERR"            : "{APP_NAME} was not able to decode the contents of file.",\r\n    "UNSUPPORTED_UTF16_ENCODING_ERR"    : "{APP_NAME} currently doesn\'t support UTF-16 encoded text files.",\r\n    "FILE_EXISTS_ERR"                   : "The file or directory already exists.",\r\n    "FILE"                              : "file",\r\n    "FILE_TITLE"                        : "File",\r\n    "DIRECTORY"                         : "directory",\r\n    "DIRECTORY_TITLE"                   : "Directory",\r\n    "DIRECTORY_NAMES_LEDE"              : "Directory names",\r\n    "FILENAMES_LEDE"                    : "Filenames",\r\n    "FILENAME"                          : "Filename",\r\n    "DIRECTORY_NAME"                    : "Directory Name",\r\n\r\n    // Project error strings\r\n    "ERROR_LOADING_PROJECT"             : "Error Loading Project",\r\n    "OPEN_DIALOG_ERROR"                 : "An error occurred when showing the open file dialog. (error {0})",\r\n    "REQUEST_NATIVE_FILE_SYSTEM_ERROR"  : "An error occurred when trying to load the directory <span class=\'dialog-filename\'>{0}</span>. (error {1})",\r\n    "READ_DIRECTORY_ENTRIES_ERROR"      : "An error occurred when reading the contents of the directory <span class=\'dialog-filename\'>{0}</span>. (error {1})",\r\n\r\n    // File open/save error string\r\n    "ERROR_OPENING_FILE_TITLE"          : "Error Opening File",\r\n    "ERROR_OPENING_FILE"                : "An error occurred when trying to open the file <span class=\'dialog-filename\'>{0}</span>. {1}",\r\n    "ERROR_OPENING_FILES"               : "An error occurred when trying to open the following files:",\r\n    "ERROR_RELOADING_FILE_TITLE"        : "Error Reloading Changes From Disk",\r\n    "ERROR_RELOADING_FILE"              : "An error occurred when trying to reload the file <span class=\'dialog-filename\'>{0}</span>. {1}",\r\n    "ERROR_SAVING_FILE_TITLE"           : "Error Saving File",\r\n    "ERROR_SAVING_FILE"                 : "An error occurred when trying to save the file <span class=\'dialog-filename\'>{0}</span>. {1}",\r\n    "ERROR_RENAMING_FILE_TITLE"         : "Error Renaming {0}",\r\n    "ERROR_RENAMING_FILE"               : "An error occurred when trying to rename the {2} <span class=\'dialog-filename\'>{0}</span>. {1}",\r\n    "ERROR_RENAMING_NOT_IN_PROJECT"     : "The file or directory is not part of the currently opened project. Unfortunately, only project files can be renamed at this point.",\r\n    "ERROR_DELETING_FILE_TITLE"         : "Error Deleting {0}",\r\n    "ERROR_DELETING_FILE"               : "An error occurred when trying to delete the {2} <span class=\'dialog-filename\'>{0}</span>. {1}",\r\n    "INVALID_FILENAME_TITLE"            : "Invalid {0}",\r\n    "INVALID_FILENAME_MESSAGE"          : "{0} cannot use any system reserved words, end with dots (.) or use any of the following characters: <code class=\'emphasized\'>{1}</code>",\r\n    "ENTRY_WITH_SAME_NAME_EXISTS"       : "A file or directory with the name <span class=\'dialog-filename\'>{0}</span> already exists.",\r\n    "ERROR_CREATING_FILE_TITLE"         : "Error Creating {0}",\r\n    "ERROR_CREATING_FILE"               : "An error occurred when trying to create the {0} <span class=\'dialog-filename\'>{1}</span>. {2}",\r\n    "ERROR_MIXED_DRAGDROP"              : "Cannot open a folder at the same time as opening other files.",\r\n\r\n    // User key map error strings\r\n    "ERROR_KEYMAP_TITLE"                : "Error Reading User Key Map",\r\n    "ERROR_KEYMAP_CORRUPT"              : "Your key map file is not valid JSON. The file will be opened so that you can correct the format.",\r\n    "ERROR_LOADING_KEYMAP"              : "Your key map file is not a valid UTF-8 encoded text file and cannot be loaded",\r\n    "ERROR_RESTRICTED_COMMANDS"         : "You cannot reassign shortcuts to these commands: {0}",\r\n    "ERROR_RESTRICTED_SHORTCUTS"        : "You cannot reassign these shortcuts: {0}",\r\n    "ERROR_MULTIPLE_SHORTCUTS"          : "You are reassigning multiple shortcuts to these commands: {0}",\r\n    "ERROR_DUPLICATE_SHORTCUTS"         : "You have multiple bindings of these shortcuts: {0}",\r\n    "ERROR_INVALID_SHORTCUTS"           : "These shortcuts are invalid: {0}",\r\n    "ERROR_NONEXISTENT_COMMANDS"        : "You are assigning shortcuts to nonexistent commands: {0}",\r\n\r\n    // Application preferences corrupt error strings\r\n    "ERROR_PREFS_CORRUPT_TITLE"         : "Error Reading Preferences",\r\n    "ERROR_PREFS_CORRUPT"               : "Your preferences file is not valid JSON. The file will be opened so that you can correct the format. You will need to restart {APP_NAME} for the changes to take effect.",\r\n    "ERROR_PROJ_PREFS_CORRUPT"          : "Your project preferences file is not valid JSON. The file will be opened so that you can correct the format. You will need to reload the project for the changes to take effect.",\r\n\r\n    // Application error strings\r\n    "ERROR_IN_BROWSER_TITLE"            : "Oops! {APP_NAME} Doesn\'t Run in Browsers Yet.",\r\n    "ERROR_IN_BROWSER"                  : "{APP_NAME} is built in HTML, but right now it runs as a desktop app so you can use it to edit local files. Please use the application shell in the <b>github.com/adobe/brackets-shell</b> repo to run {APP_NAME}.",\r\n\r\n    // ProjectManager max files error string\r\n    "ERROR_MAX_FILES_TITLE"             : "Error Indexing Files",\r\n    "ERROR_MAX_FILES"                   : "This project contains more than 30,000 files. Features that operate across multiple files may be disabled or behave as if the project is empty. <a href=\'https://github.com/adobe/brackets/wiki/Large-Projects\'>Read more about working with large projects</a>.",\r\n\r\n    // Live Preview error strings\r\n    "ERROR_LAUNCHING_BROWSER_TITLE"     : "Error Launching Browser",\r\n    "ERROR_CANT_FIND_CHROME"            : "The Google Chrome browser could not be found. Please make sure it is installed.",\r\n    "ERROR_LAUNCHING_BROWSER"           : "An error occurred when launching the browser. (error {0})",\r\n\r\n    "LIVE_DEVELOPMENT_ERROR_TITLE"      : "Live Preview Error",\r\n    "LIVE_DEVELOPMENT_RELAUNCH_TITLE"   : "Connecting to Browser",\r\n    "LIVE_DEVELOPMENT_ERROR_MESSAGE"    : "In order for Live Preview to connect, Chrome needs to be relaunched with remote debugging enabled.<br /><br />Would you like to relaunch Chrome and enable remote debugging?<br /><br />",\r\n    "LIVE_DEV_LOADING_ERROR_MESSAGE"    : "Unable to load Live Preview page.",\r\n    "LIVE_DEV_NEED_HTML_MESSAGE"        : "Open an HTML file or make sure there is an index.html file in your project in order to launch live preview.",\r\n    "LIVE_DEV_NEED_BASEURL_MESSAGE"     : "To launch live preview with a server-side file, you need to specify a Base URL for this project.",\r\n    "LIVE_DEV_SERVER_NOT_READY_MESSAGE" : "Error starting up the HTTP server for live preview files. Please try again.",\r\n    "LIVE_DEVELOPMENT_INFO_TITLE"       : "Welcome to Live Preview!",\r\n    "LIVE_DEVELOPMENT_INFO_MESSAGE"     : "Live Preview connects {APP_NAME} to your browser. It launches a preview of your HTML file in the browser, then updates the preview instantly as you edit your code.<br /><br />In this early version of {APP_NAME}, Live Preview only works with <strong>Google Chrome</strong> and updates live as you edit <strong>CSS or HTML files</strong>. Changes to JavaScript files are automatically reloaded when you save.<br /><br />(You\'ll only see this message once.)",\r\n    "LIVE_DEVELOPMENT_TROUBLESHOOTING"  : "For more information, see <a href=\'{0}\' title=\'{0}\'>Troubleshooting Live Preview connection errors</a>.",\r\n\r\n    "LIVE_DEV_STATUS_TIP_NOT_CONNECTED" : "Live Preview",\r\n    "LIVE_DEV_STATUS_TIP_PROGRESS1"     : "Live Preview: Connecting\\u2026",\r\n    "LIVE_DEV_STATUS_TIP_PROGRESS2"     : "Live Preview: Initializing\\u2026",\r\n    "LIVE_DEV_STATUS_TIP_CONNECTED"     : "Disconnect Live Preview",\r\n    "LIVE_DEV_STATUS_TIP_OUT_OF_SYNC"   : "Live Preview (save file to refresh)",\r\n    "LIVE_DEV_STATUS_TIP_SYNC_ERROR"    : "Live Preview (not updating due to syntax error)",\r\n\r\n    "LIVE_DEV_DETACHED_REPLACED_WITH_DEVTOOLS" : "Live Preview was canceled because the browser\'s developer tools were opened",\r\n    "LIVE_DEV_DETACHED_TARGET_CLOSED"          : "Live Preview was canceled because the page was closed in the browser",\r\n    "LIVE_DEV_NAVIGATED_AWAY"                  : "Live Preview was canceled because the browser navigated to a page that is not part of the current project",\r\n    "LIVE_DEV_CLOSED_UNKNOWN_REASON"           : "Live Preview was canceled for an unknown reason ({0})",\r\n\r\n    "SAVE_CLOSE_TITLE"                  : "Save Changes",\r\n    "SAVE_CLOSE_MESSAGE"                : "Do you want to save the changes you made in the document <span class=\'dialog-filename\'>{0}</span>?",\r\n    "SAVE_CLOSE_MULTI_MESSAGE"          : "Do you want to save your changes to the following files?",\r\n    "EXT_MODIFIED_TITLE"                : "External Changes",\r\n    "CONFIRM_DELETE_TITLE"              : "Confirm Delete",\r\n    "CONFIRM_FILE_DELETE"               : "Are you sure you want to delete the file <span class=\'dialog-filename\'>{0}</span>?",\r\n    "CONFIRM_FOLDER_DELETE"             : "Are you sure you want to delete the folder <span class=\'dialog-filename\'>{0}</span>?",\r\n    "FILE_DELETED_TITLE"                : "File Deleted",\r\n    "EXT_MODIFIED_WARNING"              : "<span class=\'dialog-filename\'>{0}</span> has been modified on disk outside of {APP_NAME}.<br /><br />Do you want to save the file and overwrite those changes?",\r\n    "EXT_MODIFIED_MESSAGE"              : "<span class=\'dialog-filename\'>{0}</span> has been modified on disk outside of {APP_NAME}, but also has unsaved changes in {APP_NAME}.<br /><br />Which version do you want to keep?",\r\n    "EXT_DELETED_MESSAGE"               : "<span class=\'dialog-filename\'>{0}</span> has been deleted on disk outside of {APP_NAME}, but has unsaved changes in {APP_NAME}.<br /><br />Do you want to keep your changes?",\r\n    \r\n    // Window unload warning messages\r\n    "WINDOW_UNLOAD_WARNING"                      : "Are you sure you want to navigate to a different URL and leave Brackets?",\r\n    "WINDOW_UNLOAD_WARNING_WITH_UNSAVED_CHANGES" : "You have unsaved changes! Are you sure you want to navigate to a different URL and leave Brackets?",\r\n\r\n    // Generic dialog/button labels\r\n    "DONE"                              : "Done",\r\n    "OK"                                : "OK",\r\n    "CANCEL"                            : "Cancel",\r\n    "DONT_SAVE"                         : "Don\'t Save",\r\n    "SAVE"                              : "Save",\r\n    "SAVE_AS"                           : "Save As\\u2026",\r\n    "SAVE_AND_OVERWRITE"                : "Overwrite",\r\n    "DELETE"                            : "Delete",\r\n    "BUTTON_YES"                        : "Yes",\r\n    "BUTTON_NO"                         : "No",\r\n\r\n    // Find, Replace, Find in Files\r\n    "FIND_MATCH_INDEX"                  : "{0} of {1}",\r\n    "FIND_NO_RESULTS"                   : "No results",\r\n    "FIND_QUERY_PLACEHOLDER"            : "Find\\u2026",\r\n    "FIND_HISTORY_MAX_COUNT"            : "Maximum Number of Search Items in Search History",\r\n    "REPLACE_PLACEHOLDER"               : "Replace with\\u2026",\r\n    "BUTTON_REPLACE_ALL"                : "Replace All",\r\n    "BUTTON_REPLACE_BATCH"              : "Batch\\u2026",\r\n    "BUTTON_REPLACE_ALL_IN_FILES"       : "Replace\\u2026",\r\n    "BUTTON_REPLACE"                    : "Replace",\r\n    "BUTTON_NEXT"                       : "\\u25B6",\r\n    "BUTTON_PREV"                       : "\\u25C0",\r\n    "BUTTON_NEXT_HINT"                  : "Next Match",\r\n    "BUTTON_PREV_HINT"                  : "Previous Match",\r\n    "BUTTON_CASESENSITIVE_HINT"         : "Match Case",\r\n    "BUTTON_REGEXP_HINT"                : "Regular Expression",\r\n    "REPLACE_WITHOUT_UNDO_WARNING_TITLE": "Replace Without Undo",\r\n    "REPLACE_WITHOUT_UNDO_WARNING"      : "Because more than {0} files need to be changed, {APP_NAME} will modify unopened files on disk.<br />You won\'t be able to undo replacements in those files.",\r\n    "BUTTON_REPLACE_WITHOUT_UNDO"       : "Replace Without Undo",\r\n\r\n    "OPEN_FILE"                         : "Open File",\r\n    "SAVE_FILE_AS"                      : "Save File",\r\n    "CHOOSE_FOLDER"                     : "Choose a folder",\r\n\r\n    "RELEASE_NOTES"                     : "Release Notes",\r\n    "NO_UPDATE_TITLE"                   : "You\'re Up to Date!",\r\n    "NO_UPDATE_MESSAGE"                 : "You are running the latest version of {APP_NAME}.",\r\n\r\n    // Find and Replace\r\n    "FIND_REPLACE_TITLE_LABEL"          : "Replace",\r\n    "FIND_REPLACE_TITLE_WITH"           : "with",\r\n    "FIND_TITLE_LABEL"                  : "Found",\r\n    "FIND_TITLE_SUMMARY"                : "&mdash; {0} {1} {2} in {3}",\r\n\r\n    // Find in Files\r\n    "FIND_NUM_FILES"                    : "{0} {1}",\r\n    "FIND_IN_FILES_SCOPED"              : "in <span class=\'dialog-filename\'>{0}</span>",\r\n    "FIND_IN_FILES_NO_SCOPE"            : "in project",\r\n    "FIND_IN_FILES_ZERO_FILES"          : "Filter excludes all files {0}",\r\n    "FIND_IN_FILES_FILE"                : "file",\r\n    "FIND_IN_FILES_FILES"               : "files",\r\n    "FIND_IN_FILES_MATCH"               : "match",\r\n    "FIND_IN_FILES_MATCHES"             : "matches",\r\n    "FIND_IN_FILES_MORE_THAN"           : "Over ",\r\n    "FIND_IN_FILES_PAGING"              : "{0}&mdash;{1}",\r\n    "FIND_IN_FILES_FILE_PATH"           : "<span class=\'dialog-filename\'>{0}</span> {2} <span class=\'dialog-path\'>{1}</span>", // We should use normal dashes on Windows instead of em dash eventually\r\n    "FIND_IN_FILES_EXPAND_COLLAPSE"     : "Ctrl/Cmd click to expand/collapse all",\r\n    "FIND_IN_FILES_INDEXING"            : "Indexing for Instant Search\\u2026",\r\n    "REPLACE_IN_FILES_ERRORS_TITLE"     : "Replace Errors",\r\n    "REPLACE_IN_FILES_ERRORS"           : "The following files weren\'t modified because they changed after the search or couldn\'t be written.",\r\n\r\n    "ERROR_FETCHING_UPDATE_INFO_TITLE"  : "Error Getting Update Info",\r\n    "ERROR_FETCHING_UPDATE_INFO_MSG"    : "There was a problem getting the latest update information from the server. Please make sure you are connected to the Internet and try again.",\r\n\r\n    // File exclusion filters\r\n    "NEW_FILE_FILTER"                   : "New Exclusion Set\\u2026",\r\n    "CLEAR_FILE_FILTER"                 : "Don\'t Exclude Files",\r\n    "NO_FILE_FILTER"                    : "No Files Excluded",\r\n    "EXCLUDE_FILE_FILTER"               : "Exclude {0}",\r\n    "EDIT_FILE_FILTER"                  : "Edit\\u2026",\r\n    "FILE_FILTER_DIALOG"                : "Edit Exclusion Set",\r\n    "FILE_FILTER_INSTRUCTIONS"          : "Exclude files and folders matching any of the following strings / substrings or <a href=\'{0}\' title=\'{0}\'>wildcards</a>. Enter each string on a new line.",\r\n    "FILTER_NAME_PLACEHOLDER"           : "Name this exclusion set (optional)",\r\n    "FILTER_NAME_REMAINING"             : "{0} characters remaining",\r\n    "FILE_FILTER_CLIPPED_SUFFIX"        : "and {0} more",\r\n    "FILTER_COUNTING_FILES"             : "Counting files\\u2026",\r\n    "FILTER_FILE_COUNT"                 : "Allows {0} of {1} files {2}",\r\n    "FILTER_FILE_COUNT_ALL"             : "Allows all {0} files {1}",\r\n\r\n    // Quick Edit\r\n    "ERROR_QUICK_EDIT_PROVIDER_NOT_FOUND"   : "No Quick Edit available for current cursor position",\r\n    "ERROR_CSSQUICKEDIT_BETWEENCLASSES"     : "CSS Quick Edit: place cursor on a single class name",\r\n    "ERROR_CSSQUICKEDIT_CLASSNOTFOUND"      : "CSS Quick Edit: incomplete class attribute",\r\n    "ERROR_CSSQUICKEDIT_IDNOTFOUND"         : "CSS Quick Edit: incomplete id attribute",\r\n    "ERROR_CSSQUICKEDIT_UNSUPPORTEDATTR"    : "CSS Quick Edit: place cursor in tag, class, or id",\r\n    "ERROR_TIMINGQUICKEDIT_INVALIDSYNTAX"   : "CSS Timing Function Quick Edit: invalid syntax",\r\n    "ERROR_JSQUICKEDIT_FUNCTIONNOTFOUND"    : "JS Quick Edit: place cursor in function name",\r\n\r\n    // Quick Docs\r\n    "ERROR_QUICK_DOCS_PROVIDER_NOT_FOUND"   : "No Quick Docs available for current cursor position",\r\n\r\n    /**\r\n     * ProjectManager\r\n     */\r\n    "PROJECT_LOADING"   : "Loading\\u2026",\r\n    "UNTITLED"          : "Untitled",\r\n    "WORKING_FILES"     : "Working Files",\r\n\r\n    /**\r\n     * MainViewManager\r\n     */\r\n    "TOP"               : "Top",\r\n    "BOTTOM"            : "Bottom",\r\n    "LEFT"              : "Left",\r\n    "RIGHT"             : "Right",\r\n\r\n    "CMD_SPLITVIEW_NONE"        : "No Split",\r\n    "CMD_SPLITVIEW_VERTICAL"    : "Vertical Split",\r\n    "CMD_SPLITVIEW_HORIZONTAL"  : "Horizontal Split",\r\n    "SPLITVIEW_MENU_TOOLTIP"    : "Split the editor vertically or horizontally",\r\n    "GEAR_MENU_TOOLTIP"         : "Configure Working Set",\r\n\r\n    "SPLITVIEW_INFO_TITLE"              : "Already Open",\r\n    "SPLITVIEW_MULTIPANE_WARNING"       : "The file is already open in another pane. {APP_NAME} will soon support opening the same file in more than one pane. Until then, the file will be shown in the pane it\'s already open in.<br /><br />(You\'ll only see this message once.)",\r\n\r\n    /**\r\n     * Keyboard modifiers and special key names\r\n     */\r\n    "KEYBOARD_CTRL"         : "Ctrl",\r\n    "KEYBOARD_SHIFT"        : "Shift",\r\n    "KEYBOARD_SPACE"        : "Space",\r\n    "KEYBOARD_PAGE_UP"      : "Page Up",\r\n    "KEYBOARD_PAGE_DOWN"    : "Page Down",\r\n    "KEYBOARD_HOME"         : "Home",\r\n    "KEYBOARD_END"          : "End",\r\n    "KEYBOARD_INSERT"       : "Insert",\r\n    "KEYBOARD_DELETE"       : "Delete",\r\n\r\n    /**\r\n     * StatusBar strings\r\n     */\r\n    "STATUSBAR_CURSOR_POSITION"             : "Line {0}, Column {1}",\r\n    "STATUSBAR_SELECTION_CH_SINGULAR"       : " \\u2014 Selected {0} column",\r\n    "STATUSBAR_SELECTION_CH_PLURAL"         : " \\u2014 Selected {0} columns",\r\n    "STATUSBAR_SELECTION_LINE_SINGULAR"     : " \\u2014 Selected {0} line",\r\n    "STATUSBAR_SELECTION_LINE_PLURAL"       : " \\u2014 Selected {0} lines",\r\n    "STATUSBAR_SELECTION_MULTIPLE"          : " \\u2014 {0} selections",\r\n    "STATUSBAR_INDENT_TOOLTIP_SPACES"       : "Click to switch indentation to spaces",\r\n    "STATUSBAR_INDENT_TOOLTIP_TABS"         : "Click to switch indentation to tabs",\r\n    "STATUSBAR_INDENT_SIZE_TOOLTIP_SPACES"  : "Click to change number of spaces used when indenting",\r\n    "STATUSBAR_INDENT_SIZE_TOOLTIP_TABS"    : "Click to change tab character width",\r\n    "STATUSBAR_SPACES"                      : "Spaces:",\r\n    "STATUSBAR_TAB_SIZE"                    : "Tab Size:",\r\n    "STATUSBAR_LINE_COUNT_SINGULAR"         : "\\u2014 {0} Line",\r\n    "STATUSBAR_LINE_COUNT_PLURAL"           : "\\u2014 {0} Lines",\r\n    "STATUSBAR_USER_EXTENSIONS_DISABLED"    : "Extensions Disabled",\r\n    "STATUSBAR_INSERT"                      : "INS",\r\n    "STATUSBAR_OVERWRITE"                   : "OVR",\r\n    "STATUSBAR_INSOVR_TOOLTIP"              : "Click to toggle cursor between Insert (INS) and Overwrite (OVR) modes",\r\n    "STATUSBAR_LANG_TOOLTIP"                : "Click to change file type",\r\n    "STATUSBAR_CODE_INSPECTION_TOOLTIP"     : "{0}. Click to toggle report panel.",\r\n    "STATUSBAR_DEFAULT_LANG"                : "(default)",\r\n    "STATUSBAR_SET_DEFAULT_LANG"            : "Set as Default for .{0} Files",\r\n    "STATUSBAR_ENCODING_TOOLTIP"            : "Select the encoding",\r\n\r\n    // CodeInspection: errors/warnings\r\n    "ERRORS_PANEL_TITLE_MULTIPLE"           : "{0} Problems",\r\n    "SINGLE_ERROR"                          : "1 {0} Problem",\r\n    "MULTIPLE_ERRORS"                       : "{1} {0} Problems",\r\n    "NO_ERRORS"                             : "No {0} problems found - good job!",\r\n    "NO_ERRORS_MULTIPLE_PROVIDER"           : "No problems found - good job!",\r\n    "LINT_DISABLED"                         : "Linting is disabled",\r\n    "NO_LINT_AVAILABLE"                     : "No linter available for {0}",\r\n    "NOTHING_TO_LINT"                       : "Nothing to lint",\r\n    "LINTER_TIMED_OUT"                      : "{0} has timed out after waiting for {1} ms",\r\n    "LINTER_FAILED"                         : "{0} terminated with error: {1}",\r\n\r\n    /**\r\n     * Command Name Constants\r\n     */\r\n\r\n    // File menu commands\r\n    "FILE_MENU"                           : "File",\r\n    "CMD_FILE_NEW_UNTITLED"               : "New",\r\n    "CMD_FILE_NEW"                        : "New File",\r\n    "CMD_FILE_NEW_FOLDER"                 : "New Folder",\r\n    "CMD_FILE_OPEN"                       : "Open\\u2026",\r\n    "CMD_RECENT_FILES_OPEN"               : "Open Recent\\u2026",\r\n    "CMD_ADD_TO_WORKING_SET"              : "Open To Working Set",\r\n    "CMD_OPEN_DROPPED_FILES"              : "Open Dropped Files",\r\n    "CMD_OPEN_FOLDER"                     : "Open Folder\\u2026",\r\n    "CMD_FILE_CLOSE"                      : "Close",\r\n    "CMD_FILE_CLOSE_ALL"                  : "Close All",\r\n    "CMD_FILE_CLOSE_LIST"                 : "Close List",\r\n    "CMD_FILE_CLOSE_OTHERS"               : "Close Others",\r\n    "CMD_FILE_CLOSE_ABOVE"                : "Close Others Above",\r\n    "CMD_FILE_CLOSE_BELOW"                : "Close Others Below",\r\n    "CMD_FILE_SAVE"                       : "Save",\r\n    "CMD_FILE_SAVE_ALL"                   : "Save All",\r\n    "CMD_FILE_SAVE_AS"                    : "Save As\\u2026",\r\n    "CMD_LIVE_FILE_PREVIEW"               : "Live Preview",\r\n    "CMD_TOGGLE_LIVE_PREVIEW_MB_MODE"     : "Enable Experimental Live Preview",\r\n    "CMD_RELOAD_LIVE_PREVIEW"             : "Force Reload Live Preview",\r\n    "CMD_PROJECT_SETTINGS"                : "Project Settings\\u2026",\r\n    "CMD_FILE_RENAME"                     : "Rename",\r\n    "CMD_FILE_DELETE"                     : "Delete",\r\n    "CMD_INSTALL_EXTENSION"               : "Install Extension\\u2026",\r\n    "CMD_EXTENSION_MANAGER"               : "Extension Manager\\u2026",\r\n    "CMD_FILE_REFRESH"                    : "Refresh File Tree",\r\n    "CMD_QUIT"                            : "Quit",\r\n    // Used in native File menu on Windows\r\n    "CMD_EXIT"                            : "Exit",\r\n\r\n    // Edit menu commands\r\n    "EDIT_MENU"                           : "Edit",\r\n    "CMD_UNDO"                            : "Undo",\r\n    "CMD_REDO"                            : "Redo",\r\n    "CMD_CUT"                             : "Cut",\r\n    "CMD_COPY"                            : "Copy",\r\n    "CMD_PASTE"                           : "Paste",\r\n    "CMD_SELECT_ALL"                      : "Select All",\r\n    "CMD_SELECT_LINE"                     : "Select Line",\r\n    "CMD_SPLIT_SEL_INTO_LINES"            : "Split Selection into Lines",\r\n    "CMD_ADD_CUR_TO_NEXT_LINE"            : "Add Cursor to Next Line",\r\n    "CMD_ADD_CUR_TO_PREV_LINE"            : "Add Cursor to Previous Line",\r\n    "CMD_INDENT"                          : "Indent",\r\n    "CMD_UNINDENT"                        : "Unindent",\r\n    "CMD_DUPLICATE"                       : "Duplicate",\r\n    "CMD_DELETE_LINES"                    : "Delete Line",\r\n    "CMD_COMMENT"                         : "Toggle Line Comment",\r\n    "CMD_BLOCK_COMMENT"                   : "Toggle Block Comment",\r\n    "CMD_LINE_UP"                         : "Move Line Up",\r\n    "CMD_LINE_DOWN"                       : "Move Line Down",\r\n    "CMD_OPEN_LINE_ABOVE"                 : "Open Line Above",\r\n    "CMD_OPEN_LINE_BELOW"                 : "Open Line Below",\r\n    "CMD_TOGGLE_CLOSE_BRACKETS"           : "Auto Close Braces",\r\n    "CMD_SHOW_CODE_HINTS"                 : "Show Code Hints",\r\n\r\n    // Search menu commands\r\n    "FIND_MENU"                           : "Find",\r\n    "CMD_FIND"                            : "Find",\r\n    "CMD_FIND_NEXT"                       : "Find Next",\r\n    "CMD_FIND_PREVIOUS"                   : "Find Previous",\r\n    "CMD_FIND_ALL_AND_SELECT"             : "Find All and Select",\r\n    "CMD_ADD_NEXT_MATCH"                  : "Add Next Match to Selection",\r\n    "CMD_SKIP_CURRENT_MATCH"              : "Skip and Add Next Match",\r\n    "CMD_FIND_IN_FILES"                   : "Find in Files",\r\n    "CMD_FIND_IN_SUBTREE"                 : "Find in\\u2026",\r\n    "CMD_REPLACE"                         : "Replace",\r\n    "CMD_REPLACE_IN_FILES"                : "Replace in Files",\r\n    "CMD_REPLACE_IN_SUBTREE"              : "Replace in\\u2026",\r\n\r\n    // View menu commands\r\n    "VIEW_MENU"                           : "View",\r\n    "CMD_HIDE_SIDEBAR"                    : "Hide Sidebar",\r\n    "CMD_SHOW_SIDEBAR"                    : "Show Sidebar",\r\n    "CMD_TOGGLE_SIDEBAR"                  : "Toggle Sidebar",\r\n    "CMD_TOGGLE_PANELS"                   : "Toggle Panels",\r\n    "CMD_TOGGLE_PURE_CODE"                : "No Distractions",\r\n    "CMD_INCREASE_FONT_SIZE"              : "Increase Font Size",\r\n    "CMD_DECREASE_FONT_SIZE"              : "Decrease Font Size",\r\n    "CMD_RESTORE_FONT_SIZE"               : "Restore Font Size",\r\n    "CMD_SCROLL_LINE_UP"                  : "Scroll Line Up",\r\n    "CMD_SCROLL_LINE_DOWN"                : "Scroll Line Down",\r\n    "CMD_TOGGLE_LINE_NUMBERS"             : "Line Numbers",\r\n    "CMD_TOGGLE_ACTIVE_LINE"              : "Highlight Active Line",\r\n    "CMD_TOGGLE_WORD_WRAP"                : "Word Wrap",\r\n    "CMD_LIVE_HIGHLIGHT"                  : "Live Preview Highlight",\r\n    "CMD_VIEW_TOGGLE_INSPECTION"          : "Lint Files on Save",\r\n    "CMD_WORKINGSET_SORT_BY_ADDED"        : "Sort by Added",\r\n    "CMD_WORKINGSET_SORT_BY_NAME"         : "Sort by Name",\r\n    "CMD_WORKINGSET_SORT_BY_TYPE"         : "Sort by Type",\r\n    "CMD_WORKING_SORT_TOGGLE_AUTO"        : "Automatic Sort",\r\n    "CMD_THEMES"                          : "Themes\\u2026",\r\n\r\n    // Navigate menu commands\r\n    "NAVIGATE_MENU"                       : "Navigate",\r\n    "CMD_QUICK_OPEN"                      : "Quick Open",\r\n    "CMD_GOTO_LINE"                       : "Go to Line",\r\n    "CMD_GOTO_DEFINITION"                 : "Quick Find Definition",\r\n    "CMD_GOTO_FIRST_PROBLEM"              : "Go to First Problem",\r\n    "CMD_TOGGLE_QUICK_EDIT"               : "Quick Edit",\r\n    "CMD_TOGGLE_QUICK_DOCS"               : "Quick Docs",\r\n    "CMD_QUICK_EDIT_PREV_MATCH"           : "Previous Match",\r\n    "CMD_QUICK_EDIT_NEXT_MATCH"           : "Next Match",\r\n    "CMD_CSS_QUICK_EDIT_NEW_RULE"         : "New Rule",\r\n    "CMD_NEXT_DOC"                        : "Next Document",\r\n    "CMD_PREV_DOC"                        : "Previous Document",\r\n    "CMD_NAVIGATE_BACKWARD"               : "Navigate Backward",\r\n    "CMD_NAVIGATE_FORWARD"                : "Navigate Forward",\r\n    "CMD_NEXT_DOC_LIST_ORDER"             : "Next Document in List",\r\n    "CMD_PREV_DOC_LIST_ORDER"             : "Previous Document in List",\r\n    "CMD_SHOW_IN_TREE"                    : "Show in File Tree",\r\n    "CMD_SHOW_IN_EXPLORER"                : "Show in Explorer",\r\n    "CMD_SHOW_IN_FINDER"                  : "Show in Finder",\r\n    "CMD_SHOW_IN_OS"                      : "Show in OS",\r\n    "CMD_SWITCH_PANE_FOCUS"               : "Switch Pane Focus",\r\n\r\n    // Help menu commands\r\n    "HELP_MENU"                           : "Help",\r\n    "CMD_CHECK_FOR_UPDATE"                : "Check for Updates",\r\n    "CMD_HOW_TO_USE_BRACKETS"             : "How to Use {APP_NAME}",\r\n    "CMD_SUPPORT"                         : "{APP_NAME} Support",\r\n    "CMD_SUGGEST"                         : "Suggest a Feature",\r\n    "CMD_RELEASE_NOTES"                   : "Release Notes",\r\n    "CMD_GET_INVOLVED"                    : "Get Involved",\r\n    "CMD_SHOW_EXTENSIONS_FOLDER"          : "Show Extensions Folder",\r\n    "CMD_HEALTH_DATA_STATISTICS"          : "Health Report",\r\n    "CMD_HOMEPAGE"                        : "{APP_TITLE} Homepage",\r\n    "CMD_TWITTER"                         : "{TWITTER_NAME} on Twitter",\r\n    "CMD_ABOUT"                           : "About {APP_TITLE}",\r\n    "CMD_OPEN_PREFERENCES"                : "Open Preferences File",\r\n    "CMD_OPEN_KEYMAP"                     : "Open User Key Map",\r\n\r\n    // Strings for main-view.html\r\n    "EXPERIMENTAL_BUILD"                   : "experimental build",\r\n    "RELEASE_BUILD"                        : "build",\r\n    "DEVELOPMENT_BUILD"                    : "development build",\r\n    "RELOAD_FROM_DISK"                     : "Reload from Disk",\r\n    "KEEP_CHANGES_IN_EDITOR"               : "Keep Changes in Editor",\r\n    "CLOSE_DONT_SAVE"                      : "Close (Don\'t Save)",\r\n    "RELAUNCH_CHROME"                      : "Relaunch Chrome",\r\n    "ABOUT"                                : "About",\r\n    "CLOSE"                                : "Close",\r\n    "ABOUT_TEXT_LINE1"                     : "Release {VERSION_MAJOR}.{VERSION_MINOR} {BUILD_TYPE} {VERSION}",\r\n    "ABOUT_TEXT_BUILD_TIMESTAMP"           : "build timestamp: ",\r\n    "ABOUT_TEXT_LINE3"                     : "Notices, terms and conditions pertaining to third party software are located at <a href=\'{ADOBE_THIRD_PARTY}\'>{ADOBE_THIRD_PARTY}</a> and incorporated by reference herein.",\r\n    "ABOUT_TEXT_LINE4"                     : "Documentation and source at <a href=\'https://github.com/adobe/brackets/\'>https://github.com/adobe/brackets/</a>",\r\n    "ABOUT_TEXT_LINE5"                     : "Made with \\u2764 and JavaScript by:",\r\n    "ABOUT_TEXT_LINE6"                     : "Lots of people (but we\'re having trouble loading that data right now).",\r\n    "ABOUT_TEXT_MDN_DOCS"                  : "MDN Docs and the MDN graphical logo are licensed under a Creative Commons Attribution license, <a href=\'{MDN_DOCS_LICENSE}\'>CC-BY-SA 2.5 Unported</a>.",\r\n    "UPDATE_NOTIFICATION_TOOLTIP"          : "There\'s a new build of {APP_NAME} available! Click here for details.",\r\n    "UPDATE_AVAILABLE_TITLE"               : "Update Available",\r\n    "UPDATE_MESSAGE"                       : "Hey, there\'s a new build of {APP_NAME} available. Here are some of the new features:",\r\n    "GET_IT_NOW"                           : "Get it now!",\r\n    "PROJECT_SETTINGS_TITLE"               : "Project Settings for: {0}",\r\n    "PROJECT_SETTING_BASE_URL"             : "Live Preview Base URL",\r\n    "PROJECT_SETTING_BASE_URL_HINT"        : "To use a local server, enter a URL like http://localhost:8000/",\r\n    "BASEURL_ERROR_INVALID_PROTOCOL"       : "The {0} protocol isn\'t supported by Live Preview&mdash;please use http: or https: .",\r\n    "BASEURL_ERROR_SEARCH_DISALLOWED"      : "The base URL can\'t contain search parameters like \\"{0}\\".",\r\n    "BASEURL_ERROR_HASH_DISALLOWED"        : "The base URL can\'t contain hashes like \\"{0}\\".",\r\n    "BASEURL_ERROR_INVALID_CHAR"           : "Special characters like \'{0}\' must be %-encoded.",\r\n    "BASEURL_ERROR_UNKNOWN_ERROR"          : "Unknown error parsing Base URL",\r\n\r\n    // Strings for Pane.js\r\n    "EMPTY_VIEW_HEADER"                    : "<em>Open a file while this pane has focus</em>",\r\n    "FLIPVIEW_BTN_TOOLTIP"                 : "Flip this view to {0} pane",\r\n\r\n    // Strings for themes-settings.html and themes-general.html\r\n    "CURRENT_THEME"                        : "Current Theme",\r\n    "USE_THEME_SCROLLBARS"                 : "Use Theme Scrollbars",\r\n    "FONT_SIZE"                            : "Font Size",\r\n    "FONT_FAMILY"                          : "Font Family",\r\n    "THEMES_SETTINGS"                      : "Themes Settings",\r\n\r\n    // CSS Quick Edit\r\n    "BUTTON_NEW_RULE"                      : "New Rule",\r\n\r\n    // Extension Management strings\r\n    "INSTALL"                              : "Install",\r\n    "UPDATE"                               : "Update",\r\n    "REMOVE"                               : "Remove",\r\n    "DISABLE"                              : "Disable",\r\n    "ENABLE"                               : "Enable",\r\n    "OVERWRITE"                            : "Overwrite",\r\n    "CANT_REMOVE_DEV"                      : "Extensions in the \\"dev\\" folder must be manually deleted.",\r\n    "CANT_UPDATE"                          : "The update isn\'t compatible with this version of {APP_NAME}.",\r\n    "CANT_UPDATE_DEV"                      : "Extensions in the \\"dev\\" folder can\'t be updated automatically.",\r\n    "INSTALL_EXTENSION_TITLE"              : "Install Extension",\r\n    "UPDATE_EXTENSION_TITLE"               : "Update Extension",\r\n    "INSTALL_EXTENSION_LABEL"              : "Extension URL",\r\n    "INSTALL_EXTENSION_HINT"               : "URL of the extension\'s zip file or GitHub repo",\r\n    "INSTALLING_FROM"                      : "Installing extension from {0}\\u2026",\r\n    "INSTALL_SUCCEEDED"                    : "Installation successful!",\r\n    "INSTALL_FAILED"                       : "Installation failed.",\r\n    "CANCELING_INSTALL"                    : "Canceling\\u2026",\r\n    "CANCELING_HUNG"                       : "Canceling the install is taking a long time. An internal error may have occurred.",\r\n    "INSTALL_CANCELED"                     : "Installation canceled.",\r\n    "VIEW_COMPLETE_DESCRIPTION"            : "View complete description",\r\n    "VIEW_TRUNCATED_DESCRIPTION"           : "View truncated description",\r\n    "SORT_EXTENSION_METHOD"                : "Sort Extensions using downloadCount or publishedDate",\r\n    // These must match the error codes in ExtensionsDomain.Errors.* :\r\n    "INVALID_ZIP_FILE"                     : "The downloaded content is not a valid zip file.",\r\n    "MISSING_PACKAGE_JSON"                 : "The package has no package.json file.",\r\n    "INVALID_PACKAGE_JSON"                 : "The package.json file is not valid (error was: {0}).",\r\n    "MISSING_PACKAGE_NAME"                 : "The package.json file doesn\'t specify a package name.",\r\n    "BAD_PACKAGE_NAME"                     : "{0} is an invalid package name.",\r\n    "MISSING_PACKAGE_VERSION"              : "The package.json file doesn\'t specify a package version.",\r\n    "INVALID_VERSION_NUMBER"               : "The package version number ({0}) is invalid.",\r\n    "INVALID_BRACKETS_VERSION"             : "The {APP_NAME} compatibility string ({0}) is invalid.",\r\n    "DISALLOWED_WORDS"                     : "The words ({1}) are not allowed in the {0} field.",\r\n    "NPM_INSTALL_FAILED"                   : "npm install command failed: {0}",\r\n    "API_NOT_COMPATIBLE"                   : "The extension isn\'t compatible with this version of {APP_NAME}. It\'s installed in your disabled extensions folder.",\r\n    "MISSING_MAIN"                         : "The package has no main.js file.",\r\n    "EXTENSION_ALREADY_INSTALLED"          : "Installing this package will overwrite a previously installed extension. Overwrite the old extension?",\r\n    "EXTENSION_SAME_VERSION"               : "This package is the same version as the one that is currently installed. Overwrite the existing installation?",\r\n    "EXTENSION_OLDER_VERSION"              : "This package is version {0} which is older than the currently installed ({1}). Overwrite the existing installation?",\r\n    "DOWNLOAD_ID_IN_USE"                   : "Internal error: download ID already in use.",\r\n    "NO_SERVER_RESPONSE"                   : "Cannot connect to server.",\r\n    "BAD_HTTP_STATUS"                      : "File not found on server (HTTP {0}).",\r\n    "CANNOT_WRITE_TEMP"                    : "Unable to save download to temp file.",\r\n    "ERROR_LOADING"                        : "The extension encountered an error while starting up.",\r\n    "MALFORMED_URL"                        : "The URL is invalid. Please check that you entered it correctly.",\r\n    "UNSUPPORTED_PROTOCOL"                 : "The URL must be an http or https URL.",\r\n    "UNKNOWN_ERROR"                        : "Unknown internal error.",\r\n    // For NOT_FOUND_ERR, see generic strings above\r\n    "EXTENSION_MANAGER_TITLE"              : "Extension Manager",\r\n    "EXTENSION_MANAGER_ERROR_LOAD"         : "Unable to access the extension registry. Please try again later.",\r\n    "INSTALL_EXTENSION_DRAG"               : "Drag .zip here or",\r\n    "INSTALL_EXTENSION_DROP"               : "Drop .zip to install",\r\n    "INSTALL_EXTENSION_DROP_ERROR"         : "Install/Update aborted due to the following errors:",\r\n    "INSTALL_FROM_URL"                     : "Install from URL\\u2026",\r\n    "INSTALL_EXTENSION_VALIDATING"         : "Validating\\u2026",\r\n    "EXTENSION_AUTHOR"                     : "Author",\r\n    "EXTENSION_DATE"                       : "Date",\r\n    "EXTENSION_INCOMPATIBLE_NEWER"         : "This extension requires a newer version of {APP_NAME}.",\r\n    "EXTENSION_INCOMPATIBLE_OLDER"         : "This extension currently only works with older versions of {APP_NAME}.",\r\n    "EXTENSION_LATEST_INCOMPATIBLE_NEWER"  : "Version {0} of this extension requires a newer version of {APP_NAME}. But you can install the earlier version {1}.",\r\n    "EXTENSION_LATEST_INCOMPATIBLE_OLDER"  : "Version {0} of this extension only works with older versions of {APP_NAME}. But you can install the earlier version {1}.",\r\n    "EXTENSION_NO_DESCRIPTION"             : "No description",\r\n    "EXTENSION_MORE_INFO"                  : "More info\\u2026",\r\n    "EXTENSION_ERROR"                      : "Extension error",\r\n    "EXTENSION_KEYWORDS"                   : "Keywords",\r\n    "EXTENSION_TRANSLATED_USER_LANG"       : "Translated into {0} languages, including yours",\r\n    "EXTENSION_TRANSLATED_GENERAL"         : "Translated into {0} languages",\r\n    "EXTENSION_TRANSLATED_LANGS"           : "This extension has been translated into these languages: {0}",\r\n    "EXTENSION_INSTALLED"                  : "Installed",\r\n    "EXTENSION_UPDATE_INSTALLED"           : "This extension update has been downloaded and will be installed after {APP_NAME} reloads.",\r\n    "EXTENSION_SEARCH_PLACEHOLDER"         : "Search",\r\n    "EXTENSION_MORE_INFO_LINK"             : "More",\r\n    "BROWSE_EXTENSIONS"                    : "Browse Extensions",\r\n    "EXTENSION_MANAGER_REMOVE"             : "Remove Extension",\r\n    "EXTENSION_MANAGER_REMOVE_ERROR"       : "Unable to remove one or more extensions: {0}. {APP_NAME} will still reload.",\r\n    "EXTENSION_MANAGER_UPDATE"             : "Update Extension",\r\n    "EXTENSION_MANAGER_UPDATE_ERROR"       : "Unable to update one or more extensions: {0}. {APP_NAME} will still reload.",\r\n    "EXTENSION_MANAGER_DISABLE"            : "Disable Extension",\r\n    "EXTENSION_MANAGER_DISABLE_ERROR"      : "Unable to disable one or more extensions: {0}. {APP_NAME} will still reload.",\r\n    "MARKED_FOR_REMOVAL"                   : "Marked for removal",\r\n    "UNDO_REMOVE"                          : "Undo",\r\n    "MARKED_FOR_UPDATE"                    : "Marked for update",\r\n    "UNDO_UPDATE"                          : "Undo",\r\n    "MARKED_FOR_DISABLING"                 : "Marked for disabling",\r\n    "UNDO_DISABLE"                         : "Undo",\r\n    "CHANGE_AND_RELOAD_TITLE"              : "Change Extensions",\r\n    "CHANGE_AND_RELOAD_MESSAGE"            : "To update, remove or disable the marked extensions, {APP_NAME} will need to reload. You\'ll be prompted to save unsaved changes.",\r\n    "REMOVE_AND_RELOAD"                    : "Remove Extensions and Reload",\r\n    "CHANGE_AND_RELOAD"                    : "Change Extensions and Reload",\r\n    "UPDATE_AND_RELOAD"                    : "Update Extensions and Reload",\r\n    "DISABLE_AND_RELOAD"                   : "Disable Extensions and Reload",\r\n    "PROCESSING_EXTENSIONS"                : "Processing extension changes\\u2026",\r\n    "EXTENSION_NOT_INSTALLED"              : "Couldn\'t remove extension {0} because it wasn\'t installed.",\r\n    "NO_EXTENSIONS"                        : "No extensions installed yet.<br>Click on the Available tab above to get started.",\r\n    "NO_EXTENSION_MATCHES"                 : "No extensions match your search.",\r\n    "REGISTRY_SANITY_CHECK_WARNING"        : "NOTE: These extensions may come from different authors than {APP_NAME} itself. Extensions are not reviewed and have full local privileges. Be cautious when installing extensions from an unknown source.",\r\n    "EXTENSIONS_INSTALLED_TITLE"           : "Installed",\r\n    "EXTENSIONS_DEFAULT_TITLE"             : "Default",\r\n    "EXTENSIONS_AVAILABLE_TITLE"           : "Available",\r\n    "EXTENSIONS_THEMES_TITLE"              : "Themes",\r\n    "EXTENSIONS_UPDATES_TITLE"             : "Updates",\r\n    "EXTENSIONS_LAST_UPDATED"              : "Last Updated",\r\n    "EXTENSIONS_DOWNLOADS"                 : "Downloads",\r\n\r\n    "INLINE_EDITOR_NO_MATCHES"             : "No matches available.",\r\n    "INLINE_EDITOR_HIDDEN_MATCHES"         : "All matches are collapsed. Expand the files listed at right to view matches.",\r\n    "CSS_QUICK_EDIT_NO_MATCHES"            : "There are no existing CSS rules that match your selection.<br> Click \\"New Rule\\" to create one.",\r\n    "CSS_QUICK_EDIT_NO_STYLESHEETS"        : "There are no stylesheets in your project.<br>Create one to add CSS rules.",\r\n\r\n    // Custom Viewers\r\n    "IMAGE_VIEWER_LARGEST_ICON"            : "largest",\r\n\r\n    /**\r\n     * Unit names\r\n     */\r\n    "UNIT_PIXELS"                          : "pixels",\r\n\r\n    // extensions/default/DebugCommands\r\n    "DEBUG_MENU"                                : "Debug",\r\n    "ERRORS"                                    : "Errors",\r\n    "CMD_SHOW_DEV_TOOLS"                        : "Show Developer Tools",\r\n    "CMD_REFRESH_WINDOW"                        : "Reload With Extensions",\r\n    "CMD_RELOAD_WITHOUT_USER_EXTS"              : "Reload Without Extensions",\r\n    "CMD_NEW_BRACKETS_WINDOW"                   : "New {APP_NAME} Window",\r\n    "CMD_LAUNCH_SCRIPT_MAC"                     : "Install Command Line Shortcut",\r\n    "CMD_SWITCH_LANGUAGE"                       : "Switch Language",\r\n    "CMD_RUN_UNIT_TESTS"                        : "Run Tests",\r\n    "CMD_SHOW_PERF_DATA"                        : "Show Performance Data",\r\n    "CMD_ENABLE_NODE_DEBUGGER"                  : "Enable Node Debugger",\r\n    "CMD_LOG_NODE_STATE"                        : "Log Node State to Console",\r\n    "CMD_RESTART_NODE"                          : "Restart Node",\r\n    "CMD_SHOW_ERRORS_IN_STATUS_BAR"             : "Show Errors in Status Bar",\r\n    "CMD_OPEN_BRACKETS_SOURCE"                  : "Open {APP_NAME} Source",\r\n\r\n    "CREATING_LAUNCH_SCRIPT_TITLE"              : "{APP_NAME} Command Line Shortcut",\r\n    "ERROR_CREATING_LAUNCH_SCRIPT"              : "An error occurred while installing the command line shortcut. Please try <a href=\'https://github.com/adobe/brackets/wiki/Command-Line-Arguments#troubleshooting\'>these troubleshooting suggestions</a>.<br/><br/>Reason: {0}",\r\n    "ERROR_CLTOOLS_RMFAILED"                    : "Unable to remove existing <code>/usr/local/bin/brackets</code> symlink.",\r\n    "ERROR_CLTOOLS_MKDIRFAILED"                 : "Unable to create <code>/usr/local/bin</code> directory.",\r\n    "ERROR_CLTOOLS_LNFAILED"                    : "Unable to create <code>/usr/local/bin/brackets</code> symlink.",\r\n    "ERROR_CLTOOLS_SERVFAILED"                  : "Internal error.",\r\n    "ERROR_CLTOOLS_NOTSUPPORTED"                : "Command line shortcut is not supported on this OS.",\r\n    "LAUNCH_SCRIPT_CREATE_SUCCESS"              : "Success! Now you can easily launch {APP_NAME} from the command line: <code>brackets myFile.txt</code> to open a file or <code>brackets myFolder</code> to switch projects. <br/><br/><a href=\'https://github.com/adobe/brackets/wiki/Command-Line-Arguments\'>Learn more</a> about using {APP_NAME} from the command line.",\r\n\r\n    "LANGUAGE_TITLE"                            : "Switch Language",\r\n    "LANGUAGE_MESSAGE"                          : "Language:",\r\n    "LANGUAGE_SUBMIT"                           : "Reload {APP_NAME}",\r\n    "LANGUAGE_CANCEL"                           : "Cancel",\r\n    "LANGUAGE_SYSTEM_DEFAULT"                   : "System Default",\r\n\r\n    // extensions/default/HealthData\r\n    "HEALTH_DATA_NOTIFICATION"                  : "Health Report Preferences",\r\n    "HEALTH_FIRST_POPUP_TITLE"                  : "{APP_NAME} Health Report",\r\n    "HEALTH_DATA_DO_TRACK"                      : "Share anonymous information on how I use {APP_NAME}",\r\n    "HEALTH_DATA_NOTIFICATION_MESSAGE"          : "In order to improve {APP_NAME}, we periodically send limited, <strong>anonymous</strong> statistics to Adobe about how you use {APP_NAME}. This information helps prioritize features, find bugs, and spot usability issues.<br><br>You can see your data or choose not to share data by selecting <strong>Help > Health Report</strong>.<br><br><a href=\'https://github.com/adobe/brackets/wiki/Health-Data\'>Learn more about {APP_NAME} Health Report</a>",\r\n    "HEALTH_DATA_PREVIEW"                       : "{APP_NAME} Health Report",\r\n    "HEALTH_DATA_PREVIEW_INTRO"                 : "<p>In order to improve {APP_NAME}, we periodically send limited, <strong>anonymous</strong> statistics to Adobe about how you use {APP_NAME}. This information helps prioritize features, find bugs, and spot usability issues. <a href=\'https://github.com/adobe/brackets/wiki/Health-Data\'>Learn more about {APP_NAME} Health Report</a> and how it benefits the {APP_NAME} community while protecting your privacy.</p><p>Below is a preview of the data that will be sent in your next Health Report <em>if</em> it is enabled.</p>",\r\n\r\n    // extensions/default/InlineTimingFunctionEditor\r\n    "INLINE_TIMING_EDITOR_TIME"                 : "Time",\r\n    "INLINE_TIMING_EDITOR_PROGRESSION"          : "Progression",\r\n    "BEZIER_EDITOR_INFO"                        : "<kbd>↑</kbd><kbd>↓</kbd><kbd>←</kbd><kbd>→</kbd> Move selected point<br><kbd class=\'text\'>Shift</kbd> Move by ten units<br><kbd class=\'text\'>Tab</kbd> Switch points",\r\n    "STEPS_EDITOR_INFO"                         : "<kbd>↑</kbd><kbd>↓</kbd> Increase or decrease steps<br><kbd>←</kbd><kbd>→</kbd> \'Start\' or \'End\'",\r\n    "INLINE_TIMING_EDITOR_INVALID"              : "The old value <code>{0}</code> is not valid, so the displayed function was changed to <code>{1}</code>. The document will be updated with the first edit.",\r\n\r\n    // extensions/default/InlineColorEditor\r\n    "COLOR_EDITOR_CURRENT_COLOR_SWATCH_TIP"     : "Current Color",\r\n    "COLOR_EDITOR_ORIGINAL_COLOR_SWATCH_TIP"    : "Original Color",\r\n    "COLOR_EDITOR_RGBA_BUTTON_TIP"              : "RGBa Format",\r\n    "COLOR_EDITOR_HEX_BUTTON_TIP"               : "Hex Format",\r\n    "COLOR_EDITOR_HSLA_BUTTON_TIP"              : "HSLa Format",\r\n    "COLOR_EDITOR_0X_BUTTON_TIP"                : "Hex (0x) Format",\r\n    "COLOR_EDITOR_USED_COLOR_TIP_SINGULAR"      : "{0} (Used {1} time)",\r\n    "COLOR_EDITOR_USED_COLOR_TIP_PLURAL"        : "{0} (Used {1} times)",\r\n\r\n    // extensions/default/JavaScriptCodeHints\r\n    "CMD_JUMPTO_DEFINITION"                     : "Jump to Definition",\r\n    "CMD_SHOW_PARAMETER_HINT"                   : "Show Parameter Hint",\r\n    "NO_ARGUMENTS"                              : "<no parameters>",\r\n    "DETECTED_EXCLUSION_TITLE"                  : "JavaScript File Inference Problem",\r\n    "DETECTED_EXCLUSION_INFO"                   : "{APP_NAME} ran into trouble processing <span class=\'dialog-filename\'>{0}</span>.<br><br>This file will no longer be processed for code hints, Jump to Definition or Quick Edit. To re-enable this file, open <code>.brackets.json</code> in your project and edit <code>jscodehints.detectedExclusions</code>.<br><br>This is likely a {APP_NAME} bug. If you can provide a copy of this file, please <a href=\'https://github.com/adobe/brackets/wiki/How-to-Report-an-Issue\'>file a bug</a> with a link to the file named here.",\r\n\r\n    // extensions/default/JSLint\r\n    "JSLINT_NAME"                               : "JSLint",\r\n\r\n    // extensions/default/QuickView\r\n    "CMD_ENABLE_QUICK_VIEW"                     : "Quick View on Hover",\r\n\r\n    // extensions/default/RecentProjects\r\n    "CMD_TOGGLE_RECENT_PROJECTS"                : "Recent Projects",\r\n\r\n    // extensions/default/MDNDocs\r\n    "DOCS_MORE_LINK"                            : "Read more",\r\n\r\n    // extensions/default/CodeFolding\r\n    "COLLAPSE_ALL"                  : "Collapse All",\r\n    "EXPAND_ALL"                    : "Expand All",\r\n    "COLLAPSE_CURRENT"              : "Collapse Current",\r\n    "EXPAND_CURRENT"                : "Expand Current",\r\n\r\n    // extensions/default/NavigationAndHistory\r\n    "RECENT_FILES_DLG_HEADER"                    : "Recent Files",\r\n    "RECENT_FILES_DLG_CLEAR_BUTTON_LABEL"        : "Clear",\r\n    "RECENT_FILES_DLG_CLEAR_BUTTON_TITLE"        : "Clear files not in Working Set",\r\n\r\n    // Descriptions of core preferences\r\n    "DESCRIPTION_CLOSE_BRACKETS"                     : "true to automatically close braces, brackets and parentheses",\r\n    "DESCRIPTION_CLOSE_OTHERS_ABOVE"                 : "false to remove the \\"Close Others Above\\" from the Working Files context menu",\r\n    "DESCRIPTION_CLOSE_OTHERS_BELOW"                 : "false to remove the \\"Close Others Below\\" from the Working Files context menu",\r\n    "DESCRIPTION_CLOSE_OTHERS"                       : "false to remove the \\"Close Others\\" from the Working Files context menu",\r\n    "DESCRIPTION_CLOSE_TAGS"                         : "Sets the tag closing options",\r\n    "DESCRIPTION_CLOSE_TAGS_DONT_CLOSE_TAGS"         : "An array of tags that should not be auto-closed",\r\n    "DESCRIPTION_CLOSE_TAGS_WHEN_OPENING"            : "Close when > of opening tag is typed",\r\n    "DESCRIPTION_CLOSE_TAGS_WHEN_CLOSING"            : "Close when / of closing tag is typed",\r\n    "DESCRIPTION_CLOSE_TAGS_INDENT_TAGS"             : "An array of tags that when opened has a blank line",\r\n    "DESCRIPTION_CODE_FOLDING_ALWAY_USE_INDENT_FOLD" : "true to always generate collapsible section markers when indent level changes",\r\n    "DESCRIPTION_CODE_FOLDING_ENABLED"               : "true to enable code folding",\r\n    "DESCRIPTION_CODE_FOLDING_HIDE_UNTIL_MOUSEOVER"  : "true to make Section-collapsing markers visible only when you move the mouse over the gutter",\r\n    "DESCRIPTION_CODE_FOLDING_MAX_FOLD_LEVEL"        : "Limits how many levels deep Collapse All applies",\r\n    "DESCRIPTION_CODE_FOLDING_MIN_FOLD_SIZE"         : "Minimum lines before a collapsible section icon appears",\r\n    "DESCRIPTION_CODE_FOLDING_SAVE_FOLD_STATES"      : "true to remember collapsed sections if you close and reopen a file or project",\r\n    "DESCRIPTION_CODE_FOLDING_MAKE_SELECTIONS_FOLDABLE": "true to enable code folding on selected text in the editor",\r\n    "DESCRIPTION_DISABLED_DEFAULT_EXTENSIONS"        : "Default extensions that are disabled",\r\n    "DESCRIPTION_ATTR_HINTS"                         : "Enable/disable HTML attribute hints",\r\n    "DESCRIPTION_CSS_PROP_HINTS"                     : "Enable/disable CSS/LESS/SCSS property hints",\r\n    "DESCRIPTION_JS_HINTS"                           : "Enable/disable JavaScript code hints",\r\n    "DESCRIPTION_JS_HINTS_TYPE_DETAILS"              : "Enable/disable datatype details in JavaScript code hints",\r\n    "DESCRIPTION_PREF_HINTS"                         : "Enable/disable Preferences code hints",\r\n    "DESCRIPTION_SPECIAL_CHAR_HINTS"                 : "Enable/disable HTML entity hints",\r\n    "DESCRIPTION_SVG_HINTS"                          : "Enable/disable SVG code hints",\r\n    "DESCRIPTION_HTML_TAG_HINTS"                     : "Enable/disable HTML tag hints",\r\n    "DESCRIPTION_URL_CODE_HINTS"                     : "Enable/disable URL hints in HTML & CSS/LESS/SCSS",\r\n    "DESCRIPTION_DRAG_DROP_TEXT"                     : "Enable/disable Drag & Drop functionality",\r\n    "DESCRIPTION_HEALTH_DATA_TRACKING"               : "Enable the Health Data Tracking",\r\n    "DESCRIPTION_HIGHLIGHT_MATCHES"                  : "Enables automatic highlighting of matching strings throughout the document",\r\n    "DESCRIPTION_HIGHLIGHT_MATCHES_SHOW_TOKEN"       : "Highlight all strings that match the token the cursor is currently in (no selection needed)",\r\n    "DESCRIPTION_HIGHLIGHT_MATCHES_WORDS_ONLY"       : "Highlight only when selection is a complete token",\r\n    "DESCRIPTION_INSERT_HINT_ON_TAB"                 : "true to insert the currently selected code hint on tab",\r\n    "DESCRIPTION_NO_HINTS_ON_DOT"                    : "true to not automatically show JS code hints when . is typed",\r\n    "DESCRIPTION_JSLINT_OPTIONS"                     : "An object with the default options for JSLint",\r\n    "DESCRIPTION_JSLINT_OPTIONS_ASS"                 : "true to allow assignment expressions",\r\n    "DESCRIPTION_JSLINT_OPTIONS_BITWISE"             : "true to allow bitwise operators",\r\n    "DESCRIPTION_JSLINT_OPTIONS_BROWSER"             : "true if standard browser globals should be predefined",\r\n    "DESCRIPTION_JSLINT_OPTIONS_CLOSURE"             : "true to allow Google Closure idioms",\r\n    "DESCRIPTION_JSLINT_OPTIONS_CONTINUE"            : "true to allow \\"continue\\" statement",\r\n    "DESCRIPTION_JSLINT_OPTIONS_COUCH"               : "true if CouchDB globals should be predefined",\r\n    "DESCRIPTION_JSLINT_OPTIONS_DEBUG"               : "true to allow debugger statements",\r\n    "DESCRIPTION_JSLINT_OPTIONS_DEVEL"               : "true if browser globals useful in development should be predefined",\r\n    "DESCRIPTION_JSLINT_OPTIONS_EQEQ"                : "true to allow == and !=",\r\n    "DESCRIPTION_JSLINT_OPTIONS_ES6"                 : "true if ES6 globals should be predefined",\r\n    "DESCRIPTION_JSLINT_OPTIONS_EVIL"                : "true to allow eval",\r\n    "DESCRIPTION_JSLINT_OPTIONS_FORIN"               : "true to allow unfiltered \\"for ... in\\"",\r\n    "DESCRIPTION_JSLINT_OPTIONS_INDENT"              : "Set a specific tab width",\r\n    "DESCRIPTION_JSLINT_OPTIONS_MAXERR"              : "The maximum number of warnings reported",\r\n    "DESCRIPTION_JSLINT_OPTIONS_MAXLEN"              : "The maximum number of characters in a line",\r\n    "DESCRIPTION_JSLINT_OPTIONS_NEWCAP"              : "true to allow uncapitalized constructors",\r\n    "DESCRIPTION_JSLINT_OPTIONS_NODE"                : "true if Node.js globals should be predefined",\r\n    "DESCRIPTION_JSLINT_OPTIONS_NOMEN"               : "true to allow dangling underscore in identifiers",\r\n    "DESCRIPTION_JSLINT_OPTIONS_PASSFAIL"            : "true to stop on first error",\r\n    "DESCRIPTION_JSLINT_OPTIONS_PLUSPLUS"            : "true to allow ++ and --",\r\n    "DESCRIPTION_JSLINT_OPTIONS_REGEXP"              : "true to allow . and [^...]. in RegExp",\r\n    "DESCRIPTION_JSLINT_OPTIONS_RHINO"               : "true if Rhino globals should be predefined",\r\n    "DESCRIPTION_JSLINT_OPTIONS_SLOPPY"              : "true to allow missing `use strict` pragma",\r\n    "DESCRIPTION_JSLINT_OPTIONS_STUPID"              : "true if blocking (\'...Sync\') methods can be used.",\r\n    "DESCRIPTION_JSLINT_OPTIONS_SUB"                 : "true to allow inefficient subscripting",\r\n    "DESCRIPTION_JSLINT_OPTIONS_TODO"                : "true to allow TODO comments",\r\n    "DESCRIPTION_JSLINT_OPTIONS_UNPARAM"             : "true to allow unused parameters",\r\n    "DESCRIPTION_JSLINT_OPTIONS_VARS"                : "true to allow more than 1 vars in a function",\r\n    "DESCRIPTION_JSLINT_OPTIONS_WHITE"               : "true to ignore white-space rules",\r\n    "DESCRIPTION_LANGUAGE"                           : "Language specific settings",\r\n    "DESCRIPTION_LANGUAGE_FILE_EXTENSIONS"           : "Additional mappings from file extension to language name",\r\n    "DESCRIPTION_LANGUAGE_FILE_NAMES"                : "Additional mappings from file name to language name",\r\n    "DESCRIPTION_LINEWISE_COPY_CUT"                  : "Doing copy and cut when there\'s no selection will copy or cut the whole lines that have cursors in them",\r\n    "DESCRIPTION_INPUT_STYLE"                        : "Selects the way CodeMirror handles input and focus. It can be textarea, which is the default, or contenteditable which is better for screen readers (unstable)",\r\n    "DESCRIPTION_LINTING_ENABLED"                    : "true to enable Code Inspection",\r\n    "DESCRIPTION_ASYNC_TIMEOUT"                      : "The time in milliseconds after which asynchronous linters time out",\r\n    "DESCRIPTION_LINTING_PREFER"                     : "Array of linters to run first",\r\n    "DESCRIPTION_LIVE_DEV_MULTIBROWSER"              : "true to enable experimental Live Preview",\r\n    "DESCRIPTION_USE_PREFERED_ONLY"                  : "true to run providers specified in linting.prefer only",\r\n    "DESCRIPTION_MAX_CODE_HINTS"                     : "Maximum code hints displayed at once",\r\n    "DESCRIPTION_PATH"                               : "Path specific settings",\r\n    "DESCRIPTION_PROXY"                              : "The URL of the proxy server used for extension installation",\r\n    "DESCRIPTION_SCROLL_PAST_END"                    : "true to enable scrolling beyond the end of the document",\r\n    "DESCRIPTION_SHOW_CODE_HINTS"                    : "false to disable all code hints",\r\n    "DESCRIPTION_SHOW_CURSOR_WHEN_SELECTING"         : "Keeps the blinking cursor visible when you have a text selection",\r\n    "DESCRIPTION_SHOW_LINE_NUMBERS"                  : "true to show line numbers in a “gutter” to the left of the code",\r\n    "DESCRIPTION_SMART_INDENT"                       : "Automatically indent when creating a new block",\r\n    "DESCRIPTION_SOFT_TABS"                          : "false to turn off soft tabs behavior",\r\n    "DESCRIPTION_SORT_DIRECTORIES_FIRST"             : "true to sort the directories first in the project tree",\r\n    "DESCRIPTION_SPACE_UNITS"                        : "Number of spaces to use for space-based indentation",\r\n    "DESCRIPTION_STATIC_SERVER_PORT"                 : "Port number that the built-in server should use for Live Preview",\r\n    "DESCRIPTION_STYLE_ACTIVE_LINE"                  : "true to highlight background color of the line the cursor is on",\r\n    "DESCRIPTION_TAB_SIZE"                           : "Number of spaces to display for tabs",\r\n    "DESCRIPTION_USE_TAB_CHAR"                       : "true to use tabs instead of spaces",\r\n    "DESCRIPTION_UPPERCASE_COLORS"                   : "true to generate uppercase hex colors in Inline Color Editor",\r\n    "DESCRIPTION_WORD_WRAP"                          : "Wrap lines that exceed the viewport width",\r\n    "DESCRIPTION_DETECTED_EXCLUSIONS"                : "A list of files that have been detected to cause Tern to run out of control",\r\n    "DESCRIPTION_INFERENCE_TIMEOUT"                  : "The amount of time after which Tern will time out when trying to understand files",\r\n    "DESCRIPTION_SHOW_ERRORS_IN_STATUS_BAR"          : "true to show errors in status bar",\r\n    "DESCRIPTION_QUICK_VIEW_ENABLED"                 : "true to enable Quick View",\r\n    "DESCRIPTION_EXTENSION_LESS_IMAGE_PREVIEW"       : "true to show image previews for URLs missing extensions",\r\n    "DESCRIPTION_THEME"                              : "Select a {APP_NAME} theme",\r\n    "DESCRIPTION_USE_THEME_SCROLLBARS"               : "true to allow custom scroll bars",\r\n    "DESCRIPTION_LINTING_COLLAPSED"                  : "true to collapse linting panel",\r\n    "DESCRIPTION_FONT_FAMILY"                        : "Change font family",\r\n    "DESCRIPTION_FONT_SIZE"                          : "Change font size; e.g. 13px",\r\n    "DESCRIPTION_FIND_IN_FILES_NODE"                 : "true to enable node based search",\r\n    "DESCRIPTION_FIND_IN_FILES_INSTANT"              : "true to enable instant search",\r\n    "DESCRIPTION_FONT_SMOOTHING"                     : "Mac-only: \\"subpixel-antialiased\\" to enable sub-pixel antialiasing or \\"antialiased\\" for gray scale antialiasing",\r\n    "DESCRIPTION_OPEN_PREFS_IN_SPLIT_VIEW"           : "false to disable opening preferences file in split view",\r\n    "DESCRIPTION_OPEN_USER_PREFS_IN_SECOND_PANE"     : "false to open user preferences file in left/top pane",\r\n    "DESCRIPTION_MERGE_PANES_WHEN_LAST_FILE_CLOSED"  : "true to collapse panes after the last file from the pane is closed via pane header close button",\r\n    "DESCRIPTION_SHOW_PANE_HEADER_BUTTONS"           : "Toggle when to show the close and flip-view buttons on the header.",\r\n    "DEFAULT_PREFERENCES_JSON_HEADER_COMMENT"        : "/*\\n * This is a read-only file with the preferences supported\\n * by {APP_NAME}.\\n * Use this file as a reference to modify your preferences\\n * file \\"brackets.json\\" opened in the other pane.\\n * For more information on how to use preferences inside\\n * {APP_NAME}, refer to the web page at https://github.com/adobe/brackets/wiki/How-to-Use-Brackets#preferences\\n */",\r\n    "DEFAULT_PREFERENCES_JSON_DEFAULT"               : "Default",\r\n    "DESCRIPTION_PURE_CODING_SURFACE"                : "true to enable code only mode and hide all other UI elements in {APP_NAME}",\r\n    "DESCRIPTION_INDENT_LINE_COMMENT"                : "true to enable indenting of line comments",\r\n    "DESCRIPTION_RECENT_FILES_NAV"                   : "Enable/disable navigation in recent files",\r\n    "DESCRIPTION_LIVEDEV_WEBSOCKET_PORT"             : "Port on which WebSocket Server runs for Live Preview",\r\n    "DESCRIPTION_LIVE_DEV_HIGHLIGHT_SETTINGS"        : "Live Preview Highlight settings",\r\n    "DESCRIPTION_LIVEDEV_ENABLE_REVERSE_INSPECT"     : "false to disable live preview reverse inpsect"\r\n});\r\n\n//# sourceURL=/nls/root/strings.js'),
eval('/*\r\n * Copyright (c) 2013 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\ndefine(\'nls/urls\',[\'require\',\'exports\',\'module\'],function (require, exports, module) {\r\n\r\n    "use strict";\r\n\r\n    // Registry for languages that have specific per-language URLs or file paths that we use\r\n    // elsewhere in Brackets.\r\n    //\r\n    // TODO: dynamically populate the local prefix list below?\r\n    module.exports = {\r\n        root: true,\r\n        "bg": true,\r\n        "cs": true,\r\n        "da": true,\r\n        "de": true,\r\n        "es": true,\r\n        "fa-ir": true,\r\n        "fi": true,\r\n        "fr": true,\r\n        "hr": true,\r\n        "id": true,\r\n        "it": true,\r\n        "ja": true,\r\n        "ko": true,\r\n        "nb": true,\r\n        "pl": true,\r\n        "pt-br": true,\r\n        "pt-pt": true,\r\n        "ru": true,\r\n        "sv": true,\r\n        "zh-cn": true,\r\n        "zh-tw": true,\r\n        "tr": true,\r\n        "uk": true\r\n    };\r\n});\r\n\n//# sourceURL=/nls/urls.js'),eval('/*\r\n * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\ndefine(\'nls/root/urls\',{\r\n    // Relative to the samples folder\r\n    "GETTING_STARTED"           : "root/Getting Started",\r\n    "ADOBE_THIRD_PARTY"         : "http://www.adobe.com/go/thirdparty/",\r\n    "MDN_DOCS_LICENSE"          : "http://creativecommons.org/licenses/by-sa/2.5/"\r\n});\r\n\n//# sourceURL=/nls/root/urls.js'),eval("/*\r\n * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the \"Software\"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\ndefine('nls/strings-app',['require','exports','module'],function (require, exports, module) {\r\n\r\n    \"use strict\";\r\n\r\n    // Code that needs to display user strings should call require(\"strings\") to load\r\n    // src/strings.js. This file will dynamically load strings.js for the specified brackets.locale.\r\n    //\r\n    // See the README.md file in this folder for information on how to add a new translation for\r\n    // another language or locale.\r\n    //\r\n    // TODO: dynamically populate the local prefix list below?\r\n    module.exports = {\r\n        root: true\r\n    };\r\n});\r\n\n//# sourceURL=/nls/strings-app.js"),eval('/*\r\n * Copyright (c) 2013 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\ndefine(\'nls/root/strings-app\',{\r\n    // product-specific strings\r\n    "APP_NAME"                             : "Brackets",\r\n\r\n    // Self locales (used by Debug > Switch Language)\r\n    "LOCALE_BG"                                 : "български",\r\n    "LOCALE_CS"                                 : "čeština",\r\n    "LOCALE_DA"                                 : "Dansk",\r\n    "LOCALE_DE"                                 : "Deutsch",\r\n    "LOCALE_EL"                                 : "Ελληνικά",\r\n    "LOCALE_EN"                                 : "English (US)",\r\n    "LOCALE_EN_GB"                              : "English (UK)",\r\n    "LOCALE_ES"                                 : "español",\r\n    "LOCALE_FA_IR"                              : "فارسی",\r\n    "LOCALE_FI"                                 : "suomi",\r\n    "LOCALE_FR"                                 : "français",\r\n    "LOCALE_GL"                                 : "galego",\r\n    "LOCALE_HR"                                 : "hrvatski",\r\n    "LOCALE_HU"                                 : "magyar",\r\n    "LOCALE_ID"                                 : "Bahasa Indonesia",\r\n    "LOCALE_IT"                                 : "italiano",\r\n    "LOCALE_JA"                                 : "日本語",\r\n    "LOCALE_KO"                                 : "한국어",\r\n    "LOCALE_LV"                                 : "latviešu",\r\n    "LOCALE_NB"                                 : "norsk",\r\n    "LOCALE_NL"                                 : "Nederlands",\r\n    "LOCALE_PL"                                 : "polski",\r\n    "LOCALE_PT_BR"                              : "português (BR)",\r\n    "LOCALE_PT_PT"                              : "português (PT)",\r\n    "LOCALE_RO"                                 : "română",\r\n    "LOCALE_RU"                                 : "русский",\r\n    "LOCALE_SK"                                 : "slovenčina",\r\n    "LOCALE_SR"                                 : "Српски",\r\n    "LOCALE_SV"                                 : "svenska",\r\n    "LOCALE_TR"                                 : "Türkçe",\r\n    "LOCALE_UK"                                 : "Українська",\r\n    "LOCALE_ZH_CN"                              : "简体中文",\r\n    "LOCALE_ZH_TW"                              : "繁體中文"\r\n});\r\n\n//# sourceURL=/nls/root/strings-app.js'),eval('/*\r\n * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\n/**\r\n * This file provides the interface to user visible strings in Brackets. Code that needs\r\n * to display strings should should load this module by calling `var Strings = require("strings")`.\r\n * The i18n plugin will dynamically load the strings for the right locale and populate\r\n * the exports variable. See src\\nls\\strings.js for the master file of English strings.\r\n */\r\ndefine(\'strings\',[\'require\',\'exports\',\'module\',\'thirdparty/lodash\',\'i18n!nls/strings\',\'i18n!nls/urls\',\'i18n!nls/strings-app\',\'utils/StringUtils\',\'utils/Global\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    var _ = require("thirdparty/lodash");\r\n\r\n    var strings     = require("i18n!nls/strings"),\r\n        urls        = require("i18n!nls/urls"),\r\n        stringsApp  = require("i18n!nls/strings-app"),\r\n        StringUtils = require("utils/StringUtils");\r\n\r\n    // make sure the global brackets variable is loaded\r\n    require("utils/Global");\r\n\r\n    // Add URLs as additional globals\r\n    var additionalGlobals = $.extend({}, urls),\r\n        parsedVersion = /([0-9]+)\\.([0-9]+)\\.([0-9]+)/.exec(brackets.metadata.version);\r\n\r\n    additionalGlobals.APP_NAME      = brackets.metadata.name || strings.APP_NAME;\r\n    additionalGlobals.APP_TITLE     = brackets.config.app_title || strings.APP_NAME;\r\n    additionalGlobals.TWITTER_NAME  = brackets.config.twitter_name;\r\n    additionalGlobals.VERSION       = brackets.metadata.version;\r\n    additionalGlobals.VERSION_MAJOR = parsedVersion[1];\r\n    additionalGlobals.VERSION_MINOR = parsedVersion[2];\r\n    additionalGlobals.VERSION_PATCH = parsedVersion[3];\r\n\r\n    var isDevBuild = !StringUtils.endsWith(decodeURI(window.location.pathname), "/www/index.html");\r\n    if (isDevBuild) {\r\n        additionalGlobals.BUILD_TYPE = strings.DEVELOPMENT_BUILD;\r\n    } else {\r\n        additionalGlobals.BUILD_TYPE = strings.RELEASE_BUILD;\r\n    }\r\n\r\n    // Insert application strings\r\n    _.forEach(strings, function (value, key) {\r\n        _.forEach(additionalGlobals, function (item, name) {\r\n            strings[key] = strings[key].replace(new RegExp("{" + name + "}", "g"), additionalGlobals[name]);\r\n        });\r\n    });\r\n\r\n    // Append or overlay additional, product-specific strings\r\n    _.forEach(stringsApp, function (value, key) {\r\n        _.forEach(additionalGlobals, function (item, name) {\r\n            stringsApp[key] = stringsApp[key].replace(new RegExp("{" + name + "}", "g"), additionalGlobals[name]);\r\n        });\r\n        strings[key] = stringsApp[key];\r\n    });\r\n\r\n    module.exports = strings;\r\n\r\n});\r\n\n//# sourceURL=/strings.js'),eval('/*\r\n * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\n/*jslint regexp: true */\r\n/*global unescape */\r\n\r\n/**\r\n * Set of utilities for working with files and text content.\r\n */\r\ndefine(\'file/FileUtils\',[\'require\',\'exports\',\'module\',\'utils/Global\',\'filesystem/FileSystemError\',\'utils/DeprecationWarning\',\'language/LanguageManager\',\'utils/PerfUtils\',\'strings\',\'utils/StringUtils\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    require("utils/Global");\r\n\r\n    var FileSystemError     = require("filesystem/FileSystemError"),\r\n        DeprecationWarning  = require("utils/DeprecationWarning"),\r\n        LanguageManager     = require("language/LanguageManager"),\r\n        PerfUtils           = require("utils/PerfUtils"),\r\n        Strings             = require("strings"),\r\n        StringUtils         = require("utils/StringUtils");\r\n\r\n    // These will be loaded asynchronously\r\n    var DocumentCommandHandlers, LiveDevelopmentUtils;\r\n\r\n    /**\r\n     * @const {Number} Maximium file size (in megabytes)\r\n     *   (for display strings)\r\n     *   This must be a hard-coded value since this value\r\n     *   tells how low-level APIs should behave which cannot\r\n     *   have a load order dependency on preferences manager\r\n     */\r\n    var MAX_FILE_SIZE_MB = 16;\r\n\r\n    /**\r\n     * @const {Number} Maximium file size (in bytes)\r\n     *   This must be a hard-coded value since this value\r\n     *   tells how low-level APIs should behave which cannot\r\n     *   have a load order dependency on preferences manager\r\n     */\r\n    var MAX_FILE_SIZE = MAX_FILE_SIZE_MB * 1024 * 1024;\r\n\r\n\r\n    /**\r\n     * Asynchronously reads a file as UTF-8 encoded text.\r\n     * @param {!File} file File to read\r\n     * @return {$.Promise} a jQuery promise that will be resolved with the\r\n     *  file\'s text content plus its timestamp, or rejected with a FileSystemError string\r\n     *  constant if the file can not be read.\r\n     */\r\n    function readAsText(file) {\r\n        var result = new $.Deferred();\r\n\r\n        // Measure performance\r\n        var perfTimerName = PerfUtils.markStart("readAsText:\\t" + file.fullPath);\r\n        result.always(function () {\r\n            PerfUtils.addMeasurement(perfTimerName);\r\n        });\r\n\r\n        // Read file\r\n        file.read(function (err, data, encoding, stat) {\r\n            if (!err) {\r\n                result.resolve(data, stat.mtime);\r\n            } else {\r\n                result.reject(err);\r\n            }\r\n        });\r\n\r\n        return result.promise();\r\n    }\r\n\r\n    /**\r\n     * Asynchronously writes a file as UTF-8 encoded text.\r\n     * @param {!File} file File to write\r\n     * @param {!string} text\r\n     * @param {boolean=} allowBlindWrite Indicates whether or not CONTENTS_MODIFIED\r\n     *      errors---which can be triggered if the actual file contents differ from\r\n     *      the FileSystem\'s last-known contents---should be ignored.\r\n     * @return {$.Promise} a jQuery promise that will be resolved when\r\n     * file writing completes, or rejected with a FileSystemError string constant.\r\n     */\r\n    function writeText(file, text, allowBlindWrite) {\r\n        var result = new $.Deferred(),\r\n            options = {};\r\n\r\n        if (allowBlindWrite) {\r\n            options.blind = true;\r\n        }\r\n\r\n        file.write(text, options, function (err) {\r\n            if (!err) {\r\n                result.resolve();\r\n            } else {\r\n                result.reject(err);\r\n            }\r\n        });\r\n\r\n        return result.promise();\r\n    }\r\n\r\n    /**\r\n     * Line endings\r\n     * @enum {string}\r\n     */\r\n    var LINE_ENDINGS_CRLF = "CRLF",\r\n        LINE_ENDINGS_LF   = "LF";\r\n\r\n    /**\r\n     * Returns the standard line endings for the current platform\r\n     * @return {LINE_ENDINGS_CRLF|LINE_ENDINGS_LF}\r\n     */\r\n    function getPlatformLineEndings() {\r\n        return brackets.platform === "win" ? LINE_ENDINGS_CRLF : LINE_ENDINGS_LF;\r\n    }\r\n\r\n    /**\r\n     * Scans the first 1000 chars of the text to determine how it encodes line endings. Returns\r\n     * null if usage is mixed or if no line endings found.\r\n     * @param {!string} text\r\n     * @return {null|LINE_ENDINGS_CRLF|LINE_ENDINGS_LF}\r\n     */\r\n    function sniffLineEndings(text) {\r\n        var subset = text.substr(0, 1000);  // (length is clipped to text.length)\r\n        var hasCRLF = /\\r\\n/.test(subset);\r\n        var hasLF = /[^\\r]\\n/.test(subset);\r\n\r\n        if ((hasCRLF && hasLF) || (!hasCRLF && !hasLF)) {\r\n            return null;\r\n        } else {\r\n            return hasCRLF ? LINE_ENDINGS_CRLF : LINE_ENDINGS_LF;\r\n        }\r\n    }\r\n\r\n    /**\r\n     * Translates any line ending types in the given text to the be the single form specified\r\n     * @param {!string} text\r\n     * @param {null|LINE_ENDINGS_CRLF|LINE_ENDINGS_LF} lineEndings\r\n     * @return {string}\r\n     */\r\n    function translateLineEndings(text, lineEndings) {\r\n        if (lineEndings !== LINE_ENDINGS_CRLF && lineEndings !== LINE_ENDINGS_LF) {\r\n            lineEndings = getPlatformLineEndings();\r\n        }\r\n\r\n        var eolStr = (lineEndings === LINE_ENDINGS_CRLF ? "\\r\\n" : "\\n");\r\n        var findAnyEol = /\\r\\n|\\r|\\n/g;\r\n\r\n        return text.replace(findAnyEol, eolStr);\r\n    }\r\n\r\n    /**\r\n     * @param {!FileSystemError} name\r\n     * @return {!string} User-friendly, localized error message\r\n     */\r\n    function getFileErrorString(name) {\r\n        // There are a few error codes that we have specific error messages for. The rest are\r\n        // displayed with a generic "(error N)" message.\r\n        var result;\r\n\r\n        if (name === FileSystemError.NOT_FOUND) {\r\n            result = Strings.NOT_FOUND_ERR;\r\n        } else if (name === FileSystemError.NOT_READABLE) {\r\n            result = Strings.NOT_READABLE_ERR;\r\n        } else if (name === FileSystemError.NOT_WRITABLE) {\r\n            result = Strings.NO_MODIFICATION_ALLOWED_ERR_FILE;\r\n        } else if (name === FileSystemError.CONTENTS_MODIFIED) {\r\n            result = Strings.CONTENTS_MODIFIED_ERR;\r\n        } else if (name === FileSystemError.UNSUPPORTED_ENCODING) {\r\n            result = Strings.UNSUPPORTED_ENCODING_ERR;\r\n        } else if (name === FileSystemError.EXCEEDS_MAX_FILE_SIZE) {\r\n            result = StringUtils.format(Strings.EXCEEDS_MAX_FILE_SIZE, MAX_FILE_SIZE_MB);\r\n        } else if (name === FileSystemError.ENCODE_FILE_FAILED) {\r\n            result = Strings.ENCODE_FILE_FAILED_ERR;\r\n        } else if (name === FileSystemError.DECODE_FILE_FAILED) {\r\n            result = Strings.DECODE_FILE_FAILED_ERR;\r\n        } else if (name === FileSystemError.UNSUPPORTED_UTF16_ENCODING) {\r\n            result = Strings.UNSUPPORTED_UTF16_ENCODING_ERR;\r\n        } else {\r\n            result = StringUtils.format(Strings.GENERIC_ERROR, name);\r\n        }\r\n\r\n        return result;\r\n    }\r\n\r\n    /**\r\n     * Shows an error dialog indicating that the given file could not be opened due to the given error\r\n     * @deprecated Use DocumentCommandHandlers.showFileOpenError() instead\r\n     *\r\n     * @param {!FileSystemError} name\r\n     * @return {!Dialog}\r\n     */\r\n    function showFileOpenError(name, path) {\r\n        DeprecationWarning.deprecationWarning("FileUtils.showFileOpenError() has been deprecated. " +\r\n                                              "Please use DocumentCommandHandlers.showFileOpenError() instead.");\r\n        return DocumentCommandHandlers.showFileOpenError(name, path);\r\n    }\r\n\r\n    /**\r\n     * Creates an HTML string for a list of files to be reported on, suitable for use in a dialog.\r\n     * @param {Array.<string>} Array of filenames or paths to display.\r\n     */\r\n    function makeDialogFileList(paths) {\r\n        var result = "<ul class=\'dialog-list\'>";\r\n        paths.forEach(function (path) {\r\n            result += "<li><span class=\'dialog-filename\'>";\r\n            result += StringUtils.breakableUrl(path);\r\n            result += "</span></li>";\r\n        });\r\n        result += "</ul>";\r\n        return result;\r\n    }\r\n\r\n    /**\r\n     * Convert a URI path to a native path.\r\n     * On both platforms, this unescapes the URI\r\n     * On windows, URI paths start with a "/", but have a drive letter ("C:"). In this\r\n     * case, remove the initial "/".\r\n     * @param {!string} path\r\n     * @return {string}\r\n     */\r\n    function convertToNativePath(path) {\r\n        path = unescape(path);\r\n        if (path.indexOf(":") !== -1 && path[0] === "/") {\r\n            return path.substr(1);\r\n        }\r\n\r\n        return path;\r\n    }\r\n\r\n    /**\r\n     * Convert a Windows-native path to use Unix style slashes.\r\n     * On Windows, this converts "C:\\foo\\bar\\baz.txt" to "C:/foo/bar/baz.txt".\r\n     * On Mac, this does nothing, since Mac paths are already in Unix syntax.\r\n     * (Note that this does not add an initial forward-slash. Internally, our\r\n     * APIs generally use the "C:/foo/bar/baz.txt" style for "native" paths.)\r\n     * @param {string} path A native-style path.\r\n     * @return {string} A Unix-style path.\r\n     */\r\n    function convertWindowsPathToUnixPath(path) {\r\n        if (brackets.platform === "win") {\r\n            path = path.replace(/\\\\/g, "/");\r\n        }\r\n        return path;\r\n    }\r\n\r\n    /**\r\n     * Removes the trailing slash from a path, if it has one.\r\n     * Warning: this differs from the format of most paths used in Brackets! Use paths ending in "/"\r\n     * normally, as this is the format used by Directory.fullPath.\r\n     *\r\n     * @param {string} path\r\n     * @return {string}\r\n     */\r\n    function stripTrailingSlash(path) {\r\n        if (path && path[path.length - 1] === "/") {\r\n            return path.slice(0, -1);\r\n        } else {\r\n            return path;\r\n        }\r\n    }\r\n\r\n    /**\r\n     * Get the name of a file or a directory, removing any preceding path.\r\n     * @param {string} fullPath full path to a file or directory\r\n     * @return {string} Returns the base name of a file or the name of a\r\n     * directory\r\n     */\r\n    function getBaseName(fullPath) {\r\n        var lastSlash = fullPath.lastIndexOf("/");\r\n        if (lastSlash === fullPath.length - 1) {  // directory: exclude trailing "/" too\r\n            return fullPath.slice(fullPath.lastIndexOf("/", fullPath.length - 2) + 1, -1);\r\n        } else {\r\n            return fullPath.slice(lastSlash + 1);\r\n        }\r\n    }\r\n\r\n    /**\r\n     * Returns a native absolute path to the \'brackets\' source directory.\r\n     * Note that this only works when run in brackets/src/index.html, so it does\r\n     * not work for unit tests (which is run from brackets/test/SpecRunner.html)\r\n     *\r\n     * WARNING: unlike most paths in Brackets, this path EXCLUDES the trailing "/".\r\n     * @return {string}\r\n     */\r\n    function getNativeBracketsDirectoryPath() {\r\n        var pathname = decodeURI(window.location.pathname);\r\n        var directory = pathname.substr(0, pathname.lastIndexOf("/"));\r\n        return convertToNativePath(directory);\r\n    }\r\n\r\n    /**\r\n     * Given the module object passed to JS module define function,\r\n     * convert the path to a native absolute path.\r\n     * Returns a native absolute path to the module folder.\r\n     *\r\n     * WARNING: unlike most paths in Brackets, this path EXCLUDES the trailing "/".\r\n     * @return {string}\r\n     */\r\n    function getNativeModuleDirectoryPath(module) {\r\n        var path;\r\n\r\n        if (module && module.uri) {\r\n            path = decodeURI(module.uri);\r\n\r\n            // Remove module name and trailing slash from path.\r\n            path = path.substr(0, path.lastIndexOf("/"));\r\n        }\r\n        return path;\r\n    }\r\n\r\n    /**\r\n     * Get the file extension (excluding ".") given a path OR a bare filename.\r\n     * Returns "" for names with no extension. If the name starts with ".", the\r\n     * full remaining text is considered the extension.\r\n     *\r\n     * @param {string} fullPath full path to a file or directory\r\n     * @return {string} Returns the extension of a filename or empty string if\r\n     * the argument is a directory or a filename with no extension\r\n     */\r\n    function getFileExtension(fullPath) {\r\n        var baseName = getBaseName(fullPath),\r\n            idx      = baseName.lastIndexOf(".");\r\n\r\n        if (idx === -1) {\r\n            return "";\r\n        }\r\n\r\n        return baseName.substr(idx + 1);\r\n    }\r\n\r\n    /**\r\n     * Get the file extension (excluding ".") given a path OR a bare filename.\r\n     * Returns "" for names with no extension.\r\n     * If the only `.` in the file is the first character,\r\n     * returns "" as this is not considered an extension.\r\n     * This method considers known extensions which include `.` in them.\r\n     * @deprecated Use LanguageManager.getCompoundFileExtension() instead\r\n     *\r\n     * @param {string} fullPath full path to a file or directory\r\n     * @return {string} Returns the extension of a filename or empty string if\r\n     * the argument is a directory or a filename with no extension\r\n     */\r\n    function getSmartFileExtension(fullPath) {\r\n        DeprecationWarning.deprecationWarning("FileUtils.getSmartFileExtension() has been deprecated. " +\r\n                                              "Please use LanguageManager.getCompoundFileExtension() instead.");\r\n        return LanguageManager.getCompoundFileExtension(fullPath);\r\n    }\r\n\r\n    /**\r\n     * Computes filename as relative to the basePath. For example:\r\n     * basePath: /foo/bar/, filename: /foo/bar/baz.txt\r\n     * returns: baz.txt\r\n     *\r\n     * The net effect is that the common prefix is stripped away. If basePath is not\r\n     * a prefix of filename, then undefined is returned.\r\n     *\r\n     * @param {string} basePath Path against which we\'re computing the relative path\r\n     * @param {string} filename Full path to the file for which we are computing a relative path\r\n     * @return {string} relative path\r\n     */\r\n    function getRelativeFilename(basePath, filename) {\r\n        if (!filename || filename.substr(0, basePath.length) !== basePath) {\r\n            return;\r\n        }\r\n\r\n        return filename.substr(basePath.length);\r\n    }\r\n\r\n    /**\r\n     * Determine if file extension is a static html file extension.\r\n     * @param {string} filePath could be a path, a file name or just a file extension\r\n     * @return {boolean} Returns true if fileExt is in the list\r\n     */\r\n    function isStaticHtmlFileExt(filePath) {\r\n        DeprecationWarning.deprecationWarning("FileUtils.isStaticHtmlFileExt() has been deprecated. " +\r\n                                              "Please use LiveDevelopmentUtils.isStaticHtmlFileExt() instead.");\r\n        return LiveDevelopmentUtils.isStaticHtmlFileExt(filePath);\r\n    }\r\n\r\n    /**\r\n     * Get the parent directory of a file. If a directory is passed, the SAME directory is returned.\r\n     * @param {string} fullPath full path to a file or directory\r\n     * @return {string} Returns the path to the parent directory of a file or the path of a directory,\r\n     *                  including trailing "/"\r\n     */\r\n    function getDirectoryPath(fullPath) {\r\n        return fullPath.substr(0, fullPath.lastIndexOf("/") + 1);\r\n    }\r\n\r\n    /**\r\n     * Get the parent folder of the given file/folder path. Differs from getDirectoryPath() when \'fullPath\'\r\n     * is a directory itself: returns its parent instead of the original path. (Note: if you already have a\r\n     * FileSystemEntry, it\'s faster to use entry.parentPath instead).\r\n     * @param {string} fullPath full path to a file or directory\r\n     * @return {string} Path of containing folder (including trailing "/"); or "" if path was the root\r\n     */\r\n    function getParentPath(fullPath) {\r\n        if (fullPath === "/") {\r\n            return "";\r\n        }\r\n        return fullPath.substring(0, fullPath.lastIndexOf("/", fullPath.length - 2) + 1);\r\n    }\r\n\r\n    /**\r\n     * Get the file name without the extension. Returns "" if name starts with "."\r\n     * @param {string} filename File name of a file or directory, without preceding path\r\n     * @return {string} Returns the file name without the extension\r\n     */\r\n    function getFilenameWithoutExtension(filename) {\r\n        var index = filename.lastIndexOf(".");\r\n        return index === -1 ? filename : filename.slice(0, index);\r\n    }\r\n\r\n    /**\r\n     * @private\r\n     * OS-specific helper for `compareFilenames()`\r\n     * @return {Function} The OS-specific compare function\r\n     */\r\n    var _cmpNames = (function () {\r\n        if (brackets.platform === "win") {\r\n            // Use this function on Windows\r\n            return function (filename1, filename2, lang) {\r\n                var f1 = getFilenameWithoutExtension(filename1),\r\n                    f2 = getFilenameWithoutExtension(filename2);\r\n                return f1.localeCompare(f2, lang, {numeric: true});\r\n            };\r\n        }\r\n\r\n        // Use this function other OSes\r\n        return function (filename1, filename2, lang) {\r\n            return filename1.localeCompare(filename2, lang, {numeric: true});\r\n        };\r\n    }());\r\n\r\n    /**\r\n     * Compares 2 filenames in lowercases. In Windows it compares the names without the\r\n     * extension first and then the extensions to fix issue #4409\r\n     * @param {string} filename1\r\n     * @param {string} filename2\r\n     * @param {boolean} extFirst If true it compares the extensions first and then the file names.\r\n     * @return {number} The result of the compare function\r\n     */\r\n    function compareFilenames(filename1, filename2, extFirst) {\r\n        var lang = brackets.getLocale();\r\n\r\n        filename1 = filename1.toLocaleLowerCase();\r\n        filename2 = filename2.toLocaleLowerCase();\r\n\r\n        function cmpExt() {\r\n            var ext1 = getFileExtension(filename1),\r\n                ext2 = getFileExtension(filename2);\r\n            return ext1.localeCompare(ext2, lang, {numeric: true});\r\n        }\r\n\r\n        function cmpNames() {\r\n            return _cmpNames(filename1, filename2, lang);\r\n        }\r\n\r\n        return extFirst ? (cmpExt() || cmpNames()) : (cmpNames() || cmpExt());\r\n    }\r\n\r\n    /**\r\n     * Compares two paths segment-by-segment, used for sorting. When two files share a path prefix,\r\n     * the less deeply nested one is sorted earlier in the list. Sorts files within the same parent\r\n     * folder based on `compareFilenames()`.\r\n     * @param {string} path1\r\n     * @param {string} path2\r\n     * @return {number} -1, 0, or 1 depending on whether path1 is less than, equal to, or greater than\r\n     *     path2 according to this ordering.\r\n     */\r\n    function comparePaths(path1, path2) {\r\n        var entryName1, entryName2,\r\n            pathParts1 = path1.split("/"),\r\n            pathParts2 = path2.split("/"),\r\n            length     = Math.min(pathParts1.length, pathParts2.length),\r\n            folders1   = pathParts1.length - 1,\r\n            folders2   = pathParts2.length - 1,\r\n            index      = 0;\r\n\r\n        while (index < length) {\r\n            entryName1 = pathParts1[index];\r\n            entryName2 = pathParts2[index];\r\n\r\n            if (entryName1 !== entryName2) {\r\n                if (index < folders1 && index < folders2) {\r\n                    return entryName1.toLocaleLowerCase().localeCompare(entryName2.toLocaleLowerCase());\r\n                } else if (index >= folders1 && index >= folders2) {\r\n                    return compareFilenames(entryName1, entryName2);\r\n                }\r\n                return (index >= folders1 && index < folders2) ? -1 : 1;\r\n            }\r\n            index++;\r\n        }\r\n        return 0;\r\n    }\r\n\r\n    /**\r\n     * @param {string} path Native path in the format used by FileSystemEntry.fullPath\r\n     * @return {string} URI-encoded version suitable for appending to \'file:///`. It\'s not safe to use encodeURI()\r\n     *     directly since it doesn\'t escape chars like "#".\r\n     */\r\n    function encodeFilePath(path) {\r\n        var pathArray = path.split("/");\r\n        pathArray = pathArray.map(function (subPath) {\r\n            return encodeURIComponent(subPath);\r\n        });\r\n        return pathArray.join("/");\r\n    }\r\n\r\n    // Asynchronously load DocumentCommandHandlers\r\n    // This avoids a temporary circular dependency created\r\n    // by relocating showFileOpenError() until deprecation is over\r\n    require(["document/DocumentCommandHandlers"], function (dchModule) {\r\n        DocumentCommandHandlers = dchModule;\r\n    });\r\n\r\n    // Asynchronously load LiveDevelopmentUtils\r\n    // This avoids a temporary circular dependency created\r\n    // by relocating isStaticHtmlFileExt() until deprecation is over\r\n    require(["LiveDevelopment/LiveDevelopmentUtils"], function (lduModule) {\r\n        LiveDevelopmentUtils = lduModule;\r\n    });\r\n\r\n    // Define public API\r\n    exports.LINE_ENDINGS_CRLF              = LINE_ENDINGS_CRLF;\r\n    exports.LINE_ENDINGS_LF                = LINE_ENDINGS_LF;\r\n    exports.getPlatformLineEndings         = getPlatformLineEndings;\r\n    exports.sniffLineEndings               = sniffLineEndings;\r\n    exports.translateLineEndings           = translateLineEndings;\r\n    exports.showFileOpenError              = showFileOpenError;\r\n    exports.getFileErrorString             = getFileErrorString;\r\n    exports.makeDialogFileList             = makeDialogFileList;\r\n    exports.readAsText                     = readAsText;\r\n    exports.writeText                      = writeText;\r\n    exports.convertToNativePath            = convertToNativePath;\r\n    exports.convertWindowsPathToUnixPath   = convertWindowsPathToUnixPath;\r\n    exports.getNativeBracketsDirectoryPath = getNativeBracketsDirectoryPath;\r\n    exports.getNativeModuleDirectoryPath   = getNativeModuleDirectoryPath;\r\n    exports.stripTrailingSlash             = stripTrailingSlash;\r\n    exports.isStaticHtmlFileExt            = isStaticHtmlFileExt;\r\n    exports.getDirectoryPath               = getDirectoryPath;\r\n    exports.getParentPath                  = getParentPath;\r\n    exports.getBaseName                    = getBaseName;\r\n    exports.getRelativeFilename            = getRelativeFilename;\r\n    exports.getFilenameWithoutExtension    = getFilenameWithoutExtension;\r\n    exports.getFileExtension               = getFileExtension;\r\n    exports.getSmartFileExtension          = getSmartFileExtension;\r\n    exports.compareFilenames               = compareFilenames;\r\n    exports.comparePaths                   = comparePaths;\r\n    exports.MAX_FILE_SIZE                  = MAX_FILE_SIZE;\r\n    exports.encodeFilePath                 = encodeFilePath;\r\n});\r\n\n//# sourceURL=/file/FileUtils.js'),
eval('define(\'text!language/languages.json\',[],function () { return \'{\\r\\n    "unknown": {\\r\\n        "name": "Text",\\r\\n        "mode": ["null", "text/plain"]\\r\\n    },\\r\\n    \\r\\n    "groovy": {\\r\\n        "name": "Groovy",\\r\\n        "mode": "groovy",\\r\\n        "fileExtensions": ["groovy", "gradle"],\\r\\n        "blockComment": ["/*", "*/"],\\r\\n        "lineComment": ["//"]\\r\\n    },\\r\\n   \\r\\n    "properties": {\\r\\n        "name": "Properties",\\r\\n        "mode": ["properties", "text/x-properties"],\\r\\n        "fileExtensions": ["ini", "properties"]\\r\\n    },\\r\\n\\r\\n    "css": {\\r\\n        "name": "CSS",\\r\\n        "mode": "css",\\r\\n        "fileExtensions": ["css", "css.erb"],\\r\\n        "blockComment": ["/*", "*/"]\\r\\n    },\\r\\n\\r\\n    "scss": {\\r\\n        "name": "SCSS",\\r\\n        "mode": ["css", "text/x-scss"],\\r\\n        "fileExtensions": ["scss", "scss.erb"],\\r\\n        "blockComment": ["/*", "*/"],\\r\\n        "lineComment": ["//"]\\r\\n    },\\r\\n\\r\\n    "stylus": {\\r\\n        "name": "Stylus",\\r\\n        "mode": ["stylus", "text/x-styl"],\\r\\n        "fileExtensions": ["styl"],\\r\\n        "blockComment": ["/*", "*/"],\\r\\n        "lineComment": ["//"]\\r\\n    },\\r\\n\\r\\n    "html": {\\r\\n        "name": "HTML",\\r\\n        "mode": ["htmlmixed", "text/x-brackets-html"],\\r\\n        "fileExtensions": ["html", "htm", "shtm", "shtml", "xhtml", "cfm", "cfml", "cfc", "dhtml", "xht", "tpl", "twig", "kit", "jsp", "aspx", "ascx", "asp", "master", "cshtml", "vbhtml"],\\r\\n        "blockComment": ["<!--", "-->"]\\r\\n    },\\r\\n    \\r\\n    "ejs": {\\r\\n        "name": "EJS",\\r\\n        "mode": ["htmlembedded", "application/x-ejs"],\\r\\n        "fileExtensions": ["ejs", "dust"],\\r\\n        "blockComment": ["<!--", "-->"]\\r\\n    },\\r\\n    \\r\\n    "erb_html": {\\r\\n        "name": "Embedded Ruby",\\r\\n        "mode": ["htmlembedded", "application/x-erb"],\\r\\n        "fileExtensions": ["erb", "html.erb", "htm.erb"],\\r\\n        "blockComment": ["<!--", "-->"]\\r\\n    },\\r\\n\\r\\n    "javascript": {\\r\\n        "name": "JavaScript",\\r\\n        "mode": "javascript",\\r\\n        "fileExtensions": ["js", "js.erb", "jsm", "_js"],\\r\\n        "blockComment": ["/*", "*/"],\\r\\n        "lineComment": ["//"]\\r\\n    },\\r\\n\\r\\n    "jsx": {\\r\\n        "name": "JSX",\\r\\n        "mode": "jsx",\\r\\n        "fileExtensions": ["jsx"],\\r\\n        "blockComment": ["/*", "*/"],\\r\\n        "lineComment": ["//"]\\r\\n    },\\r\\n\\r\\n    "dart": {\\r\\n        "name": "Dart",\\r\\n        "mode": ["dart", "application/dart"],\\r\\n        "fileExtensions": ["dart"],\\r\\n        "blockComment": ["/*", "*/"],\\r\\n        "lineComment": ["//"]\\r\\n    },\\r\\n\\r\\n    "vbscript": {\\r\\n        "name": "VBScript",\\r\\n        "mode": "vbscript",\\r\\n        "fileExtensions": ["vbs"],\\r\\n        "lineComment": ["\\\'", "REM"]\\r\\n    },\\r\\n\\r\\n    "vb": {\\r\\n        "name": "VB",\\r\\n        "mode": ["vb", "text/x-vb"],\\r\\n        "fileExtensions": ["vb"],\\r\\n        "lineComment": ["\\\'"]\\r\\n    },\\r\\n\\r\\n    "json": {\\r\\n        "name": "JSON",\\r\\n        "mode": ["javascript", "application/json"],\\r\\n        "fileExtensions": ["json"],\\r\\n        "fileNames": [".jshintrc", ".bowerrc"]\\r\\n    },\\r\\n\\r\\n    "xml": {\\r\\n        "name": "XML",\\r\\n        "mode": "xml",\\r\\n        "fileExtensions": ["xml", "wxs", "wxl", "wsdl", "rss", "atom", "rdf", "xslt", "xsl", "xul", "xsd", "xbl", "mathml", "config", "plist", "xaml"],\\r\\n        "blockComment": ["<!--", "-->"]\\r\\n    },\\r\\n\\r\\n    "svg": {\\r\\n        "name": "SVG",\\r\\n        "mode": ["xml", "image/svg+xml"],\\r\\n        "fileExtensions": ["svg"],\\r\\n        "blockComment": ["<!--", "-->"]\\r\\n    },\\r\\n\\r\\n    "php": {\\r\\n        "name": "PHP",\\r\\n        "mode": "php",\\r\\n        "fileExtensions": ["php", "php3", "php4", "php5", "phtm", "phtml", "ctp"],\\r\\n        "blockComment": ["/*", "*/"],\\r\\n        "lineComment": ["//", "#"]\\r\\n    },\\r\\n\\r\\n    "c": {\\r\\n        "name": "C",\\r\\n        "mode": ["clike", "text/x-csrc"],\\r\\n        "fileExtensions": ["c", "h", "i"],\\r\\n        "blockComment": ["/*", "*/"],\\r\\n        "lineComment": ["//"]\\r\\n    },\\r\\n\\r\\n    "cpp": {\\r\\n        "name": "C++",\\r\\n        "mode": ["clike", "text/x-c++src"],\\r\\n        "fileExtensions": ["cc", "cp", "cpp", "c++", "cxx", "hh", "hpp", "hxx", "h++", "ii", "ino"],\\r\\n        "blockComment": ["/*", "*/"],\\r\\n        "lineComment": ["//"]\\r\\n    },\\r\\n\\r\\n    "csharp": {\\r\\n        "name": "C#",\\r\\n        "mode": ["clike", "text/x-csharp"],\\r\\n        "fileExtensions": ["cs", "asax", "ashx"],\\r\\n        "blockComment": ["/*", "*/"],\\r\\n        "lineComment": ["//"]\\r\\n    },\\r\\n\\r\\n    "java": {\\r\\n        "name": "Java",\\r\\n        "mode": ["clike", "text/x-java"],\\r\\n        "fileExtensions": ["java"],\\r\\n        "blockComment": ["/*", "*/"],\\r\\n        "lineComment": ["//"]\\r\\n    },\\r\\n\\r\\n    "scala": {\\r\\n        "name": "Scala",\\r\\n        "mode": ["clike", "text/x-scala"],\\r\\n        "fileExtensions": ["scala", "sbt"],\\r\\n        "blockComment": ["/*", "*/"],\\r\\n        "lineComment": ["//"]\\r\\n    },\\r\\n\\r\\n    "coffeescript": {\\r\\n        "name": "CoffeeScript",\\r\\n        "mode": "coffeescript",\\r\\n        "fileExtensions": ["coffee", "cf", "cson", "_coffee"],\\r\\n        "fileNames": ["Cakefile"],\\r\\n        "blockComment": ["###", "###"],\\r\\n        "lineComment": ["#"]\\r\\n    },\\r\\n\\r\\n    "clojure": {\\r\\n        "name": "Clojure",\\r\\n        "mode": "clojure",\\r\\n        "fileExtensions": ["clj", "cljs", "cljx"],\\r\\n        "lineComment": [";", ";;"]\\r\\n    },\\r\\n\\r\\n    "perl": {\\r\\n        "name": "Perl",\\r\\n        "mode": "perl",\\r\\n        "fileExtensions": ["pl", "pm", "t"],\\r\\n        "lineComment": ["#"]\\r\\n    },\\r\\n\\r\\n    "ruby": {\\r\\n        "name": "Ruby",\\r\\n        "mode": "ruby",\\r\\n        "fileExtensions": ["rb", "ru", "gemspec", "rake"],\\r\\n        "fileNames": ["Gemfile", "Rakefile", "Guardfile", "Vagrantfile"],\\r\\n        "lineComment": ["#"]\\r\\n    },\\r\\n\\r\\n    "python": {\\r\\n        "name": "Python",\\r\\n        "mode": "python",\\r\\n        "fileExtensions": ["py", "pyw", "wsgi", "gyp", "gypi"],\\r\\n        "lineComment": ["#"]\\r\\n    },\\r\\n\\r\\n    "sass": {\\r\\n        "name": "SASS",\\r\\n        "mode": "sass",\\r\\n        "fileExtensions": ["sass"],\\r\\n        "blockComment": ["/*", "*/"],\\r\\n        "lineComment": ["//"]\\r\\n    },\\r\\n\\r\\n    "lua": {\\r\\n        "name": "Lua",\\r\\n        "mode": "lua",\\r\\n        "fileExtensions": ["lua"],\\r\\n        "blockComment": ["--[[", "]]"],\\r\\n        "lineComment": ["--"]\\r\\n    },\\r\\n\\r\\n    "sql": {\\r\\n        "name": "SQL",\\r\\n        "mode": ["sql", "text/x-mysql"],\\r\\n        "fileExtensions": ["sql"]\\r\\n    },\\r\\n\\r\\n    "diff": {\\r\\n        "name": "Diff",\\r\\n        "mode": "diff",\\r\\n        "fileExtensions": ["diff", "patch"]\\r\\n    },\\r\\n\\r\\n    "markdown": {\\r\\n        "name": "Markdown",\\r\\n        "mode": "markdown",\\r\\n        "fileExtensions": ["md", "markdown", "mdown", "mkdn"],\\r\\n        "blockComment": ["<!--", "-->"]\\r\\n    },\\r\\n\\r\\n    "gfm": {\\r\\n        "name": "Markdown (GitHub)",\\r\\n        "mode": "gfm"\\r\\n    },\\r\\n\\r\\n    "yaml": {\\r\\n        "name": "YAML",\\r\\n        "mode": "yaml",\\r\\n        "fileExtensions": ["yaml", "yml"],\\r\\n        "lineComment": ["#"]\\r\\n    },\\r\\n\\r\\n    "hx": {\\r\\n        "name": "Haxe",\\r\\n        "mode": "haxe",\\r\\n        "fileExtensions": ["hx"],\\r\\n        "blockComment": ["/*", "*/"],\\r\\n        "lineComment": ["//"]\\r\\n    },\\r\\n\\r\\n    "bash": {\\r\\n        "name": "Bash",\\r\\n        "mode": ["shell", "text/x-sh"],\\r\\n        "fileExtensions": ["sh", "command", "bash"],\\r\\n        "fileNames": [".bash_login", ".bash_logout", ".bash_profile", ".bashrc", ".profile"],\\r\\n        "lineComment": ["#"]\\r\\n    },\\r\\n  \\r\\n    "image": {\\r\\n        "name": "Image",\\r\\n        "fileExtensions": ["gif", "png", "jpe", "jpeg", "jpg", "ico", "bmp", "webp"],\\r\\n        "isBinary": true\\r\\n    },\\r\\n    \\r\\n    "audio": {\\r\\n        "name": "Audio",\\r\\n        "fileExtensions": ["mp3", "wav", "aif", "aiff", "ogg"],\\r\\n        "isBinary": true\\r\\n    },\\r\\n    \\r\\n    "binary": {\\r\\n        "name": "Other Binary",\\r\\n        "fileExtensions": [\\r\\n            "a", "ai", "avi", "bin", "cab", "com", "db", "dll", "dmg",\\r\\n            "doc", "docx", "dot", "dotx", "dsym", "dylib", "egg", "epub", "eot",\\r\\n            "exe", "flv", "gz", "gzip", "htmz", "htmlz", "ipch", "iso", "jar",\\r\\n            "jsz", "lib", "mpeg", "mpg", "mp4", "msi", "node", "o", "obj", "odc",\\r\\n            "odb", "odf", "odg", "odp", "ods", "odt", "otf", "pak", "pdb", "pdf",\\r\\n            "pdi", "ppt", "pptx", "psd", "rar", "sdf", "so", "sqlite", "suo", "svgz",\\r\\n            "swf", "tar", "tif", "tiff", "ttf", "woff", "xls", "xlsx", "zip"\\r\\n        ],\\r\\n        "isBinary": true\\r\\n    },\\r\\n\\r\\n    "haskell": {\\r\\n        "name": "Haskell",\\r\\n        "mode": "haskell",\\r\\n        "fileExtensions": ["hs"],\\r\\n        "blockComment": ["{-", "-}"],\\r\\n        "lineComment": ["--"]\\r\\n    },\\r\\n    \\r\\n    "turtle": {\\r\\n        "name": "RDF Turtle",\\r\\n        "mode": "turtle",\\r\\n        "fileExtensions": ["ttl"],\\r\\n        "lineComment": ["#"]\\r\\n    },\\r\\n    \\r\\n    "go": {\\r\\n        "name": "Go",\\r\\n        "mode": "go",\\r\\n        "fileExtensions": ["go"],\\r\\n        "blockComment": ["/*", "*/"],\\r\\n        "lineComment": ["//"]\\r\\n    },\\r\\n\\r\\n    "pug": {\\r\\n        "name": "Pug",\\r\\n        "mode": "pug",\\r\\n        "fileExtensions": ["pug", "jade"],\\r\\n        "lineComment": ["//"]\\r\\n    }\\r\\n\\r\\n}\\r\\n\';});\n\n//# sourceURL=/text!language/languages.json'),eval('/*\r\n * Copyright (c) 2012 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\n/*unittests: LanguageManager*/\r\n\r\n/**\r\n * LanguageManager provides access to the languages supported by Brackets\r\n *\r\n * To find out which languages we support by default, have a look at languages.json.\r\n *\r\n * To get access to an existing language, call getLanguage():\r\n *\r\n *     var language = LanguageManager.getLanguage("<id>");\r\n *\r\n * To define your own languages, call defineLanguage():\r\n *\r\n *     LanguageManager.defineLanguage("haskell", {\r\n *         name: "Haskell",\r\n *         mode: "haskell",\r\n *         fileExtensions: ["hs"],\r\n *         blockComment: ["{-", "-}"],\r\n *         lineComment: ["--"]\r\n *     });\r\n *\r\n * To use that language and its related mode, wait for the returned promise to be resolved:\r\n *\r\n *     LanguageManager.defineLanguage("haskell", definition).done(function (language) {\r\n *         console.log("Language " + language.getName() + " is now available!");\r\n *     });\r\n *\r\n * The extension can also contain dots:\r\n *\r\n *     LanguageManager.defineLanguage("literatecoffeescript", {\r\n *         name: "Literate CoffeeScript",\r\n *         mode: "coffeescript",\r\n *         fileExtensions: ["litcoffee", "coffee.md"]\r\n *     });\r\n *\r\n * You can also specify file names:\r\n *\r\n *     LanguageManager.defineLanguage("makefile", {\r\n *         name: "Make",\r\n *         mode: ["null", "text/plain"],\r\n *         fileNames: ["Makefile"]\r\n *     });\r\n *\r\n * You can combine file names and extensions, or not define them at all.\r\n *\r\n * You can also refine an existing language:\r\n *\r\n *     var language = LanguageManager.getLanguage("haskell");\r\n *     language.setLineCommentSyntax(["--"]);\r\n *     language.setBlockCommentSyntax("{-", "-}");\r\n *     language.addFileExtension("lhs");\r\n *\r\n * Some CodeMirror modes define variations of themselves. They are called MIME modes.\r\n * To find existing MIME modes, search for "CodeMirror.defineMIME" in thirdparty/CodeMirror/mode\r\n * For instance, C++, C# and Java all use the clike (C-like) mode with different settings and a different MIME name.\r\n * You can refine the mode definition by specifying the MIME mode as well:\r\n *\r\n *     LanguageManager.defineLanguage("csharp", {\r\n *         name: "C#",\r\n *         mode: ["clike", "text/x-csharp"],\r\n *         ...\r\n *     });\r\n *\r\n * Defining the base mode is still necessary to know which file to load.\r\n * However, language.getMode() will return just the MIME mode if one was\r\n * specified.\r\n *\r\n * If you need to configure a mode, you can just create a new MIME mode and use that:\r\n *\r\n *     CodeMirror.defineMIME("text/x-brackets-html", {\r\n *         "name": "htmlmixed",\r\n *         "scriptTypes": [{"matches": /\\/x-handlebars-template|\\/x-mustache/i,\r\n *                        "mode": null}]\r\n *     });\r\n *\r\n *     LanguageManager.defineLanguage("html", {\r\n *         name: "HTML",\r\n *         mode: ["htmlmixed", "text/x-brackets-html"],\r\n *         ...\r\n *     });\r\n *\r\n * If a mode is not shipped with our CodeMirror distribution, you need to first load it yourself.\r\n * If the mode is part of our CodeMirror distribution, it gets loaded automatically.\r\n *\r\n * You can also defines binary file types, i.e. Brackets supports image files by default,\r\n * such as *.jpg, *.png etc.\r\n * Binary files do not require mode because modes are specific to CodeMirror, which\r\n * only handles text based file types.\r\n * To register a binary language the isBinary flag must be set, i.e.\r\n *\r\n *     LanguageManager.defineLanguage("audio", {\r\n *         name: "Audio",\r\n *         fileExtensions: ["mp3", "wav", "aif", "aiff", "ogg"],\r\n *         isBinary: true\r\n *     });\r\n *\r\n *\r\n * LanguageManager dispatches two events:\r\n *\r\n *  - languageAdded -- When any new Language is added. 2nd arg is the new Language.\r\n *  - languageModified -- When the attributes of a Language change, or when the Language gains or loses\r\n *          file extension / filename mappings. 2nd arg is the modified Language.\r\n */\r\ndefine(\'language/LanguageManager\',[\'require\',\'exports\',\'module\',\'thirdparty/CodeMirror/lib/codemirror\',\'utils/EventDispatcher\',\'utils/Async\',\'file/FileUtils\',\'strings\',\'text!language/languages.json\',\'thirdparty/lodash\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n\r\n    // Dependencies\r\n    var CodeMirror            = require("thirdparty/CodeMirror/lib/codemirror"),\r\n        EventDispatcher       = require("utils/EventDispatcher"),\r\n        Async                 = require("utils/Async"),\r\n        FileUtils             = require("file/FileUtils"),\r\n        Strings               = require("strings"),\r\n        _defaultLanguagesJSON = require("text!language/languages.json"),\r\n        _                     = require("thirdparty/lodash"),\r\n\r\n        // PreferencesManager is loaded near the end of the file\r\n        PreferencesManager;\r\n\r\n    // State\r\n    var _fallbackLanguage               = null,\r\n        _pendingLanguages               = {},\r\n        _languages                      = {},\r\n        _baseFileExtensionToLanguageMap = {},\r\n        _fileExtensionToLanguageMap     = Object.create(_baseFileExtensionToLanguageMap),\r\n        _fileNameToLanguageMap          = {},\r\n        _filePathToLanguageMap          = {},\r\n        _modeToLanguageMap              = {},\r\n        _ready;\r\n\r\n    // Constants\r\n\r\n    var _EXTENSION_MAP_PREF = "language.fileExtensions",\r\n        _NAME_MAP_PREF      = "language.fileNames";\r\n\r\n    // Tracking for changes to mappings made by preferences\r\n    var _prefState = {};\r\n\r\n    _prefState[_EXTENSION_MAP_PREF] = {\r\n        last: {},\r\n        overridden: {},\r\n        add: "addFileExtension",\r\n        remove: "removeFileExtension",\r\n        get: "getLanguageForExtension"\r\n    };\r\n\r\n    _prefState[_NAME_MAP_PREF] = {\r\n        last: {},\r\n        overridden: {},\r\n        add: "addFileName",\r\n        remove: "removeFileName",\r\n        get: "getLanguageForPath"\r\n    };\r\n\r\n    // Helper functions\r\n\r\n    /**\r\n     * Checks whether value is a non-empty string. Reports an error otherwise.\r\n     * If no deferred is passed, console.error is called.\r\n     * Otherwise the deferred is rejected with the error message.\r\n     * @param {*}                value         The value to validate\r\n     * @param {!string}          description   A helpful identifier for value\r\n     * @param {?jQuery.Deferred} deferred      A deferred to reject with the error message in case of an error\r\n     * @return {boolean} True if the value is a non-empty string, false otherwise\r\n     */\r\n    function _validateNonEmptyString(value, description, deferred) {\r\n        var reportError = deferred ? deferred.reject : console.error;\r\n\r\n        // http://stackoverflow.com/questions/1303646/check-whether-variable-is-number-or-string-in-javascript\r\n        if (Object.prototype.toString.call(value) !== "[object String]") {\r\n            reportError(description + " must be a string");\r\n            return false;\r\n        }\r\n        if (value === "") {\r\n            reportError(description + " must not be empty");\r\n            return false;\r\n        }\r\n        return true;\r\n    }\r\n\r\n    /**\r\n     * Monkey-patch CodeMirror to prevent modes from being overwritten by extensions.\r\n     * We may rely on the tokens provided by some of these modes.\r\n     */\r\n    function _patchCodeMirror() {\r\n        var _original_CodeMirror_defineMode = CodeMirror.defineMode;\r\n        function _wrapped_CodeMirror_defineMode(name) {\r\n            if (CodeMirror.modes[name]) {\r\n                console.error("There already is a CodeMirror mode with the name \\"" + name + "\\"");\r\n                return;\r\n            }\r\n            _original_CodeMirror_defineMode.apply(CodeMirror, arguments);\r\n        }\r\n        CodeMirror.defineMode = _wrapped_CodeMirror_defineMode;\r\n    }\r\n\r\n    /**\r\n     * Adds a global mode-to-language association.\r\n     * @param {!string} mode The mode to associate the language with\r\n     * @param {!Language} language The language to associate with the mode\r\n     */\r\n    function _setLanguageForMode(mode, language) {\r\n        if (_modeToLanguageMap[mode]) {\r\n            console.warn("CodeMirror mode \\"" + mode + "\\" is already used by language " + _modeToLanguageMap[mode]._name + " - cannot fully register language " + language._name +\r\n                         " using the same mode. Some features will treat all content with this mode as language " + _modeToLanguageMap[mode]._name);\r\n            return;\r\n        }\r\n\r\n        _modeToLanguageMap[mode] = language;\r\n    }\r\n\r\n    /**\r\n     * Resolves a language ID to a Language object.\r\n     * File names have a higher priority than file extensions.\r\n     * @param {!string} id Identifier for this language: lowercase letters, digits, and _ separators (e.g. "cpp", "foo_bar", "c99")\r\n     * @return {Language} The language with the provided identifier or undefined\r\n     */\r\n    function getLanguage(id) {\r\n        return _languages[id];\r\n    }\r\n\r\n    /**\r\n     * Resolves a file extension to a Language object.\r\n     * *Warning:* it is almost always better to use getLanguageForPath(), since Language can depend\r\n     * on file name and even full path. Use this API only if no relevant file/path exists.\r\n     * @param {!string} extension Extension that language should be resolved for\r\n     * @return {?Language} The language for the provided extension or null if none exists\r\n     */\r\n    function getLanguageForExtension(extension) {\r\n        return _fileExtensionToLanguageMap[extension.toLowerCase()];\r\n    }\r\n\r\n    /**\r\n     * Resolves a file path to a Language object.\r\n     * @param {!string} path Path to the file to find a language for\r\n     * @param {?boolean} ignoreOverride If set to true will cause the lookup to ignore any\r\n     *      overrides and return default binding. By default override is not ignored.\r\n     *\r\n     * @return {Language} The language for the provided file type or the fallback language\r\n     */\r\n    function getLanguageForPath(path, ignoreOverride) {\r\n        var fileName,\r\n            language = _filePathToLanguageMap[path],\r\n            extension,\r\n            parts;\r\n\r\n        // if there\'s an override, return it\r\n        if (!ignoreOverride && language) {\r\n            return language;\r\n        }\r\n\r\n        fileName = FileUtils.getBaseName(path).toLowerCase();\r\n        language = _fileNameToLanguageMap[fileName];\r\n\r\n        // If no language was found for the file name, use the file extension instead\r\n        if (!language) {\r\n            // Split the file name into parts:\r\n            //   "foo.coffee.md"   => ["foo", "coffee", "md"]\r\n            //   ".profile.bak"    => ["", "profile", "bak"]\r\n            //   "1. Vacation.txt" => ["1", " Vacation", "txt"]\r\n            parts = fileName.split(".");\r\n\r\n            // A leading dot does not indicate a file extension, but marks the file as hidden => remove it\r\n            if (parts[0] === "") {\r\n                // ["", "profile", "bak"] => ["profile", "bak"]\r\n                parts.shift();\r\n            }\r\n\r\n            // The first part is assumed to be the title, not the extension => remove it\r\n            //   ["foo", "coffee", "md"]   => ["coffee", "md"]\r\n            //   ["profile", "bak"]        => ["bak"]\r\n            //   ["1", " Vacation", "txt"] => [" Vacation", "txt"]\r\n            parts.shift();\r\n\r\n            // Join the remaining parts into a file extension until none are left or a language was found\r\n            while (!language && parts.length) {\r\n                // First iteration:\r\n                //   ["coffee", "md"]     => "coffee.md"\r\n                //   ["bak"]              => "bak"\r\n                //   [" Vacation", "txt"] => " Vacation.txt"\r\n                // Second iteration (assuming no language was found for "coffee.md"):\r\n                //   ["md"]  => "md"\r\n                //   ["txt"] => "txt"\r\n                extension = parts.join(".");\r\n                language  = _fileExtensionToLanguageMap[extension];\r\n                // Remove the first part\r\n                // First iteration:\r\n                //   ["coffee", "md"]     => ["md"]\r\n                //   ["bak"]              => []\r\n                //   [" Vacation", "txt"] => ["txt"]\r\n                // Second iteration:\r\n                //   ["md"]  => []\r\n                //   ["txt"] => []\r\n                parts.shift();\r\n            }\r\n        }\r\n\r\n        return language || _fallbackLanguage;\r\n    }\r\n\r\n    /**\r\n     * Returns a map of all the languages currently defined in the LanguageManager. The key to\r\n     * the map is the language id and the value is the language object.\r\n     *\r\n     * @return {Object.<string, Language>} A map containing all of the\r\n     *      languages currently defined.\r\n     */\r\n    function getLanguages() {\r\n        return $.extend({}, _languages); // copy to prevent modification\r\n    }\r\n\r\n    /**\r\n     * Resolves a CodeMirror mode to a Language object.\r\n     * @param {!string} mode CodeMirror mode\r\n     * @return {Language} The language for the provided mode or the fallback language\r\n     */\r\n    function _getLanguageForMode(mode) {\r\n        var language = _modeToLanguageMap[mode];\r\n        if (language) {\r\n            return language;\r\n        }\r\n\r\n        // In case of unsupported languages\r\n        console.log("Called LanguageManager._getLanguageForMode with a mode for which no language has been registered:", mode);\r\n        return _fallbackLanguage;\r\n    }\r\n\r\n    /**\r\n     * @private\r\n     * Notify listeners when a language is added\r\n     * @param {!Language} language The new language\r\n     */\r\n    function _triggerLanguageAdded(language) {\r\n        // finally, store language to _language map\r\n        _languages[language.getId()] = language;\r\n        exports.trigger("languageAdded", language);\r\n    }\r\n\r\n    /**\r\n     * @private\r\n     * Notify listeners when a language is modified\r\n     * @param {!Language} language The modified language\r\n     */\r\n    function _triggerLanguageModified(language) {\r\n        exports.trigger("languageModified", language);\r\n    }\r\n\r\n    /**\r\n     * Adds a language mapping for the specified fullPath. If language is falsy (null or undefined), the mapping\r\n     * is removed. The override is NOT persisted across Brackets sessions.\r\n     *\r\n     * @param {!fullPath} fullPath absolute path of the file\r\n     * @param {?object} language language to associate the file with or falsy value to remove any existing override\r\n     */\r\n    function setLanguageOverrideForPath(fullPath, language) {\r\n        var oldLang = getLanguageForPath(fullPath);\r\n        if (!language) {\r\n            delete _filePathToLanguageMap[fullPath];\r\n        } else {\r\n            _filePathToLanguageMap[fullPath] = language;\r\n        }\r\n        var newLang = getLanguageForPath(fullPath);\r\n\r\n        // Old language changed since this path is no longer mapped to it\r\n        _triggerLanguageModified(oldLang);\r\n        // New language changed since a path is now mapped to it that wasn\'t before\r\n        _triggerLanguageModified(newLang);\r\n    }\r\n\r\n    /**\r\n     * Resets all the language overrides for file paths. Used by unit tests only.\r\n     */\r\n    function _resetPathLanguageOverrides() {\r\n        _filePathToLanguageMap = {};\r\n    }\r\n\r\n    /**\r\n     * Get the file extension (excluding ".") given a path OR a bare filename.\r\n     * Returns "" for names with no extension.\r\n     * If the only `.` in the file is the first character,\r\n     * returns "" as this is not considered an extension.\r\n     * This method considers known extensions which include `.` in them.\r\n     *\r\n     * @param {string} fullPath full path to a file or directory\r\n     * @return {string} Returns the extension of a filename or empty string if\r\n     * the argument is a directory or a filename with no extension\r\n     */\r\n    function getCompoundFileExtension(fullPath) {\r\n        var baseName = FileUtils.getBaseName(fullPath),\r\n            parts = baseName.split(".");\r\n\r\n        // get rid of file name\r\n        parts.shift();\r\n        if (baseName[0] === ".") {\r\n            // if starts with a `.`, then still consider it as file name\r\n            parts.shift();\r\n        }\r\n\r\n        var extension = [parts.pop()], // last part is always an extension\r\n            i = parts.length;\r\n        while (i--) {\r\n            if (getLanguageForExtension(parts[i])) {\r\n                extension.unshift(parts[i]);\r\n            } else {\r\n                break;\r\n            }\r\n        }\r\n        return extension.join(".");\r\n    }\r\n\r\n\r\n\r\n    /**\r\n     * Model for a language.\r\n     * @constructor\r\n     */\r\n    function Language() {\r\n        this._fileExtensions    = [];\r\n        this._fileNames         = [];\r\n        this._modeToLanguageMap = {};\r\n        this._lineCommentSyntax = [];\r\n    }\r\n\r\n\r\n    /**\r\n     * Identifier for this language\r\n     * @type {string}\r\n     */\r\n    Language.prototype._id = null;\r\n\r\n    /**\r\n     * Human-readable name of this language\r\n     * @type {string}\r\n     */\r\n    Language.prototype._name = null;\r\n\r\n    /**\r\n     * CodeMirror mode for this language\r\n     * @type {string}\r\n     */\r\n    Language.prototype._mode = null;\r\n\r\n    /**\r\n     * File extensions that use this language\r\n     * @type {Array.<string>}\r\n     */\r\n    Language.prototype._fileExtensions = null;\r\n\r\n    /**\r\n     * File names for extensionless files that use this language\r\n     * @type {Array.<string>}\r\n     */\r\n    Language.prototype._fileNames = null;\r\n\r\n    /**\r\n     * Line comment syntax\r\n     * @type {Array.<string>}\r\n     */\r\n    Language.prototype._lineCommentSyntax = null;\r\n\r\n    /**\r\n     * Which language to use for what CodeMirror mode\r\n     * @type {Object.<string,Language>}\r\n     */\r\n    Language.prototype._modeToLanguageMap = null;\r\n\r\n    /**\r\n     * Block comment syntax\r\n     * @type {{ prefix: string, suffix: string }}\r\n     */\r\n    Language.prototype._blockCommentSyntax = null;\r\n\r\n    /**\r\n     * Whether or not the language is binary\r\n     * @type {boolean}\r\n     */\r\n    Language.prototype._isBinary = false;\r\n\r\n    /**\r\n     * Returns the identifier for this language.\r\n     * @return {string} The identifier\r\n     */\r\n    Language.prototype.getId = function () {\r\n        return this._id;\r\n    };\r\n\r\n    /**\r\n     * Sets the identifier for this language or prints an error to the console.\r\n     * @param {!string} id Identifier for this language: lowercase letters, digits, and _ separators (e.g. "cpp", "foo_bar", "c99")\r\n     * @return {boolean} Whether the ID was valid and set or not\r\n     */\r\n    Language.prototype._setId = function (id) {\r\n        if (!_validateNonEmptyString(id, "Language ID")) {\r\n            return false;\r\n        }\r\n        // Make sure the ID is a string that can safely be used universally by the computer - as a file name, as an object key, as part of a URL, etc.\r\n        // Hence we use "_" instead of "." since the latter often has special meaning\r\n        if (!id.match(/^[a-z0-9]+(_[a-z0-9]+)*$/)) {\r\n            console.error("Invalid language ID \\"" + id + "\\": Only groups of lower case letters and numbers are allowed, separated by underscores.");\r\n            return false;\r\n        }\r\n\r\n        this._id = id;\r\n        return true;\r\n    };\r\n\r\n    /**\r\n     * Returns the human-readable name of this language.\r\n     * @return {string} The name\r\n     */\r\n    Language.prototype.getName = function () {\r\n        return this._name;\r\n    };\r\n\r\n    /**\r\n     * Sets the human-readable name of this language or prints an error to the console.\r\n     * @param {!string} name Human-readable name of the language, as it\'s commonly referred to (e.g. "C++")\r\n     * @return {boolean} Whether the name was valid and set or not\r\n     */\r\n    Language.prototype._setName = function (name) {\r\n        if (!_validateNonEmptyString(name, "name")) {\r\n            return false;\r\n        }\r\n\r\n        this._name = name;\r\n        return true;\r\n    };\r\n\r\n    /**\r\n     * Returns the CodeMirror mode for this language.\r\n     * @return {string} The mode\r\n     */\r\n    Language.prototype.getMode = function () {\r\n        return this._mode;\r\n    };\r\n\r\n    /**\r\n     * Loads a mode and sets it for this language.\r\n     *\r\n     * @param {(string|Array.<string>)} mode  CodeMirror mode (e.g. "htmlmixed"), optionally paired with a MIME mode defined by\r\n     *      that mode (e.g. ["clike", "text/x-c++src"]). Unless the mode is located in thirdparty/CodeMirror/mode/<name>/<name>.js,\r\n     *      you need to first load it yourself.\r\n     * @return {$.Promise} A promise object that will be resolved when the mode is loaded and set\r\n     */\r\n    Language.prototype._loadAndSetMode = function (mode) {\r\n        var result      = new $.Deferred(),\r\n            self        = this,\r\n            mimeMode; // Mode can be an array specifying a mode plus a MIME mode defined by that mode ["clike", "text/x-c++src"]\r\n\r\n        if (Array.isArray(mode)) {\r\n            if (mode.length !== 2) {\r\n                result.reject("Mode must either be a string or an array containing two strings");\r\n                return result.promise();\r\n            }\r\n            mimeMode = mode[1];\r\n            mode = mode[0];\r\n        }\r\n\r\n        // mode must not be empty. Use "null" (the string "null") mode for plain text\r\n        if (!_validateNonEmptyString(mode, "mode", result)) {\r\n            result.reject();\r\n            return result.promise();\r\n        }\r\n\r\n        var finish = function () {\r\n            if (!CodeMirror.modes[mode]) {\r\n                result.reject("CodeMirror mode \\"" + mode + "\\" is not loaded");\r\n                return;\r\n            }\r\n\r\n            if (mimeMode) {\r\n                var modeConfig = CodeMirror.mimeModes[mimeMode];\r\n\r\n                if (!modeConfig) {\r\n                    result.reject("CodeMirror MIME mode \\"" + mimeMode + "\\" not found");\r\n                    return;\r\n                }\r\n            }\r\n\r\n            // This mode is now only about what to tell CodeMirror\r\n            // The base mode was only necessary to load the proper mode file\r\n            self._mode = mimeMode || mode;\r\n            self._wasModified();\r\n\r\n            result.resolve(self);\r\n        };\r\n\r\n        if (CodeMirror.modes[mode]) {\r\n            finish();\r\n        } else {\r\n            require(["thirdparty/CodeMirror/mode/" + mode + "/" + mode], finish);\r\n        }\r\n\r\n        return result.promise();\r\n    };\r\n\r\n    /**\r\n     * Returns an array of file extensions for this language.\r\n     * @return {Array.<string>} File extensions used by this language\r\n     */\r\n    Language.prototype.getFileExtensions = function () {\r\n        // Use concat to create a copy of this array, preventing external modification\r\n        return this._fileExtensions.concat();\r\n    };\r\n\r\n    /**\r\n     * Returns an array of file names for extensionless files that use this language.\r\n     * @return {Array.<string>} Extensionless file names used by this language\r\n     */\r\n    Language.prototype.getFileNames = function () {\r\n        // Use concat to create a copy of this array, preventing external modification\r\n        return this._fileNames.concat();\r\n    };\r\n\r\n    /**\r\n     * Adds one or more file extensions to this language.\r\n     * @param {!string|Array.<string>} extension A file extension (or array thereof) used by this language\r\n     */\r\n    Language.prototype.addFileExtension = function (extension) {\r\n        if (Array.isArray(extension)) {\r\n            extension.forEach(this._addFileExtension.bind(this));\r\n        } else {\r\n            this._addFileExtension(extension);\r\n        }\r\n    };\r\n    Language.prototype._addFileExtension = function (extension) {\r\n        // Remove a leading dot if present\r\n        if (extension.charAt(0) === ".") {\r\n            extension = extension.substr(1);\r\n        }\r\n\r\n        // Make checks below case-INsensitive\r\n        extension = extension.toLowerCase();\r\n\r\n        if (this._fileExtensions.indexOf(extension) === -1) {\r\n            this._fileExtensions.push(extension);\r\n\r\n            var language = _fileExtensionToLanguageMap[extension];\r\n            if (language) {\r\n                console.warn("Cannot register file extension \\"" + extension + "\\" for " + this._name + ", it already belongs to " + language._name);\r\n            } else {\r\n                _fileExtensionToLanguageMap[extension] = this;\r\n            }\r\n\r\n            this._wasModified();\r\n        } else if(!_fileExtensionToLanguageMap[extension]) {\r\n            \r\n            // Language should be in the extension map but isn\'t\r\n            _fileExtensionToLanguageMap[extension] = this;\r\n            this._wasModified();\r\n        }\r\n    };\r\n\r\n    /**\r\n     * Unregisters one or more file extensions from this language.\r\n     * @param {!string|Array.<string>} extension File extension (or array thereof) to stop using for this language\r\n     */\r\n    Language.prototype.removeFileExtension = function (extension) {\r\n        if (Array.isArray(extension)) {\r\n            extension.forEach(this._removeFileExtension.bind(this));\r\n        } else {\r\n            this._removeFileExtension(extension);\r\n        }\r\n    };\r\n    Language.prototype._removeFileExtension = function (extension) {\r\n        // Remove a leading dot if present\r\n        if (extension.charAt(0) === ".") {\r\n            extension = extension.substr(1);\r\n        }\r\n\r\n        // Make checks below case-INsensitive\r\n        extension = extension.toLowerCase();\r\n\r\n        var index = this._fileExtensions.indexOf(extension);\r\n        if (index !== -1) {\r\n            this._fileExtensions.splice(index, 1);\r\n\r\n            delete _fileExtensionToLanguageMap[extension];\r\n\r\n            this._wasModified();\r\n        }\r\n    };\r\n\r\n    /**\r\n     * Adds one or more file names to the language which is used to match files that don\'t have extensions like "Makefile" for example.\r\n     * @param {!string|Array.<string>} extension An extensionless file name (or array thereof) used by this language\r\n     */\r\n    Language.prototype.addFileName = function (name) {\r\n        if (Array.isArray(name)) {\r\n            name.forEach(this._addFileName.bind(this));\r\n        } else {\r\n            this._addFileName(name);\r\n        }\r\n    };\r\n    Language.prototype._addFileName = function (name) {\r\n        // Make checks below case-INsensitive\r\n        name = name.toLowerCase();\r\n\r\n        if (this._fileNames.indexOf(name) === -1) {\r\n            this._fileNames.push(name);\r\n\r\n            var language = _fileNameToLanguageMap[name];\r\n            if (language) {\r\n                console.warn("Cannot register file name \\"" + name + "\\" for " + this._name + ", it already belongs to " + language._name);\r\n            } else {\r\n                _fileNameToLanguageMap[name] = this;\r\n            }\r\n\r\n            this._wasModified();\r\n        }\r\n    };\r\n\r\n    /**\r\n     * Unregisters one or more file names from this language.\r\n     * @param {!string|Array.<string>} extension An extensionless file name (or array thereof) used by this language\r\n     */\r\n    Language.prototype.removeFileName = function (name) {\r\n        if (Array.isArray(name)) {\r\n            name.forEach(this._removeFileName.bind(this));\r\n        } else {\r\n            this._removeFileName(name);\r\n        }\r\n    };\r\n    Language.prototype._removeFileName = function (name) {\r\n        // Make checks below case-INsensitive\r\n        name = name.toLowerCase();\r\n\r\n        var index = this._fileNames.indexOf(name);\r\n        if (index !== -1) {\r\n            this._fileNames.splice(index, 1);\r\n\r\n            delete _fileNameToLanguageMap[name];\r\n\r\n            this._wasModified();\r\n        }\r\n    };\r\n\r\n    /**\r\n     * Returns whether the line comment syntax is defined for this language.\r\n     * @return {boolean} Whether line comments are supported\r\n     */\r\n    Language.prototype.hasLineCommentSyntax = function () {\r\n        return this._lineCommentSyntax.length > 0;\r\n    };\r\n\r\n    /**\r\n     * Returns an array of prefixes to use for line comments.\r\n     * @return {Array.<string>} The prefixes\r\n     */\r\n    Language.prototype.getLineCommentPrefixes = function () {\r\n        return this._lineCommentSyntax;\r\n    };\r\n\r\n    /**\r\n     * Sets the prefixes to use for line comments in this language or prints an error to the console.\r\n     * @param {!(string|Array.<string>)} prefix Prefix string or an array of prefix strings\r\n     *   to use for line comments (e.g. "//" or ["//", "#"])\r\n     * @return {boolean} Whether the syntax was valid and set or not\r\n     */\r\n    Language.prototype.setLineCommentSyntax = function (prefix) {\r\n        var prefixes = Array.isArray(prefix) ? prefix : [prefix];\r\n        var i;\r\n\r\n        if (prefixes.length) {\r\n            this._lineCommentSyntax = [];\r\n            for (i = 0; i < prefixes.length; i++) {\r\n                _validateNonEmptyString(String(prefixes[i]), Array.isArray(prefix) ? "prefix[" + i + "]" : "prefix");\r\n\r\n                this._lineCommentSyntax.push(prefixes[i]);\r\n            }\r\n            this._wasModified();\r\n        } else {\r\n            console.error("The prefix array should not be empty");\r\n        }\r\n\r\n        return true;\r\n    };\r\n\r\n    /**\r\n     * Returns whether the block comment syntax is defined for this language.\r\n     * @return {boolean} Whether block comments are supported\r\n     */\r\n    Language.prototype.hasBlockCommentSyntax = function () {\r\n        return Boolean(this._blockCommentSyntax);\r\n    };\r\n\r\n    /**\r\n     * Returns the prefix to use for block comments.\r\n     * @return {string} The prefix\r\n     */\r\n    Language.prototype.getBlockCommentPrefix = function () {\r\n        return this._blockCommentSyntax && this._blockCommentSyntax.prefix;\r\n    };\r\n\r\n    /**\r\n     * Returns the suffix to use for block comments.\r\n     * @return {string} The suffix\r\n     */\r\n    Language.prototype.getBlockCommentSuffix = function () {\r\n        return this._blockCommentSyntax && this._blockCommentSyntax.suffix;\r\n    };\r\n\r\n    /**\r\n     * Sets the prefix and suffix to use for blocks comments in this language or prints an error to the console.\r\n     * @param {!string} prefix Prefix string to use for block comments (e.g. "<!--")\r\n     * @param {!string} suffix Suffix string to use for block comments (e.g. "-->")\r\n     * @return {boolean} Whether the syntax was valid and set or not\r\n     */\r\n    Language.prototype.setBlockCommentSyntax = function (prefix, suffix) {\r\n        if (!_validateNonEmptyString(prefix, "prefix") || !_validateNonEmptyString(suffix, "suffix")) {\r\n            return false;\r\n        }\r\n\r\n        this._blockCommentSyntax = { prefix: prefix, suffix: suffix };\r\n        this._wasModified();\r\n\r\n        return true;\r\n    };\r\n\r\n    /**\r\n     * Returns either a language associated with the mode or the fallback language.\r\n     * Used to disambiguate modes used by multiple languages.\r\n     * @param {!string} mode The mode to associate the language with\r\n     * @return {Language} This language if it uses the mode, or whatever {@link #_getLanguageForMode} returns\r\n     */\r\n    Language.prototype.getLanguageForMode = function (mode) {\r\n        if (mode === this._mode) {\r\n            return this;\r\n        }\r\n        return this._modeToLanguageMap[mode] || _getLanguageForMode(mode);\r\n    };\r\n\r\n    /**\r\n     * Overrides a mode-to-language association for this particular language only or prints an error to the console.\r\n     * Used to disambiguate modes used by multiple languages.\r\n     * @param {!string} mode The mode to associate the language with\r\n     * @param {!Language} language The language to associate with the mode\r\n     * @return {boolean} Whether the mode-to-language association was valid and set or not\r\n     * @private\r\n     */\r\n    Language.prototype._setLanguageForMode = function (mode, language) {\r\n        if (mode === this._mode && language !== this) {\r\n            console.error("A language must always map its mode to itself");\r\n            return false;\r\n        }\r\n\r\n        this._modeToLanguageMap[mode] = language;\r\n        this._wasModified();\r\n\r\n        return true;\r\n    };\r\n\r\n    /**\r\n     * Determines whether this is the fallback language or not\r\n     * @return {boolean} True if this is the fallback language, false otherwise\r\n     */\r\n    Language.prototype.isFallbackLanguage = function () {\r\n        return this === _fallbackLanguage;\r\n    };\r\n\r\n    /**\r\n     * Trigger the "languageModified" event if this language is registered already\r\n     * @see #_triggerLanguageModified\r\n     * @private\r\n     */\r\n    Language.prototype._wasModified = function () {\r\n        if (_languages[this._id]) {\r\n            _triggerLanguageModified(this);\r\n        }\r\n    };\r\n\r\n    /**\r\n     * Indicates whether or not the language is binary (e.g., image or audio).\r\n     * @return {boolean}\r\n     */\r\n    Language.prototype.isBinary = function () {\r\n        return this._isBinary;\r\n    };\r\n\r\n    /**\r\n     * Sets whether or not the language is binary\r\n     * @param {!boolean} isBinary\r\n     */\r\n    Language.prototype._setBinary = function (isBinary) {\r\n        this._isBinary = isBinary;\r\n    };\r\n\r\n    /**\r\n     * Defines a language.\r\n     *\r\n     * @param {!string}               id                        Unique identifier for this language: lowercase letters, digits, and _ separators (e.g. "cpp", "foo_bar", "c99")\r\n     * @param {!Object}               definition                An object describing the language\r\n     * @param {!string}               definition.name           Human-readable name of the language, as it\'s commonly referred to (e.g. "C++")\r\n     * @param {Array.<string>}        definition.fileExtensions List of file extensions used by this language (e.g. ["php", "php3"] or ["coffee.md"] - may contain dots)\r\n     * @param {Array.<string>}        definition.fileNames      List of exact file names (e.g. ["Makefile"] or ["package.json]). Higher precedence than file extension.\r\n     * @param {Array.<string>}        definition.blockComment   Array with two entries defining the block comment prefix and suffix (e.g. ["<!--", "-->"])\r\n     * @param {(string|Array.<string>)} definition.lineComment  Line comment prefixes (e.g. "//" or ["//", "#"])\r\n     * @param {(string|Array.<string>)} definition.mode         CodeMirror mode (e.g. "htmlmixed"), optionally with a MIME mode defined by that mode ["clike", "text/x-c++src"]\r\n     *                                                          Unless the mode is located in thirdparty/CodeMirror/mode/<name>/<name>.js, you need to first load it yourself.\r\n     *\r\n     * @return {$.Promise} A promise object that will be resolved with a Language object\r\n     **/\r\n    function defineLanguage(id, definition) {\r\n        var result = new $.Deferred();\r\n\r\n        if (_pendingLanguages[id]) {\r\n            result.reject("Language \\"" + id + "\\" is waiting to be resolved.");\r\n            return result.promise();\r\n        }\r\n        if (_languages[id]) {\r\n            result.reject("Language \\"" + id + "\\" is already defined");\r\n            return result.promise();\r\n        }\r\n\r\n        var language       = new Language(),\r\n            name           = definition.name,\r\n            fileExtensions = definition.fileExtensions,\r\n            fileNames      = definition.fileNames,\r\n            blockComment   = definition.blockComment,\r\n            lineComment    = definition.lineComment,\r\n            i,\r\n            l;\r\n\r\n        function _finishRegisteringLanguage() {\r\n            if (fileExtensions) {\r\n                for (i = 0, l = fileExtensions.length; i < l; i++) {\r\n                    language.addFileExtension(fileExtensions[i]);\r\n                }\r\n            }\r\n            // register language file names after mode has loaded\r\n            if (fileNames) {\r\n                for (i = 0, l = fileNames.length; i < l; i++) {\r\n                    language.addFileName(fileNames[i]);\r\n                }\r\n            }\r\n\r\n            language._setBinary(!!definition.isBinary);\r\n\r\n            // store language to language map\r\n            _languages[language.getId()] = language;\r\n\r\n            // restore any preferences for non-default languages\r\n            if(PreferencesManager) {\r\n                _updateFromPrefs(_EXTENSION_MAP_PREF);\r\n                _updateFromPrefs(_NAME_MAP_PREF);\r\n            }\r\n        }\r\n\r\n        if (!language._setId(id) || !language._setName(name) ||\r\n                (blockComment && !language.setBlockCommentSyntax(blockComment[0], blockComment[1])) ||\r\n                (lineComment && !language.setLineCommentSyntax(lineComment))) {\r\n            result.reject();\r\n            return result.promise();\r\n        }\r\n\r\n\r\n        if (definition.isBinary) {\r\n            // add file extensions and store language to language map\r\n            _finishRegisteringLanguage();\r\n\r\n            result.resolve(language);\r\n            // Not notifying DocumentManager via event LanguageAdded, because DocumentManager\r\n            // does not care about binary files.\r\n        } else {\r\n            // track languages that are currently loading\r\n            _pendingLanguages[id] = language;\r\n\r\n            language._loadAndSetMode(definition.mode).done(function () {\r\n\r\n                // globally associate mode to language\r\n                _setLanguageForMode(language.getMode(), language);\r\n\r\n                // add file extensions and store language to language map\r\n                _finishRegisteringLanguage();\r\n\r\n                // fire an event to notify DocumentManager of the new language\r\n                _triggerLanguageAdded(language);\r\n\r\n                result.resolve(language);\r\n            }).fail(function (error) {\r\n                console.error(error);\r\n                result.reject(error);\r\n            }).always(function () {\r\n                // delete from pending languages after success and failure\r\n                delete _pendingLanguages[id];\r\n            });\r\n        }\r\n\r\n        return result.promise();\r\n    }\r\n\r\n    /**\r\n     * @private\r\n     *\r\n     * If a default file extension or name was overridden by a pref, restore it.\r\n     *\r\n     * @param {string} name Extension or filename that should be restored\r\n     * @param {{overridden: string, add: string}} prefState object for the pref that is currently being updated\r\n     */\r\n    function _restoreOverriddenDefault(name, state) {\r\n        if (state.overridden[name]) {\r\n            var language = getLanguage(state.overridden[name]);\r\n            language[state.add](name);\r\n            delete state.overridden[name];\r\n        }\r\n    }\r\n\r\n    /**\r\n     * @private\r\n     *\r\n     * Updates extension and filename mappings from languages based on the current preferences values.\r\n     *\r\n     * The preferences look like this in a prefs file:\r\n     *\r\n     * Map *.foo to javascript, *.vm to html\r\n     *\r\n     *     "language.fileExtensions": {\r\n     *         "foo": "javascript",\r\n     *         "vm": "html"\r\n     *     }\r\n     *\r\n     * Map "Gemfile" to ruby:\r\n     *\r\n     *     "language.fileNames": {\r\n     *         "Gemfile": "ruby"\r\n     *     }\r\n     */\r\n    function _updateFromPrefs(pref) {\r\n        var newMapping = PreferencesManager.get(pref),\r\n            newNames = Object.keys(newMapping),\r\n            state = _prefState[pref],\r\n            last = state.last,\r\n            overridden = state.overridden;\r\n\r\n        // Look for added and changed names (extensions or filenames)\r\n        newNames.forEach(function (name) {\r\n            var language;\r\n            if (newMapping[name] !== last[name]) {\r\n                if (last[name]) {\r\n                    language = getLanguage(last[name]);\r\n                    if (language) {\r\n                        language[state.remove](name);\r\n\r\n                        // If this name that was previously mapped was overriding a default\r\n                        // restore it now.\r\n                        _restoreOverriddenDefault(name, state);\r\n                    }\r\n                }\r\n\r\n                language = exports[state.get](name);\r\n                if (language) {\r\n                    language[state.remove](name);\r\n\r\n                    // We\'re removing a name that was defined in Brackets or an extension,\r\n                    // so keep track of how it used to be mapped.\r\n                    if (!overridden[name]) {\r\n                        overridden[name] = language.getId();\r\n                    }\r\n                }\r\n                language = getLanguage(newMapping[name]);\r\n                if (language) {\r\n                    language[state.add](name);\r\n                }\r\n            }\r\n            if(!getLanguage(newMapping[name])) {\r\n                \r\n                // If the language doesn\'t exist, restore any overrides and remove it\r\n                // from the state.\r\n                if(overridden[name]) {\r\n                    _restoreOverriddenDefault(name, state);\r\n                }\r\n                delete newMapping[name];\r\n            }\r\n        });\r\n\r\n        // Look for removed names (extensions or filenames)\r\n        _.difference(Object.keys(last), newNames).forEach(function (name) {\r\n            var language = getLanguage(last[name]);\r\n            if (language) {\r\n                language[state.remove](name);\r\n                _restoreOverriddenDefault(name, state);\r\n            }\r\n        });\r\n        state.last = newMapping;\r\n    }\r\n\r\n\r\n    EventDispatcher.makeEventDispatcher(exports);\r\n\r\n    // Prevent modes from being overwritten by extensions\r\n    _patchCodeMirror();\r\n\r\n    // Define a custom MIME mode here instead of putting it directly into languages.json\r\n    // because JSON files can\'t contain regular expressions. Also, all other modes so\r\n    // far were strings, so we spare us the trouble of allowing more complex mode values.\r\n    CodeMirror.defineMIME("text/x-brackets-html", {\r\n        "name": "htmlmixed",\r\n        "scriptTypes": [\r\n            {\r\n                "matches": /\\/x-handlebars|\\/x-mustache|\\/ng-template$|^text\\/html$/i,\r\n                "mode": "htmlmixed"\r\n            },\r\n            {\r\n                "matches": /^text\\/(babel|jsx)$/i,\r\n                "mode": "jsx"\r\n            }\r\n        ]\r\n    });\r\n\r\n    // Define SVG MIME type so an SVG language can be defined for SVG-specific code hints.\r\n    // Currently, SVG uses XML mode so it has generic XML syntax highlighting. This can\r\n    // be removed when SVG gets its own CodeMirror mode with SVG syntax highlighting.\r\n    CodeMirror.defineMIME("image/svg+xml", "xml");\r\n\r\n    // Load the default languages\r\n    _defaultLanguagesJSON = JSON.parse(_defaultLanguagesJSON);\r\n    _ready = Async.doInParallel(Object.keys(_defaultLanguagesJSON), function (key) {\r\n        return defineLanguage(key, _defaultLanguagesJSON[key]);\r\n    }, false);\r\n\r\n    // Get the object for HTML\r\n    _ready.always(function () {\r\n        var html = getLanguage("html");\r\n\r\n        // The htmlmixed mode uses the xml mode internally for the HTML parts, so we map it to HTML\r\n        html._setLanguageForMode("xml", html);\r\n\r\n        // Currently we override the above mentioned "xml" in TokenUtils.getModeAt, instead returning "html".\r\n        // When the CSSInlineEditor and the hint providers are no longer based on modes, this can be changed.\r\n        // But for now, we need to associate this madeup "html" mode with our HTML language object.\r\n        _setLanguageForMode("html", html);\r\n\r\n        // Similarly, the php mode uses clike internally for the PHP parts\r\n        var php = getLanguage("php");\r\n        php._setLanguageForMode("clike", php);\r\n\r\n        // Similar hack to the above for dealing with SCSS/CSS.\r\n        var scss = getLanguage("scss");\r\n        scss._setLanguageForMode("css", scss);\r\n\r\n        // Map stylus mode to the stylus Brackets language, fixes #13378\r\n        var stylus = getLanguage("stylus");\r\n        _setLanguageForMode("stylus", stylus);\r\n\r\n        // The fallback language for unknown modes and file extensions\r\n        _fallbackLanguage = getLanguage("unknown");\r\n\r\n        // There is a circular dependency between FileUtils and LanguageManager which\r\n        // was introduced in 254b01e2f2eebea4416026d0f40d017b8ca6dbc9\r\n        // and may be preventing us from importing PreferencesManager (which also\r\n        // depends on FileUtils) here. Using the async form of require fixes this.\r\n        require(["preferences/PreferencesManager"], function (pm) {\r\n            PreferencesManager = pm;\r\n            pm.definePreference(_EXTENSION_MAP_PREF, "object", {}, {\r\n                description: Strings.DESCRIPTION_LANGUAGE_FILE_EXTENSIONS\r\n            }).on("change", function () {\r\n                _updateFromPrefs(_EXTENSION_MAP_PREF);\r\n            });\r\n            pm.definePreference(_NAME_MAP_PREF, "object", {}, {\r\n                description: Strings.DESCRIPTION_LANGUAGE_FILE_NAMES\r\n            }).on("change", function () {\r\n                _updateFromPrefs(_NAME_MAP_PREF);\r\n            });\r\n            _updateFromPrefs(_EXTENSION_MAP_PREF);\r\n            _updateFromPrefs(_NAME_MAP_PREF);\r\n        });\r\n    });\r\n\r\n    // Private for unit tests\r\n    exports._EXTENSION_MAP_PREF         = _EXTENSION_MAP_PREF;\r\n    exports._NAME_MAP_PREF              = _NAME_MAP_PREF;\r\n    exports._resetPathLanguageOverrides = _resetPathLanguageOverrides;\r\n\r\n    // Public methods\r\n    exports.ready                       = _ready;\r\n    exports.defineLanguage              = defineLanguage;\r\n    exports.getLanguage                 = getLanguage;\r\n    exports.getLanguageForExtension     = getLanguageForExtension;\r\n    exports.getLanguageForPath          = getLanguageForPath;\r\n    exports.getLanguages                = getLanguages;\r\n    exports.setLanguageOverrideForPath  = setLanguageOverrideForPath;\r\n    exports.getCompoundFileExtension    = getCompoundFileExtension;\r\n});\r\n\n//# sourceURL=/language/LanguageManager.js'),
eval('/*\r\n * Copyright (c) 2013 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\ndefine(\'widgets/DefaultDialogs\',[\'require\',\'exports\',\'module\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    /**\r\n     * List of constants for the default dialogs IDs.\r\n     */\r\n    exports.DIALOG_ID_ERROR             = "error-dialog";\r\n    exports.DIALOG_ID_INFO              = "error-dialog"; // uses the same template for now--could be different in future\r\n    exports.DIALOG_ID_SAVE_CLOSE        = "save-close-dialog";\r\n    exports.DIALOG_ID_EXT_CHANGED       = "ext-changed-dialog";\r\n    exports.DIALOG_ID_EXT_DELETED       = "ext-deleted-dialog";\r\n    exports.DIALOG_ID_LIVE_DEVELOPMENT  = "live-development-error-dialog";\r\n    exports.DIALOG_ID_CHANGE_EXTENSIONS = "change-marked-extensions";\r\n});\r\n\n//# sourceURL=/widgets/DefaultDialogs.js'),eval("/*\r\n * Copyright (c) 2013 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the \"Software\"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\ndefine('filesystem/WatchedRoot',['require','exports','module'],function (require, exports, module) {\r\n    \"use strict\";\r\n\r\n    /*\r\n     * Represents file or directory structure watched by the FileSystem. If the\r\n     * entry is a directory, all children (that pass the supplied filter function)\r\n     * are also watched. A WatchedRoot object begins and ends its life in the\r\n     * INACTIVE state. While in the process of starting up watchers, the WatchedRoot\r\n     * is in the STARTING state. When watchers are ready, the WatchedRoot enters\r\n     * the ACTIVE state.\r\n     *\r\n     * See the FileSystem class for more details.\r\n     *\r\n     * @constructor\r\n     * @param {File|Directory} entry\r\n     * @param {function(string, string):boolean} filter\r\n     * @param {Array<string>} filterGlobs\r\n     */\r\n    function WatchedRoot(entry, filter, filterGlobs) {\r\n        this.entry = entry;\r\n        this.filter = filter;\r\n        this.filterGlobs = filterGlobs;\r\n    }\r\n\r\n    // Status constants\r\n    WatchedRoot.INACTIVE = 0;\r\n    WatchedRoot.STARTING = 1;\r\n    WatchedRoot.ACTIVE = 2;\r\n\r\n    /**\r\n     * @type {File|Directory}\r\n     */\r\n    WatchedRoot.prototype.entry = null;\r\n\r\n    /**\r\n     * @type {function(string, string):boolean}\r\n     */\r\n    WatchedRoot.prototype.filter = null;\r\n\r\n    /**\r\n     * @type {Array<string>}\r\n     */\r\n    WatchedRoot.prototype.filterGlobs = null;\r\n\r\n    /**\r\n     * @type {number}\r\n     */\r\n    WatchedRoot.prototype.status = WatchedRoot.INACTIVE;\r\n\r\n\r\n    // Export this class\r\n    module.exports = WatchedRoot;\r\n});\r\n\n//# sourceURL=/filesystem/WatchedRoot.js"),eval('/*\r\n * Copyright (c) 2013 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\n/*\r\n * To ensure cache coherence, current and future asynchronous state-changing\r\n * operations of FileSystemEntry and its subclasses should implement the\r\n * following high-level sequence of steps:\r\n *\r\n * 1. Block external filesystem change events;\r\n * 2. Execute the low-level state-changing operation;\r\n * 3. Update the internal filesystem state, including caches;\r\n * 4. Apply the callback;\r\n * 5. Fire an appropriate internal change notification; and\r\n * 6. Unblock external change events.\r\n *\r\n * Note that because internal filesystem state is updated first, both the original\r\n * caller and the change notification listeners observe filesystem state that is\r\n * current w.r.t. the operation. Furthermore, because external change events are\r\n * blocked before the operation begins, listeners will only receive the internal\r\n * change event for the operation and not additional (or possibly inconsistent)\r\n * external change events.\r\n *\r\n * State-changing operations that block external filesystem change events must\r\n * take care to always subsequently unblock the external change events in all\r\n * control paths. It is safe to assume, however, that the underlying impl will\r\n * always apply the callback with some value.\r\n\r\n * Caches should be conservative. Consequently, the entry\'s cached data should\r\n * always be cleared if the underlying impl\'s operation fails. This is the case\r\n * event for read-only operations because an unexpected failure implies that the\r\n * system is in an unknown state. The entry should communicate this by failing\r\n * where appropriate, and should not use the cache to hide failure.\r\n *\r\n * Only watched entries should make use of cached data because change events are\r\n * only expected for such entries, and change events are used to granularly\r\n * invalidate out-of-date caches.\r\n *\r\n * By convention, callbacks are optional for asynchronous, state-changing\r\n * operations, but required for read-only operations. The first argument to the\r\n * callback should always be a nullable error string from FileSystemError.\r\n */\r\ndefine(\'filesystem/FileSystemEntry\',[\'require\',\'exports\',\'module\',\'filesystem/FileSystemError\',\'filesystem/WatchedRoot\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    var FileSystemError = require("filesystem/FileSystemError"),\r\n        WatchedRoot     = require("filesystem/WatchedRoot");\r\n\r\n    var VISIT_DEFAULT_MAX_DEPTH = 100,\r\n        VISIT_DEFAULT_MAX_ENTRIES = 30000;\r\n\r\n    /* Counter to give every entry a unique id */\r\n    var nextId = 0;\r\n\r\n    /**\r\n     * Model for a file system entry. This is the base class for File and Directory,\r\n     * and is never used directly.\r\n     *\r\n     * See the File, Directory, and FileSystem classes for more details.\r\n     *\r\n     * @constructor\r\n     * @param {string} path The path for this entry.\r\n     * @param {FileSystem} fileSystem The file system associated with this entry.\r\n     */\r\n    function FileSystemEntry(path, fileSystem) {\r\n        this._setPath(path);\r\n        this._fileSystem = fileSystem;\r\n        this._id = nextId++;\r\n    }\r\n\r\n    // Add "fullPath", "name", "parent", "id", "isFile" and "isDirectory" getters\r\n    Object.defineProperties(FileSystemEntry.prototype, {\r\n        "fullPath": {\r\n            get: function () { return this._path; },\r\n            set: function () { throw new Error("Cannot set fullPath"); }\r\n        },\r\n        "name": {\r\n            get: function () { return this._name; },\r\n            set: function () { throw new Error("Cannot set name"); }\r\n        },\r\n        "parentPath": {\r\n            get: function () { return this._parentPath; },\r\n            set: function () { throw new Error("Cannot set parentPath"); }\r\n        },\r\n        "id": {\r\n            get: function () { return this._id; },\r\n            set: function () { throw new Error("Cannot set id"); }\r\n        },\r\n        "isFile": {\r\n            get: function () { return this._isFile; },\r\n            set: function () { throw new Error("Cannot set isFile"); }\r\n        },\r\n        "isDirectory": {\r\n            get: function () { return this._isDirectory; },\r\n            set: function () { throw new Error("Cannot set isDirectory"); }\r\n        },\r\n        "_impl": {\r\n            get: function () { return this._fileSystem._impl; },\r\n            set: function () { throw new Error("Cannot set _impl"); }\r\n        }\r\n    });\r\n\r\n    /**\r\n     * Cached stat object for this file.\r\n     * @type {?FileSystemStats}\r\n     */\r\n    FileSystemEntry.prototype._stat = null;\r\n\r\n    /**\r\n     * Parent file system.\r\n     * @type {!FileSystem}\r\n     */\r\n    FileSystemEntry.prototype._fileSystem = null;\r\n\r\n    /**\r\n     * The path of this entry.\r\n     * @type {string}\r\n     */\r\n    FileSystemEntry.prototype._path = null;\r\n\r\n    /**\r\n     * The name of this entry.\r\n     * @type {string}\r\n     */\r\n    FileSystemEntry.prototype._name = null;\r\n\r\n    /**\r\n     * The parent of this entry.\r\n     * @type {string}\r\n     */\r\n    FileSystemEntry.prototype._parentPath = null;\r\n\r\n    /**\r\n     * Whether or not the entry is a file\r\n     * @type {boolean}\r\n     */\r\n    FileSystemEntry.prototype._isFile = false;\r\n\r\n    /**\r\n     * Whether or not the entry is a directory\r\n     * @type {boolean}\r\n     */\r\n    FileSystemEntry.prototype._isDirectory = false;\r\n\r\n    /**\r\n     * Cached copy of this entry\'s watched root\r\n     * @type {entry: File|Directory, filter: function(FileSystemEntry):boolean, active: boolean}\r\n     */\r\n    FileSystemEntry.prototype._watchedRoot = undefined;\r\n\r\n    /**\r\n     * Cached result of _watchedRoot.filter(this.name, this.parentPath).\r\n     * @type {boolean}\r\n     */\r\n    FileSystemEntry.prototype._watchedRootFilterResult = undefined;\r\n\r\n    /**\r\n     * Determines whether or not the entry is watched.\r\n     * @param {boolean=} relaxed If falsey, the method will only return true if\r\n     *      the watched root is fully active. If true, the method will return\r\n     *      true if the watched root is either starting up or fully active.\r\n     * @return {boolean}\r\n     */\r\n    FileSystemEntry.prototype._isWatched = function (relaxed) {\r\n        var watchedRoot = this._watchedRoot,\r\n            filterResult = this._watchedRootFilterResult;\r\n\r\n        if (!watchedRoot) {\r\n            watchedRoot = this._fileSystem._findWatchedRootForPath(this._path);\r\n\r\n            if (watchedRoot) {\r\n                this._watchedRoot = watchedRoot;\r\n                if (watchedRoot.entry !== this) { // avoid creating entries for root\'s parent\r\n                    var parentEntry = this._fileSystem.getDirectoryForPath(this._parentPath);\r\n                    if (parentEntry._isWatched() === false) {\r\n                        filterResult = false;\r\n                    } else {\r\n                        filterResult = watchedRoot.filter(this._name, this._parentPath);\r\n                    }\r\n                } else { // root itself is watched\r\n                    filterResult = true;\r\n                }\r\n                this._watchedRootFilterResult = filterResult;\r\n            }\r\n        }\r\n\r\n        if (watchedRoot) {\r\n            if (watchedRoot.status === WatchedRoot.ACTIVE ||\r\n                    (relaxed && watchedRoot.status === WatchedRoot.STARTING)) {\r\n                return filterResult;\r\n            } else {\r\n                // We had a watched root, but it\'s no longer active, so it must now be invalid.\r\n                this._watchedRoot = undefined;\r\n                this._watchedRootFilterResult = false;\r\n                this._clearCachedData();\r\n            }\r\n        }\r\n        return false;\r\n    };\r\n\r\n    /**\r\n     * Update the path for this entry\r\n     * @private\r\n     * @param {String} newPath\r\n     */\r\n    FileSystemEntry.prototype._setPath = function (newPath) {\r\n        var parts = newPath.split("/");\r\n        if (this.isDirectory) {\r\n            parts.pop(); // Remove the empty string after last trailing "/"\r\n        }\r\n        this._name = parts[parts.length - 1];\r\n        parts.pop(); // Remove name\r\n\r\n        if (parts.length > 0) {\r\n            this._parentPath = parts.join("/") + "/";\r\n        } else {\r\n            // root directories have no parent path\r\n            this._parentPath = null;\r\n        }\r\n\r\n        this._path = newPath;\r\n\r\n        var watchedRoot = this._watchedRoot;\r\n        if (watchedRoot) {\r\n            if (newPath.indexOf(watchedRoot.entry.fullPath) === 0) {\r\n                // Update watchedRootFilterResult\r\n                this._watchedRootFilterResult = watchedRoot.filter(this._name, this._parentPath);\r\n            } else {\r\n                // The entry was moved outside of the watched root\r\n                this._watchedRoot = null;\r\n                this._watchedRootFilterResult = false;\r\n            }\r\n        }\r\n    };\r\n\r\n    /**\r\n     * Clear any cached data for this entry\r\n     * @private\r\n     */\r\n    FileSystemEntry.prototype._clearCachedData = function () {\r\n        this._stat = undefined;\r\n    };\r\n\r\n    /**\r\n     * Helpful toString for debugging purposes\r\n     */\r\n    FileSystemEntry.prototype.toString = function () {\r\n        return "[" + (this.isDirectory ? "Directory " : "File ") + this._path + "]";\r\n    };\r\n\r\n    /**\r\n     * Check to see if the entry exists on disk. Note that there will NOT be an\r\n     * error returned if the file does not exist on the disk; in that case the\r\n     * error parameter will be null and the boolean will be false. The error\r\n     * parameter will only be truthy when an unexpected error was encountered\r\n     * during the test, in which case the state of the entry should be considered\r\n     * unknown.\r\n     *\r\n     * @param {function (?string, boolean)} callback Callback with a FileSystemError\r\n     *      string or a boolean indicating whether or not the file exists.\r\n     */\r\n    FileSystemEntry.prototype.exists = function (callback) {\r\n        if (this._stat) {\r\n            callback(null, true);\r\n            return;\r\n        }\r\n\r\n        this._impl.exists(this._path, function (err, exists) {\r\n            if (err) {\r\n                this._clearCachedData();\r\n                callback(err);\r\n                return;\r\n            }\r\n\r\n            if (!exists) {\r\n                this._clearCachedData();\r\n            }\r\n\r\n            callback(null, exists);\r\n        }.bind(this));\r\n    };\r\n\r\n    /**\r\n     * Returns the stats for the entry.\r\n     *\r\n     * @param {function (?string, FileSystemStats=)} callback Callback with a\r\n     *      FileSystemError string or FileSystemStats object.\r\n     */\r\n    FileSystemEntry.prototype.stat = function (callback) {\r\n        if (this._stat) {\r\n            callback(null, this._stat);\r\n            return;\r\n        }\r\n\r\n        this._impl.stat(this._path, function (err, stat) {\r\n            if (err) {\r\n                this._clearCachedData();\r\n                callback(err);\r\n                return;\r\n            }\r\n\r\n            if (this._isWatched()) {\r\n                this._stat = stat;\r\n            }\r\n\r\n            callback(null, stat);\r\n        }.bind(this));\r\n    };\r\n\r\n    /**\r\n     * Rename this entry.\r\n     *\r\n     * @param {string} newFullPath New path & name for this entry.\r\n     * @param {function (?string)=} callback Callback with a single FileSystemError\r\n     *      string parameter.\r\n     */\r\n    FileSystemEntry.prototype.rename = function (newFullPath, callback) {\r\n        callback = callback || function () {};\r\n\r\n        // Block external change events until after the write has finished\r\n        this._fileSystem._beginChange();\r\n\r\n        this._impl.rename(this._path, newFullPath, function (err) {\r\n            var oldFullPath = this._path;\r\n\r\n            try {\r\n                if (err) {\r\n                    this._clearCachedData();\r\n                    callback(err);\r\n                    return;\r\n                }\r\n\r\n                // Update internal filesystem state\r\n                this._fileSystem._handleRename(this._path, newFullPath, this.isDirectory);\r\n\r\n                try {\r\n                    // Notify the caller\r\n                    callback(null);\r\n                } finally {\r\n                    // Notify rename listeners\r\n                    this._fileSystem._fireRenameEvent(oldFullPath, newFullPath);\r\n                }\r\n            } finally {\r\n                // Unblock external change events\r\n                this._fileSystem._endChange();\r\n            }\r\n        }.bind(this));\r\n    };\r\n\r\n    /**\r\n     * Permanently delete this entry. For Directories, this will delete the directory\r\n     * and all of its contents. For reversible delete, see moveToTrash().\r\n     *\r\n     * @param {function (?string)=} callback Callback with a single FileSystemError\r\n     *      string parameter.\r\n     */\r\n    FileSystemEntry.prototype.unlink = function (callback) {\r\n        callback = callback || function () {};\r\n\r\n        // Block external change events until after the write has finished\r\n        this._fileSystem._beginChange();\r\n\r\n        this._clearCachedData();\r\n        this._impl.unlink(this._path, function (err) {\r\n            var parent = this._fileSystem.getDirectoryForPath(this.parentPath);\r\n\r\n            // Update internal filesystem state\r\n            this._fileSystem._handleDirectoryChange(parent, function (added, removed) {\r\n                try {\r\n                    // Notify the caller\r\n                    callback(err);\r\n                } finally {\r\n                    if (parent._isWatched()) {\r\n                        // Notify change listeners\r\n                        this._fileSystem._fireChangeEvent(parent, added, removed);\r\n                    }\r\n\r\n                    // Unblock external change events\r\n                    this._fileSystem._endChange();\r\n                }\r\n            }.bind(this));\r\n        }.bind(this));\r\n    };\r\n\r\n    /**\r\n     * Move this entry to the trash. If the underlying file system doesn\'t support move\r\n     * to trash, the item is permanently deleted.\r\n     *\r\n     * @param {function (?string)=} callback Callback with a single FileSystemError\r\n     *      string parameter.\r\n     */\r\n    FileSystemEntry.prototype.moveToTrash = function (callback) {\r\n        if (!this._impl.moveToTrash) {\r\n            this.unlink(callback);\r\n            return;\r\n        }\r\n\r\n        callback = callback || function () {};\r\n\r\n        // Block external change events until after the write has finished\r\n        this._fileSystem._beginChange();\r\n\r\n        this._clearCachedData();\r\n        this._impl.moveToTrash(this._path, function (err) {\r\n            var parent = this._fileSystem.getDirectoryForPath(this.parentPath);\r\n\r\n            // Update internal filesystem state\r\n            this._fileSystem._handleDirectoryChange(parent, function (added, removed) {\r\n                try {\r\n                    // Notify the caller\r\n                    callback(err);\r\n                } finally {\r\n                    if (parent._isWatched()) {\r\n                        // Notify change listeners\r\n                        this._fileSystem._fireChangeEvent(parent, added, removed);\r\n                    }\r\n\r\n                    // Unblock external change events\r\n                    this._fileSystem._endChange();\r\n                }\r\n            }.bind(this));\r\n        }.bind(this));\r\n    };\r\n\r\n    /**\r\n     * Private helper function for FileSystemEntry.visit that requires sanitized options.\r\n     *\r\n     * @private\r\n     * @param {FileSystemStats} stats - the stats for this entry\r\n     * @param {{string: boolean}} visitedPaths - the set of fullPaths that have already been visited\r\n     * @param {function(FileSystemEntry): boolean} visitor - A visitor function, which is\r\n     *      applied to descendent FileSystemEntry objects. If the function returns false for\r\n     *      a particular Directory entry, that directory\'s descendents will not be visited.\r\n     * @param {{maxDepth: number, maxEntriesCounter: {value: number}, sortList: boolean}} options\r\n     * @param {function(?string)=} callback Callback with single FileSystemError string parameter.\r\n     */\r\n    FileSystemEntry.prototype._visitHelper = function (stats, visitedPaths, visitor, options, callback) {\r\n        var maxDepth = options.maxDepth,\r\n            maxEntriesCounter = options.maxEntriesCounter,\r\n            sortList = options.sortList;\r\n\r\n        if (maxEntriesCounter.value-- <= 0 || maxDepth-- < 0) {\r\n            // The outer FileSystemEntry.visit call is responsible for applying\r\n            // the main callback to FileSystemError.TOO_MANY_FILES in this case\r\n            callback(null);\r\n            return;\r\n        }\r\n\r\n        if (this.isDirectory) {\r\n            var visitedPath = stats.realPath || this.fullPath;\r\n\r\n            if (visitedPaths.hasOwnProperty(visitedPath)) {\r\n                // Link cycle detected\r\n                callback(null);\r\n                return;\r\n            }\r\n\r\n            visitedPaths[visitedPath] = true;\r\n        }\r\n\r\n        if (!visitor(this) || this.isFile) {\r\n            callback(null);\r\n            return;\r\n        }\r\n\r\n        this.getContents(function (err, entries, entriesStats) {\r\n            if (err) {\r\n                callback(err);\r\n                return;\r\n            }\r\n\r\n            var counter = entries.length;\r\n            if (counter === 0) {\r\n                callback(null);\r\n                return;\r\n            }\r\n\r\n            function helperCallback(err) {\r\n                if (--counter === 0) {\r\n                    callback(null);\r\n                }\r\n            }\r\n\r\n            var nextOptions = {\r\n                maxDepth: maxDepth,\r\n                maxEntriesCounter: maxEntriesCounter,\r\n                sortList : sortList\r\n            };\r\n\r\n            //sort entries if required\r\n            function compareFilesWithIndices(index1, index2) {\r\n                return entries[index1]._name.toLocaleLowerCase().localeCompare(entries[index2]._name.toLocaleLowerCase());\r\n            }\r\n            if (sortList) {\r\n                var fileIndexes = [], i = 0;\r\n                for (i = 0; i < entries.length; i++) {\r\n                    fileIndexes[i] = i;\r\n                }\r\n                fileIndexes.sort(compareFilesWithIndices);\r\n                fileIndexes.forEach(function (fileIndex) {\r\n                    var stats = entriesStats[fileIndexes[fileIndex]];\r\n                    entries[fileIndexes[fileIndex]]._visitHelper(stats, visitedPaths, visitor, nextOptions, helperCallback);\r\n                });\r\n            } else {\r\n                entries.forEach(function (entry, index) {\r\n                    var stats = entriesStats[index];\r\n                    entry._visitHelper(stats, visitedPaths, visitor, nextOptions, helperCallback);\r\n                });\r\n            }\r\n        }.bind(this));\r\n    };\r\n\r\n    /**\r\n     * Visit this entry and its descendents with the supplied visitor function.\r\n     * Correctly handles symbolic link cycles and options can be provided to limit\r\n     * search depth and total number of entries visited. No particular traversal\r\n     * order is guaranteed; instead of relying on such an order, it is preferable\r\n     * to use the visit function to build a list of visited entries, sort those\r\n     * entries as desired, and then process them. Whenever possible, deep\r\n     * filesystem traversals should use this method.\r\n     *\r\n     * @param {function(FileSystemEntry): boolean} visitor - A visitor function, which is\r\n     *      applied to this entry and all descendent FileSystemEntry objects. If the function returns\r\n     *      false for a particular Directory entry, that directory\'s descendents will not be visited.\r\n     * @param {{maxDepth: number=, maxEntries: number=}=} options\r\n     * @param {function(?string)=} callback Callback with single FileSystemError string parameter.\r\n     */\r\n    FileSystemEntry.prototype.visit = function (visitor, options, callback) {\r\n        if (typeof options === "function") {\r\n            callback = options;\r\n            options = {};\r\n        } else {\r\n            if (options === undefined) {\r\n                options = {};\r\n            }\r\n\r\n            callback = callback || function () {};\r\n        }\r\n\r\n        if (options.maxDepth === undefined) {\r\n            options.maxDepth = VISIT_DEFAULT_MAX_DEPTH;\r\n        }\r\n\r\n        if (options.maxEntries === undefined) {\r\n            options.maxEntries = VISIT_DEFAULT_MAX_ENTRIES;\r\n        }\r\n\r\n        options.maxEntriesCounter = { value: options.maxEntries };\r\n\r\n        this.stat(function (err, stats) {\r\n            if (err) {\r\n                callback(err);\r\n                return;\r\n            }\r\n\r\n            this._visitHelper(stats, {}, visitor, options, function (err) {\r\n                if (callback) {\r\n                    if (err) {\r\n                        callback(err);\r\n                        return;\r\n                    }\r\n\r\n                    if (options.maxEntriesCounter.value < 0) {\r\n                        callback(FileSystemError.TOO_MANY_ENTRIES);\r\n                        return;\r\n                    }\r\n\r\n                    callback(null);\r\n                }\r\n            }.bind(this));\r\n        }.bind(this));\r\n    };\r\n\r\n    // Export this class\r\n    module.exports = FileSystemEntry;\r\n});\r\n\n//# sourceURL=/filesystem/FileSystemEntry.js'),eval('/*\r\n * Copyright (c) 2013 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\ndefine(\'filesystem/Directory\',[\'require\',\'exports\',\'module\',\'filesystem/FileSystemEntry\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    var FileSystemEntry = require("filesystem/FileSystemEntry");\r\n\r\n    /*\r\n     * Model for a file system Directory.\r\n     *\r\n     * This class should *not* be instantiated directly. Use FileSystem.getDirectoryForPath,\r\n     * FileSystem.resolve, or Directory.getContents to create an instance of this class.\r\n     *\r\n     * Note: Directory.fullPath always has a trailing slash.\r\n     *\r\n     * See the FileSystem class for more details.\r\n     *\r\n     * @constructor\r\n     * @param {!string} fullPath The full path for this Directory.\r\n     * @param {!FileSystem} fileSystem The file system associated with this Directory.\r\n     */\r\n    function Directory(fullPath, fileSystem) {\r\n        this._isDirectory = true;\r\n        FileSystemEntry.call(this, fullPath, fileSystem);\r\n    }\r\n\r\n    Directory.prototype = Object.create(FileSystemEntry.prototype);\r\n    Directory.prototype.constructor = Directory;\r\n    Directory.prototype.parentClass = FileSystemEntry.prototype;\r\n\r\n    /**\r\n     * The contents of this directory. This "private" property is used by FileSystem.\r\n     * @type {Array<FileSystemEntry>}\r\n     */\r\n    Directory.prototype._contents = null;\r\n\r\n    /**\r\n     * The stats for the contents of this directory, such that this._contentsStats[i]\r\n     * corresponds to this._contents[i].\r\n     * @type {Array.<FileSystemStats>}\r\n     */\r\n    Directory.prototype._contentsStats = null;\r\n\r\n    /**\r\n     * The stats errors for the contents of this directory.\r\n     * @type {object.<string: string>} fullPaths are mapped to FileSystemError strings\r\n     */\r\n    Directory.prototype._contentsStatsErrors = null;\r\n\r\n    /**\r\n     * Clear any cached data for this directory. By default, we clear the contents\r\n     * of immediate children as well, because in some cases file watchers fail\r\n     * provide precise change notifications. (Sometimes, like after a "git\r\n     * checkout", they just report that some directory has changed when in fact\r\n     * many of the file within the directory have changed.\r\n     *\r\n     * @private\r\n     * @param {boolean=} preserveImmediateChildren\r\n     */\r\n    Directory.prototype._clearCachedData = function (preserveImmediateChildren) {\r\n        FileSystemEntry.prototype._clearCachedData.apply(this);\r\n\r\n        if (!preserveImmediateChildren) {\r\n            if (this._contents) {\r\n                this._contents.forEach(function (child) {\r\n                    child._clearCachedData(true);\r\n                });\r\n            } else {\r\n                // No cached _contents, but child entries may still exist.\r\n                // Scan the full index to catch all of them.\r\n                var dirPath = this.fullPath;\r\n                this._fileSystem._index.visitAll(function (entry) {\r\n                    if (entry.parentPath === dirPath) {\r\n                        entry._clearCachedData(true);\r\n                    }\r\n                });\r\n            }\r\n        }\r\n\r\n        this._contents = undefined;\r\n        this._contentsStats = undefined;\r\n        this._contentsStatsErrors = undefined;\r\n    };\r\n\r\n    /**\r\n     * Apply each callback in a list to the provided arguments. Callbacks\r\n     * can throw without preventing other callbacks from being applied.\r\n     *\r\n     * @private\r\n     * @param {Array.<function>} callbacks The callbacks to apply\r\n     * @param {Array} args The arguments to which each callback is applied\r\n     */\r\n    function _applyAllCallbacks(callbacks, args) {\r\n        if (callbacks.length > 0) {\r\n            var callback = callbacks.pop();\r\n            try {\r\n                callback.apply(undefined, args);\r\n            } finally {\r\n                _applyAllCallbacks(callbacks, args);\r\n            }\r\n        }\r\n    }\r\n\r\n    /**\r\n     * Read the contents of a Directory. If this Directory is under a watch root,\r\n     * the listing will exclude any items filtered out by the watch root\'s filter\r\n     * function.\r\n     *\r\n     * @param {Directory} directory Directory whose contents you want to get\r\n     * @param {function (?string, Array.<FileSystemEntry>=, Array.<FileSystemStats>=, Object.<string, string>=)} callback\r\n     *          Callback that is passed an error code or the stat-able contents\r\n     *          of the directory along with the stats for these entries and a\r\n     *          fullPath-to-FileSystemError string map of unstat-able entries\r\n     *          and their stat errors. If there are no stat errors then the last\r\n     *          parameter shall remain undefined.\r\n     */\r\n    Directory.prototype.getContents = function (callback) {\r\n        if (this._contentsCallbacks) {\r\n            // There is already a pending call for this directory\'s contents.\r\n            // Push the new callback onto the stack and return.\r\n            this._contentsCallbacks.push(callback);\r\n            return;\r\n        }\r\n\r\n        // Return cached contents if the directory is watched\r\n        if (this._contents) {\r\n            callback(null, this._contents, this._contentsStats, this._contentsStatsErrors);\r\n            return;\r\n        }\r\n\r\n        this._contentsCallbacks = [callback];\r\n\r\n        this._impl.readdir(this.fullPath, function (err, names, stats) {\r\n            var contents = [],\r\n                contentsStats = [],\r\n                contentsStatsErrors;\r\n\r\n            if (err) {\r\n                this._clearCachedData();\r\n            } else {\r\n                // Use the "relaxed" parameter to _isWatched because it\'s OK to\r\n                // cache data even while watchers are still starting up\r\n                var watched = this._isWatched(true);\r\n\r\n                names.forEach(function (name, index) {\r\n                    var entryPath = this.fullPath + name;\r\n\r\n                    var entryStats = stats[index];\r\n                    if (this._fileSystem._indexFilter(entryPath, name, entryStats)) {\r\n                        var entry;\r\n\r\n                        // Note: not all entries necessarily have associated stats.\r\n                        if (typeof entryStats === "string") {\r\n                            // entryStats is an error string\r\n                            if (contentsStatsErrors === undefined) {\r\n                                contentsStatsErrors = {};\r\n                            }\r\n                            contentsStatsErrors[entryPath] = entryStats;\r\n                        } else {\r\n                            // entryStats is a FileSystemStats object\r\n                            if (entryStats.isFile) {\r\n                                entry = this._fileSystem.getFileForPath(entryPath);\r\n                            } else {\r\n                                entry = this._fileSystem.getDirectoryForPath(entryPath);\r\n                            }\r\n\r\n                            if (watched) {\r\n                                entry._stat = entryStats;\r\n                            }\r\n\r\n                            contents.push(entry);\r\n                            contentsStats.push(entryStats);\r\n                        }\r\n                    }\r\n                }, this);\r\n\r\n                if (watched) {\r\n                    this._contents = contents;\r\n                    this._contentsStats = contentsStats;\r\n                    this._contentsStatsErrors = contentsStatsErrors;\r\n                }\r\n            }\r\n\r\n            // Reset the callback list before we begin calling back so that\r\n            // synchronous reentrant calls are handled correctly.\r\n            var currentCallbacks = this._contentsCallbacks;\r\n\r\n            this._contentsCallbacks = null;\r\n\r\n            // Invoke all saved callbacks\r\n            var callbackArgs = [err, contents, contentsStats, contentsStatsErrors];\r\n            _applyAllCallbacks(currentCallbacks, callbackArgs);\r\n        }.bind(this));\r\n    };\r\n\r\n    /**\r\n     * Create a directory\r\n     *\r\n     * @param {function (?string, FileSystemStats=)=} callback Callback resolved with a\r\n     *      FileSystemError string or the stat object for the created directory.\r\n     */\r\n    Directory.prototype.create = function (callback) {\r\n        callback = callback || function () {};\r\n\r\n        // Block external change events until after the write has finished\r\n        this._fileSystem._beginChange();\r\n\r\n        this._impl.mkdir(this._path, function (err, stat) {\r\n            if (err) {\r\n                this._clearCachedData();\r\n                try {\r\n                    callback(err);\r\n                    return;\r\n                } finally {\r\n                    // Unblock external change events\r\n                    this._fileSystem._endChange();\r\n                }\r\n            }\r\n\r\n            var parent = this._fileSystem.getDirectoryForPath(this.parentPath);\r\n\r\n            // Update internal filesystem state\r\n            if (this._isWatched()) {\r\n                this._stat = stat;\r\n            }\r\n\r\n            this._fileSystem._handleDirectoryChange(parent, function (added, removed) {\r\n                try {\r\n                    callback(null, stat);\r\n                } finally {\r\n                    if (parent._isWatched()) {\r\n                        this._fileSystem._fireChangeEvent(parent, added, removed);\r\n                    }\r\n                    // Unblock external change events\r\n                    this._fileSystem._endChange();\r\n                }\r\n            }.bind(this));\r\n        }.bind(this));\r\n    };\r\n\r\n    // Export this class\r\n    module.exports = Directory;\r\n});\r\n\n//# sourceURL=/filesystem/Directory.js'),
eval('/*\r\n * Copyright (c) 2013 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\ndefine(\'filesystem/File\',[\'require\',\'exports\',\'module\',\'filesystem/FileSystemEntry\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    var FileSystemEntry = require("filesystem/FileSystemEntry");\r\n\r\n\r\n    /*\r\n     * Model for a File.\r\n     *\r\n     * This class should *not* be instantiated directly. Use FileSystem.getFileForPath,\r\n     * FileSystem.resolve, or Directory.getContents to create an instance of this class.\r\n     *\r\n     * See the FileSystem class for more details.\r\n     *\r\n     * @constructor\r\n     * @param {!string} fullPath The full path for this File.\r\n     * @param {!FileSystem} fileSystem The file system associated with this File.\r\n     */\r\n    function File(fullPath, fileSystem) {\r\n        this._isFile = true;\r\n        FileSystemEntry.call(this, fullPath, fileSystem);\r\n    }\r\n\r\n    File.prototype = Object.create(FileSystemEntry.prototype);\r\n    File.prototype.constructor = File;\r\n    File.prototype.parentClass = FileSystemEntry.prototype;\r\n\r\n    /**\r\n     * Cached contents of this file. This value is nullable but should NOT be undefined.\r\n     * @private\r\n     * @type {?string}\r\n     */\r\n    File.prototype._contents = null;\r\n    \r\n    \r\n    /**\r\n     * Encoding detected by brackets-shell\r\n     * @private\r\n     * @type {?string}\r\n     */\r\n    File.prototype._encoding = null;\r\n\r\n    /**\r\n     * BOM detected by brackets-shell\r\n     * @private\r\n     * @type {?bool}\r\n     */\r\n    File.prototype._preserveBOM = false;\r\n\r\n    /**\r\n     * Consistency hash for this file. Reads and writes update this value, and\r\n     * writes confirm the hash before overwriting existing files. The type of\r\n     * this object is dependent on the FileSystemImpl; the only constraint is\r\n     * that === can be used as an equality relation on hashes.\r\n     * @private\r\n     * @type {?object}\r\n     */\r\n    File.prototype._hash = null;\r\n\r\n    /**\r\n     * Clear any cached data for this file. Note that this explicitly does NOT\r\n     * clear the file\'s hash.\r\n     * @private\r\n     */\r\n    File.prototype._clearCachedData = function () {\r\n        FileSystemEntry.prototype._clearCachedData.apply(this);\r\n        this._contents = null;\r\n    };\r\n\r\n    /**\r\n     * Read a file.\r\n     *\r\n     * @param {Object=} options Currently unused.\r\n     * @param {function (?string, string=, FileSystemStats=)} callback Callback that is passed the\r\n     *              FileSystemError string or the file\'s contents and its stats.\r\n     */\r\n    File.prototype.read = function (options, callback) {\r\n        if (typeof (options) === "function") {\r\n            callback = options;\r\n            options = {};\r\n            options.encoding = this._encoding;\r\n        }\r\n        options.encoding = this._encoding || "utf8";\r\n\r\n        // We don\'t need to check isWatched() here because contents are only saved\r\n        // for watched files. Note that we need to explicitly test this._contents\r\n        // for a default value; otherwise it could be the empty string, which is\r\n        // falsey.\r\n        if (this._contents !== null && this._stat) {\r\n            callback(null, this._contents, this._encoding, this._stat);\r\n            return;\r\n        }\r\n\r\n        var watched = this._isWatched();\r\n        if (watched) {\r\n            options.stat = this._stat;\r\n        }\r\n\r\n        this._impl.readFile(this._path, options, function (err, data, encoding, preserveBOM, stat) {\r\n            if (err) {\r\n                this._clearCachedData();\r\n                callback(err);\r\n                return;\r\n            }\r\n\r\n            // Always store the hash\r\n            this._hash = stat._hash;\r\n            this._encoding = encoding;\r\n            this._preserveBOM = preserveBOM;\r\n\r\n            // Only cache data for watched files\r\n            if (watched) {\r\n                this._stat = stat;\r\n                this._contents = data;\r\n            }\r\n\r\n            callback(err, data, encoding, stat);\r\n        }.bind(this));\r\n    };\r\n\r\n    /**\r\n     * Write a file.\r\n     *\r\n     * @param {string} data Data to write.\r\n     * @param {object=} options Currently unused.\r\n     * @param {function (?string, FileSystemStats=)=} callback Callback that is passed the\r\n     *              FileSystemError string or the file\'s new stats.\r\n     */\r\n    File.prototype.write = function (data, options, callback) {\r\n        if (typeof options === "function") {\r\n            callback = options;\r\n            options = {};\r\n        } else {\r\n            if (options === undefined) {\r\n                options = {};\r\n            }\r\n\r\n            callback = callback || function () {};\r\n        }\r\n\r\n        // Request a consistency check if the write is not blind\r\n        if (!options.blind) {\r\n            options.expectedHash = this._hash;\r\n            options.expectedContents = this._contents;\r\n        }\r\n        if (!options.encoding) {\r\n            options.encoding = this._encoding || "utf8";\r\n        }\r\n        options.preserveBOM = this._preserveBOM;\r\n\r\n        // Block external change events until after the write has finished\r\n        this._fileSystem._beginChange();\r\n\r\n        this._impl.writeFile(this._path, data, options, function (err, stat, created) {\r\n            if (err) {\r\n                this._clearCachedData();\r\n                try {\r\n                    callback(err);\r\n                    return;\r\n                } finally {\r\n                    // Always unblock external change events\r\n                    this._fileSystem._endChange();\r\n                }\r\n            }\r\n\r\n            // Always store the hash\r\n            this._hash = stat._hash;\r\n\r\n            // Only cache data for watched files\r\n            if (this._isWatched()) {\r\n                this._stat = stat;\r\n                this._contents = data;\r\n            }\r\n\r\n            if (created) {\r\n                var parent = this._fileSystem.getDirectoryForPath(this.parentPath);\r\n                this._fileSystem._handleDirectoryChange(parent, function (added, removed) {\r\n                    try {\r\n                        // Notify the caller\r\n                        callback(null, stat);\r\n                    } finally {\r\n                        if (parent._isWatched()) {\r\n                            // If the write succeeded and the parent directory is watched,\r\n                            // fire a synthetic change event\r\n                            this._fileSystem._fireChangeEvent(parent, added, removed);\r\n\r\n                        }\r\n                        // Always unblock external change events\r\n                        this._fileSystem._endChange();\r\n                    }\r\n                }.bind(this));\r\n            } else {\r\n                try {\r\n                    // Notify the caller\r\n                    callback(null, stat);\r\n                } finally {\r\n                    // existing file modified\r\n                    this._fileSystem._fireChangeEvent(this);\r\n\r\n                    // Always unblock external change events\r\n                    this._fileSystem._endChange();\r\n                }\r\n            }\r\n        }.bind(this));\r\n    };\r\n\r\n    // Export this class\r\n    module.exports = File;\r\n});\r\n\n//# sourceURL=/filesystem/File.js'),eval("/*\r\n * Copyright (c) 2013 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the \"Software\"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\n/**\r\n * FileIndex is an internal module used by FileSystem to maintain an index of all files and directories.\r\n *\r\n * This module is *only* used by FileSystem, and should not be called directly.\r\n */\r\ndefine('filesystem/FileIndex',['require','exports','module'],function (require, exports, module) {\r\n    \"use strict\";\r\n\r\n    /**\r\n     * @constructor\r\n     */\r\n    function FileIndex() {\r\n        this._index = {};\r\n    }\r\n\r\n    /**\r\n     * Master index\r\n     *\r\n     * @type {Object.<string, File|Directory>} Maps a fullPath to a File or Directory object\r\n     */\r\n    FileIndex.prototype._index = null;\r\n\r\n    /**\r\n     * Clear the file index cache.\r\n     */\r\n    FileIndex.prototype.clear = function () {\r\n        this._index = {};\r\n    };\r\n\r\n    /**\r\n     * Visits every entry in the entire index; no stopping condition.\r\n     * @param {!function(FileSystemEntry, string):void} Called with an entry and its fullPath\r\n     */\r\n    FileIndex.prototype.visitAll = function (visitor) {\r\n        var path;\r\n        for (path in this._index) {\r\n            if (this._index.hasOwnProperty(path)) {\r\n                visitor(this._index[path], path);\r\n            }\r\n        }\r\n    };\r\n\r\n    /**\r\n     * Add an entry.\r\n     *\r\n     * @param {FileSystemEntry} entry The entry to add.\r\n     */\r\n    FileIndex.prototype.addEntry = function (entry) {\r\n        this._index[entry.fullPath] = entry;\r\n    };\r\n\r\n    /**\r\n     * Remove an entry.\r\n     *\r\n     * @param {FileSystemEntry} entry The entry to remove.\r\n     */\r\n    FileIndex.prototype.removeEntry = function (entry) {\r\n        var path = entry.fullPath,\r\n            property;\r\n\r\n        function replaceMember(property) {\r\n            var member = entry[property];\r\n            if (typeof member === \"function\") {\r\n                entry[property] = function () {\r\n                    console.warn(\"FileSystemEntry used after being removed from index: \", path);\r\n                    return member.apply(entry, arguments);\r\n                };\r\n            }\r\n        }\r\n\r\n        delete this._index[path];\r\n\r\n        for (property in entry) {\r\n            if (entry.hasOwnProperty(property)) {\r\n                replaceMember(property);\r\n            }\r\n        }\r\n    };\r\n\r\n    /**\r\n     * Notify the index that an entry has been renamed. This updates\r\n     * all affected entries in the index.\r\n     *\r\n     * @param {string} oldPath\r\n     * @param {string} newPath\r\n     * @param {boolean} isDirectory\r\n     */\r\n    FileIndex.prototype.entryRenamed = function (oldPath, newPath, isDirectory) {\r\n        var path,\r\n            renameMap = {};\r\n\r\n        // Find all entries affected by the rename and put into a separate map.\r\n        for (path in this._index) {\r\n            if (this._index.hasOwnProperty(path)) {\r\n                // See if we have a match. For directories, see if the path\r\n                // starts with the old name. This is safe since paths always end\r\n                // with '/'. For files, see if there is an exact match between\r\n                // the path and the old name.\r\n                if (isDirectory ? path.indexOf(oldPath) === 0 : path === oldPath) {\r\n                    renameMap[path] = newPath + path.substr(oldPath.length);\r\n                }\r\n            }\r\n        }\r\n\r\n        // Do the rename.\r\n        for (path in renameMap) {\r\n            if (renameMap.hasOwnProperty(path)) {\r\n                var item = this._index[path];\r\n\r\n                // Sanity check to make sure the item and path still match\r\n                console.assert(item.fullPath === path);\r\n\r\n                delete this._index[path];\r\n                this._index[renameMap[path]] = item;\r\n                item._setPath(renameMap[path]);\r\n            }\r\n        }\r\n    };\r\n\r\n    /**\r\n     * Returns the cached entry for the specified path, or undefined\r\n     * if the path has not been cached.\r\n     *\r\n     * @param {string} path The path of the entry to return.\r\n     * @return {File|Directory} The entry for the path, or undefined if it hasn't\r\n     *              been cached yet.\r\n     */\r\n    FileIndex.prototype.getEntry = function (path) {\r\n        return this._index[path];\r\n    };\r\n\r\n    // Export public API\r\n    module.exports = FileIndex;\r\n});\r\n\n//# sourceURL=/filesystem/FileIndex.js"),eval('/*\r\n * Copyright (c) 2013 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\n/**\r\n * The FileSystemStats represents a particular FileSystemEntry\'s stats.\r\n */\r\ndefine(\'filesystem/FileSystemStats\',[\'require\',\'exports\',\'module\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    /**\r\n     * @constructor\r\n     * @param {{isFile: boolean, mtime: Date, size: Number, realPath: ?string, hash: object}} options\r\n     */\r\n    function FileSystemStats(options) {\r\n        var isFile = options.isFile;\r\n\r\n        this._isFile = isFile;\r\n        this._isDirectory = !isFile;\r\n        // in case of stats transferred over a node-domain,\r\n        // mtime will have JSON-ified value which needs to be restored\r\n        this._mtime = options.mtime instanceof Date ? options.mtime : new Date(options.mtime);\r\n        this._size = options.size;\r\n        // hash is a property introduced by brackets and it\'s calculated\r\n        // as a valueOf modification time -> calculate here if it\'s not present\r\n        this._hash = options.hash || this._mtime.valueOf();\r\n\r\n        var realPath = options.realPath;\r\n        if (realPath) {\r\n            if (!isFile && realPath[realPath.length - 1] !== "/") {\r\n                realPath += "/";\r\n            }\r\n\r\n            this._realPath = realPath;\r\n        }\r\n    }\r\n\r\n    // Add "isFile", "isDirectory", "mtime" and "size" getters\r\n    Object.defineProperties(FileSystemStats.prototype, {\r\n        "isFile": {\r\n            get: function () { return this._isFile; },\r\n            set: function () { throw new Error("Cannot set isFile"); }\r\n        },\r\n        "isDirectory": {\r\n            get: function () { return this._isDirectory; },\r\n            set: function () { throw new Error("Cannot set isDirectory"); }\r\n        },\r\n        "mtime": {\r\n            get: function () { return this._mtime; },\r\n            set: function () { throw new Error("Cannot set mtime"); }\r\n        },\r\n        "size": {\r\n            get: function () { return this._size; },\r\n            set: function () { throw new Error("Cannot set size"); }\r\n        },\r\n        "realPath": {\r\n            get: function () { return this._realPath; },\r\n            set: function () { throw new Error("Cannot set realPath"); }\r\n        }\r\n    });\r\n\r\n    /**\r\n     * Whether or not this is a stats object for a file\r\n     * @type {boolean}\r\n     */\r\n    FileSystemStats.prototype._isFile = false;\r\n\r\n    /**\r\n     * Whether or not this is a stats object for a directory\r\n     * @type {boolean}\r\n     */\r\n    FileSystemStats.prototype._isDirectory = false;\r\n\r\n    /**\r\n     * Modification time for a file\r\n     * @type {Date}\r\n     */\r\n    FileSystemStats.prototype._mtime = null;\r\n\r\n    /**\r\n     * Size in bytes of a file\r\n     * @type {Number}\r\n     */\r\n    FileSystemStats.prototype._size = null;\r\n\r\n    /**\r\n     * Consistency hash for a file\r\n     * @type {object}\r\n     */\r\n    FileSystemStats.prototype._hash = null;\r\n\r\n    /**\r\n     * The canonical path of this file or directory ONLY if it is a symbolic link,\r\n     * and null otherwise.\r\n     *\r\n     * @type {?string}\r\n     */\r\n    FileSystemStats.prototype._realPath = null;\r\n\r\n    module.exports = FileSystemStats;\r\n});\r\n\n//# sourceURL=/filesystem/FileSystemStats.js'),eval('/*\r\n * Copyright (c) 2013 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\ndefine(\'utils/NodeConnection\',[\'require\',\'exports\',\'module\',\'utils/EventDispatcher\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    var EventDispatcher = require("utils/EventDispatcher");\r\n\r\n\r\n    /**\r\n     * Connection attempts to make before failing\r\n     * @type {number}\r\n     */\r\n    var CONNECTION_ATTEMPTS = 10;\r\n\r\n    /**\r\n     * Milliseconds to wait before a particular connection attempt is considered failed.\r\n     * NOTE: It\'s okay for the connection timeout to be long because the\r\n     * expected behavior of WebSockets is to send a "close" event as soon\r\n     * as they realize they can\'t connect. So, we should rarely hit the\r\n     * connection timeout even if we try to connect to a port that isn\'t open.\r\n     * @type {number}\r\n     */\r\n    var CONNECTION_TIMEOUT  = 10000; // 10 seconds\r\n\r\n    /**\r\n     * Milliseconds to wait before retrying connecting\r\n     * @type {number}\r\n     */\r\n    var RETRY_DELAY         = 500;   // 1/2 second\r\n\r\n    /**\r\n     * Maximum value of the command ID counter\r\n     * @type  {number}\r\n     */\r\n    var MAX_COUNTER_VALUE = 4294967295; // 2^32 - 1\r\n\r\n    /**\r\n     * @private\r\n     * Helper function to auto-reject a deferred after a given amount of time.\r\n     * If the deferred is resolved/rejected manually, then the timeout is\r\n     * automatically cleared.\r\n     */\r\n    function setDeferredTimeout(deferred, delay) {\r\n        var timer = setTimeout(function () {\r\n            deferred.reject("timeout");\r\n        }, delay);\r\n        deferred.always(function () { clearTimeout(timer); });\r\n    }\r\n\r\n    /**\r\n     * @private\r\n     * Helper function to attempt a single connection to the node server\r\n     */\r\n    function attemptSingleConnect() {\r\n        var deferred = $.Deferred();\r\n        var port = null;\r\n        var ws = null;\r\n        setDeferredTimeout(deferred, CONNECTION_TIMEOUT);\r\n\r\n        brackets.app.getNodeState(function (err, nodePort) {\r\n            if (!err && nodePort && deferred.state() !== "rejected") {\r\n                port = nodePort;\r\n                ws = new WebSocket("ws://localhost:" + port);\r\n\r\n                // Expect ArrayBuffer objects from Node when receiving binary\r\n                // data instead of DOM Blobs, which are the default.\r\n                ws.binaryType = "arraybuffer";\r\n\r\n                // If the server port isn\'t open, we get a close event\r\n                // at some point in the future (and will not get an onopen\r\n                // event)\r\n                ws.onclose = function () {\r\n                    deferred.reject("WebSocket closed");\r\n                };\r\n\r\n                ws.onopen = function () {\r\n                    // If we successfully opened, remove the old onclose\r\n                    // handler (which was present to detect failure to\r\n                    // connect at all).\r\n                    ws.onclose = null;\r\n                    deferred.resolveWith(null, [ws, port]);\r\n                };\r\n            } else {\r\n                deferred.reject("brackets.app.getNodeState error: " + err);\r\n            }\r\n        });\r\n\r\n        return deferred.promise();\r\n    }\r\n\r\n    /**\r\n     * Provides an interface for interacting with the node server.\r\n     * @constructor\r\n     */\r\n    function NodeConnection() {\r\n        this.domains = {};\r\n        this._registeredModules = [];\r\n        this._pendingInterfaceRefreshDeferreds = [];\r\n        this._pendingCommandDeferreds = [];\r\n    }\r\n    EventDispatcher.makeEventDispatcher(NodeConnection.prototype);\r\n\r\n    /**\r\n     * @type {Object}\r\n     * Exposes the domains registered with the server. This object will\r\n     * have a property for each registered domain. Each of those properties\r\n     * will be an object containing properties for all the commands in that\r\n     * domain. So, myConnection.base.enableDebugger would point to the function\r\n     * to call to enable the debugger.\r\n     *\r\n     * This object is automatically replaced every time the API changes (based\r\n     * on the base:newDomains event from the server). Therefore, code that\r\n     * uses this object should not keep their own pointer to the domain property.\r\n     */\r\n    NodeConnection.prototype.domains = null;\r\n\r\n    /**\r\n     * @private\r\n     * @type {Array.<string>}\r\n     * List of module pathnames that should be re-registered if there is\r\n     * a disconnection/connection (i.e. if the server died).\r\n     */\r\n    NodeConnection.prototype._registeredModules = null;\r\n\r\n    /**\r\n     * @private\r\n     * @type {WebSocket}\r\n     * The connection to the server\r\n     */\r\n    NodeConnection.prototype._ws = null;\r\n\r\n    /**\r\n     * @private\r\n     * @type {?number}\r\n     * The port the WebSocket is currently connected to\r\n     */\r\n    NodeConnection.prototype._port = null;\r\n\r\n    /**\r\n     * @private\r\n     * @type {number}\r\n     * Unique ID for commands\r\n     */\r\n    NodeConnection.prototype._commandCount = 1;\r\n\r\n    /**\r\n     * @private\r\n     * @type {boolean}\r\n     * Whether to attempt reconnection if connection fails\r\n     */\r\n    NodeConnection.prototype._autoReconnect = false;\r\n\r\n    /**\r\n     * @private\r\n     * @type {Array.<jQuery.Deferred>}\r\n     * List of deferred objects that should be resolved pending\r\n     * a successful refresh of the API\r\n     */\r\n    NodeConnection.prototype._pendingInterfaceRefreshDeferreds = null;\r\n\r\n    /**\r\n     * @private\r\n     * @type {Array.<jQuery.Deferred>}\r\n     * Array (indexed on command ID) of deferred objects that should be\r\n     * resolved/rejected with the response of commands.\r\n     */\r\n    NodeConnection.prototype._pendingCommandDeferreds = null;\r\n\r\n    /**\r\n     * @private\r\n     * @return {number} The next command ID to use. Always representable as an\r\n     * unsigned 32-bit integer.\r\n     */\r\n    NodeConnection.prototype._getNextCommandID = function () {\r\n        var nextID;\r\n\r\n        if (this._commandCount > MAX_COUNTER_VALUE) {\r\n            nextID = this._commandCount = 0;\r\n        } else {\r\n            nextID = this._commandCount++;\r\n        }\r\n\r\n        return nextID;\r\n    };\r\n\r\n    /**\r\n     * @private\r\n     * Helper function to do cleanup work when a connection fails\r\n     */\r\n    NodeConnection.prototype._cleanup = function () {\r\n        // clear out the domains, since we may get different ones\r\n        // on the next connection\r\n        this.domains = {};\r\n\r\n        // shut down the old connection if there is one\r\n        if (this._ws && this._ws.readyState !== WebSocket.CLOSED) {\r\n            try {\r\n                this._ws.close();\r\n            } catch (e) { }\r\n        }\r\n        var failedDeferreds = this._pendingInterfaceRefreshDeferreds\r\n            .concat(this._pendingCommandDeferreds);\r\n        failedDeferreds.forEach(function (d) {\r\n            d.reject("cleanup");\r\n        });\r\n        this._pendingInterfaceRefreshDeferreds = [];\r\n        this._pendingCommandDeferreds = [];\r\n\r\n        this._ws = null;\r\n        this._port = null;\r\n    };\r\n\r\n    /**\r\n     * Connect to the node server. After connecting, the NodeConnection\r\n     * object will trigger a "close" event when the underlying socket\r\n     * is closed. If the connection is set to autoReconnect, then the\r\n     * event will also include a jQuery promise for the connection.\r\n     *\r\n     * @param {boolean} autoReconnect Whether to automatically try to\r\n     *    reconnect to the server if the connection succeeds and then\r\n     *    later disconnects. Note if this connection fails initially, the\r\n     *    autoReconnect flag is set to false. Future calls to connect()\r\n     *    can reset it to true\r\n     * @return {jQuery.Promise} Promise that resolves/rejects when the\r\n     *    connection succeeds/fails\r\n     */\r\n    NodeConnection.prototype.connect = function (autoReconnect) {\r\n        var self = this;\r\n        self._autoReconnect = autoReconnect;\r\n        var deferred = $.Deferred();\r\n        var attemptCount = 0;\r\n        var attemptTimestamp = null;\r\n\r\n        // Called after a successful connection to do final setup steps\r\n        function registerHandlersAndDomains(ws, port) {\r\n            // Called if we succeed at the final setup\r\n            function success() {\r\n                self._ws.onclose = function () {\r\n                    if (self._autoReconnect) {\r\n                        var $promise = self.connect(true);\r\n                        self.trigger("close", $promise);\r\n                    } else {\r\n                        self._cleanup();\r\n                        self.trigger("close");\r\n                    }\r\n                };\r\n                deferred.resolve();\r\n            }\r\n            // Called if we fail at the final setup\r\n            function fail(err) {\r\n                self._cleanup();\r\n                deferred.reject(err);\r\n            }\r\n\r\n            self._ws = ws;\r\n            self._port = port;\r\n            self._ws.onmessage = self._receive.bind(self);\r\n\r\n            // refresh the current domains, then re-register any\r\n            // "autoregister" modules\r\n            self._refreshInterface().then(\r\n                function () {\r\n                    if (self._registeredModules.length > 0) {\r\n                        self.loadDomains(self._registeredModules, false).then(\r\n                            success,\r\n                            fail\r\n                        );\r\n                    } else {\r\n                        success();\r\n                    }\r\n                },\r\n                fail\r\n            );\r\n        }\r\n\r\n        // Repeatedly tries to connect until we succeed or until we\'ve\r\n        // failed CONNECTION_ATTEMPT times. After each attempt, waits\r\n        // at least RETRY_DELAY before trying again.\r\n        function doConnect() {\r\n            attemptCount++;\r\n            attemptTimestamp = new Date();\r\n            attemptSingleConnect().then(\r\n                registerHandlersAndDomains, // succeded\r\n                function () { // failed this attempt, possibly try again\r\n                    if (attemptCount < CONNECTION_ATTEMPTS) { //try again\r\n                        // Calculate how long we should wait before trying again\r\n                        var now = new Date();\r\n                        var delay = Math.max(\r\n                            RETRY_DELAY - (now - attemptTimestamp),\r\n                            1\r\n                        );\r\n                        setTimeout(doConnect, delay);\r\n                    } else { // too many attempts, give up\r\n                        deferred.reject("Max connection attempts reached");\r\n                    }\r\n                }\r\n            );\r\n        }\r\n\r\n        // Start the connection process\r\n        self._cleanup();\r\n        doConnect();\r\n\r\n        return deferred.promise();\r\n    };\r\n\r\n    /**\r\n     * Determines whether the NodeConnection is currently connected\r\n     * @return {boolean} Whether the NodeConnection is connected.\r\n     */\r\n    NodeConnection.prototype.connected = function () {\r\n        return !!(this._ws && this._ws.readyState === WebSocket.OPEN);\r\n    };\r\n\r\n    /**\r\n     * Explicitly disconnects from the server. Note that even if\r\n     * autoReconnect was set to true at connection time, the connection\r\n     * will not reconnect after this call. Reconnection can be manually done\r\n     * by calling connect() again.\r\n     */\r\n    NodeConnection.prototype.disconnect = function () {\r\n        this._autoReconnect = false;\r\n        this._cleanup();\r\n    };\r\n\r\n    /**\r\n     * Load domains into the server by path\r\n     * @param {Array.<string>} List of absolute paths to load\r\n     * @param {boolean} autoReload Whether to auto-reload the domains if the server\r\n     *    fails and restarts. Note that the reload is initiated by the\r\n     *    client, so it will only happen after the client reconnects.\r\n     * @return {jQuery.Promise} Promise that resolves after the load has\r\n     *    succeeded and the new API is availale at NodeConnection.domains,\r\n     *    or that rejects on failure.\r\n     */\r\n    NodeConnection.prototype.loadDomains = function (paths, autoReload) {\r\n        var deferred = $.Deferred();\r\n        setDeferredTimeout(deferred, CONNECTION_TIMEOUT);\r\n        var pathArray = paths;\r\n        if (!Array.isArray(paths)) {\r\n            pathArray = [paths];\r\n        }\r\n\r\n        if (autoReload) {\r\n            Array.prototype.push.apply(this._registeredModules, pathArray);\r\n        }\r\n\r\n        if (this.domains.base && this.domains.base.loadDomainModulesFromPaths) {\r\n            this.domains.base.loadDomainModulesFromPaths(pathArray).then(\r\n                function (success) { // command call succeeded\r\n                    if (!success) {\r\n                        // response from commmand call was "false" so we know\r\n                        // the actual load failed.\r\n                        deferred.reject("loadDomainModulesFromPaths failed");\r\n                    }\r\n                    // if the load succeeded, we wait for the API refresh to\r\n                    // resolve the deferred.\r\n                },\r\n                function (reason) { // command call failed\r\n                    deferred.reject("Unable to load one of the modules: " + pathArray + (reason ? ", reason: " + reason : ""));\r\n                }\r\n            );\r\n\r\n            this._pendingInterfaceRefreshDeferreds.push(deferred);\r\n        } else {\r\n            deferred.reject("this.domains.base is undefined");\r\n        }\r\n\r\n        return deferred.promise();\r\n    };\r\n\r\n    /**\r\n     * @private\r\n     * Sends a message over the WebSocket. Automatically JSON.stringifys\r\n     * the message if necessary.\r\n     * @param {Object|string} m Object to send. Must be JSON.stringify-able.\r\n     */\r\n    NodeConnection.prototype._send = function (m) {\r\n        if (this.connected()) {\r\n\r\n            // Convert the message to a string\r\n            var messageString = null;\r\n            if (typeof m === "string") {\r\n                messageString = m;\r\n            } else {\r\n                try {\r\n                    messageString = JSON.stringify(m);\r\n                } catch (stringifyError) {\r\n                    console.error("[NodeConnection] Unable to stringify message in order to send: " + stringifyError.message);\r\n                }\r\n            }\r\n\r\n            // If we succeded in making a string, try to send it\r\n            if (messageString) {\r\n                try {\r\n                    this._ws.send(messageString);\r\n                } catch (sendError) {\r\n                    console.error("[NodeConnection] Error sending message: " + sendError.message);\r\n                }\r\n            }\r\n        } else {\r\n            console.error("[NodeConnection] Not connected to node, unable to send.");\r\n        }\r\n    };\r\n\r\n    /**\r\n     * @private\r\n     * Handler for receiving events on the WebSocket. Parses the message\r\n     * and dispatches it appropriately.\r\n     * @param {WebSocket.Message} message Message object from WebSocket\r\n     */\r\n    NodeConnection.prototype._receive = function (message) {\r\n        var responseDeferred = null;\r\n        var data = message.data;\r\n        var m;\r\n\r\n        if (message.data instanceof ArrayBuffer) {\r\n            // The first four bytes encode the command ID as an unsigned 32-bit integer\r\n            if (data.byteLength < 4) {\r\n                console.error("[NodeConnection] received malformed binary message");\r\n                return;\r\n            }\r\n\r\n            var header = data.slice(0, 4),\r\n                body = data.slice(4),\r\n                headerView = new Uint32Array(header),\r\n                id = headerView[0];\r\n\r\n            // Unpack the binary message into a commandResponse\r\n            m = {\r\n                type: "commandResponse",\r\n                message: {\r\n                    id: id,\r\n                    response: body\r\n                }\r\n            };\r\n        } else {\r\n            try {\r\n                m = JSON.parse(data);\r\n            } catch (e) {\r\n                console.error("[NodeConnection] received malformed message", message, e.message);\r\n                return;\r\n            }\r\n        }\r\n\r\n        switch (m.type) {\r\n        case "event":\r\n            if (m.message.domain === "base" && m.message.event === "newDomains") {\r\n                this._refreshInterface();\r\n            }\r\n\r\n            // Event type "domain:event"\r\n            EventDispatcher.triggerWithArray(this, m.message.domain + ":" + m.message.event,\r\n                                             m.message.parameters);\r\n            break;\r\n        case "commandResponse":\r\n            responseDeferred = this._pendingCommandDeferreds[m.message.id];\r\n            if (responseDeferred) {\r\n                responseDeferred.resolveWith(this, [m.message.response]);\r\n                delete this._pendingCommandDeferreds[m.message.id];\r\n            }\r\n            break;\r\n        case "commandProgress":\r\n            responseDeferred = this._pendingCommandDeferreds[m.message.id];\r\n            if (responseDeferred) {\r\n                responseDeferred.notifyWith(this, [m.message.message]);\r\n            }\r\n            break;\r\n        case "commandError":\r\n            responseDeferred = this._pendingCommandDeferreds[m.message.id];\r\n            if (responseDeferred) {\r\n                responseDeferred.rejectWith(\r\n                    this,\r\n                    [m.message.message, m.message.stack]\r\n                );\r\n                delete this._pendingCommandDeferreds[m.message.id];\r\n            }\r\n            break;\r\n        case "error":\r\n            console.error("[NodeConnection] received error: " +\r\n                            m.message.message);\r\n            break;\r\n        default:\r\n            console.error("[NodeConnection] unknown event type: " + m.type);\r\n        }\r\n    };\r\n\r\n    /**\r\n     * @private\r\n     * Helper function for refreshing the interface in the "domain" property.\r\n     * Automatically called when the connection receives a base:newDomains\r\n     * event from the server, and also called at connection time.\r\n     */\r\n    NodeConnection.prototype._refreshInterface = function () {\r\n        var deferred = $.Deferred();\r\n        var self = this;\r\n\r\n        var pendingDeferreds = this._pendingInterfaceRefreshDeferreds;\r\n        this._pendingInterfaceRefreshDeferreds = [];\r\n        deferred.then(\r\n            function () {\r\n                pendingDeferreds.forEach(function (d) { d.resolve(); });\r\n            },\r\n            function (err) {\r\n                pendingDeferreds.forEach(function (d) { d.reject(err); });\r\n            }\r\n        );\r\n\r\n        function refreshInterfaceCallback(spec) {\r\n            function makeCommandFunction(domainName, commandSpec) {\r\n                return function () {\r\n                    var deferred = $.Deferred();\r\n                    var parameters = Array.prototype.slice.call(arguments, 0);\r\n                    var id = self._getNextCommandID();\r\n                    self._pendingCommandDeferreds[id] = deferred;\r\n                    self._send({id: id,\r\n                               domain: domainName,\r\n                               command: commandSpec.name,\r\n                               parameters: parameters\r\n                               });\r\n                    return deferred;\r\n                };\r\n            }\r\n\r\n            // TODO: Don\'t replace the domain object every time. Instead, merge.\r\n            self.domains = {};\r\n            self.domainEvents = {};\r\n            spec.forEach(function (domainSpec) {\r\n                self.domains[domainSpec.domain] = {};\r\n                domainSpec.commands.forEach(function (commandSpec) {\r\n                    self.domains[domainSpec.domain][commandSpec.name] =\r\n                        makeCommandFunction(domainSpec.domain, commandSpec);\r\n                });\r\n                self.domainEvents[domainSpec.domain] = {};\r\n                domainSpec.events.forEach(function (eventSpec) {\r\n                    var parameters = eventSpec.parameters;\r\n                    self.domainEvents[domainSpec.domain][eventSpec.name] = parameters;\r\n                });\r\n            });\r\n            deferred.resolve();\r\n        }\r\n\r\n        if (this.connected()) {\r\n            $.getJSON("http://localhost:" + this._port + "/api")\r\n                .done(refreshInterfaceCallback)\r\n                .fail(function (err) { deferred.reject(err); });\r\n        } else {\r\n            deferred.reject("Attempted to call _refreshInterface when not connected.");\r\n        }\r\n\r\n        return deferred.promise();\r\n    };\r\n\r\n    /**\r\n     * @private\r\n     * Get the default timeout value\r\n     * @return {number} Timeout value in milliseconds\r\n     */\r\n    NodeConnection._getConnectionTimeout = function () {\r\n        return CONNECTION_TIMEOUT;\r\n    };\r\n\r\n    module.exports = NodeConnection;\r\n\r\n});\r\n\n//# sourceURL=/utils/NodeConnection.js'),
eval('/*\r\n * Copyright (c) 2013 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\ndefine(\'utils/NodeDomain\',[\'require\',\'exports\',\'module\',\'utils/NodeConnection\',\'utils/EventDispatcher\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    var NodeConnection = require("utils/NodeConnection"),\r\n        EventDispatcher = require("utils/EventDispatcher");\r\n\r\n    // Used to remove all listeners at once when the connection drops\r\n    var EVENT_NAMESPACE = ".NodeDomainEvent";\r\n\r\n    /**\r\n     * Provides a simple abstraction for executing the commands of a single\r\n     * domain loaded via a NodeConnection. Automatically handles connection\r\n     * management and domain loading, and exposes each command in the domain as\r\n     * a promise-returning method that can safely be called regardless of the\r\n     * current status of the underlying connection. Example usage:\r\n     *\r\n     *     var myDomain = new NodeDomain("someDomain", "/path/to/SomeDomainDef.js"),\r\n     *         $result = myDomain.exec("someCommand", arg1, arg2);\r\n     *\r\n     *     $result.done(function (value) {\r\n     *         // the command succeeded!\r\n     *     });\r\n     *\r\n     *     $result.fail(function (err) {\r\n     *         // the command failed; act accordingly!\r\n     *     });\r\n     *\r\n     * To handle domain events, just listen for the event on the domain:\r\n     *\r\n     *     myDomain.on("someEvent", someHandler);\r\n     *\r\n     * @constructor\r\n     * @param {string} domainName Name of the registered Node Domain\r\n     * @param {string} domainPath Full path of the JavaScript Node domain specification\r\n     */\r\n    function NodeDomain(domainName, domainPath) {\r\n        var connection = new NodeConnection();\r\n\r\n        this.connection = connection;\r\n        this._domainName = domainName;\r\n        this._domainPath = domainPath;\r\n        this._domainLoaded = false;\r\n        this._load = this._load.bind(this);\r\n        this._connectionPromise = connection.connect(true)\r\n            .then(this._load);\r\n\r\n        connection.on("close", function (event, promise) {\r\n            this.connection.off(EVENT_NAMESPACE);\r\n            this._domainLoaded = false;\r\n            this._connectionPromise = promise.then(this._load);\r\n        }.bind(this));\r\n    }\r\n    EventDispatcher.makeEventDispatcher(NodeDomain.prototype);\r\n\r\n    /**\r\n     * The underlying Node connection object for this domain.\r\n     *\r\n     * @type {NodeConnection}\r\n     */\r\n    NodeDomain.prototype.connection = null;\r\n\r\n    /**\r\n     * A promise that is resolved once the NodeConnection is connected and the\r\n     * domain has been loaded.\r\n     *\r\n     * @type {?jQuery.Promise}\r\n     * @private\r\n     */\r\n    NodeDomain.prototype._connectionPromise = null;\r\n\r\n    /**\r\n     * The name of this domain.\r\n     *\r\n     * @type {string}\r\n     * @private\r\n     */\r\n    NodeDomain.prototype._domainName = null;\r\n\r\n    /**\r\n     * The path at which the Node definition of this domain resides.\r\n     *\r\n     * @type {string}\r\n     * @private\r\n     */\r\n    NodeDomain.prototype._domainPath = null;\r\n\r\n    /**\r\n     * Whether or not the domain has been successfully loaded.\r\n     *\r\n     * @type {boolean}\r\n     * @private\r\n     */\r\n    NodeDomain.prototype._domainLoaded = false;\r\n\r\n    /**\r\n     * Loads the domain via the underlying connection object and exposes the\r\n     * domain\'s commands as methods on this object. Assumes the underlying\r\n     * connection has already been opened.\r\n     *\r\n     * @return {jQuery.Promise} Resolves once the domain is been loaded.\r\n     * @private\r\n     */\r\n    NodeDomain.prototype._load = function () {\r\n        var connection = this.connection;\r\n        return connection.loadDomains(this._domainPath, true)\r\n            .done(function () {\r\n                this._domainLoaded = true;\r\n                this._connectionPromise = null;\r\n\r\n                var eventNames = Object.keys(connection.domainEvents[this._domainName]);\r\n                eventNames.forEach(function (domainEvent) {\r\n                    var connectionEvent = this._domainName + ":" + domainEvent + EVENT_NAMESPACE;\r\n\r\n                    connection.on(connectionEvent, function () {\r\n                        var params = Array.prototype.slice.call(arguments, 1);\r\n                        EventDispatcher.triggerWithArray(this, domainEvent, params);\r\n                    }.bind(this));\r\n                }, this);\r\n            }.bind(this))\r\n            .fail(function (err) {\r\n                console.error("[NodeDomain] Error loading domain \\"" + this._domainName + "\\": " + err);\r\n            }.bind(this));\r\n    };\r\n\r\n    /**\r\n     * Synchronously determine whether the domain is ready; i.e., whether the\r\n     * connection is open and the domain is loaded.\r\n     *\r\n     * @return {boolean} Whether or not the domain is currently ready.\r\n     */\r\n    NodeDomain.prototype.ready = function () {\r\n        return this._domainLoaded && this.connection.connected();\r\n    };\r\n\r\n    /**\r\n     * Get a promise that resolves when the connection is open and the domain\r\n     * is loaded.\r\n     *\r\n     * @return {jQuery.Promise}\r\n     */\r\n    NodeDomain.prototype.promise = function () {\r\n        if (this._connectionPromise) {\r\n            return this._connectionPromise;\r\n        } else {\r\n            var deferred = new $.Deferred();\r\n\r\n            if (this.ready()) {\r\n                deferred.resolve();\r\n            } else {\r\n                deferred.reject();\r\n            }\r\n\r\n            return deferred.promise();\r\n        }\r\n    };\r\n\r\n    /**\r\n     * Applies the named command from the domain to a list of parameters, which\r\n     * are passed as extra arguments to this method. If the connection is open\r\n     * and the domain is loaded, the function is applied immediately. Otherwise\r\n     * the function is applied as soon as the connection has been opened and the\r\n     * domain has finished loading.\r\n     *\r\n     * @param {string} name The name of the domain command to execute\r\n     * @return {jQuery.Promise} Resolves with the result of the command\r\n     */\r\n    NodeDomain.prototype.exec = function (name) {\r\n        var connection = this.connection,\r\n            params = Array.prototype.slice.call(arguments, 1),\r\n            execConnected = function () {\r\n                var domain  = connection.domains[this._domainName],\r\n                    fn      = domain && domain[name],\r\n                    execResult;\r\n\r\n                if (fn) {\r\n                    execResult = fn.apply(domain, params);\r\n                } else {\r\n                    execResult = new $.Deferred().reject().promise();\r\n                }\r\n                return execResult;\r\n            }.bind(this);\r\n\r\n        var result;\r\n        if (this.ready()) {\r\n            result = execConnected();\r\n        } else if (this._connectionPromise) {\r\n            result = this._connectionPromise.then(execConnected);\r\n        } else {\r\n            result = new $.Deferred.reject().promise();\r\n        }\r\n        return result;\r\n    };\r\n\r\n    module.exports = NodeDomain;\r\n});\r\n\n//# sourceURL=/utils/NodeDomain.js'),eval('/*\r\n * Copyright (c) 2013 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\n/*global appshell */\r\n\r\ndefine(\'fileSystemImpl\',[\'require\',\'exports\',\'module\',\'file/FileUtils\',\'filesystem/FileSystemStats\',\'filesystem/FileSystemError\',\'utils/NodeDomain\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    var FileUtils           = require("file/FileUtils"),\r\n        FileSystemStats     = require("filesystem/FileSystemStats"),\r\n        FileSystemError     = require("filesystem/FileSystemError"),\r\n        NodeDomain          = require("utils/NodeDomain");\r\n\r\n    /**\r\n     * @const\r\n     */\r\n    var FILE_WATCHER_BATCH_TIMEOUT = 200;   // 200ms - granularity of file watcher changes\r\n\r\n    /**\r\n     * Callback to notify FileSystem of watcher changes\r\n     * @type {?function(string, FileSystemStats=)}\r\n     */\r\n    var _changeCallback;\r\n\r\n    /**\r\n     * Callback to notify FileSystem if watchers stop working entirely\r\n     * @type {?function()}\r\n     */\r\n    var _offlineCallback;\r\n\r\n    /** Timeout used to batch up file watcher changes (setTimeout() return value) */\r\n    var _changeTimeout;\r\n\r\n    /**\r\n     * Pending file watcher changes - map from fullPath to flag indicating whether we need to pass stats\r\n     * to _changeCallback() for this path.\r\n     * @type {!Object.<string, boolean>}\r\n     */\r\n    var _pendingChanges = {};\r\n\r\n    var _bracketsPath   = FileUtils.getNativeBracketsDirectoryPath(),\r\n        _modulePath     = FileUtils.getNativeModuleDirectoryPath(module),\r\n        _nodePath       = "node/FileWatcherDomain",\r\n        _domainPath     = [_bracketsPath, _modulePath, _nodePath].join("/"),\r\n        _nodeDomain     = new NodeDomain("fileWatcher", _domainPath);\r\n\r\n    var _isRunningOnWindowsXP = window.navigator.userAgent.indexOf("Windows NT 5.") >= 0;\r\n\r\n\r\n    // If the connection closes, notify the FileSystem that watchers have gone offline.\r\n    _nodeDomain.connection.on("close", function (event, promise) {\r\n        if (_offlineCallback) {\r\n            _offlineCallback();\r\n        }\r\n    });\r\n\r\n    /**\r\n     * Enqueue a file change event for eventual reporting back to the FileSystem.\r\n     *\r\n     * @param {string} changedPath The path that was changed\r\n     * @param {object} stats Stats coming from the underlying watcher, if available\r\n     * @private\r\n     */\r\n    function _enqueueChange(changedPath, stats) {\r\n        _pendingChanges[changedPath] = stats;\r\n        if (!_changeTimeout) {\r\n            _changeTimeout = window.setTimeout(function () {\r\n                if (_changeCallback) {\r\n                    Object.keys(_pendingChanges).forEach(function (path) {\r\n                        _changeCallback(path, _pendingChanges[path]);\r\n                    });\r\n                }\r\n\r\n                _changeTimeout = null;\r\n                _pendingChanges = {};\r\n            }, FILE_WATCHER_BATCH_TIMEOUT);\r\n        }\r\n    }\r\n\r\n    /**\r\n     * Event handler for the Node fileWatcher domain\'s change event.\r\n     *\r\n     * @param {jQuery.Event} The underlying change event\r\n     * @param {string} event The type of the event: "changed", "created" or "deleted"\r\n     * @param {string} parentDirPath The path to the directory holding entry that has changed\r\n     * @param {string=} entryName The name of the file/directory that has changed\r\n     * @param {object} statsObj Object that can be used to construct FileSystemStats\r\n     * @private\r\n     */\r\n    function _fileWatcherChange(evt, event, parentDirPath, entryName, statsObj) {\r\n        var change;\r\n        switch (event) {\r\n        case "changed":\r\n            // an existing file/directory was modified; stats are passed if available\r\n            var fsStats;\r\n            if (statsObj) {\r\n                fsStats = new FileSystemStats(statsObj);\r\n            } else {\r\n                console.warn("FileWatcherDomain was expected to deliver stats for changed event!");\r\n            }\r\n            _enqueueChange(parentDirPath + entryName, fsStats);\r\n            break;\r\n        case "created":\r\n        case "deleted":\r\n            // file/directory was created/deleted; fire change on parent to reload contents\r\n            _enqueueChange(parentDirPath, null);\r\n            break;\r\n        default:\r\n            console.error("Unexpected \'change\' event:", event);\r\n        }\r\n    }\r\n\r\n    // Setup the change handler. This only needs to happen once.\r\n    _nodeDomain.on("change", _fileWatcherChange);\r\n\r\n    /**\r\n     * Convert appshell error codes to FileSystemError values.\r\n     *\r\n     * @param {?number} err An appshell error code\r\n     * @return {?string} A FileSystemError string, or null if there was no error code.\r\n     * @private\r\n     */\r\n    function _mapError(err) {\r\n        if (!err) {\r\n            return null;\r\n        }\r\n\r\n        switch (err) {\r\n        case appshell.fs.ERR_INVALID_PARAMS:\r\n            return FileSystemError.INVALID_PARAMS;\r\n        case appshell.fs.ERR_NOT_FOUND:\r\n            return FileSystemError.NOT_FOUND;\r\n        case appshell.fs.ERR_CANT_READ:\r\n            return FileSystemError.NOT_READABLE;\r\n        case appshell.fs.ERR_CANT_WRITE:\r\n            return FileSystemError.NOT_WRITABLE;\r\n        case appshell.fs.ERR_UNSUPPORTED_ENCODING:\r\n            return FileSystemError.UNSUPPORTED_ENCODING;\r\n        case appshell.fs.ERR_OUT_OF_SPACE:\r\n            return FileSystemError.OUT_OF_SPACE;\r\n        case appshell.fs.ERR_FILE_EXISTS:\r\n            return FileSystemError.ALREADY_EXISTS;\r\n        case appshell.fs.ERR_ENCODE_FILE_FAILED:\r\n            return FileSystemError.ENCODE_FILE_FAILED;\r\n        case appshell.fs.ERR_DECODE_FILE_FAILED:\r\n            return FileSystemError.DECODE_FILE_FAILED;\r\n        case appshell.fs.ERR_UNSUPPORTED_UTF16_ENCODING:\r\n            return FileSystemError.UNSUPPORTED_UTF16_ENCODING;\r\n        }\r\n        return FileSystemError.UNKNOWN;\r\n    }\r\n\r\n    /**\r\n     * Convert a callback to one that transforms its first parameter from an\r\n     * appshell error code to a FileSystemError string.\r\n     *\r\n     * @param {function(?number)} cb A callback that expects an appshell error code\r\n     * @return {function(?string)} A callback that expects a FileSystemError string\r\n     * @private\r\n     */\r\n    function _wrap(cb) {\r\n        return function (err) {\r\n            var args = Array.prototype.slice.call(arguments);\r\n            args[0] = _mapError(args[0]);\r\n            cb.apply(null, args);\r\n        };\r\n    }\r\n\r\n    /**\r\n     * Display an open-files dialog to the user and call back asynchronously with\r\n     * either a FileSystmError string or an array of path strings, which indicate\r\n     * the entry or entries selected.\r\n     *\r\n     * @param {boolean} allowMultipleSelection\r\n     * @param {boolean} chooseDirectories\r\n     * @param {string} title\r\n     * @param {string} initialPath\r\n     * @param {Array.<string>=} fileTypes\r\n     * @param {function(?string, Array.<string>=)} callback\r\n     */\r\n    function showOpenDialog(allowMultipleSelection, chooseDirectories, title, initialPath, fileTypes, callback) {\r\n        appshell.fs.showOpenDialog(allowMultipleSelection, chooseDirectories, title, initialPath, fileTypes, _wrap(callback));\r\n    }\r\n\r\n    /**\r\n     * Display a save-file dialog and call back asynchronously with either a\r\n     * FileSystemError string or the path to which the user has chosen to save\r\n     * the file. If the dialog is cancelled, the path string will be empty.\r\n     *\r\n     * @param {string} title\r\n     * @param {string} initialPath\r\n     * @param {string} proposedNewFilename\r\n     * @param {function(?string, string=)} callback\r\n     */\r\n    function showSaveDialog(title, initialPath, proposedNewFilename, callback) {\r\n        appshell.fs.showSaveDialog(title, initialPath, proposedNewFilename, _wrap(callback));\r\n    }\r\n\r\n    /**\r\n     * Stat the file or directory at the given path, calling back\r\n     * asynchronously with either a FileSystemError string or the entry\'s\r\n     * associated FileSystemStats object.\r\n     *\r\n     * @param {string} path\r\n     * @param {function(?string, FileSystemStats=)} callback\r\n     */\r\n    function stat(path, callback) {\r\n        appshell.fs.stat(path, function (err, stats) {\r\n            if (err) {\r\n                callback(_mapError(err));\r\n            } else {\r\n                var options = {\r\n                    isFile: stats.isFile(),\r\n                    mtime: stats.mtime,\r\n                    size: stats.size,\r\n                    realPath: stats.realPath,\r\n                    hash: stats.mtime.getTime()\r\n                };\r\n\r\n                var fsStats = new FileSystemStats(options);\r\n\r\n                callback(null, fsStats);\r\n            }\r\n        });\r\n    }\r\n\r\n    /**\r\n     * Determine whether a file or directory exists at the given path by calling\r\n     * back asynchronously with either a FileSystemError string or a boolean,\r\n     * which is true if the file exists and false otherwise. The error will never\r\n     * be FileSystemError.NOT_FOUND; in that case, there will be no error and the\r\n     * boolean parameter will be false.\r\n     *\r\n     * @param {string} path\r\n     * @param {function(?string, boolean)} callback\r\n     */\r\n    function exists(path, callback) {\r\n        stat(path, function (err) {\r\n            if (err) {\r\n                if (err === FileSystemError.NOT_FOUND) {\r\n                    callback(null, false);\r\n                } else {\r\n                    callback(err);\r\n                }\r\n                return;\r\n            }\r\n\r\n            callback(null, true);\r\n        });\r\n    }\r\n\r\n    /**\r\n     * Read the contents of the directory at the given path, calling back\r\n     * asynchronously either with a FileSystemError string or an array of\r\n     * FileSystemEntry objects along with another consistent array, each index\r\n     * of which either contains a FileSystemStats object for the corresponding\r\n     * FileSystemEntry object in the second parameter or a FileSystemError\r\n     * string describing a stat error.\r\n     *\r\n     * @param {string} path\r\n     * @param {function(?string, Array.<FileSystemEntry>=, Array.<string|FileSystemStats>=)} callback\r\n     */\r\n    function readdir(path, callback) {\r\n        appshell.fs.readdir(path, function (err, contents) {\r\n            if (err) {\r\n                callback(_mapError(err));\r\n                return;\r\n            }\r\n\r\n            var count = contents.length;\r\n            if (!count) {\r\n                callback(null, [], []);\r\n                return;\r\n            }\r\n\r\n            var stats = [];\r\n            contents.forEach(function (val, idx) {\r\n                stat(path + "/" + val, function (err, stat) {\r\n                    stats[idx] = err || stat;\r\n                    count--;\r\n                    if (count <= 0) {\r\n                        callback(null, contents, stats);\r\n                    }\r\n                });\r\n            });\r\n        });\r\n    }\r\n\r\n    /**\r\n     * Create a directory at the given path, and call back asynchronously with\r\n     * either a FileSystemError string or a stats object for the newly created\r\n     * directory. The octal mode parameter is optional; if unspecified, the mode\r\n     * of the created directory is implementation dependent.\r\n     *\r\n     * @param {string} path\r\n     * @param {number=} mode The base-eight mode of the newly created directory.\r\n     * @param {function(?string, FileSystemStats=)=} callback\r\n     */\r\n    function mkdir(path, mode, callback) {\r\n        if (typeof mode === "function") {\r\n            callback = mode;\r\n            mode = parseInt("0755", 8);\r\n        }\r\n        appshell.fs.makedir(path, mode, function (err) {\r\n            if (err) {\r\n                callback(_mapError(err));\r\n            } else {\r\n                stat(path, function (err, stat) {\r\n                    callback(err, stat);\r\n                });\r\n            }\r\n        });\r\n    }\r\n\r\n    /**\r\n     * Rename the file or directory at oldPath to newPath, and call back\r\n     * asynchronously with a possibly null FileSystemError string.\r\n     *\r\n     * @param {string} oldPath\r\n     * @param {string} newPath\r\n     * @param {function(?string)=} callback\r\n     */\r\n    function rename(oldPath, newPath, callback) {\r\n        appshell.fs.rename(oldPath, newPath, _wrap(callback));\r\n    }\r\n\r\n    /**\r\n     * Read the contents of the file at the given path, calling back\r\n     * asynchronously with either a FileSystemError string, or with the data and\r\n     * the FileSystemStats object associated with the read file. The options\r\n     * parameter can be used to specify an encoding (default "utf8"), and also\r\n     * a cached stats object that the implementation is free to use in order\r\n     * to avoid an additional stat call.\r\n     *\r\n     * Note: if either the read or the stat call fails then neither the read data\r\n     * nor stat will be passed back, and the call should be considered to have failed.\r\n     * If both calls fail, the error from the read call is passed back.\r\n     *\r\n     * @param {string} path\r\n     * @param {{encoding: string=, stat: FileSystemStats=}} options\r\n     * @param {function(?string, string=, FileSystemStats=)} callback\r\n     */\r\n    function readFile(path, options, callback) {\r\n        var encoding = options.encoding || "utf8";\r\n\r\n        // callback to be executed when the call to stat completes\r\n        //  or immediately if a stat object was passed as an argument\r\n        function doReadFile(stat) {\r\n            if (stat.size > (FileUtils.MAX_FILE_SIZE)) {\r\n                callback(FileSystemError.EXCEEDS_MAX_FILE_SIZE);\r\n            } else {\r\n                appshell.fs.readFile(path, encoding, function (_err, _data, encoding, preserveBOM) {\r\n                    if (_err) {\r\n                        callback(_mapError(_err));\r\n                    } else {\r\n                        callback(null, _data, encoding, preserveBOM, stat);\r\n                    }\r\n                });\r\n            }\r\n        }\r\n\r\n        if (options.stat) {\r\n            doReadFile(options.stat);\r\n        } else {\r\n            exports.stat(path, function (_err, _stat) {\r\n                if (_err) {\r\n                    callback(_err);\r\n                } else {\r\n                    doReadFile(_stat);\r\n                }\r\n            });\r\n        }\r\n    }\r\n    /**\r\n     * Write data to the file at the given path, calling back asynchronously with\r\n     * either a FileSystemError string or the FileSystemStats object associated\r\n     * with the written file and a boolean that indicates whether the file was\r\n     * created by the write (true) or not (false). If no file exists at the\r\n     * given path, a new file will be created. The options parameter can be used\r\n     * to specify an encoding (default "utf8"), an octal mode (default\r\n     * unspecified and implementation dependent), and a consistency hash, which\r\n     * is used to the current state of the file before overwriting it. If a\r\n     * consistency hash is provided but does not match the hash of the file on\r\n     * disk, a FileSystemError.CONTENTS_MODIFIED error is passed to the callback.\r\n     *\r\n     * @param {string} path\r\n     * @param {string} data\r\n     * @param {{encoding : string=, mode : number=, expectedHash : object=, expectedContents : string=}} options\r\n     * @param {function(?string, FileSystemStats=, boolean)} callback\r\n     */\r\n    function writeFile(path, data, options, callback) {\r\n        var encoding = options.encoding || "utf8",\r\n            preserveBOM = options.preserveBOM;\r\n\r\n        function _finishWrite(created) {\r\n            appshell.fs.writeFile(path, data, encoding, preserveBOM, function (err) {\r\n                if (err) {\r\n                    callback(_mapError(err));\r\n                } else {\r\n                    stat(path, function (err, stat) {\r\n                        callback(err, stat, created);\r\n                    });\r\n                }\r\n            });\r\n        }\r\n\r\n        stat(path, function (err, stats) {\r\n            if (err) {\r\n                switch (err) {\r\n                case FileSystemError.NOT_FOUND:\r\n                    _finishWrite(true);\r\n                    break;\r\n                default:\r\n                    callback(err);\r\n                }\r\n                return;\r\n            }\r\n\r\n            if (options.hasOwnProperty("expectedHash") && options.expectedHash !== stats._hash) {\r\n                console.error("Blind write attempted: ", path, stats._hash, options.expectedHash);\r\n\r\n                if (options.hasOwnProperty("expectedContents")) {\r\n                    appshell.fs.readFile(path, encoding, function (_err, _data) {\r\n                        if (_err || _data !== options.expectedContents) {\r\n                            callback(FileSystemError.CONTENTS_MODIFIED);\r\n                            return;\r\n                        }\r\n\r\n                        _finishWrite(false);\r\n                    });\r\n                    return;\r\n                } else {\r\n                    callback(FileSystemError.CONTENTS_MODIFIED);\r\n                    return;\r\n                }\r\n            }\r\n\r\n            _finishWrite(false);\r\n        });\r\n    }\r\n\r\n    /**\r\n     * Unlink (i.e., permanently delete) the file or directory at the given path,\r\n     * calling back asynchronously with a possibly null FileSystemError string.\r\n     * Directories will be unlinked even when non-empty.\r\n     *\r\n     * @param {string} path\r\n     * @param {function(string)=} callback\r\n     */\r\n    function unlink(path, callback) {\r\n        appshell.fs.unlink(path, function (err) {\r\n            callback(_mapError(err));\r\n        });\r\n    }\r\n\r\n    /**\r\n     * Move the file or directory at the given path to a system dependent trash\r\n     * location, calling back asynchronously with a possibly null FileSystemError\r\n     * string. Directories will be moved even when non-empty.\r\n     *\r\n     * @param {string} path\r\n     * @param {function(string)=} callback\r\n     */\r\n    function moveToTrash(path, callback) {\r\n        appshell.fs.moveToTrash(path, function (err) {\r\n            callback(_mapError(err));\r\n        });\r\n    }\r\n\r\n    /**\r\n     * Initialize file watching for this filesystem, using the supplied\r\n     * changeCallback to provide change notifications. The first parameter of\r\n     * changeCallback specifies the changed path (either a file or a directory);\r\n     * if this parameter is null, it indicates that the implementation cannot\r\n     * specify a particular changed path, and so the callers should consider all\r\n     * paths to have changed and to update their state accordingly. The second\r\n     * parameter to changeCallback is an optional FileSystemStats object that\r\n     * may be provided in case the changed path already exists and stats are\r\n     * readily available. The offlineCallback will be called in case watchers\r\n     * are no longer expected to function properly. All watched paths are\r\n     * cleared when the offlineCallback is called.\r\n     *\r\n     * @param {function(?string, FileSystemStats=)} changeCallback\r\n     * @param {function()=} offlineCallback\r\n     */\r\n    function initWatchers(changeCallback, offlineCallback) {\r\n        _changeCallback = changeCallback;\r\n        _offlineCallback = offlineCallback;\r\n\r\n        if (_isRunningOnWindowsXP && _offlineCallback) {\r\n            _offlineCallback();\r\n        }\r\n    }\r\n\r\n    /**\r\n     * Start providing change notifications for the file or directory at the\r\n     * given path, calling back asynchronously with a possibly null FileSystemError\r\n     * string when the initialization is complete. Notifications are provided\r\n     * using the changeCallback function provided by the initWatchers method.\r\n     * Note that change notifications are only provided recursively for directories\r\n     * when the recursiveWatch property of this module is true.\r\n     *\r\n     * @param {string} path\r\n     * @param {Array<string>} ignored\r\n     * @param {function(?string)=} callback\r\n     */\r\n    function watchPath(path, ignored, callback) {\r\n        if (_isRunningOnWindowsXP) {\r\n            callback(FileSystemError.NOT_SUPPORTED);\r\n            return;\r\n        }\r\n        appshell.fs.isNetworkDrive(path, function (err, isNetworkDrive) {\r\n            if (err || isNetworkDrive) {\r\n                if (isNetworkDrive) {\r\n                    callback(FileSystemError.NETWORK_DRIVE_NOT_SUPPORTED);\r\n                } else {\r\n                    callback(FileSystemError.UNKNOWN);\r\n                }\r\n                return;\r\n            }\r\n            _nodeDomain.exec("watchPath", path, ignored)\r\n                .then(callback, callback);\r\n        });\r\n    }\r\n    /**\r\n     * Stop providing change notifications for the file or directory at the\r\n     * given path, calling back asynchronously with a possibly null FileSystemError\r\n     * string when the operation is complete.\r\n     * This function needs to mirror the signature of watchPath\r\n     * because of FileSystem.prototype._watchOrUnwatchEntry implementation.\r\n     *\r\n     * @param {string} path\r\n     * @param {Array<string>} ignored\r\n     * @param {function(?string)=} callback\r\n     */\r\n    function unwatchPath(path, ignored, callback) {\r\n        _nodeDomain.exec("unwatchPath", path)\r\n            .then(callback, callback);\r\n    }\r\n\r\n    /**\r\n     * Stop providing change notifications for all previously watched files and\r\n     * directories, optionally calling back asynchronously with a possibly null\r\n     * FileSystemError string when the operation is complete.\r\n     *\r\n     * @param {function(?string)=} callback\r\n     */\r\n    function unwatchAll(callback) {\r\n        _nodeDomain.exec("unwatchAll")\r\n            .then(callback, callback);\r\n    }\r\n\r\n\r\n    // Export public API\r\n    exports.showOpenDialog  = showOpenDialog;\r\n    exports.showSaveDialog  = showSaveDialog;\r\n    exports.exists          = exists;\r\n    exports.readdir         = readdir;\r\n    exports.mkdir           = mkdir;\r\n    exports.rename          = rename;\r\n    exports.stat            = stat;\r\n    exports.readFile        = readFile;\r\n    exports.writeFile       = writeFile;\r\n    exports.unlink          = unlink;\r\n    exports.moveToTrash     = moveToTrash;\r\n    exports.initWatchers    = initWatchers;\r\n    exports.watchPath       = watchPath;\r\n    exports.unwatchPath     = unwatchPath;\r\n    exports.unwatchAll      = unwatchAll;\r\n\r\n    /**\r\n     * Indicates whether or not recursive watching notifications are supported\r\n     * by the watchPath call.\r\n     *\r\n     * @type {boolean}\r\n     */\r\n    exports.recursiveWatch = true;\r\n\r\n    /**\r\n     * Indicates whether or not the filesystem should expect and normalize UNC\r\n     * paths. If set, then //server/directory/ is a normalized path; otherwise the\r\n     * filesystem will normalize it to /server/directory. Currently, UNC path\r\n     * normalization only occurs on Windows.\r\n     *\r\n     * @type {boolean}\r\n     */\r\n    exports.normalizeUNCPaths = appshell.platform === "win";\r\n});\r\n\n//# sourceURL=/filesystem/impls/appshell/AppshellFileSystem.js'),
eval('/*\r\n * Copyright (c) 2013 - present Adobe Systems Incorporated. All rights reserved.\r\n *\r\n * Permission is hereby granted, free of charge, to any person obtaining a\r\n * copy of this software and associated documentation files (the "Software"),\r\n * to deal in the Software without restriction, including without limitation\r\n * the rights to use, copy, modify, merge, publish, distribute, sublicense,\r\n * and/or sell copies of the Software, and to permit persons to whom the\r\n * Software is furnished to do so, subject to the following conditions:\r\n *\r\n * The above copyright notice and this permission notice shall be included in\r\n * all copies or substantial portions of the Software.\r\n *\r\n * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING\r\n * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER\r\n * DEALINGS IN THE SOFTWARE.\r\n *\r\n */\r\n\r\n/**\r\n * FileSystem is a model object representing a complete file system. This object creates\r\n * and manages File and Directory instances, dispatches events when the file system changes,\r\n * and provides methods for showing \'open\' and \'save\' dialogs.\r\n *\r\n * FileSystem automatically initializes when loaded. It depends on a pluggable "impl" layer, which\r\n * it loads itself but must be designated in the require.config() that loads FileSystem. For details\r\n * see: https://github.com/adobe/brackets/wiki/File-System-Implementations\r\n *\r\n * There are three ways to get File or Directory instances:\r\n *    * Use FileSystem.resolve() to convert a path to a File/Directory object. This will only\r\n *      succeed if the file/directory already exists.\r\n *    * Use FileSystem.getFileForPath()/FileSystem.getDirectoryForPath() if you know the\r\n *      file/directory already exists, or if you want to create a new entry.\r\n *    * Use Directory.getContents() to return all entries for the specified Directory.\r\n *\r\n * All paths passed *to* FileSystem APIs must be in the following format:\r\n *    * The path separator is "/" regardless of platform\r\n *    * Paths begin with "/" on Mac/Linux and "c:/" (or some other drive letter) on Windows\r\n *\r\n * All paths returned *from* FileSystem APIs additionally meet the following guarantees:\r\n *    * No ".." segments\r\n *    * No consecutive "/"s\r\n *    * Paths to a directory always end with a trailing "/"\r\n * (Because FileSystem normalizes paths automatically, paths passed *to* FileSystem do not need\r\n * to meet these requirements)\r\n *\r\n * FileSystem dispatches the following events:\r\n * (NOTE: attach to these events via `FileSystem.on()` - not `$(FileSystem).on()`)\r\n *\r\n * __change__ - Sent whenever there is a change in the file system. The handler\r\n *   is passed up to three arguments: the changed entry and, if that changed entry\r\n *   is a Directory, a list of entries added to the directory and a list of entries\r\n *   removed from the Directory. The entry argument can be:\r\n *   *  a File - the contents of the file have changed, and should be reloaded.\r\n *   *  a Directory - an immediate child of the directory has been added, removed,\r\n *      or renamed/moved. Not triggered for "grandchildren".\r\n *      - If the added & removed arguments are null, we don\'t know what was added/removed:\r\n *        clients should assume the whole subtree may have changed.\r\n *      - If the added & removed arguments are 0-length, there\'s no net change in the set\r\n *        of files but a file may have been replaced: clients should assume the contents\r\n *        of any immediate child file may have changed.\r\n *   *  null - a \'wholesale\' change happened, and you should assume everything may\r\n *      have changed.\r\n *   For changes made externally, there may be a significant delay before a "change" event\r\n *   is dispatched.\r\n *\r\n * __rename__ - Sent whenever a File or Directory is renamed. All affected File and Directory\r\n *   objects have been updated to reflect the new path by the time this event is dispatched.\r\n *   This event should be used to trigger any UI updates that may need to occur when a path\r\n *   has changed. Note that these events will only be sent for rename operations that happen\r\n *   within the filesystem. If a file is renamed externally, a change event on the parent\r\n *   directory will be sent instead.\r\n *\r\n * FileSystem may perform caching. But it guarantees:\r\n *    * File contents & metadata - reads are guaranteed to be up to date (cached data is not used\r\n *      without first veryifying it is up to date).\r\n *    * Directory structure / file listing - reads may return cached data immediately, which may not\r\n *      reflect external changes made recently. (However, changes made via FileSystem itself are always\r\n *      reflected immediately, as soon as the change operation\'s callback signals success).\r\n *\r\n * The FileSystem doesn\'t directly read or write contents--this work is done by a low-level\r\n * implementation object. This allows client code to use the FileSystem API without having to\r\n * worry about the underlying storage, which could be a local filesystem or a remote server.\r\n */\r\ndefine(\'filesystem/FileSystem\',[\'require\',\'exports\',\'module\',\'filesystem/Directory\',\'filesystem/File\',\'filesystem/FileIndex\',\'filesystem/FileSystemError\',\'filesystem/WatchedRoot\',\'utils/EventDispatcher\',\'fileSystemImpl\'],function (require, exports, module) {\r\n    "use strict";\r\n\r\n    var Directory       = require("filesystem/Directory"),\r\n        File            = require("filesystem/File"),\r\n        FileIndex       = require("filesystem/FileIndex"),\r\n        FileSystemError = require("filesystem/FileSystemError"),\r\n        WatchedRoot     = require("filesystem/WatchedRoot"),\r\n        EventDispatcher = require("utils/EventDispatcher");\r\n\r\n    /**\r\n     * The FileSystem is not usable until init() signals its callback.\r\n     * @constructor\r\n     */\r\n    function FileSystem() {\r\n        // Create a file index\r\n        this._index = new FileIndex();\r\n\r\n        // Initialize the set of watched roots\r\n        this._watchedRoots = {};\r\n\r\n        // Initialize the watch/unwatch request queue\r\n        this._watchRequests = [];\r\n\r\n        // Initialize the queue of pending external changes\r\n        this._externalChanges = [];\r\n    }\r\n    EventDispatcher.makeEventDispatcher(FileSystem.prototype);\r\n\r\n    /**\r\n     * The low-level file system implementation used by this object.\r\n     * This is set in the init() function and cannot be changed.\r\n     */\r\n    FileSystem.prototype._impl = null;\r\n\r\n    /**\r\n     * The FileIndex used by this object. This is initialized in the constructor.\r\n     */\r\n    FileSystem.prototype._index = null;\r\n\r\n    /**\r\n     * Refcount of any pending filesystem mutation operations (e.g., writes,\r\n     * unlinks, etc.). Used to ensure that external change events aren\'t processed\r\n     * until after index fixups, operation-specific callbacks, and internal change\r\n     * events are complete. (This is important for distinguishing rename from\r\n     * an unrelated delete-add pair).\r\n     * @type {number}\r\n     */\r\n    FileSystem.prototype._activeChangeCount = 0;\r\n\r\n    // For unit testing only\r\n    FileSystem.prototype._getActiveChangeCount = function () {\r\n        return this._activeChangeCount;\r\n    };\r\n\r\n    /**\r\n     * Queue of arguments with which to invoke _handleExternalChanges(); triggered\r\n     * once _activeChangeCount drops to zero.\r\n     * @type {!Array.<{path:?string, stat:FileSystemStats=}>}\r\n     */\r\n    FileSystem.prototype._externalChanges = null;\r\n\r\n    /** Process all queued watcher results, by calling _handleExternalChange() on each */\r\n    FileSystem.prototype._triggerExternalChangesNow = function () {\r\n        this._externalChanges.forEach(function (info) {\r\n            this._handleExternalChange(info.path, info.stat);\r\n        }, this);\r\n        this._externalChanges.length = 0;\r\n    };\r\n\r\n    /**\r\n     * Receives a result from the impl\'s watcher callback, and either processes it\r\n     * immediately (if _activeChangeCount is 0) or otherwise stores it for later\r\n     * processing.\r\n     * @param {?string} path The fullPath of the changed entry\r\n     * @param {FileSystemStats=} stat An optional stat object for the changed entry\r\n     */\r\n    FileSystem.prototype._enqueueExternalChange = function (path, stat) {\r\n        this._externalChanges.push({path: path, stat: stat});\r\n        if (!this._activeChangeCount) {\r\n            this._triggerExternalChangesNow();\r\n        }\r\n    };\r\n\r\n\r\n    /**\r\n     * The queue of pending watch/unwatch requests.\r\n     * @type {Array.<{fn: function(), cb: function()}>}\r\n     */\r\n    FileSystem.prototype._watchRequests = null;\r\n\r\n    /**\r\n     * Dequeue and process all pending watch/unwatch requests\r\n     */\r\n    FileSystem.prototype._dequeueWatchRequest = function () {\r\n        if (this._watchRequests.length > 0) {\r\n            var request = this._watchRequests[0];\r\n\r\n            request.fn.call(null, function () {\r\n                // Apply the given callback\r\n                var callbackArgs = arguments;\r\n                try {\r\n                    request.cb.apply(null, callbackArgs);\r\n                } finally {\r\n                    // Process the remaining watch/unwatch requests\r\n                    this._watchRequests.shift();\r\n                    this._dequeueWatchRequest();\r\n                }\r\n            }.bind(this));\r\n        }\r\n    };\r\n\r\n    /**\r\n     * Enqueue a new watch/unwatch request.\r\n     *\r\n     * @param {function()} fn - The watch/unwatch request function.\r\n     * @param {callback()} cb - The callback for the provided watch/unwatch\r\n     *      request function.\r\n     */\r\n    FileSystem.prototype._enqueueWatchRequest = function (fn, cb) {\r\n        // Enqueue the given watch/unwatch request\r\n        this._watchRequests.push({fn: fn, cb: cb});\r\n\r\n        // Begin processing the queue if it is not already being processed\r\n        if (this._watchRequests.length === 1) {\r\n            this._dequeueWatchRequest();\r\n        }\r\n    };\r\n\r\n    /**\r\n     * The set of watched roots, encoded as a mapping from full paths to WatchedRoot\r\n     * objects which contain a file entry, filter function, and an indication of\r\n     * whether the watched root is inactive, starting up or fully active.\r\n     *\r\n     * @type {Object.<string, WatchedRoot>}\r\n     */\r\n    FileSystem.prototype._watchedRoots = null;\r\n\r\n    /**\r\n     * Finds a parent watched root for a given path, or returns null if a parent\r\n     * watched root does not exist.\r\n     *\r\n     * @param {string} fullPath The child path for which a parent watched root is to be found\r\n     * @return {?{entry: FileSystemEntry, filter: function(string) boolean}} The parent\r\n     *      watched root, if it exists, or null.\r\n     */\r\n    FileSystem.prototype._findWatchedRootForPath = function (fullPath) {\r\n        var watchedRoot = null;\r\n\r\n        Object.keys(this._watchedRoots).some(function (watchedPath) {\r\n            if (fullPath.indexOf(watchedPath) === 0) {\r\n                watchedRoot = this._watchedRoots[watchedPath];\r\n                return true;\r\n            }\r\n        }, this);\r\n\r\n        return watchedRoot;\r\n    };\r\n\r\n    /**\r\n     * Helper function to watch or unwatch a filesystem entry beneath a given\r\n     * watchedRoot.\r\n     *\r\n     * @private\r\n     * @param {FileSystemEntry} entry - The FileSystemEntry to watch. Must be a\r\n     *      non-strict descendent of watchedRoot.entry.\r\n     * @param {WatchedRoot} watchedRoot - See FileSystem._watchedRoots.\r\n     * @param {function(?string)} callback - A function that is called once the\r\n     *      watch is complete, possibly with a FileSystemError string.\r\n     * @param {boolean} shouldWatch - Whether the entry should be watched (true)\r\n     *      or unwatched (false).\r\n     */\r\n    FileSystem.prototype._watchOrUnwatchEntry = function (entry, watchedRoot, callback, shouldWatch) {\r\n        var impl = this._impl,\r\n            recursiveWatch = impl.recursiveWatch,\r\n            commandName = shouldWatch ? "watchPath" : "unwatchPath",\r\n            filterGlobs = watchedRoot.filterGlobs;\r\n\r\n        if (recursiveWatch) {\r\n            // The impl can watch the entire subtree with one call on the root (we also fall into this case for\r\n            // unwatch, although that never requires us to do the recursion - see similar final case below)\r\n            if (entry !== watchedRoot.entry) {\r\n                // Watch and unwatch calls to children of the watched root are\r\n                // no-ops if the impl supports recursiveWatch\r\n                callback(null);\r\n            } else {\r\n                // The impl will handle finding all subdirectories to watch.\r\n                this._enqueueWatchRequest(function (requestCb) {\r\n                    impl[commandName].call(impl, entry.fullPath, filterGlobs, requestCb);\r\n                }.bind(this), callback);\r\n            }\r\n        } else if (shouldWatch) {\r\n            // The impl can\'t handle recursive watch requests, so it\'s up to the\r\n            // filesystem to recursively watch all subdirectories.\r\n            this._enqueueWatchRequest(function (requestCb) {\r\n                // First construct a list of entries to watch or unwatch\r\n                var entriesToWatch = [];\r\n\r\n                var visitor = function (child) {\r\n                    if (watchedRoot.filter(child.name, child.parentPath)) {\r\n                        if (child.isDirectory || child === watchedRoot.entry) {\r\n                            entriesToWatch.push(child);\r\n                        }\r\n                        return true;\r\n                    }\r\n                    return false;\r\n                };\r\n\r\n                entry.visit(visitor, function (err) {\r\n                    if (err) {\r\n                        // Unexpected error\r\n                        requestCb(err);\r\n                        return;\r\n                    }\r\n\r\n                    // Then watch or unwatched all these entries\r\n                    var count = entriesToWatch.length;\r\n                    if (count === 0) {\r\n                        requestCb(null);\r\n                        return;\r\n                    }\r\n\r\n                    var watchCallback = function () {\r\n                        if (--count === 0) {\r\n                            requestCb(null);\r\n                        }\r\n                    };\r\n\r\n                    entriesToWatch.forEach(function (entry) {\r\n                        impl.watchPath(entry.fullPath, filterGlobs, watchCallback);\r\n                    });\r\n                });\r\n            }, callback);\r\n        } else {\r\n            // Unwatching never requires enumerating the subfolders (which is good, since after a\r\n            // delete/rename we may be unable to do so anyway)\r\n            this._enqueueWatchRequest(function (requestCb) {\r\n                impl.unwatchPath(entry.fullPath, requestCb);\r\n            }, callback);\r\n        }\r\n    };\r\n\r\n    /**\r\n     * Watch a filesystem entry beneath a given watchedRoot.\r\n     *\r\n     * @private\r\n     * @param {FileSystemEntry} entry - The FileSystemEntry to watch. Must be a\r\n     *      non-strict descendent of watchedRoot.entry.\r\n     * @param {WatchedRoot} watchedRoot - See FileSystem._watchedRoots.\r\n     * @param {function(?string)} callback - A function that is called once the\r\n     *      watch is complete, possibly with a FileSystemError string.\r\n     */\r\n    FileSystem.prototype._watchEntry = function (entry, watchedRoot, callback) {\r\n        this._watchOrUnwatchEntry(entry, watchedRoot, callback, true);\r\n    };\r\n\r\n    /**\r\n     * Unwatch a filesystem entry beneath a given watchedRoot.\r\n     *\r\n     * @private\r\n     * @param {FileSystemEntry} entry - The FileSystemEntry to watch. Must be a\r\n     *      non-strict descendent of watchedRoot.entry.\r\n     * @param {WatchedRoot} watchedRoot - See FileSystem._watchedRoots.\r\n     * @param {function(?string)} callback - A function that is called once the\r\n     *      watch is complete, possibly with a FileSystemError string.\r\n     */\r\n    FileSystem.prototype._unwatchEntry = function (entry, watchedRoot, callback) {\r\n        this._watchOrUnwatchEntry(entry, watchedRoot, function (err) {\r\n            // Make sure to clear cached data for all unwatched entries because\r\n            // entries always return cached data if it exists!\r\n            this._index.visitAll(function (child) {\r\n                if (child.fullPath.indexOf(entry.fullPath) === 0) {\r\n                    // \'true\' so entry doesn\'t try to clear its immediate childrens\' caches too. That would be redundant\r\n                    // with the visitAll() here, and could be slow if we\'ve already cleared its parent (#7150).\r\n                    child._clearCachedData(true);\r\n                }\r\n            }.bind(this));\r\n\r\n            callback(err);\r\n        }.bind(this), false);\r\n    };\r\n\r\n    /**\r\n     * Initialize this FileSystem instance.\r\n     *\r\n     * @param {FileSystemImpl} impl The back-end implementation for this\r\n     *      FileSystem instance.\r\n     */\r\n    FileSystem.prototype.init = function (impl) {\r\n        console.assert(!this._impl, "This FileSystem has already been initialized!");\r\n\r\n        var changeCallback = this._enqueueExternalChange.bind(this),\r\n            offlineCallback = this._unwatchAll.bind(this);\r\n\r\n        this._impl = impl;\r\n        this._impl.initWatchers(changeCallback, offlineCallback);\r\n    };\r\n\r\n    /**\r\n     * Close a file system. Clear all caches, indexes, and file watchers.\r\n     */\r\n    FileSystem.prototype.close = function () {\r\n        this._impl.unwatchAll();\r\n        this._index.clear();\r\n    };\r\n\r\n    /**\r\n     * Returns true if the given path should be automatically added to the index & watch list when one of its ancestors\r\n     * is a watch-root. (Files are added automatically when the watch-root is first established, or later when a new\r\n     * directory is created and its children enumerated).\r\n     *\r\n     * Entries explicitly created via FileSystem.getFile/DirectoryForPath() are *always* added to the index regardless\r\n     * of this filtering - but they will not be watched if the watch-root\'s filter excludes them.\r\n     *\r\n     * @param {string} path Full path\r\n     * @param {string} name Name portion of the path\r\n     */\r\n    FileSystem.prototype._indexFilter = function (path, name) {\r\n        var parentRoot = this._findWatchedRootForPath(path);\r\n\r\n        if (parentRoot) {\r\n            return parentRoot.filter(name, path);\r\n        }\r\n\r\n        // It might seem more sensible to return false (exclude) for files outside the watch roots, but\r\n        // that would break usage of appFileSystem for \'system\'-level things like enumerating extensions.\r\n        // (Or in general, Directory.getContents() for any Directory outside the watch roots).\r\n        return true;\r\n    };\r\n\r\n    /**\r\n     * Indicates that a filesystem-mutating operation has begun. As long as there\r\n     * are changes taking place, change events from the external watchers are\r\n     * blocked and queued, to be handled once changes have fin